---
layout: mark
title: Shape Mark
permalink: /docs/marks/shape/index.html
---

**Shape** marks are arbitrary shapes whose geometry is determined at _render_ time. Whereas [path](../path) marks require SVG path strings, shape marks instead require a shape instance with a drawing function that is later invoked upon render. Canvas rendering with shape marks can improve performance, as no intermediate representation (such as an SVG path string) needs to be parsed.

The primary use case for shape marks is drawing dynamic maps, using the shape instance provided by the [geoshape](../../transforms/geoshape) transform.

## Type-Specific Mark Properties

| Property            | Type   | Description   |
| :------------------ | :----: | :------------ |
| shape               | Shape  | An shape instance that provides a drawing method to invoke within the renderer. Shape instances can not be specified directly, they must be generated by a data transform such as [geoshape](../../transforms/geoshape). |

{% include properties.md %}
