/*
 * ============
 * VDK Builder
 * Version 1.2
 * Revision 4
 * October 2000
 * ============
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
#if ENABLE_NLS
#include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
#else
#define _(str) str
#define N_(str) str 
#endif
#endif
#include <vdkb2/vdkb_edhelp.h>
#include <ctype.h>

static struct
{ 
  char *key,*action; 
} helps[] =  
{
{ N_("COPY, CUT & PASTE"),"" },
{ N_("<ctlr-c>,<ctrl-ins>"),N_("copy selection" )},
{ N_("<ctlr-x>,<shift-canc>"),N_("cut selection") },
{ N_("<ctlr-v>,<shift-ins>"),N_("paste selection") },
{ N_("MOVEMENTS"),"" },
{ N_("<up>,<down>"),N_("self explanatory") },
{ N_("<left>,<right>"),N_("self explanatory") },
{ N_("<shift+left>"),N_("previous word") },
{ N_("<shift+right>"),N_("next word") },
{ N_("SELECTION"),"" },
{ N_("<shift+movements>"),N_("select and move") },
{ N_("INDENTING"),"" },
{ N_("<tab>"),N_("indent") },
{ N_("<shift-tab>"),N_("normal tab") },
{ N_("OTHERS"),"" },
{ N_("<ctrl-tab>"),N_("word completion") },
{ N_("<ctrl-q>"),N_("hints") },
{ N_("<ctrl-p>"),N_("parenthesis matching") },
{ NULL,NULL }
};

/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(Vdkb_edhelpForm,VDKForm)
  ON_SIGNAL(close,clicked_signal,OncloseClick),
  ON_SIGNAL(helpList,realize_signal,OnhelpListRealize)
END_SIGNAL_MAP

// Vdkb_edhelp MAIN FORM  CLASS
/*
main form constructor
*/
Vdkb_edhelpForm::Vdkb_edhelpForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
  color = NULL;
}

/*
main form destructor
*/
Vdkb_edhelpForm::~Vdkb_edhelpForm()
{
}


/*
main form gui setup
*/
void
Vdkb_edhelpForm::GUISetup(void)
{
  SetSize(330,300);
  Title = _("VDKBuilder editor short cuts");
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);
  vbox2 = new VDKBox(this,v_box);
  vbox2->SetSize(282,267);
  vbox1->Add(vbox2,0,1,1,0);
  vbox2->BorderWidth(0);
  char* helpListTitles[] = { N_("Keys"),N_("Actions") };
  helpList = new VDKCustomList(this,2,helpListTitles,(GtkSelectionMode) 0);
  helpList->SetSize(100,100);
  helpList->AutoResize = true;
  helpList->BorderShadow = (GtkShadowType) shadow_in;
  vbox2->Add(helpList,0,1,1,0);
  hbox3 = new VDKBox(this,h_box);
  hbox3->SetSize(282,30);
  vbox1->Add(hbox3,0,1,1,0);
  hbox3->BorderWidth(0);
  close = new VDKCustomButton(this,_("Close"));
  hbox3->Add(close,0,1,0,0);
}

/*
main form setup
*/
void
Vdkb_edhelpForm::Setup(void)
{
  GUISetup();
  // color = new VDKColor(this,clIvory);
}

//signal response method
bool
Vdkb_edhelpForm::OnhelpListRealize(VDKObject* sender)
{
  int t = 0;
  for(; helps[t].key;t++)
    {
      char* keys[2];
      keys[0] = _(helps[t].key);
      if(isupper(keys[0][0]))
	  keys[1] = helps[t].action;
      else
	  keys[1] = _(helps[t].action);
      helpList->AddRow(keys);
    }
  return true;
}

//signal response method
bool
Vdkb_edhelpForm::OncloseClick(VDKObject* sender)
{
  Close();
  return true;
}
