/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_interface_h
#define _vdkb_interface_h
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>

/*
abstract class for common interfaces
subclasses must override
pure virtual functions.
*/
class VDKBAbstractComponentInterface
{
public:
 virtual char* CreateSource(char* buffer,
			    VDKBParser& parser) = 0;
 virtual bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,
			   VDKBParser& parser) = 0;
 virtual int MakeWidget(VDKBGuiForm* owner, 
			GdkEvent* ev) = 0;
 virtual const char **Icon() { return (const char**) NULL; }
 virtual const char* Tip() { return (const char*) NULL; }
 virtual const char* VDKName() { return "VDKObject"; }
};

#endif

