#
# Generate token_names.h from token_enum.h
#
# This script is meant to be executed with `cmake -P` from a custom command,
# and expects the variables `src_file` and `dst_file` to be set.
#

function(generate_token_names src_file dst_file)
  set(tokens "")

  file(READ "${src_file}" token_lines)
  string(REGEX REPLACE ";|\\[|\\]" " " token_lines "${token_lines}")
  string(REPLACE "\n" ";" token_lines "${token_lines}")

  foreach(token_line ${token_lines})
    if(${token_line} MATCHES "^[ \t]*CT_([A-Z0-9_]+),.*$")
      list(APPEND tokens "   \"${CMAKE_MATCH_1}\",\n")
    endif()
  endforeach()

  file(WRITE "${dst_file}"
    "/*\n"
    " * Generated by CMake\n"
    " */\n"
    "#ifndef TOKEN_NAMES_H_INCLUDED\n"
    "#define TOKEN_NAMES_H_INCLUDED\n"
    "\n"
    "const char *token_names[] =\n"
    "{\n"
    ${tokens}
    "};\n"
    "\n"
    "#endif /* TOKEN_NAMES_H_INCLUDED */\n"
  )
endfunction()

generate_token_names("${src_file}" "${dst_file}")
