/*
    This file is part of KDevelop PHP support
    SPDX-FileCopyrightText: 2012 Miha Čančula <miha@noughmad.eu>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef PHPUNITRUNJOB_H
#define PHPUNITRUNJOB_H

#include <QProcess>

#include <outputview/outputjob.h>
#include <interfaces/itestsuite.h>
#include <interfaces/itestcontroller.h>

class PhpUnitTestSuite;
class KProcess;

class PhpUnitRunJob : public KJob
{
    Q_OBJECT
public:
    PhpUnitRunJob(PhpUnitTestSuite* suite, const QStringList& cases, KDevelop::OutputJob::OutputJobVerbosity verbosity, QObject* parent = 0);
    virtual void start();

protected:
    virtual bool doKill();

private slots:
    void processFinished(KJob* job);
    void rowsInserted(const QModelIndex &parent, int startRow, int endRow);

private:
    KProcess* m_process;
    PhpUnitTestSuite* m_suite;
    QStringList m_cases;
    KDevelop::TestResult m_result;
    KJob* m_job;
    KDevelop::OutputJob* m_outputJob;
    KDevelop::OutputJob::OutputJobVerbosity m_verbosity;
};

#endif // PHPUNITRUNJOB_H
