/* BEGIN_COMMON_COPYRIGHT_HEADER
 * 
 * Copyright: 2023, KylinSoft Co., Ltd.
 * Copyright: 2012 Razor team
 * 
 * Authors:
 *   Christian Surlykke <christian@surlykke.dk>
 *
 * This program or library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * END_COMMON_COPYRIGHT_HEADER */
#ifndef IDLEWATCHER_H
#define IDLEWATCHER_H

#include <QObject>
#include <QDBusInterface>
#include <QList>

//class ScreenSaver;

class IdleWatcher : public QObject
{
    Q_OBJECT
public:
    explicit IdleWatcher(int idle, QObject *parent = nullptr);
    virtual ~IdleWatcher();

    void reset(int idle);

private:
    bool isWemeetappRunning();

private slots:
    void resumingFromIdle();
    void timeoutReached(int identifier, int timeout);
    void setup();
    void weakupFromSleep(bool a);

Q_SIGNALS:
    void StatusChanged(uint status);

public:
    QDBusInterface *interface;

private:
    int mSecsidle = 1 * 60;
    QList<QVariant> args;
};

#endif // IDLEWATCHER_H
