/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#include "upm_powerchanged.h"

UpmPowerChanged::UpmPowerChanged(QObject *parent) : QObject(parent)
{
    connect(UpmUpowerDBus::self(), &UpmUpowerDBus::acOnlineStateChanged,
            this, &UpmPowerChanged::dealAcOnlineStateChanged);
}

void UpmPowerChanged::dealAcOnlineStateChanged(int acIndex, bool acOnline)
{
    qDebug() << "ac index:" << acIndex << "ac online state :" << acOnline;
    if (true == UpmUpowerDBus::self()->getAcOnlineState()) {
        setPowerModePolicy();
//        UpmCommonDBus::self()->playSystemSound(POWER_PLUG);
    } else {
        setBatteryModePolicy();
    }
}

void UpmPowerChanged::setPowerModePolicy()
{
    QVariant value;
    if (true == UpmGsettings::self()->getGsettingsConfig(GSETTINGS_KEY_POWER_POLICY_AC, value)) {
        UpmControlDBus::self()->controlPowerManagement(UPM_DBUS_METHOD_SET_PC_POLICY, value.toInt());
    }
}

void UpmPowerChanged::setBatteryModePolicy()
{
    QVariant value;
    int percentageLow = 0;
    bool lowBatteryAutoSave = false;
    double currentPercent = UpmUpowerDBus::self()->getBatteryPercentage();

    if (true == UpmGsettings::self()->getGsettingsConfig(GSETTINGS_KEY_LOW_BATTERY_AUTO_SAVE, value)) {
        lowBatteryAutoSave = value.toBool();
    }

    if (true == UpmGsettings::self()->getGsettingsConfig(GSETTINGS_KEY_PERCENTAGE_LOW, value)) {
        percentageLow = value.toInt();
    }

    if (percentageLow > currentPercent && true == lowBatteryAutoSave) {
        qDebug() << "power low and auto save";
    } else {
        if (true == UpmGsettings::self()->getGsettingsConfig(GSETTINGS_KEY_POWER_POLICY_BATTERY, value)) {
            UpmControlDBus::self()->controlPowerManagement(UPM_DBUS_METHOD_SET_PC_POLICY, value.toInt());
        }
    }
}
