# -*- coding: utf-8 -*-
#
# Copyright 2011-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""Tests for the EnhancedCheckBox widget."""

from PyQt4 import QtGui, QtCore

from ubuntu_sso.qt import enhanced_check_box
from ubuntu_sso.qt.tests import BaseTestCase


class EnhancedCheckBoxTestCase(BaseTestCase):
    """Test the EnhancedCheckBox code."""

    def test_init(self):
        """Check the initial state of EnhancedCheckBox."""
        check = enhanced_check_box.EnhancedCheckBox("text")
        self.assertEqual(check.text(), "text")
        self.assertTrue(check.text_label.openExternalLinks())
        self.assertEqual(check.receivers(
            QtCore.SIGNAL('stateChanged(int)')), 1)

    def test_set_text(self):
        """Check if override setText and text methods works properly."""
        check = enhanced_check_box.EnhancedCheckBox()
        self.assertEqual(check.text_label.text(), "")
        check.setText("text")
        self.assertEqual(check.text(), "text")
        self.assertEqual(check.text(), check.text_label.text())

    def test_enhanced_check_size_adjust_with_small_height(self):
        """Check if the size of the EnhancedCheckBox is adjusted correctly."""
        text = 't' * 200
        height = 10
        widget = QtGui.QWidget()
        widget.setFixedSize(200, height)
        check = enhanced_check_box.EnhancedCheckBox(text, widget)
        self.assertTrue(check.height() > height)

    def test_enhanced_check_size_adjust_with_big_height(self):
        """Check if the size of the EnhancedCheckBox is adjusted correctly."""
        text = 't' * 20
        height = 200
        widget = QtGui.QWidget()
        widget.setFixedSize(200, height)
        check = enhanced_check_box.EnhancedCheckBox(text, widget)
        self.assertTrue(check.height() < height)
