import QtQuick 2.0
import QtTest 1.0
import Ubuntu.Components 0.1
import "../../../qml"
import "unit_test.js" as UT

// See more details @ http://qt-project.org/doc/qt-5.0/qtquick/qml-testcase.html

// Execute tests with:
//   qmltestrunner

Item {

    UbuntuPurchase {
        id: ubuntuPurchase
    }

    QtObject {
        id: requestPage
        property string url: "http://canonical.com";
        property var action
    }

    QtObject {
        id: requestFail
        property var url: "purchase://failed/?var=value&package_name=com.canonical.app";
        property var action
    }

    TestCase {
        name: "UbuntuPurchase"
        when: windowShown

        function cleanup() {

        }

        function test_components_visible() {
            tryCompare(ubuntuPurchase, "visible", true);
            var webView = UT.findChild(ubuntuPurchase, "webView");
            tryCompare(webView, "visible", true);
        }
    }
}
