// @HEADER
// *****************************************************************************
//            NOX: An Object-Oriented Nonlinear Solver Package
//
// Copyright 2002 NTESS and the NOX contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

// Finite Difference Problem Class
/* Description HERE
 */

#ifndef _NOX_PETSC_EXAMPLE_1D_FD
#define _NOX_PETSC_EXAMPLE_1D_FD

#include "petscsnes.h"
#include "petscdmda.h"

/*
   User-defined application context
*/
typedef struct {
   DM        da;     /* distributed array */
   int       rank;   /* rank of processor */
   int       size;   /* size of communicator */
   PetscReal h;      /* mesh spacing */
} ApplicationCtx;

// Flag to tell the evaluate routine what objects to fill
enum FillType {RHS_ONLY, MATRIX_ONLY, ALL};

// Finite Element Problem Class
class FiniteDifference {

public:

  // Constructor
  FiniteDifference(SNES* snes, void* ctx = NULL);

  // Destructor
  ~FiniteDifference();

  // Evaluates the function (RHS) and/or the Jacobian using the solution
  // values in solnVector.
  bool evaluate(FillType f, const Vec *solnVector,
        Vec *rhsVector, Mat *matrix);

  // Return a reference to the Vec with the Jacobian
  // that is generated by this class.
  Mat& getJacobian();

private:

  void *ctx;   // user-defined context optionally used in fill
  SNES *snes;  // A nonlinear solver object needed to respect fill interfaces
  MatStructure matStruct;

  FillType flag;
  Vec *initialSolution;
  Vec *overlapSolution;
  Vec *soln;
  Vec *rhs;
  Mat *A;
  VecScatter* petscMap;

  int MyPID;              // Process number
  int NumProc;            // Total number of processes
  int NumMyElements;      // Number of elements owned by this process
  int NumGlobalElements;  // Total Number of elements

};
#endif
