'\"
'\" Generated from file 'ipager\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "term::interact::pager" n 0\&.1 tcllib "Terminal control"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
term::interact::pager \- Terminal widget, paging
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBterm::interact::pager  ?0\&.1?\fR
.sp
\fBterm::interact::pager\fR \fIobject\fR \fItext\fR ?\fIoptions\fR\&.\&.\&.?
.sp
\fIobject\fR \fBinteract\fR
.sp
\fIobject\fR \fBdone\fR
.sp
\fIobject\fR \fBclear\fR
.sp
\fIobject\fR \fBtext\fR \fItext\fR
.sp
\fIobject\fR \fBconfigure\fR
.sp
\fIobject\fR \fBconfigure\fR \fIoption\fR
.sp
\fIobject\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR\&.\&.\&.
.sp
\fIobject\fR \fBcget\fR \fIoption\fR
.sp
.BE
.SH DESCRIPTION
This package provides a class for the creation of a simple paging
text display\&.
.SH "CLASS API"
The package exports a single command, the class command, enabling the
creation of pager instances\&. Its API is:
.TP
\fBterm::interact::pager\fR \fIobject\fR \fItext\fR ?\fIoptions\fR\&.\&.\&.?
This command creates a new pager object with the name \fIobject\fR,
initializes it, and returns the fully qualified name of the object
command as its result\&.
.sp
The argument is the text to show, possibly followed by configuration
options and their values\&. The options are explained in the section
\fBConfiguration\fR\&.
.PP
.SH "OBJECT API"
The objects created by the class command provide the methods listed
below:
.TP
\fIobject\fR \fBinteract\fR
Show the pager in the screen at the configured location and start
interacting with it\&. This opens its own event loop for the processing
of incoming characters\&. The method returns when the interaction has
completed\&. See section \fBInteraction\fR for a description of the
possible interaction\&.
.TP
\fIobject\fR \fBdone\fR
This method can be used by user supplied actions to terminate the
interaction with the object\&.
.TP
\fIobject\fR \fBclear\fR
This method can be used by user supplied actions to remove the pager
from the terminal\&.
.TP
\fIobject\fR \fBtext\fR \fItext\fR
This method can be used to change the text shown by the pager\&.
The pager will reset the dispay to show the first line of the
text at the top\&.
.TP
\fIobject\fR \fBconfigure\fR
.TP
\fIobject\fR \fBconfigure\fR \fIoption\fR
.TP
\fIobject\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR\&.\&.\&.
.TP
\fIobject\fR \fBcget\fR \fIoption\fR
Standard methods to retrieve and configure the options of the pager\&.
.PP
.SH CONFIGURATION
A pager instance recognizes the following options:
.TP
\fB-in\fR chan
Specifies the channel to read character sequences from\&. Defaults to
\fBstdin\fR\&.
.TP
\fB-out\fR chan
Specifies the channel to write the pager contents to\&. Defaults to
\fBstdout\fR\&.
.TP
\fB-column\fR int
Specifies the column of the terminal where the left margin of the
pager display should appear\&. Defaults to 0, i\&.e\&. the left-most
column\&.
.TP
\fB-line\fR int
Specifies the line of the terminal where the top margin of the pager
display should appear\&. Defaults to 0, i\&.e\&. the top-most line\&.
.TP
\fB-height\fR int
Specifies the number of lines of text to show at most in the
display\&. Defaults to 25\&.
.TP
\fB-actions\fR dict
Specifies a dictionary containing additional actions, using character
sequences as keys\&. Note that these sequences cannot override the
hardwired sequences described in section \fBInteraction\fR\&.
.PP
.SH INTERACTION
A pager object recognizes the control sequences listed below and acts
as described\&. The user can supply more control sequences to act on via
the configuration, but is not able to overide these defaults\&.
.TP
Cursor Up
The text is scrolled down a single line, making one more line visible
at the top\&. The pager will not react if the first line of the text is
already shown\&.
.TP
Cursor Down
The text is scrolled up a single line, making one more line visible at
the bottom\&. The pager will not react if the last line of the text is
already shown\&.
.TP
Page Up
The text is scrolled down a page\&. The pager will not react if the
first line of the text is already shown\&.
.TP
Page Down
The text is scrolled up a page\&. The pager will not react if the last
line of the text is already shown\&.
.TP
Enter/Return
The interaction with the object is terminated\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIterm\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
control, pager, terminal, text display
.SH CATEGORY
Terminal control
.SH COPYRIGHT
.nf
Copyright (c) 2006 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
