# -*- coding: utf-8 -*-
"""
This module contains code for the class Dof_Ptv and its related components.
"""

# Copyright (C) 2008 Martin Sandve Alnes and Simula Resarch Laboratory
#
# This file is part of SyFi.
#
# SyFi is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# SyFi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SyFi. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2008-09-03
# Last changed: 2008-09-03

from sfc.dofcode.Ptv import Ptv
from sfc.dofcode.DofT import DofT
from sfc.dofcode.Dof_Ptv import Dof_Ptv

def gen_utility_code(hfilename):
    name = hfilename.split(".")[0]
    if name == "Ptv":
       return name, Ptv.header, Ptv.implementation
    if name == "DofT":
       return name, DofT.header, DofT.implementation
    if name == "Dof_Ptv":
       return name, Dof_Ptv.header, Dof_Ptv.implementation
    raise RuntimeError("Unknown utility '%s'." % hfilename)

