#!/usr/bin/env python
import os, time
from glob import glob

skiplist = ("Elements",)

times = []
for f in glob("*"):
    if f in skiplist:
        continue
    if os.path.isdir(f):
        os.chdir(f)
        if os.path.isdir("cpp"):
            os.chdir("cpp")
            if os.path.exists("Makefile"):
                t = -time.time()
                os.system("make")
                t += time.time()
                msg = "%8.1f seconds to make %s" % (t, f)
                times.append(msg)
            os.chdir("..")
        os.chdir("..")
print
print "="*80
print "Timing:"
print "\n".join(times)

