; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @load_i8_stride4_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3) nounwind {
; SSE-LABEL: load_i8_stride4_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,255,0,255,0,255,0]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm1, %eax
; SSE-NEXT:    movw %ax, (%rsi)
; SSE-NEXT:    movd %xmm2, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    movd %xmm3, %eax
; SSE-NEXT:    movw %ax, (%rcx)
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    movw %ax, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride4_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,4,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[3,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX-NEXT:    vpextrw $0, %xmm0, (%r8)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride4_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vpmovdb %xmm0, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[3,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512-NEXT:    vpextrw $0, %xmm0, (%r8)
; AVX512-NEXT:    retq
  %wide.vec = load <8 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <8 x i8> %wide.vec, <8 x i8> poison, <2 x i32> <i32 0, i32 4>
  %strided.vec1 = shufflevector <8 x i8> %wide.vec, <8 x i8> poison, <2 x i32> <i32 1, i32 5>
  %strided.vec2 = shufflevector <8 x i8> %wide.vec, <8 x i8> poison, <2 x i32> <i32 2, i32 6>
  %strided.vec3 = shufflevector <8 x i8> %wide.vec, <8 x i8> poison, <2 x i32> <i32 3, i32 7>

  store <2 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <2 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <2 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <2 x i8> %strided.vec3, ptr %out.vec3, align 32

  ret void
}

define void @load_i8_stride4_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3) nounwind {
; SSE-LABEL: load_i8_stride4_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,0,255,0,255,0,255,0]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[1,3,2,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm5[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movd %xmm0, (%rsi)
; SSE-NEXT:    movd %xmm2, (%rdx)
; SSE-NEXT:    movd %xmm4, (%rcx)
; SSE-NEXT:    movd %xmm1, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride4_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovd %xmm1, (%rsi)
; AVX-NEXT:    vmovd %xmm2, (%rdx)
; AVX-NEXT:    vmovd %xmm3, (%rcx)
; AVX-NEXT:    vmovd %xmm0, (%r8)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride4_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpmovdb %xmm0, (%rsi)
; AVX512-NEXT:    vmovd %xmm1, (%rdx)
; AVX512-NEXT:    vmovd %xmm2, (%rcx)
; AVX512-NEXT:    vmovd %xmm3, (%r8)
; AVX512-NEXT:    retq
  %wide.vec = load <16 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <16 x i8> %wide.vec, <16 x i8> poison, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %strided.vec1 = shufflevector <16 x i8> %wide.vec, <16 x i8> poison, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %strided.vec2 = shufflevector <16 x i8> %wide.vec, <16 x i8> poison, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %strided.vec3 = shufflevector <16 x i8> %wide.vec, <16 x i8> poison, <4 x i32> <i32 3, i32 7, i32 11, i32 15>

  store <4 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <4 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <4 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <4 x i8> %strided.vec3, ptr %out.vec3, align 32

  ret void
}

define void @load_i8_stride4_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3) nounwind {
; SSE-LABEL: load_i8_stride4_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,0,255,0,255,0,255,0]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pxor %xmm7, %xmm7
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm7[8],xmm2[9],xmm7[9],xmm2[10],xmm7[10],xmm2[11],xmm7[11],xmm2[12],xmm7[12],xmm2[13],xmm7[13],xmm2[14],xmm7[14],xmm2[15],xmm7[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm3[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3],xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm6[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm7[8],xmm5[9],xmm7[9],xmm5[10],xmm7[10],xmm5[11],xmm7[11],xmm5[12],xmm7[12],xmm5[13],xmm7[13],xmm5[14],xmm7[14],xmm5[15],xmm7[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm6[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3],xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1]
; SSE-NEXT:    packuswb %xmm8, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[0,3,2,3]
; SSE-NEXT:    movq %xmm0, (%rsi)
; SSE-NEXT:    movq %xmm7, (%rdx)
; SSE-NEXT:    movq %xmm1, (%rcx)
; SSE-NEXT:    movq %xmm2, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride4_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm0 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vmovdqa (%rdi), %xmm1
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm3, %xmm2, %xmm4
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm4, %xmm2, %xmm5
; AVX-NEXT:    vpshufb %xmm4, %xmm1, %xmm4
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX-NEXT:    vmovq %xmm0, (%rsi)
; AVX-NEXT:    vmovq %xmm3, (%rdx)
; AVX-NEXT:    vmovq %xmm4, (%rcx)
; AVX-NEXT:    vmovq %xmm1, (%r8)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride4_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512-NEXT:    vpshufb %xmm1, %xmm3, %xmm4
; AVX512-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm4, %xmm3, %xmm5
; AVX512-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm5 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX512-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX512-NEXT:    vpmovdb %ymm0, (%rsi)
; AVX512-NEXT:    vmovq %xmm1, (%rdx)
; AVX512-NEXT:    vmovq %xmm4, (%rcx)
; AVX512-NEXT:    vmovq %xmm2, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <32 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <32 x i8> %wide.vec, <32 x i8> poison, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %strided.vec1 = shufflevector <32 x i8> %wide.vec, <32 x i8> poison, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %strided.vec2 = shufflevector <32 x i8> %wide.vec, <32 x i8> poison, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %strided.vec3 = shufflevector <32 x i8> %wide.vec, <32 x i8> poison, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>

  store <8 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <8 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <8 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <8 x i8> %strided.vec3, ptr %out.vec3, align 32

  ret void
}

define void @load_i8_stride4_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3) nounwind {
; SSE-LABEL: load_i8_stride4_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm2
; SSE-NEXT:    movdqa 32(%rdi), %xmm6
; SSE-NEXT:    movdqa 48(%rdi), %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,0,255,0,255,0,255,0]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm9, %xmm9
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm9[8],xmm3[9],xmm9[9],xmm3[10],xmm9[10],xmm3[11],xmm9[11],xmm3[12],xmm9[12],xmm3[13],xmm9[13],xmm3[14],xmm9[14],xmm3[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm7[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm9[8],xmm5[9],xmm9[9],xmm5[10],xmm9[10],xmm5[11],xmm9[11],xmm5[12],xmm9[12],xmm5[13],xmm9[13],xmm5[14],xmm9[14],xmm5[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm7[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3],xmm7[4],xmm9[4],xmm7[5],xmm9[5],xmm7[6],xmm9[6],xmm7[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm7[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm14 = xmm12[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm14 = xmm14[0],xmm10[0],xmm14[1],xmm10[1]
; SSE-NEXT:    packuswb %xmm8, %xmm14
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm9[8],xmm8[9],xmm9[9],xmm8[10],xmm9[10],xmm8[11],xmm9[11],xmm8[12],xmm9[12],xmm8[13],xmm9[13],xmm8[14],xmm9[14],xmm8[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm10[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3],xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm10[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm15 = xmm13[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm12[0],xmm15[1],xmm12[1]
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm9[8],xmm12[9],xmm9[9],xmm12[10],xmm9[10],xmm12[11],xmm9[11],xmm12[12],xmm9[12],xmm12[13],xmm9[13],xmm12[14],xmm9[14],xmm12[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1],xmm13[2],xmm9[2],xmm13[3],xmm9[3],xmm13[4],xmm9[4],xmm13[5],xmm9[5],xmm13[6],xmm9[6],xmm13[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm12[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm9[1,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm13[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; SSE-NEXT:    packuswb %xmm15, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,3],xmm14[0,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm11, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm11[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm6[0,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm12[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm3, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,3],xmm4[0,3]
; SSE-NEXT:    movdqa %xmm0, (%rsi)
; SSE-NEXT:    movaps %xmm9, (%rdx)
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    movaps %xmm5, (%r8)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride4_vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX1-NEXT:    vpshufb %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm5, %xmm1, %xmm6
; AVX1-NEXT:    vpshufb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm6
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm6, %xmm1, %xmm7
; AVX1-NEXT:    vpshufb %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1,2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpshufb %xmm6, %xmm3, %xmm6
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm7, %xmm1, %xmm8
; AVX1-NEXT:    vpshufb %xmm7, %xmm0, %xmm7
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0,1,2,3],xmm6[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX1-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX1-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX1-NEXT:    vmovdqa %xmm0, (%r8)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride4_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm4, %xmm3, %xmm5
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm5, %xmm1, %xmm6
; AVX2-NEXT:    vpshufb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm5[0,1],xmm4[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm5, %xmm3, %xmm6
; AVX2-NEXT:    vpshufb %xmm5, %xmm2, %xmm5
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm6, %xmm1, %xmm7
; AVX2-NEXT:    vpshufb %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm5 = xmm6[0,1],xmm5[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm6, %xmm3, %xmm7
; AVX2-NEXT:    vpshufb %xmm6, %xmm2, %xmm6
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm7 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm7, %xmm1, %xmm8
; AVX2-NEXT:    vpshufb %xmm7, %xmm0, %xmm7
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm6 = xmm7[0,1],xmm6[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm7, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3]
; AVX2-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX2-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX2-NEXT:    vmovdqa %xmm0, (%r8)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride4_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm5, %xmm4, %xmm6
; AVX512-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm6 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm6, %xmm2, %xmm7
; AVX512-NEXT:    vpshufb %xmm6, %xmm1, %xmm6
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm5 = xmm6[0,1],xmm5[2,3]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm6, %xmm4, %xmm7
; AVX512-NEXT:    vpshufb %xmm6, %xmm3, %xmm6
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm7 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm7, %xmm2, %xmm8
; AVX512-NEXT:    vpshufb %xmm7, %xmm1, %xmm7
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm6 = xmm7[0,1],xmm6[2,3]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX512-NEXT:    vpshufb %xmm7, %xmm3, %xmm3
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX512-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512-NEXT:    vpmovdb %zmm0, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <64 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <64 x i8> %wide.vec, <64 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %strided.vec1 = shufflevector <64 x i8> %wide.vec, <64 x i8> poison, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %strided.vec2 = shufflevector <64 x i8> %wide.vec, <64 x i8> poison, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %strided.vec3 = shufflevector <64 x i8> %wide.vec, <64 x i8> poison, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>

  store <16 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <16 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <16 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <16 x i8> %strided.vec3, ptr %out.vec3, align 32

  ret void
}

define void @load_i8_stride4_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3) nounwind {
; SSE-LABEL: load_i8_stride4_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $120, %rsp
; SSE-NEXT:    movdqa 64(%rdi), %xmm4
; SSE-NEXT:    movdqa 80(%rdi), %xmm13
; SSE-NEXT:    movdqa 96(%rdi), %xmm15
; SSE-NEXT:    movdqa 112(%rdi), %xmm9
; SSE-NEXT:    movdqa (%rdi), %xmm10
; SSE-NEXT:    movdqa 16(%rdi), %xmm14
; SSE-NEXT:    movdqa 32(%rdi), %xmm8
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,0,255,0,255,0,255,0]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm6
; SSE-NEXT:    packuswb %xmm1, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; SSE-NEXT:    packuswb %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm5[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm0[0],xmm11[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    packuswb %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,3],xmm7[0,3]
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm0[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1]
; SSE-NEXT:    packuswb %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm4[8],xmm1[9],xmm4[9],xmm1[10],xmm4[10],xmm1[11],xmm4[11],xmm1[12],xmm4[12],xmm1[13],xmm4[13],xmm1[14],xmm4[14],xmm1[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm13, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm4[0],xmm12[1],xmm4[1],xmm12[2],xmm4[2],xmm12[3],xmm4[3],xmm12[4],xmm4[4],xmm12[5],xmm4[5],xmm12[6],xmm4[6],xmm12[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm12[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm11[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm4[8],xmm11[9],xmm4[9],xmm11[10],xmm4[10],xmm11[11],xmm4[11],xmm11[12],xmm4[12],xmm11[13],xmm4[13],xmm11[14],xmm4[14],xmm11[15],xmm4[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[1,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm1, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3],xmm0[0,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pand %xmm0, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm14
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm14[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm1[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm2[0,3]
; SSE-NEXT:    pand %xmm0, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm9[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pand %xmm0, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm15[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm3[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm8
; SSE-NEXT:    pand %xmm0, %xmm13
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,5,4]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm8[0,3]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm0[0],xmm8[1],xmm0[1]
; SSE-NEXT:    packuswb %xmm2, %xmm8
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd $231, (%rsp), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm8[0,3]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm2[0],xmm9[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm8, %xmm9
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm8, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,3],xmm9[0,3]
; SSE-NEXT:    movdqa %xmm6, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps %xmm4, 16(%rdx)
; SSE-NEXT:    movaps %xmm5, (%rdx)
; SSE-NEXT:    movaps %xmm3, 16(%rcx)
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    movaps %xmm7, 16(%r8)
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $120, %rsp
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride4_vf32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm0
; AVX1-NEXT:    vpshufb %xmm8, %xmm0, %xmm1
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm2
; AVX1-NEXT:    vpshufb %xmm8, %xmm2, %xmm3
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm9 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm3
; AVX1-NEXT:    vpshufb %xmm9, %xmm3, %xmm4
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX1-NEXT:    vpshufb %xmm9, %xmm5, %xmm6
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm10
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX1-NEXT:    vpshufb %xmm8, %xmm7, %xmm11
; AVX1-NEXT:    vpshufb %xmm8, %xmm6, %xmm8
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm8[0],xmm11[0],xmm8[1],xmm11[1]
; AVX1-NEXT:    vpshufb %xmm9, %xmm4, %xmm11
; AVX1-NEXT:    vpshufb %xmm9, %xmm1, %xmm9
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm9[0],xmm11[0],xmm9[1],xmm11[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm8 = xmm9[0,1,2,3],xmm8[4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm9, %xmm0, %xmm10
; AVX1-NEXT:    vpshufb %xmm9, %xmm2, %xmm11
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm11, %xmm3, %xmm12
; AVX1-NEXT:    vpshufb %xmm11, %xmm5, %xmm13
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm10 = xmm12[0,1,2,3],xmm10[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX1-NEXT:    vpshufb %xmm9, %xmm7, %xmm12
; AVX1-NEXT:    vpshufb %xmm9, %xmm6, %xmm9
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm9[0],xmm12[0],xmm9[1],xmm12[1]
; AVX1-NEXT:    vpshufb %xmm11, %xmm4, %xmm12
; AVX1-NEXT:    vpshufb %xmm11, %xmm1, %xmm11
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm9 = xmm11[0,1,2,3],xmm9[4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm10, %xmm0, %xmm11
; AVX1-NEXT:    vpshufb %xmm10, %xmm2, %xmm12
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm12 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm12, %xmm3, %xmm13
; AVX1-NEXT:    vpshufb %xmm12, %xmm5, %xmm14
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm11 = xmm13[0,1,2,3],xmm11[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX1-NEXT:    vpshufb %xmm10, %xmm7, %xmm13
; AVX1-NEXT:    vpshufb %xmm10, %xmm6, %xmm10
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm10[0],xmm13[0],xmm10[1],xmm13[1]
; AVX1-NEXT:    vpshufb %xmm12, %xmm4, %xmm13
; AVX1-NEXT:    vpshufb %xmm12, %xmm1, %xmm12
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm12[0],xmm13[0],xmm12[1],xmm13[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm10 = xmm12[0,1,2,3],xmm10[4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm11, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm11, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpshufb %xmm11, %xmm7, %xmm3
; AVX1-NEXT:    vpshufb %xmm11, %xmm6, %xmm5
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX1-NEXT:    vpshufb %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    vmovaps %ymm8, (%rsi)
; AVX1-NEXT:    vmovaps %ymm9, (%rdx)
; AVX1-NEXT:    vmovaps %ymm10, (%rcx)
; AVX1-NEXT:    vmovaps %ymm0, (%r8)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride4_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa (%rdi), %xmm2
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm4
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm5
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm6, %xmm5, %xmm7
; AVX2-NEXT:    vpshufb %xmm6, %xmm4, %xmm6
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm7 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm7, %xmm3, %xmm8
; AVX2-NEXT:    vpshufb %xmm7, %xmm2, %xmm7
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],xmm6[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %ymm8, %ymm1, %ymm9
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [17179869184,17179869184,17179869184,17179869184]
; AVX2-NEXT:    vpermd %ymm9, %ymm6, %ymm9
; AVX2-NEXT:    vpshufb %ymm8, %ymm0, %ymm8
; AVX2-NEXT:    vpermd %ymm8, %ymm6, %ymm8
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm9[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm8, %xmm5, %xmm9
; AVX2-NEXT:    vpshufb %xmm8, %xmm4, %xmm8
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm9 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm9, %xmm3, %xmm10
; AVX2-NEXT:    vpshufb %xmm9, %xmm2, %xmm9
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm8 = xmm9[0,1],xmm8[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = <1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u,1,5,9,13,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %ymm9, %ymm1, %ymm10
; AVX2-NEXT:    vpermd %ymm10, %ymm6, %ymm10
; AVX2-NEXT:    vpshufb %ymm9, %ymm0, %ymm9
; AVX2-NEXT:    vpermd %ymm9, %ymm6, %ymm9
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm10[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm9, %xmm5, %xmm10
; AVX2-NEXT:    vpshufb %xmm9, %xmm4, %xmm9
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm10 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm10, %xmm3, %xmm11
; AVX2-NEXT:    vpshufb %xmm10, %xmm2, %xmm10
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm10[0],xmm11[0],xmm10[1],xmm11[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm9 = xmm10[0,1],xmm9[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm10 = <2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u,2,6,10,14,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %ymm10, %ymm1, %ymm11
; AVX2-NEXT:    vpermd %ymm11, %ymm6, %ymm11
; AVX2-NEXT:    vpshufb %ymm10, %ymm0, %ymm10
; AVX2-NEXT:    vpermd %ymm10, %ymm6, %ymm10
; AVX2-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm10, %xmm5, %xmm5
; AVX2-NEXT:    vpshufb %xmm10, %xmm4, %xmm4
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = <3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u,3,7,11,15,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpermd %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpermd %ymm0, %ymm6, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqa %ymm7, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm9, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride4_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,4,8,12,1,5,9,13]
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm1
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm2
; AVX512-NEXT:    vpshufb {{.*#+}} zmm3 = zero,zero,zero,zero,zmm2[0,4,8,12,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[16,20,24,28,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[32,36,40,44,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[48,52,56,60,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} zmm4 = zmm1[0,4,8,12],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,16,20,24,28],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,32,36,40,44],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,48,52,56,60],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vporq %zmm3, %zmm4, %zmm3
; AVX512-NEXT:    vpermd %zmm3, %zmm0, %zmm3
; AVX512-NEXT:    vpshufb {{.*#+}} zmm4 = zero,zero,zero,zero,zmm2[1,5,9,13,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[17,21,25,29,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[33,37,41,45,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[49,53,57,61,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} zmm5 = zmm1[1,5,9,13],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,17,21,25,29],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,33,37,41,45],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,49,53,57,61],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vporq %zmm4, %zmm5, %zmm4
; AVX512-NEXT:    vpermd %zmm4, %zmm0, %zmm4
; AVX512-NEXT:    vpshufb {{.*#+}} zmm5 = zero,zero,zero,zero,zmm2[2,6,10,14,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[18,22,26,30,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[34,38,42,46,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[50,54,58,62,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} zmm6 = zmm1[2,6,10,14],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,18,22,26,30],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,34,38,42,46],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,50,54,58,62],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vporq %zmm5, %zmm6, %zmm5
; AVX512-NEXT:    vpermd %zmm5, %zmm0, %zmm5
; AVX512-NEXT:    vpshufb {{.*#+}} zmm2 = zero,zero,zero,zero,zmm2[3,7,11,15,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[19,23,27,31,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[35,39,43,47,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[51,55,59,63,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[3,7,11,15],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,19,23,27,31],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,35,39,43,47],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u,51,55,59,63],zero,zero,zero,zero,zmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vporq %zmm2, %zmm1, %zmm1
; AVX512-NEXT:    vpermd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vmovdqa %ymm3, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm5, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <128 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <128 x i8> %wide.vec, <128 x i8> poison, <32 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60, i32 64, i32 68, i32 72, i32 76, i32 80, i32 84, i32 88, i32 92, i32 96, i32 100, i32 104, i32 108, i32 112, i32 116, i32 120, i32 124>
  %strided.vec1 = shufflevector <128 x i8> %wide.vec, <128 x i8> poison, <32 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61, i32 65, i32 69, i32 73, i32 77, i32 81, i32 85, i32 89, i32 93, i32 97, i32 101, i32 105, i32 109, i32 113, i32 117, i32 121, i32 125>
  %strided.vec2 = shufflevector <128 x i8> %wide.vec, <128 x i8> poison, <32 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62, i32 66, i32 70, i32 74, i32 78, i32 82, i32 86, i32 90, i32 94, i32 98, i32 102, i32 106, i32 110, i32 114, i32 118, i32 122, i32 126>
  %strided.vec3 = shufflevector <128 x i8> %wide.vec, <128 x i8> poison, <32 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63, i32 67, i32 71, i32 75, i32 79, i32 83, i32 87, i32 91, i32 95, i32 99, i32 103, i32 107, i32 111, i32 115, i32 119, i32 123, i32 127>

  store <32 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <32 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <32 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <32 x i8> %strided.vec3, ptr %out.vec3, align 32

  ret void
}
