/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_SVN_H
#define _SVN_SVN_H

// apr
#include <apr.h>

// svn
#include <svn_types.h>
#include <svn_wc.h>


namespace svn
{
typedef apr_size_t     Size;         // unsigned int32/64
typedef apr_off_t      Offset;       // int32/64

typedef svn_filesize_t Filesize;     // unsigned int64
typedef svn_revnum_t   Revnumber;    // long
typedef apr_time_t     Date;         // int64

typedef apr_int64_t    Linenumber;


const Revnumber InvalidRevnumber = SVN_INVALID_REVNUM; ///< an invalid Revnumber


// types/svn_node_kind_t
enum NodeKind
{
  Node_None    = svn_node_none,
  Node_File    = svn_node_file,
  Node_Dir     = svn_node_dir,
  Node_Unknown = svn_node_unknown
};

//class Error;
//extern Error* Success;

void setAspDotNetAdmDir( bool enable );

} // namespace

#endif //_SVN_SVN_H

