/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "BlameLine.h"


namespace svn
{

BlameLine::BlameLine( Linenumber lineNo, Revnumber rev, const sc::String& author, Date date,
  const sc::String& line ) : _lineNo(lineNo), _rev(rev), _author(author), _date(date),
  _line(line)
{
}

Linenumber BlameLine::getLineNo() const
{
  return _lineNo;
}

Revnumber BlameLine::getRevnumber() const
{
  return _rev;
}

Date BlameLine::getDate() const
{
  return _date;
}

const sc::String& BlameLine::getAuthor() const
{
  return _author;
}

const sc::String& BlameLine::getLine() const
{
  return _line;
}

} // namespace
