/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXT_VIEW_WIDGET_H
#define _TEXT_VIEW_WIDGET_H

// qt
#include <QtGui/QWidget>
#include <QtGui/QFrame>
class QScrollBar;


class TextViewWidget : public QFrame 
{
  typedef QFrame super;
  Q_OBJECT 

public:
  TextViewWidget( QWidget *parent=0, const char *name=0 );
  virtual ~TextViewWidget();

  enum ScrollBarOff { sboHide, sboDisable };

  void setVScrollBarOff( ScrollBarOff off );
  void setHScrollBarOff( ScrollBarOff off );

  ScrollBarOff getHScrollBarOff() const;

public slots:
  virtual void vsbChange(int) = 0;
  virtual void hsbChange(int) = 0;
  virtual void xChange(int) = 0;
  virtual void yChange(int) = 0;

  QScrollBar* getVScrollBar() const;
  QScrollBar* getHScrollBar() const;

signals:
  void updatedScrollBars();

protected:
  virtual QSize getScrollSizeHint() = 0;
  virtual QSize getScrollSizeCurr() = 0;

  void resizeEvent( QResizeEvent* );
  void setGeometry( int x, int y, int w, int h );

  void updateScrollBars();
  void setScrollBarOff( QScrollBar* sb, ScrollBarOff sbo, bool off );

protected:
  QScrollBar*        _vsb;
  QScrollBar*        _hsb;

  ScrollBarOff       _vsbOff;
  ScrollBarOff       _hsbOff;
};


#endif // _TEXT_VIEW_WIDGET_H

