/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "DebugSettingsWidget.h"
#include "util/apr.h"

// apr
#include <apr_file_io.h>

// qt
#include <QtGui/QLayout>
#include <QtGui/QCheckBox>
#include <QtGui/QToolTip>
#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <Qt3Support/Q3HBox>


DebugSettingsWidget::DebugSettingsWidget( long enable, QWidget *parent )
: super(parent)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  vl->setSpacing(10);
  {
    //QGroupBox* gb1 = new QGroupBox(1,Qt::Vertical,this);
    //gb1->setTitle( "all plattforms: " );
    //vl->addWidget(gb1);
    {
      _log = new QCheckBox( _q("&keep diff stdout/stderr output"), this );
      _log->setTristate(false);
      _log->setShown(enable&Log);
      _log->setToolTip( _q("do NOT delete stdout and stderr output files from diff tool") );
      vl->addWidget(_log);
    }

    {
      _l10n = new QCheckBox( _q("&disable localization"), this );
      _l10n->setTristate(false);
      _l10n->setShown(enable&L10n);
      _l10n->setToolTip( _q("use english texts, toggling requires restart") );
      vl->addWidget(_l10n);
    }

    vl->addStretch(1);

    Q3HBox* hb = new Q3HBox(this);
    vl->addWidget(hb);
    {
      apr::Pool pool;
      const char*  tempdir = 0;
      apr_status_t status  = apr_temp_dir_get( &tempdir, pool );
      if( status != APR_SUCCESS )
      {
        // \todo error handling
      }

      // TODO avoid #ifdef
#ifdef _WIN32
      char buf[256];
      GetLongPathName( tempdir, buf, 250 );
      tempdir = buf;
#endif //_WIN32

      new QLabel( _q("output path: "), hb );
      QLineEdit *e = new QLineEdit( hb );
      e->setEnabled(false);
      e->setText(tempdir);
    }
  }

  connect( _log, SIGNAL(clicked(void)), SLOT(clicked(void)) );
  connect( _l10n, SIGNAL(clicked(void)), SLOT(clicked(void)) );
}

DebugSettingsWidget::~DebugSettingsWidget()
{
}

void DebugSettingsWidget::setLog(bool b)
{
  _log->setChecked(b);
}

bool DebugSettingsWidget::getLog() const
{
  return _log->isChecked();
}


void DebugSettingsWidget::setL10n(bool b)
{
  _l10n->setChecked(!b);
}

bool DebugSettingsWidget::getL10n()
{
  return !_l10n->isChecked();
}

void DebugSettingsWidget::clicked()
{
  emit modified();
}
