/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTCMD2_H
#define _SC_LISTCMD2_H

// sc
#include "ScCmd.h"
#include "svn/DirEntryTypes.h"
class ListCache;
class ListParam;
class CmdResultCallback;

/**
 * Command for listing a repository.
 */
class ListCmd2 : public ScCmd
{
public:
  /**
   * Construct a ListCmd2.
   *
   * \param param the parameters for the command.
   * \param lc the callback to get and set cache information. 
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  ListCmd2( ListParam* param, ListCache* lc, CmdResultCallback* cb );
  ~ListCmd2();

  void run();

private:
  // in
  ListParam*         _param;

  // out
  ListCache*         _lc;
  CmdResultCallback* _cb;
};

#endif // _SC_LISTCMD2_H
