use lang:bs;
use core:lang;
use core:asm;

/**
 * Embed and refer to an object from within an expression.
 */
class ObjectLiteral extends Expr {
	// Object we are referring to.
	Object object;

	// Create.
	init(SrcPos pos, Object object) {
		init(pos) {
			object = object;
		}
	}

	// Result.
	ExprResult result() {
		ExprResult(Value(typeOf(object)));
	}

	// Code.
	void code(CodeGen state, CodeResult result) {
		if (!result.needed)
			return;

		var v = result.location(state);
		state.l << mov(v, objPtr(object));
		result.created(state);
	}

	// Output.
	void toS(StrBuf to) {
		to << "object{" << object << "}";
	}
}


/**
 * Embed and refer to a TObject from an expression.
 */
class TObjectLiteral extends Expr {
	// Object we are referring to.
	TObject object;

	// Create.
	init(SrcPos pos, TObject object) {
		init(pos) {
			object = object;
		}
	}

	// Result.
	ExprResult result() {
		ExprResult(Value(typeOf(object)));
	}

	// Code.
	void code(CodeGen state, CodeResult result) {
		if (!result.needed)
			return;

		var v = result.location(state);
		state.l << mov(v, objPtr(object));
		result.created(state);
	}

	// Output.
	void toS(StrBuf to) {
		to << "tobject{" << object << "}";
	}
}
