/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.SQLFunctionType;

public class SQLFunction
extends ADQLFunction {
    private final SQLFunctionType type;
    private ADQLOperand param = null;
    private boolean distinct = false;

    public SQLFunction(SQLFunctionType t, ADQLOperand operand) throws NullPointerException {
        this(t, operand, false);
    }

    public SQLFunction(SQLFunctionType t, ADQLOperand operand, boolean distinctValues) throws NullPointerException {
        if (t == null) {
            throw new NullPointerException("Impossible to build a SQLFunction without its type (COUNT, SUM, AVG, ...)!");
        }
        this.type = t;
        if (this.type == SQLFunctionType.COUNT_ALL) {
            this.param = null;
        } else {
            if (operand == null) {
                throw new NullPointerException("Impossible to build the SQL function \"" + this.type.name() + "\" without the operand on which it must apply!");
            }
            this.param = operand;
        }
        this.distinct = distinctValues;
    }

    public SQLFunction(SQLFunction toCopy) throws Exception {
        this.type = toCopy.type;
        this.param = (ADQLOperand)toCopy.param.getCopy();
        this.distinct = toCopy.distinct;
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return this.type.getFeatureDescription();
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinctValues) {
        this.distinct = distinctValues;
        this.setPosition(null);
    }

    public final SQLFunctionType getType() {
        return this.type;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new SQLFunction(this);
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        if (this.param != null) {
            return new ADQLOperand[]{this.param};
        }
        return new ADQLOperand[0];
    }

    @Override
    public int getNbParameters() {
        return this.type == SQLFunctionType.COUNT_ALL ? 0 : 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.type.name() + "\"!");
        }
        return this.param;
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.type.name() + "\"!");
        }
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove the only required parameter of the function \"" + this.type.name() + "\"!");
        }
        ADQLOperand replaced = this.param;
        this.param = replacer;
        this.setPosition(null);
        return replaced;
    }

    @Override
    public String toADQL() {
        if (this.type == SQLFunctionType.COUNT_ALL) {
            return "COUNT(" + (this.distinct ? "DISTINCT " : "") + "*)";
        }
        return this.getName() + "(" + (this.distinct ? "DISTINCT " : "") + this.param.toADQL() + ")";
    }
}

