<?php
/**
 * functions/decode/x_mac_chintrad.php
 * $Id: x_mac_chintrad.php 12467 2007-06-25 15:52:44Z kink $
 *
 * Copyright (c) 2003-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Original data taken from:
 *  ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/APPLE/CHINTRAD.TXT
 * 
 * Contents:
 * Map (external version) from Mac OS Chinese
 * Traditional encoding to Unicode 2.1 through Unicode 3.2
 * 
 * Copyright:  (c) 1995-2002 by Apple Computer, Inc., all rights reserved.
 *
 * Contact:    charsets@apple.com
 *
 * Standard header:
 * Apple, the Apple logo, and Macintosh are trademarks of Apple
 * Computer, Inc., registered in the United States and other countries.
 * Unicode is a trademark of Unicode Inc. For the sake of brevity,
 * throughout this document, ""Macintosh"" can be used to refer to
 * Macintosh computers and ""Unicode"" can be used to refer to the
 * Unicode standard.
 *
 * Apple makes no warranty or representation, either express or
 * implied, with respect to these tables, their quality, accuracy, or
 * fitness for a particular purpose. In no event will Apple be liable
 * for direct, indirect, special, incidental, or consequential damages 
 * resulting from any defect or inaccuracy in this document or the
 * accompanying tables.
 * 
 * These mapping tables and character lists are subject to change.
 * The latest tables should be available from the following:
 * 
 * <http://www.unicode.org/Public/MAPPINGS/VENDORS/APPLE/>
 *
 * @package decode
 * @subpackage x-mac
 */

/**
 * Decode x-mac-chintrad string
 * @param string $string String to decode
 * @return string $string Html formated string
 */
function charset_decode_x_mac_chintrad ($string) {
    // don't do decoding when there are no 8bit symbols
    if (! sq_is8bit($string,'x-mac-chintrad'))
        return $string;

    $mac_chintrad = array(
	"\x80" => '&#92;&#63615;',
	"\x81" => '&#63616;',
	"\x82" => '&#63617;',
	"\xA0" => '&#160;',
	"\xFD" => '&#169;',
	"\xFE" => '&#8482;',
	"\xFF" => '&#8230;',
	"\xA140" => '&#12288;',
	"\xA141" => '&#65292;',
	"\xA142" => '&#12289;',
	"\xA143" => '&#12290;',
	"\xA144" => '&#65294;',
	"\xA145" => '&#183;',
	"\xA146" => '&#65307;',
	"\xA147" => '&#65306;',
	"\xA148" => '&#65311;',
	"\xA149" => '&#65281;',
	"\xA14A" => '&#65072;',
	"\xA14B" => '&#8943;',
	"\xA14C" => '&#8229;',
	"\xA14D" => '&#65292;&#63613;',
	"\xA14E" => '&#12289;&#63613;',
	"\xA14F" => '&#65294;&#63613;',
	"\xA150" => '&#65294;&#63614;',
	"\xA151" => '&#65307;&#63613;',
	"\xA152" => '&#65306;&#63613;',
	"\xA153" => '&#65311;&#63613;',
	"\xA154" => '&#65281;&#63613;',
	"\xA155" => '&#65372;',
	"\xA156" => '&#8211;',
	"\xA157" => '&#65073;',
	"\xA158" => '&#8212;',
	"\xA159" => '&#65075;',
	"\xA15A" => '&#65343;&#63615;',
	"\xA15B" => '&#65076;',
	"\xA15C" => '&#65103;',
	"\xA15D" => '&#65288;',
	"\xA15E" => '&#65289;',
	"\xA15F" => '&#65077;',
	"\xA160" => '&#65078;',
	"\xA161" => '&#65371;',
	"\xA162" => '&#65373;',
	"\xA163" => '&#65079;',
	"\xA164" => '&#65080;',
	"\xA165" => '&#12308;',
	"\xA166" => '&#12309;',
	"\xA167" => '&#65081;',
	"\xA168" => '&#65082;',
	"\xA169" => '&#12304;',
	"\xA16A" => '&#12305;',
	"\xA16B" => '&#65083;',
	"\xA16C" => '&#65084;',
	"\xA16D" => '&#12298;',
	"\xA16E" => '&#12299;',
	"\xA16F" => '&#65085;',
	"\xA170" => '&#65086;',
	"\xA171" => '&#12296;',
	"\xA172" => '&#12297;',
	"\xA173" => '&#65087;',
	"\xA174" => '&#65088;',
	"\xA175" => '&#12300;',
	"\xA176" => '&#12301;',
	"\xA177" => '&#65089;',
	"\xA178" => '&#65090;',
	"\xA179" => '&#12302;',
	"\xA17A" => '&#12303;',
	"\xA17B" => '&#65091;',
	"\xA17C" => '&#65092;',
	"\xA17D" => '&#65288;&#63615;',
	"\xA17E" => '&#65289;&#63615;',
	"\xA1A1" => '&#65371;&#63615;',
	"\xA1A2" => '&#65373;&#63615;',
	"\xA1A3" => '&#12308;&#63615;',
	"\xA1A4" => '&#12309;&#63615;',
	"\xA1A5" => '&#8216;',
	"\xA1A6" => '&#8217;',
	"\xA1A7" => '&#8220;',
	"\xA1A8" => '&#8221;',
	"\xA1A9" => '&#12317;',
	"\xA1AA" => '&#12318;',
	"\xA1AB" => '&#8245;',
	"\xA1AC" => '&#8242;',
	"\xA1AD" => '&#65283;',
	"\xA1AE" => '&#65286;',
	"\xA1AF" => '&#65290;',
	"\xA1B0" => '&#8251;',
	"\xA1B1" => '&#167;',
	"\xA1B2" => '&#12291;',
	"\xA1B3" => '&#9675;',
	"\xA1B4" => '&#9679;',
	"\xA1B5" => '&#9651;',
	"\xA1B6" => '&#9650;',
	"\xA1B7" => '&#9678;',
	"\xA1B8" => '&#9734;',
	"\xA1B9" => '&#9733;',
	"\xA1BA" => '&#9671;',
	"\xA1BB" => '&#9670;',
	"\xA1BC" => '&#9633;',
	"\xA1BD" => '&#9632;',
	"\xA1BE" => '&#9661;',
	"\xA1BF" => '&#9660;',
	"\xA1C0" => '&#12963;',
	"\xA1C1" => '&#8453;',
	"\xA1C2" => '&#8254;',
	"\xA1C3" => '&#8254;&#63612;',
	"\xA1C4" => '&#65343;',
	"\xA1C5" => '&#65343;&#63612;',
	"\xA1C6" => '&#65097;',
	"\xA1C7" => '&#65098;',
	"\xA1C8" => '&#65101;',
	"\xA1C9" => '&#65102;',
	"\xA1CA" => '&#65099;',
	"\xA1CB" => '&#65099;&#63612;',
	"\xA1CC" => '&#65119;',
	"\xA1CD" => '&#65120;',
	"\xA1CE" => '&#65121;',
	"\xA1CF" => '&#65291;',
	"\xA1D0" => '&#65293;',
	"\xA1D1" => '&#215;',
	"\xA1D2" => '&#247;',
	"\xA1D3" => '&#177;',
	"\xA1D4" => '&#8730;',
	"\xA1D5" => '&#65308;',
	"\xA1D6" => '&#65310;',
	"\xA1D7" => '&#65309;',
	"\xA1D8" => '&#8806;',
	"\xA1D9" => '&#8807;',
	"\xA1DA" => '&#8800;',
	"\xA1DB" => '&#8734;',
	"\xA1DC" => '&#8786;',
	"\xA1DD" => '&#8801;',
	"\xA1DE" => '&#65122;',
	"\xA1DF" => '&#65123;',
	"\xA1E0" => '&#65124;',
	"\xA1E1" => '&#65125;',
	"\xA1E2" => '&#65126;',
	"\xA1E3" => '&#8764;',
	"\xA1E4" => '&#8745;',
	"\xA1E5" => '&#8746;',
	"\xA1E6" => '&#8869;',
	"\xA1E7" => '&#8736;',
	"\xA1E8" => '&#8735;',
	"\xA1E9" => '&#8895;',
	"\xA1EA" => '&#13266;',
	"\xA1EB" => '&#13265;',
	"\xA1EC" => '&#8747;',
	"\xA1ED" => '&#8750;',
	"\xA1EE" => '&#8757;',
	"\xA1EF" => '&#8756;',
	"\xA1F0" => '&#9792;',
	"\xA1F1" => '&#9794;',
	"\xA1F2" => '&#8853;',
	"\xA1F3" => '&#9737;',
	"\xA1F4" => '&#8593;',
	"\xA1F5" => '&#8595;',
	"\xA1F6" => '&#8592;',
	"\xA1F7" => '&#8594;',
	"\xA1F8" => '&#8598;',
	"\xA1F9" => '&#8599;',
	"\xA1FA" => '&#8601;',
	"\xA1FB" => '&#8600;',
	"\xA1FC" => '&#8741;',
	"\xA1FD" => '&#8739;',
	"\xA1FE" => '&#65295;&#63615;',
	"\xA240" => '&#65340;&#63615;',
	"\xA241" => '&#65295;',
	"\xA242" => '&#65340;',
	"\xA243" => '&#65284;',
	"\xA244" => '&#165;',
	"\xA245" => '&#12306;',
	"\xA246" => '&#162;',
	"\xA247" => '&#163;',
	"\xA248" => '&#65285;',
	"\xA249" => '&#65312;',
	"\xA24A" => '&#8451;',
	"\xA24B" => '&#8457;',
	"\xA24C" => '&#65129;',
	"\xA24D" => '&#65130;',
	"\xA24E" => '&#65131;',
	"\xA24F" => '&#13269;',
	"\xA250" => '&#13212;',
	"\xA251" => '&#13213;',
	"\xA252" => '&#13214;',
	"\xA253" => '&#13262;',
	"\xA254" => '&#13217;',
	"\xA255" => '&#13198;',
	"\xA256" => '&#13199;',
	"\xA257" => '&#13252;',
	"\xA258" => '&#176;',
	"\xA259" => '&#20825;',
	"\xA25A" => '&#20827;',
	"\xA25B" => '&#20830;',
	"\xA25C" => '&#20829;',
	"\xA25D" => '&#20833;',
	"\xA25E" => '&#20835;',
	"\xA25F" => '&#21991;',
	"\xA260" => '&#29929;',
	"\xA261" => '&#31950;',
	"\xA262" => '&#9601;',
	"\xA263" => '&#9602;',
	"\xA264" => '&#9603;',
	"\xA265" => '&#9604;',
	"\xA266" => '&#9605;',
	"\xA267" => '&#9606;',
	"\xA268" => '&#9607;',
	"\xA269" => '&#9608;',
	"\xA26A" => '&#9615;',
	"\xA26B" => '&#9614;',
	"\xA26C" => '&#9613;',
	"\xA26D" => '&#9612;',
	"\xA26E" => '&#9611;',
	"\xA26F" => '&#9610;',
	"\xA270" => '&#9609;',
	"\xA271" => '&#9532;',
	"\xA272" => '&#9524;',
	"\xA273" => '&#9516;',
	"\xA274" => '&#9508;',
	"\xA275" => '&#9500;',
	"\xA276" => '&#9620;',
	"\xA277" => '&#9472;',
	"\xA278" => '&#9474;',
	"\xA279" => '&#9474;&#63615;',
	"\xA27A" => '&#9484;',
	"\xA27B" => '&#9488;',
	"\xA27C" => '&#9492;',
	"\xA27D" => '&#9496;',
	"\xA27E" => '&#9581;',
	"\xA2A1" => '&#9582;',
	"\xA2A2" => '&#9584;',
	"\xA2A3" => '&#9583;',
	"\xA2A4" => '&#9552;',
	"\xA2A5" => '&#9566;',
	"\xA2A6" => '&#9578;',
	"\xA2A7" => '&#9569;',
	"\xA2A8" => '&#9698;',
	"\xA2A9" => '&#9699;',
	"\xA2AA" => '&#9701;',
	"\xA2AB" => '&#9700;',
	"\xA2AC" => '&#9585;',
	"\xA2AD" => '&#9586;',
	"\xA2AE" => '&#9587;',
	"\xA2AF" => '&#65296;',
	"\xA2B0" => '&#65297;',
	"\xA2B1" => '&#65298;',
	"\xA2B2" => '&#65299;',
	"\xA2B3" => '&#65300;',
	"\xA2B4" => '&#65301;',
	"\xA2B5" => '&#65302;',
	"\xA2B6" => '&#65303;',
	"\xA2B7" => '&#65304;',
	"\xA2B8" => '&#65305;',
	"\xA2B9" => '&#8544;',
	"\xA2BA" => '&#8545;',
	"\xA2BB" => '&#8546;',
	"\xA2BC" => '&#8547;',
	"\xA2BD" => '&#8548;',
	"\xA2BE" => '&#8549;',
	"\xA2BF" => '&#8550;',
	"\xA2C0" => '&#8551;',
	"\xA2C1" => '&#8552;',
	"\xA2C2" => '&#8553;',
	"\xA2C3" => '&#12321;',
	"\xA2C4" => '&#12322;',
	"\xA2C5" => '&#12323;',
	"\xA2C6" => '&#12324;',
	"\xA2C7" => '&#12325;',
	"\xA2C8" => '&#12326;',
	"\xA2C9" => '&#12327;',
	"\xA2CA" => '&#12328;',
	"\xA2CB" => '&#12329;',
	"\xA2CC" => '&#21313;&#63615;',
	"\xA2CD" => '&#21316;',
	"\xA2CE" => '&#21317;&#63615;',
	"\xA2CF" => '&#65313;',
	"\xA2D0" => '&#65314;',
	"\xA2D1" => '&#65315;',
	"\xA2D2" => '&#65316;',
	"\xA2D3" => '&#65317;',
	"\xA2D4" => '&#65318;',
	"\xA2D5" => '&#65319;',
	"\xA2D6" => '&#65320;',
	"\xA2D7" => '&#65321;',
	"\xA2D8" => '&#65322;',
	"\xA2D9" => '&#65323;',
	"\xA2DA" => '&#65324;',
	"\xA2DB" => '&#65325;',
	"\xA2DC" => '&#65326;',
	"\xA2DD" => '&#65327;',
	"\xA2DE" => '&#65328;',
	"\xA2DF" => '&#65329;',
	"\xA2E0" => '&#65330;',
	"\xA2E1" => '&#65331;',
	"\xA2E2" => '&#65332;',
	"\xA2E3" => '&#65333;',
	"\xA2E4" => '&#65334;',
	"\xA2E5" => '&#65335;',
	"\xA2E6" => '&#65336;',
	"\xA2E7" => '&#65337;',
	"\xA2E8" => '&#65338;',
	"\xA2E9" => '&#65345;',
	"\xA2EA" => '&#65346;',
	"\xA2EB" => '&#65347;',
	"\xA2EC" => '&#65348;',
	"\xA2ED" => '&#65349;',
	"\xA2EE" => '&#65350;',
	"\xA2EF" => '&#65351;',
	"\xA2F0" => '&#65352;',
	"\xA2F1" => '&#65353;',
	"\xA2F2" => '&#65354;',
	"\xA2F3" => '&#65355;',
	"\xA2F4" => '&#65356;',
	"\xA2F5" => '&#65357;',
	"\xA2F6" => '&#65358;',
	"\xA2F7" => '&#65359;',
	"\xA2F8" => '&#65360;',
	"\xA2F9" => '&#65361;',
	"\xA2FA" => '&#65362;',
	"\xA2FB" => '&#65363;',
	"\xA2FC" => '&#65364;',
	"\xA2FD" => '&#65365;',
	"\xA2FE" => '&#65366;',
	"\xA340" => '&#65367;',
	"\xA341" => '&#65368;',
	"\xA342" => '&#65369;',
	"\xA343" => '&#65370;',
	"\xA344" => '&#913;',
	"\xA345" => '&#914;',
	"\xA346" => '&#915;',
	"\xA347" => '&#916;',
	"\xA348" => '&#917;',
	"\xA349" => '&#918;',
	"\xA34A" => '&#919;',
	"\xA34B" => '&#920;',
	"\xA34C" => '&#921;',
	"\xA34D" => '&#922;',
	"\xA34E" => '&#923;',
	"\xA34F" => '&#924;',
	"\xA350" => '&#925;',
	"\xA351" => '&#926;',
	"\xA352" => '&#927;',
	"\xA353" => '&#928;',
	"\xA354" => '&#929;',
	"\xA355" => '&#931;',
	"\xA356" => '&#932;',
	"\xA357" => '&#933;',
	"\xA358" => '&#934;',
	"\xA359" => '&#935;',
	"\xA35A" => '&#936;',
	"\xA35B" => '&#937;',
	"\xA35C" => '&#945;',
	"\xA35D" => '&#946;',
	"\xA35E" => '&#947;',
	"\xA35F" => '&#948;',
	"\xA360" => '&#949;',
	"\xA361" => '&#950;',
	"\xA362" => '&#951;',
	"\xA363" => '&#952;',
	"\xA364" => '&#953;',
	"\xA365" => '&#954;',
	"\xA366" => '&#955;',
	"\xA367" => '&#956;',
	"\xA368" => '&#957;',
	"\xA369" => '&#958;',
	"\xA36A" => '&#959;',
	"\xA36B" => '&#960;',
	"\xA36C" => '&#961;',
	"\xA36D" => '&#963;',
	"\xA36E" => '&#964;',
	"\xA36F" => '&#965;',
	"\xA370" => '&#966;',
	"\xA371" => '&#967;',
	"\xA372" => '&#968;',
	"\xA373" => '&#969;',
	"\xA374" => '&#12549;',
	"\xA375" => '&#12550;',
	"\xA376" => '&#12551;',
	"\xA377" => '&#12552;',
	"\xA378" => '&#12553;',
	"\xA379" => '&#12554;',
	"\xA37A" => '&#12555;',
	"\xA37B" => '&#12556;',
	"\xA37C" => '&#12557;',
	"\xA37D" => '&#12558;',
	"\xA37E" => '&#12559;',
	"\xA3A1" => '&#12560;',
	"\xA3A2" => '&#12561;',
	"\xA3A3" => '&#12562;',
	"\xA3A4" => '&#12563;',
	"\xA3A5" => '&#12564;',
	"\xA3A6" => '&#12565;',
	"\xA3A7" => '&#12566;',
	"\xA3A8" => '&#12567;',
	"\xA3A9" => '&#12568;',
	"\xA3AA" => '&#12569;',
	"\xA3AB" => '&#12570;',
	"\xA3AC" => '&#12571;',
	"\xA3AD" => '&#12572;',
	"\xA3AE" => '&#12573;',
	"\xA3AF" => '&#12574;',
	"\xA3B0" => '&#12575;',
	"\xA3B1" => '&#12576;',
	"\xA3B2" => '&#12577;',
	"\xA3B3" => '&#12578;',
	"\xA3B4" => '&#12579;',
	"\xA3B5" => '&#12580;',
	"\xA3B6" => '&#12581;',
	"\xA3B7" => '&#12582;',
	"\xA3B8" => '&#12583;',
	"\xA3B9" => '&#12584;',
	"\xA3BA" => '&#12585;',
	"\xA3BB" => '&#729;',
	"\xA3BC" => '&#713;',
	"\xA3BD" => '&#714;',
	"\xA3BE" => '&#711;',
	"\xA3BF" => '&#715;',
	"\xA440" => '&#19968;',
	"\xA441" => '&#20057;',
	"\xA442" => '&#19969;',
	"\xA443" => '&#19971;',
	"\xA444" => '&#20035;',
	"\xA445" => '&#20061;',
	"\xA446" => '&#20102;',
	"\xA447" => '&#20108;',
	"\xA448" => '&#20154;',
	"\xA449" => '&#20799;',
	"\xA44A" => '&#20837;',
	"\xA44B" => '&#20843;',
	"\xA44C" => '&#20960;',
	"\xA44D" => '&#20992;',
	"\xA44E" => '&#20993;',
	"\xA44F" => '&#21147;',
	"\xA450" => '&#21269;',
	"\xA451" => '&#21313;',
	"\xA452" => '&#21340;',
	"\xA453" => '&#21448;',
	"\xA454" => '&#19977;',
	"\xA455" => '&#19979;',
	"\xA456" => '&#19976;',
	"\xA457" => '&#19978;',
	"\xA458" => '&#20011;',
	"\xA459" => '&#20024;',
	"\xA45A" => '&#20961;',
	"\xA45B" => '&#20037;',
	"\xA45C" => '&#20040;',
	"\xA45D" => '&#20063;',
	"\xA45E" => '&#20062;',
	"\xA45F" => '&#20110;',
	"\xA460" => '&#20129;',
	"\xA461" => '&#20800;',
	"\xA462" => '&#20995;',
	"\xA463" => '&#21242;',
	"\xA464" => '&#21315;',
	"\xA465" => '&#21449;',
	"\xA466" => '&#21475;',
	"\xA467" => '&#22303;',
	"\xA468" => '&#22763;',
	"\xA469" => '&#22805;',
	"\xA46A" => '&#22823;',
	"\xA46B" => '&#22899;',
	"\xA46C" => '&#23376;',
	"\xA46D" => '&#23377;',
	"\xA46E" => '&#23379;',
	"\xA46F" => '&#23544;',
	"\xA470" => '&#23567;',
	"\xA471" => '&#23586;',
	"\xA472" => '&#23608;',
	"\xA473" => '&#23665;',
	"\xA474" => '&#24029;',
	"\xA475" => '&#24037;',
	"\xA476" => '&#24049;',
	"\xA477" => '&#24050;',
	"\xA478" => '&#24051;',
	"\xA479" => '&#24062;',
	"\xA47A" => '&#24178;',
	"\xA47B" => '&#24318;',
	"\xA47C" => '&#24331;',
	"\xA47D" => '&#24339;',
	"\xA47E" => '&#25165;',
	"\xA4A1" => '&#19985;',
	"\xA4A2" => '&#19984;',
	"\xA4A3" => '&#19981;',
	"\xA4A4" => '&#20013;',
	"\xA4A5" => '&#20016;',
	"\xA4A6" => '&#20025;',
	"\xA4A7" => '&#20043;',
	"\xA4A8" => '&#23609;',
	"\xA4A9" => '&#20104;',
	"\xA4AA" => '&#20113;',
	"\xA4AB" => '&#20117;',
	"\xA4AC" => '&#20114;',
	"\xA4AD" => '&#20116;',
	"\xA4AE" => '&#20130;',
	"\xA4AF" => '&#20161;',
	"\xA4B0" => '&#20160;',
	"\xA4B1" => '&#20163;',
	"\xA4B2" => '&#20166;',
	"\xA4B3" => '&#20167;',
	"\xA4B4" => '&#20173;',
	"\xA4B5" => '&#20170;',
	"\xA4B6" => '&#20171;',
	"\xA4B7" => '&#20164;',
	"\xA4B8" => '&#20803;',
	"\xA4B9" => '&#20801;',
	"\xA4BA" => '&#20839;',
	"\xA4BB" => '&#20845;',
	"\xA4BC" => '&#20846;',
	"\xA4BD" => '&#20844;',
	"\xA4BE" => '&#20887;',
	"\xA4BF" => '&#20982;',
	"\xA4C0" => '&#20998;',
	"\xA4C1" => '&#20999;',
	"\xA4C2" => '&#21000;',
	"\xA4C3" => '&#21243;',
	"\xA4C4" => '&#21246;',
	"\xA4C5" => '&#21247;',
	"\xA4C6" => '&#21270;',
	"\xA4C7" => '&#21305;',
	"\xA4C8" => '&#21320;',
	"\xA4C9" => '&#21319;',
	"\xA4CA" => '&#21317;',
	"\xA4CB" => '&#21342;',
	"\xA4CC" => '&#21380;',
	"\xA4CD" => '&#21451;',
	"\xA4CE" => '&#21450;',
	"\xA4CF" => '&#21453;',
	"\xA4D0" => '&#22764;',
	"\xA4D1" => '&#22825;',
	"\xA4D2" => '&#22827;',
	"\xA4D3" => '&#22826;',
	"\xA4D4" => '&#22829;',
	"\xA4D5" => '&#23380;',
	"\xA4D6" => '&#23569;',
	"\xA4D7" => '&#23588;',
	"\xA4D8" => '&#23610;',
	"\xA4D9" => '&#23663;',
	"\xA4DA" => '&#24052;',
	"\xA4DB" => '&#24187;',
	"\xA4DC" => '&#24319;',
	"\xA4DD" => '&#24340;',
	"\xA4DE" => '&#24341;',
	"\xA4DF" => '&#24515;',
	"\xA4E0" => '&#25096;',
	"\xA4E1" => '&#25142;',
	"\xA4E2" => '&#25163;',
	"\xA4E3" => '&#25166;',
	"\xA4E4" => '&#25903;',
	"\xA4E5" => '&#25991;',
	"\xA4E6" => '&#26007;',
	"\xA4E7" => '&#26020;',
	"\xA4E8" => '&#26041;',
	"\xA4E9" => '&#26085;',
	"\xA4EA" => '&#26352;',
	"\xA4EB" => '&#26376;',
	"\xA4EC" => '&#26408;',
	"\xA4ED" => '&#27424;',
	"\xA4EE" => '&#27490;',
	"\xA4EF" => '&#27513;',
	"\xA4F0" => '&#27595;',
	"\xA4F1" => '&#27604;',
	"\xA4F2" => '&#27611;',
	"\xA4F3" => '&#27663;',
	"\xA4F4" => '&#27700;',
	"\xA4F5" => '&#28779;',
	"\xA4F6" => '&#29226;',
	"\xA4F7" => '&#29238;',
	"\xA4F8" => '&#29243;',
	"\xA4F9" => '&#29255;',
	"\xA4FA" => '&#29273;',
	"\xA4FB" => '&#29275;',
	"\xA4FC" => '&#29356;',
	"\xA4FD" => '&#29579;',
	"\xA4FE" => '&#19993;',
	"\xA540" => '&#19990;',
	"\xA541" => '&#19989;',
	"\xA542" => '&#19988;',
	"\xA543" => '&#19992;',
	"\xA544" => '&#20027;',
	"\xA545" => '&#20045;',
	"\xA546" => '&#20047;',
	"\xA547" => '&#20046;',
	"\xA548" => '&#20197;',
	"\xA549" => '&#20184;',
	"\xA54A" => '&#20180;',
	"\xA54B" => '&#20181;',
	"\xA54C" => '&#20182;',
	"\xA54D" => '&#20183;',
	"\xA54E" => '&#20195;',
	"\xA54F" => '&#20196;',
	"\xA550" => '&#20185;',
	"\xA551" => '&#20190;',
	"\xA552" => '&#20805;',
	"\xA553" => '&#20804;',
	"\xA554" => '&#20873;',
	"\xA555" => '&#20874;',
	"\xA556" => '&#20908;',
	"\xA557" => '&#20985;',
	"\xA558" => '&#20986;',
	"\xA559" => '&#20984;',
	"\xA55A" => '&#21002;',
	"\xA55B" => '&#21152;',
	"\xA55C" => '&#21151;',
	"\xA55D" => '&#21253;',
	"\xA55E" => '&#21254;',
	"\xA55F" => '&#21271;',
	"\xA560" => '&#21277;',
	"\xA561" => '&#20191;',
	"\xA562" => '&#21322;',
	"\xA563" => '&#21321;',
	"\xA564" => '&#21345;',
	"\xA565" => '&#21344;',
	"\xA566" => '&#21359;',
	"\xA567" => '&#21358;',
	"\xA568" => '&#21435;',
	"\xA569" => '&#21487;',
	"\xA56A" => '&#21476;',
	"\xA56B" => '&#21491;',
	"\xA56C" => '&#21484;',
	"\xA56D" => '&#21486;',
	"\xA56E" => '&#21481;',
	"\xA56F" => '&#21480;',
	"\xA570" => '&#21500;',
	"\xA571" => '&#21496;',
	"\xA572" => '&#21493;',
	"\xA573" => '&#21483;',
	"\xA574" => '&#21478;',
	"\xA575" => '&#21482;',
	"\xA576" => '&#21490;',
	"\xA577" => '&#21489;',
	"\xA578" => '&#21488;',
	"\xA579" => '&#21477;',
	"\xA57A" => '&#21485;',
	"\xA57B" => '&#21499;',
	"\xA57C" => '&#22235;',
	"\xA57D" => '&#22234;',
	"\xA57E" => '&#22806;',
	"\xA5A1" => '&#22830;',
	"\xA5A2" => '&#22833;',
	"\xA5A3" => '&#22900;',
	"\xA5A4" => '&#22902;',
	"\xA5A5" => '&#23381;',
	"\xA5A6" => '&#23427;',
	"\xA5A7" => '&#23612;',
	"\xA5A8" => '&#24040;',
	"\xA5A9" => '&#24039;',
	"\xA5AA" => '&#24038;',
	"\xA5AB" => '&#24066;',
	"\xA5AC" => '&#24067;',
	"\xA5AD" => '&#24179;',
	"\xA5AE" => '&#24188;',
	"\xA5AF" => '&#24321;',
	"\xA5B0" => '&#24344;',
	"\xA5B1" => '&#24343;',
	"\xA5B2" => '&#24517;',
	"\xA5B3" => '&#25098;',
	"\xA5B4" => '&#25171;',
	"\xA5B5" => '&#25172;',
	"\xA5B6" => '&#25170;',
	"\xA5B7" => '&#25169;',
	"\xA5B8" => '&#26021;',
	"\xA5B9" => '&#26086;',
	"\xA5BA" => '&#26414;',
	"\xA5BB" => '&#26412;',
	"\xA5BC" => '&#26410;',
	"\xA5BD" => '&#26411;',
	"\xA5BE" => '&#26413;',
	"\xA5BF" => '&#27491;',
	"\xA5C0" => '&#27597;',
	"\xA5C1" => '&#27665;',
	"\xA5C2" => '&#27664;',
	"\xA5C3" => '&#27704;',
	"\xA5C4" => '&#27713;',
	"\xA5C5" => '&#27712;',
	"\xA5C6" => '&#27710;',
	"\xA5C7" => '&#29359;',
	"\xA5C8" => '&#29572;',
	"\xA5C9" => '&#29577;',
	"\xA5CA" => '&#29916;',
	"\xA5CB" => '&#29926;',
	"\xA5CC" => '&#29976;',
	"\xA5CD" => '&#29983;',
	"\xA5CE" => '&#29992;',
	"\xA5CF" => '&#29993;',
	"\xA5D0" => '&#30000;',
	"\xA5D1" => '&#30001;',
	"\xA5D2" => '&#30002;',
	"\xA5D3" => '&#30003;',
	"\xA5D4" => '&#30091;',
	"\xA5D5" => '&#30333;',
	"\xA5D6" => '&#30382;',
	"\xA5D7" => '&#30399;',
	"\xA5D8" => '&#30446;',
	"\xA5D9" => '&#30683;',
	"\xA5DA" => '&#30690;',
	"\xA5DB" => '&#30707;',
	"\xA5DC" => '&#31034;',
	"\xA5DD" => '&#31166;',
	"\xA5DE" => '&#31348;',
	"\xA5DF" => '&#31435;',
	"\xA5E0" => '&#19998;',
	"\xA5E1" => '&#19999;',
	"\xA5E2" => '&#20050;',
	"\xA5E3" => '&#20051;',
	"\xA5E4" => '&#20073;',
	"\xA5E5" => '&#20121;',
	"\xA5E6" => '&#20132;',
	"\xA5E7" => '&#20134;',
	"\xA5E8" => '&#20133;',
	"\xA5E9" => '&#20223;',
	"\xA5EA" => '&#20233;',
	"\xA5EB" => '&#20249;',
	"\xA5EC" => '&#20234;',
	"\xA5ED" => '&#20245;',
	"\xA5EE" => '&#20237;',
	"\xA5EF" => '&#20240;',
	"\xA5F0" => '&#20241;',
	"\xA5F1" => '&#20239;',
	"\xA5F2" => '&#20210;',
	"\xA5F3" => '&#20214;',
	"\xA5F4" => '&#20219;',
	"\xA5F5" => '&#20208;',
	"\xA5F6" => '&#20211;',
	"\xA5F7" => '&#20221;',
	"\xA5F8" => '&#20225;',
	"\xA5F9" => '&#20235;',
	"\xA5FA" => '&#20809;',
	"\xA5FB" => '&#20807;',
	"\xA5FC" => '&#20806;',
	"\xA5FD" => '&#20808;',
	"\xA5FE" => '&#20840;',
	"\xA640" => '&#20849;',
	"\xA641" => '&#20877;',
	"\xA642" => '&#20912;',
	"\xA643" => '&#21015;',
	"\xA644" => '&#21009;',
	"\xA645" => '&#21010;',
	"\xA646" => '&#21006;',
	"\xA647" => '&#21014;',
	"\xA648" => '&#21155;',
	"\xA649" => '&#21256;',
	"\xA64A" => '&#21281;',
	"\xA64B" => '&#21280;',
	"\xA64C" => '&#21360;',
	"\xA64D" => '&#21361;',
	"\xA64E" => '&#21513;',
	"\xA64F" => '&#21519;',
	"\xA650" => '&#21516;',
	"\xA651" => '&#21514;',
	"\xA652" => '&#21520;',
	"\xA653" => '&#21505;',
	"\xA654" => '&#21515;',
	"\xA655" => '&#21508;',
	"\xA656" => '&#21521;',
	"\xA657" => '&#21517;',
	"\xA658" => '&#21512;',
	"\xA659" => '&#21507;',
	"\xA65A" => '&#21518;',
	"\xA65B" => '&#21510;',
	"\xA65C" => '&#21522;',
	"\xA65D" => '&#22240;',
	"\xA65E" => '&#22238;',
	"\xA65F" => '&#22237;',
	"\xA660" => '&#22323;',
	"\xA661" => '&#22320;',
	"\xA662" => '&#22312;',
	"\xA663" => '&#22317;',
	"\xA664" => '&#22316;',
	"\xA665" => '&#22319;',
	"\xA666" => '&#22313;',
	"\xA667" => '&#22809;',
	"\xA668" => '&#22810;',
	"\xA669" => '&#22839;',
	"\xA66A" => '&#22840;',
	"\xA66B" => '&#22916;',
	"\xA66C" => '&#22904;',
	"\xA66D" => '&#22915;',
	"\xA66E" => '&#22909;',
	"\xA66F" => '&#22905;',
	"\xA670" => '&#22914;',
	"\xA671" => '&#22913;',
	"\xA672" => '&#23383;',
	"\xA673" => '&#23384;',
	"\xA674" => '&#23431;',
	"\xA675" => '&#23432;',
	"\xA676" => '&#23429;',
	"\xA677" => '&#23433;',
	"\xA678" => '&#23546;',
	"\xA679" => '&#23574;',
	"\xA67A" => '&#23673;',
	"\xA67B" => '&#24030;',
	"\xA67C" => '&#24070;',
	"\xA67D" => '&#24182;',
	"\xA67E" => '&#24180;',
	"\xA6A1" => '&#24335;',
	"\xA6A2" => '&#24347;',
	"\xA6A3" => '&#24537;',
	"\xA6A4" => '&#24534;',
	"\xA6A5" => '&#25102;',
	"\xA6A6" => '&#25100;',
	"\xA6A7" => '&#25101;',
	"\xA6A8" => '&#25104;',
	"\xA6A9" => '&#25187;',
	"\xA6AA" => '&#25179;',
	"\xA6AB" => '&#25176;',
	"\xA6AC" => '&#25910;',
	"\xA6AD" => '&#26089;',
	"\xA6AE" => '&#26088;',
	"\xA6AF" => '&#26092;',
	"\xA6B0" => '&#26093;',
	"\xA6B1" => '&#26354;',
	"\xA6B2" => '&#26355;',
	"\xA6B3" => '&#26377;',
	"\xA6B4" => '&#26429;',
	"\xA6B5" => '&#26420;',
	"\xA6B6" => '&#26417;',
	"\xA6B7" => '&#26421;',
	"\xA6B8" => '&#27425;',
	"\xA6B9" => '&#27492;',
	"\xA6BA" => '&#27515;',
	"\xA6BB" => '&#27670;',
	"\xA6BC" => '&#27741;',
	"\xA6BD" => '&#27735;',
	"\xA6BE" => '&#27737;',
	"\xA6BF" => '&#27743;',
	"\xA6C0" => '&#27744;',
	"\xA6C1" => '&#27728;',
	"\xA6C2" => '&#27733;',
	"\xA6C3" => '&#27745;',
	"\xA6C4" => '&#27739;',
	"\xA6C5" => '&#27725;',
	"\xA6C6" => '&#27726;',
	"\xA6C7" => '&#28784;',
	"\xA6C8" => '&#29279;',
	"\xA6C9" => '&#29277;',
	"\xA6CA" => '&#30334;',
	"\xA6CB" => '&#31481;',
	"\xA6CC" => '&#31859;',
	"\xA6CD" => '&#31992;',
	"\xA6CE" => '&#32566;',
	"\xA6CF" => '&#32650;',
	"\xA6D0" => '&#32701;',
	"\xA6D1" => '&#32769;',
	"\xA6D2" => '&#32771;',
	"\xA6D3" => '&#32780;',
	"\xA6D4" => '&#32786;',
	"\xA6D5" => '&#32819;',
	"\xA6D6" => '&#32895;',
	"\xA6D7" => '&#32905;',
	"\xA6D8" => '&#32907;',
	"\xA6D9" => '&#32908;',
	"\xA6DA" => '&#33251;',
	"\xA6DB" => '&#33258;',
	"\xA6DC" => '&#33267;',
	"\xA6DD" => '&#33276;',
	"\xA6DE" => '&#33292;',
	"\xA6DF" => '&#33307;',
	"\xA6E0" => '&#33311;',
	"\xA6E1" => '&#33390;',
	"\xA6E2" => '&#33394;',
	"\xA6E3" => '&#33406;',
	"\xA6E4" => '&#34411;',
	"\xA6E5" => '&#34880;',
	"\xA6E6" => '&#34892;',
	"\xA6E7" => '&#34915;',
	"\xA6E8" => '&#35199;',
	"\xA6E9" => '&#38433;',
	"\xA6EA" => '&#20018;',
	"\xA6EB" => '&#20136;',
	"\xA6EC" => '&#20301;',
	"\xA6ED" => '&#20303;',
	"\xA6EE" => '&#20295;',
	"\xA6EF" => '&#20311;',
	"\xA6F0" => '&#20318;',
	"\xA6F1" => '&#20276;',
	"\xA6F2" => '&#20315;',
	"\xA6F3" => '&#20309;',
	"\xA6F4" => '&#20272;',
	"\xA6F5" => '&#20304;',
	"\xA6F6" => '&#20305;',
	"\xA6F7" => '&#20285;',
	"\xA6F8" => '&#20282;',
	"\xA6F9" => '&#20280;',
	"\xA6FA" => '&#20291;',
	"\xA6FB" => '&#20308;',
	"\xA6FC" => '&#20284;',
	"\xA6FD" => '&#20294;',
	"\xA6FE" => '&#20323;',
	"\xA740" => '&#20316;',
	"\xA741" => '&#20320;',
	"\xA742" => '&#20271;',
	"\xA743" => '&#20302;',
	"\xA744" => '&#20278;',
	"\xA745" => '&#20313;',
	"\xA746" => '&#20317;',
	"\xA747" => '&#20296;',
	"\xA748" => '&#20314;',
	"\xA749" => '&#20812;',
	"\xA74A" => '&#20811;',
	"\xA74B" => '&#20813;',
	"\xA74C" => '&#20853;',
	"\xA74D" => '&#20918;',
	"\xA74E" => '&#20919;',
	"\xA74F" => '&#21029;',
	"\xA750" => '&#21028;',
	"\xA751" => '&#21033;',
	"\xA752" => '&#21034;',
	"\xA753" => '&#21032;',
	"\xA754" => '&#21163;',
	"\xA755" => '&#21161;',
	"\xA756" => '&#21162;',
	"\xA757" => '&#21164;',
	"\xA758" => '&#21283;',
	"\xA759" => '&#21363;',
	"\xA75A" => '&#21365;',
	"\xA75B" => '&#21533;',
	"\xA75C" => '&#21549;',
	"\xA75D" => '&#21534;',
	"\xA75E" => '&#21566;',
	"\xA75F" => '&#21542;',
	"\xA760" => '&#21582;',
	"\xA761" => '&#21543;',
	"\xA762" => '&#21574;',
	"\xA763" => '&#21571;',
	"\xA764" => '&#21555;',
	"\xA765" => '&#21576;',
	"\xA766" => '&#21570;',
	"\xA767" => '&#21531;',
	"\xA768" => '&#21545;',
	"\xA769" => '&#21578;',
	"\xA76A" => '&#21561;',
	"\xA76B" => '&#21563;',
	"\xA76C" => '&#21560;',
	"\xA76D" => '&#21550;',
	"\xA76E" => '&#21557;',
	"\xA76F" => '&#21558;',
	"\xA770" => '&#21536;',
	"\xA771" => '&#21564;',
	"\xA772" => '&#21568;',
	"\xA773" => '&#21553;',
	"\xA774" => '&#21547;',
	"\xA775" => '&#21535;',
	"\xA776" => '&#21548;',
	"\xA777" => '&#22250;',
	"\xA778" => '&#22256;',
	"\xA779" => '&#22244;',
	"\xA77A" => '&#22251;',
	"\xA77B" => '&#22346;',
	"\xA77C" => '&#22353;',
	"\xA77D" => '&#22336;',
	"\xA77E" => '&#22349;',
	"\xA7A1" => '&#22343;',
	"\xA7A2" => '&#22350;',
	"\xA7A3" => '&#22334;',
	"\xA7A4" => '&#22352;',
	"\xA7A5" => '&#22351;',
	"\xA7A6" => '&#22331;',
	"\xA7A7" => '&#22767;',
	"\xA7A8" => '&#22846;',
	"\xA7A9" => '&#22941;',
	"\xA7AA" => '&#22930;',
	"\xA7AB" => '&#22952;',
	"\xA7AC" => '&#22942;',
	"\xA7AD" => '&#22947;',
	"\xA7AE" => '&#22937;',
	"\xA7AF" => '&#22934;',
	"\xA7B0" => '&#22925;',
	"\xA7B1" => '&#22948;',
	"\xA7B2" => '&#22931;',
	"\xA7B3" => '&#22922;',
	"\xA7B4" => '&#22949;',
	"\xA7B5" => '&#23389;',
	"\xA7B6" => '&#23388;',
	"\xA7B7" => '&#23386;',
	"\xA7B8" => '&#23387;',
	"\xA7B9" => '&#23436;',
	"\xA7BA" => '&#23435;',
	"\xA7BB" => '&#23439;',
	"\xA7BC" => '&#23596;',
	"\xA7BD" => '&#23616;',
	"\xA7BE" => '&#23617;',
	"\xA7BF" => '&#23615;',
	"\xA7C0" => '&#23614;',
	"\xA7C1" => '&#23696;',
	"\xA7C2" => '&#23697;',
	"\xA7C3" => '&#23700;',
	"\xA7C4" => '&#23692;',
	"\xA7C5" => '&#24043;',
	"\xA7C6" => '&#24076;',
	"\xA7C7" => '&#24207;',
	"\xA7C8" => '&#24199;',
	"\xA7C9" => '&#24202;',
	"\xA7CA" => '&#24311;',
	"\xA7CB" => '&#24324;',
	"\xA7CC" => '&#24351;',
	"\xA7CD" => '&#24420;',
	"\xA7CE" => '&#24418;',
	"\xA7CF" => '&#24439;',
	"\xA7D0" => '&#24441;',
	"\xA7D1" => '&#24536;',
	"\xA7D2" => '&#24524;',
	"\xA7D3" => '&#24535;',
	"\xA7D4" => '&#24525;',
	"\xA7D5" => '&#24561;',
	"\xA7D6" => '&#24555;',
	"\xA7D7" => '&#24568;',
	"\xA7D8" => '&#24554;',
	"\xA7D9" => '&#25106;',
	"\xA7DA" => '&#25105;',
	"\xA7DB" => '&#25220;',
	"\xA7DC" => '&#25239;',
	"\xA7DD" => '&#25238;',
	"\xA7DE" => '&#25216;',
	"\xA7DF" => '&#25206;',
	"\xA7E0" => '&#25225;',
	"\xA7E1" => '&#25197;',
	"\xA7E2" => '&#25226;',
	"\xA7E3" => '&#25212;',
	"\xA7E4" => '&#25214;',
	"\xA7E5" => '&#25209;',
	"\xA7E6" => '&#25203;',
	"\xA7E7" => '&#25234;',
	"\xA7E8" => '&#25199;',
	"\xA7E9" => '&#25240;',
	"\xA7EA" => '&#25198;',
	"\xA7EB" => '&#25237;',
	"\xA7EC" => '&#25235;',
	"\xA7ED" => '&#25233;',
	"\xA7EE" => '&#25222;',
	"\xA7EF" => '&#25913;',
	"\xA7F0" => '&#25915;',
	"\xA7F1" => '&#25912;',
	"\xA7F2" => '&#26097;',
	"\xA7F3" => '&#26356;',
	"\xA7F4" => '&#26463;',
	"\xA7F5" => '&#26446;',
	"\xA7F6" => '&#26447;',
	"\xA7F7" => '&#26448;',
	"\xA7F8" => '&#26449;',
	"\xA7F9" => '&#26460;',
	"\xA7FA" => '&#26454;',
	"\xA7FB" => '&#26462;',
	"\xA7FC" => '&#26441;',
	"\xA7FD" => '&#26438;',
	"\xA7FE" => '&#26464;',
	"\xA840" => '&#26451;',
	"\xA841" => '&#26455;',
	"\xA842" => '&#27493;',
	"\xA843" => '&#27599;',
	"\xA844" => '&#27714;',
	"\xA845" => '&#27742;',
	"\xA846" => '&#27801;',
	"\xA847" => '&#27777;',
	"\xA848" => '&#27784;',
	"\xA849" => '&#27785;',
	"\xA84A" => '&#27781;',
	"\xA84B" => '&#27803;',
	"\xA84C" => '&#27754;',
	"\xA84D" => '&#27770;',
	"\xA84E" => '&#27792;',
	"\xA84F" => '&#27760;',
	"\xA850" => '&#27788;',
	"\xA851" => '&#27752;',
	"\xA852" => '&#27798;',
	"\xA853" => '&#27794;',
	"\xA854" => '&#27773;',
	"\xA855" => '&#27779;',
	"\xA856" => '&#27762;',
	"\xA857" => '&#27774;',
	"\xA858" => '&#27764;',
	"\xA859" => '&#27782;',
	"\xA85A" => '&#27766;',
	"\xA85B" => '&#27789;',
	"\xA85C" => '&#27796;',
	"\xA85D" => '&#27800;',
	"\xA85E" => '&#27778;',
	"\xA85F" => '&#28790;',
	"\xA860" => '&#28796;',
	"\xA861" => '&#28797;',
	"\xA862" => '&#28792;',
	"\xA863" => '&#29282;',
	"\xA864" => '&#29281;',
	"\xA865" => '&#29280;',
	"\xA866" => '&#29380;',
	"\xA867" => '&#29378;',
	"\xA868" => '&#29590;',
	"\xA869" => '&#29996;',
	"\xA86A" => '&#29995;',
	"\xA86B" => '&#30007;',
	"\xA86C" => '&#30008;',
	"\xA86D" => '&#30338;',
	"\xA86E" => '&#30447;',
	"\xA86F" => '&#30691;',
	"\xA870" => '&#31169;',
	"\xA871" => '&#31168;',
	"\xA872" => '&#31167;',
	"\xA873" => '&#31350;',
	"\xA874" => '&#31995;',
	"\xA875" => '&#32597;',
	"\xA876" => '&#32918;',
	"\xA877" => '&#32915;',
	"\xA878" => '&#32925;',
	"\xA879" => '&#32920;',
	"\xA87A" => '&#32923;',
	"\xA87B" => '&#32922;',
	"\xA87C" => '&#32946;',
	"\xA87D" => '&#33391;',
	"\xA87E" => '&#33426;',
	"\xA8A1" => '&#33419;',
	"\xA8A2" => '&#33421;',
	"\xA8A3" => '&#35211;',
	"\xA8A4" => '&#35282;',
	"\xA8A5" => '&#35328;',
	"\xA8A6" => '&#35895;',
	"\xA8A7" => '&#35910;',
	"\xA8A8" => '&#35925;',
	"\xA8A9" => '&#35997;',
	"\xA8AA" => '&#36196;',
	"\xA8AB" => '&#36208;',
	"\xA8AC" => '&#36275;',
	"\xA8AD" => '&#36523;',
	"\xA8AE" => '&#36554;',
	"\xA8AF" => '&#36763;',
	"\xA8B0" => '&#36784;',
	"\xA8B1" => '&#36802;',
	"\xA8B2" => '&#36806;',
	"\xA8B3" => '&#36805;',
	"\xA8B4" => '&#36804;',
	"\xA8B5" => '&#24033;',
	"\xA8B6" => '&#37009;',
	"\xA8B7" => '&#37026;',
	"\xA8B8" => '&#37034;',
	"\xA8B9" => '&#37030;',
	"\xA8BA" => '&#37027;',
	"\xA8BB" => '&#37193;',
	"\xA8BC" => '&#37318;',
	"\xA8BD" => '&#37324;',
	"\xA8BE" => '&#38450;',
	"\xA8BF" => '&#38446;',
	"\xA8C0" => '&#38449;',
	"\xA8C1" => '&#38442;',
	"\xA8C2" => '&#38444;',
	"\xA8C3" => '&#20006;',
	"\xA8C4" => '&#20054;',
	"\xA8C5" => '&#20083;',
	"\xA8C6" => '&#20107;',
	"\xA8C7" => '&#20123;',
	"\xA8C8" => '&#20126;',
	"\xA8C9" => '&#20139;',
	"\xA8CA" => '&#20140;',
	"\xA8CB" => '&#20335;',
	"\xA8CC" => '&#20381;',
	"\xA8CD" => '&#20365;',
	"\xA8CE" => '&#20339;',
	"\xA8CF" => '&#20351;',
	"\xA8D0" => '&#20332;',
	"\xA8D1" => '&#20379;',
	"\xA8D2" => '&#20363;',
	"\xA8D3" => '&#20358;',
	"\xA8D4" => '&#20355;',
	"\xA8D5" => '&#20336;',
	"\xA8D6" => '&#20341;',
	"\xA8D7" => '&#20360;',
	"\xA8D8" => '&#20329;',
	"\xA8D9" => '&#20347;',
	"\xA8DA" => '&#20374;',
	"\xA8DB" => '&#20350;',
	"\xA8DC" => '&#20367;',
	"\xA8DD" => '&#20369;',
	"\xA8DE" => '&#20346;',
	"\xA8DF" => '&#20820;',
	"\xA8E0" => '&#20818;',
	"\xA8E1" => '&#20821;',
	"\xA8E2" => '&#20841;',
	"\xA8E3" => '&#20855;',
	"\xA8E4" => '&#20854;',
	"\xA8E5" => '&#20856;',
	"\xA8E6" => '&#20925;',
	"\xA8E7" => '&#20989;',
	"\xA8E8" => '&#21051;',
	"\xA8E9" => '&#21048;',
	"\xA8EA" => '&#21047;',
	"\xA8EB" => '&#21050;',
	"\xA8EC" => '&#21040;',
	"\xA8ED" => '&#21038;',
	"\xA8EE" => '&#21046;',
	"\xA8EF" => '&#21057;',
	"\xA8F0" => '&#21182;',
	"\xA8F1" => '&#21179;',
	"\xA8F2" => '&#21330;',
	"\xA8F3" => '&#21332;',
	"\xA8F4" => '&#21331;',
	"\xA8F5" => '&#21329;',
	"\xA8F6" => '&#21350;',
	"\xA8F7" => '&#21367;',
	"\xA8F8" => '&#21368;',
	"\xA8F9" => '&#21369;',
	"\xA8FA" => '&#21462;',
	"\xA8FB" => '&#21460;',
	"\xA8FC" => '&#21463;',
	"\xA8FD" => '&#21619;',
	"\xA8FE" => '&#21621;',
	"\xA940" => '&#21654;',
	"\xA941" => '&#21624;',
	"\xA942" => '&#21653;',
	"\xA943" => '&#21632;',
	"\xA944" => '&#21627;',
	"\xA945" => '&#21623;',
	"\xA946" => '&#21636;',
	"\xA947" => '&#21650;',
	"\xA948" => '&#21638;',
	"\xA949" => '&#21628;',
	"\xA94A" => '&#21648;',
	"\xA94B" => '&#21617;',
	"\xA94C" => '&#21622;',
	"\xA94D" => '&#21644;',
	"\xA94E" => '&#21658;',
	"\xA94F" => '&#21602;',
	"\xA950" => '&#21608;',
	"\xA951" => '&#21643;',
	"\xA952" => '&#21629;',
	"\xA953" => '&#21646;',
	"\xA954" => '&#22266;',
	"\xA955" => '&#22403;',
	"\xA956" => '&#22391;',
	"\xA957" => '&#22378;',
	"\xA958" => '&#22377;',
	"\xA959" => '&#22369;',
	"\xA95A" => '&#22374;',
	"\xA95B" => '&#22372;',
	"\xA95C" => '&#22396;',
	"\xA95D" => '&#22812;',
	"\xA95E" => '&#22857;',
	"\xA95F" => '&#22855;',
	"\xA960" => '&#22856;',
	"\xA961" => '&#22852;',
	"\xA962" => '&#22868;',
	"\xA963" => '&#22974;',
	"\xA964" => '&#22971;',
	"\xA965" => '&#22996;',
	"\xA966" => '&#22969;',
	"\xA967" => '&#22958;',
	"\xA968" => '&#22993;',
	"\xA969" => '&#22982;',
	"\xA96A" => '&#22992;',
	"\xA96B" => '&#22989;',
	"\xA96C" => '&#22987;',
	"\xA96D" => '&#22995;',
	"\xA96E" => '&#22986;',
	"\xA96F" => '&#22959;',
	"\xA970" => '&#22963;',
	"\xA971" => '&#22994;',
	"\xA972" => '&#22981;',
	"\xA973" => '&#23391;',
	"\xA974" => '&#23396;',
	"\xA975" => '&#23395;',
	"\xA976" => '&#23447;',
	"\xA977" => '&#23450;',
	"\xA978" => '&#23448;',
	"\xA979" => '&#23452;',
	"\xA97A" => '&#23449;',
	"\xA97B" => '&#23451;',
	"\xA97C" => '&#23578;',
	"\xA97D" => '&#23624;',
	"\xA97E" => '&#23621;',
	"\xA9A1" => '&#23622;',
	"\xA9A2" => '&#23735;',
	"\xA9A3" => '&#23713;',
	"\xA9A4" => '&#23736;',
	"\xA9A5" => '&#23721;',
	"\xA9A6" => '&#23723;',
	"\xA9A7" => '&#23729;',
	"\xA9A8" => '&#23731;',
	"\xA9A9" => '&#24088;',
	"\xA9AA" => '&#24090;',
	"\xA9AB" => '&#24086;',
	"\xA9AC" => '&#24085;',
	"\xA9AD" => '&#24091;',
	"\xA9AE" => '&#24081;',
	"\xA9AF" => '&#24184;',
	"\xA9B0" => '&#24218;',
	"\xA9B1" => '&#24215;',
	"\xA9B2" => '&#24220;',
	"\xA9B3" => '&#24213;',
	"\xA9B4" => '&#24214;',
	"\xA9B5" => '&#24310;',
	"\xA9B6" => '&#24358;',
	"\xA9B7" => '&#24359;',
	"\xA9B8" => '&#24361;',
	"\xA9B9" => '&#24448;',
	"\xA9BA" => '&#24449;',
	"\xA9BB" => '&#24447;',
	"\xA9BC" => '&#24444;',
	"\xA9BD" => '&#24541;',
	"\xA9BE" => '&#24544;',
	"\xA9BF" => '&#24573;',
	"\xA9C0" => '&#24565;',
	"\xA9C1" => '&#24575;',
	"\xA9C2" => '&#24591;',
	"\xA9C3" => '&#24596;',
	"\xA9C4" => '&#24623;',
	"\xA9C5" => '&#24629;',
	"\xA9C6" => '&#24598;',
	"\xA9C7" => '&#24618;',
	"\xA9C8" => '&#24597;',
	"\xA9C9" => '&#24609;',
	"\xA9CA" => '&#24615;',
	"\xA9CB" => '&#24617;',
	"\xA9CC" => '&#24619;',
	"\xA9CD" => '&#24603;',
	"\xA9CE" => '&#25110;',
	"\xA9CF" => '&#25109;',
	"\xA9D0" => '&#25151;',
	"\xA9D1" => '&#25150;',
	"\xA9D2" => '&#25152;',
	"\xA9D3" => '&#25215;',
	"\xA9D4" => '&#25289;',
	"\xA9D5" => '&#25292;',
	"\xA9D6" => '&#25284;',
	"\xA9D7" => '&#25279;',
	"\xA9D8" => '&#25282;',
	"\xA9D9" => '&#25273;',
	"\xA9DA" => '&#25298;',
	"\xA9DB" => '&#25307;',
	"\xA9DC" => '&#25259;',
	"\xA9DD" => '&#25299;',
	"\xA9DE" => '&#25300;',
	"\xA9DF" => '&#25291;',
	"\xA9E0" => '&#25288;',
	"\xA9E1" => '&#25256;',
	"\xA9E2" => '&#25277;',
	"\xA9E3" => '&#25276;',
	"\xA9E4" => '&#25296;',
	"\xA9E5" => '&#25305;',
	"\xA9E6" => '&#25287;',
	"\xA9E7" => '&#25293;',
	"\xA9E8" => '&#25269;',
	"\xA9E9" => '&#25306;',
	"\xA9EA" => '&#25265;',
	"\xA9EB" => '&#25304;',
	"\xA9EC" => '&#25302;',
	"\xA9ED" => '&#25303;',
	"\xA9EE" => '&#25286;',
	"\xA9EF" => '&#25260;',
	"\xA9F0" => '&#25294;',
	"\xA9F1" => '&#25918;',
	"\xA9F2" => '&#26023;',
	"\xA9F3" => '&#26044;',
	"\xA9F4" => '&#26106;',
	"\xA9F5" => '&#26132;',
	"\xA9F6" => '&#26131;',
	"\xA9F7" => '&#26124;',
	"\xA9F8" => '&#26118;',
	"\xA9F9" => '&#26114;',
	"\xA9FA" => '&#26126;',
	"\xA9FB" => '&#26112;',
	"\xA9FC" => '&#26127;',
	"\xA9FD" => '&#26133;',
	"\xA9FE" => '&#26122;',
	"\xAA40" => '&#26119;',
	"\xAA41" => '&#26381;',
	"\xAA42" => '&#26379;',
	"\xAA43" => '&#26477;',
	"\xAA44" => '&#26507;',
	"\xAA45" => '&#26517;',
	"\xAA46" => '&#26481;',
	"\xAA47" => '&#26524;',
	"\xAA48" => '&#26483;',
	"\xAA49" => '&#26487;',
	"\xAA4A" => '&#26503;',
	"\xAA4B" => '&#26525;',
	"\xAA4C" => '&#26519;',
	"\xAA4D" => '&#26479;',
	"\xAA4E" => '&#26480;',
	"\xAA4F" => '&#26495;',
	"\xAA50" => '&#26505;',
	"\xAA51" => '&#26494;',
	"\xAA52" => '&#26512;',
	"\xAA53" => '&#26485;',
	"\xAA54" => '&#26522;',
	"\xAA55" => '&#26515;',
	"\xAA56" => '&#26492;',
	"\xAA57" => '&#26474;',
	"\xAA58" => '&#26482;',
	"\xAA59" => '&#27427;',
	"\xAA5A" => '&#27494;',
	"\xAA5B" => '&#27495;',
	"\xAA5C" => '&#27519;',
	"\xAA5D" => '&#27667;',
	"\xAA5E" => '&#27675;',
	"\xAA5F" => '&#27875;',
	"\xAA60" => '&#27880;',
	"\xAA61" => '&#27891;',
	"\xAA62" => '&#27825;',
	"\xAA63" => '&#27852;',
	"\xAA64" => '&#27877;',
	"\xAA65" => '&#27827;',
	"\xAA66" => '&#27837;',
	"\xAA67" => '&#27838;',
	"\xAA68" => '&#27836;',
	"\xAA69" => '&#27874;',
	"\xAA6A" => '&#27819;',
	"\xAA6B" => '&#27861;',
	"\xAA6C" => '&#27859;',
	"\xAA6D" => '&#27832;',
	"\xAA6E" => '&#27844;',
	"\xAA6F" => '&#27833;',
	"\xAA70" => '&#27841;',
	"\xAA71" => '&#27822;',
	"\xAA72" => '&#27863;',
	"\xAA73" => '&#27845;',
	"\xAA74" => '&#27889;',
	"\xAA75" => '&#27839;',
	"\xAA76" => '&#27835;',
	"\xAA77" => '&#27873;',
	"\xAA78" => '&#27867;',
	"\xAA79" => '&#27850;',
	"\xAA7A" => '&#27820;',
	"\xAA7B" => '&#27887;',
	"\xAA7C" => '&#27868;',
	"\xAA7D" => '&#27862;',
	"\xAA7E" => '&#27872;',
	"\xAAA1" => '&#28821;',
	"\xAAA2" => '&#28814;',
	"\xAAA3" => '&#28818;',
	"\xAAA4" => '&#28810;',
	"\xAAA5" => '&#28825;',
	"\xAAA6" => '&#29228;',
	"\xAAA7" => '&#29229;',
	"\xAAA8" => '&#29240;',
	"\xAAA9" => '&#29256;',
	"\xAAAA" => '&#29287;',
	"\xAAAB" => '&#29289;',
	"\xAAAC" => '&#29376;',
	"\xAAAD" => '&#29390;',
	"\xAAAE" => '&#29401;',
	"\xAAAF" => '&#29399;',
	"\xAAB0" => '&#29392;',
	"\xAAB1" => '&#29609;',
	"\xAAB2" => '&#29608;',
	"\xAAB3" => '&#29599;',
	"\xAAB4" => '&#29611;',
	"\xAAB5" => '&#29605;',
	"\xAAB6" => '&#30013;',
	"\xAAB7" => '&#30109;',
	"\xAAB8" => '&#30105;',
	"\xAAB9" => '&#30106;',
	"\xAABA" => '&#30340;',
	"\xAABB" => '&#30402;',
	"\xAABC" => '&#30450;',
	"\xAABD" => '&#30452;',
	"\xAABE" => '&#30693;',
	"\xAABF" => '&#30717;',
	"\xAAC0" => '&#31038;',
	"\xAAC1" => '&#31040;',
	"\xAAC2" => '&#31041;',
	"\xAAC3" => '&#31177;',
	"\xAAC4" => '&#31176;',
	"\xAAC5" => '&#31354;',
	"\xAAC6" => '&#31353;',
	"\xAAC7" => '&#31482;',
	"\xAAC8" => '&#31998;',
	"\xAAC9" => '&#32596;',
	"\xAACA" => '&#32652;',
	"\xAACB" => '&#32651;',
	"\xAACC" => '&#32773;',
	"\xAACD" => '&#32954;',
	"\xAACE" => '&#32933;',
	"\xAACF" => '&#32930;',
	"\xAAD0" => '&#32945;',
	"\xAAD1" => '&#32929;',
	"\xAAD2" => '&#32939;',
	"\xAAD3" => '&#32937;',
	"\xAAD4" => '&#32948;',
	"\xAAD5" => '&#32938;',
	"\xAAD6" => '&#32943;',
	"\xAAD7" => '&#33253;',
	"\xAAD8" => '&#33278;',
	"\xAAD9" => '&#33293;',
	"\xAADA" => '&#33459;',
	"\xAADB" => '&#33437;',
	"\xAADC" => '&#33433;',
	"\xAADD" => '&#33453;',
	"\xAADE" => '&#33469;',
	"\xAADF" => '&#33439;',
	"\xAAE0" => '&#33465;',
	"\xAAE1" => '&#33457;',
	"\xAAE2" => '&#33452;',
	"\xAAE3" => '&#33445;',
	"\xAAE4" => '&#33455;',
	"\xAAE5" => '&#33464;',
	"\xAAE6" => '&#33443;',
	"\xAAE7" => '&#33456;',
	"\xAAE8" => '&#33470;',
	"\xAAE9" => '&#33463;',
	"\xAAEA" => '&#34382;',
	"\xAAEB" => '&#34417;',
	"\xAAEC" => '&#21021;',
	"\xAAED" => '&#34920;',
	"\xAAEE" => '&#36555;',
	"\xAAEF" => '&#36814;',
	"\xAAF0" => '&#36820;',
	"\xAAF1" => '&#36817;',
	"\xAAF2" => '&#37045;',
	"\xAAF3" => '&#37048;',
	"\xAAF4" => '&#37041;',
	"\xAAF5" => '&#37046;',
	"\xAAF6" => '&#37319;',
	"\xAAF7" => '&#37329;',
	"\xAAF8" => '&#38263;',
	"\xAAF9" => '&#38272;',
	"\xAAFA" => '&#38428;',
	"\xAAFB" => '&#38464;',
	"\xAAFC" => '&#38463;',
	"\xAAFD" => '&#38459;',
	"\xAAFE" => '&#38468;',
	"\xAB40" => '&#38466;',
	"\xAB41" => '&#38585;',
	"\xAB42" => '&#38632;',
	"\xAB43" => '&#38738;',
	"\xAB44" => '&#38750;',
	"\xAB45" => '&#20127;',
	"\xAB46" => '&#20141;',
	"\xAB47" => '&#20142;',
	"\xAB48" => '&#20449;',
	"\xAB49" => '&#20405;',
	"\xAB4A" => '&#20399;',
	"\xAB4B" => '&#20415;',
	"\xAB4C" => '&#20448;',
	"\xAB4D" => '&#20433;',
	"\xAB4E" => '&#20431;',
	"\xAB4F" => '&#20445;',
	"\xAB50" => '&#20419;',
	"\xAB51" => '&#20406;',
	"\xAB52" => '&#20440;',
	"\xAB53" => '&#20447;',
	"\xAB54" => '&#20426;',
	"\xAB55" => '&#20439;',
	"\xAB56" => '&#20398;',
	"\xAB57" => '&#20432;',
	"\xAB58" => '&#20420;',
	"\xAB59" => '&#20418;',
	"\xAB5A" => '&#20442;',
	"\xAB5B" => '&#20430;',
	"\xAB5C" => '&#20446;',
	"\xAB5D" => '&#20407;',
	"\xAB5E" => '&#20823;',
	"\xAB5F" => '&#20882;',
	"\xAB60" => '&#20881;',
	"\xAB61" => '&#20896;',
	"\xAB62" => '&#21070;',
	"\xAB63" => '&#21059;',
	"\xAB64" => '&#21066;',
	"\xAB65" => '&#21069;',
	"\xAB66" => '&#21068;',
	"\xAB67" => '&#21067;',
	"\xAB68" => '&#21063;',
	"\xAB69" => '&#21191;',
	"\xAB6A" => '&#21193;',
	"\xAB6B" => '&#21187;',
	"\xAB6C" => '&#21185;',
	"\xAB6D" => '&#21261;',
	"\xAB6E" => '&#21335;',
	"\xAB6F" => '&#21371;',
	"\xAB70" => '&#21402;',
	"\xAB71" => '&#21467;',
	"\xAB72" => '&#21676;',
	"\xAB73" => '&#21696;',
	"\xAB74" => '&#21672;',
	"\xAB75" => '&#21710;',
	"\xAB76" => '&#21705;',
	"\xAB77" => '&#21688;',
	"\xAB78" => '&#21670;',
	"\xAB79" => '&#21683;',
	"\xAB7A" => '&#21703;',
	"\xAB7B" => '&#21698;',
	"\xAB7C" => '&#21693;',
	"\xAB7D" => '&#21674;',
	"\xAB7E" => '&#21697;',
	"\xABA1" => '&#21700;',
	"\xABA2" => '&#21704;',
	"\xABA3" => '&#21679;',
	"\xABA4" => '&#21675;',
	"\xABA5" => '&#21681;',
	"\xABA6" => '&#21691;',
	"\xABA7" => '&#21673;',
	"\xABA8" => '&#21671;',
	"\xABA9" => '&#21695;',
	"\xABAA" => '&#22271;',
	"\xABAB" => '&#22402;',
	"\xABAC" => '&#22411;',
	"\xABAD" => '&#22432;',
	"\xABAE" => '&#22435;',
	"\xABAF" => '&#22434;',
	"\xABB0" => '&#22478;',
	"\xABB1" => '&#22446;',
	"\xABB2" => '&#22419;',
	"\xABB3" => '&#22869;',
	"\xABB4" => '&#22865;',
	"\xABB5" => '&#22863;',
	"\xABB6" => '&#22862;',
	"\xABB7" => '&#22864;',
	"\xABB8" => '&#23004;',
	"\xABB9" => '&#23000;',
	"\xABBA" => '&#23039;',
	"\xABBB" => '&#23011;',
	"\xABBC" => '&#23016;',
	"\xABBD" => '&#23043;',
	"\xABBE" => '&#23013;',
	"\xABBF" => '&#23018;',
	"\xABC0" => '&#23002;',
	"\xABC1" => '&#23014;',
	"\xABC2" => '&#23041;',
	"\xABC3" => '&#23035;',
	"\xABC4" => '&#23401;',
	"\xABC5" => '&#23459;',
	"\xABC6" => '&#23462;',
	"\xABC7" => '&#23460;',
	"\xABC8" => '&#23458;',
	"\xABC9" => '&#23461;',
	"\xABCA" => '&#23553;',
	"\xABCB" => '&#23630;',
	"\xABCC" => '&#23631;',
	"\xABCD" => '&#23629;',
	"\xABCE" => '&#23627;',
	"\xABCF" => '&#23769;',
	"\xABD0" => '&#23762;',
	"\xABD1" => '&#24055;',
	"\xABD2" => '&#24093;',
	"\xABD3" => '&#24101;',
	"\xABD4" => '&#24095;',
	"\xABD5" => '&#24189;',
	"\xABD6" => '&#24224;',
	"\xABD7" => '&#24230;',
	"\xABD8" => '&#24314;',
	"\xABD9" => '&#24328;',
	"\xABDA" => '&#24365;',
	"\xABDB" => '&#24421;',
	"\xABDC" => '&#24456;',
	"\xABDD" => '&#24453;',
	"\xABDE" => '&#24458;',
	"\xABDF" => '&#24459;',
	"\xABE0" => '&#24455;',
	"\xABE1" => '&#24460;',
	"\xABE2" => '&#24457;',
	"\xABE3" => '&#24594;',
	"\xABE4" => '&#24605;',
	"\xABE5" => '&#24608;',
	"\xABE6" => '&#24613;',
	"\xABE7" => '&#24590;',
	"\xABE8" => '&#24616;',
	"\xABE9" => '&#24653;',
	"\xABEA" => '&#24688;',
	"\xABEB" => '&#24680;',
	"\xABEC" => '&#24674;',
	"\xABED" => '&#24646;',
	"\xABEE" => '&#24643;',
	"\xABEF" => '&#24684;',
	"\xABF0" => '&#24683;',
	"\xABF1" => '&#24682;',
	"\xABF2" => '&#24676;',
	"\xABF3" => '&#25153;',
	"\xABF4" => '&#25308;',
	"\xABF5" => '&#25366;',
	"\xABF6" => '&#25353;',
	"\xABF7" => '&#25340;',
	"\xABF8" => '&#25325;',
	"\xABF9" => '&#25345;',
	"\xABFA" => '&#25326;',
	"\xABFB" => '&#25341;',
	"\xABFC" => '&#25351;',
	"\xABFD" => '&#25329;',
	"\xABFE" => '&#25335;',
	"\xAC40" => '&#25327;',
	"\xAC41" => '&#25324;',
	"\xAC42" => '&#25342;',
	"\xAC43" => '&#25332;',
	"\xAC44" => '&#25361;',
	"\xAC45" => '&#25346;',
	"\xAC46" => '&#25919;',
	"\xAC47" => '&#25925;',
	"\xAC48" => '&#26027;',
	"\xAC49" => '&#26045;',
	"\xAC4A" => '&#26082;',
	"\xAC4B" => '&#26149;',
	"\xAC4C" => '&#26157;',
	"\xAC4D" => '&#26144;',
	"\xAC4E" => '&#26151;',
	"\xAC4F" => '&#26159;',
	"\xAC50" => '&#26143;',
	"\xAC51" => '&#26152;',
	"\xAC52" => '&#26161;',
	"\xAC53" => '&#26148;',
	"\xAC54" => '&#26359;',
	"\xAC55" => '&#26623;',
	"\xAC56" => '&#26579;',
	"\xAC57" => '&#26609;',
	"\xAC58" => '&#26580;',
	"\xAC59" => '&#26576;',
	"\xAC5A" => '&#26604;',
	"\xAC5B" => '&#26550;',
	"\xAC5C" => '&#26543;',
	"\xAC5D" => '&#26613;',
	"\xAC5E" => '&#26601;',
	"\xAC5F" => '&#26607;',
	"\xAC60" => '&#26564;',
	"\xAC61" => '&#26577;',
	"\xAC62" => '&#26548;',
	"\xAC63" => '&#26586;',
	"\xAC64" => '&#26597;',
	"\xAC65" => '&#26552;',
	"\xAC66" => '&#26575;',
	"\xAC67" => '&#26590;',
	"\xAC68" => '&#26611;',
	"\xAC69" => '&#26544;',
	"\xAC6A" => '&#26585;',
	"\xAC6B" => '&#26594;',
	"\xAC6C" => '&#26589;',
	"\xAC6D" => '&#26578;',
	"\xAC6E" => '&#27498;',
	"\xAC6F" => '&#27523;',
	"\xAC70" => '&#27526;',
	"\xAC71" => '&#27573;',
	"\xAC72" => '&#27602;',
	"\xAC73" => '&#27607;',
	"\xAC74" => '&#27679;',
	"\xAC75" => '&#27849;',
	"\xAC76" => '&#27915;',
	"\xAC77" => '&#27954;',
	"\xAC78" => '&#27946;',
	"\xAC79" => '&#27969;',
	"\xAC7A" => '&#27941;',
	"\xAC7B" => '&#27916;',
	"\xAC7C" => '&#27953;',
	"\xAC7D" => '&#27934;',
	"\xAC7E" => '&#27927;',
	"\xACA1" => '&#27963;',
	"\xACA2" => '&#27965;',
	"\xACA3" => '&#27966;',
	"\xACA4" => '&#27958;',
	"\xACA5" => '&#27931;',
	"\xACA6" => '&#27893;',
	"\xACA7" => '&#27961;',
	"\xACA8" => '&#27943;',
	"\xACA9" => '&#27960;',
	"\xACAA" => '&#27945;',
	"\xACAB" => '&#27950;',
	"\xACAC" => '&#27957;',
	"\xACAD" => '&#27918;',
	"\xACAE" => '&#27947;',
	"\xACAF" => '&#28843;',
	"\xACB0" => '&#28858;',
	"\xACB1" => '&#28851;',
	"\xACB2" => '&#28844;',
	"\xACB3" => '&#28847;',
	"\xACB4" => '&#28845;',
	"\xACB5" => '&#28856;',
	"\xACB6" => '&#28846;',
	"\xACB7" => '&#28836;',
	"\xACB8" => '&#29232;',
	"\xACB9" => '&#29298;',
	"\xACBA" => '&#29295;',
	"\xACBB" => '&#29300;',
	"\xACBC" => '&#29417;',
	"\xACBD" => '&#29408;',
	"\xACBE" => '&#29409;',
	"\xACBF" => '&#29623;',
	"\xACC0" => '&#29642;',
	"\xACC1" => '&#29627;',
	"\xACC2" => '&#29618;',
	"\xACC3" => '&#29645;',
	"\xACC4" => '&#29632;',
	"\xACC5" => '&#29619;',
	"\xACC6" => '&#29978;',
	"\xACC7" => '&#29997;',
	"\xACC8" => '&#30031;',
	"\xACC9" => '&#30028;',
	"\xACCA" => '&#30030;',
	"\xACCB" => '&#30027;',
	"\xACCC" => '&#30123;',
	"\xACCD" => '&#30116;',
	"\xACCE" => '&#30117;',
	"\xACCF" => '&#30114;',
	"\xACD0" => '&#30115;',
	"\xACD1" => '&#30328;',
	"\xACD2" => '&#30342;',
	"\xACD3" => '&#30343;',
	"\xACD4" => '&#30344;',
	"\xACD5" => '&#30408;',
	"\xACD6" => '&#30406;',
	"\xACD7" => '&#30403;',
	"\xACD8" => '&#30405;',
	"\xACD9" => '&#30465;',
	"\xACDA" => '&#30457;',
	"\xACDB" => '&#30456;',
	"\xACDC" => '&#30473;',
	"\xACDD" => '&#30475;',
	"\xACDE" => '&#30462;',
	"\xACDF" => '&#30460;',
	"\xACE0" => '&#30471;',
	"\xACE1" => '&#30684;',
	"\xACE2" => '&#30722;',
	"\xACE3" => '&#30740;',
	"\xACE4" => '&#30732;',
	"\xACE5" => '&#30733;',
	"\xACE6" => '&#31046;',
	"\xACE7" => '&#31049;',
	"\xACE8" => '&#31048;',
	"\xACE9" => '&#31047;',
	"\xACEA" => '&#31161;',
	"\xACEB" => '&#31162;',
	"\xACEC" => '&#31185;',
	"\xACED" => '&#31186;',
	"\xACEE" => '&#31179;',
	"\xACEF" => '&#31359;',
	"\xACF0" => '&#31361;',
	"\xACF1" => '&#31487;',
	"\xACF2" => '&#31485;',
	"\xACF3" => '&#31869;',
	"\xACF4" => '&#32002;',
	"\xACF5" => '&#32005;',
	"\xACF6" => '&#32000;',
	"\xACF7" => '&#32009;',
	"\xACF8" => '&#32007;',
	"\xACF9" => '&#32004;',
	"\xACFA" => '&#32006;',
	"\xACFB" => '&#32568;',
	"\xACFC" => '&#32654;',
	"\xACFD" => '&#32703;',
	"\xACFE" => '&#32772;',
	"\xAD40" => '&#32784;',
	"\xAD41" => '&#32781;',
	"\xAD42" => '&#32785;',
	"\xAD43" => '&#32822;',
	"\xAD44" => '&#32982;',
	"\xAD45" => '&#32997;',
	"\xAD46" => '&#32986;',
	"\xAD47" => '&#32963;',
	"\xAD48" => '&#32964;',
	"\xAD49" => '&#32972;',
	"\xAD4A" => '&#32993;',
	"\xAD4B" => '&#32987;',
	"\xAD4C" => '&#32974;',
	"\xAD4D" => '&#32990;',
	"\xAD4E" => '&#32996;',
	"\xAD4F" => '&#32989;',
	"\xAD50" => '&#33268;',
	"\xAD51" => '&#33314;',
	"\xAD52" => '&#33511;',
	"\xAD53" => '&#33539;',
	"\xAD54" => '&#33541;',
	"\xAD55" => '&#33507;',
	"\xAD56" => '&#33499;',
	"\xAD57" => '&#33510;',
	"\xAD58" => '&#33540;',
	"\xAD59" => '&#33509;',
	"\xAD5A" => '&#33538;',
	"\xAD5B" => '&#33545;',
	"\xAD5C" => '&#33490;',
	"\xAD5D" => '&#33495;',
	"\xAD5E" => '&#33521;',
	"\xAD5F" => '&#33537;',
	"\xAD60" => '&#33500;',
	"\xAD61" => '&#33492;',
	"\xAD62" => '&#33489;',
	"\xAD63" => '&#33502;',
	"\xAD64" => '&#33491;',
	"\xAD65" => '&#33503;',
	"\xAD66" => '&#33519;',
	"\xAD67" => '&#33542;',
	"\xAD68" => '&#34384;',
	"\xAD69" => '&#34425;',
	"\xAD6A" => '&#34427;',
	"\xAD6B" => '&#34426;',
	"\xAD6C" => '&#34893;',
	"\xAD6D" => '&#34923;',
	"\xAD6E" => '&#35201;',
	"\xAD6F" => '&#35284;',
	"\xAD70" => '&#35336;',
	"\xAD71" => '&#35330;',
	"\xAD72" => '&#35331;',
	"\xAD73" => '&#35998;',
	"\xAD74" => '&#36000;',
	"\xAD75" => '&#36212;',
	"\xAD76" => '&#36211;',
	"\xAD77" => '&#36276;',
	"\xAD78" => '&#36557;',
	"\xAD79" => '&#36556;',
	"\xAD7A" => '&#36848;',
	"\xAD7B" => '&#36838;',
	"\xAD7C" => '&#36834;',
	"\xAD7D" => '&#36842;',
	"\xAD7E" => '&#36837;',
	"\xADA1" => '&#36845;',
	"\xADA2" => '&#36843;',
	"\xADA3" => '&#36836;',
	"\xADA4" => '&#36840;',
	"\xADA5" => '&#37066;',
	"\xADA6" => '&#37070;',
	"\xADA7" => '&#37057;',
	"\xADA8" => '&#37059;',
	"\xADA9" => '&#37195;',
	"\xADAA" => '&#37194;',
	"\xADAB" => '&#37325;',
	"\xADAC" => '&#38274;',
	"\xADAD" => '&#38480;',
	"\xADAE" => '&#38475;',
	"\xADAF" => '&#38476;',
	"\xADB0" => '&#38477;',
	"\xADB1" => '&#38754;',
	"\xADB2" => '&#38761;',
	"\xADB3" => '&#38859;',
	"\xADB4" => '&#38893;',
	"\xADB5" => '&#38899;',
	"\xADB6" => '&#38913;',
	"\xADB7" => '&#39080;',
	"\xADB8" => '&#39131;',
	"\xADB9" => '&#39135;',
	"\xADBA" => '&#39318;',
	"\xADBB" => '&#39321;',
	"\xADBC" => '&#20056;',
	"\xADBD" => '&#20147;',
	"\xADBE" => '&#20492;',
	"\xADBF" => '&#20493;',
	"\xADC0" => '&#20515;',
	"\xADC1" => '&#20463;',
	"\xADC2" => '&#20518;',
	"\xADC3" => '&#20517;',
	"\xADC4" => '&#20472;',
	"\xADC5" => '&#20521;',
	"\xADC6" => '&#20502;',
	"\xADC7" => '&#20486;',
	"\xADC8" => '&#20540;',
	"\xADC9" => '&#20511;',
	"\xADCA" => '&#20506;',
	"\xADCB" => '&#20498;',
	"\xADCC" => '&#20497;',
	"\xADCD" => '&#20474;',
	"\xADCE" => '&#20480;',
	"\xADCF" => '&#20500;',
	"\xADD0" => '&#20520;',
	"\xADD1" => '&#20465;',
	"\xADD2" => '&#20513;',
	"\xADD3" => '&#20491;',
	"\xADD4" => '&#20505;',
	"\xADD5" => '&#20504;',
	"\xADD6" => '&#20467;',
	"\xADD7" => '&#20462;',
	"\xADD8" => '&#20525;',
	"\xADD9" => '&#20522;',
	"\xADDA" => '&#20478;',
	"\xADDB" => '&#20523;',
	"\xADDC" => '&#20489;',
	"\xADDD" => '&#20860;',
	"\xADDE" => '&#20900;',
	"\xADDF" => '&#20901;',
	"\xADE0" => '&#20898;',
	"\xADE1" => '&#20941;',
	"\xADE2" => '&#20940;',
	"\xADE3" => '&#20934;',
	"\xADE4" => '&#20939;',
	"\xADE5" => '&#21078;',
	"\xADE6" => '&#21084;',
	"\xADE7" => '&#21076;',
	"\xADE8" => '&#21083;',
	"\xADE9" => '&#21085;',
	"\xADEA" => '&#21290;',
	"\xADEB" => '&#21375;',
	"\xADEC" => '&#21407;',
	"\xADED" => '&#21405;',
	"\xADEE" => '&#21471;',
	"\xADEF" => '&#21736;',
	"\xADF0" => '&#21776;',
	"\xADF1" => '&#21761;',
	"\xADF2" => '&#21815;',
	"\xADF3" => '&#21756;',
	"\xADF4" => '&#21733;',
	"\xADF5" => '&#21746;',
	"\xADF6" => '&#21766;',
	"\xADF7" => '&#21754;',
	"\xADF8" => '&#21780;',
	"\xADF9" => '&#21737;',
	"\xADFA" => '&#21741;',
	"\xADFB" => '&#21729;',
	"\xADFC" => '&#21769;',
	"\xADFD" => '&#21742;',
	"\xADFE" => '&#21738;',
	"\xAE40" => '&#21734;',
	"\xAE41" => '&#21799;',
	"\xAE42" => '&#21767;',
	"\xAE43" => '&#21757;',
	"\xAE44" => '&#21775;',
	"\xAE45" => '&#22275;',
	"\xAE46" => '&#22276;',
	"\xAE47" => '&#22466;',
	"\xAE48" => '&#22484;',
	"\xAE49" => '&#22475;',
	"\xAE4A" => '&#22467;',
	"\xAE4B" => '&#22537;',
	"\xAE4C" => '&#22799;',
	"\xAE4D" => '&#22871;',
	"\xAE4E" => '&#22872;',
	"\xAE4F" => '&#22874;',
	"\xAE50" => '&#23057;',
	"\xAE51" => '&#23064;',
	"\xAE52" => '&#23068;',
	"\xAE53" => '&#23071;',
	"\xAE54" => '&#23067;',
	"\xAE55" => '&#23059;',
	"\xAE56" => '&#23020;',
	"\xAE57" => '&#23072;',
	"\xAE58" => '&#23075;',
	"\xAE59" => '&#23081;',
	"\xAE5A" => '&#23077;',
	"\xAE5B" => '&#23052;',
	"\xAE5C" => '&#23049;',
	"\xAE5D" => '&#23403;',
	"\xAE5E" => '&#23640;',
	"\xAE5F" => '&#23472;',
	"\xAE60" => '&#23475;',
	"\xAE61" => '&#23478;',
	"\xAE62" => '&#23476;',
	"\xAE63" => '&#23470;',
	"\xAE64" => '&#23477;',
	"\xAE65" => '&#23481;',
	"\xAE66" => '&#23480;',
	"\xAE67" => '&#23556;',
	"\xAE68" => '&#23633;',
	"\xAE69" => '&#23637;',
	"\xAE6A" => '&#23632;',
	"\xAE6B" => '&#23789;',
	"\xAE6C" => '&#23805;',
	"\xAE6D" => '&#23803;',
	"\xAE6E" => '&#23786;',
	"\xAE6F" => '&#23784;',
	"\xAE70" => '&#23792;',
	"\xAE71" => '&#23798;',
	"\xAE72" => '&#23809;',
	"\xAE73" => '&#23796;',
	"\xAE74" => '&#24046;',
	"\xAE75" => '&#24109;',
	"\xAE76" => '&#24107;',
	"\xAE77" => '&#24235;',
	"\xAE78" => '&#24237;',
	"\xAE79" => '&#24231;',
	"\xAE7A" => '&#24369;',
	"\xAE7B" => '&#24466;',
	"\xAE7C" => '&#24465;',
	"\xAE7D" => '&#24464;',
	"\xAE7E" => '&#24665;',
	"\xAEA1" => '&#24675;',
	"\xAEA2" => '&#24677;',
	"\xAEA3" => '&#24656;',
	"\xAEA4" => '&#24661;',
	"\xAEA5" => '&#24685;',
	"\xAEA6" => '&#24681;',
	"\xAEA7" => '&#24687;',
	"\xAEA8" => '&#24708;',
	"\xAEA9" => '&#24735;',
	"\xAEAA" => '&#24730;',
	"\xAEAB" => '&#24717;',
	"\xAEAC" => '&#24724;',
	"\xAEAD" => '&#24716;',
	"\xAEAE" => '&#24709;',
	"\xAEAF" => '&#24726;',
	"\xAEB0" => '&#25159;',
	"\xAEB1" => '&#25331;',
	"\xAEB2" => '&#25352;',
	"\xAEB3" => '&#25343;',
	"\xAEB4" => '&#25422;',
	"\xAEB5" => '&#25406;',
	"\xAEB6" => '&#25391;',
	"\xAEB7" => '&#25429;',
	"\xAEB8" => '&#25410;',
	"\xAEB9" => '&#25414;',
	"\xAEBA" => '&#25423;',
	"\xAEBB" => '&#25417;',
	"\xAEBC" => '&#25402;',
	"\xAEBD" => '&#25424;',
	"\xAEBE" => '&#25405;',
	"\xAEBF" => '&#25386;',
	"\xAEC0" => '&#25387;',
	"\xAEC1" => '&#25384;',
	"\xAEC2" => '&#25421;',
	"\xAEC3" => '&#25420;',
	"\xAEC4" => '&#25928;',
	"\xAEC5" => '&#25929;',
	"\xAEC6" => '&#26009;',
	"\xAEC7" => '&#26049;',
	"\xAEC8" => '&#26053;',
	"\xAEC9" => '&#26178;',
	"\xAECA" => '&#26185;',
	"\xAECB" => '&#26191;',
	"\xAECC" => '&#26179;',
	"\xAECD" => '&#26194;',
	"\xAECE" => '&#26188;',
	"\xAECF" => '&#26181;',
	"\xAED0" => '&#26177;',
	"\xAED1" => '&#26360;',
	"\xAED2" => '&#26388;',
	"\xAED3" => '&#26389;',
	"\xAED4" => '&#26391;',
	"\xAED5" => '&#26657;',
	"\xAED6" => '&#26680;',
	"\xAED7" => '&#26696;',
	"\xAED8" => '&#26694;',
	"\xAED9" => '&#26707;',
	"\xAEDA" => '&#26681;',
	"\xAEDB" => '&#26690;',
	"\xAEDC" => '&#26708;',
	"\xAEDD" => '&#26665;',
	"\xAEDE" => '&#26803;',
	"\xAEDF" => '&#26647;',
	"\xAEE0" => '&#26700;',
	"\xAEE1" => '&#26705;',
	"\xAEE2" => '&#26685;',
	"\xAEE3" => '&#26612;',
	"\xAEE4" => '&#26704;',
	"\xAEE5" => '&#26688;',
	"\xAEE6" => '&#26684;',
	"\xAEE7" => '&#26691;',
	"\xAEE8" => '&#26666;',
	"\xAEE9" => '&#26693;',
	"\xAEEA" => '&#26643;',
	"\xAEEB" => '&#26648;',
	"\xAEEC" => '&#26689;',
	"\xAEED" => '&#27530;',
	"\xAEEE" => '&#27529;',
	"\xAEEF" => '&#27575;',
	"\xAEF0" => '&#27683;',
	"\xAEF1" => '&#27687;',
	"\xAEF2" => '&#27688;',
	"\xAEF3" => '&#27686;',
	"\xAEF4" => '&#27684;',
	"\xAEF5" => '&#27888;',
	"\xAEF6" => '&#28010;',
	"\xAEF7" => '&#28053;',
	"\xAEF8" => '&#28040;',
	"\xAEF9" => '&#28039;',
	"\xAEFA" => '&#28006;',
	"\xAEFB" => '&#28024;',
	"\xAEFC" => '&#28023;',
	"\xAEFD" => '&#27993;',
	"\xAEFE" => '&#28051;',
	"\xAF40" => '&#28012;',
	"\xAF41" => '&#28041;',
	"\xAF42" => '&#28014;',
	"\xAF43" => '&#27994;',
	"\xAF44" => '&#28020;',
	"\xAF45" => '&#28009;',
	"\xAF46" => '&#28044;',
	"\xAF47" => '&#28042;',
	"\xAF48" => '&#28025;',
	"\xAF49" => '&#28037;',
	"\xAF4A" => '&#28005;',
	"\xAF4B" => '&#28052;',
	"\xAF4C" => '&#28874;',
	"\xAF4D" => '&#28888;',
	"\xAF4E" => '&#28900;',
	"\xAF4F" => '&#28889;',
	"\xAF50" => '&#28872;',
	"\xAF51" => '&#28879;',
	"\xAF52" => '&#29241;',
	"\xAF53" => '&#29305;',
	"\xAF54" => '&#29436;',
	"\xAF55" => '&#29433;',
	"\xAF56" => '&#29437;',
	"\xAF57" => '&#29432;',
	"\xAF58" => '&#29431;',
	"\xAF59" => '&#29574;',
	"\xAF5A" => '&#29677;',
	"\xAF5B" => '&#29705;',
	"\xAF5C" => '&#29678;',
	"\xAF5D" => '&#29664;',
	"\xAF5E" => '&#29674;',
	"\xAF5F" => '&#29662;',
	"\xAF60" => '&#30036;',
	"\xAF61" => '&#30045;',
	"\xAF62" => '&#30044;',
	"\xAF63" => '&#30042;',
	"\xAF64" => '&#30041;',
	"\xAF65" => '&#30142;',
	"\xAF66" => '&#30149;',
	"\xAF67" => '&#30151;',
	"\xAF68" => '&#30130;',
	"\xAF69" => '&#30131;',
	"\xAF6A" => '&#30141;',
	"\xAF6B" => '&#30140;',
	"\xAF6C" => '&#30137;',
	"\xAF6D" => '&#30146;',
	"\xAF6E" => '&#30136;',
	"\xAF6F" => '&#30347;',
	"\xAF70" => '&#30384;',
	"\xAF71" => '&#30410;',
	"\xAF72" => '&#30413;',
	"\xAF73" => '&#30414;',
	"\xAF74" => '&#30505;',
	"\xAF75" => '&#30495;',
	"\xAF76" => '&#30496;',
	"\xAF77" => '&#30504;',
	"\xAF78" => '&#30697;',
	"\xAF79" => '&#30768;',
	"\xAF7A" => '&#30759;',
	"\xAF7B" => '&#30776;',
	"\xAF7C" => '&#30749;',
	"\xAF7D" => '&#30772;',
	"\xAF7E" => '&#30775;',
	"\xAFA1" => '&#30757;',
	"\xAFA2" => '&#30765;',
	"\xAFA3" => '&#30752;',
	"\xAFA4" => '&#30751;',
	"\xAFA5" => '&#30770;',
	"\xAFA6" => '&#31061;',
	"\xAFA7" => '&#31056;',
	"\xAFA8" => '&#31072;',
	"\xAFA9" => '&#31071;',
	"\xAFAA" => '&#31062;',
	"\xAFAB" => '&#31070;',
	"\xAFAC" => '&#31069;',
	"\xAFAD" => '&#31063;',
	"\xAFAE" => '&#31066;',
	"\xAFAF" => '&#31204;',
	"\xAFB0" => '&#31203;',
	"\xAFB1" => '&#31207;',
	"\xAFB2" => '&#31199;',
	"\xAFB3" => '&#31206;',
	"\xAFB4" => '&#31209;',
	"\xAFB5" => '&#31192;',
	"\xAFB6" => '&#31364;',
	"\xAFB7" => '&#31368;',
	"\xAFB8" => '&#31449;',
	"\xAFB9" => '&#31494;',
	"\xAFBA" => '&#31505;',
	"\xAFBB" => '&#31881;',
	"\xAFBC" => '&#32033;',
	"\xAFBD" => '&#32023;',
	"\xAFBE" => '&#32011;',
	"\xAFBF" => '&#32010;',
	"\xAFC0" => '&#32032;',
	"\xAFC1" => '&#32034;',
	"\xAFC2" => '&#32020;',
	"\xAFC3" => '&#32016;',
	"\xAFC4" => '&#32021;',
	"\xAFC5" => '&#32026;',
	"\xAFC6" => '&#32028;',
	"\xAFC7" => '&#32013;',
	"\xAFC8" => '&#32025;',
	"\xAFC9" => '&#32027;',
	"\xAFCA" => '&#32570;',
	"\xAFCB" => '&#32607;',
	"\xAFCC" => '&#32660;',
	"\xAFCD" => '&#32709;',
	"\xAFCE" => '&#32705;',
	"\xAFCF" => '&#32774;',
	"\xAFD0" => '&#32792;',
	"\xAFD1" => '&#32789;',
	"\xAFD2" => '&#32793;',
	"\xAFD3" => '&#32791;',
	"\xAFD4" => '&#32829;',
	"\xAFD5" => '&#32831;',
	"\xAFD6" => '&#33009;',
	"\xAFD7" => '&#33026;',
	"\xAFD8" => '&#33008;',
	"\xAFD9" => '&#33029;',
	"\xAFDA" => '&#33005;',
	"\xAFDB" => '&#33012;',
	"\xAFDC" => '&#33030;',
	"\xAFDD" => '&#33016;',
	"\xAFDE" => '&#33011;',
	"\xAFDF" => '&#33032;',
	"\xAFE0" => '&#33021;',
	"\xAFE1" => '&#33034;',
	"\xAFE2" => '&#33020;',
	"\xAFE3" => '&#33007;',
	"\xAFE4" => '&#33261;',
	"\xAFE5" => '&#33260;',
	"\xAFE6" => '&#33280;',
	"\xAFE7" => '&#33296;',
	"\xAFE8" => '&#33322;',
	"\xAFE9" => '&#33323;',
	"\xAFEA" => '&#33320;',
	"\xAFEB" => '&#33324;',
	"\xAFEC" => '&#33467;',
	"\xAFED" => '&#33579;',
	"\xAFEE" => '&#33618;',
	"\xAFEF" => '&#33620;',
	"\xAFF0" => '&#33610;',
	"\xAFF1" => '&#33592;',
	"\xAFF2" => '&#33616;',
	"\xAFF3" => '&#33609;',
	"\xAFF4" => '&#33589;',
	"\xAFF5" => '&#33588;',
	"\xAFF6" => '&#33615;',
	"\xAFF7" => '&#33586;',
	"\xAFF8" => '&#33593;',
	"\xAFF9" => '&#33590;',
	"\xAFFA" => '&#33559;',
	"\xAFFB" => '&#33600;',
	"\xAFFC" => '&#33585;',
	"\xAFFD" => '&#33576;',
	"\xAFFE" => '&#33603;',
	"\xB040" => '&#34388;',
	"\xB041" => '&#34442;',
	"\xB042" => '&#34474;',
	"\xB043" => '&#34451;',
	"\xB044" => '&#34468;',
	"\xB045" => '&#34473;',
	"\xB046" => '&#34444;',
	"\xB047" => '&#34467;',
	"\xB048" => '&#34460;',
	"\xB049" => '&#34928;',
	"\xB04A" => '&#34935;',
	"\xB04B" => '&#34945;',
	"\xB04C" => '&#34946;',
	"\xB04D" => '&#34941;',
	"\xB04E" => '&#34937;',
	"\xB04F" => '&#35352;',
	"\xB050" => '&#35344;',
	"\xB051" => '&#35342;',
	"\xB052" => '&#35340;',
	"\xB053" => '&#35349;',
	"\xB054" => '&#35338;',
	"\xB055" => '&#35351;',
	"\xB056" => '&#35347;',
	"\xB057" => '&#35350;',
	"\xB058" => '&#35343;',
	"\xB059" => '&#35345;',
	"\xB05A" => '&#35912;',
	"\xB05B" => '&#35962;',
	"\xB05C" => '&#35961;',
	"\xB05D" => '&#36001;',
	"\xB05E" => '&#36002;',
	"\xB05F" => '&#36215;',
	"\xB060" => '&#36524;',
	"\xB061" => '&#36562;',
	"\xB062" => '&#36564;',
	"\xB063" => '&#36559;',
	"\xB064" => '&#36785;',
	"\xB065" => '&#36865;',
	"\xB066" => '&#36870;',
	"\xB067" => '&#36855;',
	"\xB068" => '&#36864;',
	"\xB069" => '&#36858;',
	"\xB06A" => '&#36852;',
	"\xB06B" => '&#36867;',
	"\xB06C" => '&#36861;',
	"\xB06D" => '&#36869;',
	"\xB06E" => '&#36856;',
	"\xB06F" => '&#37013;',
	"\xB070" => '&#37089;',
	"\xB071" => '&#37085;',
	"\xB072" => '&#37090;',
	"\xB073" => '&#37202;',
	"\xB074" => '&#37197;',
	"\xB075" => '&#37196;',
	"\xB076" => '&#37336;',
	"\xB077" => '&#37341;',
	"\xB078" => '&#37335;',
	"\xB079" => '&#37340;',
	"\xB07A" => '&#37337;',
	"\xB07B" => '&#38275;',
	"\xB07C" => '&#38498;',
	"\xB07D" => '&#38499;',
	"\xB07E" => '&#38497;',
	"\xB0A1" => '&#38491;',
	"\xB0A2" => '&#38493;',
	"\xB0A3" => '&#38500;',
	"\xB0A4" => '&#38488;',
	"\xB0A5" => '&#38494;',
	"\xB0A6" => '&#38587;',
	"\xB0A7" => '&#39138;',
	"\xB0A8" => '&#39340;',
	"\xB0A9" => '&#39592;',
	"\xB0AA" => '&#39640;',
	"\xB0AB" => '&#39717;',
	"\xB0AC" => '&#39730;',
	"\xB0AD" => '&#39740;',
	"\xB0AE" => '&#20094;',
	"\xB0AF" => '&#20602;',
	"\xB0B0" => '&#20605;',
	"\xB0B1" => '&#20572;',
	"\xB0B2" => '&#20551;',
	"\xB0B3" => '&#20547;',
	"\xB0B4" => '&#20556;',
	"\xB0B5" => '&#20570;',
	"\xB0B6" => '&#20553;',
	"\xB0B7" => '&#20581;',
	"\xB0B8" => '&#20598;',
	"\xB0B9" => '&#20558;',
	"\xB0BA" => '&#20565;',
	"\xB0BB" => '&#20597;',
	"\xB0BC" => '&#20596;',
	"\xB0BD" => '&#20599;',
	"\xB0BE" => '&#20559;',
	"\xB0BF" => '&#20495;',
	"\xB0C0" => '&#20591;',
	"\xB0C1" => '&#20589;',
	"\xB0C2" => '&#20828;',
	"\xB0C3" => '&#20885;',
	"\xB0C4" => '&#20976;',
	"\xB0C5" => '&#21098;',
	"\xB0C6" => '&#21103;',
	"\xB0C7" => '&#21202;',
	"\xB0C8" => '&#21209;',
	"\xB0C9" => '&#21208;',
	"\xB0CA" => '&#21205;',
	"\xB0CB" => '&#21264;',
	"\xB0CC" => '&#21263;',
	"\xB0CD" => '&#21273;',
	"\xB0CE" => '&#21311;',
	"\xB0CF" => '&#21312;',
	"\xB0D0" => '&#21310;',
	"\xB0D1" => '&#21443;',
	"\xB0D2" => '&#26364;',
	"\xB0D3" => '&#21830;',
	"\xB0D4" => '&#21866;',
	"\xB0D5" => '&#21862;',
	"\xB0D6" => '&#21828;',
	"\xB0D7" => '&#21854;',
	"\xB0D8" => '&#21857;',
	"\xB0D9" => '&#21827;',
	"\xB0DA" => '&#21834;',
	"\xB0DB" => '&#21809;',
	"\xB0DC" => '&#21846;',
	"\xB0DD" => '&#21839;',
	"\xB0DE" => '&#21845;',
	"\xB0DF" => '&#21807;',
	"\xB0E0" => '&#21860;',
	"\xB0E1" => '&#21816;',
	"\xB0E2" => '&#21806;',
	"\xB0E3" => '&#21852;',
	"\xB0E4" => '&#21804;',
	"\xB0E5" => '&#21859;',
	"\xB0E6" => '&#21811;',
	"\xB0E7" => '&#21825;',
	"\xB0E8" => '&#21847;',
	"\xB0E9" => '&#22280;',
	"\xB0EA" => '&#22283;',
	"\xB0EB" => '&#22281;',
	"\xB0EC" => '&#22495;',
	"\xB0ED" => '&#22533;',
	"\xB0EE" => '&#22538;',
	"\xB0EF" => '&#22534;',
	"\xB0F0" => '&#22496;',
	"\xB0F1" => '&#22500;',
	"\xB0F2" => '&#22522;',
	"\xB0F3" => '&#22530;',
	"\xB0F4" => '&#22581;',
	"\xB0F5" => '&#22519;',
	"\xB0F6" => '&#22521;',
	"\xB0F7" => '&#22816;',
	"\xB0F8" => '&#22882;',
	"\xB0F9" => '&#23094;',
	"\xB0FA" => '&#23105;',
	"\xB0FB" => '&#23113;',
	"\xB0FC" => '&#23142;',
	"\xB0FD" => '&#23146;',
	"\xB0FE" => '&#23104;',
	"\xB140" => '&#23100;',
	"\xB141" => '&#23138;',
	"\xB142" => '&#23130;',
	"\xB143" => '&#23110;',
	"\xB144" => '&#23114;',
	"\xB145" => '&#23408;',
	"\xB146" => '&#23495;',
	"\xB147" => '&#23493;',
	"\xB148" => '&#23492;',
	"\xB149" => '&#23490;',
	"\xB14A" => '&#23487;',
	"\xB14B" => '&#23494;',
	"\xB14C" => '&#23561;',
	"\xB14D" => '&#23560;',
	"\xB14E" => '&#23559;',
	"\xB14F" => '&#23648;',
	"\xB150" => '&#23644;',
	"\xB151" => '&#23645;',
	"\xB152" => '&#23815;',
	"\xB153" => '&#23814;',
	"\xB154" => '&#23822;',
	"\xB155" => '&#23835;',
	"\xB156" => '&#23830;',
	"\xB157" => '&#23842;',
	"\xB158" => '&#23825;',
	"\xB159" => '&#23849;',
	"\xB15A" => '&#23828;',
	"\xB15B" => '&#23833;',
	"\xB15C" => '&#23844;',
	"\xB15D" => '&#23847;',
	"\xB15E" => '&#23831;',
	"\xB15F" => '&#24034;',
	"\xB160" => '&#24120;',
	"\xB161" => '&#24118;',
	"\xB162" => '&#24115;',
	"\xB163" => '&#24119;',
	"\xB164" => '&#24247;',
	"\xB165" => '&#24248;',
	"\xB166" => '&#24246;',
	"\xB167" => '&#24245;',
	"\xB168" => '&#24254;',
	"\xB169" => '&#24373;',
	"\xB16A" => '&#24375;',
	"\xB16B" => '&#24407;',
	"\xB16C" => '&#24428;',
	"\xB16D" => '&#24425;',
	"\xB16E" => '&#24427;',
	"\xB16F" => '&#24471;',
	"\xB170" => '&#24473;',
	"\xB171" => '&#24478;',
	"\xB172" => '&#24472;',
	"\xB173" => '&#24481;',
	"\xB174" => '&#24480;',
	"\xB175" => '&#24476;',
	"\xB176" => '&#24703;',
	"\xB177" => '&#24739;',
	"\xB178" => '&#24713;',
	"\xB179" => '&#24736;',
	"\xB17A" => '&#24744;',
	"\xB17B" => '&#24779;',
	"\xB17C" => '&#24756;',
	"\xB17D" => '&#24806;',
	"\xB17E" => '&#24765;',
	"\xB1A1" => '&#24773;',
	"\xB1A2" => '&#24763;',
	"\xB1A3" => '&#24757;',
	"\xB1A4" => '&#24796;',
	"\xB1A5" => '&#24764;',
	"\xB1A6" => '&#24792;',
	"\xB1A7" => '&#24789;',
	"\xB1A8" => '&#24774;',
	"\xB1A9" => '&#24799;',
	"\xB1AA" => '&#24760;',
	"\xB1AB" => '&#24794;',
	"\xB1AC" => '&#24775;',
	"\xB1AD" => '&#25114;',
	"\xB1AE" => '&#25115;',
	"\xB1AF" => '&#25160;',
	"\xB1B0" => '&#25504;',
	"\xB1B1" => '&#25511;',
	"\xB1B2" => '&#25458;',
	"\xB1B3" => '&#25494;',
	"\xB1B4" => '&#25506;',
	"\xB1B5" => '&#25509;',
	"\xB1B6" => '&#25463;',
	"\xB1B7" => '&#25447;',
	"\xB1B8" => '&#25496;',
	"\xB1B9" => '&#25514;',
	"\xB1BA" => '&#25457;',
	"\xB1BB" => '&#25513;',
	"\xB1BC" => '&#25481;',
	"\xB1BD" => '&#25475;',
	"\xB1BE" => '&#25499;',
	"\xB1BF" => '&#25451;',
	"\xB1C0" => '&#25512;',
	"\xB1C1" => '&#25476;',
	"\xB1C2" => '&#25480;',
	"\xB1C3" => '&#25497;',
	"\xB1C4" => '&#25505;',
	"\xB1C5" => '&#25516;',
	"\xB1C6" => '&#25490;',
	"\xB1C7" => '&#25487;',
	"\xB1C8" => '&#25472;',
	"\xB1C9" => '&#25467;',
	"\xB1CA" => '&#25449;',
	"\xB1CB" => '&#25448;',
	"\xB1CC" => '&#25466;',
	"\xB1CD" => '&#25949;',
	"\xB1CE" => '&#25942;',
	"\xB1CF" => '&#25937;',
	"\xB1D0" => '&#25945;',
	"\xB1D1" => '&#25943;',
	"\xB1D2" => '&#21855;',
	"\xB1D3" => '&#25935;',
	"\xB1D4" => '&#25944;',
	"\xB1D5" => '&#25941;',
	"\xB1D6" => '&#25940;',
	"\xB1D7" => '&#26012;',
	"\xB1D8" => '&#26011;',
	"\xB1D9" => '&#26028;',
	"\xB1DA" => '&#26063;',
	"\xB1DB" => '&#26059;',
	"\xB1DC" => '&#26060;',
	"\xB1DD" => '&#26062;',
	"\xB1DE" => '&#26205;',
	"\xB1DF" => '&#26202;',
	"\xB1E0" => '&#26212;',
	"\xB1E1" => '&#26216;',
	"\xB1E2" => '&#26214;',
	"\xB1E3" => '&#26206;',
	"\xB1E4" => '&#26361;',
	"\xB1E5" => '&#21207;',
	"\xB1E6" => '&#26395;',
	"\xB1E7" => '&#26753;',
	"\xB1E8" => '&#26799;',
	"\xB1E9" => '&#26786;',
	"\xB1EA" => '&#26771;',
	"\xB1EB" => '&#26805;',
	"\xB1EC" => '&#26751;',
	"\xB1ED" => '&#26742;',
	"\xB1EE" => '&#26801;',
	"\xB1EF" => '&#26791;',
	"\xB1F0" => '&#26775;',
	"\xB1F1" => '&#26800;',
	"\xB1F2" => '&#26755;',
	"\xB1F3" => '&#26820;',
	"\xB1F4" => '&#26797;',
	"\xB1F5" => '&#26758;',
	"\xB1F6" => '&#26757;',
	"\xB1F7" => '&#26772;',
	"\xB1F8" => '&#26781;',
	"\xB1F9" => '&#26792;',
	"\xB1FA" => '&#26783;',
	"\xB1FB" => '&#26785;',
	"\xB1FC" => '&#26754;',
	"\xB1FD" => '&#27442;',
	"\xB1FE" => '&#27578;',
	"\xB240" => '&#27627;',
	"\xB241" => '&#27628;',
	"\xB242" => '&#27691;',
	"\xB243" => '&#28046;',
	"\xB244" => '&#28092;',
	"\xB245" => '&#28147;',
	"\xB246" => '&#28121;',
	"\xB247" => '&#28082;',
	"\xB248" => '&#28129;',
	"\xB249" => '&#28108;',
	"\xB24A" => '&#28132;',
	"\xB24B" => '&#28155;',
	"\xB24C" => '&#28154;',
	"\xB24D" => '&#28165;',
	"\xB24E" => '&#28103;',
	"\xB24F" => '&#28107;',
	"\xB250" => '&#28079;',
	"\xB251" => '&#28113;',
	"\xB252" => '&#28078;',
	"\xB253" => '&#28126;',
	"\xB254" => '&#28153;',
	"\xB255" => '&#28088;',
	"\xB256" => '&#28151;',
	"\xB257" => '&#28149;',
	"\xB258" => '&#28101;',
	"\xB259" => '&#28114;',
	"\xB25A" => '&#28186;',
	"\xB25B" => '&#28085;',
	"\xB25C" => '&#28122;',
	"\xB25D" => '&#28139;',
	"\xB25E" => '&#28120;',
	"\xB25F" => '&#28138;',
	"\xB260" => '&#28145;',
	"\xB261" => '&#28142;',
	"\xB262" => '&#28136;',
	"\xB263" => '&#28102;',
	"\xB264" => '&#28100;',
	"\xB265" => '&#28074;',
	"\xB266" => '&#28140;',
	"\xB267" => '&#28095;',
	"\xB268" => '&#28134;',
	"\xB269" => '&#28921;',
	"\xB26A" => '&#28937;',
	"\xB26B" => '&#28938;',
	"\xB26C" => '&#28925;',
	"\xB26D" => '&#28911;',
	"\xB26E" => '&#29245;',
	"\xB26F" => '&#29309;',
	"\xB270" => '&#29313;',
	"\xB271" => '&#29468;',
	"\xB272" => '&#29467;',
	"\xB273" => '&#29462;',
	"\xB274" => '&#29459;',
	"\xB275" => '&#29465;',
	"\xB276" => '&#29575;',
	"\xB277" => '&#29701;',
	"\xB278" => '&#29706;',
	"\xB279" => '&#29699;',
	"\xB27A" => '&#29702;',
	"\xB27B" => '&#29694;',
	"\xB27C" => '&#29709;',
	"\xB27D" => '&#29920;',
	"\xB27E" => '&#29942;',
	"\xB2A1" => '&#29943;',
	"\xB2A2" => '&#29980;',
	"\xB2A3" => '&#29986;',
	"\xB2A4" => '&#30053;',
	"\xB2A5" => '&#30054;',
	"\xB2A6" => '&#30050;',
	"\xB2A7" => '&#30064;',
	"\xB2A8" => '&#30095;',
	"\xB2A9" => '&#30164;',
	"\xB2AA" => '&#30165;',
	"\xB2AB" => '&#30133;',
	"\xB2AC" => '&#30154;',
	"\xB2AD" => '&#30157;',
	"\xB2AE" => '&#30350;',
	"\xB2AF" => '&#30420;',
	"\xB2B0" => '&#30418;',
	"\xB2B1" => '&#30427;',
	"\xB2B2" => '&#30519;',
	"\xB2B3" => '&#30526;',
	"\xB2B4" => '&#30524;',
	"\xB2B5" => '&#30518;',
	"\xB2B6" => '&#30520;',
	"\xB2B7" => '&#30522;',
	"\xB2B8" => '&#30827;',
	"\xB2B9" => '&#30787;',
	"\xB2BA" => '&#30798;',
	"\xB2BB" => '&#31077;',
	"\xB2BC" => '&#31080;',
	"\xB2BD" => '&#31085;',
	"\xB2BE" => '&#31227;',
	"\xB2BF" => '&#31378;',
	"\xB2C0" => '&#31381;',
	"\xB2C1" => '&#31520;',
	"\xB2C2" => '&#31528;',
	"\xB2C3" => '&#31515;',
	"\xB2C4" => '&#31532;',
	"\xB2C5" => '&#31526;',
	"\xB2C6" => '&#31513;',
	"\xB2C7" => '&#31518;',
	"\xB2C8" => '&#31534;',
	"\xB2C9" => '&#31890;',
	"\xB2CA" => '&#31895;',
	"\xB2CB" => '&#31893;',
	"\xB2CC" => '&#32070;',
	"\xB2CD" => '&#32067;',
	"\xB2CE" => '&#32113;',
	"\xB2CF" => '&#32046;',
	"\xB2D0" => '&#32057;',
	"\xB2D1" => '&#32060;',
	"\xB2D2" => '&#32064;',
	"\xB2D3" => '&#32048;',
	"\xB2D4" => '&#32051;',
	"\xB2D5" => '&#32068;',
	"\xB2D6" => '&#32047;',
	"\xB2D7" => '&#32066;',
	"\xB2D8" => '&#32050;',
	"\xB2D9" => '&#32049;',
	"\xB2DA" => '&#32573;',
	"\xB2DB" => '&#32670;',
	"\xB2DC" => '&#32666;',
	"\xB2DD" => '&#32716;',
	"\xB2DE" => '&#32718;',
	"\xB2DF" => '&#32722;',
	"\xB2E0" => '&#32796;',
	"\xB2E1" => '&#32842;',
	"\xB2E2" => '&#32838;',
	"\xB2E3" => '&#33071;',
	"\xB2E4" => '&#33046;',
	"\xB2E5" => '&#33059;',
	"\xB2E6" => '&#33067;',
	"\xB2E7" => '&#33065;',
	"\xB2E8" => '&#33072;',
	"\xB2E9" => '&#33060;',
	"\xB2EA" => '&#33282;',
	"\xB2EB" => '&#33333;',
	"\xB2EC" => '&#33335;',
	"\xB2ED" => '&#33334;',
	"\xB2EE" => '&#33337;',
	"\xB2EF" => '&#33678;',
	"\xB2F0" => '&#33694;',
	"\xB2F1" => '&#33688;',
	"\xB2F2" => '&#33656;',
	"\xB2F3" => '&#33698;',
	"\xB2F4" => '&#33686;',
	"\xB2F5" => '&#33725;',
	"\xB2F6" => '&#33707;',
	"\xB2F7" => '&#33682;',
	"\xB2F8" => '&#33674;',
	"\xB2F9" => '&#33683;',
	"\xB2FA" => '&#33673;',
	"\xB2FB" => '&#33696;',
	"\xB2FC" => '&#33655;',
	"\xB2FD" => '&#33659;',
	"\xB2FE" => '&#33660;',
	"\xB340" => '&#33670;',
	"\xB341" => '&#33703;',
	"\xB342" => '&#34389;',
	"\xB343" => '&#24426;',
	"\xB344" => '&#34503;',
	"\xB345" => '&#34496;',
	"\xB346" => '&#34486;',
	"\xB347" => '&#34500;',
	"\xB348" => '&#34485;',
	"\xB349" => '&#34502;',
	"\xB34A" => '&#34507;',
	"\xB34B" => '&#34481;',
	"\xB34C" => '&#34479;',
	"\xB34D" => '&#34505;',
	"\xB34E" => '&#34899;',
	"\xB34F" => '&#34974;',
	"\xB350" => '&#34952;',
	"\xB351" => '&#34987;',
	"\xB352" => '&#34962;',
	"\xB353" => '&#34966;',
	"\xB354" => '&#34957;',
	"\xB355" => '&#34955;',
	"\xB356" => '&#35219;',
	"\xB357" => '&#35215;',
	"\xB358" => '&#35370;',
	"\xB359" => '&#35357;',
	"\xB35A" => '&#35363;',
	"\xB35B" => '&#35365;',
	"\xB35C" => '&#35377;',
	"\xB35D" => '&#35373;',
	"\xB35E" => '&#35359;',
	"\xB35F" => '&#35355;',
	"\xB360" => '&#35362;',
	"\xB361" => '&#35913;',
	"\xB362" => '&#35930;',
	"\xB363" => '&#36009;',
	"\xB364" => '&#36012;',
	"\xB365" => '&#36011;',
	"\xB366" => '&#36008;',
	"\xB367" => '&#36010;',
	"\xB368" => '&#36007;',
	"\xB369" => '&#36199;',
	"\xB36A" => '&#36198;',
	"\xB36B" => '&#36286;',
	"\xB36C" => '&#36282;',
	"\xB36D" => '&#36571;',
	"\xB36E" => '&#36575;',
	"\xB36F" => '&#36889;',
	"\xB370" => '&#36877;',
	"\xB371" => '&#36890;',
	"\xB372" => '&#36887;',
	"\xB373" => '&#36899;',
	"\xB374" => '&#36895;',
	"\xB375" => '&#36893;',
	"\xB376" => '&#36880;',
	"\xB377" => '&#36885;',
	"\xB378" => '&#36894;',
	"\xB379" => '&#36896;',
	"\xB37A" => '&#36879;',
	"\xB37B" => '&#36898;',
	"\xB37C" => '&#36886;',
	"\xB37D" => '&#36891;',
	"\xB37E" => '&#36884;',
	"\xB3A1" => '&#37096;',
	"\xB3A2" => '&#37101;',
	"\xB3A3" => '&#37117;',
	"\xB3A4" => '&#37207;',
	"\xB3A5" => '&#37326;',
	"\xB3A6" => '&#37365;',
	"\xB3A7" => '&#37350;',
	"\xB3A8" => '&#37347;',
	"\xB3A9" => '&#37351;',
	"\xB3AA" => '&#37357;',
	"\xB3AB" => '&#37353;',
	"\xB3AC" => '&#38281;',
	"\xB3AD" => '&#38506;',
	"\xB3AE" => '&#38517;',
	"\xB3AF" => '&#38515;',
	"\xB3B0" => '&#38520;',
	"\xB3B1" => '&#38512;',
	"\xB3B2" => '&#38516;',
	"\xB3B3" => '&#38518;',
	"\xB3B4" => '&#38519;',
	"\xB3B5" => '&#38508;',
	"\xB3B6" => '&#38592;',
	"\xB3B7" => '&#38634;',
	"\xB3B8" => '&#38633;',
	"\xB3B9" => '&#31456;',
	"\xB3BA" => '&#31455;',
	"\xB3BB" => '&#38914;',
	"\xB3BC" => '&#38915;',
	"\xB3BD" => '&#39770;',
	"\xB3BE" => '&#40165;',
	"\xB3BF" => '&#40565;',
	"\xB3C0" => '&#40575;',
	"\xB3C1" => '&#40613;',
	"\xB3C2" => '&#40635;',
	"\xB3C3" => '&#20642;',
	"\xB3C4" => '&#20621;',
	"\xB3C5" => '&#20613;',
	"\xB3C6" => '&#20633;',
	"\xB3C7" => '&#20625;',
	"\xB3C8" => '&#20608;',
	"\xB3C9" => '&#20630;',
	"\xB3CA" => '&#20632;',
	"\xB3CB" => '&#20634;',
	"\xB3CC" => '&#26368;',
	"\xB3CD" => '&#20977;',
	"\xB3CE" => '&#21106;',
	"\xB3CF" => '&#21108;',
	"\xB3D0" => '&#21109;',
	"\xB3D1" => '&#21097;',
	"\xB3D2" => '&#21214;',
	"\xB3D3" => '&#21213;',
	"\xB3D4" => '&#21211;',
	"\xB3D5" => '&#21338;',
	"\xB3D6" => '&#21413;',
	"\xB3D7" => '&#21883;',
	"\xB3D8" => '&#21888;',
	"\xB3D9" => '&#21927;',
	"\xB3DA" => '&#21884;',
	"\xB3DB" => '&#21898;',
	"\xB3DC" => '&#21917;',
	"\xB3DD" => '&#21912;',
	"\xB3DE" => '&#21890;',
	"\xB3DF" => '&#21916;',
	"\xB3E0" => '&#21930;',
	"\xB3E1" => '&#21908;',
	"\xB3E2" => '&#21895;',
	"\xB3E3" => '&#21899;',
	"\xB3E4" => '&#21891;',
	"\xB3E5" => '&#21939;',
	"\xB3E6" => '&#21934;',
	"\xB3E7" => '&#21919;',
	"\xB3E8" => '&#21822;',
	"\xB3E9" => '&#21938;',
	"\xB3EA" => '&#21914;',
	"\xB3EB" => '&#21947;',
	"\xB3EC" => '&#21932;',
	"\xB3ED" => '&#21937;',
	"\xB3EE" => '&#21886;',
	"\xB3EF" => '&#21897;',
	"\xB3F0" => '&#21931;',
	"\xB3F1" => '&#21913;',
	"\xB3F2" => '&#22285;',
	"\xB3F3" => '&#22575;',
	"\xB3F4" => '&#22570;',
	"\xB3F5" => '&#22580;',
	"\xB3F6" => '&#22564;',
	"\xB3F7" => '&#22576;',
	"\xB3F8" => '&#22577;',
	"\xB3F9" => '&#22561;',
	"\xB3FA" => '&#22557;',
	"\xB3FB" => '&#22560;',
	"\xB3FC" => '&#22777;',
	"\xB3FD" => '&#22778;',
	"\xB3FE" => '&#22880;',
	"\xB440" => '&#23159;',
	"\xB441" => '&#23194;',
	"\xB442" => '&#23167;',
	"\xB443" => '&#23186;',
	"\xB444" => '&#23195;',
	"\xB445" => '&#23207;',
	"\xB446" => '&#23411;',
	"\xB447" => '&#23409;',
	"\xB448" => '&#23506;',
	"\xB449" => '&#23500;',
	"\xB44A" => '&#23507;',
	"\xB44B" => '&#23504;',
	"\xB44C" => '&#23562;',
	"\xB44D" => '&#23563;',
	"\xB44E" => '&#23601;',
	"\xB44F" => '&#23884;',
	"\xB450" => '&#23888;',
	"\xB451" => '&#23860;',
	"\xB452" => '&#23879;',
	"\xB453" => '&#24061;',
	"\xB454" => '&#24133;',
	"\xB455" => '&#24125;',
	"\xB456" => '&#24128;',
	"\xB457" => '&#24131;',
	"\xB458" => '&#24190;',
	"\xB459" => '&#24266;',
	"\xB45A" => '&#24257;',
	"\xB45B" => '&#24258;',
	"\xB45C" => '&#24260;',
	"\xB45D" => '&#24380;',
	"\xB45E" => '&#24429;',
	"\xB45F" => '&#24489;',
	"\xB460" => '&#24490;',
	"\xB461" => '&#24488;',
	"\xB462" => '&#24785;',
	"\xB463" => '&#24801;',
	"\xB464" => '&#24754;',
	"\xB465" => '&#24758;',
	"\xB466" => '&#24800;',
	"\xB467" => '&#24860;',
	"\xB468" => '&#24867;',
	"\xB469" => '&#24826;',
	"\xB46A" => '&#24853;',
	"\xB46B" => '&#24816;',
	"\xB46C" => '&#24827;',
	"\xB46D" => '&#24820;',
	"\xB46E" => '&#24936;',
	"\xB46F" => '&#24817;',
	"\xB470" => '&#24846;',
	"\xB471" => '&#24822;',
	"\xB472" => '&#24841;',
	"\xB473" => '&#24832;',
	"\xB474" => '&#24850;',
	"\xB475" => '&#25119;',
	"\xB476" => '&#25161;',
	"\xB477" => '&#25507;',
	"\xB478" => '&#25484;',
	"\xB479" => '&#25551;',
	"\xB47A" => '&#25536;',
	"\xB47B" => '&#25577;',
	"\xB47C" => '&#25545;',
	"\xB47D" => '&#25542;',
	"\xB47E" => '&#25549;',
	"\xB4A1" => '&#25554;',
	"\xB4A2" => '&#25571;',
	"\xB4A3" => '&#25552;',
	"\xB4A4" => '&#25569;',
	"\xB4A5" => '&#25558;',
	"\xB4A6" => '&#25581;',
	"\xB4A7" => '&#25582;',
	"\xB4A8" => '&#25462;',
	"\xB4A9" => '&#25588;',
	"\xB4AA" => '&#25578;',
	"\xB4AB" => '&#25563;',
	"\xB4AC" => '&#25682;',
	"\xB4AD" => '&#25562;',
	"\xB4AE" => '&#25593;',
	"\xB4AF" => '&#25950;',
	"\xB4B0" => '&#25958;',
	"\xB4B1" => '&#25954;',
	"\xB4B2" => '&#25955;',
	"\xB4B3" => '&#26001;',
	"\xB4B4" => '&#26000;',
	"\xB4B5" => '&#26031;',
	"\xB4B6" => '&#26222;',
	"\xB4B7" => '&#26224;',
	"\xB4B8" => '&#26228;',
	"\xB4B9" => '&#26230;',
	"\xB4BA" => '&#26223;',
	"\xB4BB" => '&#26257;',
	"\xB4BC" => '&#26234;',
	"\xB4BD" => '&#26238;',
	"\xB4BE" => '&#26231;',
	"\xB4BF" => '&#26366;',
	"\xB4C0" => '&#26367;',
	"\xB4C1" => '&#26399;',
	"\xB4C2" => '&#26397;',
	"\xB4C3" => '&#26874;',
	"\xB4C4" => '&#26837;',
	"\xB4C5" => '&#26848;',
	"\xB4C6" => '&#26840;',
	"\xB4C7" => '&#26839;',
	"\xB4C8" => '&#26885;',
	"\xB4C9" => '&#26847;',
	"\xB4CA" => '&#26869;',
	"\xB4CB" => '&#26862;',
	"\xB4CC" => '&#26855;',
	"\xB4CD" => '&#26873;',
	"\xB4CE" => '&#26834;',
	"\xB4CF" => '&#26866;',
	"\xB4D0" => '&#26851;',
	"\xB4D1" => '&#26827;',
	"\xB4D2" => '&#26829;',
	"\xB4D3" => '&#26893;',
	"\xB4D4" => '&#26898;',
	"\xB4D5" => '&#26894;',
	"\xB4D6" => '&#26825;',
	"\xB4D7" => '&#26842;',
	"\xB4D8" => '&#26990;',
	"\xB4D9" => '&#26875;',
	"\xB4DA" => '&#27454;',
	"\xB4DB" => '&#27450;',
	"\xB4DC" => '&#27453;',
	"\xB4DD" => '&#27544;',
	"\xB4DE" => '&#27542;',
	"\xB4DF" => '&#27580;',
	"\xB4E0" => '&#27631;',
	"\xB4E1" => '&#27694;',
	"\xB4E2" => '&#27695;',
	"\xB4E3" => '&#27692;',
	"\xB4E4" => '&#28207;',
	"\xB4E5" => '&#28216;',
	"\xB4E6" => '&#28244;',
	"\xB4E7" => '&#28193;',
	"\xB4E8" => '&#28210;',
	"\xB4E9" => '&#28263;',
	"\xB4EA" => '&#28234;',
	"\xB4EB" => '&#28192;',
	"\xB4EC" => '&#28197;',
	"\xB4ED" => '&#28195;',
	"\xB4EE" => '&#28187;',
	"\xB4EF" => '&#28251;',
	"\xB4F0" => '&#28248;',
	"\xB4F1" => '&#28196;',
	"\xB4F2" => '&#28246;',
	"\xB4F3" => '&#28270;',
	"\xB4F4" => '&#28205;',
	"\xB4F5" => '&#28198;',
	"\xB4F6" => '&#28271;',
	"\xB4F7" => '&#28212;',
	"\xB4F8" => '&#28237;',
	"\xB4F9" => '&#28218;',
	"\xB4FA" => '&#28204;',
	"\xB4FB" => '&#28227;',
	"\xB4FC" => '&#28189;',
	"\xB4FD" => '&#28222;',
	"\xB4FE" => '&#28363;',
	"\xB540" => '&#28297;',
	"\xB541" => '&#28185;',
	"\xB542" => '&#28238;',
	"\xB543" => '&#28259;',
	"\xB544" => '&#28228;',
	"\xB545" => '&#28274;',
	"\xB546" => '&#28265;',
	"\xB547" => '&#28255;',
	"\xB548" => '&#28953;',
	"\xB549" => '&#28954;',
	"\xB54A" => '&#28966;',
	"\xB54B" => '&#28976;',
	"\xB54C" => '&#28961;',
	"\xB54D" => '&#28982;',
	"\xB54E" => '&#29038;',
	"\xB54F" => '&#28956;',
	"\xB550" => '&#29260;',
	"\xB551" => '&#29316;',
	"\xB552" => '&#29312;',
	"\xB553" => '&#29494;',
	"\xB554" => '&#29477;',
	"\xB555" => '&#29492;',
	"\xB556" => '&#29481;',
	"\xB557" => '&#29754;',
	"\xB558" => '&#29738;',
	"\xB559" => '&#29747;',
	"\xB55A" => '&#29730;',
	"\xB55B" => '&#29733;',
	"\xB55C" => '&#29749;',
	"\xB55D" => '&#29750;',
	"\xB55E" => '&#29748;',
	"\xB55F" => '&#29743;',
	"\xB560" => '&#29723;',
	"\xB561" => '&#29734;',
	"\xB562" => '&#29736;',
	"\xB563" => '&#29989;',
	"\xB564" => '&#29990;',
	"\xB565" => '&#30059;',
	"\xB566" => '&#30058;',
	"\xB567" => '&#30178;',
	"\xB568" => '&#30171;',
	"\xB569" => '&#30179;',
	"\xB56A" => '&#30169;',
	"\xB56B" => '&#30168;',
	"\xB56C" => '&#30174;',
	"\xB56D" => '&#30176;',
	"\xB56E" => '&#30331;',
	"\xB56F" => '&#30332;',
	"\xB570" => '&#30358;',
	"\xB571" => '&#30355;',
	"\xB572" => '&#30388;',
	"\xB573" => '&#30428;',
	"\xB574" => '&#30543;',
	"\xB575" => '&#30701;',
	"\xB576" => '&#30813;',
	"\xB577" => '&#30828;',
	"\xB578" => '&#30831;',
	"\xB579" => '&#31245;',
	"\xB57A" => '&#31240;',
	"\xB57B" => '&#31243;',
	"\xB57C" => '&#31237;',
	"\xB57D" => '&#31232;',
	"\xB57E" => '&#31384;',
	"\xB5A1" => '&#31383;',
	"\xB5A2" => '&#31382;',
	"\xB5A3" => '&#31461;',
	"\xB5A4" => '&#31459;',
	"\xB5A5" => '&#31561;',
	"\xB5A6" => '&#31574;',
	"\xB5A7" => '&#31558;',
	"\xB5A8" => '&#31568;',
	"\xB5A9" => '&#31570;',
	"\xB5AA" => '&#31572;',
	"\xB5AB" => '&#31565;',
	"\xB5AC" => '&#31563;',
	"\xB5AD" => '&#31567;',
	"\xB5AE" => '&#31569;',
	"\xB5AF" => '&#31903;',
	"\xB5B0" => '&#31909;',
	"\xB5B1" => '&#32094;',
	"\xB5B2" => '&#32080;',
	"\xB5B3" => '&#32104;',
	"\xB5B4" => '&#32085;',
	"\xB5B5" => '&#32043;',
	"\xB5B6" => '&#32110;',
	"\xB5B7" => '&#32114;',
	"\xB5B8" => '&#32097;',
	"\xB5B9" => '&#32102;',
	"\xB5BA" => '&#32098;',
	"\xB5BB" => '&#32112;',
	"\xB5BC" => '&#32115;',
	"\xB5BD" => '&#21892;',
	"\xB5BE" => '&#32724;',
	"\xB5BF" => '&#32725;',
	"\xB5C0" => '&#32779;',
	"\xB5C1" => '&#32850;',
	"\xB5C2" => '&#32901;',
	"\xB5C3" => '&#33109;',
	"\xB5C4" => '&#33108;',
	"\xB5C5" => '&#33099;',
	"\xB5C6" => '&#33105;',
	"\xB5C7" => '&#33102;',
	"\xB5C8" => '&#33081;',
	"\xB5C9" => '&#33094;',
	"\xB5CA" => '&#33086;',
	"\xB5CB" => '&#33100;',
	"\xB5CC" => '&#33107;',
	"\xB5CD" => '&#33140;',
	"\xB5CE" => '&#33298;',
	"\xB5CF" => '&#33308;',
	"\xB5D0" => '&#33769;',
	"\xB5D1" => '&#33795;',
	"\xB5D2" => '&#33784;',
	"\xB5D3" => '&#33805;',
	"\xB5D4" => '&#33760;',
	"\xB5D5" => '&#33733;',
	"\xB5D6" => '&#33803;',
	"\xB5D7" => '&#33729;',
	"\xB5D8" => '&#33775;',
	"\xB5D9" => '&#33777;',
	"\xB5DA" => '&#33780;',
	"\xB5DB" => '&#33879;',
	"\xB5DC" => '&#33802;',
	"\xB5DD" => '&#33776;',
	"\xB5DE" => '&#33804;',
	"\xB5DF" => '&#33740;',
	"\xB5E0" => '&#33789;',
	"\xB5E1" => '&#33778;',
	"\xB5E2" => '&#33738;',
	"\xB5E3" => '&#33848;',
	"\xB5E4" => '&#33806;',
	"\xB5E5" => '&#33796;',
	"\xB5E6" => '&#33756;',
	"\xB5E7" => '&#33799;',
	"\xB5E8" => '&#33748;',
	"\xB5E9" => '&#33759;',
	"\xB5EA" => '&#34395;',
	"\xB5EB" => '&#34527;',
	"\xB5EC" => '&#34521;',
	"\xB5ED" => '&#34541;',
	"\xB5EE" => '&#34516;',
	"\xB5EF" => '&#34523;',
	"\xB5F0" => '&#34532;',
	"\xB5F1" => '&#34512;',
	"\xB5F2" => '&#34526;',
	"\xB5F3" => '&#34903;',
	"\xB5F4" => '&#35009;',
	"\xB5F5" => '&#35010;',
	"\xB5F6" => '&#34993;',
	"\xB5F7" => '&#35203;',
	"\xB5F8" => '&#35222;',
	"\xB5F9" => '&#35387;',
	"\xB5FA" => '&#35424;',
	"\xB5FB" => '&#35413;',
	"\xB5FC" => '&#35422;',
	"\xB5FD" => '&#35388;',
	"\xB5FE" => '&#35393;',
	"\xB640" => '&#35412;',
	"\xB641" => '&#35419;',
	"\xB642" => '&#35408;',
	"\xB643" => '&#35398;',
	"\xB644" => '&#35380;',
	"\xB645" => '&#35386;',
	"\xB646" => '&#35382;',
	"\xB647" => '&#35414;',
	"\xB648" => '&#35937;',
	"\xB649" => '&#35970;',
	"\xB64A" => '&#36015;',
	"\xB64B" => '&#36028;',
	"\xB64C" => '&#36019;',
	"\xB64D" => '&#36029;',
	"\xB64E" => '&#36033;',
	"\xB64F" => '&#36027;',
	"\xB650" => '&#36032;',
	"\xB651" => '&#36020;',
	"\xB652" => '&#36023;',
	"\xB653" => '&#36022;',
	"\xB654" => '&#36031;',
	"\xB655" => '&#36024;',
	"\xB656" => '&#36234;',
	"\xB657" => '&#36229;',
	"\xB658" => '&#36225;',
	"\xB659" => '&#36302;',
	"\xB65A" => '&#36317;',
	"\xB65B" => '&#36299;',
	"\xB65C" => '&#36314;',
	"\xB65D" => '&#36305;',
	"\xB65E" => '&#36300;',
	"\xB65F" => '&#36315;',
	"\xB660" => '&#36294;',
	"\xB661" => '&#36603;',
	"\xB662" => '&#36600;',
	"\xB663" => '&#36604;',
	"\xB664" => '&#36764;',
	"\xB665" => '&#36910;',
	"\xB666" => '&#36917;',
	"\xB667" => '&#36913;',
	"\xB668" => '&#36920;',
	"\xB669" => '&#36914;',
	"\xB66A" => '&#36918;',
	"\xB66B" => '&#37122;',
	"\xB66C" => '&#37109;',
	"\xB66D" => '&#37129;',
	"\xB66E" => '&#37118;',
	"\xB66F" => '&#37219;',
	"\xB670" => '&#37221;',
	"\xB671" => '&#37327;',
	"\xB672" => '&#37396;',
	"\xB673" => '&#37397;',
	"\xB674" => '&#37411;',
	"\xB675" => '&#37385;',
	"\xB676" => '&#37406;',
	"\xB677" => '&#37389;',
	"\xB678" => '&#37392;',
	"\xB679" => '&#37383;',
	"\xB67A" => '&#37393;',
	"\xB67B" => '&#38292;',
	"\xB67C" => '&#38287;',
	"\xB67D" => '&#38283;',
	"\xB67E" => '&#38289;',
	"\xB6A1" => '&#38291;',
	"\xB6A2" => '&#38290;',
	"\xB6A3" => '&#38286;',
	"\xB6A4" => '&#38538;',
	"\xB6A5" => '&#38542;',
	"\xB6A6" => '&#38539;',
	"\xB6A7" => '&#38525;',
	"\xB6A8" => '&#38533;',
	"\xB6A9" => '&#38534;',
	"\xB6AA" => '&#38541;',
	"\xB6AB" => '&#38514;',
	"\xB6AC" => '&#38532;',
	"\xB6AD" => '&#38593;',
	"\xB6AE" => '&#38597;',
	"\xB6AF" => '&#38596;',
	"\xB6B0" => '&#38598;',
	"\xB6B1" => '&#38599;',
	"\xB6B2" => '&#38639;',
	"\xB6B3" => '&#38642;',
	"\xB6B4" => '&#38860;',
	"\xB6B5" => '&#38917;',
	"\xB6B6" => '&#38918;',
	"\xB6B7" => '&#38920;',
	"\xB6B8" => '&#39143;',
	"\xB6B9" => '&#39146;',
	"\xB6BA" => '&#39151;',
	"\xB6BB" => '&#39145;',
	"\xB6BC" => '&#39154;',
	"\xB6BD" => '&#39149;',
	"\xB6BE" => '&#39342;',
	"\xB6BF" => '&#39341;',
	"\xB6C0" => '&#40643;',
	"\xB6C1" => '&#40653;',
	"\xB6C2" => '&#40657;',
	"\xB6C3" => '&#20098;',
	"\xB6C4" => '&#20653;',
	"\xB6C5" => '&#20661;',
	"\xB6C6" => '&#20658;',
	"\xB6C7" => '&#20659;',
	"\xB6C8" => '&#20677;',
	"\xB6C9" => '&#20670;',
	"\xB6CA" => '&#20652;',
	"\xB6CB" => '&#20663;',
	"\xB6CC" => '&#20667;',
	"\xB6CD" => '&#20655;',
	"\xB6CE" => '&#20679;',
	"\xB6CF" => '&#21119;',
	"\xB6D0" => '&#21111;',
	"\xB6D1" => '&#21117;',
	"\xB6D2" => '&#21215;',
	"\xB6D3" => '&#21222;',
	"\xB6D4" => '&#21220;',
	"\xB6D5" => '&#21218;',
	"\xB6D6" => '&#21219;',
	"\xB6D7" => '&#21295;',
	"\xB6D8" => '&#21983;',
	"\xB6D9" => '&#21992;',
	"\xB6DA" => '&#21971;',
	"\xB6DB" => '&#21990;',
	"\xB6DC" => '&#21966;',
	"\xB6DD" => '&#21980;',
	"\xB6DE" => '&#21959;',
	"\xB6DF" => '&#21969;',
	"\xB6E0" => '&#21987;',
	"\xB6E1" => '&#21988;',
	"\xB6E2" => '&#21999;',
	"\xB6E3" => '&#21978;',
	"\xB6E4" => '&#21985;',
	"\xB6E5" => '&#21957;',
	"\xB6E6" => '&#21958;',
	"\xB6E7" => '&#21989;',
	"\xB6E8" => '&#21961;',
	"\xB6E9" => '&#22290;',
	"\xB6EA" => '&#22291;',
	"\xB6EB" => '&#22622;',
	"\xB6EC" => '&#22609;',
	"\xB6ED" => '&#22616;',
	"\xB6EE" => '&#22615;',
	"\xB6EF" => '&#22618;',
	"\xB6F0" => '&#22612;',
	"\xB6F1" => '&#22635;',
	"\xB6F2" => '&#22604;',
	"\xB6F3" => '&#22637;',
	"\xB6F4" => '&#22602;',
	"\xB6F5" => '&#22626;',
	"\xB6F6" => '&#22610;',
	"\xB6F7" => '&#22603;',
	"\xB6F8" => '&#22887;',
	"\xB6F9" => '&#23233;',
	"\xB6FA" => '&#23241;',
	"\xB6FB" => '&#23244;',
	"\xB6FC" => '&#23230;',
	"\xB6FD" => '&#23229;',
	"\xB6FE" => '&#23228;',
	"\xB740" => '&#23219;',
	"\xB741" => '&#23234;',
	"\xB742" => '&#23218;',
	"\xB743" => '&#23913;',
	"\xB744" => '&#23919;',
	"\xB745" => '&#24140;',
	"\xB746" => '&#24185;',
	"\xB747" => '&#24265;',
	"\xB748" => '&#24264;',
	"\xB749" => '&#24338;',
	"\xB74A" => '&#24409;',
	"\xB74B" => '&#24492;',
	"\xB74C" => '&#24494;',
	"\xB74D" => '&#24858;',
	"\xB74E" => '&#24847;',
	"\xB74F" => '&#24904;',
	"\xB750" => '&#24863;',
	"\xB751" => '&#24819;',
	"\xB752" => '&#24859;',
	"\xB753" => '&#24825;',
	"\xB754" => '&#24833;',
	"\xB755" => '&#24840;',
	"\xB756" => '&#24910;',
	"\xB757" => '&#24908;',
	"\xB758" => '&#24900;',
	"\xB759" => '&#24909;',
	"\xB75A" => '&#24894;',
	"\xB75B" => '&#24884;',
	"\xB75C" => '&#24871;',
	"\xB75D" => '&#24845;',
	"\xB75E" => '&#24838;',
	"\xB75F" => '&#24887;',
	"\xB760" => '&#25121;',
	"\xB761" => '&#25122;',
	"\xB762" => '&#25619;',
	"\xB763" => '&#25662;',
	"\xB764" => '&#25630;',
	"\xB765" => '&#25642;',
	"\xB766" => '&#25645;',
	"\xB767" => '&#25661;',
	"\xB768" => '&#25644;',
	"\xB769" => '&#25615;',
	"\xB76A" => '&#25628;',
	"\xB76B" => '&#25620;',
	"\xB76C" => '&#25613;',
	"\xB76D" => '&#25654;',
	"\xB76E" => '&#25622;',
	"\xB76F" => '&#25623;',
	"\xB770" => '&#25606;',
	"\xB771" => '&#25964;',
	"\xB772" => '&#26015;',
	"\xB773" => '&#26032;',
	"\xB774" => '&#26263;',
	"\xB775" => '&#26249;',
	"\xB776" => '&#26247;',
	"\xB777" => '&#26248;',
	"\xB778" => '&#26262;',
	"\xB779" => '&#26244;',
	"\xB77A" => '&#26264;',
	"\xB77B" => '&#26253;',
	"\xB77C" => '&#26371;',
	"\xB77D" => '&#27028;',
	"\xB77E" => '&#26989;',
	"\xB7A1" => '&#26970;',
	"\xB7A2" => '&#26999;',
	"\xB7A3" => '&#26976;',
	"\xB7A4" => '&#26964;',
	"\xB7A5" => '&#26997;',
	"\xB7A6" => '&#26928;',
	"\xB7A7" => '&#27010;',
	"\xB7A8" => '&#26954;',
	"\xB7A9" => '&#26984;',
	"\xB7AA" => '&#26987;',
	"\xB7AB" => '&#26974;',
	"\xB7AC" => '&#26963;',
	"\xB7AD" => '&#27001;',
	"\xB7AE" => '&#27014;',
	"\xB7AF" => '&#26973;',
	"\xB7B0" => '&#26979;',
	"\xB7B1" => '&#26971;',
	"\xB7B2" => '&#27463;',
	"\xB7B3" => '&#27506;',
	"\xB7B4" => '&#27584;',
	"\xB7B5" => '&#27583;',
	"\xB7B6" => '&#27603;',
	"\xB7B7" => '&#27645;',
	"\xB7B8" => '&#28322;',
	"\xB7B9" => '&#28335;',
	"\xB7BA" => '&#28371;',
	"\xB7BB" => '&#28342;',
	"\xB7BC" => '&#28354;',
	"\xB7BD" => '&#28304;',
	"\xB7BE" => '&#28317;',
	"\xB7BF" => '&#28359;',
	"\xB7C0" => '&#28357;',
	"\xB7C1" => '&#28325;',
	"\xB7C2" => '&#28312;',
	"\xB7C3" => '&#28348;',
	"\xB7C4" => '&#28346;',
	"\xB7C5" => '&#28331;',
	"\xB7C6" => '&#28369;',
	"\xB7C7" => '&#28310;',
	"\xB7C8" => '&#28316;',
	"\xB7C9" => '&#28356;',
	"\xB7CA" => '&#28372;',
	"\xB7CB" => '&#28330;',
	"\xB7CC" => '&#28327;',
	"\xB7CD" => '&#28340;',
	"\xB7CE" => '&#29006;',
	"\xB7CF" => '&#29017;',
	"\xB7D0" => '&#29033;',
	"\xB7D1" => '&#29028;',
	"\xB7D2" => '&#29001;',
	"\xB7D3" => '&#29031;',
	"\xB7D4" => '&#29020;',
	"\xB7D5" => '&#29036;',
	"\xB7D6" => '&#29030;',
	"\xB7D7" => '&#29004;',
	"\xB7D8" => '&#29029;',
	"\xB7D9" => '&#29022;',
	"\xB7DA" => '&#28998;',
	"\xB7DB" => '&#29032;',
	"\xB7DC" => '&#29014;',
	"\xB7DD" => '&#29242;',
	"\xB7DE" => '&#29266;',
	"\xB7DF" => '&#29495;',
	"\xB7E0" => '&#29509;',
	"\xB7E1" => '&#29503;',
	"\xB7E2" => '&#29502;',
	"\xB7E3" => '&#29807;',
	"\xB7E4" => '&#29786;',
	"\xB7E5" => '&#29781;',
	"\xB7E6" => '&#29791;',
	"\xB7E7" => '&#29790;',
	"\xB7E8" => '&#29761;',
	"\xB7E9" => '&#29759;',
	"\xB7EA" => '&#29785;',
	"\xB7EB" => '&#29787;',
	"\xB7EC" => '&#29788;',
	"\xB7ED" => '&#30070;',
	"\xB7EE" => '&#30072;',
	"\xB7EF" => '&#30208;',
	"\xB7F0" => '&#30192;',
	"\xB7F1" => '&#30209;',
	"\xB7F2" => '&#30194;',
	"\xB7F3" => '&#30193;',
	"\xB7F4" => '&#30202;',
	"\xB7F5" => '&#30207;',
	"\xB7F6" => '&#30196;',
	"\xB7F7" => '&#30195;',
	"\xB7F8" => '&#30430;',
	"\xB7F9" => '&#30431;',
	"\xB7FA" => '&#30555;',
	"\xB7FB" => '&#30571;',
	"\xB7FC" => '&#30566;',
	"\xB7FD" => '&#30558;',
	"\xB7FE" => '&#30563;',
	"\xB840" => '&#30585;',
	"\xB841" => '&#30570;',
	"\xB842" => '&#30572;',
	"\xB843" => '&#30556;',
	"\xB844" => '&#30565;',
	"\xB845" => '&#30568;',
	"\xB846" => '&#30562;',
	"\xB847" => '&#30702;',
	"\xB848" => '&#30862;',
	"\xB849" => '&#30896;',
	"\xB84A" => '&#30871;',
	"\xB84B" => '&#30872;',
	"\xB84C" => '&#30860;',
	"\xB84D" => '&#30857;',
	"\xB84E" => '&#30844;',
	"\xB84F" => '&#30865;',
	"\xB850" => '&#30867;',
	"\xB851" => '&#30847;',
	"\xB852" => '&#31098;',
	"\xB853" => '&#31103;',
	"\xB854" => '&#31105;',
	"\xB855" => '&#33836;',
	"\xB856" => '&#31165;',
	"\xB857" => '&#31260;',
	"\xB858" => '&#31258;',
	"\xB859" => '&#31264;',
	"\xB85A" => '&#31252;',
	"\xB85B" => '&#31263;',
	"\xB85C" => '&#31262;',
	"\xB85D" => '&#31391;',
	"\xB85E" => '&#31392;',
	"\xB85F" => '&#31607;',
	"\xB860" => '&#31680;',
	"\xB861" => '&#31584;',
	"\xB862" => '&#31598;',
	"\xB863" => '&#31591;',
	"\xB864" => '&#31921;',
	"\xB865" => '&#31923;',
	"\xB866" => '&#31925;',
	"\xB867" => '&#32147;',
	"\xB868" => '&#32121;',
	"\xB869" => '&#32145;',
	"\xB86A" => '&#32129;',
	"\xB86B" => '&#32143;',
	"\xB86C" => '&#32091;',
	"\xB86D" => '&#32622;',
	"\xB86E" => '&#32617;',
	"\xB86F" => '&#32618;',
	"\xB870" => '&#32626;',
	"\xB871" => '&#32681;',
	"\xB872" => '&#32680;',
	"\xB873" => '&#32676;',
	"\xB874" => '&#32854;',
	"\xB875" => '&#32856;',
	"\xB876" => '&#32902;',
	"\xB877" => '&#32900;',
	"\xB878" => '&#33137;',
	"\xB879" => '&#33136;',
	"\xB87A" => '&#33144;',
	"\xB87B" => '&#33125;',
	"\xB87C" => '&#33134;',
	"\xB87D" => '&#33139;',
	"\xB87E" => '&#33131;',
	"\xB8A1" => '&#33145;',
	"\xB8A2" => '&#33146;',
	"\xB8A3" => '&#33126;',
	"\xB8A4" => '&#33285;',
	"\xB8A5" => '&#33351;',
	"\xB8A6" => '&#33922;',
	"\xB8A7" => '&#33911;',
	"\xB8A8" => '&#33853;',
	"\xB8A9" => '&#33841;',
	"\xB8AA" => '&#33909;',
	"\xB8AB" => '&#33894;',
	"\xB8AC" => '&#33899;',
	"\xB8AD" => '&#33865;',
	"\xB8AE" => '&#33900;',
	"\xB8AF" => '&#33883;',
	"\xB8B0" => '&#33852;',
	"\xB8B1" => '&#33845;',
	"\xB8B2" => '&#33889;',
	"\xB8B3" => '&#33891;',
	"\xB8B4" => '&#33897;',
	"\xB8B5" => '&#33901;',
	"\xB8B6" => '&#33862;',
	"\xB8B7" => '&#34398;',
	"\xB8B8" => '&#34396;',
	"\xB8B9" => '&#34399;',
	"\xB8BA" => '&#34553;',
	"\xB8BB" => '&#34579;',
	"\xB8BC" => '&#34568;',
	"\xB8BD" => '&#34567;',
	"\xB8BE" => '&#34560;',
	"\xB8BF" => '&#34558;',
	"\xB8C0" => '&#34555;',
	"\xB8C1" => '&#34562;',
	"\xB8C2" => '&#34563;',
	"\xB8C3" => '&#34566;',
	"\xB8C4" => '&#34570;',
	"\xB8C5" => '&#34905;',
	"\xB8C6" => '&#35039;',
	"\xB8C7" => '&#35028;',
	"\xB8C8" => '&#35033;',
	"\xB8C9" => '&#35036;',
	"\xB8CA" => '&#35032;',
	"\xB8CB" => '&#35037;',
	"\xB8CC" => '&#35041;',
	"\xB8CD" => '&#35018;',
	"\xB8CE" => '&#35029;',
	"\xB8CF" => '&#35026;',
	"\xB8D0" => '&#35228;',
	"\xB8D1" => '&#35299;',
	"\xB8D2" => '&#35435;',
	"\xB8D3" => '&#35442;',
	"\xB8D4" => '&#35443;',
	"\xB8D5" => '&#35430;',
	"\xB8D6" => '&#35433;',
	"\xB8D7" => '&#35440;',
	"\xB8D8" => '&#35463;',
	"\xB8D9" => '&#35452;',
	"\xB8DA" => '&#35427;',
	"\xB8DB" => '&#35488;',
	"\xB8DC" => '&#35441;',
	"\xB8DD" => '&#35461;',
	"\xB8DE" => '&#35437;',
	"\xB8DF" => '&#35426;',
	"\xB8E0" => '&#35438;',
	"\xB8E1" => '&#35436;',
	"\xB8E2" => '&#35449;',
	"\xB8E3" => '&#35451;',
	"\xB8E4" => '&#35390;',
	"\xB8E5" => '&#35432;',
	"\xB8E6" => '&#35938;',
	"\xB8E7" => '&#35978;',
	"\xB8E8" => '&#35977;',
	"\xB8E9" => '&#36042;',
	"\xB8EA" => '&#36039;',
	"\xB8EB" => '&#36040;',
	"\xB8EC" => '&#36036;',
	"\xB8ED" => '&#36018;',
	"\xB8EE" => '&#36035;',
	"\xB8EF" => '&#36034;',
	"\xB8F0" => '&#36037;',
	"\xB8F1" => '&#36321;',
	"\xB8F2" => '&#36319;',
	"\xB8F3" => '&#36328;',
	"\xB8F4" => '&#36335;',
	"\xB8F5" => '&#36339;',
	"\xB8F6" => '&#36346;',
	"\xB8F7" => '&#36330;',
	"\xB8F8" => '&#36324;',
	"\xB8F9" => '&#36326;',
	"\xB8FA" => '&#36530;',
	"\xB8FB" => '&#36611;',
	"\xB8FC" => '&#36617;',
	"\xB8FD" => '&#36606;',
	"\xB8FE" => '&#36618;',
	"\xB940" => '&#36767;',
	"\xB941" => '&#36786;',
	"\xB942" => '&#36939;',
	"\xB943" => '&#36938;',
	"\xB944" => '&#36947;',
	"\xB945" => '&#36930;',
	"\xB946" => '&#36948;',
	"\xB947" => '&#36924;',
	"\xB948" => '&#36949;',
	"\xB949" => '&#36944;',
	"\xB94A" => '&#36935;',
	"\xB94B" => '&#36943;',
	"\xB94C" => '&#36942;',
	"\xB94D" => '&#36941;',
	"\xB94E" => '&#36945;',
	"\xB94F" => '&#36926;',
	"\xB950" => '&#36929;',
	"\xB951" => '&#37138;',
	"\xB952" => '&#37143;',
	"\xB953" => '&#37228;',
	"\xB954" => '&#37226;',
	"\xB955" => '&#37225;',
	"\xB956" => '&#37321;',
	"\xB957" => '&#37431;',
	"\xB958" => '&#37463;',
	"\xB959" => '&#37432;',
	"\xB95A" => '&#37437;',
	"\xB95B" => '&#37440;',
	"\xB95C" => '&#37438;',
	"\xB95D" => '&#37467;',
	"\xB95E" => '&#37451;',
	"\xB95F" => '&#37476;',
	"\xB960" => '&#37457;',
	"\xB961" => '&#37428;',
	"\xB962" => '&#37449;',
	"\xB963" => '&#37453;',
	"\xB964" => '&#37445;',
	"\xB965" => '&#37433;',
	"\xB966" => '&#37439;',
	"\xB967" => '&#37466;',
	"\xB968" => '&#38296;',
	"\xB969" => '&#38552;',
	"\xB96A" => '&#38548;',
	"\xB96B" => '&#38549;',
	"\xB96C" => '&#38605;',
	"\xB96D" => '&#38603;',
	"\xB96E" => '&#38601;',
	"\xB96F" => '&#38602;',
	"\xB970" => '&#38647;',
	"\xB971" => '&#38651;',
	"\xB972" => '&#38649;',
	"\xB973" => '&#38646;',
	"\xB974" => '&#38742;',
	"\xB975" => '&#38772;',
	"\xB976" => '&#38774;',
	"\xB977" => '&#38928;',
	"\xB978" => '&#38929;',
	"\xB979" => '&#38931;',
	"\xB97A" => '&#38922;',
	"\xB97B" => '&#38930;',
	"\xB97C" => '&#38924;',
	"\xB97D" => '&#39164;',
	"\xB97E" => '&#39156;',
	"\xB9A1" => '&#39165;',
	"\xB9A2" => '&#39166;',
	"\xB9A3" => '&#39347;',
	"\xB9A4" => '&#39345;',
	"\xB9A5" => '&#39348;',
	"\xB9A6" => '&#39649;',
	"\xB9A7" => '&#40169;',
	"\xB9A8" => '&#40578;',
	"\xB9A9" => '&#40718;',
	"\xB9AA" => '&#40723;',
	"\xB9AB" => '&#40736;',
	"\xB9AC" => '&#20711;',
	"\xB9AD" => '&#20718;',
	"\xB9AE" => '&#20709;',
	"\xB9AF" => '&#20694;',
	"\xB9B0" => '&#20717;',
	"\xB9B1" => '&#20698;',
	"\xB9B2" => '&#20693;',
	"\xB9B3" => '&#20687;',
	"\xB9B4" => '&#20689;',
	"\xB9B5" => '&#20721;',
	"\xB9B6" => '&#20686;',
	"\xB9B7" => '&#20713;',
	"\xB9B8" => '&#20834;',
	"\xB9B9" => '&#20979;',
	"\xB9BA" => '&#21123;',
	"\xB9BB" => '&#21122;',
	"\xB9BC" => '&#21297;',
	"\xB9BD" => '&#21421;',
	"\xB9BE" => '&#22014;',
	"\xB9BF" => '&#22016;',
	"\xB9C0" => '&#22043;',
	"\xB9C1" => '&#22039;',
	"\xB9C2" => '&#22013;',
	"\xB9C3" => '&#22036;',
	"\xB9C4" => '&#22022;',
	"\xB9C5" => '&#22025;',
	"\xB9C6" => '&#22029;',
	"\xB9C7" => '&#22030;',
	"\xB9C8" => '&#22007;',
	"\xB9C9" => '&#22038;',
	"\xB9CA" => '&#22047;',
	"\xB9CB" => '&#22024;',
	"\xB9CC" => '&#22032;',
	"\xB9CD" => '&#22006;',
	"\xB9CE" => '&#22296;',
	"\xB9CF" => '&#22294;',
	"\xB9D0" => '&#22645;',
	"\xB9D1" => '&#22654;',
	"\xB9D2" => '&#22659;',
	"\xB9D3" => '&#22675;',
	"\xB9D4" => '&#22666;',
	"\xB9D5" => '&#22649;',
	"\xB9D6" => '&#22661;',
	"\xB9D7" => '&#22653;',
	"\xB9D8" => '&#22781;',
	"\xB9D9" => '&#22821;',
	"\xB9DA" => '&#22818;',
	"\xB9DB" => '&#22820;',
	"\xB9DC" => '&#22890;',
	"\xB9DD" => '&#22889;',
	"\xB9DE" => '&#23265;',
	"\xB9DF" => '&#23270;',
	"\xB9E0" => '&#23273;',
	"\xB9E1" => '&#23255;',
	"\xB9E2" => '&#23254;',
	"\xB9E3" => '&#23256;',
	"\xB9E4" => '&#23267;',
	"\xB9E5" => '&#23413;',
	"\xB9E6" => '&#23518;',
	"\xB9E7" => '&#23527;',
	"\xB9E8" => '&#23521;',
	"\xB9E9" => '&#23525;',
	"\xB9EA" => '&#23526;',
	"\xB9EB" => '&#23528;',
	"\xB9EC" => '&#23522;',
	"\xB9ED" => '&#23524;',
	"\xB9EE" => '&#23519;',
	"\xB9EF" => '&#23565;',
	"\xB9F0" => '&#23650;',
	"\xB9F1" => '&#23940;',
	"\xB9F2" => '&#23943;',
	"\xB9F3" => '&#24155;',
	"\xB9F4" => '&#24163;',
	"\xB9F5" => '&#24149;',
	"\xB9F6" => '&#24151;',
	"\xB9F7" => '&#24148;',
	"\xB9F8" => '&#24275;',
	"\xB9F9" => '&#24278;',
	"\xB9FA" => '&#24330;',
	"\xB9FB" => '&#24390;',
	"\xB9FC" => '&#24432;',
	"\xB9FD" => '&#24505;',
	"\xB9FE" => '&#24903;',
	"\xBA40" => '&#24895;',
	"\xBA41" => '&#24907;',
	"\xBA42" => '&#24951;',
	"\xBA43" => '&#24930;',
	"\xBA44" => '&#24931;',
	"\xBA45" => '&#24927;',
	"\xBA46" => '&#24922;',
	"\xBA47" => '&#24920;',
	"\xBA48" => '&#24949;',
	"\xBA49" => '&#25130;',
	"\xBA4A" => '&#25735;',
	"\xBA4B" => '&#25688;',
	"\xBA4C" => '&#25684;',
	"\xBA4D" => '&#25764;',
	"\xBA4E" => '&#25720;',
	"\xBA4F" => '&#25695;',
	"\xBA50" => '&#25722;',
	"\xBA51" => '&#25681;',
	"\xBA52" => '&#25703;',
	"\xBA53" => '&#25652;',
	"\xBA54" => '&#25709;',
	"\xBA55" => '&#25723;',
	"\xBA56" => '&#25970;',
	"\xBA57" => '&#26017;',
	"\xBA58" => '&#26071;',
	"\xBA59" => '&#26070;',
	"\xBA5A" => '&#26274;',
	"\xBA5B" => '&#26280;',
	"\xBA5C" => '&#26269;',
	"\xBA5D" => '&#27036;',
	"\xBA5E" => '&#27048;',
	"\xBA5F" => '&#27029;',
	"\xBA60" => '&#27073;',
	"\xBA61" => '&#27054;',
	"\xBA62" => '&#27091;',
	"\xBA63" => '&#27083;',
	"\xBA64" => '&#27035;',
	"\xBA65" => '&#27063;',
	"\xBA66" => '&#27067;',
	"\xBA67" => '&#27051;',
	"\xBA68" => '&#27060;',
	"\xBA69" => '&#27088;',
	"\xBA6A" => '&#27085;',
	"\xBA6B" => '&#27053;',
	"\xBA6C" => '&#27084;',
	"\xBA6D" => '&#27046;',
	"\xBA6E" => '&#27075;',
	"\xBA6F" => '&#27043;',
	"\xBA70" => '&#27465;',
	"\xBA71" => '&#27468;',
	"\xBA72" => '&#27699;',
	"\xBA73" => '&#28467;',
	"\xBA74" => '&#28436;',
	"\xBA75" => '&#28414;',
	"\xBA76" => '&#28435;',
	"\xBA77" => '&#28404;',
	"\xBA78" => '&#28457;',
	"\xBA79" => '&#28478;',
	"\xBA7A" => '&#28448;',
	"\xBA7B" => '&#28460;',
	"\xBA7C" => '&#28431;',
	"\xBA7D" => '&#28418;',
	"\xBA7E" => '&#28450;',
	"\xBAA1" => '&#28415;',
	"\xBAA2" => '&#28399;',
	"\xBAA3" => '&#28422;',
	"\xBAA4" => '&#28465;',
	"\xBAA5" => '&#28472;',
	"\xBAA6" => '&#28466;',
	"\xBAA7" => '&#28451;',
	"\xBAA8" => '&#28437;',
	"\xBAA9" => '&#28459;',
	"\xBAAA" => '&#28463;',
	"\xBAAB" => '&#28552;',
	"\xBAAC" => '&#28458;',
	"\xBAAD" => '&#28396;',
	"\xBAAE" => '&#28417;',
	"\xBAAF" => '&#28402;',
	"\xBAB0" => '&#28364;',
	"\xBAB1" => '&#28407;',
	"\xBAB2" => '&#29076;',
	"\xBAB3" => '&#29081;',
	"\xBAB4" => '&#29053;',
	"\xBAB5" => '&#29066;',
	"\xBAB6" => '&#29060;',
	"\xBAB7" => '&#29074;',
	"\xBAB8" => '&#29246;',
	"\xBAB9" => '&#29330;',
	"\xBABA" => '&#29334;',
	"\xBABB" => '&#29508;',
	"\xBABC" => '&#29520;',
	"\xBABD" => '&#29796;',
	"\xBABE" => '&#29795;',
	"\xBABF" => '&#29802;',
	"\xBAC0" => '&#29808;',
	"\xBAC1" => '&#29805;',
	"\xBAC2" => '&#29956;',
	"\xBAC3" => '&#30097;',
	"\xBAC4" => '&#30247;',
	"\xBAC5" => '&#30221;',
	"\xBAC6" => '&#30219;',
	"\xBAC7" => '&#30217;',
	"\xBAC8" => '&#30227;',
	"\xBAC9" => '&#30433;',
	"\xBACA" => '&#30435;',
	"\xBACB" => '&#30596;',
	"\xBACC" => '&#30589;',
	"\xBACD" => '&#30591;',
	"\xBACE" => '&#30561;',
	"\xBACF" => '&#30913;',
	"\xBAD0" => '&#30879;',
	"\xBAD1" => '&#30887;',
	"\xBAD2" => '&#30899;',
	"\xBAD3" => '&#30889;',
	"\xBAD4" => '&#30883;',
	"\xBAD5" => '&#31118;',
	"\xBAD6" => '&#31119;',
	"\xBAD7" => '&#31117;',
	"\xBAD8" => '&#31278;',
	"\xBAD9" => '&#31281;',
	"\xBADA" => '&#31402;',
	"\xBADB" => '&#31401;',
	"\xBADC" => '&#31469;',
	"\xBADD" => '&#31471;',
	"\xBADE" => '&#31649;',
	"\xBADF" => '&#31637;',
	"\xBAE0" => '&#31627;',
	"\xBAE1" => '&#31605;',
	"\xBAE2" => '&#31639;',
	"\xBAE3" => '&#31645;',
	"\xBAE4" => '&#31636;',
	"\xBAE5" => '&#31631;',
	"\xBAE6" => '&#31672;',
	"\xBAE7" => '&#31623;',
	"\xBAE8" => '&#31620;',
	"\xBAE9" => '&#31929;',
	"\xBAEA" => '&#31933;',
	"\xBAEB" => '&#31934;',
	"\xBAEC" => '&#32187;',
	"\xBAED" => '&#32176;',
	"\xBAEE" => '&#32156;',
	"\xBAEF" => '&#32189;',
	"\xBAF0" => '&#32190;',
	"\xBAF1" => '&#32160;',
	"\xBAF2" => '&#32202;',
	"\xBAF3" => '&#32180;',
	"\xBAF4" => '&#32178;',
	"\xBAF5" => '&#32177;',
	"\xBAF6" => '&#32186;',
	"\xBAF7" => '&#32162;',
	"\xBAF8" => '&#32191;',
	"\xBAF9" => '&#32181;',
	"\xBAFA" => '&#32184;',
	"\xBAFB" => '&#32173;',
	"\xBAFC" => '&#32210;',
	"\xBAFD" => '&#32199;',
	"\xBAFE" => '&#32172;',
	"\xBB40" => '&#32624;',
	"\xBB41" => '&#32736;',
	"\xBB42" => '&#32737;',
	"\xBB43" => '&#32735;',
	"\xBB44" => '&#32862;',
	"\xBB45" => '&#32858;',
	"\xBB46" => '&#32903;',
	"\xBB47" => '&#33104;',
	"\xBB48" => '&#33152;',
	"\xBB49" => '&#33167;',
	"\xBB4A" => '&#33160;',
	"\xBB4B" => '&#33162;',
	"\xBB4C" => '&#33151;',
	"\xBB4D" => '&#33154;',
	"\xBB4E" => '&#33255;',
	"\xBB4F" => '&#33274;',
	"\xBB50" => '&#33287;',
	"\xBB51" => '&#33300;',
	"\xBB52" => '&#33310;',
	"\xBB53" => '&#33355;',
	"\xBB54" => '&#33993;',
	"\xBB55" => '&#33983;',
	"\xBB56" => '&#33990;',
	"\xBB57" => '&#33988;',
	"\xBB58" => '&#33945;',
	"\xBB59" => '&#33950;',
	"\xBB5A" => '&#33970;',
	"\xBB5B" => '&#33948;',
	"\xBB5C" => '&#33995;',
	"\xBB5D" => '&#33976;',
	"\xBB5E" => '&#33984;',
	"\xBB5F" => '&#34003;',
	"\xBB60" => '&#33936;',
	"\xBB61" => '&#33980;',
	"\xBB62" => '&#34001;',
	"\xBB63" => '&#33994;',
	"\xBB64" => '&#34623;',
	"\xBB65" => '&#34588;',
	"\xBB66" => '&#34619;',
	"\xBB67" => '&#34594;',
	"\xBB68" => '&#34597;',
	"\xBB69" => '&#34612;',
	"\xBB6A" => '&#34584;',
	"\xBB6B" => '&#34645;',
	"\xBB6C" => '&#34615;',
	"\xBB6D" => '&#34601;',
	"\xBB6E" => '&#35059;',
	"\xBB6F" => '&#35074;',
	"\xBB70" => '&#35060;',
	"\xBB71" => '&#35065;',
	"\xBB72" => '&#35064;',
	"\xBB73" => '&#35069;',
	"\xBB74" => '&#35048;',
	"\xBB75" => '&#35098;',
	"\xBB76" => '&#35055;',
	"\xBB77" => '&#35494;',
	"\xBB78" => '&#35468;',
	"\xBB79" => '&#35486;',
	"\xBB7A" => '&#35491;',
	"\xBB7B" => '&#35469;',
	"\xBB7C" => '&#35489;',
	"\xBB7D" => '&#35475;',
	"\xBB7E" => '&#35492;',
	"\xBBA1" => '&#35498;',
	"\xBBA2" => '&#35493;',
	"\xBBA3" => '&#35496;',
	"\xBBA4" => '&#35480;',
	"\xBBA5" => '&#35473;',
	"\xBBA6" => '&#35482;',
	"\xBBA7" => '&#35495;',
	"\xBBA8" => '&#35946;',
	"\xBBA9" => '&#35981;',
	"\xBBAA" => '&#35980;',
	"\xBBAB" => '&#36051;',
	"\xBBAC" => '&#36049;',
	"\xBBAD" => '&#36050;',
	"\xBBAE" => '&#36203;',
	"\xBBAF" => '&#36249;',
	"\xBBB0" => '&#36245;',
	"\xBBB1" => '&#36348;',
	"\xBBB2" => '&#36628;',
	"\xBBB3" => '&#36626;',
	"\xBBB4" => '&#36629;',
	"\xBBB5" => '&#36627;',
	"\xBBB6" => '&#36771;',
	"\xBBB7" => '&#36960;',
	"\xBBB8" => '&#36952;',
	"\xBBB9" => '&#36956;',
	"\xBBBA" => '&#36963;',
	"\xBBBB" => '&#36953;',
	"\xBBBC" => '&#36958;',
	"\xBBBD" => '&#36962;',
	"\xBBBE" => '&#36957;',
	"\xBBBF" => '&#36955;',
	"\xBBC0" => '&#37145;',
	"\xBBC1" => '&#37144;',
	"\xBBC2" => '&#37150;',
	"\xBBC3" => '&#37237;',
	"\xBBC4" => '&#37240;',
	"\xBBC5" => '&#37239;',
	"\xBBC6" => '&#37236;',
	"\xBBC7" => '&#37496;',
	"\xBBC8" => '&#37504;',
	"\xBBC9" => '&#37509;',
	"\xBBCA" => '&#37528;',
	"\xBBCB" => '&#37526;',
	"\xBBCC" => '&#37499;',
	"\xBBCD" => '&#37523;',
	"\xBBCE" => '&#37532;',
	"\xBBCF" => '&#37544;',
	"\xBBD0" => '&#37500;',
	"\xBBD1" => '&#37521;',
	"\xBBD2" => '&#38305;',
	"\xBBD3" => '&#38312;',
	"\xBBD4" => '&#38313;',
	"\xBBD5" => '&#38307;',
	"\xBBD6" => '&#38309;',
	"\xBBD7" => '&#38308;',
	"\xBBD8" => '&#38553;',
	"\xBBD9" => '&#38556;',
	"\xBBDA" => '&#38555;',
	"\xBBDB" => '&#38604;',
	"\xBBDC" => '&#38610;',
	"\xBBDD" => '&#38656;',
	"\xBBDE" => '&#38780;',
	"\xBBDF" => '&#38789;',
	"\xBBE0" => '&#38902;',
	"\xBBE1" => '&#38935;',
	"\xBBE2" => '&#38936;',
	"\xBBE3" => '&#39087;',
	"\xBBE4" => '&#39089;',
	"\xBBE5" => '&#39171;',
	"\xBBE6" => '&#39173;',
	"\xBBE7" => '&#39180;',
	"\xBBE8" => '&#39177;',
	"\xBBE9" => '&#39361;',
	"\xBBEA" => '&#39599;',
	"\xBBEB" => '&#39600;',
	"\xBBEC" => '&#39654;',
	"\xBBED" => '&#39745;',
	"\xBBEE" => '&#39746;',
	"\xBBEF" => '&#40180;',
	"\xBBF0" => '&#40182;',
	"\xBBF1" => '&#40179;',
	"\xBBF2" => '&#40636;',
	"\xBBF3" => '&#40763;',
	"\xBBF4" => '&#40778;',
	"\xBBF5" => '&#20740;',
	"\xBBF6" => '&#20736;',
	"\xBBF7" => '&#20731;',
	"\xBBF8" => '&#20725;',
	"\xBBF9" => '&#20729;',
	"\xBBFA" => '&#20738;',
	"\xBBFB" => '&#20744;',
	"\xBBFC" => '&#20745;',
	"\xBBFD" => '&#20741;',
	"\xBBFE" => '&#20956;',
	"\xBC40" => '&#21127;',
	"\xBC41" => '&#21128;',
	"\xBC42" => '&#21129;',
	"\xBC43" => '&#21133;',
	"\xBC44" => '&#21130;',
	"\xBC45" => '&#21232;',
	"\xBC46" => '&#21426;',
	"\xBC47" => '&#22062;',
	"\xBC48" => '&#22075;',
	"\xBC49" => '&#22073;',
	"\xBC4A" => '&#22066;',
	"\xBC4B" => '&#22079;',
	"\xBC4C" => '&#22068;',
	"\xBC4D" => '&#22057;',
	"\xBC4E" => '&#22099;',
	"\xBC4F" => '&#22094;',
	"\xBC50" => '&#22103;',
	"\xBC51" => '&#22132;',
	"\xBC52" => '&#22070;',
	"\xBC53" => '&#22063;',
	"\xBC54" => '&#22064;',
	"\xBC55" => '&#22656;',
	"\xBC56" => '&#22687;',
	"\xBC57" => '&#22686;',
	"\xBC58" => '&#22707;',
	"\xBC59" => '&#22684;',
	"\xBC5A" => '&#22702;',
	"\xBC5B" => '&#22697;',
	"\xBC5C" => '&#22694;',
	"\xBC5D" => '&#22893;',
	"\xBC5E" => '&#23305;',
	"\xBC5F" => '&#23291;',
	"\xBC60" => '&#23307;',
	"\xBC61" => '&#23285;',
	"\xBC62" => '&#23308;',
	"\xBC63" => '&#23304;',
	"\xBC64" => '&#23534;',
	"\xBC65" => '&#23532;',
	"\xBC66" => '&#23529;',
	"\xBC67" => '&#23531;',
	"\xBC68" => '&#23652;',
	"\xBC69" => '&#23653;',
	"\xBC6A" => '&#23965;',
	"\xBC6B" => '&#23956;',
	"\xBC6C" => '&#24162;',
	"\xBC6D" => '&#24159;',
	"\xBC6E" => '&#24161;',
	"\xBC6F" => '&#24290;',
	"\xBC70" => '&#24282;',
	"\xBC71" => '&#24287;',
	"\xBC72" => '&#24285;',
	"\xBC73" => '&#24291;',
	"\xBC74" => '&#24288;',
	"\xBC75" => '&#24392;',
	"\xBC76" => '&#24433;',
	"\xBC77" => '&#24503;',
	"\xBC78" => '&#24501;',
	"\xBC79" => '&#24950;',
	"\xBC7A" => '&#24935;',
	"\xBC7B" => '&#24942;',
	"\xBC7C" => '&#24925;',
	"\xBC7D" => '&#24917;',
	"\xBC7E" => '&#24962;',
	"\xBCA1" => '&#24956;',
	"\xBCA2" => '&#24944;',
	"\xBCA3" => '&#24939;',
	"\xBCA4" => '&#24958;',
	"\xBCA5" => '&#24999;',
	"\xBCA6" => '&#24976;',
	"\xBCA7" => '&#25003;',
	"\xBCA8" => '&#24974;',
	"\xBCA9" => '&#25004;',
	"\xBCAA" => '&#24986;',
	"\xBCAB" => '&#24996;',
	"\xBCAC" => '&#24980;',
	"\xBCAD" => '&#25006;',
	"\xBCAE" => '&#25134;',
	"\xBCAF" => '&#25705;',
	"\xBCB0" => '&#25711;',
	"\xBCB1" => '&#25721;',
	"\xBCB2" => '&#25758;',
	"\xBCB3" => '&#25778;',
	"\xBCB4" => '&#25736;',
	"\xBCB5" => '&#25744;',
	"\xBCB6" => '&#25776;',
	"\xBCB7" => '&#25765;',
	"\xBCB8" => '&#25747;',
	"\xBCB9" => '&#25749;',
	"\xBCBA" => '&#25769;',
	"\xBCBB" => '&#25746;',
	"\xBCBC" => '&#25774;',
	"\xBCBD" => '&#25773;',
	"\xBCBE" => '&#25771;',
	"\xBCBF" => '&#25754;',
	"\xBCC0" => '&#25772;',
	"\xBCC1" => '&#25753;',
	"\xBCC2" => '&#25762;',
	"\xBCC3" => '&#25779;',
	"\xBCC4" => '&#25973;',
	"\xBCC5" => '&#25975;',
	"\xBCC6" => '&#25976;',
	"\xBCC7" => '&#26286;',
	"\xBCC8" => '&#26283;',
	"\xBCC9" => '&#26292;',
	"\xBCCA" => '&#26289;',
	"\xBCCB" => '&#27171;',
	"\xBCCC" => '&#27167;',
	"\xBCCD" => '&#27112;',
	"\xBCCE" => '&#27137;',
	"\xBCCF" => '&#27166;',
	"\xBCD0" => '&#27161;',
	"\xBCD1" => '&#27133;',
	"\xBCD2" => '&#27169;',
	"\xBCD3" => '&#27155;',
	"\xBCD4" => '&#27146;',
	"\xBCD5" => '&#27123;',
	"\xBCD6" => '&#27138;',
	"\xBCD7" => '&#27141;',
	"\xBCD8" => '&#27117;',
	"\xBCD9" => '&#27153;',
	"\xBCDA" => '&#27472;',
	"\xBCDB" => '&#27470;',
	"\xBCDC" => '&#27556;',
	"\xBCDD" => '&#27589;',
	"\xBCDE" => '&#27590;',
	"\xBCDF" => '&#28479;',
	"\xBCE0" => '&#28540;',
	"\xBCE1" => '&#28548;',
	"\xBCE2" => '&#28497;',
	"\xBCE3" => '&#28518;',
	"\xBCE4" => '&#28500;',
	"\xBCE5" => '&#28550;',
	"\xBCE6" => '&#28525;',
	"\xBCE7" => '&#28507;',
	"\xBCE8" => '&#28536;',
	"\xBCE9" => '&#28526;',
	"\xBCEA" => '&#28558;',
	"\xBCEB" => '&#28538;',
	"\xBCEC" => '&#28528;',
	"\xBCED" => '&#28516;',
	"\xBCEE" => '&#28567;',
	"\xBCEF" => '&#28504;',
	"\xBCF0" => '&#28373;',
	"\xBCF1" => '&#28527;',
	"\xBCF2" => '&#28512;',
	"\xBCF3" => '&#28511;',
	"\xBCF4" => '&#29087;',
	"\xBCF5" => '&#29100;',
	"\xBCF6" => '&#29105;',
	"\xBCF7" => '&#29096;',
	"\xBCF8" => '&#29270;',
	"\xBCF9" => '&#29339;',
	"\xBCFA" => '&#29518;',
	"\xBCFB" => '&#29527;',
	"\xBCFC" => '&#29801;',
	"\xBCFD" => '&#29835;',
	"\xBCFE" => '&#29827;',
	"\xBD40" => '&#29822;',
	"\xBD41" => '&#29824;',
	"\xBD42" => '&#30079;',
	"\xBD43" => '&#30240;',
	"\xBD44" => '&#30249;',
	"\xBD45" => '&#30239;',
	"\xBD46" => '&#30244;',
	"\xBD47" => '&#30246;',
	"\xBD48" => '&#30241;',
	"\xBD49" => '&#30242;',
	"\xBD4A" => '&#30362;',
	"\xBD4B" => '&#30394;',
	"\xBD4C" => '&#30436;',
	"\xBD4D" => '&#30606;',
	"\xBD4E" => '&#30599;',
	"\xBD4F" => '&#30604;',
	"\xBD50" => '&#30609;',
	"\xBD51" => '&#30603;',
	"\xBD52" => '&#30923;',
	"\xBD53" => '&#30917;',
	"\xBD54" => '&#30906;',
	"\xBD55" => '&#30922;',
	"\xBD56" => '&#30910;',
	"\xBD57" => '&#30933;',
	"\xBD58" => '&#30908;',
	"\xBD59" => '&#30928;',
	"\xBD5A" => '&#31295;',
	"\xBD5B" => '&#31292;',
	"\xBD5C" => '&#31296;',
	"\xBD5D" => '&#31293;',
	"\xBD5E" => '&#31287;',
	"\xBD5F" => '&#31291;',
	"\xBD60" => '&#31407;',
	"\xBD61" => '&#31406;',
	"\xBD62" => '&#31661;',
	"\xBD63" => '&#31665;',
	"\xBD64" => '&#31684;',
	"\xBD65" => '&#31668;',
	"\xBD66" => '&#31686;',
	"\xBD67" => '&#31687;',
	"\xBD68" => '&#31681;',
	"\xBD69" => '&#31648;',
	"\xBD6A" => '&#31692;',
	"\xBD6B" => '&#31946;',
	"\xBD6C" => '&#32224;',
	"\xBD6D" => '&#32244;',
	"\xBD6E" => '&#32239;',
	"\xBD6F" => '&#32251;',
	"\xBD70" => '&#32216;',
	"\xBD71" => '&#32236;',
	"\xBD72" => '&#32221;',
	"\xBD73" => '&#32232;',
	"\xBD74" => '&#32227;',
	"\xBD75" => '&#32218;',
	"\xBD76" => '&#32222;',
	"\xBD77" => '&#32233;',
	"\xBD78" => '&#32158;',
	"\xBD79" => '&#32217;',
	"\xBD7A" => '&#32242;',
	"\xBD7B" => '&#32249;',
	"\xBD7C" => '&#32629;',
	"\xBD7D" => '&#32631;',
	"\xBD7E" => '&#32687;',
	"\xBDA1" => '&#32745;',
	"\xBDA2" => '&#32806;',
	"\xBDA3" => '&#33179;',
	"\xBDA4" => '&#33180;',
	"\xBDA5" => '&#33181;',
	"\xBDA6" => '&#33184;',
	"\xBDA7" => '&#33178;',
	"\xBDA8" => '&#33176;',
	"\xBDA9" => '&#34071;',
	"\xBDAA" => '&#34109;',
	"\xBDAB" => '&#34074;',
	"\xBDAC" => '&#34030;',
	"\xBDAD" => '&#34092;',
	"\xBDAE" => '&#34093;',
	"\xBDAF" => '&#34067;',
	"\xBDB0" => '&#34065;',
	"\xBDB1" => '&#34083;',
	"\xBDB2" => '&#34081;',
	"\xBDB3" => '&#34068;',
	"\xBDB4" => '&#34028;',
	"\xBDB5" => '&#34085;',
	"\xBDB6" => '&#34047;',
	"\xBDB7" => '&#34054;',
	"\xBDB8" => '&#34690;',
	"\xBDB9" => '&#34676;',
	"\xBDBA" => '&#34678;',
	"\xBDBB" => '&#34656;',
	"\xBDBC" => '&#34662;',
	"\xBDBD" => '&#34680;',
	"\xBDBE" => '&#34664;',
	"\xBDBF" => '&#34649;',
	"\xBDC0" => '&#34647;',
	"\xBDC1" => '&#34636;',
	"\xBDC2" => '&#34643;',
	"\xBDC3" => '&#34907;',
	"\xBDC4" => '&#34909;',
	"\xBDC5" => '&#35088;',
	"\xBDC6" => '&#35079;',
	"\xBDC7" => '&#35090;',
	"\xBDC8" => '&#35091;',
	"\xBDC9" => '&#35093;',
	"\xBDCA" => '&#35082;',
	"\xBDCB" => '&#35516;',
	"\xBDCC" => '&#35538;',
	"\xBDCD" => '&#35527;',
	"\xBDCE" => '&#35524;',
	"\xBDCF" => '&#35477;',
	"\xBDD0" => '&#35531;',
	"\xBDD1" => '&#35576;',
	"\xBDD2" => '&#35506;',
	"\xBDD3" => '&#35529;',
	"\xBDD4" => '&#35522;',
	"\xBDD5" => '&#35519;',
	"\xBDD6" => '&#35504;',
	"\xBDD7" => '&#35542;',
	"\xBDD8" => '&#35533;',
	"\xBDD9" => '&#35510;',
	"\xBDDA" => '&#35513;',
	"\xBDDB" => '&#35547;',
	"\xBDDC" => '&#35916;',
	"\xBDDD" => '&#35918;',
	"\xBDDE" => '&#35948;',
	"\xBDDF" => '&#36064;',
	"\xBDE0" => '&#36062;',
	"\xBDE1" => '&#36070;',
	"\xBDE2" => '&#36068;',
	"\xBDE3" => '&#36076;',
	"\xBDE4" => '&#36077;',
	"\xBDE5" => '&#36066;',
	"\xBDE6" => '&#36067;',
	"\xBDE7" => '&#36060;',
	"\xBDE8" => '&#36074;',
	"\xBDE9" => '&#36065;',
	"\xBDEA" => '&#36205;',
	"\xBDEB" => '&#36255;',
	"\xBDEC" => '&#36259;',
	"\xBDED" => '&#36395;',
	"\xBDEE" => '&#36368;',
	"\xBDEF" => '&#36381;',
	"\xBDF0" => '&#36386;',
	"\xBDF1" => '&#36367;',
	"\xBDF2" => '&#36393;',
	"\xBDF3" => '&#36383;',
	"\xBDF4" => '&#36385;',
	"\xBDF5" => '&#36382;',
	"\xBDF6" => '&#36538;',
	"\xBDF7" => '&#36637;',
	"\xBDF8" => '&#36635;',
	"\xBDF9" => '&#36639;',
	"\xBDFA" => '&#36649;',
	"\xBDFB" => '&#36646;',
	"\xBDFC" => '&#36650;',
	"\xBDFD" => '&#36636;',
	"\xBDFE" => '&#36638;',
	"\xBE40" => '&#36645;',
	"\xBE41" => '&#36969;',
	"\xBE42" => '&#36974;',
	"\xBE43" => '&#36968;',
	"\xBE44" => '&#36973;',
	"\xBE45" => '&#36983;',
	"\xBE46" => '&#37168;',
	"\xBE47" => '&#37165;',
	"\xBE48" => '&#37159;',
	"\xBE49" => '&#37169;',
	"\xBE4A" => '&#37255;',
	"\xBE4B" => '&#37257;',
	"\xBE4C" => '&#37259;',
	"\xBE4D" => '&#37251;',
	"\xBE4E" => '&#37573;',
	"\xBE4F" => '&#37563;',
	"\xBE50" => '&#37559;',
	"\xBE51" => '&#37610;',
	"\xBE52" => '&#37548;',
	"\xBE53" => '&#37604;',
	"\xBE54" => '&#37569;',
	"\xBE55" => '&#37555;',
	"\xBE56" => '&#37564;',
	"\xBE57" => '&#37586;',
	"\xBE58" => '&#37575;',
	"\xBE59" => '&#37616;',
	"\xBE5A" => '&#37554;',
	"\xBE5B" => '&#38317;',
	"\xBE5C" => '&#38321;',
	"\xBE5D" => '&#38660;',
	"\xBE5E" => '&#38662;',
	"\xBE5F" => '&#38663;',
	"\xBE60" => '&#38665;',
	"\xBE61" => '&#38752;',
	"\xBE62" => '&#38797;',
	"\xBE63" => '&#38795;',
	"\xBE64" => '&#38799;',
	"\xBE65" => '&#38945;',
	"\xBE66" => '&#38955;',
	"\xBE67" => '&#38940;',
	"\xBE68" => '&#39091;',
	"\xBE69" => '&#39178;',
	"\xBE6A" => '&#39187;',
	"\xBE6B" => '&#39186;',
	"\xBE6C" => '&#39192;',
	"\xBE6D" => '&#39389;',
	"\xBE6E" => '&#39376;',
	"\xBE6F" => '&#39391;',
	"\xBE70" => '&#39387;',
	"\xBE71" => '&#39377;',
	"\xBE72" => '&#39381;',
	"\xBE73" => '&#39378;',
	"\xBE74" => '&#39385;',
	"\xBE75" => '&#39607;',
	"\xBE76" => '&#39662;',
	"\xBE77" => '&#39663;',
	"\xBE78" => '&#39719;',
	"\xBE79" => '&#39749;',
	"\xBE7A" => '&#39748;',
	"\xBE7B" => '&#39799;',
	"\xBE7C" => '&#39791;',
	"\xBE7D" => '&#40198;',
	"\xBE7E" => '&#40201;',
	"\xBEA1" => '&#40195;',
	"\xBEA2" => '&#40617;',
	"\xBEA3" => '&#40638;',
	"\xBEA4" => '&#40654;',
	"\xBEA5" => '&#22696;',
	"\xBEA6" => '&#40786;',
	"\xBEA7" => '&#20754;',
	"\xBEA8" => '&#20760;',
	"\xBEA9" => '&#20756;',
	"\xBEAA" => '&#20752;',
	"\xBEAB" => '&#20757;',
	"\xBEAC" => '&#20864;',
	"\xBEAD" => '&#20906;',
	"\xBEAE" => '&#20957;',
	"\xBEAF" => '&#21137;',
	"\xBEB0" => '&#21139;',
	"\xBEB1" => '&#21235;',
	"\xBEB2" => '&#22105;',
	"\xBEB3" => '&#22123;',
	"\xBEB4" => '&#22137;',
	"\xBEB5" => '&#22121;',
	"\xBEB6" => '&#22116;',
	"\xBEB7" => '&#22136;',
	"\xBEB8" => '&#22122;',
	"\xBEB9" => '&#22120;',
	"\xBEBA" => '&#22117;',
	"\xBEBB" => '&#22129;',
	"\xBEBC" => '&#22127;',
	"\xBEBD" => '&#22124;',
	"\xBEBE" => '&#22114;',
	"\xBEBF" => '&#22134;',
	"\xBEC0" => '&#22721;',
	"\xBEC1" => '&#22718;',
	"\xBEC2" => '&#22727;',
	"\xBEC3" => '&#22725;',
	"\xBEC4" => '&#22894;',
	"\xBEC5" => '&#23325;',
	"\xBEC6" => '&#23348;',
	"\xBEC7" => '&#23416;',
	"\xBEC8" => '&#23536;',
	"\xBEC9" => '&#23566;',
	"\xBECA" => '&#24394;',
	"\xBECB" => '&#25010;',
	"\xBECC" => '&#24977;',
	"\xBECD" => '&#25001;',
	"\xBECE" => '&#24970;',
	"\xBECF" => '&#25037;',
	"\xBED0" => '&#25014;',
	"\xBED1" => '&#25022;',
	"\xBED2" => '&#25034;',
	"\xBED3" => '&#25032;',
	"\xBED4" => '&#25136;',
	"\xBED5" => '&#25797;',
	"\xBED6" => '&#25793;',
	"\xBED7" => '&#25803;',
	"\xBED8" => '&#25787;',
	"\xBED9" => '&#25788;',
	"\xBEDA" => '&#25818;',
	"\xBEDB" => '&#25796;',
	"\xBEDC" => '&#25799;',
	"\xBEDD" => '&#25794;',
	"\xBEDE" => '&#25805;',
	"\xBEDF" => '&#25791;',
	"\xBEE0" => '&#25810;',
	"\xBEE1" => '&#25812;',
	"\xBEE2" => '&#25790;',
	"\xBEE3" => '&#25972;',
	"\xBEE4" => '&#26310;',
	"\xBEE5" => '&#26313;',
	"\xBEE6" => '&#26297;',
	"\xBEE7" => '&#26308;',
	"\xBEE8" => '&#26311;',
	"\xBEE9" => '&#26296;',
	"\xBEEA" => '&#27197;',
	"\xBEEB" => '&#27192;',
	"\xBEEC" => '&#27194;',
	"\xBEED" => '&#27225;',
	"\xBEEE" => '&#27243;',
	"\xBEEF" => '&#27224;',
	"\xBEF0" => '&#27193;',
	"\xBEF1" => '&#27204;',
	"\xBEF2" => '&#27234;',
	"\xBEF3" => '&#27233;',
	"\xBEF4" => '&#27211;',
	"\xBEF5" => '&#27207;',
	"\xBEF6" => '&#27189;',
	"\xBEF7" => '&#27231;',
	"\xBEF8" => '&#27208;',
	"\xBEF9" => '&#27481;',
	"\xBEFA" => '&#27511;',
	"\xBEFB" => '&#27653;',
	"\xBEFC" => '&#28610;',
	"\xBEFD" => '&#28593;',
	"\xBEFE" => '&#28577;',
	"\xBF40" => '&#28611;',
	"\xBF41" => '&#28580;',
	"\xBF42" => '&#28609;',
	"\xBF43" => '&#28583;',
	"\xBF44" => '&#28595;',
	"\xBF45" => '&#28608;',
	"\xBF46" => '&#28601;',
	"\xBF47" => '&#28598;',
	"\xBF48" => '&#28582;',
	"\xBF49" => '&#28576;',
	"\xBF4A" => '&#28596;',
	"\xBF4B" => '&#29118;',
	"\xBF4C" => '&#29129;',
	"\xBF4D" => '&#29136;',
	"\xBF4E" => '&#29138;',
	"\xBF4F" => '&#29128;',
	"\xBF50" => '&#29141;',
	"\xBF51" => '&#29113;',
	"\xBF52" => '&#29134;',
	"\xBF53" => '&#29145;',
	"\xBF54" => '&#29148;',
	"\xBF55" => '&#29123;',
	"\xBF56" => '&#29124;',
	"\xBF57" => '&#29544;',
	"\xBF58" => '&#29852;',
	"\xBF59" => '&#29859;',
	"\xBF5A" => '&#29848;',
	"\xBF5B" => '&#29855;',
	"\xBF5C" => '&#29854;',
	"\xBF5D" => '&#29922;',
	"\xBF5E" => '&#29964;',
	"\xBF5F" => '&#29965;',
	"\xBF60" => '&#30260;',
	"\xBF61" => '&#30264;',
	"\xBF62" => '&#30266;',
	"\xBF63" => '&#30439;',
	"\xBF64" => '&#30437;',
	"\xBF65" => '&#30624;',
	"\xBF66" => '&#30622;',
	"\xBF67" => '&#30623;',
	"\xBF68" => '&#30629;',
	"\xBF69" => '&#30952;',
	"\xBF6A" => '&#30938;',
	"\xBF6B" => '&#30956;',
	"\xBF6C" => '&#30951;',
	"\xBF6D" => '&#31142;',
	"\xBF6E" => '&#31309;',
	"\xBF6F" => '&#31310;',
	"\xBF70" => '&#31302;',
	"\xBF71" => '&#31308;',
	"\xBF72" => '&#31307;',
	"\xBF73" => '&#31418;',
	"\xBF74" => '&#31705;',
	"\xBF75" => '&#31761;',
	"\xBF76" => '&#31689;',
	"\xBF77" => '&#31716;',
	"\xBF78" => '&#31707;',
	"\xBF79" => '&#31713;',
	"\xBF7A" => '&#31721;',
	"\xBF7B" => '&#31718;',
	"\xBF7C" => '&#31957;',
	"\xBF7D" => '&#31958;',
	"\xBF7E" => '&#32266;',
	"\xBFA1" => '&#32273;',
	"\xBFA2" => '&#32264;',
	"\xBFA3" => '&#32283;',
	"\xBFA4" => '&#32291;',
	"\xBFA5" => '&#32286;',
	"\xBFA6" => '&#32285;',
	"\xBFA7" => '&#32265;',
	"\xBFA8" => '&#32272;',
	"\xBFA9" => '&#32633;',
	"\xBFAA" => '&#32690;',
	"\xBFAB" => '&#32752;',
	"\xBFAC" => '&#32753;',
	"\xBFAD" => '&#32750;',
	"\xBFAE" => '&#32808;',
	"\xBFAF" => '&#33203;',
	"\xBFB0" => '&#33193;',
	"\xBFB1" => '&#33192;',
	"\xBFB2" => '&#33275;',
	"\xBFB3" => '&#33288;',
	"\xBFB4" => '&#33368;',
	"\xBFB5" => '&#33369;',
	"\xBFB6" => '&#34122;',
	"\xBFB7" => '&#34137;',
	"\xBFB8" => '&#34120;',
	"\xBFB9" => '&#34152;',
	"\xBFBA" => '&#34153;',
	"\xBFBB" => '&#34115;',
	"\xBFBC" => '&#34121;',
	"\xBFBD" => '&#34157;',
	"\xBFBE" => '&#34154;',
	"\xBFBF" => '&#34142;',
	"\xBFC0" => '&#34691;',
	"\xBFC1" => '&#34719;',
	"\xBFC2" => '&#34718;',
	"\xBFC3" => '&#34722;',
	"\xBFC4" => '&#34701;',
	"\xBFC5" => '&#34913;',
	"\xBFC6" => '&#35114;',
	"\xBFC7" => '&#35122;',
	"\xBFC8" => '&#35109;',
	"\xBFC9" => '&#35115;',
	"\xBFCA" => '&#35105;',
	"\xBFCB" => '&#35242;',
	"\xBFCC" => '&#35238;',
	"\xBFCD" => '&#35558;',
	"\xBFCE" => '&#35578;',
	"\xBFCF" => '&#35563;',
	"\xBFD0" => '&#35569;',
	"\xBFD1" => '&#35584;',
	"\xBFD2" => '&#35548;',
	"\xBFD3" => '&#35559;',
	"\xBFD4" => '&#35566;',
	"\xBFD5" => '&#35582;',
	"\xBFD6" => '&#35585;',
	"\xBFD7" => '&#35586;',
	"\xBFD8" => '&#35575;',
	"\xBFD9" => '&#35565;',
	"\xBFDA" => '&#35571;',
	"\xBFDB" => '&#35574;',
	"\xBFDC" => '&#35580;',
	"\xBFDD" => '&#35947;',
	"\xBFDE" => '&#35949;',
	"\xBFDF" => '&#35987;',
	"\xBFE0" => '&#36084;',
	"\xBFE1" => '&#36420;',
	"\xBFE2" => '&#36401;',
	"\xBFE3" => '&#36404;',
	"\xBFE4" => '&#36418;',
	"\xBFE5" => '&#36409;',
	"\xBFE6" => '&#36405;',
	"\xBFE7" => '&#36667;',
	"\xBFE8" => '&#36655;',
	"\xBFE9" => '&#36664;',
	"\xBFEA" => '&#36659;',
	"\xBFEB" => '&#36776;',
	"\xBFEC" => '&#36774;',
	"\xBFED" => '&#36981;',
	"\xBFEE" => '&#36980;',
	"\xBFEF" => '&#36984;',
	"\xBFF0" => '&#36978;',
	"\xBFF1" => '&#36988;',
	"\xBFF2" => '&#36986;',
	"\xBFF3" => '&#37172;',
	"\xBFF4" => '&#37266;',
	"\xBFF5" => '&#37664;',
	"\xBFF6" => '&#37686;',
	"\xBFF7" => '&#37624;',
	"\xBFF8" => '&#37683;',
	"\xBFF9" => '&#37679;',
	"\xBFFA" => '&#37666;',
	"\xBFFB" => '&#37628;',
	"\xBFFC" => '&#37675;',
	"\xBFFD" => '&#37636;',
	"\xBFFE" => '&#37658;',
	"\xC040" => '&#37648;',
	"\xC041" => '&#37670;',
	"\xC042" => '&#37665;',
	"\xC043" => '&#37653;',
	"\xC044" => '&#37678;',
	"\xC045" => '&#37657;',
	"\xC046" => '&#38331;',
	"\xC047" => '&#38567;',
	"\xC048" => '&#38568;',
	"\xC049" => '&#38570;',
	"\xC04A" => '&#38613;',
	"\xC04B" => '&#38670;',
	"\xC04C" => '&#38673;',
	"\xC04D" => '&#38678;',
	"\xC04E" => '&#38669;',
	"\xC04F" => '&#38675;',
	"\xC050" => '&#38671;',
	"\xC051" => '&#38747;',
	"\xC052" => '&#38748;',
	"\xC053" => '&#38758;',
	"\xC054" => '&#38808;',
	"\xC055" => '&#38960;',
	"\xC056" => '&#38968;',
	"\xC057" => '&#38971;',
	"\xC058" => '&#38967;',
	"\xC059" => '&#38957;',
	"\xC05A" => '&#38969;',
	"\xC05B" => '&#38948;',
	"\xC05C" => '&#39184;',
	"\xC05D" => '&#39208;',
	"\xC05E" => '&#39198;',
	"\xC05F" => '&#39195;',
	"\xC060" => '&#39201;',
	"\xC061" => '&#39194;',
	"\xC062" => '&#39405;',
	"\xC063" => '&#39394;',
	"\xC064" => '&#39409;',
	"\xC065" => '&#39608;',
	"\xC066" => '&#39612;',
	"\xC067" => '&#39675;',
	"\xC068" => '&#39661;',
	"\xC069" => '&#39720;',
	"\xC06A" => '&#39825;',
	"\xC06B" => '&#40213;',
	"\xC06C" => '&#40227;',
	"\xC06D" => '&#40230;',
	"\xC06E" => '&#40232;',
	"\xC06F" => '&#40210;',
	"\xC070" => '&#40219;',
	"\xC071" => '&#40664;',
	"\xC072" => '&#40660;',
	"\xC073" => '&#40845;',
	"\xC074" => '&#40860;',
	"\xC075" => '&#20778;',
	"\xC076" => '&#20767;',
	"\xC077" => '&#20769;',
	"\xC078" => '&#20786;',
	"\xC079" => '&#21237;',
	"\xC07A" => '&#22158;',
	"\xC07B" => '&#22144;',
	"\xC07C" => '&#22160;',
	"\xC07D" => '&#22149;',
	"\xC07E" => '&#22151;',
	"\xC0A1" => '&#22159;',
	"\xC0A2" => '&#22741;',
	"\xC0A3" => '&#22739;',
	"\xC0A4" => '&#22737;',
	"\xC0A5" => '&#22734;',
	"\xC0A6" => '&#23344;',
	"\xC0A7" => '&#23338;',
	"\xC0A8" => '&#23332;',
	"\xC0A9" => '&#23418;',
	"\xC0AA" => '&#23607;',
	"\xC0AB" => '&#23656;',
	"\xC0AC" => '&#23996;',
	"\xC0AD" => '&#23994;',
	"\xC0AE" => '&#23997;',
	"\xC0AF" => '&#23992;',
	"\xC0B0" => '&#24171;',
	"\xC0B1" => '&#24396;',
	"\xC0B2" => '&#24509;',
	"\xC0B3" => '&#25033;',
	"\xC0B4" => '&#25026;',
	"\xC0B5" => '&#25031;',
	"\xC0B6" => '&#25062;',
	"\xC0B7" => '&#25035;',
	"\xC0B8" => '&#25138;',
	"\xC0B9" => '&#25140;',
	"\xC0BA" => '&#25806;',
	"\xC0BB" => '&#25802;',
	"\xC0BC" => '&#25816;',
	"\xC0BD" => '&#25824;',
	"\xC0BE" => '&#25840;',
	"\xC0BF" => '&#25830;',
	"\xC0C0" => '&#25836;',
	"\xC0C1" => '&#25841;',
	"\xC0C2" => '&#25826;',
	"\xC0C3" => '&#25837;',
	"\xC0C4" => '&#25986;',
	"\xC0C5" => '&#25987;',
	"\xC0C6" => '&#26329;',
	"\xC0C7" => '&#26326;',
	"\xC0C8" => '&#27264;',
	"\xC0C9" => '&#27284;',
	"\xC0CA" => '&#27268;',
	"\xC0CB" => '&#27298;',
	"\xC0CC" => '&#27292;',
	"\xC0CD" => '&#27355;',
	"\xC0CE" => '&#27299;',
	"\xC0CF" => '&#27262;',
	"\xC0D0" => '&#27287;',
	"\xC0D1" => '&#27280;',
	"\xC0D2" => '&#27296;',
	"\xC0D3" => '&#27484;',
	"\xC0D4" => '&#27566;',
	"\xC0D5" => '&#27610;',
	"\xC0D6" => '&#27656;',
	"\xC0D7" => '&#28632;',
	"\xC0D8" => '&#28657;',
	"\xC0D9" => '&#28639;',
	"\xC0DA" => '&#28640;',
	"\xC0DB" => '&#28635;',
	"\xC0DC" => '&#28644;',
	"\xC0DD" => '&#28651;',
	"\xC0DE" => '&#28655;',
	"\xC0DF" => '&#28544;',
	"\xC0E0" => '&#28652;',
	"\xC0E1" => '&#28641;',
	"\xC0E2" => '&#28649;',
	"\xC0E3" => '&#28629;',
	"\xC0E4" => '&#28654;',
	"\xC0E5" => '&#28656;',
	"\xC0E6" => '&#29159;',
	"\xC0E7" => '&#29151;',
	"\xC0E8" => '&#29166;',
	"\xC0E9" => '&#29158;',
	"\xC0EA" => '&#29157;',
	"\xC0EB" => '&#29165;',
	"\xC0EC" => '&#29164;',
	"\xC0ED" => '&#29172;',
	"\xC0EE" => '&#29152;',
	"\xC0EF" => '&#29237;',
	"\xC0F0" => '&#29254;',
	"\xC0F1" => '&#29552;',
	"\xC0F2" => '&#29554;',
	"\xC0F3" => '&#29865;',
	"\xC0F4" => '&#29872;',
	"\xC0F5" => '&#29862;',
	"\xC0F6" => '&#29864;',
	"\xC0F7" => '&#30278;',
	"\xC0F8" => '&#30274;',
	"\xC0F9" => '&#30284;',
	"\xC0FA" => '&#30442;',
	"\xC0FB" => '&#30643;',
	"\xC0FC" => '&#30634;',
	"\xC0FD" => '&#30640;',
	"\xC0FE" => '&#30636;',
	"\xC140" => '&#30631;',
	"\xC141" => '&#30637;',
	"\xC142" => '&#30703;',
	"\xC143" => '&#30967;',
	"\xC144" => '&#30970;',
	"\xC145" => '&#30964;',
	"\xC146" => '&#30959;',
	"\xC147" => '&#30977;',
	"\xC148" => '&#31143;',
	"\xC149" => '&#31146;',
	"\xC14A" => '&#31319;',
	"\xC14B" => '&#31423;',
	"\xC14C" => '&#31751;',
	"\xC14D" => '&#31757;',
	"\xC14E" => '&#31742;',
	"\xC14F" => '&#31735;',
	"\xC150" => '&#31756;',
	"\xC151" => '&#31712;',
	"\xC152" => '&#31968;',
	"\xC153" => '&#31964;',
	"\xC154" => '&#31966;',
	"\xC155" => '&#31970;',
	"\xC156" => '&#31967;',
	"\xC157" => '&#31961;',
	"\xC158" => '&#31965;',
	"\xC159" => '&#32302;',
	"\xC15A" => '&#32318;',
	"\xC15B" => '&#32326;',
	"\xC15C" => '&#32311;',
	"\xC15D" => '&#32306;',
	"\xC15E" => '&#32323;',
	"\xC15F" => '&#32299;',
	"\xC160" => '&#32317;',
	"\xC161" => '&#32305;',
	"\xC162" => '&#32325;',
	"\xC163" => '&#32321;',
	"\xC164" => '&#32308;',
	"\xC165" => '&#32313;',
	"\xC166" => '&#32328;',
	"\xC167" => '&#32309;',
	"\xC168" => '&#32319;',
	"\xC169" => '&#32303;',
	"\xC16A" => '&#32580;',
	"\xC16B" => '&#32755;',
	"\xC16C" => '&#32764;',
	"\xC16D" => '&#32881;',
	"\xC16E" => '&#32882;',
	"\xC16F" => '&#32880;',
	"\xC170" => '&#32879;',
	"\xC171" => '&#32883;',
	"\xC172" => '&#33222;',
	"\xC173" => '&#33219;',
	"\xC174" => '&#33210;',
	"\xC175" => '&#33218;',
	"\xC176" => '&#33216;',
	"\xC177" => '&#33215;',
	"\xC178" => '&#33213;',
	"\xC179" => '&#33225;',
	"\xC17A" => '&#33214;',
	"\xC17B" => '&#33256;',
	"\xC17C" => '&#33289;',
	"\xC17D" => '&#33393;',
	"\xC17E" => '&#34218;',
	"\xC1A1" => '&#34180;',
	"\xC1A2" => '&#34174;',
	"\xC1A3" => '&#34204;',
	"\xC1A4" => '&#34193;',
	"\xC1A5" => '&#34196;',
	"\xC1A6" => '&#34223;',
	"\xC1A7" => '&#34203;',
	"\xC1A8" => '&#34183;',
	"\xC1A9" => '&#34216;',
	"\xC1AA" => '&#34186;',
	"\xC1AB" => '&#34407;',
	"\xC1AC" => '&#34752;',
	"\xC1AD" => '&#34769;',
	"\xC1AE" => '&#34739;',
	"\xC1AF" => '&#34770;',
	"\xC1B0" => '&#34758;',
	"\xC1B1" => '&#34731;',
	"\xC1B2" => '&#34747;',
	"\xC1B3" => '&#34746;',
	"\xC1B4" => '&#34760;',
	"\xC1B5" => '&#34763;',
	"\xC1B6" => '&#35131;',
	"\xC1B7" => '&#35126;',
	"\xC1B8" => '&#35140;',
	"\xC1B9" => '&#35128;',
	"\xC1BA" => '&#35133;',
	"\xC1BB" => '&#35244;',
	"\xC1BC" => '&#35598;',
	"\xC1BD" => '&#35607;',
	"\xC1BE" => '&#35609;',
	"\xC1BF" => '&#35611;',
	"\xC1C0" => '&#35594;',
	"\xC1C1" => '&#35616;',
	"\xC1C2" => '&#35613;',
	"\xC1C3" => '&#35588;',
	"\xC1C4" => '&#35600;',
	"\xC1C5" => '&#35905;',
	"\xC1C6" => '&#35903;',
	"\xC1C7" => '&#35955;',
	"\xC1C8" => '&#36090;',
	"\xC1C9" => '&#36093;',
	"\xC1CA" => '&#36092;',
	"\xC1CB" => '&#36088;',
	"\xC1CC" => '&#36091;',
	"\xC1CD" => '&#36264;',
	"\xC1CE" => '&#36425;',
	"\xC1CF" => '&#36427;',
	"\xC1D0" => '&#36424;',
	"\xC1D1" => '&#36426;',
	"\xC1D2" => '&#36676;',
	"\xC1D3" => '&#36670;',
	"\xC1D4" => '&#36674;',
	"\xC1D5" => '&#36677;',
	"\xC1D6" => '&#36671;',
	"\xC1D7" => '&#36991;',
	"\xC1D8" => '&#36989;',
	"\xC1D9" => '&#36996;',
	"\xC1DA" => '&#36993;',
	"\xC1DB" => '&#36994;',
	"\xC1DC" => '&#36992;',
	"\xC1DD" => '&#37177;',
	"\xC1DE" => '&#37283;',
	"\xC1DF" => '&#37278;',
	"\xC1E0" => '&#37276;',
	"\xC1E1" => '&#37709;',
	"\xC1E2" => '&#37762;',
	"\xC1E3" => '&#37672;',
	"\xC1E4" => '&#37749;',
	"\xC1E5" => '&#37706;',
	"\xC1E6" => '&#37733;',
	"\xC1E7" => '&#37707;',
	"\xC1E8" => '&#37656;',
	"\xC1E9" => '&#37758;',
	"\xC1EA" => '&#37740;',
	"\xC1EB" => '&#37723;',
	"\xC1EC" => '&#37744;',
	"\xC1ED" => '&#37722;',
	"\xC1EE" => '&#37716;',
	"\xC1EF" => '&#38346;',
	"\xC1F0" => '&#38347;',
	"\xC1F1" => '&#38348;',
	"\xC1F2" => '&#38344;',
	"\xC1F3" => '&#38342;',
	"\xC1F4" => '&#38577;',
	"\xC1F5" => '&#38584;',
	"\xC1F6" => '&#38614;',
	"\xC1F7" => '&#38684;',
	"\xC1F8" => '&#38686;',
	"\xC1F9" => '&#38816;',
	"\xC1FA" => '&#38867;',
	"\xC1FB" => '&#38982;',
	"\xC1FC" => '&#39094;',
	"\xC1FD" => '&#39221;',
	"\xC1FE" => '&#39425;',
	"\xC240" => '&#39423;',
	"\xC241" => '&#39854;',
	"\xC242" => '&#39851;',
	"\xC243" => '&#39850;',
	"\xC244" => '&#39853;',
	"\xC245" => '&#40251;',
	"\xC246" => '&#40255;',
	"\xC247" => '&#40587;',
	"\xC248" => '&#40655;',
	"\xC249" => '&#40670;',
	"\xC24A" => '&#40668;',
	"\xC24B" => '&#40669;',
	"\xC24C" => '&#40667;',
	"\xC24D" => '&#40766;',
	"\xC24E" => '&#40779;',
	"\xC24F" => '&#21474;',
	"\xC250" => '&#22165;',
	"\xC251" => '&#22190;',
	"\xC252" => '&#22745;',
	"\xC253" => '&#22744;',
	"\xC254" => '&#23352;',
	"\xC255" => '&#24413;',
	"\xC256" => '&#25059;',
	"\xC257" => '&#25139;',
	"\xC258" => '&#25844;',
	"\xC259" => '&#25842;',
	"\xC25A" => '&#25854;',
	"\xC25B" => '&#25862;',
	"\xC25C" => '&#25850;',
	"\xC25D" => '&#25851;',
	"\xC25E" => '&#25847;',
	"\xC25F" => '&#26039;',
	"\xC260" => '&#26332;',
	"\xC261" => '&#26406;',
	"\xC262" => '&#27315;',
	"\xC263" => '&#27308;',
	"\xC264" => '&#27331;',
	"\xC265" => '&#27323;',
	"\xC266" => '&#27320;',
	"\xC267" => '&#27330;',
	"\xC268" => '&#27310;',
	"\xC269" => '&#27311;',
	"\xC26A" => '&#27487;',
	"\xC26B" => '&#27512;',
	"\xC26C" => '&#27567;',
	"\xC26D" => '&#28681;',
	"\xC26E" => '&#28683;',
	"\xC26F" => '&#28670;',
	"\xC270" => '&#28678;',
	"\xC271" => '&#28666;',
	"\xC272" => '&#28689;',
	"\xC273" => '&#28687;',
	"\xC274" => '&#29179;',
	"\xC275" => '&#29180;',
	"\xC276" => '&#29182;',
	"\xC277" => '&#29176;',
	"\xC278" => '&#29559;',
	"\xC279" => '&#29557;',
	"\xC27A" => '&#29863;',
	"\xC27B" => '&#29887;',
	"\xC27C" => '&#29973;',
	"\xC27D" => '&#30294;',
	"\xC27E" => '&#30296;',
	"\xC2A1" => '&#30290;',
	"\xC2A2" => '&#30653;',
	"\xC2A3" => '&#30655;',
	"\xC2A4" => '&#30651;',
	"\xC2A5" => '&#30652;',
	"\xC2A6" => '&#30990;',
	"\xC2A7" => '&#31150;',
	"\xC2A8" => '&#31329;',
	"\xC2A9" => '&#31330;',
	"\xC2AA" => '&#31328;',
	"\xC2AB" => '&#31428;',
	"\xC2AC" => '&#31429;',
	"\xC2AD" => '&#31787;',
	"\xC2AE" => '&#31783;',
	"\xC2AF" => '&#31786;',
	"\xC2B0" => '&#31774;',
	"\xC2B1" => '&#31779;',
	"\xC2B2" => '&#31777;',
	"\xC2B3" => '&#31975;',
	"\xC2B4" => '&#32340;',
	"\xC2B5" => '&#32341;',
	"\xC2B6" => '&#32350;',
	"\xC2B7" => '&#32346;',
	"\xC2B8" => '&#32353;',
	"\xC2B9" => '&#32338;',
	"\xC2BA" => '&#32345;',
	"\xC2BB" => '&#32584;',
	"\xC2BC" => '&#32761;',
	"\xC2BD" => '&#32763;',
	"\xC2BE" => '&#32887;',
	"\xC2BF" => '&#32886;',
	"\xC2C0" => '&#33229;',
	"\xC2C1" => '&#33231;',
	"\xC2C2" => '&#33290;',
	"\xC2C3" => '&#34255;',
	"\xC2C4" => '&#34217;',
	"\xC2C5" => '&#34253;',
	"\xC2C6" => '&#34256;',
	"\xC2C7" => '&#34249;',
	"\xC2C8" => '&#34224;',
	"\xC2C9" => '&#34234;',
	"\xC2CA" => '&#34233;',
	"\xC2CB" => '&#34214;',
	"\xC2CC" => '&#34799;',
	"\xC2CD" => '&#34796;',
	"\xC2CE" => '&#34802;',
	"\xC2CF" => '&#34784;',
	"\xC2D0" => '&#35206;',
	"\xC2D1" => '&#35250;',
	"\xC2D2" => '&#35316;',
	"\xC2D3" => '&#35624;',
	"\xC2D4" => '&#35641;',
	"\xC2D5" => '&#35628;',
	"\xC2D6" => '&#35627;',
	"\xC2D7" => '&#35920;',
	"\xC2D8" => '&#36101;',
	"\xC2D9" => '&#36441;',
	"\xC2DA" => '&#36451;',
	"\xC2DB" => '&#36454;',
	"\xC2DC" => '&#36452;',
	"\xC2DD" => '&#36447;',
	"\xC2DE" => '&#36437;',
	"\xC2DF" => '&#36544;',
	"\xC2E0" => '&#36681;',
	"\xC2E1" => '&#36685;',
	"\xC2E2" => '&#36999;',
	"\xC2E3" => '&#36995;',
	"\xC2E4" => '&#37000;',
	"\xC2E5" => '&#37291;',
	"\xC2E6" => '&#37292;',
	"\xC2E7" => '&#37328;',
	"\xC2E8" => '&#37780;',
	"\xC2E9" => '&#37770;',
	"\xC2EA" => '&#37782;',
	"\xC2EB" => '&#37794;',
	"\xC2EC" => '&#37811;',
	"\xC2ED" => '&#37806;',
	"\xC2EE" => '&#37804;',
	"\xC2EF" => '&#37808;',
	"\xC2F0" => '&#37784;',
	"\xC2F1" => '&#37786;',
	"\xC2F2" => '&#37783;',
	"\xC2F3" => '&#38356;',
	"\xC2F4" => '&#38358;',
	"\xC2F5" => '&#38352;',
	"\xC2F6" => '&#38357;',
	"\xC2F7" => '&#38626;',
	"\xC2F8" => '&#38620;',
	"\xC2F9" => '&#38617;',
	"\xC2FA" => '&#38619;',
	"\xC2FB" => '&#38622;',
	"\xC2FC" => '&#38692;',
	"\xC2FD" => '&#38819;',
	"\xC2FE" => '&#38822;',
	"\xC340" => '&#38829;',
	"\xC341" => '&#38905;',
	"\xC342" => '&#38989;',
	"\xC343" => '&#38991;',
	"\xC344" => '&#38988;',
	"\xC345" => '&#38990;',
	"\xC346" => '&#38995;',
	"\xC347" => '&#39098;',
	"\xC348" => '&#39230;',
	"\xC349" => '&#39231;',
	"\xC34A" => '&#39229;',
	"\xC34B" => '&#39214;',
	"\xC34C" => '&#39333;',
	"\xC34D" => '&#39438;',
	"\xC34E" => '&#39617;',
	"\xC34F" => '&#39683;',
	"\xC350" => '&#39686;',
	"\xC351" => '&#39759;',
	"\xC352" => '&#39758;',
	"\xC353" => '&#39757;',
	"\xC354" => '&#39882;',
	"\xC355" => '&#39881;',
	"\xC356" => '&#39933;',
	"\xC357" => '&#39880;',
	"\xC358" => '&#39872;',
	"\xC359" => '&#40273;',
	"\xC35A" => '&#40285;',
	"\xC35B" => '&#40288;',
	"\xC35C" => '&#40672;',
	"\xC35D" => '&#40725;',
	"\xC35E" => '&#40748;',
	"\xC35F" => '&#20787;',
	"\xC360" => '&#22181;',
	"\xC361" => '&#22750;',
	"\xC362" => '&#22751;',
	"\xC363" => '&#22754;',
	"\xC364" => '&#23541;',
	"\xC365" => '&#40848;',
	"\xC366" => '&#24300;',
	"\xC367" => '&#25074;',
	"\xC368" => '&#25079;',
	"\xC369" => '&#25078;',
	"\xC36A" => '&#25077;',
	"\xC36B" => '&#25856;',
	"\xC36C" => '&#25871;',
	"\xC36D" => '&#26336;',
	"\xC36E" => '&#26333;',
	"\xC36F" => '&#27365;',
	"\xC370" => '&#27357;',
	"\xC371" => '&#27354;',
	"\xC372" => '&#27347;',
	"\xC373" => '&#28699;',
	"\xC374" => '&#28703;',
	"\xC375" => '&#28712;',
	"\xC376" => '&#28698;',
	"\xC377" => '&#28701;',
	"\xC378" => '&#28693;',
	"\xC379" => '&#28696;',
	"\xC37A" => '&#29190;',
	"\xC37B" => '&#29197;',
	"\xC37C" => '&#29272;',
	"\xC37D" => '&#29346;',
	"\xC37E" => '&#29560;',
	"\xC3A1" => '&#29562;',
	"\xC3A2" => '&#29885;',
	"\xC3A3" => '&#29898;',
	"\xC3A4" => '&#29923;',
	"\xC3A5" => '&#30087;',
	"\xC3A6" => '&#30086;',
	"\xC3A7" => '&#30303;',
	"\xC3A8" => '&#30305;',
	"\xC3A9" => '&#30663;',
	"\xC3AA" => '&#31001;',
	"\xC3AB" => '&#31153;',
	"\xC3AC" => '&#31339;',
	"\xC3AD" => '&#31337;',
	"\xC3AE" => '&#31806;',
	"\xC3AF" => '&#31807;',
	"\xC3B0" => '&#31800;',
	"\xC3B1" => '&#31805;',
	"\xC3B2" => '&#31799;',
	"\xC3B3" => '&#31808;',
	"\xC3B4" => '&#32363;',
	"\xC3B5" => '&#32365;',
	"\xC3B6" => '&#32377;',
	"\xC3B7" => '&#32361;',
	"\xC3B8" => '&#32362;',
	"\xC3B9" => '&#32645;',
	"\xC3BA" => '&#32371;',
	"\xC3BB" => '&#32694;',
	"\xC3BC" => '&#32697;',
	"\xC3BD" => '&#32696;',
	"\xC3BE" => '&#33240;',
	"\xC3BF" => '&#34281;',
	"\xC3C0" => '&#34269;',
	"\xC3C1" => '&#34282;',
	"\xC3C2" => '&#34261;',
	"\xC3C3" => '&#34276;',
	"\xC3C4" => '&#34277;',
	"\xC3C5" => '&#34295;',
	"\xC3C6" => '&#34811;',
	"\xC3C7" => '&#34821;',
	"\xC3C8" => '&#34829;',
	"\xC3C9" => '&#34809;',
	"\xC3CA" => '&#34814;',
	"\xC3CB" => '&#35168;',
	"\xC3CC" => '&#35167;',
	"\xC3CD" => '&#35158;',
	"\xC3CE" => '&#35166;',
	"\xC3CF" => '&#35649;',
	"\xC3D0" => '&#35676;',
	"\xC3D1" => '&#35672;',
	"\xC3D2" => '&#35657;',
	"\xC3D3" => '&#35674;',
	"\xC3D4" => '&#35662;',
	"\xC3D5" => '&#35663;',
	"\xC3D6" => '&#35654;',
	"\xC3D7" => '&#35673;',
	"\xC3D8" => '&#36104;',
	"\xC3D9" => '&#36106;',
	"\xC3DA" => '&#36476;',
	"\xC3DB" => '&#36466;',
	"\xC3DC" => '&#36487;',
	"\xC3DD" => '&#36470;',
	"\xC3DE" => '&#36460;',
	"\xC3DF" => '&#36474;',
	"\xC3E0" => '&#36468;',
	"\xC3E1" => '&#36692;',
	"\xC3E2" => '&#36686;',
	"\xC3E3" => '&#36781;',
	"\xC3E4" => '&#37002;',
	"\xC3E5" => '&#37003;',
	"\xC3E6" => '&#37297;',
	"\xC3E7" => '&#37294;',
	"\xC3E8" => '&#37857;',
	"\xC3E9" => '&#37841;',
	"\xC3EA" => '&#37855;',
	"\xC3EB" => '&#37827;',
	"\xC3EC" => '&#37832;',
	"\xC3ED" => '&#37852;',
	"\xC3EE" => '&#37853;',
	"\xC3EF" => '&#37846;',
	"\xC3F0" => '&#37858;',
	"\xC3F1" => '&#37837;',
	"\xC3F2" => '&#37848;',
	"\xC3F3" => '&#37860;',
	"\xC3F4" => '&#37847;',
	"\xC3F5" => '&#37864;',
	"\xC3F6" => '&#38364;',
	"\xC3F7" => '&#38580;',
	"\xC3F8" => '&#38627;',
	"\xC3F9" => '&#38698;',
	"\xC3FA" => '&#38695;',
	"\xC3FB" => '&#38753;',
	"\xC3FC" => '&#38876;',
	"\xC3FD" => '&#38907;',
	"\xC3FE" => '&#39006;',
	"\xC440" => '&#39000;',
	"\xC441" => '&#39003;',
	"\xC442" => '&#39100;',
	"\xC443" => '&#39237;',
	"\xC444" => '&#39241;',
	"\xC445" => '&#39446;',
	"\xC446" => '&#39449;',
	"\xC447" => '&#39693;',
	"\xC448" => '&#39912;',
	"\xC449" => '&#39911;',
	"\xC44A" => '&#39894;',
	"\xC44B" => '&#39899;',
	"\xC44C" => '&#40329;',
	"\xC44D" => '&#40289;',
	"\xC44E" => '&#40306;',
	"\xC44F" => '&#40298;',
	"\xC450" => '&#40300;',
	"\xC451" => '&#40594;',
	"\xC452" => '&#40599;',
	"\xC453" => '&#40595;',
	"\xC454" => '&#40628;',
	"\xC455" => '&#21240;',
	"\xC456" => '&#22184;',
	"\xC457" => '&#22199;',
	"\xC458" => '&#22198;',
	"\xC459" => '&#22196;',
	"\xC45A" => '&#22204;',
	"\xC45B" => '&#22756;',
	"\xC45C" => '&#23360;',
	"\xC45D" => '&#23363;',
	"\xC45E" => '&#23421;',
	"\xC45F" => '&#23542;',
	"\xC460" => '&#24009;',
	"\xC461" => '&#25080;',
	"\xC462" => '&#25082;',
	"\xC463" => '&#25880;',
	"\xC464" => '&#25876;',
	"\xC465" => '&#25881;',
	"\xC466" => '&#26342;',
	"\xC467" => '&#26407;',
	"\xC468" => '&#27372;',
	"\xC469" => '&#28734;',
	"\xC46A" => '&#28720;',
	"\xC46B" => '&#28722;',
	"\xC46C" => '&#29200;',
	"\xC46D" => '&#29563;',
	"\xC46E" => '&#29903;',
	"\xC46F" => '&#30306;',
	"\xC470" => '&#30309;',
	"\xC471" => '&#31014;',
	"\xC472" => '&#31018;',
	"\xC473" => '&#31020;',
	"\xC474" => '&#31019;',
	"\xC475" => '&#31431;',
	"\xC476" => '&#31478;',
	"\xC477" => '&#31820;',
	"\xC478" => '&#31811;',
	"\xC479" => '&#31821;',
	"\xC47A" => '&#31983;',
	"\xC47B" => '&#31984;',
	"\xC47C" => '&#36782;',
	"\xC47D" => '&#32381;',
	"\xC47E" => '&#32380;',
	"\xC4A1" => '&#32386;',
	"\xC4A2" => '&#32588;',
	"\xC4A3" => '&#32768;',
	"\xC4A4" => '&#33242;',
	"\xC4A5" => '&#33382;',
	"\xC4A6" => '&#34299;',
	"\xC4A7" => '&#34297;',
	"\xC4A8" => '&#34321;',
	"\xC4A9" => '&#34298;',
	"\xC4AA" => '&#34310;',
	"\xC4AB" => '&#34315;',
	"\xC4AC" => '&#34311;',
	"\xC4AD" => '&#34314;',
	"\xC4AE" => '&#34836;',
	"\xC4AF" => '&#34837;',
	"\xC4B0" => '&#35172;',
	"\xC4B1" => '&#35258;',
	"\xC4B2" => '&#35320;',
	"\xC4B3" => '&#35696;',
	"\xC4B4" => '&#35692;',
	"\xC4B5" => '&#35686;',
	"\xC4B6" => '&#35695;',
	"\xC4B7" => '&#35679;',
	"\xC4B8" => '&#35691;',
	"\xC4B9" => '&#36111;',
	"\xC4BA" => '&#36109;',
	"\xC4BB" => '&#36489;',
	"\xC4BC" => '&#36481;',
	"\xC4BD" => '&#36485;',
	"\xC4BE" => '&#36482;',
	"\xC4BF" => '&#37300;',
	"\xC4C0" => '&#37323;',
	"\xC4C1" => '&#37912;',
	"\xC4C2" => '&#37891;',
	"\xC4C3" => '&#37885;',
	"\xC4C4" => '&#38369;',
	"\xC4C5" => '&#38704;',
	"\xC4C6" => '&#39108;',
	"\xC4C7" => '&#39250;',
	"\xC4C8" => '&#39249;',
	"\xC4C9" => '&#39336;',
	"\xC4CA" => '&#39467;',
	"\xC4CB" => '&#39472;',
	"\xC4CC" => '&#39479;',
	"\xC4CD" => '&#39477;',
	"\xC4CE" => '&#39955;',
	"\xC4CF" => '&#39949;',
	"\xC4D0" => '&#40569;',
	"\xC4D1" => '&#40629;',
	"\xC4D2" => '&#40680;',
	"\xC4D3" => '&#40751;',
	"\xC4D4" => '&#40799;',
	"\xC4D5" => '&#40803;',
	"\xC4D6" => '&#40801;',
	"\xC4D7" => '&#20791;',
	"\xC4D8" => '&#20792;',
	"\xC4D9" => '&#22209;',
	"\xC4DA" => '&#22208;',
	"\xC4DB" => '&#22210;',
	"\xC4DC" => '&#22804;',
	"\xC4DD" => '&#23660;',
	"\xC4DE" => '&#24013;',
	"\xC4DF" => '&#25084;',
	"\xC4E0" => '&#25086;',
	"\xC4E1" => '&#25885;',
	"\xC4E2" => '&#25884;',
	"\xC4E3" => '&#26005;',
	"\xC4E4" => '&#26345;',
	"\xC4E5" => '&#27387;',
	"\xC4E6" => '&#27396;',
	"\xC4E7" => '&#27386;',
	"\xC4E8" => '&#27570;',
	"\xC4E9" => '&#28748;',
	"\xC4EA" => '&#29211;',
	"\xC4EB" => '&#29351;',
	"\xC4EC" => '&#29910;',
	"\xC4ED" => '&#29908;',
	"\xC4EE" => '&#30313;',
	"\xC4EF" => '&#30675;',
	"\xC4F0" => '&#31824;',
	"\xC4F1" => '&#32399;',
	"\xC4F2" => '&#32396;',
	"\xC4F3" => '&#32700;',
	"\xC4F4" => '&#34327;',
	"\xC4F5" => '&#34349;',
	"\xC4F6" => '&#34330;',
	"\xC4F7" => '&#34851;',
	"\xC4F8" => '&#34850;',
	"\xC4F9" => '&#34849;',
	"\xC4FA" => '&#34847;',
	"\xC4FB" => '&#35178;',
	"\xC4FC" => '&#35180;',
	"\xC4FD" => '&#35261;',
	"\xC4FE" => '&#35700;',
	"\xC540" => '&#35703;',
	"\xC541" => '&#35709;',
	"\xC542" => '&#36115;',
	"\xC543" => '&#36490;',
	"\xC544" => '&#36493;',
	"\xC545" => '&#36491;',
	"\xC546" => '&#36703;',
	"\xC547" => '&#36783;',
	"\xC548" => '&#37306;',
	"\xC549" => '&#37934;',
	"\xC54A" => '&#37939;',
	"\xC54B" => '&#37941;',
	"\xC54C" => '&#37946;',
	"\xC54D" => '&#37944;',
	"\xC54E" => '&#37938;',
	"\xC54F" => '&#37931;',
	"\xC550" => '&#38370;',
	"\xC551" => '&#38712;',
	"\xC552" => '&#38713;',
	"\xC553" => '&#38706;',
	"\xC554" => '&#38911;',
	"\xC555" => '&#39015;',
	"\xC556" => '&#39013;',
	"\xC557" => '&#39255;',
	"\xC558" => '&#39493;',
	"\xC559" => '&#39491;',
	"\xC55A" => '&#39488;',
	"\xC55B" => '&#39486;',
	"\xC55C" => '&#39631;',
	"\xC55D" => '&#39764;',
	"\xC55E" => '&#39761;',
	"\xC55F" => '&#39981;',
	"\xC560" => '&#39973;',
	"\xC561" => '&#40367;',
	"\xC562" => '&#40372;',
	"\xC563" => '&#40386;',
	"\xC564" => '&#40376;',
	"\xC565" => '&#40605;',
	"\xC566" => '&#40687;',
	"\xC567" => '&#40729;',
	"\xC568" => '&#40796;',
	"\xC569" => '&#40806;',
	"\xC56A" => '&#40807;',
	"\xC56B" => '&#20796;',
	"\xC56C" => '&#20795;',
	"\xC56D" => '&#22216;',
	"\xC56E" => '&#22218;',
	"\xC56F" => '&#22217;',
	"\xC570" => '&#23423;',
	"\xC571" => '&#24020;',
	"\xC572" => '&#24018;',
	"\xC573" => '&#24398;',
	"\xC574" => '&#25087;',
	"\xC575" => '&#25892;',
	"\xC576" => '&#27402;',
	"\xC577" => '&#27489;',
	"\xC578" => '&#28753;',
	"\xC579" => '&#28760;',
	"\xC57A" => '&#29568;',
	"\xC57B" => '&#29924;',
	"\xC57C" => '&#30090;',
	"\xC57D" => '&#30318;',
	"\xC57E" => '&#30316;',
	"\xC5A1" => '&#31155;',
	"\xC5A2" => '&#31840;',
	"\xC5A3" => '&#31839;',
	"\xC5A4" => '&#32894;',
	"\xC5A5" => '&#32893;',
	"\xC5A6" => '&#33247;',
	"\xC5A7" => '&#35186;',
	"\xC5A8" => '&#35183;',
	"\xC5A9" => '&#35324;',
	"\xC5AA" => '&#35712;',
	"\xC5AB" => '&#36118;',
	"\xC5AC" => '&#36119;',
	"\xC5AD" => '&#36497;',
	"\xC5AE" => '&#36499;',
	"\xC5AF" => '&#36705;',
	"\xC5B0" => '&#37192;',
	"\xC5B1" => '&#37956;',
	"\xC5B2" => '&#37969;',
	"\xC5B3" => '&#37970;',
	"\xC5B4" => '&#38717;',
	"\xC5B5" => '&#38718;',
	"\xC5B6" => '&#38851;',
	"\xC5B7" => '&#38849;',
	"\xC5B8" => '&#39019;',
	"\xC5B9" => '&#39253;',
	"\xC5BA" => '&#39509;',
	"\xC5BB" => '&#39501;',
	"\xC5BC" => '&#39634;',
	"\xC5BD" => '&#39706;',
	"\xC5BE" => '&#40009;',
	"\xC5BF" => '&#39985;',
	"\xC5C0" => '&#39998;',
	"\xC5C1" => '&#39995;',
	"\xC5C2" => '&#40403;',
	"\xC5C3" => '&#40407;',
	"\xC5C4" => '&#40756;',
	"\xC5C5" => '&#40812;',
	"\xC5C6" => '&#40810;',
	"\xC5C7" => '&#40852;',
	"\xC5C8" => '&#22220;',
	"\xC5C9" => '&#24022;',
	"\xC5CA" => '&#25088;',
	"\xC5CB" => '&#25891;',
	"\xC5CC" => '&#25899;',
	"\xC5CD" => '&#25898;',
	"\xC5CE" => '&#26348;',
	"\xC5CF" => '&#27408;',
	"\xC5D0" => '&#29914;',
	"\xC5D1" => '&#31434;',
	"\xC5D2" => '&#31844;',
	"\xC5D3" => '&#31843;',
	"\xC5D4" => '&#31845;',
	"\xC5D5" => '&#32403;',
	"\xC5D6" => '&#32406;',
	"\xC5D7" => '&#32404;',
	"\xC5D8" => '&#33250;',
	"\xC5D9" => '&#34360;',
	"\xC5DA" => '&#34367;',
	"\xC5DB" => '&#34865;',
	"\xC5DC" => '&#35722;',
	"\xC5DD" => '&#37008;',
	"\xC5DE" => '&#37007;',
	"\xC5DF" => '&#37987;',
	"\xC5E0" => '&#37984;',
	"\xC5E1" => '&#37988;',
	"\xC5E2" => '&#38760;',
	"\xC5E3" => '&#39023;',
	"\xC5E4" => '&#39260;',
	"\xC5E5" => '&#39514;',
	"\xC5E6" => '&#39515;',
	"\xC5E7" => '&#39511;',
	"\xC5E8" => '&#39635;',
	"\xC5E9" => '&#39636;',
	"\xC5EA" => '&#39633;',
	"\xC5EB" => '&#40020;',
	"\xC5EC" => '&#40023;',
	"\xC5ED" => '&#40022;',
	"\xC5EE" => '&#40421;',
	"\xC5EF" => '&#40607;',
	"\xC5F0" => '&#40692;',
	"\xC5F1" => '&#22225;',
	"\xC5F2" => '&#22761;',
	"\xC5F3" => '&#25900;',
	"\xC5F4" => '&#28766;',
	"\xC5F5" => '&#30321;',
	"\xC5F6" => '&#30322;',
	"\xC5F7" => '&#30679;',
	"\xC5F8" => '&#32592;',
	"\xC5F9" => '&#32648;',
	"\xC5FA" => '&#34870;',
	"\xC5FB" => '&#34873;',
	"\xC5FC" => '&#34914;',
	"\xC5FD" => '&#35731;',
	"\xC5FE" => '&#35730;',
	"\xC640" => '&#35734;',
	"\xC641" => '&#33399;',
	"\xC642" => '&#36123;',
	"\xC643" => '&#37312;',
	"\xC644" => '&#37994;',
	"\xC645" => '&#38722;',
	"\xC646" => '&#38728;',
	"\xC647" => '&#38724;',
	"\xC648" => '&#38854;',
	"\xC649" => '&#39024;',
	"\xC64A" => '&#39519;',
	"\xC64B" => '&#39714;',
	"\xC64C" => '&#39768;',
	"\xC64D" => '&#40031;',
	"\xC64E" => '&#40441;',
	"\xC64F" => '&#40442;',
	"\xC650" => '&#40572;',
	"\xC651" => '&#40573;',
	"\xC652" => '&#40711;',
	"\xC653" => '&#40823;',
	"\xC654" => '&#40818;',
	"\xC655" => '&#24307;',
	"\xC656" => '&#27414;',
	"\xC657" => '&#28771;',
	"\xC658" => '&#31852;',
	"\xC659" => '&#31854;',
	"\xC65A" => '&#34875;',
	"\xC65B" => '&#35264;',
	"\xC65C" => '&#36513;',
	"\xC65D" => '&#37313;',
	"\xC65E" => '&#38002;',
	"\xC65F" => '&#38000;',
	"\xC660" => '&#39025;',
	"\xC661" => '&#39262;',
	"\xC662" => '&#39638;',
	"\xC663" => '&#39715;',
	"\xC664" => '&#40652;',
	"\xC665" => '&#28772;',
	"\xC666" => '&#30682;',
	"\xC667" => '&#35738;',
	"\xC668" => '&#38007;',
	"\xC669" => '&#38857;',
	"\xC66A" => '&#39522;',
	"\xC66B" => '&#39525;',
	"\xC66C" => '&#32412;',
	"\xC66D" => '&#35740;',
	"\xC66E" => '&#36522;',
	"\xC66F" => '&#37317;',
	"\xC670" => '&#38013;',
	"\xC671" => '&#38014;',
	"\xC672" => '&#38012;',
	"\xC673" => '&#40055;',
	"\xC674" => '&#40056;',
	"\xC675" => '&#40695;',
	"\xC676" => '&#35924;',
	"\xC677" => '&#38015;',
	"\xC678" => '&#40474;',
	"\xC679" => '&#29224;',
	"\xC67A" => '&#39530;',
	"\xC67B" => '&#39729;',
	"\xC67C" => '&#40475;',
	"\xC67D" => '&#40478;',
	"\xC67E" => '&#31858;',
	"\xC940" => '&#20034;',
	"\xC941" => '&#20060;',
	"\xC942" => '&#20981;',
	"\xC943" => '&#21274;',
	"\xC944" => '&#21378;',
	"\xC945" => '&#19975;',
	"\xC946" => '&#19980;',
	"\xC947" => '&#20039;',
	"\xC948" => '&#20109;',
	"\xC949" => '&#22231;',
	"\xC94A" => '&#64012;',
	"\xC94B" => '&#23662;',
	"\xC94C" => '&#24435;',
	"\xC94D" => '&#19983;',
	"\xC94E" => '&#20871;',
	"\xC94F" => '&#19982;',
	"\xC950" => '&#20014;',
	"\xC951" => '&#20115;',
	"\xC952" => '&#20162;',
	"\xC953" => '&#20169;',
	"\xC954" => '&#20168;',
	"\xC955" => '&#20888;',
	"\xC956" => '&#21244;',
	"\xC957" => '&#21356;',
	"\xC958" => '&#21433;',
	"\xC959" => '&#22304;',
	"\xC95A" => '&#22787;',
	"\xC95B" => '&#22828;',
	"\xC95C" => '&#23568;',
	"\xC95D" => '&#24063;',
	"\xC95E" => '&#26081;',
	"\xC95F" => '&#27571;',
	"\xC960" => '&#27596;',
	"\xC961" => '&#27668;',
	"\xC962" => '&#29247;',
	"\xC963" => '&#20017;',
	"\xC964" => '&#20028;',
	"\xC965" => '&#20200;',
	"\xC966" => '&#20188;',
	"\xC967" => '&#20201;',
	"\xC968" => '&#20193;',
	"\xC969" => '&#20189;',
	"\xC96A" => '&#20186;',
	"\xC96B" => '&#21004;',
	"\xC96C" => '&#21276;',
	"\xC96D" => '&#21324;',
	"\xC96E" => '&#22306;',
	"\xC96F" => '&#22307;',
	"\xC970" => '&#22807;',
	"\xC971" => '&#22831;',
	"\xC972" => '&#23425;',
	"\xC973" => '&#23428;',
	"\xC974" => '&#23570;',
	"\xC975" => '&#23611;',
	"\xC976" => '&#23668;',
	"\xC977" => '&#23667;',
	"\xC978" => '&#24068;',
	"\xC979" => '&#24192;',
	"\xC97A" => '&#24194;',
	"\xC97B" => '&#24521;',
	"\xC97C" => '&#25097;',
	"\xC97D" => '&#25168;',
	"\xC97E" => '&#27669;',
	"\xC9A1" => '&#27702;',
	"\xC9A2" => '&#27715;',
	"\xC9A3" => '&#27711;',
	"\xC9A4" => '&#27707;',
	"\xC9A5" => '&#29358;',
	"\xC9A6" => '&#29360;',
	"\xC9A7" => '&#29578;',
	"\xC9A8" => '&#31160;',
	"\xC9A9" => '&#32906;',
	"\xC9AA" => '&#38430;',
	"\xC9AB" => '&#20238;',
	"\xC9AC" => '&#20248;',
	"\xC9AD" => '&#20268;',
	"\xC9AE" => '&#20213;',
	"\xC9AF" => '&#20244;',
	"\xC9B0" => '&#20209;',
	"\xC9B1" => '&#20224;',
	"\xC9B2" => '&#20215;',
	"\xC9B3" => '&#20232;',
	"\xC9B4" => '&#20253;',
	"\xC9B5" => '&#20226;',
	"\xC9B6" => '&#20229;',
	"\xC9B7" => '&#20258;',
	"\xC9B8" => '&#20243;',
	"\xC9B9" => '&#20228;',
	"\xC9BA" => '&#20212;',
	"\xC9BB" => '&#20242;',
	"\xC9BC" => '&#20913;',
	"\xC9BD" => '&#21011;',
	"\xC9BE" => '&#21001;',
	"\xC9BF" => '&#21008;',
	"\xC9C0" => '&#21158;',
	"\xC9C1" => '&#21282;',
	"\xC9C2" => '&#21279;',
	"\xC9C3" => '&#21325;',
	"\xC9C4" => '&#21386;',
	"\xC9C5" => '&#21511;',
	"\xC9C6" => '&#22241;',
	"\xC9C7" => '&#22239;',
	"\xC9C8" => '&#22318;',
	"\xC9C9" => '&#22314;',
	"\xC9CA" => '&#22324;',
	"\xC9CB" => '&#22844;',
	"\xC9CC" => '&#22912;',
	"\xC9CD" => '&#22908;',
	"\xC9CE" => '&#22917;',
	"\xC9CF" => '&#22907;',
	"\xC9D0" => '&#22910;',
	"\xC9D1" => '&#22903;',
	"\xC9D2" => '&#22911;',
	"\xC9D3" => '&#23382;',
	"\xC9D4" => '&#23573;',
	"\xC9D5" => '&#23589;',
	"\xC9D6" => '&#23676;',
	"\xC9D7" => '&#23674;',
	"\xC9D8" => '&#23675;',
	"\xC9D9" => '&#23678;',
	"\xC9DA" => '&#24031;',
	"\xC9DB" => '&#24181;',
	"\xC9DC" => '&#24196;',
	"\xC9DD" => '&#24322;',
	"\xC9DE" => '&#24346;',
	"\xC9DF" => '&#24436;',
	"\xC9E0" => '&#24533;',
	"\xC9E1" => '&#24532;',
	"\xC9E2" => '&#24527;',
	"\xC9E3" => '&#25180;',
	"\xC9E4" => '&#25182;',
	"\xC9E5" => '&#25188;',
	"\xC9E6" => '&#25185;',
	"\xC9E7" => '&#25190;',
	"\xC9E8" => '&#25186;',
	"\xC9E9" => '&#25177;',
	"\xC9EA" => '&#25184;',
	"\xC9EB" => '&#25178;',
	"\xC9EC" => '&#25189;',
	"\xC9ED" => '&#26095;',
	"\xC9EE" => '&#26094;',
	"\xC9EF" => '&#26430;',
	"\xC9F0" => '&#26425;',
	"\xC9F1" => '&#26424;',
	"\xC9F2" => '&#26427;',
	"\xC9F3" => '&#26426;',
	"\xC9F4" => '&#26431;',
	"\xC9F5" => '&#26428;',
	"\xC9F6" => '&#26419;',
	"\xC9F7" => '&#27672;',
	"\xC9F8" => '&#27718;',
	"\xC9F9" => '&#27730;',
	"\xC9FA" => '&#27740;',
	"\xC9FB" => '&#27727;',
	"\xC9FC" => '&#27722;',
	"\xC9FD" => '&#27732;',
	"\xC9FE" => '&#27723;',
	"\xCA40" => '&#27724;',
	"\xCA41" => '&#28785;',
	"\xCA42" => '&#29278;',
	"\xCA43" => '&#29364;',
	"\xCA44" => '&#29365;',
	"\xCA45" => '&#29582;',
	"\xCA46" => '&#29994;',
	"\xCA47" => '&#30335;',
	"\xCA48" => '&#31349;',
	"\xCA49" => '&#32593;',
	"\xCA4A" => '&#33400;',
	"\xCA4B" => '&#33404;',
	"\xCA4C" => '&#33408;',
	"\xCA4D" => '&#33405;',
	"\xCA4E" => '&#33407;',
	"\xCA4F" => '&#34381;',
	"\xCA50" => '&#35198;',
	"\xCA51" => '&#37017;',
	"\xCA52" => '&#37015;',
	"\xCA53" => '&#37016;',
	"\xCA54" => '&#37019;',
	"\xCA55" => '&#37012;',
	"\xCA56" => '&#38434;',
	"\xCA57" => '&#38436;',
	"\xCA58" => '&#38432;',
	"\xCA59" => '&#38435;',
	"\xCA5A" => '&#20310;',
	"\xCA5B" => '&#20283;',
	"\xCA5C" => '&#20322;',
	"\xCA5D" => '&#20297;',
	"\xCA5E" => '&#20307;',
	"\xCA5F" => '&#20324;',
	"\xCA60" => '&#20286;',
	"\xCA61" => '&#20327;',
	"\xCA62" => '&#20306;',
	"\xCA63" => '&#20319;',
	"\xCA64" => '&#20289;',
	"\xCA65" => '&#20312;',
	"\xCA66" => '&#20269;',
	"\xCA67" => '&#20275;',
	"\xCA68" => '&#20287;',
	"\xCA69" => '&#20321;',
	"\xCA6A" => '&#20879;',
	"\xCA6B" => '&#20921;',
	"\xCA6C" => '&#21020;',
	"\xCA6D" => '&#21022;',
	"\xCA6E" => '&#21025;',
	"\xCA6F" => '&#21165;',
	"\xCA70" => '&#21166;',
	"\xCA71" => '&#21257;',
	"\xCA72" => '&#21347;',
	"\xCA73" => '&#21362;',
	"\xCA74" => '&#21390;',
	"\xCA75" => '&#21391;',
	"\xCA76" => '&#21552;',
	"\xCA77" => '&#21559;',
	"\xCA78" => '&#21546;',
	"\xCA79" => '&#21588;',
	"\xCA7A" => '&#21573;',
	"\xCA7B" => '&#21529;',
	"\xCA7C" => '&#21532;',
	"\xCA7D" => '&#21541;',
	"\xCA7E" => '&#21528;',
	"\xCAA1" => '&#21565;',
	"\xCAA2" => '&#21583;',
	"\xCAA3" => '&#21569;',
	"\xCAA4" => '&#21544;',
	"\xCAA5" => '&#21540;',
	"\xCAA6" => '&#21575;',
	"\xCAA7" => '&#22254;',
	"\xCAA8" => '&#22247;',
	"\xCAA9" => '&#22245;',
	"\xCAAA" => '&#22337;',
	"\xCAAB" => '&#22341;',
	"\xCAAC" => '&#22348;',
	"\xCAAD" => '&#22345;',
	"\xCAAE" => '&#22347;',
	"\xCAAF" => '&#22354;',
	"\xCAB0" => '&#22790;',
	"\xCAB1" => '&#22848;',
	"\xCAB2" => '&#22950;',
	"\xCAB3" => '&#22936;',
	"\xCAB4" => '&#22944;',
	"\xCAB5" => '&#22935;',
	"\xCAB6" => '&#22926;',
	"\xCAB7" => '&#22946;',
	"\xCAB8" => '&#22928;',
	"\xCAB9" => '&#22927;',
	"\xCABA" => '&#22951;',
	"\xCABB" => '&#22945;',
	"\xCABC" => '&#23438;',
	"\xCABD" => '&#23442;',
	"\xCABE" => '&#23592;',
	"\xCABF" => '&#23594;',
	"\xCAC0" => '&#23693;',
	"\xCAC1" => '&#23695;',
	"\xCAC2" => '&#23688;',
	"\xCAC3" => '&#23691;',
	"\xCAC4" => '&#23689;',
	"\xCAC5" => '&#23698;',
	"\xCAC6" => '&#23690;',
	"\xCAC7" => '&#23686;',
	"\xCAC8" => '&#23699;',
	"\xCAC9" => '&#23701;',
	"\xCACA" => '&#24032;',
	"\xCACB" => '&#24074;',
	"\xCACC" => '&#24078;',
	"\xCACD" => '&#24203;',
	"\xCACE" => '&#24201;',
	"\xCACF" => '&#24204;',
	"\xCAD0" => '&#24200;',
	"\xCAD1" => '&#24205;',
	"\xCAD2" => '&#24325;',
	"\xCAD3" => '&#24349;',
	"\xCAD4" => '&#24440;',
	"\xCAD5" => '&#24438;',
	"\xCAD6" => '&#24530;',
	"\xCAD7" => '&#24529;',
	"\xCAD8" => '&#24528;',
	"\xCAD9" => '&#24557;',
	"\xCADA" => '&#24552;',
	"\xCADB" => '&#24558;',
	"\xCADC" => '&#24563;',
	"\xCADD" => '&#24545;',
	"\xCADE" => '&#24548;',
	"\xCADF" => '&#24547;',
	"\xCAE0" => '&#24570;',
	"\xCAE1" => '&#24559;',
	"\xCAE2" => '&#24567;',
	"\xCAE3" => '&#24571;',
	"\xCAE4" => '&#24576;',
	"\xCAE5" => '&#24564;',
	"\xCAE6" => '&#25146;',
	"\xCAE7" => '&#25219;',
	"\xCAE8" => '&#25228;',
	"\xCAE9" => '&#25230;',
	"\xCAEA" => '&#25231;',
	"\xCAEB" => '&#25236;',
	"\xCAEC" => '&#25223;',
	"\xCAED" => '&#25201;',
	"\xCAEE" => '&#25211;',
	"\xCAEF" => '&#25210;',
	"\xCAF0" => '&#25200;',
	"\xCAF1" => '&#25217;',
	"\xCAF2" => '&#25224;',
	"\xCAF3" => '&#25207;',
	"\xCAF4" => '&#25213;',
	"\xCAF5" => '&#25202;',
	"\xCAF6" => '&#25204;',
	"\xCAF7" => '&#25911;',
	"\xCAF8" => '&#26096;',
	"\xCAF9" => '&#26100;',
	"\xCAFA" => '&#26099;',
	"\xCAFB" => '&#26098;',
	"\xCAFC" => '&#26101;',
	"\xCAFD" => '&#26437;',
	"\xCAFE" => '&#26439;',
	"\xCB40" => '&#26457;',
	"\xCB41" => '&#26453;',
	"\xCB42" => '&#26444;',
	"\xCB43" => '&#26440;',
	"\xCB44" => '&#26461;',
	"\xCB45" => '&#26445;',
	"\xCB46" => '&#26458;',
	"\xCB47" => '&#26443;',
	"\xCB48" => '&#27600;',
	"\xCB49" => '&#27673;',
	"\xCB4A" => '&#27674;',
	"\xCB4B" => '&#27768;',
	"\xCB4C" => '&#27751;',
	"\xCB4D" => '&#27755;',
	"\xCB4E" => '&#27780;',
	"\xCB4F" => '&#27787;',
	"\xCB50" => '&#27791;',
	"\xCB51" => '&#27761;',
	"\xCB52" => '&#27759;',
	"\xCB53" => '&#27753;',
	"\xCB54" => '&#27802;',
	"\xCB55" => '&#27757;',
	"\xCB56" => '&#27783;',
	"\xCB57" => '&#27797;',
	"\xCB58" => '&#27804;',
	"\xCB59" => '&#27750;',
	"\xCB5A" => '&#27763;',
	"\xCB5B" => '&#27749;',
	"\xCB5C" => '&#27771;',
	"\xCB5D" => '&#27790;',
	"\xCB5E" => '&#28788;',
	"\xCB5F" => '&#28794;',
	"\xCB60" => '&#29283;',
	"\xCB61" => '&#29375;',
	"\xCB62" => '&#29373;',
	"\xCB63" => '&#29379;',
	"\xCB64" => '&#29382;',
	"\xCB65" => '&#29377;',
	"\xCB66" => '&#29370;',
	"\xCB67" => '&#29381;',
	"\xCB68" => '&#29589;',
	"\xCB69" => '&#29591;',
	"\xCB6A" => '&#29587;',
	"\xCB6B" => '&#29588;',
	"\xCB6C" => '&#29586;',
	"\xCB6D" => '&#30010;',
	"\xCB6E" => '&#30009;',
	"\xCB6F" => '&#30100;',
	"\xCB70" => '&#30101;',
	"\xCB71" => '&#30337;',
	"\xCB72" => '&#31037;',
	"\xCB73" => '&#32820;',
	"\xCB74" => '&#32917;',
	"\xCB75" => '&#32921;',
	"\xCB76" => '&#32912;',
	"\xCB77" => '&#32914;',
	"\xCB78" => '&#32924;',
	"\xCB79" => '&#33424;',
	"\xCB7A" => '&#33423;',
	"\xCB7B" => '&#33413;',
	"\xCB7C" => '&#33422;',
	"\xCB7D" => '&#33425;',
	"\xCB7E" => '&#33427;',
	"\xCBA1" => '&#33418;',
	"\xCBA2" => '&#33411;',
	"\xCBA3" => '&#33412;',
	"\xCBA4" => '&#35960;',
	"\xCBA5" => '&#36809;',
	"\xCBA6" => '&#36799;',
	"\xCBA7" => '&#37023;',
	"\xCBA8" => '&#37025;',
	"\xCBA9" => '&#37029;',
	"\xCBAA" => '&#37022;',
	"\xCBAB" => '&#37031;',
	"\xCBAC" => '&#37024;',
	"\xCBAD" => '&#38448;',
	"\xCBAE" => '&#38440;',
	"\xCBAF" => '&#38447;',
	"\xCBB0" => '&#38445;',
	"\xCBB1" => '&#20019;',
	"\xCBB2" => '&#20376;',
	"\xCBB3" => '&#20348;',
	"\xCBB4" => '&#20357;',
	"\xCBB5" => '&#20349;',
	"\xCBB6" => '&#20352;',
	"\xCBB7" => '&#20359;',
	"\xCBB8" => '&#20342;',
	"\xCBB9" => '&#20340;',
	"\xCBBA" => '&#20361;',
	"\xCBBB" => '&#20356;',
	"\xCBBC" => '&#20343;',
	"\xCBBD" => '&#20300;',
	"\xCBBE" => '&#20375;',
	"\xCBBF" => '&#20330;',
	"\xCBC0" => '&#20378;',
	"\xCBC1" => '&#20345;',
	"\xCBC2" => '&#20353;',
	"\xCBC3" => '&#20344;',
	"\xCBC4" => '&#20368;',
	"\xCBC5" => '&#20380;',
	"\xCBC6" => '&#20372;',
	"\xCBC7" => '&#20382;',
	"\xCBC8" => '&#20370;',
	"\xCBC9" => '&#20354;',
	"\xCBCA" => '&#20373;',
	"\xCBCB" => '&#20331;',
	"\xCBCC" => '&#20334;',
	"\xCBCD" => '&#20894;',
	"\xCBCE" => '&#20924;',
	"\xCBCF" => '&#20926;',
	"\xCBD0" => '&#21045;',
	"\xCBD1" => '&#21042;',
	"\xCBD2" => '&#21043;',
	"\xCBD3" => '&#21062;',
	"\xCBD4" => '&#21041;',
	"\xCBD5" => '&#21180;',
	"\xCBD6" => '&#21258;',
	"\xCBD7" => '&#21259;',
	"\xCBD8" => '&#21308;',
	"\xCBD9" => '&#21394;',
	"\xCBDA" => '&#21396;',
	"\xCBDB" => '&#21639;',
	"\xCBDC" => '&#21631;',
	"\xCBDD" => '&#21633;',
	"\xCBDE" => '&#21649;',
	"\xCBDF" => '&#21634;',
	"\xCBE0" => '&#21640;',
	"\xCBE1" => '&#21611;',
	"\xCBE2" => '&#21626;',
	"\xCBE3" => '&#21630;',
	"\xCBE4" => '&#21605;',
	"\xCBE5" => '&#21612;',
	"\xCBE6" => '&#21620;',
	"\xCBE7" => '&#21606;',
	"\xCBE8" => '&#21645;',
	"\xCBE9" => '&#21615;',
	"\xCBEA" => '&#21601;',
	"\xCBEB" => '&#21600;',
	"\xCBEC" => '&#21656;',
	"\xCBED" => '&#21603;',
	"\xCBEE" => '&#21607;',
	"\xCBEF" => '&#21604;',
	"\xCBF0" => '&#22263;',
	"\xCBF1" => '&#22265;',
	"\xCBF2" => '&#22383;',
	"\xCBF3" => '&#22386;',
	"\xCBF4" => '&#22381;',
	"\xCBF5" => '&#22379;',
	"\xCBF6" => '&#22385;',
	"\xCBF7" => '&#22384;',
	"\xCBF8" => '&#22390;',
	"\xCBF9" => '&#22400;',
	"\xCBFA" => '&#22389;',
	"\xCBFB" => '&#22395;',
	"\xCBFC" => '&#22387;',
	"\xCBFD" => '&#22388;',
	"\xCBFE" => '&#22370;',
	"\xCC40" => '&#22376;',
	"\xCC41" => '&#22397;',
	"\xCC42" => '&#22796;',
	"\xCC43" => '&#22853;',
	"\xCC44" => '&#22965;',
	"\xCC45" => '&#22970;',
	"\xCC46" => '&#22991;',
	"\xCC47" => '&#22990;',
	"\xCC48" => '&#22962;',
	"\xCC49" => '&#22988;',
	"\xCC4A" => '&#22977;',
	"\xCC4B" => '&#22966;',
	"\xCC4C" => '&#22972;',
	"\xCC4D" => '&#22979;',
	"\xCC4E" => '&#22998;',
	"\xCC4F" => '&#22961;',
	"\xCC50" => '&#22973;',
	"\xCC51" => '&#22976;',
	"\xCC52" => '&#22984;',
	"\xCC53" => '&#22964;',
	"\xCC54" => '&#22983;',
	"\xCC55" => '&#23394;',
	"\xCC56" => '&#23397;',
	"\xCC57" => '&#23443;',
	"\xCC58" => '&#23445;',
	"\xCC59" => '&#23620;',
	"\xCC5A" => '&#23623;',
	"\xCC5B" => '&#23726;',
	"\xCC5C" => '&#23716;',
	"\xCC5D" => '&#23712;',
	"\xCC5E" => '&#23733;',
	"\xCC5F" => '&#23727;',
	"\xCC60" => '&#23720;',
	"\xCC61" => '&#23724;',
	"\xCC62" => '&#23711;',
	"\xCC63" => '&#23715;',
	"\xCC64" => '&#23725;',
	"\xCC65" => '&#23714;',
	"\xCC66" => '&#23722;',
	"\xCC67" => '&#23719;',
	"\xCC68" => '&#23709;',
	"\xCC69" => '&#23717;',
	"\xCC6A" => '&#23734;',
	"\xCC6B" => '&#23728;',
	"\xCC6C" => '&#23718;',
	"\xCC6D" => '&#24087;',
	"\xCC6E" => '&#24084;',
	"\xCC6F" => '&#24089;',
	"\xCC70" => '&#24360;',
	"\xCC71" => '&#24354;',
	"\xCC72" => '&#24355;',
	"\xCC73" => '&#24356;',
	"\xCC74" => '&#24404;',
	"\xCC75" => '&#24450;',
	"\xCC76" => '&#24446;',
	"\xCC77" => '&#24445;',
	"\xCC78" => '&#24542;',
	"\xCC79" => '&#24549;',
	"\xCC7A" => '&#24621;',
	"\xCC7B" => '&#24614;',
	"\xCC7C" => '&#24601;',
	"\xCC7D" => '&#24626;',
	"\xCC7E" => '&#24587;',
	"\xCCA1" => '&#24628;',
	"\xCCA2" => '&#24586;',
	"\xCCA3" => '&#24599;',
	"\xCCA4" => '&#24627;',
	"\xCCA5" => '&#24602;',
	"\xCCA6" => '&#24606;',
	"\xCCA7" => '&#24620;',
	"\xCCA8" => '&#24610;',
	"\xCCA9" => '&#24589;',
	"\xCCAA" => '&#24592;',
	"\xCCAB" => '&#24622;',
	"\xCCAC" => '&#24595;',
	"\xCCAD" => '&#24593;',
	"\xCCAE" => '&#24588;',
	"\xCCAF" => '&#24585;',
	"\xCCB0" => '&#24604;',
	"\xCCB1" => '&#25108;',
	"\xCCB2" => '&#25149;',
	"\xCCB3" => '&#25261;',
	"\xCCB4" => '&#25268;',
	"\xCCB5" => '&#25297;',
	"\xCCB6" => '&#25278;',
	"\xCCB7" => '&#25258;',
	"\xCCB8" => '&#25270;',
	"\xCCB9" => '&#25290;',
	"\xCCBA" => '&#25262;',
	"\xCCBB" => '&#25267;',
	"\xCCBC" => '&#25263;',
	"\xCCBD" => '&#25275;',
	"\xCCBE" => '&#25257;',
	"\xCCBF" => '&#25264;',
	"\xCCC0" => '&#25272;',
	"\xCCC1" => '&#25917;',
	"\xCCC2" => '&#26024;',
	"\xCCC3" => '&#26043;',
	"\xCCC4" => '&#26121;',
	"\xCCC5" => '&#26108;',
	"\xCCC6" => '&#26116;',
	"\xCCC7" => '&#26130;',
	"\xCCC8" => '&#26120;',
	"\xCCC9" => '&#26107;',
	"\xCCCA" => '&#26115;',
	"\xCCCB" => '&#26123;',
	"\xCCCC" => '&#26125;',
	"\xCCCD" => '&#26117;',
	"\xCCCE" => '&#26109;',
	"\xCCCF" => '&#26129;',
	"\xCCD0" => '&#26128;',
	"\xCCD1" => '&#26358;',
	"\xCCD2" => '&#26378;',
	"\xCCD3" => '&#26501;',
	"\xCCD4" => '&#26476;',
	"\xCCD5" => '&#26510;',
	"\xCCD6" => '&#26514;',
	"\xCCD7" => '&#26486;',
	"\xCCD8" => '&#26491;',
	"\xCCD9" => '&#26520;',
	"\xCCDA" => '&#26502;',
	"\xCCDB" => '&#26500;',
	"\xCCDC" => '&#26484;',
	"\xCCDD" => '&#26509;',
	"\xCCDE" => '&#26508;',
	"\xCCDF" => '&#26490;',
	"\xCCE0" => '&#26527;',
	"\xCCE1" => '&#26513;',
	"\xCCE2" => '&#26521;',
	"\xCCE3" => '&#26499;',
	"\xCCE4" => '&#26493;',
	"\xCCE5" => '&#26497;',
	"\xCCE6" => '&#26488;',
	"\xCCE7" => '&#26489;',
	"\xCCE8" => '&#26516;',
	"\xCCE9" => '&#27429;',
	"\xCCEA" => '&#27520;',
	"\xCCEB" => '&#27518;',
	"\xCCEC" => '&#27614;',
	"\xCCED" => '&#27677;',
	"\xCCEE" => '&#27795;',
	"\xCCEF" => '&#27884;',
	"\xCCF0" => '&#27883;',
	"\xCCF1" => '&#27886;',
	"\xCCF2" => '&#27865;',
	"\xCCF3" => '&#27830;',
	"\xCCF4" => '&#27860;',
	"\xCCF5" => '&#27821;',
	"\xCCF6" => '&#27879;',
	"\xCCF7" => '&#27831;',
	"\xCCF8" => '&#27856;',
	"\xCCF9" => '&#27842;',
	"\xCCFA" => '&#27834;',
	"\xCCFB" => '&#27843;',
	"\xCCFC" => '&#27846;',
	"\xCCFD" => '&#27885;',
	"\xCCFE" => '&#27890;',
	"\xCD40" => '&#27858;',
	"\xCD41" => '&#27869;',
	"\xCD42" => '&#27828;',
	"\xCD43" => '&#27786;',
	"\xCD44" => '&#27805;',
	"\xCD45" => '&#27776;',
	"\xCD46" => '&#27870;',
	"\xCD47" => '&#27840;',
	"\xCD48" => '&#27952;',
	"\xCD49" => '&#27853;',
	"\xCD4A" => '&#27847;',
	"\xCD4B" => '&#27824;',
	"\xCD4C" => '&#27897;',
	"\xCD4D" => '&#27855;',
	"\xCD4E" => '&#27881;',
	"\xCD4F" => '&#27857;',
	"\xCD50" => '&#28820;',
	"\xCD51" => '&#28824;',
	"\xCD52" => '&#28805;',
	"\xCD53" => '&#28819;',
	"\xCD54" => '&#28806;',
	"\xCD55" => '&#28804;',
	"\xCD56" => '&#28817;',
	"\xCD57" => '&#28822;',
	"\xCD58" => '&#28802;',
	"\xCD59" => '&#28826;',
	"\xCD5A" => '&#28803;',
	"\xCD5B" => '&#29290;',
	"\xCD5C" => '&#29398;',
	"\xCD5D" => '&#29387;',
	"\xCD5E" => '&#29400;',
	"\xCD5F" => '&#29385;',
	"\xCD60" => '&#29404;',
	"\xCD61" => '&#29394;',
	"\xCD62" => '&#29396;',
	"\xCD63" => '&#29402;',
	"\xCD64" => '&#29388;',
	"\xCD65" => '&#29393;',
	"\xCD66" => '&#29604;',
	"\xCD67" => '&#29601;',
	"\xCD68" => '&#29613;',
	"\xCD69" => '&#29606;',
	"\xCD6A" => '&#29602;',
	"\xCD6B" => '&#29600;',
	"\xCD6C" => '&#29612;',
	"\xCD6D" => '&#29597;',
	"\xCD6E" => '&#29917;',
	"\xCD6F" => '&#29928;',
	"\xCD70" => '&#30015;',
	"\xCD71" => '&#30016;',
	"\xCD72" => '&#30014;',
	"\xCD73" => '&#30092;',
	"\xCD74" => '&#30104;',
	"\xCD75" => '&#30383;',
	"\xCD76" => '&#30451;',
	"\xCD77" => '&#30449;',
	"\xCD78" => '&#30448;',
	"\xCD79" => '&#30453;',
	"\xCD7A" => '&#30712;',
	"\xCD7B" => '&#30716;',
	"\xCD7C" => '&#30713;',
	"\xCD7D" => '&#30715;',
	"\xCD7E" => '&#30714;',
	"\xCDA1" => '&#30711;',
	"\xCDA2" => '&#31042;',
	"\xCDA3" => '&#31039;',
	"\xCDA4" => '&#31173;',
	"\xCDA5" => '&#31352;',
	"\xCDA6" => '&#31355;',
	"\xCDA7" => '&#31483;',
	"\xCDA8" => '&#31861;',
	"\xCDA9" => '&#31997;',
	"\xCDAA" => '&#32821;',
	"\xCDAB" => '&#32911;',
	"\xCDAC" => '&#32942;',
	"\xCDAD" => '&#32931;',
	"\xCDAE" => '&#32952;',
	"\xCDAF" => '&#32949;',
	"\xCDB0" => '&#32941;',
	"\xCDB1" => '&#33312;',
	"\xCDB2" => '&#33440;',
	"\xCDB3" => '&#33472;',
	"\xCDB4" => '&#33451;',
	"\xCDB5" => '&#33434;',
	"\xCDB6" => '&#33432;',
	"\xCDB7" => '&#33435;',
	"\xCDB8" => '&#33461;',
	"\xCDB9" => '&#33447;',
	"\xCDBA" => '&#33454;',
	"\xCDBB" => '&#33468;',
	"\xCDBC" => '&#33438;',
	"\xCDBD" => '&#33466;',
	"\xCDBE" => '&#33460;',
	"\xCDBF" => '&#33448;',
	"\xCDC0" => '&#33441;',
	"\xCDC1" => '&#33449;',
	"\xCDC2" => '&#33474;',
	"\xCDC3" => '&#33444;',
	"\xCDC4" => '&#33475;',
	"\xCDC5" => '&#33462;',
	"\xCDC6" => '&#33442;',
	"\xCDC7" => '&#34416;',
	"\xCDC8" => '&#34415;',
	"\xCDC9" => '&#34413;',
	"\xCDCA" => '&#34414;',
	"\xCDCB" => '&#35926;',
	"\xCDCC" => '&#36818;',
	"\xCDCD" => '&#36811;',
	"\xCDCE" => '&#36819;',
	"\xCDCF" => '&#36813;',
	"\xCDD0" => '&#36822;',
	"\xCDD1" => '&#36821;',
	"\xCDD2" => '&#36823;',
	"\xCDD3" => '&#37042;',
	"\xCDD4" => '&#37044;',
	"\xCDD5" => '&#37039;',
	"\xCDD6" => '&#37043;',
	"\xCDD7" => '&#37040;',
	"\xCDD8" => '&#38457;',
	"\xCDD9" => '&#38461;',
	"\xCDDA" => '&#38460;',
	"\xCDDB" => '&#38458;',
	"\xCDDC" => '&#38467;',
	"\xCDDD" => '&#20429;',
	"\xCDDE" => '&#20421;',
	"\xCDDF" => '&#20435;',
	"\xCDE0" => '&#20402;',
	"\xCDE1" => '&#20425;',
	"\xCDE2" => '&#20427;',
	"\xCDE3" => '&#20417;',
	"\xCDE4" => '&#20436;',
	"\xCDE5" => '&#20444;',
	"\xCDE6" => '&#20441;',
	"\xCDE7" => '&#20411;',
	"\xCDE8" => '&#20403;',
	"\xCDE9" => '&#20443;',
	"\xCDEA" => '&#20423;',
	"\xCDEB" => '&#20438;',
	"\xCDEC" => '&#20410;',
	"\xCDED" => '&#20416;',
	"\xCDEE" => '&#20409;',
	"\xCDEF" => '&#20460;',
	"\xCDF0" => '&#21060;',
	"\xCDF1" => '&#21065;',
	"\xCDF2" => '&#21184;',
	"\xCDF3" => '&#21186;',
	"\xCDF4" => '&#21309;',
	"\xCDF5" => '&#21372;',
	"\xCDF6" => '&#21399;',
	"\xCDF7" => '&#21398;',
	"\xCDF8" => '&#21401;',
	"\xCDF9" => '&#21400;',
	"\xCDFA" => '&#21690;',
	"\xCDFB" => '&#21665;',
	"\xCDFC" => '&#21677;',
	"\xCDFD" => '&#21669;',
	"\xCDFE" => '&#21711;',
	"\xCE40" => '&#21699;',
	"\xCE41" => '&#33549;',
	"\xCE42" => '&#21687;',
	"\xCE43" => '&#21678;',
	"\xCE44" => '&#21718;',
	"\xCE45" => '&#21686;',
	"\xCE46" => '&#21701;',
	"\xCE47" => '&#21702;',
	"\xCE48" => '&#21664;',
	"\xCE49" => '&#21616;',
	"\xCE4A" => '&#21692;',
	"\xCE4B" => '&#21666;',
	"\xCE4C" => '&#21694;',
	"\xCE4D" => '&#21618;',
	"\xCE4E" => '&#21726;',
	"\xCE4F" => '&#21680;',
	"\xCE50" => '&#22453;',
	"\xCE51" => '&#22430;',
	"\xCE52" => '&#22431;',
	"\xCE53" => '&#22436;',
	"\xCE54" => '&#22412;',
	"\xCE55" => '&#22423;',
	"\xCE56" => '&#22429;',
	"\xCE57" => '&#22427;',
	"\xCE58" => '&#22420;',
	"\xCE59" => '&#22424;',
	"\xCE5A" => '&#22415;',
	"\xCE5B" => '&#22425;',
	"\xCE5C" => '&#22437;',
	"\xCE5D" => '&#22426;',
	"\xCE5E" => '&#22421;',
	"\xCE5F" => '&#22772;',
	"\xCE60" => '&#22797;',
	"\xCE61" => '&#22867;',
	"\xCE62" => '&#23009;',
	"\xCE63" => '&#23006;',
	"\xCE64" => '&#23022;',
	"\xCE65" => '&#23040;',
	"\xCE66" => '&#23025;',
	"\xCE67" => '&#23005;',
	"\xCE68" => '&#23034;',
	"\xCE69" => '&#23037;',
	"\xCE6A" => '&#23036;',
	"\xCE6B" => '&#23030;',
	"\xCE6C" => '&#23012;',
	"\xCE6D" => '&#23026;',
	"\xCE6E" => '&#23031;',
	"\xCE6F" => '&#23003;',
	"\xCE70" => '&#23017;',
	"\xCE71" => '&#23027;',
	"\xCE72" => '&#23029;',
	"\xCE73" => '&#23008;',
	"\xCE74" => '&#23038;',
	"\xCE75" => '&#23028;',
	"\xCE76" => '&#23021;',
	"\xCE77" => '&#23464;',
	"\xCE78" => '&#23628;',
	"\xCE79" => '&#23760;',
	"\xCE7A" => '&#23768;',
	"\xCE7B" => '&#23756;',
	"\xCE7C" => '&#23767;',
	"\xCE7D" => '&#23755;',
	"\xCE7E" => '&#23771;',
	"\xCEA1" => '&#23774;',
	"\xCEA2" => '&#23770;',
	"\xCEA3" => '&#23753;',
	"\xCEA4" => '&#23751;',
	"\xCEA5" => '&#23754;',
	"\xCEA6" => '&#23766;',
	"\xCEA7" => '&#23763;',
	"\xCEA8" => '&#23764;',
	"\xCEA9" => '&#23759;',
	"\xCEAA" => '&#23752;',
	"\xCEAB" => '&#23750;',
	"\xCEAC" => '&#23758;',
	"\xCEAD" => '&#23775;',
	"\xCEAE" => '&#23800;',
	"\xCEAF" => '&#24057;',
	"\xCEB0" => '&#24097;',
	"\xCEB1" => '&#24098;',
	"\xCEB2" => '&#24099;',
	"\xCEB3" => '&#24096;',
	"\xCEB4" => '&#24100;',
	"\xCEB5" => '&#24240;',
	"\xCEB6" => '&#24228;',
	"\xCEB7" => '&#24226;',
	"\xCEB8" => '&#24219;',
	"\xCEB9" => '&#24227;',
	"\xCEBA" => '&#24229;',
	"\xCEBB" => '&#24327;',
	"\xCEBC" => '&#24366;',
	"\xCEBD" => '&#24406;',
	"\xCEBE" => '&#24454;',
	"\xCEBF" => '&#24631;',
	"\xCEC0" => '&#24633;',
	"\xCEC1" => '&#24660;',
	"\xCEC2" => '&#24690;',
	"\xCEC3" => '&#24670;',
	"\xCEC4" => '&#24645;',
	"\xCEC5" => '&#24659;',
	"\xCEC6" => '&#24647;',
	"\xCEC7" => '&#24649;',
	"\xCEC8" => '&#24667;',
	"\xCEC9" => '&#24652;',
	"\xCECA" => '&#24640;',
	"\xCECB" => '&#24642;',
	"\xCECC" => '&#24671;',
	"\xCECD" => '&#24612;',
	"\xCECE" => '&#24644;',
	"\xCECF" => '&#24664;',
	"\xCED0" => '&#24678;',
	"\xCED1" => '&#24686;',
	"\xCED2" => '&#25154;',
	"\xCED3" => '&#25155;',
	"\xCED4" => '&#25295;',
	"\xCED5" => '&#25357;',
	"\xCED6" => '&#25355;',
	"\xCED7" => '&#25333;',
	"\xCED8" => '&#25358;',
	"\xCED9" => '&#25347;',
	"\xCEDA" => '&#25323;',
	"\xCEDB" => '&#25337;',
	"\xCEDC" => '&#25359;',
	"\xCEDD" => '&#25356;',
	"\xCEDE" => '&#25336;',
	"\xCEDF" => '&#25334;',
	"\xCEE0" => '&#25344;',
	"\xCEE1" => '&#25363;',
	"\xCEE2" => '&#25364;',
	"\xCEE3" => '&#25338;',
	"\xCEE4" => '&#25365;',
	"\xCEE5" => '&#25339;',
	"\xCEE6" => '&#25328;',
	"\xCEE7" => '&#25921;',
	"\xCEE8" => '&#25923;',
	"\xCEE9" => '&#26026;',
	"\xCEEA" => '&#26047;',
	"\xCEEB" => '&#26166;',
	"\xCEEC" => '&#26145;',
	"\xCEED" => '&#26162;',
	"\xCEEE" => '&#26165;',
	"\xCEEF" => '&#26140;',
	"\xCEF0" => '&#26150;',
	"\xCEF1" => '&#26146;',
	"\xCEF2" => '&#26163;',
	"\xCEF3" => '&#26155;',
	"\xCEF4" => '&#26170;',
	"\xCEF5" => '&#26141;',
	"\xCEF6" => '&#26164;',
	"\xCEF7" => '&#26169;',
	"\xCEF8" => '&#26158;',
	"\xCEF9" => '&#26383;',
	"\xCEFA" => '&#26384;',
	"\xCEFB" => '&#26561;',
	"\xCEFC" => '&#26610;',
	"\xCEFD" => '&#26568;',
	"\xCEFE" => '&#26554;',
	"\xCF40" => '&#26588;',
	"\xCF41" => '&#26555;',
	"\xCF42" => '&#26616;',
	"\xCF43" => '&#26584;',
	"\xCF44" => '&#26560;',
	"\xCF45" => '&#26551;',
	"\xCF46" => '&#26565;',
	"\xCF47" => '&#26603;',
	"\xCF48" => '&#26596;',
	"\xCF49" => '&#26591;',
	"\xCF4A" => '&#26549;',
	"\xCF4B" => '&#26573;',
	"\xCF4C" => '&#26547;',
	"\xCF4D" => '&#26615;',
	"\xCF4E" => '&#26614;',
	"\xCF4F" => '&#26606;',
	"\xCF50" => '&#26595;',
	"\xCF51" => '&#26562;',
	"\xCF52" => '&#26553;',
	"\xCF53" => '&#26574;',
	"\xCF54" => '&#26599;',
	"\xCF55" => '&#26608;',
	"\xCF56" => '&#26546;',
	"\xCF57" => '&#26620;',
	"\xCF58" => '&#26566;',
	"\xCF59" => '&#26605;',
	"\xCF5A" => '&#26572;',
	"\xCF5B" => '&#26542;',
	"\xCF5C" => '&#26598;',
	"\xCF5D" => '&#26587;',
	"\xCF5E" => '&#26618;',
	"\xCF5F" => '&#26569;',
	"\xCF60" => '&#26570;',
	"\xCF61" => '&#26563;',
	"\xCF62" => '&#26602;',
	"\xCF63" => '&#26571;',
	"\xCF64" => '&#27432;',
	"\xCF65" => '&#27522;',
	"\xCF66" => '&#27524;',
	"\xCF67" => '&#27574;',
	"\xCF68" => '&#27606;',
	"\xCF69" => '&#27608;',
	"\xCF6A" => '&#27616;',
	"\xCF6B" => '&#27680;',
	"\xCF6C" => '&#27681;',
	"\xCF6D" => '&#27944;',
	"\xCF6E" => '&#27956;',
	"\xCF6F" => '&#27949;',
	"\xCF70" => '&#27935;',
	"\xCF71" => '&#27964;',
	"\xCF72" => '&#27967;',
	"\xCF73" => '&#27922;',
	"\xCF74" => '&#27914;',
	"\xCF75" => '&#27866;',
	"\xCF76" => '&#27955;',
	"\xCF77" => '&#27908;',
	"\xCF78" => '&#27929;',
	"\xCF79" => '&#27962;',
	"\xCF7A" => '&#27930;',
	"\xCF7B" => '&#27921;',
	"\xCF7C" => '&#27904;',
	"\xCF7D" => '&#27933;',
	"\xCF7E" => '&#27970;',
	"\xCFA1" => '&#27905;',
	"\xCFA2" => '&#27928;',
	"\xCFA3" => '&#27959;',
	"\xCFA4" => '&#27907;',
	"\xCFA5" => '&#27919;',
	"\xCFA6" => '&#27968;',
	"\xCFA7" => '&#27911;',
	"\xCFA8" => '&#27936;',
	"\xCFA9" => '&#27948;',
	"\xCFAA" => '&#27912;',
	"\xCFAB" => '&#27938;',
	"\xCFAC" => '&#27913;',
	"\xCFAD" => '&#27920;',
	"\xCFAE" => '&#28855;',
	"\xCFAF" => '&#28831;',
	"\xCFB0" => '&#28862;',
	"\xCFB1" => '&#28849;',
	"\xCFB2" => '&#28848;',
	"\xCFB3" => '&#28833;',
	"\xCFB4" => '&#28852;',
	"\xCFB5" => '&#28853;',
	"\xCFB6" => '&#28841;',
	"\xCFB7" => '&#29249;',
	"\xCFB8" => '&#29257;',
	"\xCFB9" => '&#29258;',
	"\xCFBA" => '&#29292;',
	"\xCFBB" => '&#29296;',
	"\xCFBC" => '&#29299;',
	"\xCFBD" => '&#29294;',
	"\xCFBE" => '&#29386;',
	"\xCFBF" => '&#29412;',
	"\xCFC0" => '&#29416;',
	"\xCFC1" => '&#29419;',
	"\xCFC2" => '&#29407;',
	"\xCFC3" => '&#29418;',
	"\xCFC4" => '&#29414;',
	"\xCFC5" => '&#29411;',
	"\xCFC6" => '&#29573;',
	"\xCFC7" => '&#29644;',
	"\xCFC8" => '&#29634;',
	"\xCFC9" => '&#29640;',
	"\xCFCA" => '&#29637;',
	"\xCFCB" => '&#29625;',
	"\xCFCC" => '&#29622;',
	"\xCFCD" => '&#29621;',
	"\xCFCE" => '&#29620;',
	"\xCFCF" => '&#29675;',
	"\xCFD0" => '&#29631;',
	"\xCFD1" => '&#29639;',
	"\xCFD2" => '&#29630;',
	"\xCFD3" => '&#29635;',
	"\xCFD4" => '&#29638;',
	"\xCFD5" => '&#29624;',
	"\xCFD6" => '&#29643;',
	"\xCFD7" => '&#29932;',
	"\xCFD8" => '&#29934;',
	"\xCFD9" => '&#29998;',
	"\xCFDA" => '&#30023;',
	"\xCFDB" => '&#30024;',
	"\xCFDC" => '&#30119;',
	"\xCFDD" => '&#30122;',
	"\xCFDE" => '&#30329;',
	"\xCFDF" => '&#30404;',
	"\xCFE0" => '&#30472;',
	"\xCFE1" => '&#30467;',
	"\xCFE2" => '&#30468;',
	"\xCFE3" => '&#30469;',
	"\xCFE4" => '&#30474;',
	"\xCFE5" => '&#30455;',
	"\xCFE6" => '&#30459;',
	"\xCFE7" => '&#30458;',
	"\xCFE8" => '&#30695;',
	"\xCFE9" => '&#30696;',
	"\xCFEA" => '&#30726;',
	"\xCFEB" => '&#30737;',
	"\xCFEC" => '&#30738;',
	"\xCFED" => '&#30725;',
	"\xCFEE" => '&#30736;',
	"\xCFEF" => '&#30735;',
	"\xCFF0" => '&#30734;',
	"\xCFF1" => '&#30729;',
	"\xCFF2" => '&#30723;',
	"\xCFF3" => '&#30739;',
	"\xCFF4" => '&#31050;',
	"\xCFF5" => '&#31052;',
	"\xCFF6" => '&#31051;',
	"\xCFF7" => '&#31045;',
	"\xCFF8" => '&#31044;',
	"\xCFF9" => '&#31189;',
	"\xCFFA" => '&#31181;',
	"\xCFFB" => '&#31183;',
	"\xCFFC" => '&#31190;',
	"\xCFFD" => '&#31182;',
	"\xCFFE" => '&#31360;',
	"\xD040" => '&#31358;',
	"\xD041" => '&#31441;',
	"\xD042" => '&#31488;',
	"\xD043" => '&#31489;',
	"\xD044" => '&#31866;',
	"\xD045" => '&#31864;',
	"\xD046" => '&#31865;',
	"\xD047" => '&#31871;',
	"\xD048" => '&#31872;',
	"\xD049" => '&#31873;',
	"\xD04A" => '&#32003;',
	"\xD04B" => '&#32008;',
	"\xD04C" => '&#32001;',
	"\xD04D" => '&#32600;',
	"\xD04E" => '&#32657;',
	"\xD04F" => '&#32653;',
	"\xD050" => '&#32702;',
	"\xD051" => '&#32775;',
	"\xD052" => '&#32782;',
	"\xD053" => '&#32783;',
	"\xD054" => '&#32788;',
	"\xD055" => '&#32823;',
	"\xD056" => '&#32984;',
	"\xD057" => '&#32967;',
	"\xD058" => '&#32992;',
	"\xD059" => '&#32977;',
	"\xD05A" => '&#32968;',
	"\xD05B" => '&#32962;',
	"\xD05C" => '&#32976;',
	"\xD05D" => '&#32965;',
	"\xD05E" => '&#32995;',
	"\xD05F" => '&#32985;',
	"\xD060" => '&#32988;',
	"\xD061" => '&#32970;',
	"\xD062" => '&#32981;',
	"\xD063" => '&#32969;',
	"\xD064" => '&#32975;',
	"\xD065" => '&#32983;',
	"\xD066" => '&#32998;',
	"\xD067" => '&#32973;',
	"\xD068" => '&#33279;',
	"\xD069" => '&#33313;',
	"\xD06A" => '&#33428;',
	"\xD06B" => '&#33497;',
	"\xD06C" => '&#33534;',
	"\xD06D" => '&#33529;',
	"\xD06E" => '&#33543;',
	"\xD06F" => '&#33512;',
	"\xD070" => '&#33536;',
	"\xD071" => '&#33493;',
	"\xD072" => '&#33594;',
	"\xD073" => '&#33515;',
	"\xD074" => '&#33494;',
	"\xD075" => '&#33524;',
	"\xD076" => '&#33516;',
	"\xD077" => '&#33505;',
	"\xD078" => '&#33522;',
	"\xD079" => '&#33525;',
	"\xD07A" => '&#33548;',
	"\xD07B" => '&#33531;',
	"\xD07C" => '&#33526;',
	"\xD07D" => '&#33520;',
	"\xD07E" => '&#33514;',
	"\xD0A1" => '&#33508;',
	"\xD0A2" => '&#33504;',
	"\xD0A3" => '&#33530;',
	"\xD0A4" => '&#33523;',
	"\xD0A5" => '&#33517;',
	"\xD0A6" => '&#34423;',
	"\xD0A7" => '&#34420;',
	"\xD0A8" => '&#34428;',
	"\xD0A9" => '&#34419;',
	"\xD0AA" => '&#34881;',
	"\xD0AB" => '&#34894;',
	"\xD0AC" => '&#34919;',
	"\xD0AD" => '&#34922;',
	"\xD0AE" => '&#34921;',
	"\xD0AF" => '&#35283;',
	"\xD0B0" => '&#35332;',
	"\xD0B1" => '&#35335;',
	"\xD0B2" => '&#36210;',
	"\xD0B3" => '&#36835;',
	"\xD0B4" => '&#36833;',
	"\xD0B5" => '&#36846;',
	"\xD0B6" => '&#36832;',
	"\xD0B7" => '&#37105;',
	"\xD0B8" => '&#37053;',
	"\xD0B9" => '&#37055;',
	"\xD0BA" => '&#37077;',
	"\xD0BB" => '&#37061;',
	"\xD0BC" => '&#37054;',
	"\xD0BD" => '&#37063;',
	"\xD0BE" => '&#37067;',
	"\xD0BF" => '&#37064;',
	"\xD0C0" => '&#37332;',
	"\xD0C1" => '&#37331;',
	"\xD0C2" => '&#38484;',
	"\xD0C3" => '&#38479;',
	"\xD0C4" => '&#38481;',
	"\xD0C5" => '&#38483;',
	"\xD0C6" => '&#38474;',
	"\xD0C7" => '&#38478;',
	"\xD0C8" => '&#20510;',
	"\xD0C9" => '&#20485;',
	"\xD0CA" => '&#20487;',
	"\xD0CB" => '&#20499;',
	"\xD0CC" => '&#20514;',
	"\xD0CD" => '&#20528;',
	"\xD0CE" => '&#20507;',
	"\xD0CF" => '&#20469;',
	"\xD0D0" => '&#20468;',
	"\xD0D1" => '&#20531;',
	"\xD0D2" => '&#20535;',
	"\xD0D3" => '&#20524;',
	"\xD0D4" => '&#20470;',
	"\xD0D5" => '&#20471;',
	"\xD0D6" => '&#20503;',
	"\xD0D7" => '&#20508;',
	"\xD0D8" => '&#20512;',
	"\xD0D9" => '&#20519;',
	"\xD0DA" => '&#20533;',
	"\xD0DB" => '&#20527;',
	"\xD0DC" => '&#20529;',
	"\xD0DD" => '&#20494;',
	"\xD0DE" => '&#20826;',
	"\xD0DF" => '&#20884;',
	"\xD0E0" => '&#20883;',
	"\xD0E1" => '&#20938;',
	"\xD0E2" => '&#20932;',
	"\xD0E3" => '&#20933;',
	"\xD0E4" => '&#20936;',
	"\xD0E5" => '&#20942;',
	"\xD0E6" => '&#21089;',
	"\xD0E7" => '&#21082;',
	"\xD0E8" => '&#21074;',
	"\xD0E9" => '&#21086;',
	"\xD0EA" => '&#21087;',
	"\xD0EB" => '&#21077;',
	"\xD0EC" => '&#21090;',
	"\xD0ED" => '&#21197;',
	"\xD0EE" => '&#21262;',
	"\xD0EF" => '&#21406;',
	"\xD0F0" => '&#21798;',
	"\xD0F1" => '&#21730;',
	"\xD0F2" => '&#21783;',
	"\xD0F3" => '&#21778;',
	"\xD0F4" => '&#21735;',
	"\xD0F5" => '&#21747;',
	"\xD0F6" => '&#21732;',
	"\xD0F7" => '&#21786;',
	"\xD0F8" => '&#21759;',
	"\xD0F9" => '&#21764;',
	"\xD0FA" => '&#21768;',
	"\xD0FB" => '&#21739;',
	"\xD0FC" => '&#21777;',
	"\xD0FD" => '&#21765;',
	"\xD0FE" => '&#21745;',
	"\xD140" => '&#21770;',
	"\xD141" => '&#21755;',
	"\xD142" => '&#21751;',
	"\xD143" => '&#21752;',
	"\xD144" => '&#21728;',
	"\xD145" => '&#21774;',
	"\xD146" => '&#21763;',
	"\xD147" => '&#21771;',
	"\xD148" => '&#22273;',
	"\xD149" => '&#22274;',
	"\xD14A" => '&#22476;',
	"\xD14B" => '&#22578;',
	"\xD14C" => '&#22485;',
	"\xD14D" => '&#22482;',
	"\xD14E" => '&#22458;',
	"\xD14F" => '&#22470;',
	"\xD150" => '&#22461;',
	"\xD151" => '&#22460;',
	"\xD152" => '&#22456;',
	"\xD153" => '&#22454;',
	"\xD154" => '&#22463;',
	"\xD155" => '&#22471;',
	"\xD156" => '&#22480;',
	"\xD157" => '&#22457;',
	"\xD158" => '&#22465;',
	"\xD159" => '&#22798;',
	"\xD15A" => '&#22858;',
	"\xD15B" => '&#23065;',
	"\xD15C" => '&#23062;',
	"\xD15D" => '&#23085;',
	"\xD15E" => '&#23086;',
	"\xD15F" => '&#23061;',
	"\xD160" => '&#23055;',
	"\xD161" => '&#23063;',
	"\xD162" => '&#23050;',
	"\xD163" => '&#23070;',
	"\xD164" => '&#23091;',
	"\xD165" => '&#23404;',
	"\xD166" => '&#23463;',
	"\xD167" => '&#23469;',
	"\xD168" => '&#23468;',
	"\xD169" => '&#23555;',
	"\xD16A" => '&#23638;',
	"\xD16B" => '&#23636;',
	"\xD16C" => '&#23788;',
	"\xD16D" => '&#23807;',
	"\xD16E" => '&#23790;',
	"\xD16F" => '&#23793;',
	"\xD170" => '&#23799;',
	"\xD171" => '&#23808;',
	"\xD172" => '&#23801;',
	"\xD173" => '&#24105;',
	"\xD174" => '&#24104;',
	"\xD175" => '&#24232;',
	"\xD176" => '&#24238;',
	"\xD177" => '&#24234;',
	"\xD178" => '&#24236;',
	"\xD179" => '&#24371;',
	"\xD17A" => '&#24368;',
	"\xD17B" => '&#24423;',
	"\xD17C" => '&#24669;',
	"\xD17D" => '&#24666;',
	"\xD17E" => '&#24679;',
	"\xD1A1" => '&#24641;',
	"\xD1A2" => '&#24738;',
	"\xD1A3" => '&#24712;',
	"\xD1A4" => '&#24704;',
	"\xD1A5" => '&#24722;',
	"\xD1A6" => '&#24705;',
	"\xD1A7" => '&#24733;',
	"\xD1A8" => '&#24707;',
	"\xD1A9" => '&#24725;',
	"\xD1AA" => '&#24731;',
	"\xD1AB" => '&#24727;',
	"\xD1AC" => '&#24711;',
	"\xD1AD" => '&#24732;',
	"\xD1AE" => '&#24718;',
	"\xD1AF" => '&#25113;',
	"\xD1B0" => '&#25158;',
	"\xD1B1" => '&#25330;',
	"\xD1B2" => '&#25360;',
	"\xD1B3" => '&#25430;',
	"\xD1B4" => '&#25388;',
	"\xD1B5" => '&#25412;',
	"\xD1B6" => '&#25413;',
	"\xD1B7" => '&#25398;',
	"\xD1B8" => '&#25411;',
	"\xD1B9" => '&#25572;',
	"\xD1BA" => '&#25401;',
	"\xD1BB" => '&#25419;',
	"\xD1BC" => '&#25418;',
	"\xD1BD" => '&#25404;',
	"\xD1BE" => '&#25385;',
	"\xD1BF" => '&#25409;',
	"\xD1C0" => '&#25396;',
	"\xD1C1" => '&#25432;',
	"\xD1C2" => '&#25428;',
	"\xD1C3" => '&#25433;',
	"\xD1C4" => '&#25389;',
	"\xD1C5" => '&#25415;',
	"\xD1C6" => '&#25395;',
	"\xD1C7" => '&#25434;',
	"\xD1C8" => '&#25425;',
	"\xD1C9" => '&#25400;',
	"\xD1CA" => '&#25431;',
	"\xD1CB" => '&#25408;',
	"\xD1CC" => '&#25416;',
	"\xD1CD" => '&#25930;',
	"\xD1CE" => '&#25926;',
	"\xD1CF" => '&#26054;',
	"\xD1D0" => '&#26051;',
	"\xD1D1" => '&#26052;',
	"\xD1D2" => '&#26050;',
	"\xD1D3" => '&#26186;',
	"\xD1D4" => '&#26207;',
	"\xD1D5" => '&#26183;',
	"\xD1D6" => '&#26193;',
	"\xD1D7" => '&#26386;',
	"\xD1D8" => '&#26387;',
	"\xD1D9" => '&#26655;',
	"\xD1DA" => '&#26650;',
	"\xD1DB" => '&#26697;',
	"\xD1DC" => '&#26674;',
	"\xD1DD" => '&#26675;',
	"\xD1DE" => '&#26683;',
	"\xD1DF" => '&#26699;',
	"\xD1E0" => '&#26703;',
	"\xD1E1" => '&#26646;',
	"\xD1E2" => '&#26673;',
	"\xD1E3" => '&#26652;',
	"\xD1E4" => '&#26677;',
	"\xD1E5" => '&#26667;',
	"\xD1E6" => '&#26669;',
	"\xD1E7" => '&#26671;',
	"\xD1E8" => '&#26702;',
	"\xD1E9" => '&#26692;',
	"\xD1EA" => '&#26676;',
	"\xD1EB" => '&#26653;',
	"\xD1EC" => '&#26642;',
	"\xD1ED" => '&#26644;',
	"\xD1EE" => '&#26662;',
	"\xD1EF" => '&#26664;',
	"\xD1F0" => '&#26670;',
	"\xD1F1" => '&#26701;',
	"\xD1F2" => '&#26682;',
	"\xD1F3" => '&#26661;',
	"\xD1F4" => '&#26656;',
	"\xD1F5" => '&#27436;',
	"\xD1F6" => '&#27439;',
	"\xD1F7" => '&#27437;',
	"\xD1F8" => '&#27441;',
	"\xD1F9" => '&#27444;',
	"\xD1FA" => '&#27501;',
	"\xD1FB" => '&#32898;',
	"\xD1FC" => '&#27528;',
	"\xD1FD" => '&#27622;',
	"\xD1FE" => '&#27620;',
	"\xD240" => '&#27624;',
	"\xD241" => '&#27619;',
	"\xD242" => '&#27618;',
	"\xD243" => '&#27623;',
	"\xD244" => '&#27685;',
	"\xD245" => '&#28026;',
	"\xD246" => '&#28003;',
	"\xD247" => '&#28004;',
	"\xD248" => '&#28022;',
	"\xD249" => '&#27917;',
	"\xD24A" => '&#28001;',
	"\xD24B" => '&#28050;',
	"\xD24C" => '&#27992;',
	"\xD24D" => '&#28002;',
	"\xD24E" => '&#28013;',
	"\xD24F" => '&#28015;',
	"\xD250" => '&#28049;',
	"\xD251" => '&#28045;',
	"\xD252" => '&#28143;',
	"\xD253" => '&#28031;',
	"\xD254" => '&#28038;',
	"\xD255" => '&#27998;',
	"\xD256" => '&#28007;',
	"\xD257" => '&#28000;',
	"\xD258" => '&#28055;',
	"\xD259" => '&#28016;',
	"\xD25A" => '&#28028;',
	"\xD25B" => '&#27999;',
	"\xD25C" => '&#28034;',
	"\xD25D" => '&#28056;',
	"\xD25E" => '&#27951;',
	"\xD25F" => '&#28008;',
	"\xD260" => '&#28043;',
	"\xD261" => '&#28030;',
	"\xD262" => '&#28032;',
	"\xD263" => '&#28036;',
	"\xD264" => '&#27926;',
	"\xD265" => '&#28035;',
	"\xD266" => '&#28027;',
	"\xD267" => '&#28029;',
	"\xD268" => '&#28021;',
	"\xD269" => '&#28048;',
	"\xD26A" => '&#28892;',
	"\xD26B" => '&#28883;',
	"\xD26C" => '&#28881;',
	"\xD26D" => '&#28893;',
	"\xD26E" => '&#28875;',
	"\xD26F" => '&#32569;',
	"\xD270" => '&#28898;',
	"\xD271" => '&#28887;',
	"\xD272" => '&#28882;',
	"\xD273" => '&#28894;',
	"\xD274" => '&#28896;',
	"\xD275" => '&#28884;',
	"\xD276" => '&#28877;',
	"\xD277" => '&#28869;',
	"\xD278" => '&#28870;',
	"\xD279" => '&#28871;',
	"\xD27A" => '&#28890;',
	"\xD27B" => '&#28878;',
	"\xD27C" => '&#28897;',
	"\xD27D" => '&#29250;',
	"\xD27E" => '&#29304;',
	"\xD2A1" => '&#29303;',
	"\xD2A2" => '&#29302;',
	"\xD2A3" => '&#29440;',
	"\xD2A4" => '&#29434;',
	"\xD2A5" => '&#29428;',
	"\xD2A6" => '&#29438;',
	"\xD2A7" => '&#29430;',
	"\xD2A8" => '&#29427;',
	"\xD2A9" => '&#29435;',
	"\xD2AA" => '&#29441;',
	"\xD2AB" => '&#29651;',
	"\xD2AC" => '&#29657;',
	"\xD2AD" => '&#29669;',
	"\xD2AE" => '&#29654;',
	"\xD2AF" => '&#29628;',
	"\xD2B0" => '&#29671;',
	"\xD2B1" => '&#29667;',
	"\xD2B2" => '&#29673;',
	"\xD2B3" => '&#29660;',
	"\xD2B4" => '&#29650;',
	"\xD2B5" => '&#29659;',
	"\xD2B6" => '&#29652;',
	"\xD2B7" => '&#29661;',
	"\xD2B8" => '&#29658;',
	"\xD2B9" => '&#29655;',
	"\xD2BA" => '&#29656;',
	"\xD2BB" => '&#29672;',
	"\xD2BC" => '&#29918;',
	"\xD2BD" => '&#29919;',
	"\xD2BE" => '&#29940;',
	"\xD2BF" => '&#29941;',
	"\xD2C0" => '&#29985;',
	"\xD2C1" => '&#30043;',
	"\xD2C2" => '&#30047;',
	"\xD2C3" => '&#30128;',
	"\xD2C4" => '&#30145;',
	"\xD2C5" => '&#30139;',
	"\xD2C6" => '&#30148;',
	"\xD2C7" => '&#30144;',
	"\xD2C8" => '&#30143;',
	"\xD2C9" => '&#30134;',
	"\xD2CA" => '&#30138;',
	"\xD2CB" => '&#30346;',
	"\xD2CC" => '&#30409;',
	"\xD2CD" => '&#30493;',
	"\xD2CE" => '&#30491;',
	"\xD2CF" => '&#30480;',
	"\xD2D0" => '&#30483;',
	"\xD2D1" => '&#30482;',
	"\xD2D2" => '&#30499;',
	"\xD2D3" => '&#30481;',
	"\xD2D4" => '&#30485;',
	"\xD2D5" => '&#30489;',
	"\xD2D6" => '&#30490;',
	"\xD2D7" => '&#30498;',
	"\xD2D8" => '&#30503;',
	"\xD2D9" => '&#30755;',
	"\xD2DA" => '&#30764;',
	"\xD2DB" => '&#30754;',
	"\xD2DC" => '&#30773;',
	"\xD2DD" => '&#30767;',
	"\xD2DE" => '&#30760;',
	"\xD2DF" => '&#30766;',
	"\xD2E0" => '&#30763;',
	"\xD2E1" => '&#30753;',
	"\xD2E2" => '&#30761;',
	"\xD2E3" => '&#30771;',
	"\xD2E4" => '&#30762;',
	"\xD2E5" => '&#30769;',
	"\xD2E6" => '&#31060;',
	"\xD2E7" => '&#31067;',
	"\xD2E8" => '&#31055;',
	"\xD2E9" => '&#31068;',
	"\xD2EA" => '&#31059;',
	"\xD2EB" => '&#31058;',
	"\xD2EC" => '&#31057;',
	"\xD2ED" => '&#31211;',
	"\xD2EE" => '&#31212;',
	"\xD2EF" => '&#31200;',
	"\xD2F0" => '&#31214;',
	"\xD2F1" => '&#31213;',
	"\xD2F2" => '&#31210;',
	"\xD2F3" => '&#31196;',
	"\xD2F4" => '&#31198;',
	"\xD2F5" => '&#31197;',
	"\xD2F6" => '&#31366;',
	"\xD2F7" => '&#31369;',
	"\xD2F8" => '&#31365;',
	"\xD2F9" => '&#31371;',
	"\xD2FA" => '&#31372;',
	"\xD2FB" => '&#31370;',
	"\xD2FC" => '&#31367;',
	"\xD2FD" => '&#31448;',
	"\xD2FE" => '&#31504;',
	"\xD340" => '&#31492;',
	"\xD341" => '&#31507;',
	"\xD342" => '&#31493;',
	"\xD343" => '&#31503;',
	"\xD344" => '&#31496;',
	"\xD345" => '&#31498;',
	"\xD346" => '&#31502;',
	"\xD347" => '&#31497;',
	"\xD348" => '&#31506;',
	"\xD349" => '&#31876;',
	"\xD34A" => '&#31889;',
	"\xD34B" => '&#31882;',
	"\xD34C" => '&#31884;',
	"\xD34D" => '&#31880;',
	"\xD34E" => '&#31885;',
	"\xD34F" => '&#31877;',
	"\xD350" => '&#32030;',
	"\xD351" => '&#32029;',
	"\xD352" => '&#32017;',
	"\xD353" => '&#32014;',
	"\xD354" => '&#32024;',
	"\xD355" => '&#32022;',
	"\xD356" => '&#32019;',
	"\xD357" => '&#32031;',
	"\xD358" => '&#32018;',
	"\xD359" => '&#32015;',
	"\xD35A" => '&#32012;',
	"\xD35B" => '&#32604;',
	"\xD35C" => '&#32609;',
	"\xD35D" => '&#32606;',
	"\xD35E" => '&#32608;',
	"\xD35F" => '&#32605;',
	"\xD360" => '&#32603;',
	"\xD361" => '&#32662;',
	"\xD362" => '&#32658;',
	"\xD363" => '&#32707;',
	"\xD364" => '&#32706;',
	"\xD365" => '&#32704;',
	"\xD366" => '&#32790;',
	"\xD367" => '&#32830;',
	"\xD368" => '&#32825;',
	"\xD369" => '&#33018;',
	"\xD36A" => '&#33010;',
	"\xD36B" => '&#33017;',
	"\xD36C" => '&#33013;',
	"\xD36D" => '&#33025;',
	"\xD36E" => '&#33019;',
	"\xD36F" => '&#33024;',
	"\xD370" => '&#33281;',
	"\xD371" => '&#33327;',
	"\xD372" => '&#33317;',
	"\xD373" => '&#33587;',
	"\xD374" => '&#33581;',
	"\xD375" => '&#33604;',
	"\xD376" => '&#33561;',
	"\xD377" => '&#33617;',
	"\xD378" => '&#33573;',
	"\xD379" => '&#33622;',
	"\xD37A" => '&#33599;',
	"\xD37B" => '&#33601;',
	"\xD37C" => '&#33574;',
	"\xD37D" => '&#33564;',
	"\xD37E" => '&#33570;',
	"\xD3A1" => '&#33602;',
	"\xD3A2" => '&#33614;',
	"\xD3A3" => '&#33563;',
	"\xD3A4" => '&#33578;',
	"\xD3A5" => '&#33544;',
	"\xD3A6" => '&#33596;',
	"\xD3A7" => '&#33613;',
	"\xD3A8" => '&#33558;',
	"\xD3A9" => '&#33572;',
	"\xD3AA" => '&#33568;',
	"\xD3AB" => '&#33591;',
	"\xD3AC" => '&#33583;',
	"\xD3AD" => '&#33577;',
	"\xD3AE" => '&#33607;',
	"\xD3AF" => '&#33605;',
	"\xD3B0" => '&#33612;',
	"\xD3B1" => '&#33619;',
	"\xD3B2" => '&#33566;',
	"\xD3B3" => '&#33580;',
	"\xD3B4" => '&#33611;',
	"\xD3B5" => '&#33575;',
	"\xD3B6" => '&#33608;',
	"\xD3B7" => '&#34387;',
	"\xD3B8" => '&#34386;',
	"\xD3B9" => '&#34466;',
	"\xD3BA" => '&#34472;',
	"\xD3BB" => '&#34454;',
	"\xD3BC" => '&#34445;',
	"\xD3BD" => '&#34449;',
	"\xD3BE" => '&#34462;',
	"\xD3BF" => '&#34439;',
	"\xD3C0" => '&#34455;',
	"\xD3C1" => '&#34438;',
	"\xD3C2" => '&#34443;',
	"\xD3C3" => '&#34458;',
	"\xD3C4" => '&#34437;',
	"\xD3C5" => '&#34469;',
	"\xD3C6" => '&#34457;',
	"\xD3C7" => '&#34465;',
	"\xD3C8" => '&#34471;',
	"\xD3C9" => '&#34453;',
	"\xD3CA" => '&#34456;',
	"\xD3CB" => '&#34446;',
	"\xD3CC" => '&#34461;',
	"\xD3CD" => '&#34448;',
	"\xD3CE" => '&#34452;',
	"\xD3CF" => '&#34883;',
	"\xD3D0" => '&#34884;',
	"\xD3D1" => '&#34925;',
	"\xD3D2" => '&#34933;',
	"\xD3D3" => '&#34934;',
	"\xD3D4" => '&#34930;',
	"\xD3D5" => '&#34944;',
	"\xD3D6" => '&#34929;',
	"\xD3D7" => '&#34943;',
	"\xD3D8" => '&#34927;',
	"\xD3D9" => '&#34947;',
	"\xD3DA" => '&#34942;',
	"\xD3DB" => '&#34932;',
	"\xD3DC" => '&#34940;',
	"\xD3DD" => '&#35346;',
	"\xD3DE" => '&#35911;',
	"\xD3DF" => '&#35927;',
	"\xD3E0" => '&#35963;',
	"\xD3E1" => '&#36004;',
	"\xD3E2" => '&#36003;',
	"\xD3E3" => '&#36214;',
	"\xD3E4" => '&#36216;',
	"\xD3E5" => '&#36277;',
	"\xD3E6" => '&#36279;',
	"\xD3E7" => '&#36278;',
	"\xD3E8" => '&#36561;',
	"\xD3E9" => '&#36563;',
	"\xD3EA" => '&#36862;',
	"\xD3EB" => '&#36853;',
	"\xD3EC" => '&#36866;',
	"\xD3ED" => '&#36863;',
	"\xD3EE" => '&#36859;',
	"\xD3EF" => '&#36868;',
	"\xD3F0" => '&#36860;',
	"\xD3F1" => '&#36854;',
	"\xD3F2" => '&#37078;',
	"\xD3F3" => '&#37088;',
	"\xD3F4" => '&#37081;',
	"\xD3F5" => '&#37082;',
	"\xD3F6" => '&#37091;',
	"\xD3F7" => '&#37087;',
	"\xD3F8" => '&#37093;',
	"\xD3F9" => '&#37080;',
	"\xD3FA" => '&#37083;',
	"\xD3FB" => '&#37079;',
	"\xD3FC" => '&#37084;',
	"\xD3FD" => '&#37092;',
	"\xD3FE" => '&#37200;',
	"\xD440" => '&#37198;',
	"\xD441" => '&#37199;',
	"\xD442" => '&#37333;',
	"\xD443" => '&#37346;',
	"\xD444" => '&#37338;',
	"\xD445" => '&#38492;',
	"\xD446" => '&#38495;',
	"\xD447" => '&#38588;',
	"\xD448" => '&#39139;',
	"\xD449" => '&#39647;',
	"\xD44A" => '&#39727;',
	"\xD44B" => '&#20095;',
	"\xD44C" => '&#20592;',
	"\xD44D" => '&#20586;',
	"\xD44E" => '&#20577;',
	"\xD44F" => '&#20574;',
	"\xD450" => '&#20576;',
	"\xD451" => '&#20563;',
	"\xD452" => '&#20555;',
	"\xD453" => '&#20573;',
	"\xD454" => '&#20594;',
	"\xD455" => '&#20552;',
	"\xD456" => '&#20557;',
	"\xD457" => '&#20545;',
	"\xD458" => '&#20571;',
	"\xD459" => '&#20554;',
	"\xD45A" => '&#20578;',
	"\xD45B" => '&#20501;',
	"\xD45C" => '&#20549;',
	"\xD45D" => '&#20575;',
	"\xD45E" => '&#20585;',
	"\xD45F" => '&#20587;',
	"\xD460" => '&#20579;',
	"\xD461" => '&#20580;',
	"\xD462" => '&#20550;',
	"\xD463" => '&#20544;',
	"\xD464" => '&#20590;',
	"\xD465" => '&#20595;',
	"\xD466" => '&#20567;',
	"\xD467" => '&#20561;',
	"\xD468" => '&#20944;',
	"\xD469" => '&#21099;',
	"\xD46A" => '&#21101;',
	"\xD46B" => '&#21100;',
	"\xD46C" => '&#21102;',
	"\xD46D" => '&#21206;',
	"\xD46E" => '&#21203;',
	"\xD46F" => '&#21293;',
	"\xD470" => '&#21404;',
	"\xD471" => '&#21877;',
	"\xD472" => '&#21878;',
	"\xD473" => '&#21820;',
	"\xD474" => '&#21837;',
	"\xD475" => '&#21840;',
	"\xD476" => '&#21812;',
	"\xD477" => '&#21802;',
	"\xD478" => '&#21841;',
	"\xD479" => '&#21858;',
	"\xD47A" => '&#21814;',
	"\xD47B" => '&#21813;',
	"\xD47C" => '&#21808;',
	"\xD47D" => '&#21842;',
	"\xD47E" => '&#21829;',
	"\xD4A1" => '&#21772;',
	"\xD4A2" => '&#21810;',
	"\xD4A3" => '&#21861;',
	"\xD4A4" => '&#21838;',
	"\xD4A5" => '&#21817;',
	"\xD4A6" => '&#21832;',
	"\xD4A7" => '&#21805;',
	"\xD4A8" => '&#21819;',
	"\xD4A9" => '&#21824;',
	"\xD4AA" => '&#21835;',
	"\xD4AB" => '&#22282;',
	"\xD4AC" => '&#22279;',
	"\xD4AD" => '&#22523;',
	"\xD4AE" => '&#22548;',
	"\xD4AF" => '&#22498;',
	"\xD4B0" => '&#22518;',
	"\xD4B1" => '&#22492;',
	"\xD4B2" => '&#22516;',
	"\xD4B3" => '&#22528;',
	"\xD4B4" => '&#22509;',
	"\xD4B5" => '&#22525;',
	"\xD4B6" => '&#22536;',
	"\xD4B7" => '&#22520;',
	"\xD4B8" => '&#22539;',
	"\xD4B9" => '&#22515;',
	"\xD4BA" => '&#22479;',
	"\xD4BB" => '&#22535;',
	"\xD4BC" => '&#22510;',
	"\xD4BD" => '&#22499;',
	"\xD4BE" => '&#22514;',
	"\xD4BF" => '&#22501;',
	"\xD4C0" => '&#22508;',
	"\xD4C1" => '&#22497;',
	"\xD4C2" => '&#22542;',
	"\xD4C3" => '&#22524;',
	"\xD4C4" => '&#22544;',
	"\xD4C5" => '&#22503;',
	"\xD4C6" => '&#22529;',
	"\xD4C7" => '&#22540;',
	"\xD4C8" => '&#22513;',
	"\xD4C9" => '&#22505;',
	"\xD4CA" => '&#22512;',
	"\xD4CB" => '&#22541;',
	"\xD4CC" => '&#22532;',
	"\xD4CD" => '&#22876;',
	"\xD4CE" => '&#23136;',
	"\xD4CF" => '&#23128;',
	"\xD4D0" => '&#23125;',
	"\xD4D1" => '&#23143;',
	"\xD4D2" => '&#23134;',
	"\xD4D3" => '&#23096;',
	"\xD4D4" => '&#23093;',
	"\xD4D5" => '&#23149;',
	"\xD4D6" => '&#23120;',
	"\xD4D7" => '&#23135;',
	"\xD4D8" => '&#23141;',
	"\xD4D9" => '&#23148;',
	"\xD4DA" => '&#23123;',
	"\xD4DB" => '&#23140;',
	"\xD4DC" => '&#23127;',
	"\xD4DD" => '&#23107;',
	"\xD4DE" => '&#23133;',
	"\xD4DF" => '&#23122;',
	"\xD4E0" => '&#23108;',
	"\xD4E1" => '&#23131;',
	"\xD4E2" => '&#23112;',
	"\xD4E3" => '&#23182;',
	"\xD4E4" => '&#23102;',
	"\xD4E5" => '&#23117;',
	"\xD4E6" => '&#23097;',
	"\xD4E7" => '&#23116;',
	"\xD4E8" => '&#23152;',
	"\xD4E9" => '&#23145;',
	"\xD4EA" => '&#23111;',
	"\xD4EB" => '&#23121;',
	"\xD4EC" => '&#23126;',
	"\xD4ED" => '&#23106;',
	"\xD4EE" => '&#23132;',
	"\xD4EF" => '&#23410;',
	"\xD4F0" => '&#23406;',
	"\xD4F1" => '&#23489;',
	"\xD4F2" => '&#23488;',
	"\xD4F3" => '&#23641;',
	"\xD4F4" => '&#23838;',
	"\xD4F5" => '&#23819;',
	"\xD4F6" => '&#23837;',
	"\xD4F7" => '&#23834;',
	"\xD4F8" => '&#23840;',
	"\xD4F9" => '&#23820;',
	"\xD4FA" => '&#23848;',
	"\xD4FB" => '&#23821;',
	"\xD4FC" => '&#23846;',
	"\xD4FD" => '&#23845;',
	"\xD4FE" => '&#23823;',
	"\xD540" => '&#23856;',
	"\xD541" => '&#23826;',
	"\xD542" => '&#23843;',
	"\xD543" => '&#23839;',
	"\xD544" => '&#23854;',
	"\xD545" => '&#24126;',
	"\xD546" => '&#24116;',
	"\xD547" => '&#24241;',
	"\xD548" => '&#24244;',
	"\xD549" => '&#24249;',
	"\xD54A" => '&#24242;',
	"\xD54B" => '&#24243;',
	"\xD54C" => '&#24374;',
	"\xD54D" => '&#24376;',
	"\xD54E" => '&#24475;',
	"\xD54F" => '&#24470;',
	"\xD550" => '&#24479;',
	"\xD551" => '&#24714;',
	"\xD552" => '&#24720;',
	"\xD553" => '&#24710;',
	"\xD554" => '&#24766;',
	"\xD555" => '&#24752;',
	"\xD556" => '&#24762;',
	"\xD557" => '&#24787;',
	"\xD558" => '&#24788;',
	"\xD559" => '&#24783;',
	"\xD55A" => '&#24804;',
	"\xD55B" => '&#24793;',
	"\xD55C" => '&#24797;',
	"\xD55D" => '&#24776;',
	"\xD55E" => '&#24753;',
	"\xD55F" => '&#24795;',
	"\xD560" => '&#24759;',
	"\xD561" => '&#24778;',
	"\xD562" => '&#24767;',
	"\xD563" => '&#24771;',
	"\xD564" => '&#24781;',
	"\xD565" => '&#24768;',
	"\xD566" => '&#25394;',
	"\xD567" => '&#25445;',
	"\xD568" => '&#25482;',
	"\xD569" => '&#25474;',
	"\xD56A" => '&#25469;',
	"\xD56B" => '&#25533;',
	"\xD56C" => '&#25502;',
	"\xD56D" => '&#25517;',
	"\xD56E" => '&#25501;',
	"\xD56F" => '&#25495;',
	"\xD570" => '&#25515;',
	"\xD571" => '&#25486;',
	"\xD572" => '&#25455;',
	"\xD573" => '&#25479;',
	"\xD574" => '&#25488;',
	"\xD575" => '&#25454;',
	"\xD576" => '&#25519;',
	"\xD577" => '&#25461;',
	"\xD578" => '&#25500;',
	"\xD579" => '&#25453;',
	"\xD57A" => '&#25518;',
	"\xD57B" => '&#25468;',
	"\xD57C" => '&#25508;',
	"\xD57D" => '&#25403;',
	"\xD57E" => '&#25503;',
	"\xD5A1" => '&#25464;',
	"\xD5A2" => '&#25477;',
	"\xD5A3" => '&#25473;',
	"\xD5A4" => '&#25489;',
	"\xD5A5" => '&#25485;',
	"\xD5A6" => '&#25456;',
	"\xD5A7" => '&#25939;',
	"\xD5A8" => '&#26061;',
	"\xD5A9" => '&#26213;',
	"\xD5AA" => '&#26209;',
	"\xD5AB" => '&#26203;',
	"\xD5AC" => '&#26201;',
	"\xD5AD" => '&#26204;',
	"\xD5AE" => '&#26210;',
	"\xD5AF" => '&#26392;',
	"\xD5B0" => '&#26745;',
	"\xD5B1" => '&#26759;',
	"\xD5B2" => '&#26768;',
	"\xD5B3" => '&#26780;',
	"\xD5B4" => '&#26733;',
	"\xD5B5" => '&#26734;',
	"\xD5B6" => '&#26798;',
	"\xD5B7" => '&#26795;',
	"\xD5B8" => '&#26966;',
	"\xD5B9" => '&#26735;',
	"\xD5BA" => '&#26787;',
	"\xD5BB" => '&#26796;',
	"\xD5BC" => '&#26793;',
	"\xD5BD" => '&#26741;',
	"\xD5BE" => '&#26740;',
	"\xD5BF" => '&#26802;',
	"\xD5C0" => '&#26767;',
	"\xD5C1" => '&#26743;',
	"\xD5C2" => '&#26770;',
	"\xD5C3" => '&#26748;',
	"\xD5C4" => '&#26731;',
	"\xD5C5" => '&#26738;',
	"\xD5C6" => '&#26794;',
	"\xD5C7" => '&#26752;',
	"\xD5C8" => '&#26737;',
	"\xD5C9" => '&#26750;',
	"\xD5CA" => '&#26779;',
	"\xD5CB" => '&#26774;',
	"\xD5CC" => '&#26763;',
	"\xD5CD" => '&#26784;',
	"\xD5CE" => '&#26761;',
	"\xD5CF" => '&#26788;',
	"\xD5D0" => '&#26744;',
	"\xD5D1" => '&#26747;',
	"\xD5D2" => '&#26769;',
	"\xD5D3" => '&#26764;',
	"\xD5D4" => '&#26762;',
	"\xD5D5" => '&#26749;',
	"\xD5D6" => '&#27446;',
	"\xD5D7" => '&#27443;',
	"\xD5D8" => '&#27447;',
	"\xD5D9" => '&#27448;',
	"\xD5DA" => '&#27537;',
	"\xD5DB" => '&#27535;',
	"\xD5DC" => '&#27533;',
	"\xD5DD" => '&#27534;',
	"\xD5DE" => '&#27532;',
	"\xD5DF" => '&#27690;',
	"\xD5E0" => '&#28096;',
	"\xD5E1" => '&#28075;',
	"\xD5E2" => '&#28084;',
	"\xD5E3" => '&#28083;',
	"\xD5E4" => '&#28276;',
	"\xD5E5" => '&#28076;',
	"\xD5E6" => '&#28137;',
	"\xD5E7" => '&#28130;',
	"\xD5E8" => '&#28087;',
	"\xD5E9" => '&#28150;',
	"\xD5EA" => '&#28116;',
	"\xD5EB" => '&#28160;',
	"\xD5EC" => '&#28104;',
	"\xD5ED" => '&#28128;',
	"\xD5EE" => '&#28127;',
	"\xD5EF" => '&#28118;',
	"\xD5F0" => '&#28094;',
	"\xD5F1" => '&#28133;',
	"\xD5F2" => '&#28124;',
	"\xD5F3" => '&#28125;',
	"\xD5F4" => '&#28123;',
	"\xD5F5" => '&#28148;',
	"\xD5F6" => '&#28106;',
	"\xD5F7" => '&#28093;',
	"\xD5F8" => '&#28141;',
	"\xD5F9" => '&#28144;',
	"\xD5FA" => '&#28090;',
	"\xD5FB" => '&#28117;',
	"\xD5FC" => '&#28098;',
	"\xD5FD" => '&#28111;',
	"\xD5FE" => '&#28105;',
	"\xD640" => '&#28112;',
	"\xD641" => '&#28146;',
	"\xD642" => '&#28115;',
	"\xD643" => '&#28157;',
	"\xD644" => '&#28119;',
	"\xD645" => '&#28109;',
	"\xD646" => '&#28131;',
	"\xD647" => '&#28091;',
	"\xD648" => '&#28922;',
	"\xD649" => '&#28941;',
	"\xD64A" => '&#28919;',
	"\xD64B" => '&#28951;',
	"\xD64C" => '&#28916;',
	"\xD64D" => '&#28940;',
	"\xD64E" => '&#28912;',
	"\xD64F" => '&#28932;',
	"\xD650" => '&#28915;',
	"\xD651" => '&#28944;',
	"\xD652" => '&#28924;',
	"\xD653" => '&#28927;',
	"\xD654" => '&#28934;',
	"\xD655" => '&#28947;',
	"\xD656" => '&#28928;',
	"\xD657" => '&#28920;',
	"\xD658" => '&#28918;',
	"\xD659" => '&#28939;',
	"\xD65A" => '&#28930;',
	"\xD65B" => '&#28942;',
	"\xD65C" => '&#29310;',
	"\xD65D" => '&#29307;',
	"\xD65E" => '&#29308;',
	"\xD65F" => '&#29311;',
	"\xD660" => '&#29469;',
	"\xD661" => '&#29463;',
	"\xD662" => '&#29447;',
	"\xD663" => '&#29457;',
	"\xD664" => '&#29464;',
	"\xD665" => '&#29450;',
	"\xD666" => '&#29448;',
	"\xD667" => '&#29439;',
	"\xD668" => '&#29455;',
	"\xD669" => '&#29470;',
	"\xD66A" => '&#29576;',
	"\xD66B" => '&#29686;',
	"\xD66C" => '&#29688;',
	"\xD66D" => '&#29685;',
	"\xD66E" => '&#29700;',
	"\xD66F" => '&#29697;',
	"\xD670" => '&#29693;',
	"\xD671" => '&#29703;',
	"\xD672" => '&#29696;',
	"\xD673" => '&#29690;',
	"\xD674" => '&#29692;',
	"\xD675" => '&#29695;',
	"\xD676" => '&#29708;',
	"\xD677" => '&#29707;',
	"\xD678" => '&#29684;',
	"\xD679" => '&#29704;',
	"\xD67A" => '&#30052;',
	"\xD67B" => '&#30051;',
	"\xD67C" => '&#30158;',
	"\xD67D" => '&#30162;',
	"\xD67E" => '&#30159;',
	"\xD6A1" => '&#30155;',
	"\xD6A2" => '&#30156;',
	"\xD6A3" => '&#30161;',
	"\xD6A4" => '&#30160;',
	"\xD6A5" => '&#30351;',
	"\xD6A6" => '&#30345;',
	"\xD6A7" => '&#30419;',
	"\xD6A8" => '&#30521;',
	"\xD6A9" => '&#30511;',
	"\xD6AA" => '&#30509;',
	"\xD6AB" => '&#30513;',
	"\xD6AC" => '&#30514;',
	"\xD6AD" => '&#30516;',
	"\xD6AE" => '&#30515;',
	"\xD6AF" => '&#30525;',
	"\xD6B0" => '&#30501;',
	"\xD6B1" => '&#30523;',
	"\xD6B2" => '&#30517;',
	"\xD6B3" => '&#30792;',
	"\xD6B4" => '&#30802;',
	"\xD6B5" => '&#30793;',
	"\xD6B6" => '&#30797;',
	"\xD6B7" => '&#30794;',
	"\xD6B8" => '&#30796;',
	"\xD6B9" => '&#30758;',
	"\xD6BA" => '&#30789;',
	"\xD6BB" => '&#30800;',
	"\xD6BC" => '&#31076;',
	"\xD6BD" => '&#31079;',
	"\xD6BE" => '&#31081;',
	"\xD6BF" => '&#31082;',
	"\xD6C0" => '&#31075;',
	"\xD6C1" => '&#31083;',
	"\xD6C2" => '&#31073;',
	"\xD6C3" => '&#31163;',
	"\xD6C4" => '&#31226;',
	"\xD6C5" => '&#31224;',
	"\xD6C6" => '&#31222;',
	"\xD6C7" => '&#31223;',
	"\xD6C8" => '&#31375;',
	"\xD6C9" => '&#31380;',
	"\xD6CA" => '&#31376;',
	"\xD6CB" => '&#31541;',
	"\xD6CC" => '&#31559;',
	"\xD6CD" => '&#31540;',
	"\xD6CE" => '&#31525;',
	"\xD6CF" => '&#31536;',
	"\xD6D0" => '&#31522;',
	"\xD6D1" => '&#31524;',
	"\xD6D2" => '&#31539;',
	"\xD6D3" => '&#31512;',
	"\xD6D4" => '&#31530;',
	"\xD6D5" => '&#31517;',
	"\xD6D6" => '&#31537;',
	"\xD6D7" => '&#31531;',
	"\xD6D8" => '&#31533;',
	"\xD6D9" => '&#31535;',
	"\xD6DA" => '&#31538;',
	"\xD6DB" => '&#31544;',
	"\xD6DC" => '&#31514;',
	"\xD6DD" => '&#31523;',
	"\xD6DE" => '&#31892;',
	"\xD6DF" => '&#31896;',
	"\xD6E0" => '&#31894;',
	"\xD6E1" => '&#31907;',
	"\xD6E2" => '&#32053;',
	"\xD6E3" => '&#32061;',
	"\xD6E4" => '&#32056;',
	"\xD6E5" => '&#32054;',
	"\xD6E6" => '&#32058;',
	"\xD6E7" => '&#32069;',
	"\xD6E8" => '&#32044;',
	"\xD6E9" => '&#32041;',
	"\xD6EA" => '&#32065;',
	"\xD6EB" => '&#32071;',
	"\xD6EC" => '&#32062;',
	"\xD6ED" => '&#32063;',
	"\xD6EE" => '&#32074;',
	"\xD6EF" => '&#32059;',
	"\xD6F0" => '&#32040;',
	"\xD6F1" => '&#32611;',
	"\xD6F2" => '&#32661;',
	"\xD6F3" => '&#32668;',
	"\xD6F4" => '&#32669;',
	"\xD6F5" => '&#32667;',
	"\xD6F6" => '&#32714;',
	"\xD6F7" => '&#32715;',
	"\xD6F8" => '&#32717;',
	"\xD6F9" => '&#32720;',
	"\xD6FA" => '&#32721;',
	"\xD6FB" => '&#32711;',
	"\xD6FC" => '&#32719;',
	"\xD6FD" => '&#32713;',
	"\xD6FE" => '&#32799;',
	"\xD740" => '&#32798;',
	"\xD741" => '&#32795;',
	"\xD742" => '&#32839;',
	"\xD743" => '&#32835;',
	"\xD744" => '&#32840;',
	"\xD745" => '&#33048;',
	"\xD746" => '&#33061;',
	"\xD747" => '&#33049;',
	"\xD748" => '&#33051;',
	"\xD749" => '&#33069;',
	"\xD74A" => '&#33055;',
	"\xD74B" => '&#33068;',
	"\xD74C" => '&#33054;',
	"\xD74D" => '&#33057;',
	"\xD74E" => '&#33045;',
	"\xD74F" => '&#33063;',
	"\xD750" => '&#33053;',
	"\xD751" => '&#33058;',
	"\xD752" => '&#33297;',
	"\xD753" => '&#33336;',
	"\xD754" => '&#33331;',
	"\xD755" => '&#33338;',
	"\xD756" => '&#33332;',
	"\xD757" => '&#33330;',
	"\xD758" => '&#33396;',
	"\xD759" => '&#33680;',
	"\xD75A" => '&#33699;',
	"\xD75B" => '&#33704;',
	"\xD75C" => '&#33677;',
	"\xD75D" => '&#33658;',
	"\xD75E" => '&#33651;',
	"\xD75F" => '&#33700;',
	"\xD760" => '&#33652;',
	"\xD761" => '&#33679;',
	"\xD762" => '&#33665;',
	"\xD763" => '&#33685;',
	"\xD764" => '&#33689;',
	"\xD765" => '&#33653;',
	"\xD766" => '&#33684;',
	"\xD767" => '&#33705;',
	"\xD768" => '&#33661;',
	"\xD769" => '&#33667;',
	"\xD76A" => '&#33676;',
	"\xD76B" => '&#33693;',
	"\xD76C" => '&#33691;',
	"\xD76D" => '&#33706;',
	"\xD76E" => '&#33675;',
	"\xD76F" => '&#33662;',
	"\xD770" => '&#33701;',
	"\xD771" => '&#33711;',
	"\xD772" => '&#33672;',
	"\xD773" => '&#33687;',
	"\xD774" => '&#33712;',
	"\xD775" => '&#33663;',
	"\xD776" => '&#33702;',
	"\xD777" => '&#33671;',
	"\xD778" => '&#33710;',
	"\xD779" => '&#33654;',
	"\xD77A" => '&#33690;',
	"\xD77B" => '&#34393;',
	"\xD77C" => '&#34390;',
	"\xD77D" => '&#34495;',
	"\xD77E" => '&#34487;',
	"\xD7A1" => '&#34498;',
	"\xD7A2" => '&#34497;',
	"\xD7A3" => '&#34501;',
	"\xD7A4" => '&#34490;',
	"\xD7A5" => '&#34480;',
	"\xD7A6" => '&#34504;',
	"\xD7A7" => '&#34489;',
	"\xD7A8" => '&#34483;',
	"\xD7A9" => '&#34488;',
	"\xD7AA" => '&#34508;',
	"\xD7AB" => '&#34484;',
	"\xD7AC" => '&#34491;',
	"\xD7AD" => '&#34492;',
	"\xD7AE" => '&#34499;',
	"\xD7AF" => '&#34493;',
	"\xD7B0" => '&#34494;',
	"\xD7B1" => '&#34898;',
	"\xD7B2" => '&#34953;',
	"\xD7B3" => '&#34965;',
	"\xD7B4" => '&#34984;',
	"\xD7B5" => '&#34978;',
	"\xD7B6" => '&#34986;',
	"\xD7B7" => '&#34970;',
	"\xD7B8" => '&#34961;',
	"\xD7B9" => '&#34977;',
	"\xD7BA" => '&#34975;',
	"\xD7BB" => '&#34968;',
	"\xD7BC" => '&#34983;',
	"\xD7BD" => '&#34969;',
	"\xD7BE" => '&#34971;',
	"\xD7BF" => '&#34967;',
	"\xD7C0" => '&#34980;',
	"\xD7C1" => '&#34988;',
	"\xD7C2" => '&#34956;',
	"\xD7C3" => '&#34963;',
	"\xD7C4" => '&#34958;',
	"\xD7C5" => '&#35202;',
	"\xD7C6" => '&#35286;',
	"\xD7C7" => '&#35289;',
	"\xD7C8" => '&#35285;',
	"\xD7C9" => '&#35376;',
	"\xD7CA" => '&#35367;',
	"\xD7CB" => '&#35372;',
	"\xD7CC" => '&#35358;',
	"\xD7CD" => '&#35897;',
	"\xD7CE" => '&#35899;',
	"\xD7CF" => '&#35932;',
	"\xD7D0" => '&#35933;',
	"\xD7D1" => '&#35965;',
	"\xD7D2" => '&#36005;',
	"\xD7D3" => '&#36221;',
	"\xD7D4" => '&#36219;',
	"\xD7D5" => '&#36217;',
	"\xD7D6" => '&#36284;',
	"\xD7D7" => '&#36290;',
	"\xD7D8" => '&#36281;',
	"\xD7D9" => '&#36287;',
	"\xD7DA" => '&#36289;',
	"\xD7DB" => '&#36568;',
	"\xD7DC" => '&#36574;',
	"\xD7DD" => '&#36573;',
	"\xD7DE" => '&#36572;',
	"\xD7DF" => '&#36567;',
	"\xD7E0" => '&#36576;',
	"\xD7E1" => '&#36577;',
	"\xD7E2" => '&#36900;',
	"\xD7E3" => '&#36875;',
	"\xD7E4" => '&#36881;',
	"\xD7E5" => '&#36892;',
	"\xD7E6" => '&#36876;',
	"\xD7E7" => '&#36897;',
	"\xD7E8" => '&#37103;',
	"\xD7E9" => '&#37098;',
	"\xD7EA" => '&#37104;',
	"\xD7EB" => '&#37108;',
	"\xD7EC" => '&#37106;',
	"\xD7ED" => '&#37107;',
	"\xD7EE" => '&#37076;',
	"\xD7EF" => '&#37099;',
	"\xD7F0" => '&#37100;',
	"\xD7F1" => '&#37097;',
	"\xD7F2" => '&#37206;',
	"\xD7F3" => '&#37208;',
	"\xD7F4" => '&#37210;',
	"\xD7F5" => '&#37203;',
	"\xD7F6" => '&#37205;',
	"\xD7F7" => '&#37356;',
	"\xD7F8" => '&#37364;',
	"\xD7F9" => '&#37361;',
	"\xD7FA" => '&#37363;',
	"\xD7FB" => '&#37368;',
	"\xD7FC" => '&#37348;',
	"\xD7FD" => '&#37369;',
	"\xD7FE" => '&#37354;',
	"\xD840" => '&#37355;',
	"\xD841" => '&#37367;',
	"\xD842" => '&#37352;',
	"\xD843" => '&#37358;',
	"\xD844" => '&#38266;',
	"\xD845" => '&#38278;',
	"\xD846" => '&#38280;',
	"\xD847" => '&#38524;',
	"\xD848" => '&#38509;',
	"\xD849" => '&#38507;',
	"\xD84A" => '&#38513;',
	"\xD84B" => '&#38511;',
	"\xD84C" => '&#38591;',
	"\xD84D" => '&#38762;',
	"\xD84E" => '&#38916;',
	"\xD84F" => '&#39141;',
	"\xD850" => '&#39319;',
	"\xD851" => '&#20635;',
	"\xD852" => '&#20629;',
	"\xD853" => '&#20628;',
	"\xD854" => '&#20638;',
	"\xD855" => '&#20619;',
	"\xD856" => '&#20643;',
	"\xD857" => '&#20611;',
	"\xD858" => '&#20620;',
	"\xD859" => '&#20622;',
	"\xD85A" => '&#20637;',
	"\xD85B" => '&#20584;',
	"\xD85C" => '&#20636;',
	"\xD85D" => '&#20626;',
	"\xD85E" => '&#20610;',
	"\xD85F" => '&#20615;',
	"\xD860" => '&#20831;',
	"\xD861" => '&#20948;',
	"\xD862" => '&#21266;',
	"\xD863" => '&#21265;',
	"\xD864" => '&#21412;',
	"\xD865" => '&#21415;',
	"\xD866" => '&#21905;',
	"\xD867" => '&#21928;',
	"\xD868" => '&#21925;',
	"\xD869" => '&#21933;',
	"\xD86A" => '&#21879;',
	"\xD86B" => '&#22085;',
	"\xD86C" => '&#21922;',
	"\xD86D" => '&#21907;',
	"\xD86E" => '&#21896;',
	"\xD86F" => '&#21903;',
	"\xD870" => '&#21941;',
	"\xD871" => '&#21889;',
	"\xD872" => '&#21923;',
	"\xD873" => '&#21906;',
	"\xD874" => '&#21924;',
	"\xD875" => '&#21885;',
	"\xD876" => '&#21900;',
	"\xD877" => '&#21926;',
	"\xD878" => '&#21887;',
	"\xD879" => '&#21909;',
	"\xD87A" => '&#21921;',
	"\xD87B" => '&#21902;',
	"\xD87C" => '&#22284;',
	"\xD87D" => '&#22569;',
	"\xD87E" => '&#22583;',
	"\xD8A1" => '&#22553;',
	"\xD8A2" => '&#22558;',
	"\xD8A3" => '&#22567;',
	"\xD8A4" => '&#22563;',
	"\xD8A5" => '&#22568;',
	"\xD8A6" => '&#22517;',
	"\xD8A7" => '&#22600;',
	"\xD8A8" => '&#22565;',
	"\xD8A9" => '&#22556;',
	"\xD8AA" => '&#22555;',
	"\xD8AB" => '&#22579;',
	"\xD8AC" => '&#22591;',
	"\xD8AD" => '&#22582;',
	"\xD8AE" => '&#22574;',
	"\xD8AF" => '&#22585;',
	"\xD8B0" => '&#22584;',
	"\xD8B1" => '&#22573;',
	"\xD8B2" => '&#22572;',
	"\xD8B3" => '&#22587;',
	"\xD8B4" => '&#22881;',
	"\xD8B5" => '&#23215;',
	"\xD8B6" => '&#23188;',
	"\xD8B7" => '&#23199;',
	"\xD8B8" => '&#23162;',
	"\xD8B9" => '&#23202;',
	"\xD8BA" => '&#23198;',
	"\xD8BB" => '&#23160;',
	"\xD8BC" => '&#23206;',
	"\xD8BD" => '&#23164;',
	"\xD8BE" => '&#23205;',
	"\xD8BF" => '&#23212;',
	"\xD8C0" => '&#23189;',
	"\xD8C1" => '&#23214;',
	"\xD8C2" => '&#23095;',
	"\xD8C3" => '&#23172;',
	"\xD8C4" => '&#23178;',
	"\xD8C5" => '&#23191;',
	"\xD8C6" => '&#23171;',
	"\xD8C7" => '&#23179;',
	"\xD8C8" => '&#23209;',
	"\xD8C9" => '&#23163;',
	"\xD8CA" => '&#23165;',
	"\xD8CB" => '&#23180;',
	"\xD8CC" => '&#23196;',
	"\xD8CD" => '&#23183;',
	"\xD8CE" => '&#23187;',
	"\xD8CF" => '&#23197;',
	"\xD8D0" => '&#23530;',
	"\xD8D1" => '&#23501;',
	"\xD8D2" => '&#23499;',
	"\xD8D3" => '&#23508;',
	"\xD8D4" => '&#23505;',
	"\xD8D5" => '&#23498;',
	"\xD8D6" => '&#23502;',
	"\xD8D7" => '&#23564;',
	"\xD8D8" => '&#23600;',
	"\xD8D9" => '&#23863;',
	"\xD8DA" => '&#23875;',
	"\xD8DB" => '&#23915;',
	"\xD8DC" => '&#23873;',
	"\xD8DD" => '&#23883;',
	"\xD8DE" => '&#23871;',
	"\xD8DF" => '&#23861;',
	"\xD8E0" => '&#23889;',
	"\xD8E1" => '&#23886;',
	"\xD8E2" => '&#23893;',
	"\xD8E3" => '&#23859;',
	"\xD8E4" => '&#23866;',
	"\xD8E5" => '&#23890;',
	"\xD8E6" => '&#23869;',
	"\xD8E7" => '&#23857;',
	"\xD8E8" => '&#23897;',
	"\xD8E9" => '&#23874;',
	"\xD8EA" => '&#23865;',
	"\xD8EB" => '&#23881;',
	"\xD8EC" => '&#23864;',
	"\xD8ED" => '&#23868;',
	"\xD8EE" => '&#23858;',
	"\xD8EF" => '&#23862;',
	"\xD8F0" => '&#23872;',
	"\xD8F1" => '&#23877;',
	"\xD8F2" => '&#24132;',
	"\xD8F3" => '&#24129;',
	"\xD8F4" => '&#24408;',
	"\xD8F5" => '&#24486;',
	"\xD8F6" => '&#24485;',
	"\xD8F7" => '&#24491;',
	"\xD8F8" => '&#24777;',
	"\xD8F9" => '&#24761;',
	"\xD8FA" => '&#24780;',
	"\xD8FB" => '&#24802;',
	"\xD8FC" => '&#24782;',
	"\xD8FD" => '&#24772;',
	"\xD8FE" => '&#24852;',
	"\xD940" => '&#24818;',
	"\xD941" => '&#24842;',
	"\xD942" => '&#24854;',
	"\xD943" => '&#24837;',
	"\xD944" => '&#24821;',
	"\xD945" => '&#24851;',
	"\xD946" => '&#24824;',
	"\xD947" => '&#24828;',
	"\xD948" => '&#24830;',
	"\xD949" => '&#24769;',
	"\xD94A" => '&#24835;',
	"\xD94B" => '&#24856;',
	"\xD94C" => '&#24861;',
	"\xD94D" => '&#24848;',
	"\xD94E" => '&#24831;',
	"\xD94F" => '&#24836;',
	"\xD950" => '&#24843;',
	"\xD951" => '&#25162;',
	"\xD952" => '&#25492;',
	"\xD953" => '&#25521;',
	"\xD954" => '&#25520;',
	"\xD955" => '&#25550;',
	"\xD956" => '&#25573;',
	"\xD957" => '&#25576;',
	"\xD958" => '&#25583;',
	"\xD959" => '&#25539;',
	"\xD95A" => '&#25757;',
	"\xD95B" => '&#25587;',
	"\xD95C" => '&#25546;',
	"\xD95D" => '&#25568;',
	"\xD95E" => '&#25590;',
	"\xD95F" => '&#25557;',
	"\xD960" => '&#25586;',
	"\xD961" => '&#25589;',
	"\xD962" => '&#25697;',
	"\xD963" => '&#25567;',
	"\xD964" => '&#25534;',
	"\xD965" => '&#25565;',
	"\xD966" => '&#25564;',
	"\xD967" => '&#25540;',
	"\xD968" => '&#25560;',
	"\xD969" => '&#25555;',
	"\xD96A" => '&#25538;',
	"\xD96B" => '&#25543;',
	"\xD96C" => '&#25548;',
	"\xD96D" => '&#25547;',
	"\xD96E" => '&#25544;',
	"\xD96F" => '&#25584;',
	"\xD970" => '&#25559;',
	"\xD971" => '&#25561;',
	"\xD972" => '&#25906;',
	"\xD973" => '&#25959;',
	"\xD974" => '&#25962;',
	"\xD975" => '&#25956;',
	"\xD976" => '&#25948;',
	"\xD977" => '&#25960;',
	"\xD978" => '&#25957;',
	"\xD979" => '&#25996;',
	"\xD97A" => '&#26013;',
	"\xD97B" => '&#26014;',
	"\xD97C" => '&#26030;',
	"\xD97D" => '&#26064;',
	"\xD97E" => '&#26066;',
	"\xD9A1" => '&#26236;',
	"\xD9A2" => '&#26220;',
	"\xD9A3" => '&#26235;',
	"\xD9A4" => '&#26240;',
	"\xD9A5" => '&#26225;',
	"\xD9A6" => '&#26233;',
	"\xD9A7" => '&#26218;',
	"\xD9A8" => '&#26226;',
	"\xD9A9" => '&#26369;',
	"\xD9AA" => '&#26892;',
	"\xD9AB" => '&#26835;',
	"\xD9AC" => '&#26884;',
	"\xD9AD" => '&#26844;',
	"\xD9AE" => '&#26922;',
	"\xD9AF" => '&#26860;',
	"\xD9B0" => '&#26858;',
	"\xD9B1" => '&#26865;',
	"\xD9B2" => '&#26895;',
	"\xD9B3" => '&#26838;',
	"\xD9B4" => '&#26871;',
	"\xD9B5" => '&#26859;',
	"\xD9B6" => '&#26852;',
	"\xD9B7" => '&#26870;',
	"\xD9B8" => '&#26899;',
	"\xD9B9" => '&#26896;',
	"\xD9BA" => '&#26867;',
	"\xD9BB" => '&#26849;',
	"\xD9BC" => '&#26887;',
	"\xD9BD" => '&#26828;',
	"\xD9BE" => '&#26888;',
	"\xD9BF" => '&#26992;',
	"\xD9C0" => '&#26804;',
	"\xD9C1" => '&#26897;',
	"\xD9C2" => '&#26863;',
	"\xD9C3" => '&#26822;',
	"\xD9C4" => '&#26900;',
	"\xD9C5" => '&#26872;',
	"\xD9C6" => '&#26832;',
	"\xD9C7" => '&#26877;',
	"\xD9C8" => '&#26876;',
	"\xD9C9" => '&#26856;',
	"\xD9CA" => '&#26891;',
	"\xD9CB" => '&#26890;',
	"\xD9CC" => '&#26903;',
	"\xD9CD" => '&#26830;',
	"\xD9CE" => '&#26824;',
	"\xD9CF" => '&#26845;',
	"\xD9D0" => '&#26846;',
	"\xD9D1" => '&#26854;',
	"\xD9D2" => '&#26868;',
	"\xD9D3" => '&#26833;',
	"\xD9D4" => '&#26886;',
	"\xD9D5" => '&#26836;',
	"\xD9D6" => '&#26857;',
	"\xD9D7" => '&#26901;',
	"\xD9D8" => '&#26917;',
	"\xD9D9" => '&#26823;',
	"\xD9DA" => '&#27449;',
	"\xD9DB" => '&#27451;',
	"\xD9DC" => '&#27455;',
	"\xD9DD" => '&#27452;',
	"\xD9DE" => '&#27540;',
	"\xD9DF" => '&#27543;',
	"\xD9E0" => '&#27545;',
	"\xD9E1" => '&#27541;',
	"\xD9E2" => '&#27581;',
	"\xD9E3" => '&#27632;',
	"\xD9E4" => '&#27634;',
	"\xD9E5" => '&#27635;',
	"\xD9E6" => '&#27696;',
	"\xD9E7" => '&#28156;',
	"\xD9E8" => '&#28230;',
	"\xD9E9" => '&#28231;',
	"\xD9EA" => '&#28191;',
	"\xD9EB" => '&#28233;',
	"\xD9EC" => '&#28296;',
	"\xD9ED" => '&#28220;',
	"\xD9EE" => '&#28221;',
	"\xD9EF" => '&#28229;',
	"\xD9F0" => '&#28258;',
	"\xD9F1" => '&#28203;',
	"\xD9F2" => '&#28223;',
	"\xD9F3" => '&#28225;',
	"\xD9F4" => '&#28253;',
	"\xD9F5" => '&#28275;',
	"\xD9F6" => '&#28188;',
	"\xD9F7" => '&#28211;',
	"\xD9F8" => '&#28235;',
	"\xD9F9" => '&#28224;',
	"\xD9FA" => '&#28241;',
	"\xD9FB" => '&#28219;',
	"\xD9FC" => '&#28163;',
	"\xD9FD" => '&#28206;',
	"\xD9FE" => '&#28254;',
	"\xDA40" => '&#28264;',
	"\xDA41" => '&#28252;',
	"\xDA42" => '&#28257;',
	"\xDA43" => '&#28209;',
	"\xDA44" => '&#28200;',
	"\xDA45" => '&#28256;',
	"\xDA46" => '&#28273;',
	"\xDA47" => '&#28267;',
	"\xDA48" => '&#28217;',
	"\xDA49" => '&#28194;',
	"\xDA4A" => '&#28208;',
	"\xDA4B" => '&#28243;',
	"\xDA4C" => '&#28261;',
	"\xDA4D" => '&#28199;',
	"\xDA4E" => '&#28280;',
	"\xDA4F" => '&#28260;',
	"\xDA50" => '&#28279;',
	"\xDA51" => '&#28245;',
	"\xDA52" => '&#28281;',
	"\xDA53" => '&#28242;',
	"\xDA54" => '&#28262;',
	"\xDA55" => '&#28213;',
	"\xDA56" => '&#28214;',
	"\xDA57" => '&#28250;',
	"\xDA58" => '&#28960;',
	"\xDA59" => '&#28958;',
	"\xDA5A" => '&#28975;',
	"\xDA5B" => '&#28923;',
	"\xDA5C" => '&#28974;',
	"\xDA5D" => '&#28977;',
	"\xDA5E" => '&#28963;',
	"\xDA5F" => '&#28965;',
	"\xDA60" => '&#28962;',
	"\xDA61" => '&#28978;',
	"\xDA62" => '&#28959;',
	"\xDA63" => '&#28968;',
	"\xDA64" => '&#28986;',
	"\xDA65" => '&#28955;',
	"\xDA66" => '&#29259;',
	"\xDA67" => '&#29274;',
	"\xDA68" => '&#29320;',
	"\xDA69" => '&#29321;',
	"\xDA6A" => '&#29318;',
	"\xDA6B" => '&#29317;',
	"\xDA6C" => '&#29323;',
	"\xDA6D" => '&#29458;',
	"\xDA6E" => '&#29451;',
	"\xDA6F" => '&#29488;',
	"\xDA70" => '&#29474;',
	"\xDA71" => '&#29489;',
	"\xDA72" => '&#29491;',
	"\xDA73" => '&#29479;',
	"\xDA74" => '&#29490;',
	"\xDA75" => '&#29485;',
	"\xDA76" => '&#29478;',
	"\xDA77" => '&#29475;',
	"\xDA78" => '&#29493;',
	"\xDA79" => '&#29452;',
	"\xDA7A" => '&#29742;',
	"\xDA7B" => '&#29740;',
	"\xDA7C" => '&#29744;',
	"\xDA7D" => '&#29739;',
	"\xDA7E" => '&#29718;',
	"\xDAA1" => '&#29722;',
	"\xDAA2" => '&#29729;',
	"\xDAA3" => '&#29741;',
	"\xDAA4" => '&#29745;',
	"\xDAA5" => '&#29732;',
	"\xDAA6" => '&#29731;',
	"\xDAA7" => '&#29725;',
	"\xDAA8" => '&#29737;',
	"\xDAA9" => '&#29728;',
	"\xDAAA" => '&#29746;',
	"\xDAAB" => '&#29947;',
	"\xDAAC" => '&#29999;',
	"\xDAAD" => '&#30063;',
	"\xDAAE" => '&#30060;',
	"\xDAAF" => '&#30183;',
	"\xDAB0" => '&#30170;',
	"\xDAB1" => '&#30177;',
	"\xDAB2" => '&#30182;',
	"\xDAB3" => '&#30173;',
	"\xDAB4" => '&#30175;',
	"\xDAB5" => '&#30180;',
	"\xDAB6" => '&#30167;',
	"\xDAB7" => '&#30357;',
	"\xDAB8" => '&#30354;',
	"\xDAB9" => '&#30426;',
	"\xDABA" => '&#30534;',
	"\xDABB" => '&#30535;',
	"\xDABC" => '&#30532;',
	"\xDABD" => '&#30541;',
	"\xDABE" => '&#30533;',
	"\xDABF" => '&#30538;',
	"\xDAC0" => '&#30542;',
	"\xDAC1" => '&#30539;',
	"\xDAC2" => '&#30540;',
	"\xDAC3" => '&#30686;',
	"\xDAC4" => '&#30700;',
	"\xDAC5" => '&#30816;',
	"\xDAC6" => '&#30820;',
	"\xDAC7" => '&#30821;',
	"\xDAC8" => '&#30812;',
	"\xDAC9" => '&#30829;',
	"\xDACA" => '&#30833;',
	"\xDACB" => '&#30826;',
	"\xDACC" => '&#30830;',
	"\xDACD" => '&#30832;',
	"\xDACE" => '&#30825;',
	"\xDACF" => '&#30824;',
	"\xDAD0" => '&#30814;',
	"\xDAD1" => '&#30818;',
	"\xDAD2" => '&#31092;',
	"\xDAD3" => '&#31091;',
	"\xDAD4" => '&#31090;',
	"\xDAD5" => '&#31088;',
	"\xDAD6" => '&#31234;',
	"\xDAD7" => '&#31242;',
	"\xDAD8" => '&#31235;',
	"\xDAD9" => '&#31244;',
	"\xDADA" => '&#31236;',
	"\xDADB" => '&#31385;',
	"\xDADC" => '&#31462;',
	"\xDADD" => '&#31460;',
	"\xDADE" => '&#31562;',
	"\xDADF" => '&#31547;',
	"\xDAE0" => '&#31556;',
	"\xDAE1" => '&#31560;',
	"\xDAE2" => '&#31564;',
	"\xDAE3" => '&#31566;',
	"\xDAE4" => '&#31552;',
	"\xDAE5" => '&#31576;',
	"\xDAE6" => '&#31557;',
	"\xDAE7" => '&#31906;',
	"\xDAE8" => '&#31902;',
	"\xDAE9" => '&#31912;',
	"\xDAEA" => '&#31905;',
	"\xDAEB" => '&#32088;',
	"\xDAEC" => '&#32111;',
	"\xDAED" => '&#32099;',
	"\xDAEE" => '&#32083;',
	"\xDAEF" => '&#32086;',
	"\xDAF0" => '&#32103;',
	"\xDAF1" => '&#32106;',
	"\xDAF2" => '&#32079;',
	"\xDAF3" => '&#32109;',
	"\xDAF4" => '&#32092;',
	"\xDAF5" => '&#32107;',
	"\xDAF6" => '&#32082;',
	"\xDAF7" => '&#32084;',
	"\xDAF8" => '&#32105;',
	"\xDAF9" => '&#32081;',
	"\xDAFA" => '&#32095;',
	"\xDAFB" => '&#32078;',
	"\xDAFC" => '&#32574;',
	"\xDAFD" => '&#32575;',
	"\xDAFE" => '&#32613;',
	"\xDB40" => '&#32614;',
	"\xDB41" => '&#32674;',
	"\xDB42" => '&#32672;',
	"\xDB43" => '&#32673;',
	"\xDB44" => '&#32727;',
	"\xDB45" => '&#32849;',
	"\xDB46" => '&#32847;',
	"\xDB47" => '&#32848;',
	"\xDB48" => '&#33022;',
	"\xDB49" => '&#32980;',
	"\xDB4A" => '&#33091;',
	"\xDB4B" => '&#33098;',
	"\xDB4C" => '&#33106;',
	"\xDB4D" => '&#33103;',
	"\xDB4E" => '&#33095;',
	"\xDB4F" => '&#33085;',
	"\xDB50" => '&#33101;',
	"\xDB51" => '&#33082;',
	"\xDB52" => '&#33254;',
	"\xDB53" => '&#33262;',
	"\xDB54" => '&#33271;',
	"\xDB55" => '&#33272;',
	"\xDB56" => '&#33273;',
	"\xDB57" => '&#33284;',
	"\xDB58" => '&#33340;',
	"\xDB59" => '&#33341;',
	"\xDB5A" => '&#33343;',
	"\xDB5B" => '&#33397;',
	"\xDB5C" => '&#33595;',
	"\xDB5D" => '&#33743;',
	"\xDB5E" => '&#33785;',
	"\xDB5F" => '&#33827;',
	"\xDB60" => '&#33728;',
	"\xDB61" => '&#33768;',
	"\xDB62" => '&#33810;',
	"\xDB63" => '&#33767;',
	"\xDB64" => '&#33764;',
	"\xDB65" => '&#33788;',
	"\xDB66" => '&#33782;',
	"\xDB67" => '&#33808;',
	"\xDB68" => '&#33734;',
	"\xDB69" => '&#33736;',
	"\xDB6A" => '&#33771;',
	"\xDB6B" => '&#33763;',
	"\xDB6C" => '&#33727;',
	"\xDB6D" => '&#33793;',
	"\xDB6E" => '&#33757;',
	"\xDB6F" => '&#33765;',
	"\xDB70" => '&#33752;',
	"\xDB71" => '&#33791;',
	"\xDB72" => '&#33761;',
	"\xDB73" => '&#33739;',
	"\xDB74" => '&#33742;',
	"\xDB75" => '&#33750;',
	"\xDB76" => '&#33781;',
	"\xDB77" => '&#33737;',
	"\xDB78" => '&#33801;',
	"\xDB79" => '&#33807;',
	"\xDB7A" => '&#33758;',
	"\xDB7B" => '&#33809;',
	"\xDB7C" => '&#33798;',
	"\xDB7D" => '&#33730;',
	"\xDB7E" => '&#33779;',
	"\xDBA1" => '&#33749;',
	"\xDBA2" => '&#33786;',
	"\xDBA3" => '&#33735;',
	"\xDBA4" => '&#33745;',
	"\xDBA5" => '&#33770;',
	"\xDBA6" => '&#33811;',
	"\xDBA7" => '&#33731;',
	"\xDBA8" => '&#33772;',
	"\xDBA9" => '&#33774;',
	"\xDBAA" => '&#33732;',
	"\xDBAB" => '&#33787;',
	"\xDBAC" => '&#33751;',
	"\xDBAD" => '&#33762;',
	"\xDBAE" => '&#33819;',
	"\xDBAF" => '&#33755;',
	"\xDBB0" => '&#33790;',
	"\xDBB1" => '&#34520;',
	"\xDBB2" => '&#34530;',
	"\xDBB3" => '&#34534;',
	"\xDBB4" => '&#34515;',
	"\xDBB5" => '&#34531;',
	"\xDBB6" => '&#34522;',
	"\xDBB7" => '&#34538;',
	"\xDBB8" => '&#34525;',
	"\xDBB9" => '&#34539;',
	"\xDBBA" => '&#34524;',
	"\xDBBB" => '&#34540;',
	"\xDBBC" => '&#34537;',
	"\xDBBD" => '&#34519;',
	"\xDBBE" => '&#34536;',
	"\xDBBF" => '&#34513;',
	"\xDBC0" => '&#34888;',
	"\xDBC1" => '&#34902;',
	"\xDBC2" => '&#34901;',
	"\xDBC3" => '&#35002;',
	"\xDBC4" => '&#35031;',
	"\xDBC5" => '&#35001;',
	"\xDBC6" => '&#35000;',
	"\xDBC7" => '&#35008;',
	"\xDBC8" => '&#35006;',
	"\xDBC9" => '&#34998;',
	"\xDBCA" => '&#35004;',
	"\xDBCB" => '&#34999;',
	"\xDBCC" => '&#35005;',
	"\xDBCD" => '&#34994;',
	"\xDBCE" => '&#35073;',
	"\xDBCF" => '&#35017;',
	"\xDBD0" => '&#35221;',
	"\xDBD1" => '&#35224;',
	"\xDBD2" => '&#35223;',
	"\xDBD3" => '&#35293;',
	"\xDBD4" => '&#35290;',
	"\xDBD5" => '&#35291;',
	"\xDBD6" => '&#35406;',
	"\xDBD7" => '&#35405;',
	"\xDBD8" => '&#35385;',
	"\xDBD9" => '&#35417;',
	"\xDBDA" => '&#35392;',
	"\xDBDB" => '&#35415;',
	"\xDBDC" => '&#35416;',
	"\xDBDD" => '&#35396;',
	"\xDBDE" => '&#35397;',
	"\xDBDF" => '&#35410;',
	"\xDBE0" => '&#35400;',
	"\xDBE1" => '&#35409;',
	"\xDBE2" => '&#35402;',
	"\xDBE3" => '&#35404;',
	"\xDBE4" => '&#35407;',
	"\xDBE5" => '&#35935;',
	"\xDBE6" => '&#35969;',
	"\xDBE7" => '&#35968;',
	"\xDBE8" => '&#36026;',
	"\xDBE9" => '&#36030;',
	"\xDBEA" => '&#36016;',
	"\xDBEB" => '&#36025;',
	"\xDBEC" => '&#36021;',
	"\xDBED" => '&#36228;',
	"\xDBEE" => '&#36224;',
	"\xDBEF" => '&#36233;',
	"\xDBF0" => '&#36312;',
	"\xDBF1" => '&#36307;',
	"\xDBF2" => '&#36301;',
	"\xDBF3" => '&#36295;',
	"\xDBF4" => '&#36310;',
	"\xDBF5" => '&#36316;',
	"\xDBF6" => '&#36303;',
	"\xDBF7" => '&#36309;',
	"\xDBF8" => '&#36313;',
	"\xDBF9" => '&#36296;',
	"\xDBFA" => '&#36311;',
	"\xDBFB" => '&#36293;',
	"\xDBFC" => '&#36591;',
	"\xDBFD" => '&#36599;',
	"\xDBFE" => '&#36602;',
	"\xDC40" => '&#36601;',
	"\xDC41" => '&#36582;',
	"\xDC42" => '&#36590;',
	"\xDC43" => '&#36581;',
	"\xDC44" => '&#36597;',
	"\xDC45" => '&#36583;',
	"\xDC46" => '&#36584;',
	"\xDC47" => '&#36598;',
	"\xDC48" => '&#36587;',
	"\xDC49" => '&#36593;',
	"\xDC4A" => '&#36588;',
	"\xDC4B" => '&#36596;',
	"\xDC4C" => '&#36585;',
	"\xDC4D" => '&#36909;',
	"\xDC4E" => '&#36916;',
	"\xDC4F" => '&#36911;',
	"\xDC50" => '&#37126;',
	"\xDC51" => '&#37164;',
	"\xDC52" => '&#37124;',
	"\xDC53" => '&#37119;',
	"\xDC54" => '&#37116;',
	"\xDC55" => '&#37128;',
	"\xDC56" => '&#37113;',
	"\xDC57" => '&#37115;',
	"\xDC58" => '&#37121;',
	"\xDC59" => '&#37120;',
	"\xDC5A" => '&#37127;',
	"\xDC5B" => '&#37125;',
	"\xDC5C" => '&#37123;',
	"\xDC5D" => '&#37217;',
	"\xDC5E" => '&#37220;',
	"\xDC5F" => '&#37215;',
	"\xDC60" => '&#37218;',
	"\xDC61" => '&#37216;',
	"\xDC62" => '&#37377;',
	"\xDC63" => '&#37386;',
	"\xDC64" => '&#37413;',
	"\xDC65" => '&#37379;',
	"\xDC66" => '&#37402;',
	"\xDC67" => '&#37414;',
	"\xDC68" => '&#37391;',
	"\xDC69" => '&#37388;',
	"\xDC6A" => '&#37376;',
	"\xDC6B" => '&#37394;',
	"\xDC6C" => '&#37375;',
	"\xDC6D" => '&#37373;',
	"\xDC6E" => '&#37382;',
	"\xDC6F" => '&#37380;',
	"\xDC70" => '&#37415;',
	"\xDC71" => '&#37378;',
	"\xDC72" => '&#37404;',
	"\xDC73" => '&#37412;',
	"\xDC74" => '&#37401;',
	"\xDC75" => '&#37399;',
	"\xDC76" => '&#37381;',
	"\xDC77" => '&#37398;',
	"\xDC78" => '&#38267;',
	"\xDC79" => '&#38285;',
	"\xDC7A" => '&#38284;',
	"\xDC7B" => '&#38288;',
	"\xDC7C" => '&#38535;',
	"\xDC7D" => '&#38526;',
	"\xDC7E" => '&#38536;',
	"\xDCA1" => '&#38537;',
	"\xDCA2" => '&#38531;',
	"\xDCA3" => '&#38528;',
	"\xDCA4" => '&#38594;',
	"\xDCA5" => '&#38600;',
	"\xDCA6" => '&#38595;',
	"\xDCA7" => '&#38641;',
	"\xDCA8" => '&#38640;',
	"\xDCA9" => '&#38764;',
	"\xDCAA" => '&#38768;',
	"\xDCAB" => '&#38766;',
	"\xDCAC" => '&#38919;',
	"\xDCAD" => '&#39081;',
	"\xDCAE" => '&#39147;',
	"\xDCAF" => '&#40166;',
	"\xDCB0" => '&#40697;',
	"\xDCB1" => '&#20099;',
	"\xDCB2" => '&#20100;',
	"\xDCB3" => '&#20150;',
	"\xDCB4" => '&#20669;',
	"\xDCB5" => '&#20671;',
	"\xDCB6" => '&#20678;',
	"\xDCB7" => '&#20654;',
	"\xDCB8" => '&#20676;',
	"\xDCB9" => '&#20682;',
	"\xDCBA" => '&#20660;',
	"\xDCBB" => '&#20680;',
	"\xDCBC" => '&#20674;',
	"\xDCBD" => '&#20656;',
	"\xDCBE" => '&#20673;',
	"\xDCBF" => '&#20666;',
	"\xDCC0" => '&#20657;',
	"\xDCC1" => '&#20683;',
	"\xDCC2" => '&#20681;',
	"\xDCC3" => '&#20662;',
	"\xDCC4" => '&#20664;',
	"\xDCC5" => '&#20951;',
	"\xDCC6" => '&#21114;',
	"\xDCC7" => '&#21112;',
	"\xDCC8" => '&#21115;',
	"\xDCC9" => '&#21116;',
	"\xDCCA" => '&#21955;',
	"\xDCCB" => '&#21979;',
	"\xDCCC" => '&#21964;',
	"\xDCCD" => '&#21968;',
	"\xDCCE" => '&#21963;',
	"\xDCCF" => '&#21962;',
	"\xDCD0" => '&#21981;',
	"\xDCD1" => '&#21952;',
	"\xDCD2" => '&#21972;',
	"\xDCD3" => '&#21956;',
	"\xDCD4" => '&#21993;',
	"\xDCD5" => '&#21951;',
	"\xDCD6" => '&#21970;',
	"\xDCD7" => '&#21901;',
	"\xDCD8" => '&#21967;',
	"\xDCD9" => '&#21973;',
	"\xDCDA" => '&#21986;',
	"\xDCDB" => '&#21974;',
	"\xDCDC" => '&#21960;',
	"\xDCDD" => '&#22002;',
	"\xDCDE" => '&#21965;',
	"\xDCDF" => '&#21977;',
	"\xDCE0" => '&#21954;',
	"\xDCE1" => '&#22292;',
	"\xDCE2" => '&#22611;',
	"\xDCE3" => '&#22632;',
	"\xDCE4" => '&#22628;',
	"\xDCE5" => '&#22607;',
	"\xDCE6" => '&#22605;',
	"\xDCE7" => '&#22601;',
	"\xDCE8" => '&#22639;',
	"\xDCE9" => '&#22613;',
	"\xDCEA" => '&#22606;',
	"\xDCEB" => '&#22621;',
	"\xDCEC" => '&#22617;',
	"\xDCED" => '&#22629;',
	"\xDCEE" => '&#22619;',
	"\xDCEF" => '&#22589;',
	"\xDCF0" => '&#22627;',
	"\xDCF1" => '&#22641;',
	"\xDCF2" => '&#22780;',
	"\xDCF3" => '&#23239;',
	"\xDCF4" => '&#23236;',
	"\xDCF5" => '&#23243;',
	"\xDCF6" => '&#23226;',
	"\xDCF7" => '&#23224;',
	"\xDCF8" => '&#23217;',
	"\xDCF9" => '&#23221;',
	"\xDCFA" => '&#23216;',
	"\xDCFB" => '&#23231;',
	"\xDCFC" => '&#23240;',
	"\xDCFD" => '&#23227;',
	"\xDCFE" => '&#23238;',
	"\xDD40" => '&#23223;',
	"\xDD41" => '&#23232;',
	"\xDD42" => '&#23242;',
	"\xDD43" => '&#23220;',
	"\xDD44" => '&#23222;',
	"\xDD45" => '&#23245;',
	"\xDD46" => '&#23225;',
	"\xDD47" => '&#23184;',
	"\xDD48" => '&#23510;',
	"\xDD49" => '&#23512;',
	"\xDD4A" => '&#23513;',
	"\xDD4B" => '&#23583;',
	"\xDD4C" => '&#23603;',
	"\xDD4D" => '&#23921;',
	"\xDD4E" => '&#23907;',
	"\xDD4F" => '&#23882;',
	"\xDD50" => '&#23909;',
	"\xDD51" => '&#23922;',
	"\xDD52" => '&#23916;',
	"\xDD53" => '&#23902;',
	"\xDD54" => '&#23912;',
	"\xDD55" => '&#23911;',
	"\xDD56" => '&#23906;',
	"\xDD57" => '&#24048;',
	"\xDD58" => '&#24143;',
	"\xDD59" => '&#24142;',
	"\xDD5A" => '&#24138;',
	"\xDD5B" => '&#24141;',
	"\xDD5C" => '&#24139;',
	"\xDD5D" => '&#24261;',
	"\xDD5E" => '&#24268;',
	"\xDD5F" => '&#24262;',
	"\xDD60" => '&#24267;',
	"\xDD61" => '&#24263;',
	"\xDD62" => '&#24384;',
	"\xDD63" => '&#24495;',
	"\xDD64" => '&#24493;',
	"\xDD65" => '&#24823;',
	"\xDD66" => '&#24905;',
	"\xDD67" => '&#24906;',
	"\xDD68" => '&#24875;',
	"\xDD69" => '&#24901;',
	"\xDD6A" => '&#24886;',
	"\xDD6B" => '&#24882;',
	"\xDD6C" => '&#24878;',
	"\xDD6D" => '&#24902;',
	"\xDD6E" => '&#24879;',
	"\xDD6F" => '&#24911;',
	"\xDD70" => '&#24873;',
	"\xDD71" => '&#24896;',
	"\xDD72" => '&#25120;',
	"\xDD73" => '&#37224;',
	"\xDD74" => '&#25123;',
	"\xDD75" => '&#25125;',
	"\xDD76" => '&#25124;',
	"\xDD77" => '&#25541;',
	"\xDD78" => '&#25585;',
	"\xDD79" => '&#25579;',
	"\xDD7A" => '&#25616;',
	"\xDD7B" => '&#25618;',
	"\xDD7C" => '&#25609;',
	"\xDD7D" => '&#25632;',
	"\xDD7E" => '&#25636;',
	"\xDDA1" => '&#25651;',
	"\xDDA2" => '&#25667;',
	"\xDDA3" => '&#25631;',
	"\xDDA4" => '&#25621;',
	"\xDDA5" => '&#25624;',
	"\xDDA6" => '&#25657;',
	"\xDDA7" => '&#25655;',
	"\xDDA8" => '&#25634;',
	"\xDDA9" => '&#25635;',
	"\xDDAA" => '&#25612;',
	"\xDDAB" => '&#25638;',
	"\xDDAC" => '&#25648;',
	"\xDDAD" => '&#25640;',
	"\xDDAE" => '&#25665;',
	"\xDDAF" => '&#25653;',
	"\xDDB0" => '&#25647;',
	"\xDDB1" => '&#25610;',
	"\xDDB2" => '&#25626;',
	"\xDDB3" => '&#25664;',
	"\xDDB4" => '&#25637;',
	"\xDDB5" => '&#25639;',
	"\xDDB6" => '&#25611;',
	"\xDDB7" => '&#25575;',
	"\xDDB8" => '&#25627;',
	"\xDDB9" => '&#25646;',
	"\xDDBA" => '&#25633;',
	"\xDDBB" => '&#25614;',
	"\xDDBC" => '&#25967;',
	"\xDDBD" => '&#26002;',
	"\xDDBE" => '&#26067;',
	"\xDDBF" => '&#26246;',
	"\xDDC0" => '&#26252;',
	"\xDDC1" => '&#26261;',
	"\xDDC2" => '&#26256;',
	"\xDDC3" => '&#26251;',
	"\xDDC4" => '&#26250;',
	"\xDDC5" => '&#26265;',
	"\xDDC6" => '&#26260;',
	"\xDDC7" => '&#26232;',
	"\xDDC8" => '&#26400;',
	"\xDDC9" => '&#26982;',
	"\xDDCA" => '&#26975;',
	"\xDDCB" => '&#26936;',
	"\xDDCC" => '&#26958;',
	"\xDDCD" => '&#26978;',
	"\xDDCE" => '&#26993;',
	"\xDDCF" => '&#26943;',
	"\xDDD0" => '&#26949;',
	"\xDDD1" => '&#26986;',
	"\xDDD2" => '&#26937;',
	"\xDDD3" => '&#26946;',
	"\xDDD4" => '&#26967;',
	"\xDDD5" => '&#26969;',
	"\xDDD6" => '&#27002;',
	"\xDDD7" => '&#26952;',
	"\xDDD8" => '&#26953;',
	"\xDDD9" => '&#26933;',
	"\xDDDA" => '&#26988;',
	"\xDDDB" => '&#26931;',
	"\xDDDC" => '&#26941;',
	"\xDDDD" => '&#26981;',
	"\xDDDE" => '&#26864;',
	"\xDDDF" => '&#27000;',
	"\xDDE0" => '&#26932;',
	"\xDDE1" => '&#26985;',
	"\xDDE2" => '&#26944;',
	"\xDDE3" => '&#26991;',
	"\xDDE4" => '&#26948;',
	"\xDDE5" => '&#26998;',
	"\xDDE6" => '&#26968;',
	"\xDDE7" => '&#26945;',
	"\xDDE8" => '&#26996;',
	"\xDDE9" => '&#26956;',
	"\xDDEA" => '&#26939;',
	"\xDDEB" => '&#26955;',
	"\xDDEC" => '&#26935;',
	"\xDDED" => '&#26972;',
	"\xDDEE" => '&#26959;',
	"\xDDEF" => '&#26961;',
	"\xDDF0" => '&#26930;',
	"\xDDF1" => '&#26962;',
	"\xDDF2" => '&#26927;',
	"\xDDF3" => '&#27003;',
	"\xDDF4" => '&#26940;',
	"\xDDF5" => '&#27462;',
	"\xDDF6" => '&#27461;',
	"\xDDF7" => '&#27459;',
	"\xDDF8" => '&#27458;',
	"\xDDF9" => '&#27464;',
	"\xDDFA" => '&#27457;',
	"\xDDFB" => '&#27547;',
	"\xDDFC" => '&#64013;',
	"\xDDFD" => '&#27643;',
	"\xDDFE" => '&#27644;',
	"\xDE40" => '&#27641;',
	"\xDE41" => '&#27639;',
	"\xDE42" => '&#27640;',
	"\xDE43" => '&#28315;',
	"\xDE44" => '&#28374;',
	"\xDE45" => '&#28360;',
	"\xDE46" => '&#28303;',
	"\xDE47" => '&#28352;',
	"\xDE48" => '&#28319;',
	"\xDE49" => '&#28307;',
	"\xDE4A" => '&#28308;',
	"\xDE4B" => '&#28320;',
	"\xDE4C" => '&#28337;',
	"\xDE4D" => '&#28345;',
	"\xDE4E" => '&#28358;',
	"\xDE4F" => '&#28370;',
	"\xDE50" => '&#28349;',
	"\xDE51" => '&#28353;',
	"\xDE52" => '&#28318;',
	"\xDE53" => '&#28361;',
	"\xDE54" => '&#28343;',
	"\xDE55" => '&#28336;',
	"\xDE56" => '&#28365;',
	"\xDE57" => '&#28326;',
	"\xDE58" => '&#28367;',
	"\xDE59" => '&#28338;',
	"\xDE5A" => '&#28350;',
	"\xDE5B" => '&#28355;',
	"\xDE5C" => '&#28380;',
	"\xDE5D" => '&#28376;',
	"\xDE5E" => '&#28313;',
	"\xDE5F" => '&#28306;',
	"\xDE60" => '&#28302;',
	"\xDE61" => '&#28301;',
	"\xDE62" => '&#28324;',
	"\xDE63" => '&#28321;',
	"\xDE64" => '&#28351;',
	"\xDE65" => '&#28339;',
	"\xDE66" => '&#28368;',
	"\xDE67" => '&#28362;',
	"\xDE68" => '&#28311;',
	"\xDE69" => '&#28334;',
	"\xDE6A" => '&#28323;',
	"\xDE6B" => '&#28999;',
	"\xDE6C" => '&#29012;',
	"\xDE6D" => '&#29010;',
	"\xDE6E" => '&#29027;',
	"\xDE6F" => '&#29024;',
	"\xDE70" => '&#28993;',
	"\xDE71" => '&#29021;',
	"\xDE72" => '&#29026;',
	"\xDE73" => '&#29042;',
	"\xDE74" => '&#29048;',
	"\xDE75" => '&#29034;',
	"\xDE76" => '&#29025;',
	"\xDE77" => '&#28994;',
	"\xDE78" => '&#29016;',
	"\xDE79" => '&#28995;',
	"\xDE7A" => '&#29003;',
	"\xDE7B" => '&#29040;',
	"\xDE7C" => '&#29023;',
	"\xDE7D" => '&#29008;',
	"\xDE7E" => '&#29011;',
	"\xDEA1" => '&#28996;',
	"\xDEA2" => '&#29005;',
	"\xDEA3" => '&#29018;',
	"\xDEA4" => '&#29263;',
	"\xDEA5" => '&#29325;',
	"\xDEA6" => '&#29324;',
	"\xDEA7" => '&#29329;',
	"\xDEA8" => '&#29328;',
	"\xDEA9" => '&#29326;',
	"\xDEAA" => '&#29500;',
	"\xDEAB" => '&#29506;',
	"\xDEAC" => '&#29499;',
	"\xDEAD" => '&#29498;',
	"\xDEAE" => '&#29504;',
	"\xDEAF" => '&#29514;',
	"\xDEB0" => '&#29513;',
	"\xDEB1" => '&#29764;',
	"\xDEB2" => '&#29770;',
	"\xDEB3" => '&#29771;',
	"\xDEB4" => '&#29778;',
	"\xDEB5" => '&#29777;',
	"\xDEB6" => '&#29783;',
	"\xDEB7" => '&#29760;',
	"\xDEB8" => '&#29775;',
	"\xDEB9" => '&#29776;',
	"\xDEBA" => '&#29774;',
	"\xDEBB" => '&#29762;',
	"\xDEBC" => '&#29766;',
	"\xDEBD" => '&#29773;',
	"\xDEBE" => '&#29780;',
	"\xDEBF" => '&#29921;',
	"\xDEC0" => '&#29951;',
	"\xDEC1" => '&#29950;',
	"\xDEC2" => '&#29949;',
	"\xDEC3" => '&#29981;',
	"\xDEC4" => '&#30073;',
	"\xDEC5" => '&#30071;',
	"\xDEC6" => '&#27011;',
	"\xDEC7" => '&#30191;',
	"\xDEC8" => '&#30223;',
	"\xDEC9" => '&#30211;',
	"\xDECA" => '&#30199;',
	"\xDECB" => '&#30206;',
	"\xDECC" => '&#30204;',
	"\xDECD" => '&#30201;',
	"\xDECE" => '&#30200;',
	"\xDECF" => '&#30224;',
	"\xDED0" => '&#30203;',
	"\xDED1" => '&#30198;',
	"\xDED2" => '&#30189;',
	"\xDED3" => '&#30197;',
	"\xDED4" => '&#30205;',
	"\xDED5" => '&#30361;',
	"\xDED6" => '&#30389;',
	"\xDED7" => '&#30429;',
	"\xDED8" => '&#30549;',
	"\xDED9" => '&#30559;',
	"\xDEDA" => '&#30560;',
	"\xDEDB" => '&#30546;',
	"\xDEDC" => '&#30550;',
	"\xDEDD" => '&#30554;',
	"\xDEDE" => '&#30569;',
	"\xDEDF" => '&#30567;',
	"\xDEE0" => '&#30548;',
	"\xDEE1" => '&#30553;',
	"\xDEE2" => '&#30573;',
	"\xDEE3" => '&#30688;',
	"\xDEE4" => '&#30855;',
	"\xDEE5" => '&#30874;',
	"\xDEE6" => '&#30868;',
	"\xDEE7" => '&#30863;',
	"\xDEE8" => '&#30852;',
	"\xDEE9" => '&#30869;',
	"\xDEEA" => '&#30853;',
	"\xDEEB" => '&#30854;',
	"\xDEEC" => '&#30881;',
	"\xDEED" => '&#30851;',
	"\xDEEE" => '&#30841;',
	"\xDEEF" => '&#30873;',
	"\xDEF0" => '&#30848;',
	"\xDEF1" => '&#30870;',
	"\xDEF2" => '&#30843;',
	"\xDEF3" => '&#31100;',
	"\xDEF4" => '&#31106;',
	"\xDEF5" => '&#31101;',
	"\xDEF6" => '&#31097;',
	"\xDEF7" => '&#31249;',
	"\xDEF8" => '&#31256;',
	"\xDEF9" => '&#31257;',
	"\xDEFA" => '&#31250;',
	"\xDEFB" => '&#31255;',
	"\xDEFC" => '&#31253;',
	"\xDEFD" => '&#31266;',
	"\xDEFE" => '&#31251;',
	"\xDF40" => '&#31259;',
	"\xDF41" => '&#31248;',
	"\xDF42" => '&#31395;',
	"\xDF43" => '&#31394;',
	"\xDF44" => '&#31390;',
	"\xDF45" => '&#31467;',
	"\xDF46" => '&#31590;',
	"\xDF47" => '&#31588;',
	"\xDF48" => '&#31597;',
	"\xDF49" => '&#31604;',
	"\xDF4A" => '&#31593;',
	"\xDF4B" => '&#31602;',
	"\xDF4C" => '&#31589;',
	"\xDF4D" => '&#31603;',
	"\xDF4E" => '&#31601;',
	"\xDF4F" => '&#31600;',
	"\xDF50" => '&#31585;',
	"\xDF51" => '&#31608;',
	"\xDF52" => '&#31606;',
	"\xDF53" => '&#31587;',
	"\xDF54" => '&#31922;',
	"\xDF55" => '&#31924;',
	"\xDF56" => '&#31919;',
	"\xDF57" => '&#32136;',
	"\xDF58" => '&#32134;',
	"\xDF59" => '&#32128;',
	"\xDF5A" => '&#32141;',
	"\xDF5B" => '&#32127;',
	"\xDF5C" => '&#32133;',
	"\xDF5D" => '&#32122;',
	"\xDF5E" => '&#32142;',
	"\xDF5F" => '&#32123;',
	"\xDF60" => '&#32131;',
	"\xDF61" => '&#32124;',
	"\xDF62" => '&#32140;',
	"\xDF63" => '&#32148;',
	"\xDF64" => '&#32132;',
	"\xDF65" => '&#32125;',
	"\xDF66" => '&#32146;',
	"\xDF67" => '&#32621;',
	"\xDF68" => '&#32619;',
	"\xDF69" => '&#32615;',
	"\xDF6A" => '&#32616;',
	"\xDF6B" => '&#32620;',
	"\xDF6C" => '&#32678;',
	"\xDF6D" => '&#32677;',
	"\xDF6E" => '&#32679;',
	"\xDF6F" => '&#32731;',
	"\xDF70" => '&#32732;',
	"\xDF71" => '&#32801;',
	"\xDF72" => '&#33124;',
	"\xDF73" => '&#33120;',
	"\xDF74" => '&#33143;',
	"\xDF75" => '&#33116;',
	"\xDF76" => '&#33129;',
	"\xDF77" => '&#33115;',
	"\xDF78" => '&#33122;',
	"\xDF79" => '&#33138;',
	"\xDF7A" => '&#26401;',
	"\xDF7B" => '&#33118;',
	"\xDF7C" => '&#33142;',
	"\xDF7D" => '&#33127;',
	"\xDF7E" => '&#33135;',
	"\xDFA1" => '&#33092;',
	"\xDFA2" => '&#33121;',
	"\xDFA3" => '&#33309;',
	"\xDFA4" => '&#33353;',
	"\xDFA5" => '&#33348;',
	"\xDFA6" => '&#33344;',
	"\xDFA7" => '&#33346;',
	"\xDFA8" => '&#33349;',
	"\xDFA9" => '&#34033;',
	"\xDFAA" => '&#33855;',
	"\xDFAB" => '&#33878;',
	"\xDFAC" => '&#33910;',
	"\xDFAD" => '&#33913;',
	"\xDFAE" => '&#33935;',
	"\xDFAF" => '&#33933;',
	"\xDFB0" => '&#33893;',
	"\xDFB1" => '&#33873;',
	"\xDFB2" => '&#33856;',
	"\xDFB3" => '&#33926;',
	"\xDFB4" => '&#33895;',
	"\xDFB5" => '&#33840;',
	"\xDFB6" => '&#33869;',
	"\xDFB7" => '&#33917;',
	"\xDFB8" => '&#33882;',
	"\xDFB9" => '&#33881;',
	"\xDFBA" => '&#33908;',
	"\xDFBB" => '&#33907;',
	"\xDFBC" => '&#33885;',
	"\xDFBD" => '&#34055;',
	"\xDFBE" => '&#33886;',
	"\xDFBF" => '&#33847;',
	"\xDFC0" => '&#33850;',
	"\xDFC1" => '&#33844;',
	"\xDFC2" => '&#33914;',
	"\xDFC3" => '&#33859;',
	"\xDFC4" => '&#33912;',
	"\xDFC5" => '&#33842;',
	"\xDFC6" => '&#33861;',
	"\xDFC7" => '&#33833;',
	"\xDFC8" => '&#33753;',
	"\xDFC9" => '&#33867;',
	"\xDFCA" => '&#33839;',
	"\xDFCB" => '&#33858;',
	"\xDFCC" => '&#33837;',
	"\xDFCD" => '&#33887;',
	"\xDFCE" => '&#33904;',
	"\xDFCF" => '&#33849;',
	"\xDFD0" => '&#33870;',
	"\xDFD1" => '&#33868;',
	"\xDFD2" => '&#33874;',
	"\xDFD3" => '&#33903;',
	"\xDFD4" => '&#33989;',
	"\xDFD5" => '&#33934;',
	"\xDFD6" => '&#33851;',
	"\xDFD7" => '&#33863;',
	"\xDFD8" => '&#33846;',
	"\xDFD9" => '&#33843;',
	"\xDFDA" => '&#33896;',
	"\xDFDB" => '&#33918;',
	"\xDFDC" => '&#33860;',
	"\xDFDD" => '&#33835;',
	"\xDFDE" => '&#33888;',
	"\xDFDF" => '&#33876;',
	"\xDFE0" => '&#33902;',
	"\xDFE1" => '&#33872;',
	"\xDFE2" => '&#34571;',
	"\xDFE3" => '&#34564;',
	"\xDFE4" => '&#34551;',
	"\xDFE5" => '&#34572;',
	"\xDFE6" => '&#34554;',
	"\xDFE7" => '&#34518;',
	"\xDFE8" => '&#34549;',
	"\xDFE9" => '&#34637;',
	"\xDFEA" => '&#34552;',
	"\xDFEB" => '&#34574;',
	"\xDFEC" => '&#34569;',
	"\xDFED" => '&#34561;',
	"\xDFEE" => '&#34550;',
	"\xDFEF" => '&#34573;',
	"\xDFF0" => '&#34565;',
	"\xDFF1" => '&#35030;',
	"\xDFF2" => '&#35019;',
	"\xDFF3" => '&#35021;',
	"\xDFF4" => '&#35022;',
	"\xDFF5" => '&#35038;',
	"\xDFF6" => '&#35035;',
	"\xDFF7" => '&#35034;',
	"\xDFF8" => '&#35020;',
	"\xDFF9" => '&#35024;',
	"\xDFFA" => '&#35205;',
	"\xDFFB" => '&#35227;',
	"\xDFFC" => '&#35295;',
	"\xDFFD" => '&#35301;',
	"\xDFFE" => '&#35300;',
	"\xE040" => '&#35297;',
	"\xE041" => '&#35296;',
	"\xE042" => '&#35298;',
	"\xE043" => '&#35292;',
	"\xE044" => '&#35302;',
	"\xE045" => '&#35446;',
	"\xE046" => '&#35462;',
	"\xE047" => '&#35455;',
	"\xE048" => '&#35425;',
	"\xE049" => '&#35391;',
	"\xE04A" => '&#35447;',
	"\xE04B" => '&#35458;',
	"\xE04C" => '&#35460;',
	"\xE04D" => '&#35445;',
	"\xE04E" => '&#35459;',
	"\xE04F" => '&#35457;',
	"\xE050" => '&#35444;',
	"\xE051" => '&#35450;',
	"\xE052" => '&#35900;',
	"\xE053" => '&#35915;',
	"\xE054" => '&#35914;',
	"\xE055" => '&#35941;',
	"\xE056" => '&#35940;',
	"\xE057" => '&#35942;',
	"\xE058" => '&#35974;',
	"\xE059" => '&#35972;',
	"\xE05A" => '&#35973;',
	"\xE05B" => '&#36044;',
	"\xE05C" => '&#36200;',
	"\xE05D" => '&#36201;',
	"\xE05E" => '&#36241;',
	"\xE05F" => '&#36236;',
	"\xE060" => '&#36238;',
	"\xE061" => '&#36239;',
	"\xE062" => '&#36237;',
	"\xE063" => '&#36243;',
	"\xE064" => '&#36244;',
	"\xE065" => '&#36240;',
	"\xE066" => '&#36242;',
	"\xE067" => '&#36336;',
	"\xE068" => '&#36320;',
	"\xE069" => '&#36332;',
	"\xE06A" => '&#36337;',
	"\xE06B" => '&#36334;',
	"\xE06C" => '&#36304;',
	"\xE06D" => '&#36329;',
	"\xE06E" => '&#36323;',
	"\xE06F" => '&#36322;',
	"\xE070" => '&#36327;',
	"\xE071" => '&#36338;',
	"\xE072" => '&#36331;',
	"\xE073" => '&#36340;',
	"\xE074" => '&#36614;',
	"\xE075" => '&#36607;',
	"\xE076" => '&#36609;',
	"\xE077" => '&#36608;',
	"\xE078" => '&#36613;',
	"\xE079" => '&#36615;',
	"\xE07A" => '&#36616;',
	"\xE07B" => '&#36610;',
	"\xE07C" => '&#36619;',
	"\xE07D" => '&#36946;',
	"\xE07E" => '&#36927;',
	"\xE0A1" => '&#36932;',
	"\xE0A2" => '&#36937;',
	"\xE0A3" => '&#36925;',
	"\xE0A4" => '&#37136;',
	"\xE0A5" => '&#37133;',
	"\xE0A6" => '&#37135;',
	"\xE0A7" => '&#37137;',
	"\xE0A8" => '&#37142;',
	"\xE0A9" => '&#37140;',
	"\xE0AA" => '&#37131;',
	"\xE0AB" => '&#37134;',
	"\xE0AC" => '&#37230;',
	"\xE0AD" => '&#37231;',
	"\xE0AE" => '&#37448;',
	"\xE0AF" => '&#37458;',
	"\xE0B0" => '&#37424;',
	"\xE0B1" => '&#37434;',
	"\xE0B2" => '&#37478;',
	"\xE0B3" => '&#37427;',
	"\xE0B4" => '&#37477;',
	"\xE0B5" => '&#37470;',
	"\xE0B6" => '&#37507;',
	"\xE0B7" => '&#37422;',
	"\xE0B8" => '&#37450;',
	"\xE0B9" => '&#37446;',
	"\xE0BA" => '&#37485;',
	"\xE0BB" => '&#37484;',
	"\xE0BC" => '&#37455;',
	"\xE0BD" => '&#37472;',
	"\xE0BE" => '&#37479;',
	"\xE0BF" => '&#37487;',
	"\xE0C0" => '&#37430;',
	"\xE0C1" => '&#37473;',
	"\xE0C2" => '&#37488;',
	"\xE0C3" => '&#37425;',
	"\xE0C4" => '&#37460;',
	"\xE0C5" => '&#37475;',
	"\xE0C6" => '&#37456;',
	"\xE0C7" => '&#37490;',
	"\xE0C8" => '&#37454;',
	"\xE0C9" => '&#37459;',
	"\xE0CA" => '&#37452;',
	"\xE0CB" => '&#37462;',
	"\xE0CC" => '&#37426;',
	"\xE0CD" => '&#38303;',
	"\xE0CE" => '&#38300;',
	"\xE0CF" => '&#38302;',
	"\xE0D0" => '&#38299;',
	"\xE0D1" => '&#38546;',
	"\xE0D2" => '&#38547;',
	"\xE0D3" => '&#38545;',
	"\xE0D4" => '&#38551;',
	"\xE0D5" => '&#38606;',
	"\xE0D6" => '&#38650;',
	"\xE0D7" => '&#38653;',
	"\xE0D8" => '&#38648;',
	"\xE0D9" => '&#38645;',
	"\xE0DA" => '&#38771;',
	"\xE0DB" => '&#38775;',
	"\xE0DC" => '&#38776;',
	"\xE0DD" => '&#38770;',
	"\xE0DE" => '&#38927;',
	"\xE0DF" => '&#38925;',
	"\xE0E0" => '&#38926;',
	"\xE0E1" => '&#39084;',
	"\xE0E2" => '&#39158;',
	"\xE0E3" => '&#39161;',
	"\xE0E4" => '&#39343;',
	"\xE0E5" => '&#39346;',
	"\xE0E6" => '&#39344;',
	"\xE0E7" => '&#39349;',
	"\xE0E8" => '&#39597;',
	"\xE0E9" => '&#39595;',
	"\xE0EA" => '&#39771;',
	"\xE0EB" => '&#40170;',
	"\xE0EC" => '&#40173;',
	"\xE0ED" => '&#40167;',
	"\xE0EE" => '&#40576;',
	"\xE0EF" => '&#40701;',
	"\xE0F0" => '&#20710;',
	"\xE0F1" => '&#20692;',
	"\xE0F2" => '&#20695;',
	"\xE0F3" => '&#20712;',
	"\xE0F4" => '&#20723;',
	"\xE0F5" => '&#20699;',
	"\xE0F6" => '&#20714;',
	"\xE0F7" => '&#20701;',
	"\xE0F8" => '&#20708;',
	"\xE0F9" => '&#20691;',
	"\xE0FA" => '&#20716;',
	"\xE0FB" => '&#20720;',
	"\xE0FC" => '&#20719;',
	"\xE0FD" => '&#20707;',
	"\xE0FE" => '&#20704;',
	"\xE140" => '&#20952;',
	"\xE141" => '&#21120;',
	"\xE142" => '&#21121;',
	"\xE143" => '&#21225;',
	"\xE144" => '&#21227;',
	"\xE145" => '&#21296;',
	"\xE146" => '&#21420;',
	"\xE147" => '&#22055;',
	"\xE148" => '&#22037;',
	"\xE149" => '&#22028;',
	"\xE14A" => '&#22034;',
	"\xE14B" => '&#22012;',
	"\xE14C" => '&#22031;',
	"\xE14D" => '&#22044;',
	"\xE14E" => '&#22017;',
	"\xE14F" => '&#22035;',
	"\xE150" => '&#22018;',
	"\xE151" => '&#22010;',
	"\xE152" => '&#22045;',
	"\xE153" => '&#22020;',
	"\xE154" => '&#22015;',
	"\xE155" => '&#22009;',
	"\xE156" => '&#22665;',
	"\xE157" => '&#22652;',
	"\xE158" => '&#22672;',
	"\xE159" => '&#22680;',
	"\xE15A" => '&#22662;',
	"\xE15B" => '&#22657;',
	"\xE15C" => '&#22655;',
	"\xE15D" => '&#22644;',
	"\xE15E" => '&#22667;',
	"\xE15F" => '&#22650;',
	"\xE160" => '&#22663;',
	"\xE161" => '&#22673;',
	"\xE162" => '&#22670;',
	"\xE163" => '&#22646;',
	"\xE164" => '&#22658;',
	"\xE165" => '&#22664;',
	"\xE166" => '&#22651;',
	"\xE167" => '&#22676;',
	"\xE168" => '&#22671;',
	"\xE169" => '&#22782;',
	"\xE16A" => '&#22891;',
	"\xE16B" => '&#23260;',
	"\xE16C" => '&#23278;',
	"\xE16D" => '&#23269;',
	"\xE16E" => '&#23253;',
	"\xE16F" => '&#23274;',
	"\xE170" => '&#23258;',
	"\xE171" => '&#23277;',
	"\xE172" => '&#23275;',
	"\xE173" => '&#23283;',
	"\xE174" => '&#23266;',
	"\xE175" => '&#23264;',
	"\xE176" => '&#23259;',
	"\xE177" => '&#23276;',
	"\xE178" => '&#23262;',
	"\xE179" => '&#23261;',
	"\xE17A" => '&#23257;',
	"\xE17B" => '&#23272;',
	"\xE17C" => '&#23263;',
	"\xE17D" => '&#23415;',
	"\xE17E" => '&#23520;',
	"\xE1A1" => '&#23523;',
	"\xE1A2" => '&#23651;',
	"\xE1A3" => '&#23938;',
	"\xE1A4" => '&#23936;',
	"\xE1A5" => '&#23933;',
	"\xE1A6" => '&#23942;',
	"\xE1A7" => '&#23930;',
	"\xE1A8" => '&#23937;',
	"\xE1A9" => '&#23927;',
	"\xE1AA" => '&#23946;',
	"\xE1AB" => '&#23945;',
	"\xE1AC" => '&#23944;',
	"\xE1AD" => '&#23934;',
	"\xE1AE" => '&#23932;',
	"\xE1AF" => '&#23949;',
	"\xE1B0" => '&#23929;',
	"\xE1B1" => '&#23935;',
	"\xE1B2" => '&#24152;',
	"\xE1B3" => '&#24153;',
	"\xE1B4" => '&#24147;',
	"\xE1B5" => '&#24280;',
	"\xE1B6" => '&#24273;',
	"\xE1B7" => '&#24279;',
	"\xE1B8" => '&#24270;',
	"\xE1B9" => '&#24284;',
	"\xE1BA" => '&#24277;',
	"\xE1BB" => '&#24281;',
	"\xE1BC" => '&#24274;',
	"\xE1BD" => '&#24276;',
	"\xE1BE" => '&#24388;',
	"\xE1BF" => '&#24387;',
	"\xE1C0" => '&#24431;',
	"\xE1C1" => '&#24502;',
	"\xE1C2" => '&#24876;',
	"\xE1C3" => '&#24872;',
	"\xE1C4" => '&#24897;',
	"\xE1C5" => '&#24926;',
	"\xE1C6" => '&#24945;',
	"\xE1C7" => '&#24947;',
	"\xE1C8" => '&#24914;',
	"\xE1C9" => '&#24915;',
	"\xE1CA" => '&#24946;',
	"\xE1CB" => '&#24940;',
	"\xE1CC" => '&#24960;',
	"\xE1CD" => '&#24948;',
	"\xE1CE" => '&#24916;',
	"\xE1CF" => '&#24954;',
	"\xE1D0" => '&#24923;',
	"\xE1D1" => '&#24933;',
	"\xE1D2" => '&#24891;',
	"\xE1D3" => '&#24938;',
	"\xE1D4" => '&#24929;',
	"\xE1D5" => '&#24918;',
	"\xE1D6" => '&#25129;',
	"\xE1D7" => '&#25127;',
	"\xE1D8" => '&#25131;',
	"\xE1D9" => '&#25643;',
	"\xE1DA" => '&#25677;',
	"\xE1DB" => '&#25691;',
	"\xE1DC" => '&#25693;',
	"\xE1DD" => '&#25716;',
	"\xE1DE" => '&#25718;',
	"\xE1DF" => '&#25714;',
	"\xE1E0" => '&#25715;',
	"\xE1E1" => '&#25725;',
	"\xE1E2" => '&#25717;',
	"\xE1E3" => '&#25702;',
	"\xE1E4" => '&#25766;',
	"\xE1E5" => '&#25678;',
	"\xE1E6" => '&#25730;',
	"\xE1E7" => '&#25694;',
	"\xE1E8" => '&#25692;',
	"\xE1E9" => '&#25675;',
	"\xE1EA" => '&#25683;',
	"\xE1EB" => '&#25696;',
	"\xE1EC" => '&#25680;',
	"\xE1ED" => '&#25727;',
	"\xE1EE" => '&#25663;',
	"\xE1EF" => '&#25708;',
	"\xE1F0" => '&#25707;',
	"\xE1F1" => '&#25689;',
	"\xE1F2" => '&#25701;',
	"\xE1F3" => '&#25719;',
	"\xE1F4" => '&#25971;',
	"\xE1F5" => '&#26016;',
	"\xE1F6" => '&#26273;',
	"\xE1F7" => '&#26272;',
	"\xE1F8" => '&#26271;',
	"\xE1F9" => '&#26373;',
	"\xE1FA" => '&#26372;',
	"\xE1FB" => '&#26402;',
	"\xE1FC" => '&#27057;',
	"\xE1FD" => '&#27062;',
	"\xE1FE" => '&#27081;',
	"\xE240" => '&#27040;',
	"\xE241" => '&#27086;',
	"\xE242" => '&#27030;',
	"\xE243" => '&#27056;',
	"\xE244" => '&#27052;',
	"\xE245" => '&#27068;',
	"\xE246" => '&#27025;',
	"\xE247" => '&#27033;',
	"\xE248" => '&#27022;',
	"\xE249" => '&#27047;',
	"\xE24A" => '&#27021;',
	"\xE24B" => '&#27049;',
	"\xE24C" => '&#27070;',
	"\xE24D" => '&#27055;',
	"\xE24E" => '&#27071;',
	"\xE24F" => '&#27076;',
	"\xE250" => '&#27069;',
	"\xE251" => '&#27044;',
	"\xE252" => '&#27092;',
	"\xE253" => '&#27065;',
	"\xE254" => '&#27082;',
	"\xE255" => '&#27034;',
	"\xE256" => '&#27087;',
	"\xE257" => '&#27059;',
	"\xE258" => '&#27027;',
	"\xE259" => '&#27050;',
	"\xE25A" => '&#27041;',
	"\xE25B" => '&#27038;',
	"\xE25C" => '&#27097;',
	"\xE25D" => '&#27031;',
	"\xE25E" => '&#27024;',
	"\xE25F" => '&#27074;',
	"\xE260" => '&#27061;',
	"\xE261" => '&#27045;',
	"\xE262" => '&#27078;',
	"\xE263" => '&#27466;',
	"\xE264" => '&#27469;',
	"\xE265" => '&#27467;',
	"\xE266" => '&#27550;',
	"\xE267" => '&#27551;',
	"\xE268" => '&#27552;',
	"\xE269" => '&#27587;',
	"\xE26A" => '&#27588;',
	"\xE26B" => '&#27646;',
	"\xE26C" => '&#28366;',
	"\xE26D" => '&#28405;',
	"\xE26E" => '&#28401;',
	"\xE26F" => '&#28419;',
	"\xE270" => '&#28453;',
	"\xE271" => '&#28408;',
	"\xE272" => '&#28471;',
	"\xE273" => '&#28411;',
	"\xE274" => '&#28462;',
	"\xE275" => '&#28425;',
	"\xE276" => '&#28494;',
	"\xE277" => '&#28441;',
	"\xE278" => '&#28442;',
	"\xE279" => '&#28455;',
	"\xE27A" => '&#28440;',
	"\xE27B" => '&#28475;',
	"\xE27C" => '&#28434;',
	"\xE27D" => '&#28397;',
	"\xE27E" => '&#28426;',
	"\xE2A1" => '&#28470;',
	"\xE2A2" => '&#28531;',
	"\xE2A3" => '&#28409;',
	"\xE2A4" => '&#28398;',
	"\xE2A5" => '&#28461;',
	"\xE2A6" => '&#28480;',
	"\xE2A7" => '&#28464;',
	"\xE2A8" => '&#28476;',
	"\xE2A9" => '&#28469;',
	"\xE2AA" => '&#28395;',
	"\xE2AB" => '&#28423;',
	"\xE2AC" => '&#28430;',
	"\xE2AD" => '&#28483;',
	"\xE2AE" => '&#28421;',
	"\xE2AF" => '&#28413;',
	"\xE2B0" => '&#28406;',
	"\xE2B1" => '&#28473;',
	"\xE2B2" => '&#28444;',
	"\xE2B3" => '&#28412;',
	"\xE2B4" => '&#28474;',
	"\xE2B5" => '&#28447;',
	"\xE2B6" => '&#28429;',
	"\xE2B7" => '&#28446;',
	"\xE2B8" => '&#28424;',
	"\xE2B9" => '&#28449;',
	"\xE2BA" => '&#29063;',
	"\xE2BB" => '&#29072;',
	"\xE2BC" => '&#29065;',
	"\xE2BD" => '&#29056;',
	"\xE2BE" => '&#29061;',
	"\xE2BF" => '&#29058;',
	"\xE2C0" => '&#29071;',
	"\xE2C1" => '&#29051;',
	"\xE2C2" => '&#29062;',
	"\xE2C3" => '&#29057;',
	"\xE2C4" => '&#29079;',
	"\xE2C5" => '&#29252;',
	"\xE2C6" => '&#29267;',
	"\xE2C7" => '&#29335;',
	"\xE2C8" => '&#29333;',
	"\xE2C9" => '&#29331;',
	"\xE2CA" => '&#29507;',
	"\xE2CB" => '&#29517;',
	"\xE2CC" => '&#29521;',
	"\xE2CD" => '&#29516;',
	"\xE2CE" => '&#29794;',
	"\xE2CF" => '&#29811;',
	"\xE2D0" => '&#29809;',
	"\xE2D1" => '&#29813;',
	"\xE2D2" => '&#29810;',
	"\xE2D3" => '&#29799;',
	"\xE2D4" => '&#29806;',
	"\xE2D5" => '&#29952;',
	"\xE2D6" => '&#29954;',
	"\xE2D7" => '&#29955;',
	"\xE2D8" => '&#30077;',
	"\xE2D9" => '&#30096;',
	"\xE2DA" => '&#30230;',
	"\xE2DB" => '&#30216;',
	"\xE2DC" => '&#30220;',
	"\xE2DD" => '&#30229;',
	"\xE2DE" => '&#30225;',
	"\xE2DF" => '&#30218;',
	"\xE2E0" => '&#30228;',
	"\xE2E1" => '&#30392;',
	"\xE2E2" => '&#30593;',
	"\xE2E3" => '&#30588;',
	"\xE2E4" => '&#30597;',
	"\xE2E5" => '&#30594;',
	"\xE2E6" => '&#30574;',
	"\xE2E7" => '&#30592;',
	"\xE2E8" => '&#30575;',
	"\xE2E9" => '&#30590;',
	"\xE2EA" => '&#30595;',
	"\xE2EB" => '&#30898;',
	"\xE2EC" => '&#30890;',
	"\xE2ED" => '&#30900;',
	"\xE2EE" => '&#30893;',
	"\xE2EF" => '&#30888;',
	"\xE2F0" => '&#30846;',
	"\xE2F1" => '&#30891;',
	"\xE2F2" => '&#30878;',
	"\xE2F3" => '&#30885;',
	"\xE2F4" => '&#30880;',
	"\xE2F5" => '&#30892;',
	"\xE2F6" => '&#30882;',
	"\xE2F7" => '&#30884;',
	"\xE2F8" => '&#31128;',
	"\xE2F9" => '&#31114;',
	"\xE2FA" => '&#31115;',
	"\xE2FB" => '&#31126;',
	"\xE2FC" => '&#31125;',
	"\xE2FD" => '&#31124;',
	"\xE2FE" => '&#31123;',
	"\xE340" => '&#31127;',
	"\xE341" => '&#31112;',
	"\xE342" => '&#31122;',
	"\xE343" => '&#31120;',
	"\xE344" => '&#31275;',
	"\xE345" => '&#31306;',
	"\xE346" => '&#31280;',
	"\xE347" => '&#31279;',
	"\xE348" => '&#31272;',
	"\xE349" => '&#31270;',
	"\xE34A" => '&#31400;',
	"\xE34B" => '&#31403;',
	"\xE34C" => '&#31404;',
	"\xE34D" => '&#31470;',
	"\xE34E" => '&#31624;',
	"\xE34F" => '&#31644;',
	"\xE350" => '&#31626;',
	"\xE351" => '&#31633;',
	"\xE352" => '&#31632;',
	"\xE353" => '&#31638;',
	"\xE354" => '&#31629;',
	"\xE355" => '&#31628;',
	"\xE356" => '&#31643;',
	"\xE357" => '&#31630;',
	"\xE358" => '&#31621;',
	"\xE359" => '&#31640;',
	"\xE35A" => '&#21124;',
	"\xE35B" => '&#31641;',
	"\xE35C" => '&#31652;',
	"\xE35D" => '&#31618;',
	"\xE35E" => '&#31931;',
	"\xE35F" => '&#31935;',
	"\xE360" => '&#31932;',
	"\xE361" => '&#31930;',
	"\xE362" => '&#32167;',
	"\xE363" => '&#32183;',
	"\xE364" => '&#32194;',
	"\xE365" => '&#32163;',
	"\xE366" => '&#32170;',
	"\xE367" => '&#32193;',
	"\xE368" => '&#32192;',
	"\xE369" => '&#32197;',
	"\xE36A" => '&#32157;',
	"\xE36B" => '&#32206;',
	"\xE36C" => '&#32196;',
	"\xE36D" => '&#32198;',
	"\xE36E" => '&#32203;',
	"\xE36F" => '&#32204;',
	"\xE370" => '&#32175;',
	"\xE371" => '&#32185;',
	"\xE372" => '&#32150;',
	"\xE373" => '&#32188;',
	"\xE374" => '&#32159;',
	"\xE375" => '&#32166;',
	"\xE376" => '&#32174;',
	"\xE377" => '&#32169;',
	"\xE378" => '&#32161;',
	"\xE379" => '&#32201;',
	"\xE37A" => '&#32627;',
	"\xE37B" => '&#32738;',
	"\xE37C" => '&#32739;',
	"\xE37D" => '&#32741;',
	"\xE37E" => '&#32734;',
	"\xE3A1" => '&#32804;',
	"\xE3A2" => '&#32861;',
	"\xE3A3" => '&#32860;',
	"\xE3A4" => '&#33161;',
	"\xE3A5" => '&#33158;',
	"\xE3A6" => '&#33155;',
	"\xE3A7" => '&#33159;',
	"\xE3A8" => '&#33165;',
	"\xE3A9" => '&#33164;',
	"\xE3AA" => '&#33163;',
	"\xE3AB" => '&#33301;',
	"\xE3AC" => '&#33943;',
	"\xE3AD" => '&#33956;',
	"\xE3AE" => '&#33953;',
	"\xE3AF" => '&#33951;',
	"\xE3B0" => '&#33978;',
	"\xE3B1" => '&#33998;',
	"\xE3B2" => '&#33986;',
	"\xE3B3" => '&#33964;',
	"\xE3B4" => '&#33966;',
	"\xE3B5" => '&#33963;',
	"\xE3B6" => '&#33977;',
	"\xE3B7" => '&#33972;',
	"\xE3B8" => '&#33985;',
	"\xE3B9" => '&#33997;',
	"\xE3BA" => '&#33962;',
	"\xE3BB" => '&#33946;',
	"\xE3BC" => '&#33969;',
	"\xE3BD" => '&#34000;',
	"\xE3BE" => '&#33949;',
	"\xE3BF" => '&#33959;',
	"\xE3C0" => '&#33979;',
	"\xE3C1" => '&#33954;',
	"\xE3C2" => '&#33940;',
	"\xE3C3" => '&#33991;',
	"\xE3C4" => '&#33996;',
	"\xE3C5" => '&#33947;',
	"\xE3C6" => '&#33961;',
	"\xE3C7" => '&#33967;',
	"\xE3C8" => '&#33960;',
	"\xE3C9" => '&#34006;',
	"\xE3CA" => '&#33944;',
	"\xE3CB" => '&#33974;',
	"\xE3CC" => '&#33999;',
	"\xE3CD" => '&#33952;',
	"\xE3CE" => '&#34007;',
	"\xE3CF" => '&#34004;',
	"\xE3D0" => '&#34002;',
	"\xE3D1" => '&#34011;',
	"\xE3D2" => '&#33968;',
	"\xE3D3" => '&#33937;',
	"\xE3D4" => '&#34401;',
	"\xE3D5" => '&#34611;',
	"\xE3D6" => '&#34595;',
	"\xE3D7" => '&#34600;',
	"\xE3D8" => '&#34667;',
	"\xE3D9" => '&#34624;',
	"\xE3DA" => '&#34606;',
	"\xE3DB" => '&#34590;',
	"\xE3DC" => '&#34593;',
	"\xE3DD" => '&#34585;',
	"\xE3DE" => '&#34587;',
	"\xE3DF" => '&#34627;',
	"\xE3E0" => '&#34604;',
	"\xE3E1" => '&#34625;',
	"\xE3E2" => '&#34622;',
	"\xE3E3" => '&#34630;',
	"\xE3E4" => '&#34592;',
	"\xE3E5" => '&#34610;',
	"\xE3E6" => '&#34602;',
	"\xE3E7" => '&#34605;',
	"\xE3E8" => '&#34620;',
	"\xE3E9" => '&#34578;',
	"\xE3EA" => '&#34618;',
	"\xE3EB" => '&#34609;',
	"\xE3EC" => '&#34613;',
	"\xE3ED" => '&#34626;',
	"\xE3EE" => '&#34598;',
	"\xE3EF" => '&#34599;',
	"\xE3F0" => '&#34616;',
	"\xE3F1" => '&#34596;',
	"\xE3F2" => '&#34586;',
	"\xE3F3" => '&#34608;',
	"\xE3F4" => '&#34577;',
	"\xE3F5" => '&#35063;',
	"\xE3F6" => '&#35047;',
	"\xE3F7" => '&#35057;',
	"\xE3F8" => '&#35058;',
	"\xE3F9" => '&#35066;',
	"\xE3FA" => '&#35070;',
	"\xE3FB" => '&#35054;',
	"\xE3FC" => '&#35068;',
	"\xE3FD" => '&#35062;',
	"\xE3FE" => '&#35067;',
	"\xE440" => '&#35056;',
	"\xE441" => '&#35052;',
	"\xE442" => '&#35051;',
	"\xE443" => '&#35229;',
	"\xE444" => '&#35233;',
	"\xE445" => '&#35231;',
	"\xE446" => '&#35230;',
	"\xE447" => '&#35305;',
	"\xE448" => '&#35307;',
	"\xE449" => '&#35304;',
	"\xE44A" => '&#35499;',
	"\xE44B" => '&#35481;',
	"\xE44C" => '&#35467;',
	"\xE44D" => '&#35474;',
	"\xE44E" => '&#35471;',
	"\xE44F" => '&#35478;',
	"\xE450" => '&#35901;',
	"\xE451" => '&#35944;',
	"\xE452" => '&#35945;',
	"\xE453" => '&#36053;',
	"\xE454" => '&#36047;',
	"\xE455" => '&#36055;',
	"\xE456" => '&#36246;',
	"\xE457" => '&#36361;',
	"\xE458" => '&#36354;',
	"\xE459" => '&#36351;',
	"\xE45A" => '&#36365;',
	"\xE45B" => '&#36349;',
	"\xE45C" => '&#36362;',
	"\xE45D" => '&#36355;',
	"\xE45E" => '&#36359;',
	"\xE45F" => '&#36358;',
	"\xE460" => '&#36357;',
	"\xE461" => '&#36350;',
	"\xE462" => '&#36352;',
	"\xE463" => '&#36356;',
	"\xE464" => '&#36624;',
	"\xE465" => '&#36625;',
	"\xE466" => '&#36622;',
	"\xE467" => '&#36621;',
	"\xE468" => '&#37155;',
	"\xE469" => '&#37148;',
	"\xE46A" => '&#37152;',
	"\xE46B" => '&#37154;',
	"\xE46C" => '&#37151;',
	"\xE46D" => '&#37149;',
	"\xE46E" => '&#37146;',
	"\xE46F" => '&#37156;',
	"\xE470" => '&#37153;',
	"\xE471" => '&#37147;',
	"\xE472" => '&#37242;',
	"\xE473" => '&#37234;',
	"\xE474" => '&#37241;',
	"\xE475" => '&#37235;',
	"\xE476" => '&#37541;',
	"\xE477" => '&#37540;',
	"\xE478" => '&#37494;',
	"\xE479" => '&#37531;',
	"\xE47A" => '&#37498;',
	"\xE47B" => '&#37536;',
	"\xE47C" => '&#37524;',
	"\xE47D" => '&#37546;',
	"\xE47E" => '&#37517;',
	"\xE4A1" => '&#37542;',
	"\xE4A2" => '&#37530;',
	"\xE4A3" => '&#37547;',
	"\xE4A4" => '&#37497;',
	"\xE4A5" => '&#37527;',
	"\xE4A6" => '&#37503;',
	"\xE4A7" => '&#37539;',
	"\xE4A8" => '&#37614;',
	"\xE4A9" => '&#37518;',
	"\xE4AA" => '&#37506;',
	"\xE4AB" => '&#37525;',
	"\xE4AC" => '&#37538;',
	"\xE4AD" => '&#37501;',
	"\xE4AE" => '&#37512;',
	"\xE4AF" => '&#37537;',
	"\xE4B0" => '&#37514;',
	"\xE4B1" => '&#37510;',
	"\xE4B2" => '&#37516;',
	"\xE4B3" => '&#37529;',
	"\xE4B4" => '&#37543;',
	"\xE4B5" => '&#37502;',
	"\xE4B6" => '&#37511;',
	"\xE4B7" => '&#37545;',
	"\xE4B8" => '&#37533;',
	"\xE4B9" => '&#37515;',
	"\xE4BA" => '&#37421;',
	"\xE4BB" => '&#38558;',
	"\xE4BC" => '&#38561;',
	"\xE4BD" => '&#38655;',
	"\xE4BE" => '&#38744;',
	"\xE4BF" => '&#38781;',
	"\xE4C0" => '&#38778;',
	"\xE4C1" => '&#38782;',
	"\xE4C2" => '&#38787;',
	"\xE4C3" => '&#38784;',
	"\xE4C4" => '&#38786;',
	"\xE4C5" => '&#38779;',
	"\xE4C6" => '&#38788;',
	"\xE4C7" => '&#38785;',
	"\xE4C8" => '&#38783;',
	"\xE4C9" => '&#38862;',
	"\xE4CA" => '&#38861;',
	"\xE4CB" => '&#38934;',
	"\xE4CC" => '&#39085;',
	"\xE4CD" => '&#39086;',
	"\xE4CE" => '&#39170;',
	"\xE4CF" => '&#39168;',
	"\xE4D0" => '&#39175;',
	"\xE4D1" => '&#39325;',
	"\xE4D2" => '&#39324;',
	"\xE4D3" => '&#39363;',
	"\xE4D4" => '&#39353;',
	"\xE4D5" => '&#39355;',
	"\xE4D6" => '&#39354;',
	"\xE4D7" => '&#39362;',
	"\xE4D8" => '&#39357;',
	"\xE4D9" => '&#39367;',
	"\xE4DA" => '&#39601;',
	"\xE4DB" => '&#39651;',
	"\xE4DC" => '&#39655;',
	"\xE4DD" => '&#39742;',
	"\xE4DE" => '&#39743;',
	"\xE4DF" => '&#39776;',
	"\xE4E0" => '&#39777;',
	"\xE4E1" => '&#39775;',
	"\xE4E2" => '&#40177;',
	"\xE4E3" => '&#40178;',
	"\xE4E4" => '&#40181;',
	"\xE4E5" => '&#40615;',
	"\xE4E6" => '&#20735;',
	"\xE4E7" => '&#20739;',
	"\xE4E8" => '&#20784;',
	"\xE4E9" => '&#20728;',
	"\xE4EA" => '&#20742;',
	"\xE4EB" => '&#20743;',
	"\xE4EC" => '&#20726;',
	"\xE4ED" => '&#20734;',
	"\xE4EE" => '&#20747;',
	"\xE4EF" => '&#20748;',
	"\xE4F0" => '&#20733;',
	"\xE4F1" => '&#20746;',
	"\xE4F2" => '&#21131;',
	"\xE4F3" => '&#21132;',
	"\xE4F4" => '&#21233;',
	"\xE4F5" => '&#21231;',
	"\xE4F6" => '&#22088;',
	"\xE4F7" => '&#22082;',
	"\xE4F8" => '&#22092;',
	"\xE4F9" => '&#22069;',
	"\xE4FA" => '&#22081;',
	"\xE4FB" => '&#22090;',
	"\xE4FC" => '&#22089;',
	"\xE4FD" => '&#22086;',
	"\xE4FE" => '&#22104;',
	"\xE540" => '&#22106;',
	"\xE541" => '&#22080;',
	"\xE542" => '&#22067;',
	"\xE543" => '&#22077;',
	"\xE544" => '&#22060;',
	"\xE545" => '&#22078;',
	"\xE546" => '&#22072;',
	"\xE547" => '&#22058;',
	"\xE548" => '&#22074;',
	"\xE549" => '&#22298;',
	"\xE54A" => '&#22699;',
	"\xE54B" => '&#22685;',
	"\xE54C" => '&#22705;',
	"\xE54D" => '&#22688;',
	"\xE54E" => '&#22691;',
	"\xE54F" => '&#22703;',
	"\xE550" => '&#22700;',
	"\xE551" => '&#22693;',
	"\xE552" => '&#22689;',
	"\xE553" => '&#22783;',
	"\xE554" => '&#23295;',
	"\xE555" => '&#23284;',
	"\xE556" => '&#23293;',
	"\xE557" => '&#23287;',
	"\xE558" => '&#23286;',
	"\xE559" => '&#23299;',
	"\xE55A" => '&#23288;',
	"\xE55B" => '&#23298;',
	"\xE55C" => '&#23289;',
	"\xE55D" => '&#23297;',
	"\xE55E" => '&#23303;',
	"\xE55F" => '&#23301;',
	"\xE560" => '&#23311;',
	"\xE561" => '&#23655;',
	"\xE562" => '&#23961;',
	"\xE563" => '&#23959;',
	"\xE564" => '&#23967;',
	"\xE565" => '&#23954;',
	"\xE566" => '&#23970;',
	"\xE567" => '&#23955;',
	"\xE568" => '&#23957;',
	"\xE569" => '&#23968;',
	"\xE56A" => '&#23964;',
	"\xE56B" => '&#23969;',
	"\xE56C" => '&#23962;',
	"\xE56D" => '&#23966;',
	"\xE56E" => '&#24169;',
	"\xE56F" => '&#24157;',
	"\xE570" => '&#24160;',
	"\xE571" => '&#24156;',
	"\xE572" => '&#32243;',
	"\xE573" => '&#24283;',
	"\xE574" => '&#24286;',
	"\xE575" => '&#24289;',
	"\xE576" => '&#24393;',
	"\xE577" => '&#24498;',
	"\xE578" => '&#24971;',
	"\xE579" => '&#24963;',
	"\xE57A" => '&#24953;',
	"\xE57B" => '&#25009;',
	"\xE57C" => '&#25008;',
	"\xE57D" => '&#24994;',
	"\xE57E" => '&#24969;',
	"\xE5A1" => '&#24987;',
	"\xE5A2" => '&#24979;',
	"\xE5A3" => '&#25007;',
	"\xE5A4" => '&#25005;',
	"\xE5A5" => '&#24991;',
	"\xE5A6" => '&#24978;',
	"\xE5A7" => '&#25002;',
	"\xE5A8" => '&#24993;',
	"\xE5A9" => '&#24973;',
	"\xE5AA" => '&#24934;',
	"\xE5AB" => '&#25011;',
	"\xE5AC" => '&#25133;',
	"\xE5AD" => '&#25710;',
	"\xE5AE" => '&#25712;',
	"\xE5AF" => '&#25750;',
	"\xE5B0" => '&#25760;',
	"\xE5B1" => '&#25733;',
	"\xE5B2" => '&#25751;',
	"\xE5B3" => '&#25756;',
	"\xE5B4" => '&#25743;',
	"\xE5B5" => '&#25739;',
	"\xE5B6" => '&#25738;',
	"\xE5B7" => '&#25740;',
	"\xE5B8" => '&#25763;',
	"\xE5B9" => '&#25759;',
	"\xE5BA" => '&#25704;',
	"\xE5BB" => '&#25777;',
	"\xE5BC" => '&#25752;',
	"\xE5BD" => '&#25974;',
	"\xE5BE" => '&#25978;',
	"\xE5BF" => '&#25977;',
	"\xE5C0" => '&#25979;',
	"\xE5C1" => '&#26034;',
	"\xE5C2" => '&#26035;',
	"\xE5C3" => '&#26293;',
	"\xE5C4" => '&#26288;',
	"\xE5C5" => '&#26281;',
	"\xE5C6" => '&#26290;',
	"\xE5C7" => '&#26295;',
	"\xE5C8" => '&#26282;',
	"\xE5C9" => '&#26287;',
	"\xE5CA" => '&#27136;',
	"\xE5CB" => '&#27142;',
	"\xE5CC" => '&#27159;',
	"\xE5CD" => '&#27109;',
	"\xE5CE" => '&#27128;',
	"\xE5CF" => '&#27157;',
	"\xE5D0" => '&#27121;',
	"\xE5D1" => '&#27108;',
	"\xE5D2" => '&#27168;',
	"\xE5D3" => '&#27135;',
	"\xE5D4" => '&#27116;',
	"\xE5D5" => '&#27106;',
	"\xE5D6" => '&#27163;',
	"\xE5D7" => '&#27165;',
	"\xE5D8" => '&#27134;',
	"\xE5D9" => '&#27175;',
	"\xE5DA" => '&#27122;',
	"\xE5DB" => '&#27118;',
	"\xE5DC" => '&#27156;',
	"\xE5DD" => '&#27127;',
	"\xE5DE" => '&#27111;',
	"\xE5DF" => '&#27200;',
	"\xE5E0" => '&#27144;',
	"\xE5E1" => '&#27110;',
	"\xE5E2" => '&#27131;',
	"\xE5E3" => '&#27149;',
	"\xE5E4" => '&#27132;',
	"\xE5E5" => '&#27115;',
	"\xE5E6" => '&#27145;',
	"\xE5E7" => '&#27140;',
	"\xE5E8" => '&#27160;',
	"\xE5E9" => '&#27173;',
	"\xE5EA" => '&#27151;',
	"\xE5EB" => '&#27126;',
	"\xE5EC" => '&#27174;',
	"\xE5ED" => '&#27143;',
	"\xE5EE" => '&#27124;',
	"\xE5EF" => '&#27158;',
	"\xE5F0" => '&#27473;',
	"\xE5F1" => '&#27557;',
	"\xE5F2" => '&#27555;',
	"\xE5F3" => '&#27554;',
	"\xE5F4" => '&#27558;',
	"\xE5F5" => '&#27649;',
	"\xE5F6" => '&#27648;',
	"\xE5F7" => '&#27647;',
	"\xE5F8" => '&#27650;',
	"\xE5F9" => '&#28481;',
	"\xE5FA" => '&#28454;',
	"\xE5FB" => '&#28542;',
	"\xE5FC" => '&#28551;',
	"\xE5FD" => '&#28614;',
	"\xE5FE" => '&#28562;',
	"\xE640" => '&#28557;',
	"\xE641" => '&#28553;',
	"\xE642" => '&#28556;',
	"\xE643" => '&#28514;',
	"\xE644" => '&#28495;',
	"\xE645" => '&#28549;',
	"\xE646" => '&#28506;',
	"\xE647" => '&#28566;',
	"\xE648" => '&#28534;',
	"\xE649" => '&#28524;',
	"\xE64A" => '&#28546;',
	"\xE64B" => '&#28501;',
	"\xE64C" => '&#28530;',
	"\xE64D" => '&#28498;',
	"\xE64E" => '&#28496;',
	"\xE64F" => '&#28503;',
	"\xE650" => '&#28564;',
	"\xE651" => '&#28563;',
	"\xE652" => '&#28509;',
	"\xE653" => '&#28416;',
	"\xE654" => '&#28513;',
	"\xE655" => '&#28523;',
	"\xE656" => '&#28541;',
	"\xE657" => '&#28519;',
	"\xE658" => '&#28560;',
	"\xE659" => '&#28499;',
	"\xE65A" => '&#28555;',
	"\xE65B" => '&#28521;',
	"\xE65C" => '&#28543;',
	"\xE65D" => '&#28565;',
	"\xE65E" => '&#28515;',
	"\xE65F" => '&#28535;',
	"\xE660" => '&#28522;',
	"\xE661" => '&#28539;',
	"\xE662" => '&#29106;',
	"\xE663" => '&#29103;',
	"\xE664" => '&#29083;',
	"\xE665" => '&#29104;',
	"\xE666" => '&#29088;',
	"\xE667" => '&#29082;',
	"\xE668" => '&#29097;',
	"\xE669" => '&#29109;',
	"\xE66A" => '&#29085;',
	"\xE66B" => '&#29093;',
	"\xE66C" => '&#29086;',
	"\xE66D" => '&#29092;',
	"\xE66E" => '&#29089;',
	"\xE66F" => '&#29098;',
	"\xE670" => '&#29084;',
	"\xE671" => '&#29095;',
	"\xE672" => '&#29107;',
	"\xE673" => '&#29336;',
	"\xE674" => '&#29338;',
	"\xE675" => '&#29528;',
	"\xE676" => '&#29522;',
	"\xE677" => '&#29534;',
	"\xE678" => '&#29535;',
	"\xE679" => '&#29536;',
	"\xE67A" => '&#29533;',
	"\xE67B" => '&#29531;',
	"\xE67C" => '&#29537;',
	"\xE67D" => '&#29530;',
	"\xE67E" => '&#29529;',
	"\xE6A1" => '&#29538;',
	"\xE6A2" => '&#29831;',
	"\xE6A3" => '&#29833;',
	"\xE6A4" => '&#29834;',
	"\xE6A5" => '&#29830;',
	"\xE6A6" => '&#29825;',
	"\xE6A7" => '&#29821;',
	"\xE6A8" => '&#29829;',
	"\xE6A9" => '&#29832;',
	"\xE6AA" => '&#29820;',
	"\xE6AB" => '&#29817;',
	"\xE6AC" => '&#29960;',
	"\xE6AD" => '&#29959;',
	"\xE6AE" => '&#30078;',
	"\xE6AF" => '&#30245;',
	"\xE6B0" => '&#30238;',
	"\xE6B1" => '&#30233;',
	"\xE6B2" => '&#30237;',
	"\xE6B3" => '&#30236;',
	"\xE6B4" => '&#30243;',
	"\xE6B5" => '&#30234;',
	"\xE6B6" => '&#30248;',
	"\xE6B7" => '&#30235;',
	"\xE6B8" => '&#30364;',
	"\xE6B9" => '&#30365;',
	"\xE6BA" => '&#30366;',
	"\xE6BB" => '&#30363;',
	"\xE6BC" => '&#30605;',
	"\xE6BD" => '&#30607;',
	"\xE6BE" => '&#30601;',
	"\xE6BF" => '&#30600;',
	"\xE6C0" => '&#30925;',
	"\xE6C1" => '&#30907;',
	"\xE6C2" => '&#30927;',
	"\xE6C3" => '&#30924;',
	"\xE6C4" => '&#30929;',
	"\xE6C5" => '&#30926;',
	"\xE6C6" => '&#30932;',
	"\xE6C7" => '&#30920;',
	"\xE6C8" => '&#30915;',
	"\xE6C9" => '&#30916;',
	"\xE6CA" => '&#30921;',
	"\xE6CB" => '&#31130;',
	"\xE6CC" => '&#31137;',
	"\xE6CD" => '&#31136;',
	"\xE6CE" => '&#31132;',
	"\xE6CF" => '&#31138;',
	"\xE6D0" => '&#31131;',
	"\xE6D1" => '&#27510;',
	"\xE6D2" => '&#31289;',
	"\xE6D3" => '&#31410;',
	"\xE6D4" => '&#31412;',
	"\xE6D5" => '&#31411;',
	"\xE6D6" => '&#31671;',
	"\xE6D7" => '&#31691;',
	"\xE6D8" => '&#31678;',
	"\xE6D9" => '&#31660;',
	"\xE6DA" => '&#31694;',
	"\xE6DB" => '&#31663;',
	"\xE6DC" => '&#31673;',
	"\xE6DD" => '&#31690;',
	"\xE6DE" => '&#31669;',
	"\xE6DF" => '&#31941;',
	"\xE6E0" => '&#31944;',
	"\xE6E1" => '&#31948;',
	"\xE6E2" => '&#31947;',
	"\xE6E3" => '&#32247;',
	"\xE6E4" => '&#32219;',
	"\xE6E5" => '&#32234;',
	"\xE6E6" => '&#32231;',
	"\xE6E7" => '&#32215;',
	"\xE6E8" => '&#32225;',
	"\xE6E9" => '&#32259;',
	"\xE6EA" => '&#32250;',
	"\xE6EB" => '&#32230;',
	"\xE6EC" => '&#32246;',
	"\xE6ED" => '&#32241;',
	"\xE6EE" => '&#32240;',
	"\xE6EF" => '&#32238;',
	"\xE6F0" => '&#32223;',
	"\xE6F1" => '&#32630;',
	"\xE6F2" => '&#32684;',
	"\xE6F3" => '&#32688;',
	"\xE6F4" => '&#32685;',
	"\xE6F5" => '&#32749;',
	"\xE6F6" => '&#32747;',
	"\xE6F7" => '&#32746;',
	"\xE6F8" => '&#32748;',
	"\xE6F9" => '&#32742;',
	"\xE6FA" => '&#32744;',
	"\xE6FB" => '&#32868;',
	"\xE6FC" => '&#32871;',
	"\xE6FD" => '&#33187;',
	"\xE6FE" => '&#33183;',
	"\xE740" => '&#33182;',
	"\xE741" => '&#33173;',
	"\xE742" => '&#33186;',
	"\xE743" => '&#33177;',
	"\xE744" => '&#33175;',
	"\xE745" => '&#33302;',
	"\xE746" => '&#33359;',
	"\xE747" => '&#33363;',
	"\xE748" => '&#33362;',
	"\xE749" => '&#33360;',
	"\xE74A" => '&#33358;',
	"\xE74B" => '&#33361;',
	"\xE74C" => '&#34084;',
	"\xE74D" => '&#34107;',
	"\xE74E" => '&#34063;',
	"\xE74F" => '&#34048;',
	"\xE750" => '&#34089;',
	"\xE751" => '&#34062;',
	"\xE752" => '&#34057;',
	"\xE753" => '&#34061;',
	"\xE754" => '&#34079;',
	"\xE755" => '&#34058;',
	"\xE756" => '&#34087;',
	"\xE757" => '&#34076;',
	"\xE758" => '&#34043;',
	"\xE759" => '&#34091;',
	"\xE75A" => '&#34042;',
	"\xE75B" => '&#34056;',
	"\xE75C" => '&#34060;',
	"\xE75D" => '&#34036;',
	"\xE75E" => '&#34090;',
	"\xE75F" => '&#34034;',
	"\xE760" => '&#34069;',
	"\xE761" => '&#34039;',
	"\xE762" => '&#34027;',
	"\xE763" => '&#34035;',
	"\xE764" => '&#34044;',
	"\xE765" => '&#34066;',
	"\xE766" => '&#34026;',
	"\xE767" => '&#34025;',
	"\xE768" => '&#34070;',
	"\xE769" => '&#34046;',
	"\xE76A" => '&#34088;',
	"\xE76B" => '&#34077;',
	"\xE76C" => '&#34094;',
	"\xE76D" => '&#34050;',
	"\xE76E" => '&#34045;',
	"\xE76F" => '&#34078;',
	"\xE770" => '&#34038;',
	"\xE771" => '&#34097;',
	"\xE772" => '&#34086;',
	"\xE773" => '&#34023;',
	"\xE774" => '&#34024;',
	"\xE775" => '&#34032;',
	"\xE776" => '&#34031;',
	"\xE777" => '&#34041;',
	"\xE778" => '&#34072;',
	"\xE779" => '&#34080;',
	"\xE77A" => '&#34096;',
	"\xE77B" => '&#34059;',
	"\xE77C" => '&#34073;',
	"\xE77D" => '&#34095;',
	"\xE77E" => '&#34402;',
	"\xE7A1" => '&#34646;',
	"\xE7A2" => '&#34659;',
	"\xE7A3" => '&#34660;',
	"\xE7A4" => '&#34679;',
	"\xE7A5" => '&#34785;',
	"\xE7A6" => '&#34675;',
	"\xE7A7" => '&#34648;',
	"\xE7A8" => '&#34644;',
	"\xE7A9" => '&#34651;',
	"\xE7AA" => '&#34642;',
	"\xE7AB" => '&#34657;',
	"\xE7AC" => '&#34650;',
	"\xE7AD" => '&#34641;',
	"\xE7AE" => '&#34654;',
	"\xE7AF" => '&#34669;',
	"\xE7B0" => '&#34666;',
	"\xE7B1" => '&#34640;',
	"\xE7B2" => '&#34638;',
	"\xE7B3" => '&#34655;',
	"\xE7B4" => '&#34653;',
	"\xE7B5" => '&#34671;',
	"\xE7B6" => '&#34668;',
	"\xE7B7" => '&#34682;',
	"\xE7B8" => '&#34670;',
	"\xE7B9" => '&#34652;',
	"\xE7BA" => '&#34661;',
	"\xE7BB" => '&#34639;',
	"\xE7BC" => '&#34683;',
	"\xE7BD" => '&#34677;',
	"\xE7BE" => '&#34658;',
	"\xE7BF" => '&#34663;',
	"\xE7C0" => '&#34665;',
	"\xE7C1" => '&#34906;',
	"\xE7C2" => '&#35077;',
	"\xE7C3" => '&#35084;',
	"\xE7C4" => '&#35092;',
	"\xE7C5" => '&#35083;',
	"\xE7C6" => '&#35095;',
	"\xE7C7" => '&#35096;',
	"\xE7C8" => '&#35097;',
	"\xE7C9" => '&#35078;',
	"\xE7CA" => '&#35094;',
	"\xE7CB" => '&#35089;',
	"\xE7CC" => '&#35086;',
	"\xE7CD" => '&#35081;',
	"\xE7CE" => '&#35234;',
	"\xE7CF" => '&#35236;',
	"\xE7D0" => '&#35235;',
	"\xE7D1" => '&#35309;',
	"\xE7D2" => '&#35312;',
	"\xE7D3" => '&#35308;',
	"\xE7D4" => '&#35535;',
	"\xE7D5" => '&#35526;',
	"\xE7D6" => '&#35512;',
	"\xE7D7" => '&#35539;',
	"\xE7D8" => '&#35537;',
	"\xE7D9" => '&#35540;',
	"\xE7DA" => '&#35541;',
	"\xE7DB" => '&#35515;',
	"\xE7DC" => '&#35543;',
	"\xE7DD" => '&#35518;',
	"\xE7DE" => '&#35520;',
	"\xE7DF" => '&#35525;',
	"\xE7E0" => '&#35544;',
	"\xE7E1" => '&#35523;',
	"\xE7E2" => '&#35514;',
	"\xE7E3" => '&#35517;',
	"\xE7E4" => '&#35545;',
	"\xE7E5" => '&#35902;',
	"\xE7E6" => '&#35917;',
	"\xE7E7" => '&#35983;',
	"\xE7E8" => '&#36069;',
	"\xE7E9" => '&#36063;',
	"\xE7EA" => '&#36057;',
	"\xE7EB" => '&#36072;',
	"\xE7EC" => '&#36058;',
	"\xE7ED" => '&#36061;',
	"\xE7EE" => '&#36071;',
	"\xE7EF" => '&#36256;',
	"\xE7F0" => '&#36252;',
	"\xE7F1" => '&#36257;',
	"\xE7F2" => '&#36251;',
	"\xE7F3" => '&#36384;',
	"\xE7F4" => '&#36387;',
	"\xE7F5" => '&#36389;',
	"\xE7F6" => '&#36388;',
	"\xE7F7" => '&#36398;',
	"\xE7F8" => '&#36373;',
	"\xE7F9" => '&#36379;',
	"\xE7FA" => '&#36374;',
	"\xE7FB" => '&#36369;',
	"\xE7FC" => '&#36377;',
	"\xE7FD" => '&#36390;',
	"\xE7FE" => '&#36391;',
	"\xE840" => '&#36372;',
	"\xE841" => '&#36370;',
	"\xE842" => '&#36376;',
	"\xE843" => '&#36371;',
	"\xE844" => '&#36380;',
	"\xE845" => '&#36375;',
	"\xE846" => '&#36378;',
	"\xE847" => '&#36652;',
	"\xE848" => '&#36644;',
	"\xE849" => '&#36632;',
	"\xE84A" => '&#36634;',
	"\xE84B" => '&#36640;',
	"\xE84C" => '&#36643;',
	"\xE84D" => '&#36630;',
	"\xE84E" => '&#36631;',
	"\xE84F" => '&#36979;',
	"\xE850" => '&#36976;',
	"\xE851" => '&#36975;',
	"\xE852" => '&#36967;',
	"\xE853" => '&#36971;',
	"\xE854" => '&#37167;',
	"\xE855" => '&#37163;',
	"\xE856" => '&#37161;',
	"\xE857" => '&#37162;',
	"\xE858" => '&#37170;',
	"\xE859" => '&#37158;',
	"\xE85A" => '&#37166;',
	"\xE85B" => '&#37253;',
	"\xE85C" => '&#37254;',
	"\xE85D" => '&#37258;',
	"\xE85E" => '&#37249;',
	"\xE85F" => '&#37250;',
	"\xE860" => '&#37252;',
	"\xE861" => '&#37248;',
	"\xE862" => '&#37584;',
	"\xE863" => '&#37571;',
	"\xE864" => '&#37572;',
	"\xE865" => '&#37568;',
	"\xE866" => '&#37593;',
	"\xE867" => '&#37558;',
	"\xE868" => '&#37583;',
	"\xE869" => '&#37617;',
	"\xE86A" => '&#37599;',
	"\xE86B" => '&#37592;',
	"\xE86C" => '&#37609;',
	"\xE86D" => '&#37591;',
	"\xE86E" => '&#37597;',
	"\xE86F" => '&#37580;',
	"\xE870" => '&#37615;',
	"\xE871" => '&#37570;',
	"\xE872" => '&#37608;',
	"\xE873" => '&#37578;',
	"\xE874" => '&#37576;',
	"\xE875" => '&#37582;',
	"\xE876" => '&#37606;',
	"\xE877" => '&#37581;',
	"\xE878" => '&#37589;',
	"\xE879" => '&#37577;',
	"\xE87A" => '&#37600;',
	"\xE87B" => '&#37598;',
	"\xE87C" => '&#37607;',
	"\xE87D" => '&#37585;',
	"\xE87E" => '&#37587;',
	"\xE8A1" => '&#37557;',
	"\xE8A2" => '&#37601;',
	"\xE8A3" => '&#37574;',
	"\xE8A4" => '&#37556;',
	"\xE8A5" => '&#38268;',
	"\xE8A6" => '&#38316;',
	"\xE8A7" => '&#38315;',
	"\xE8A8" => '&#38318;',
	"\xE8A9" => '&#38320;',
	"\xE8AA" => '&#38564;',
	"\xE8AB" => '&#38562;',
	"\xE8AC" => '&#38611;',
	"\xE8AD" => '&#38661;',
	"\xE8AE" => '&#38664;',
	"\xE8AF" => '&#38658;',
	"\xE8B0" => '&#38746;',
	"\xE8B1" => '&#38794;',
	"\xE8B2" => '&#38798;',
	"\xE8B3" => '&#38792;',
	"\xE8B4" => '&#38864;',
	"\xE8B5" => '&#38863;',
	"\xE8B6" => '&#38942;',
	"\xE8B7" => '&#38941;',
	"\xE8B8" => '&#38950;',
	"\xE8B9" => '&#38953;',
	"\xE8BA" => '&#38952;',
	"\xE8BB" => '&#38944;',
	"\xE8BC" => '&#38939;',
	"\xE8BD" => '&#38951;',
	"\xE8BE" => '&#39090;',
	"\xE8BF" => '&#39176;',
	"\xE8C0" => '&#39162;',
	"\xE8C1" => '&#39185;',
	"\xE8C2" => '&#39188;',
	"\xE8C3" => '&#39190;',
	"\xE8C4" => '&#39191;',
	"\xE8C5" => '&#39189;',
	"\xE8C6" => '&#39388;',
	"\xE8C7" => '&#39373;',
	"\xE8C8" => '&#39375;',
	"\xE8C9" => '&#39379;',
	"\xE8CA" => '&#39380;',
	"\xE8CB" => '&#39374;',
	"\xE8CC" => '&#39369;',
	"\xE8CD" => '&#39382;',
	"\xE8CE" => '&#39384;',
	"\xE8CF" => '&#39371;',
	"\xE8D0" => '&#39383;',
	"\xE8D1" => '&#39372;',
	"\xE8D2" => '&#39603;',
	"\xE8D3" => '&#39660;',
	"\xE8D4" => '&#39659;',
	"\xE8D5" => '&#39667;',
	"\xE8D6" => '&#39666;',
	"\xE8D7" => '&#39665;',
	"\xE8D8" => '&#39750;',
	"\xE8D9" => '&#39747;',
	"\xE8DA" => '&#39783;',
	"\xE8DB" => '&#39796;',
	"\xE8DC" => '&#39793;',
	"\xE8DD" => '&#39782;',
	"\xE8DE" => '&#39798;',
	"\xE8DF" => '&#39797;',
	"\xE8E0" => '&#39792;',
	"\xE8E1" => '&#39784;',
	"\xE8E2" => '&#39780;',
	"\xE8E3" => '&#39788;',
	"\xE8E4" => '&#40188;',
	"\xE8E5" => '&#40186;',
	"\xE8E6" => '&#40189;',
	"\xE8E7" => '&#40191;',
	"\xE8E8" => '&#40183;',
	"\xE8E9" => '&#40199;',
	"\xE8EA" => '&#40192;',
	"\xE8EB" => '&#40185;',
	"\xE8EC" => '&#40187;',
	"\xE8ED" => '&#40200;',
	"\xE8EE" => '&#40197;',
	"\xE8EF" => '&#40196;',
	"\xE8F0" => '&#40579;',
	"\xE8F1" => '&#40659;',
	"\xE8F2" => '&#40719;',
	"\xE8F3" => '&#40720;',
	"\xE8F4" => '&#20764;',
	"\xE8F5" => '&#20755;',
	"\xE8F6" => '&#20759;',
	"\xE8F7" => '&#20762;',
	"\xE8F8" => '&#20753;',
	"\xE8F9" => '&#20958;',
	"\xE8FA" => '&#21300;',
	"\xE8FB" => '&#21473;',
	"\xE8FC" => '&#22128;',
	"\xE8FD" => '&#22112;',
	"\xE8FE" => '&#22126;',
	"\xE940" => '&#22131;',
	"\xE941" => '&#22118;',
	"\xE942" => '&#22115;',
	"\xE943" => '&#22125;',
	"\xE944" => '&#22130;',
	"\xE945" => '&#22110;',
	"\xE946" => '&#22135;',
	"\xE947" => '&#22300;',
	"\xE948" => '&#22299;',
	"\xE949" => '&#22728;',
	"\xE94A" => '&#22717;',
	"\xE94B" => '&#22729;',
	"\xE94C" => '&#22719;',
	"\xE94D" => '&#22714;',
	"\xE94E" => '&#22722;',
	"\xE94F" => '&#22716;',
	"\xE950" => '&#22726;',
	"\xE951" => '&#23319;',
	"\xE952" => '&#23321;',
	"\xE953" => '&#23323;',
	"\xE954" => '&#23329;',
	"\xE955" => '&#23316;',
	"\xE956" => '&#23315;',
	"\xE957" => '&#23312;',
	"\xE958" => '&#23318;',
	"\xE959" => '&#23336;',
	"\xE95A" => '&#23322;',
	"\xE95B" => '&#23328;',
	"\xE95C" => '&#23326;',
	"\xE95D" => '&#23535;',
	"\xE95E" => '&#23980;',
	"\xE95F" => '&#23985;',
	"\xE960" => '&#23977;',
	"\xE961" => '&#23975;',
	"\xE962" => '&#23989;',
	"\xE963" => '&#23984;',
	"\xE964" => '&#23982;',
	"\xE965" => '&#23978;',
	"\xE966" => '&#23976;',
	"\xE967" => '&#23986;',
	"\xE968" => '&#23981;',
	"\xE969" => '&#23983;',
	"\xE96A" => '&#23988;',
	"\xE96B" => '&#24167;',
	"\xE96C" => '&#24168;',
	"\xE96D" => '&#24166;',
	"\xE96E" => '&#24175;',
	"\xE96F" => '&#24297;',
	"\xE970" => '&#24295;',
	"\xE971" => '&#24294;',
	"\xE972" => '&#24296;',
	"\xE973" => '&#24293;',
	"\xE974" => '&#24395;',
	"\xE975" => '&#24508;',
	"\xE976" => '&#24989;',
	"\xE977" => '&#25000;',
	"\xE978" => '&#24982;',
	"\xE979" => '&#25029;',
	"\xE97A" => '&#25012;',
	"\xE97B" => '&#25030;',
	"\xE97C" => '&#25025;',
	"\xE97D" => '&#25036;',
	"\xE97E" => '&#25018;',
	"\xE9A1" => '&#25023;',
	"\xE9A2" => '&#25016;',
	"\xE9A3" => '&#24972;',
	"\xE9A4" => '&#25815;',
	"\xE9A5" => '&#25814;',
	"\xE9A6" => '&#25808;',
	"\xE9A7" => '&#25807;',
	"\xE9A8" => '&#25801;',
	"\xE9A9" => '&#25789;',
	"\xE9AA" => '&#25737;',
	"\xE9AB" => '&#25795;',
	"\xE9AC" => '&#25819;',
	"\xE9AD" => '&#25843;',
	"\xE9AE" => '&#25817;',
	"\xE9AF" => '&#25907;',
	"\xE9B0" => '&#25983;',
	"\xE9B1" => '&#25980;',
	"\xE9B2" => '&#26018;',
	"\xE9B3" => '&#26312;',
	"\xE9B4" => '&#26302;',
	"\xE9B5" => '&#26304;',
	"\xE9B6" => '&#26314;',
	"\xE9B7" => '&#26315;',
	"\xE9B8" => '&#26319;',
	"\xE9B9" => '&#26301;',
	"\xE9BA" => '&#26299;',
	"\xE9BB" => '&#26298;',
	"\xE9BC" => '&#26316;',
	"\xE9BD" => '&#26403;',
	"\xE9BE" => '&#27188;',
	"\xE9BF" => '&#27238;',
	"\xE9C0" => '&#27209;',
	"\xE9C1" => '&#27239;',
	"\xE9C2" => '&#27186;',
	"\xE9C3" => '&#27240;',
	"\xE9C4" => '&#27198;',
	"\xE9C5" => '&#27229;',
	"\xE9C6" => '&#27245;',
	"\xE9C7" => '&#27254;',
	"\xE9C8" => '&#27227;',
	"\xE9C9" => '&#27217;',
	"\xE9CA" => '&#27176;',
	"\xE9CB" => '&#27226;',
	"\xE9CC" => '&#27195;',
	"\xE9CD" => '&#27199;',
	"\xE9CE" => '&#27201;',
	"\xE9CF" => '&#27242;',
	"\xE9D0" => '&#27236;',
	"\xE9D1" => '&#27216;',
	"\xE9D2" => '&#27215;',
	"\xE9D3" => '&#27220;',
	"\xE9D4" => '&#27247;',
	"\xE9D5" => '&#27241;',
	"\xE9D6" => '&#27232;',
	"\xE9D7" => '&#27196;',
	"\xE9D8" => '&#27230;',
	"\xE9D9" => '&#27222;',
	"\xE9DA" => '&#27221;',
	"\xE9DB" => '&#27213;',
	"\xE9DC" => '&#27214;',
	"\xE9DD" => '&#27206;',
	"\xE9DE" => '&#27477;',
	"\xE9DF" => '&#27476;',
	"\xE9E0" => '&#27478;',
	"\xE9E1" => '&#27559;',
	"\xE9E2" => '&#27562;',
	"\xE9E3" => '&#27563;',
	"\xE9E4" => '&#27592;',
	"\xE9E5" => '&#27591;',
	"\xE9E6" => '&#27652;',
	"\xE9E7" => '&#27651;',
	"\xE9E8" => '&#27654;',
	"\xE9E9" => '&#28589;',
	"\xE9EA" => '&#28619;',
	"\xE9EB" => '&#28579;',
	"\xE9EC" => '&#28615;',
	"\xE9ED" => '&#28604;',
	"\xE9EE" => '&#28622;',
	"\xE9EF" => '&#28616;',
	"\xE9F0" => '&#28510;',
	"\xE9F1" => '&#28612;',
	"\xE9F2" => '&#28605;',
	"\xE9F3" => '&#28574;',
	"\xE9F4" => '&#28618;',
	"\xE9F5" => '&#28584;',
	"\xE9F6" => '&#28676;',
	"\xE9F7" => '&#28581;',
	"\xE9F8" => '&#28590;',
	"\xE9F9" => '&#28602;',
	"\xE9FA" => '&#28588;',
	"\xE9FB" => '&#28586;',
	"\xE9FC" => '&#28623;',
	"\xE9FD" => '&#28607;',
	"\xE9FE" => '&#28600;',
	"\xEA40" => '&#28578;',
	"\xEA41" => '&#28617;',
	"\xEA42" => '&#28587;',
	"\xEA43" => '&#28621;',
	"\xEA44" => '&#28591;',
	"\xEA45" => '&#28594;',
	"\xEA46" => '&#28592;',
	"\xEA47" => '&#29125;',
	"\xEA48" => '&#29122;',
	"\xEA49" => '&#29119;',
	"\xEA4A" => '&#29112;',
	"\xEA4B" => '&#29142;',
	"\xEA4C" => '&#29120;',
	"\xEA4D" => '&#29121;',
	"\xEA4E" => '&#29131;',
	"\xEA4F" => '&#29140;',
	"\xEA50" => '&#29130;',
	"\xEA51" => '&#29127;',
	"\xEA52" => '&#29135;',
	"\xEA53" => '&#29117;',
	"\xEA54" => '&#29144;',
	"\xEA55" => '&#29116;',
	"\xEA56" => '&#29126;',
	"\xEA57" => '&#29146;',
	"\xEA58" => '&#29147;',
	"\xEA59" => '&#29341;',
	"\xEA5A" => '&#29342;',
	"\xEA5B" => '&#29545;',
	"\xEA5C" => '&#29542;',
	"\xEA5D" => '&#29543;',
	"\xEA5E" => '&#29548;',
	"\xEA5F" => '&#29541;',
	"\xEA60" => '&#29547;',
	"\xEA61" => '&#29546;',
	"\xEA62" => '&#29823;',
	"\xEA63" => '&#29850;',
	"\xEA64" => '&#29856;',
	"\xEA65" => '&#29844;',
	"\xEA66" => '&#29842;',
	"\xEA67" => '&#29845;',
	"\xEA68" => '&#29857;',
	"\xEA69" => '&#29963;',
	"\xEA6A" => '&#30080;',
	"\xEA6B" => '&#30255;',
	"\xEA6C" => '&#30253;',
	"\xEA6D" => '&#30257;',
	"\xEA6E" => '&#30269;',
	"\xEA6F" => '&#30259;',
	"\xEA70" => '&#30268;',
	"\xEA71" => '&#30261;',
	"\xEA72" => '&#30258;',
	"\xEA73" => '&#30256;',
	"\xEA74" => '&#30395;',
	"\xEA75" => '&#30438;',
	"\xEA76" => '&#30618;',
	"\xEA77" => '&#30621;',
	"\xEA78" => '&#30625;',
	"\xEA79" => '&#30620;',
	"\xEA7A" => '&#30619;',
	"\xEA7B" => '&#30626;',
	"\xEA7C" => '&#30627;',
	"\xEA7D" => '&#30613;',
	"\xEA7E" => '&#30617;',
	"\xEAA1" => '&#30615;',
	"\xEAA2" => '&#30941;',
	"\xEAA3" => '&#30953;',
	"\xEAA4" => '&#30949;',
	"\xEAA5" => '&#30954;',
	"\xEAA6" => '&#30942;',
	"\xEAA7" => '&#30947;',
	"\xEAA8" => '&#30939;',
	"\xEAA9" => '&#30945;',
	"\xEAAA" => '&#30946;',
	"\xEAAB" => '&#30957;',
	"\xEAAC" => '&#30943;',
	"\xEAAD" => '&#30944;',
	"\xEAAE" => '&#31140;',
	"\xEAAF" => '&#31300;',
	"\xEAB0" => '&#31304;',
	"\xEAB1" => '&#31303;',
	"\xEAB2" => '&#31414;',
	"\xEAB3" => '&#31416;',
	"\xEAB4" => '&#31413;',
	"\xEAB5" => '&#31409;',
	"\xEAB6" => '&#31415;',
	"\xEAB7" => '&#31710;',
	"\xEAB8" => '&#31715;',
	"\xEAB9" => '&#31719;',
	"\xEABA" => '&#31709;',
	"\xEABB" => '&#31701;',
	"\xEABC" => '&#31717;',
	"\xEABD" => '&#31706;',
	"\xEABE" => '&#31720;',
	"\xEABF" => '&#31737;',
	"\xEAC0" => '&#31700;',
	"\xEAC1" => '&#31722;',
	"\xEAC2" => '&#31714;',
	"\xEAC3" => '&#31708;',
	"\xEAC4" => '&#31723;',
	"\xEAC5" => '&#31704;',
	"\xEAC6" => '&#31711;',
	"\xEAC7" => '&#31954;',
	"\xEAC8" => '&#31956;',
	"\xEAC9" => '&#31959;',
	"\xEACA" => '&#31952;',
	"\xEACB" => '&#31953;',
	"\xEACC" => '&#32274;',
	"\xEACD" => '&#32289;',
	"\xEACE" => '&#32279;',
	"\xEACF" => '&#32268;',
	"\xEAD0" => '&#32287;',
	"\xEAD1" => '&#32288;',
	"\xEAD2" => '&#32275;',
	"\xEAD3" => '&#32270;',
	"\xEAD4" => '&#32284;',
	"\xEAD5" => '&#32277;',
	"\xEAD6" => '&#32282;',
	"\xEAD7" => '&#32290;',
	"\xEAD8" => '&#32267;',
	"\xEAD9" => '&#32271;',
	"\xEADA" => '&#32278;',
	"\xEADB" => '&#32269;',
	"\xEADC" => '&#32276;',
	"\xEADD" => '&#32293;',
	"\xEADE" => '&#32292;',
	"\xEADF" => '&#32579;',
	"\xEAE0" => '&#32635;',
	"\xEAE1" => '&#32636;',
	"\xEAE2" => '&#32634;',
	"\xEAE3" => '&#32689;',
	"\xEAE4" => '&#32751;',
	"\xEAE5" => '&#32810;',
	"\xEAE6" => '&#32809;',
	"\xEAE7" => '&#32876;',
	"\xEAE8" => '&#33201;',
	"\xEAE9" => '&#33190;',
	"\xEAEA" => '&#33198;',
	"\xEAEB" => '&#33209;',
	"\xEAEC" => '&#33205;',
	"\xEAED" => '&#33195;',
	"\xEAEE" => '&#33200;',
	"\xEAEF" => '&#33196;',
	"\xEAF0" => '&#33204;',
	"\xEAF1" => '&#33202;',
	"\xEAF2" => '&#33207;',
	"\xEAF3" => '&#33191;',
	"\xEAF4" => '&#33266;',
	"\xEAF5" => '&#33365;',
	"\xEAF6" => '&#33366;',
	"\xEAF7" => '&#33367;',
	"\xEAF8" => '&#34134;',
	"\xEAF9" => '&#34117;',
	"\xEAFA" => '&#34155;',
	"\xEAFB" => '&#34125;',
	"\xEAFC" => '&#34131;',
	"\xEAFD" => '&#34145;',
	"\xEAFE" => '&#34136;',
	"\xEB40" => '&#34112;',
	"\xEB41" => '&#34118;',
	"\xEB42" => '&#34148;',
	"\xEB43" => '&#34113;',
	"\xEB44" => '&#34146;',
	"\xEB45" => '&#34116;',
	"\xEB46" => '&#34129;',
	"\xEB47" => '&#34119;',
	"\xEB48" => '&#34147;',
	"\xEB49" => '&#34110;',
	"\xEB4A" => '&#34139;',
	"\xEB4B" => '&#34161;',
	"\xEB4C" => '&#34126;',
	"\xEB4D" => '&#34158;',
	"\xEB4E" => '&#34165;',
	"\xEB4F" => '&#34133;',
	"\xEB50" => '&#34151;',
	"\xEB51" => '&#34144;',
	"\xEB52" => '&#34188;',
	"\xEB53" => '&#34150;',
	"\xEB54" => '&#34141;',
	"\xEB55" => '&#34132;',
	"\xEB56" => '&#34149;',
	"\xEB57" => '&#34156;',
	"\xEB58" => '&#34403;',
	"\xEB59" => '&#34405;',
	"\xEB5A" => '&#34404;',
	"\xEB5B" => '&#34715;',
	"\xEB5C" => '&#34703;',
	"\xEB5D" => '&#34711;',
	"\xEB5E" => '&#34707;',
	"\xEB5F" => '&#34706;',
	"\xEB60" => '&#34696;',
	"\xEB61" => '&#34689;',
	"\xEB62" => '&#34710;',
	"\xEB63" => '&#34712;',
	"\xEB64" => '&#34681;',
	"\xEB65" => '&#34695;',
	"\xEB66" => '&#34723;',
	"\xEB67" => '&#34693;',
	"\xEB68" => '&#34704;',
	"\xEB69" => '&#34705;',
	"\xEB6A" => '&#34717;',
	"\xEB6B" => '&#34692;',
	"\xEB6C" => '&#34708;',
	"\xEB6D" => '&#34716;',
	"\xEB6E" => '&#34714;',
	"\xEB6F" => '&#34697;',
	"\xEB70" => '&#35102;',
	"\xEB71" => '&#35110;',
	"\xEB72" => '&#35120;',
	"\xEB73" => '&#35117;',
	"\xEB74" => '&#35118;',
	"\xEB75" => '&#35111;',
	"\xEB76" => '&#35121;',
	"\xEB77" => '&#35106;',
	"\xEB78" => '&#35113;',
	"\xEB79" => '&#35107;',
	"\xEB7A" => '&#35119;',
	"\xEB7B" => '&#35116;',
	"\xEB7C" => '&#35103;',
	"\xEB7D" => '&#35313;',
	"\xEB7E" => '&#35552;',
	"\xEBA1" => '&#35554;',
	"\xEBA2" => '&#35570;',
	"\xEBA3" => '&#35572;',
	"\xEBA4" => '&#35573;',
	"\xEBA5" => '&#35549;',
	"\xEBA6" => '&#35604;',
	"\xEBA7" => '&#35556;',
	"\xEBA8" => '&#35551;',
	"\xEBA9" => '&#35568;',
	"\xEBAA" => '&#35528;',
	"\xEBAB" => '&#35550;',
	"\xEBAC" => '&#35553;',
	"\xEBAD" => '&#35560;',
	"\xEBAE" => '&#35583;',
	"\xEBAF" => '&#35567;',
	"\xEBB0" => '&#35579;',
	"\xEBB1" => '&#35985;',
	"\xEBB2" => '&#35986;',
	"\xEBB3" => '&#35984;',
	"\xEBB4" => '&#36085;',
	"\xEBB5" => '&#36078;',
	"\xEBB6" => '&#36081;',
	"\xEBB7" => '&#36080;',
	"\xEBB8" => '&#36083;',
	"\xEBB9" => '&#36204;',
	"\xEBBA" => '&#36206;',
	"\xEBBB" => '&#36261;',
	"\xEBBC" => '&#36263;',
	"\xEBBD" => '&#36403;',
	"\xEBBE" => '&#36414;',
	"\xEBBF" => '&#36408;',
	"\xEBC0" => '&#36416;',
	"\xEBC1" => '&#36421;',
	"\xEBC2" => '&#36406;',
	"\xEBC3" => '&#36412;',
	"\xEBC4" => '&#36413;',
	"\xEBC5" => '&#36417;',
	"\xEBC6" => '&#36400;',
	"\xEBC7" => '&#36415;',
	"\xEBC8" => '&#36541;',
	"\xEBC9" => '&#36662;',
	"\xEBCA" => '&#36654;',
	"\xEBCB" => '&#36661;',
	"\xEBCC" => '&#36658;',
	"\xEBCD" => '&#36665;',
	"\xEBCE" => '&#36663;',
	"\xEBCF" => '&#36660;',
	"\xEBD0" => '&#36982;',
	"\xEBD1" => '&#36985;',
	"\xEBD2" => '&#36987;',
	"\xEBD3" => '&#36998;',
	"\xEBD4" => '&#37114;',
	"\xEBD5" => '&#37171;',
	"\xEBD6" => '&#37173;',
	"\xEBD7" => '&#37174;',
	"\xEBD8" => '&#37267;',
	"\xEBD9" => '&#37264;',
	"\xEBDA" => '&#37265;',
	"\xEBDB" => '&#37261;',
	"\xEBDC" => '&#37263;',
	"\xEBDD" => '&#37671;',
	"\xEBDE" => '&#37662;',
	"\xEBDF" => '&#37640;',
	"\xEBE0" => '&#37663;',
	"\xEBE1" => '&#37638;',
	"\xEBE2" => '&#37647;',
	"\xEBE3" => '&#37754;',
	"\xEBE4" => '&#37688;',
	"\xEBE5" => '&#37692;',
	"\xEBE6" => '&#37659;',
	"\xEBE7" => '&#37667;',
	"\xEBE8" => '&#37650;',
	"\xEBE9" => '&#37633;',
	"\xEBEA" => '&#37702;',
	"\xEBEB" => '&#37677;',
	"\xEBEC" => '&#37646;',
	"\xEBED" => '&#37645;',
	"\xEBEE" => '&#37579;',
	"\xEBEF" => '&#37661;',
	"\xEBF0" => '&#37626;',
	"\xEBF1" => '&#37669;',
	"\xEBF2" => '&#37651;',
	"\xEBF3" => '&#37625;',
	"\xEBF4" => '&#37623;',
	"\xEBF5" => '&#37684;',
	"\xEBF6" => '&#37634;',
	"\xEBF7" => '&#37668;',
	"\xEBF8" => '&#37631;',
	"\xEBF9" => '&#37673;',
	"\xEBFA" => '&#37689;',
	"\xEBFB" => '&#37685;',
	"\xEBFC" => '&#37674;',
	"\xEBFD" => '&#37652;',
	"\xEBFE" => '&#37644;',
	"\xEC40" => '&#37643;',
	"\xEC41" => '&#37630;',
	"\xEC42" => '&#37641;',
	"\xEC43" => '&#37632;',
	"\xEC44" => '&#37627;',
	"\xEC45" => '&#37654;',
	"\xEC46" => '&#38332;',
	"\xEC47" => '&#38349;',
	"\xEC48" => '&#38334;',
	"\xEC49" => '&#38329;',
	"\xEC4A" => '&#38330;',
	"\xEC4B" => '&#38326;',
	"\xEC4C" => '&#38335;',
	"\xEC4D" => '&#38325;',
	"\xEC4E" => '&#38333;',
	"\xEC4F" => '&#38569;',
	"\xEC50" => '&#38612;',
	"\xEC51" => '&#38667;',
	"\xEC52" => '&#38674;',
	"\xEC53" => '&#38672;',
	"\xEC54" => '&#38809;',
	"\xEC55" => '&#38807;',
	"\xEC56" => '&#38804;',
	"\xEC57" => '&#38896;',
	"\xEC58" => '&#38904;',
	"\xEC59" => '&#38965;',
	"\xEC5A" => '&#38959;',
	"\xEC5B" => '&#38962;',
	"\xEC5C" => '&#39204;',
	"\xEC5D" => '&#39199;',
	"\xEC5E" => '&#39207;',
	"\xEC5F" => '&#39209;',
	"\xEC60" => '&#39326;',
	"\xEC61" => '&#39406;',
	"\xEC62" => '&#39404;',
	"\xEC63" => '&#39397;',
	"\xEC64" => '&#39396;',
	"\xEC65" => '&#39408;',
	"\xEC66" => '&#39395;',
	"\xEC67" => '&#39402;',
	"\xEC68" => '&#39401;',
	"\xEC69" => '&#39399;',
	"\xEC6A" => '&#39609;',
	"\xEC6B" => '&#39615;',
	"\xEC6C" => '&#39604;',
	"\xEC6D" => '&#39611;',
	"\xEC6E" => '&#39670;',
	"\xEC6F" => '&#39674;',
	"\xEC70" => '&#39673;',
	"\xEC71" => '&#39671;',
	"\xEC72" => '&#39731;',
	"\xEC73" => '&#39808;',
	"\xEC74" => '&#39813;',
	"\xEC75" => '&#39815;',
	"\xEC76" => '&#39804;',
	"\xEC77" => '&#39806;',
	"\xEC78" => '&#39803;',
	"\xEC79" => '&#39810;',
	"\xEC7A" => '&#39827;',
	"\xEC7B" => '&#39826;',
	"\xEC7C" => '&#39824;',
	"\xEC7D" => '&#39802;',
	"\xEC7E" => '&#39829;',
	"\xECA1" => '&#39805;',
	"\xECA2" => '&#39816;',
	"\xECA3" => '&#40229;',
	"\xECA4" => '&#40215;',
	"\xECA5" => '&#40224;',
	"\xECA6" => '&#40222;',
	"\xECA7" => '&#40212;',
	"\xECA8" => '&#40233;',
	"\xECA9" => '&#40221;',
	"\xECAA" => '&#40216;',
	"\xECAB" => '&#40226;',
	"\xECAC" => '&#40208;',
	"\xECAD" => '&#40217;',
	"\xECAE" => '&#40223;',
	"\xECAF" => '&#40584;',
	"\xECB0" => '&#40582;',
	"\xECB1" => '&#40583;',
	"\xECB2" => '&#40622;',
	"\xECB3" => '&#40621;',
	"\xECB4" => '&#40661;',
	"\xECB5" => '&#40662;',
	"\xECB6" => '&#40698;',
	"\xECB7" => '&#40722;',
	"\xECB8" => '&#40765;',
	"\xECB9" => '&#20774;',
	"\xECBA" => '&#20773;',
	"\xECBB" => '&#20770;',
	"\xECBC" => '&#20772;',
	"\xECBD" => '&#20768;',
	"\xECBE" => '&#20777;',
	"\xECBF" => '&#21236;',
	"\xECC0" => '&#22163;',
	"\xECC1" => '&#22156;',
	"\xECC2" => '&#22157;',
	"\xECC3" => '&#22150;',
	"\xECC4" => '&#22148;',
	"\xECC5" => '&#22147;',
	"\xECC6" => '&#22142;',
	"\xECC7" => '&#22146;',
	"\xECC8" => '&#22143;',
	"\xECC9" => '&#22145;',
	"\xECCA" => '&#22742;',
	"\xECCB" => '&#22740;',
	"\xECCC" => '&#22735;',
	"\xECCD" => '&#22738;',
	"\xECCE" => '&#23341;',
	"\xECCF" => '&#23333;',
	"\xECD0" => '&#23346;',
	"\xECD1" => '&#23331;',
	"\xECD2" => '&#23340;',
	"\xECD3" => '&#23335;',
	"\xECD4" => '&#23334;',
	"\xECD5" => '&#23343;',
	"\xECD6" => '&#23342;',
	"\xECD7" => '&#23419;',
	"\xECD8" => '&#23537;',
	"\xECD9" => '&#23538;',
	"\xECDA" => '&#23991;',
	"\xECDB" => '&#24172;',
	"\xECDC" => '&#24170;',
	"\xECDD" => '&#24510;',
	"\xECDE" => '&#24507;',
	"\xECDF" => '&#25027;',
	"\xECE0" => '&#25013;',
	"\xECE1" => '&#25020;',
	"\xECE2" => '&#25063;',
	"\xECE3" => '&#25056;',
	"\xECE4" => '&#25061;',
	"\xECE5" => '&#25060;',
	"\xECE6" => '&#25064;',
	"\xECE7" => '&#25054;',
	"\xECE8" => '&#25839;',
	"\xECE9" => '&#25833;',
	"\xECEA" => '&#25827;',
	"\xECEB" => '&#25835;',
	"\xECEC" => '&#25828;',
	"\xECED" => '&#25832;',
	"\xECEE" => '&#25985;',
	"\xECEF" => '&#25984;',
	"\xECF0" => '&#26038;',
	"\xECF1" => '&#26074;',
	"\xECF2" => '&#26322;',
	"\xECF3" => '&#27277;',
	"\xECF4" => '&#27286;',
	"\xECF5" => '&#27265;',
	"\xECF6" => '&#27301;',
	"\xECF7" => '&#27273;',
	"\xECF8" => '&#27295;',
	"\xECF9" => '&#27291;',
	"\xECFA" => '&#27297;',
	"\xECFB" => '&#27294;',
	"\xECFC" => '&#27271;',
	"\xECFD" => '&#27283;',
	"\xECFE" => '&#27278;',
	"\xED40" => '&#27285;',
	"\xED41" => '&#27267;',
	"\xED42" => '&#27304;',
	"\xED43" => '&#27300;',
	"\xED44" => '&#27281;',
	"\xED45" => '&#27263;',
	"\xED46" => '&#27302;',
	"\xED47" => '&#27290;',
	"\xED48" => '&#27269;',
	"\xED49" => '&#27276;',
	"\xED4A" => '&#27282;',
	"\xED4B" => '&#27483;',
	"\xED4C" => '&#27565;',
	"\xED4D" => '&#27657;',
	"\xED4E" => '&#28620;',
	"\xED4F" => '&#28585;',
	"\xED50" => '&#28660;',
	"\xED51" => '&#28628;',
	"\xED52" => '&#28643;',
	"\xED53" => '&#28636;',
	"\xED54" => '&#28653;',
	"\xED55" => '&#28647;',
	"\xED56" => '&#28646;',
	"\xED57" => '&#28638;',
	"\xED58" => '&#28658;',
	"\xED59" => '&#28637;',
	"\xED5A" => '&#28642;',
	"\xED5B" => '&#28648;',
	"\xED5C" => '&#29153;',
	"\xED5D" => '&#29169;',
	"\xED5E" => '&#29160;',
	"\xED5F" => '&#29170;',
	"\xED60" => '&#29156;',
	"\xED61" => '&#29168;',
	"\xED62" => '&#29154;',
	"\xED63" => '&#29555;',
	"\xED64" => '&#29550;',
	"\xED65" => '&#29551;',
	"\xED66" => '&#29847;',
	"\xED67" => '&#29874;',
	"\xED68" => '&#29867;',
	"\xED69" => '&#29840;',
	"\xED6A" => '&#29866;',
	"\xED6B" => '&#29869;',
	"\xED6C" => '&#29873;',
	"\xED6D" => '&#29861;',
	"\xED6E" => '&#29871;',
	"\xED6F" => '&#29968;',
	"\xED70" => '&#29969;',
	"\xED71" => '&#29970;',
	"\xED72" => '&#29967;',
	"\xED73" => '&#30084;',
	"\xED74" => '&#30275;',
	"\xED75" => '&#30280;',
	"\xED76" => '&#30281;',
	"\xED77" => '&#30279;',
	"\xED78" => '&#30372;',
	"\xED79" => '&#30441;',
	"\xED7A" => '&#30645;',
	"\xED7B" => '&#30635;',
	"\xED7C" => '&#30642;',
	"\xED7D" => '&#30647;',
	"\xED7E" => '&#30646;',
	"\xEDA1" => '&#30644;',
	"\xEDA2" => '&#30641;',
	"\xEDA3" => '&#30632;',
	"\xEDA4" => '&#30704;',
	"\xEDA5" => '&#30963;',
	"\xEDA6" => '&#30973;',
	"\xEDA7" => '&#30978;',
	"\xEDA8" => '&#30971;',
	"\xEDA9" => '&#30972;',
	"\xEDAA" => '&#30962;',
	"\xEDAB" => '&#30981;',
	"\xEDAC" => '&#30969;',
	"\xEDAD" => '&#30974;',
	"\xEDAE" => '&#30980;',
	"\xEDAF" => '&#31147;',
	"\xEDB0" => '&#31144;',
	"\xEDB1" => '&#31324;',
	"\xEDB2" => '&#31323;',
	"\xEDB3" => '&#31318;',
	"\xEDB4" => '&#31320;',
	"\xEDB5" => '&#31316;',
	"\xEDB6" => '&#31322;',
	"\xEDB7" => '&#31422;',
	"\xEDB8" => '&#31424;',
	"\xEDB9" => '&#31425;',
	"\xEDBA" => '&#31749;',
	"\xEDBB" => '&#31759;',
	"\xEDBC" => '&#31730;',
	"\xEDBD" => '&#31744;',
	"\xEDBE" => '&#31743;',
	"\xEDBF" => '&#31739;',
	"\xEDC0" => '&#31758;',
	"\xEDC1" => '&#31732;',
	"\xEDC2" => '&#31755;',
	"\xEDC3" => '&#31731;',
	"\xEDC4" => '&#31746;',
	"\xEDC5" => '&#31753;',
	"\xEDC6" => '&#31747;',
	"\xEDC7" => '&#31745;',
	"\xEDC8" => '&#31736;',
	"\xEDC9" => '&#31741;',
	"\xEDCA" => '&#31750;',
	"\xEDCB" => '&#31728;',
	"\xEDCC" => '&#31729;',
	"\xEDCD" => '&#31760;',
	"\xEDCE" => '&#31754;',
	"\xEDCF" => '&#31976;',
	"\xEDD0" => '&#32301;',
	"\xEDD1" => '&#32316;',
	"\xEDD2" => '&#32322;',
	"\xEDD3" => '&#32307;',
	"\xEDD4" => '&#38984;',
	"\xEDD5" => '&#32312;',
	"\xEDD6" => '&#32298;',
	"\xEDD7" => '&#32329;',
	"\xEDD8" => '&#32320;',
	"\xEDD9" => '&#32327;',
	"\xEDDA" => '&#32297;',
	"\xEDDB" => '&#32332;',
	"\xEDDC" => '&#32304;',
	"\xEDDD" => '&#32315;',
	"\xEDDE" => '&#32310;',
	"\xEDDF" => '&#32324;',
	"\xEDE0" => '&#32314;',
	"\xEDE1" => '&#32581;',
	"\xEDE2" => '&#32639;',
	"\xEDE3" => '&#32638;',
	"\xEDE4" => '&#32637;',
	"\xEDE5" => '&#32756;',
	"\xEDE6" => '&#32754;',
	"\xEDE7" => '&#32812;',
	"\xEDE8" => '&#33211;',
	"\xEDE9" => '&#33220;',
	"\xEDEA" => '&#33228;',
	"\xEDEB" => '&#33226;',
	"\xEDEC" => '&#33221;',
	"\xEDED" => '&#33223;',
	"\xEDEE" => '&#33212;',
	"\xEDEF" => '&#33257;',
	"\xEDF0" => '&#33371;',
	"\xEDF1" => '&#33370;',
	"\xEDF2" => '&#33372;',
	"\xEDF3" => '&#34179;',
	"\xEDF4" => '&#34176;',
	"\xEDF5" => '&#34191;',
	"\xEDF6" => '&#34215;',
	"\xEDF7" => '&#34197;',
	"\xEDF8" => '&#34208;',
	"\xEDF9" => '&#34187;',
	"\xEDFA" => '&#34211;',
	"\xEDFB" => '&#34171;',
	"\xEDFC" => '&#34212;',
	"\xEDFD" => '&#34202;',
	"\xEDFE" => '&#34206;',
	"\xEE40" => '&#34167;',
	"\xEE41" => '&#34172;',
	"\xEE42" => '&#34185;',
	"\xEE43" => '&#34209;',
	"\xEE44" => '&#34170;',
	"\xEE45" => '&#34168;',
	"\xEE46" => '&#34135;',
	"\xEE47" => '&#34190;',
	"\xEE48" => '&#34198;',
	"\xEE49" => '&#34182;',
	"\xEE4A" => '&#34189;',
	"\xEE4B" => '&#34201;',
	"\xEE4C" => '&#34205;',
	"\xEE4D" => '&#34177;',
	"\xEE4E" => '&#34210;',
	"\xEE4F" => '&#34178;',
	"\xEE50" => '&#34184;',
	"\xEE51" => '&#34181;',
	"\xEE52" => '&#34169;',
	"\xEE53" => '&#34166;',
	"\xEE54" => '&#34200;',
	"\xEE55" => '&#34192;',
	"\xEE56" => '&#34207;',
	"\xEE57" => '&#34408;',
	"\xEE58" => '&#34750;',
	"\xEE59" => '&#34730;',
	"\xEE5A" => '&#34733;',
	"\xEE5B" => '&#34757;',
	"\xEE5C" => '&#34736;',
	"\xEE5D" => '&#34732;',
	"\xEE5E" => '&#34745;',
	"\xEE5F" => '&#34741;',
	"\xEE60" => '&#34748;',
	"\xEE61" => '&#34734;',
	"\xEE62" => '&#34761;',
	"\xEE63" => '&#34755;',
	"\xEE64" => '&#34754;',
	"\xEE65" => '&#34764;',
	"\xEE66" => '&#34743;',
	"\xEE67" => '&#34735;',
	"\xEE68" => '&#34756;',
	"\xEE69" => '&#34762;',
	"\xEE6A" => '&#34740;',
	"\xEE6B" => '&#34742;',
	"\xEE6C" => '&#34751;',
	"\xEE6D" => '&#34744;',
	"\xEE6E" => '&#34749;',
	"\xEE6F" => '&#34782;',
	"\xEE70" => '&#34738;',
	"\xEE71" => '&#35125;',
	"\xEE72" => '&#35123;',
	"\xEE73" => '&#35132;',
	"\xEE74" => '&#35134;',
	"\xEE75" => '&#35137;',
	"\xEE76" => '&#35154;',
	"\xEE77" => '&#35127;',
	"\xEE78" => '&#35138;',
	"\xEE79" => '&#35245;',
	"\xEE7A" => '&#35247;',
	"\xEE7B" => '&#35246;',
	"\xEE7C" => '&#35314;',
	"\xEE7D" => '&#35315;',
	"\xEE7E" => '&#35614;',
	"\xEEA1" => '&#35608;',
	"\xEEA2" => '&#35606;',
	"\xEEA3" => '&#35601;',
	"\xEEA4" => '&#35589;',
	"\xEEA5" => '&#35595;',
	"\xEEA6" => '&#35618;',
	"\xEEA7" => '&#35599;',
	"\xEEA8" => '&#35602;',
	"\xEEA9" => '&#35605;',
	"\xEEAA" => '&#35591;',
	"\xEEAB" => '&#35597;',
	"\xEEAC" => '&#35592;',
	"\xEEAD" => '&#35590;',
	"\xEEAE" => '&#35612;',
	"\xEEAF" => '&#35603;',
	"\xEEB0" => '&#35610;',
	"\xEEB1" => '&#35919;',
	"\xEEB2" => '&#35952;',
	"\xEEB3" => '&#35954;',
	"\xEEB4" => '&#35953;',
	"\xEEB5" => '&#35951;',
	"\xEEB6" => '&#35989;',
	"\xEEB7" => '&#35988;',
	"\xEEB8" => '&#36089;',
	"\xEEB9" => '&#36207;',
	"\xEEBA" => '&#36430;',
	"\xEEBB" => '&#36429;',
	"\xEEBC" => '&#36435;',
	"\xEEBD" => '&#36432;',
	"\xEEBE" => '&#36428;',
	"\xEEBF" => '&#36423;',
	"\xEEC0" => '&#36675;',
	"\xEEC1" => '&#36672;',
	"\xEEC2" => '&#36997;',
	"\xEEC3" => '&#36990;',
	"\xEEC4" => '&#37176;',
	"\xEEC5" => '&#37274;',
	"\xEEC6" => '&#37282;',
	"\xEEC7" => '&#37275;',
	"\xEEC8" => '&#37273;',
	"\xEEC9" => '&#37279;',
	"\xEECA" => '&#37281;',
	"\xEECB" => '&#37277;',
	"\xEECC" => '&#37280;',
	"\xEECD" => '&#37793;',
	"\xEECE" => '&#37763;',
	"\xEECF" => '&#37807;',
	"\xEED0" => '&#37732;',
	"\xEED1" => '&#37718;',
	"\xEED2" => '&#37703;',
	"\xEED3" => '&#37756;',
	"\xEED4" => '&#37720;',
	"\xEED5" => '&#37724;',
	"\xEED6" => '&#37750;',
	"\xEED7" => '&#37705;',
	"\xEED8" => '&#37712;',
	"\xEED9" => '&#37713;',
	"\xEEDA" => '&#37728;',
	"\xEEDB" => '&#37741;',
	"\xEEDC" => '&#37775;',
	"\xEEDD" => '&#37708;',
	"\xEEDE" => '&#37738;',
	"\xEEDF" => '&#37753;',
	"\xEEE0" => '&#37719;',
	"\xEEE1" => '&#37717;',
	"\xEEE2" => '&#37714;',
	"\xEEE3" => '&#37711;',
	"\xEEE4" => '&#37745;',
	"\xEEE5" => '&#37751;',
	"\xEEE6" => '&#37755;',
	"\xEEE7" => '&#37729;',
	"\xEEE8" => '&#37726;',
	"\xEEE9" => '&#37731;',
	"\xEEEA" => '&#37735;',
	"\xEEEB" => '&#37760;',
	"\xEEEC" => '&#37710;',
	"\xEEED" => '&#37721;',
	"\xEEEE" => '&#38343;',
	"\xEEEF" => '&#38336;',
	"\xEEF0" => '&#38345;',
	"\xEEF1" => '&#38339;',
	"\xEEF2" => '&#38341;',
	"\xEEF3" => '&#38327;',
	"\xEEF4" => '&#38574;',
	"\xEEF5" => '&#38576;',
	"\xEEF6" => '&#38572;',
	"\xEEF7" => '&#38688;',
	"\xEEF8" => '&#38687;',
	"\xEEF9" => '&#38680;',
	"\xEEFA" => '&#38685;',
	"\xEEFB" => '&#38681;',
	"\xEEFC" => '&#38810;',
	"\xEEFD" => '&#38817;',
	"\xEEFE" => '&#38812;',
	"\xEF40" => '&#38814;',
	"\xEF41" => '&#38813;',
	"\xEF42" => '&#38869;',
	"\xEF43" => '&#38868;',
	"\xEF44" => '&#38897;',
	"\xEF45" => '&#38977;',
	"\xEF46" => '&#38980;',
	"\xEF47" => '&#38986;',
	"\xEF48" => '&#38985;',
	"\xEF49" => '&#38981;',
	"\xEF4A" => '&#38979;',
	"\xEF4B" => '&#39205;',
	"\xEF4C" => '&#39211;',
	"\xEF4D" => '&#39212;',
	"\xEF4E" => '&#39210;',
	"\xEF4F" => '&#39219;',
	"\xEF50" => '&#39218;',
	"\xEF51" => '&#39215;',
	"\xEF52" => '&#39213;',
	"\xEF53" => '&#39217;',
	"\xEF54" => '&#39216;',
	"\xEF55" => '&#39320;',
	"\xEF56" => '&#39331;',
	"\xEF57" => '&#39329;',
	"\xEF58" => '&#39426;',
	"\xEF59" => '&#39418;',
	"\xEF5A" => '&#39412;',
	"\xEF5B" => '&#39415;',
	"\xEF5C" => '&#39417;',
	"\xEF5D" => '&#39416;',
	"\xEF5E" => '&#39414;',
	"\xEF5F" => '&#39419;',
	"\xEF60" => '&#39421;',
	"\xEF61" => '&#39422;',
	"\xEF62" => '&#39420;',
	"\xEF63" => '&#39427;',
	"\xEF64" => '&#39614;',
	"\xEF65" => '&#39678;',
	"\xEF66" => '&#39677;',
	"\xEF67" => '&#39681;',
	"\xEF68" => '&#39676;',
	"\xEF69" => '&#39752;',
	"\xEF6A" => '&#39834;',
	"\xEF6B" => '&#39848;',
	"\xEF6C" => '&#39838;',
	"\xEF6D" => '&#39835;',
	"\xEF6E" => '&#39846;',
	"\xEF6F" => '&#39841;',
	"\xEF70" => '&#39845;',
	"\xEF71" => '&#39844;',
	"\xEF72" => '&#39814;',
	"\xEF73" => '&#39842;',
	"\xEF74" => '&#39840;',
	"\xEF75" => '&#39855;',
	"\xEF76" => '&#40243;',
	"\xEF77" => '&#40257;',
	"\xEF78" => '&#40295;',
	"\xEF79" => '&#40246;',
	"\xEF7A" => '&#40238;',
	"\xEF7B" => '&#40239;',
	"\xEF7C" => '&#40241;',
	"\xEF7D" => '&#40248;',
	"\xEF7E" => '&#40240;',
	"\xEFA1" => '&#40261;',
	"\xEFA2" => '&#40258;',
	"\xEFA3" => '&#40259;',
	"\xEFA4" => '&#40254;',
	"\xEFA5" => '&#40247;',
	"\xEFA6" => '&#40256;',
	"\xEFA7" => '&#40253;',
	"\xEFA8" => '&#32757;',
	"\xEFA9" => '&#40237;',
	"\xEFAA" => '&#40586;',
	"\xEFAB" => '&#40585;',
	"\xEFAC" => '&#40589;',
	"\xEFAD" => '&#40624;',
	"\xEFAE" => '&#40648;',
	"\xEFAF" => '&#40666;',
	"\xEFB0" => '&#40699;',
	"\xEFB1" => '&#40703;',
	"\xEFB2" => '&#40740;',
	"\xEFB3" => '&#40739;',
	"\xEFB4" => '&#40738;',
	"\xEFB5" => '&#40788;',
	"\xEFB6" => '&#40864;',
	"\xEFB7" => '&#20785;',
	"\xEFB8" => '&#20781;',
	"\xEFB9" => '&#20782;',
	"\xEFBA" => '&#22168;',
	"\xEFBB" => '&#22172;',
	"\xEFBC" => '&#22167;',
	"\xEFBD" => '&#22170;',
	"\xEFBE" => '&#22173;',
	"\xEFBF" => '&#22169;',
	"\xEFC0" => '&#22896;',
	"\xEFC1" => '&#23356;',
	"\xEFC2" => '&#23657;',
	"\xEFC3" => '&#23658;',
	"\xEFC4" => '&#24000;',
	"\xEFC5" => '&#24173;',
	"\xEFC6" => '&#24174;',
	"\xEFC7" => '&#25048;',
	"\xEFC8" => '&#25055;',
	"\xEFC9" => '&#25069;',
	"\xEFCA" => '&#25070;',
	"\xEFCB" => '&#25073;',
	"\xEFCC" => '&#25066;',
	"\xEFCD" => '&#25072;',
	"\xEFCE" => '&#25067;',
	"\xEFCF" => '&#25046;',
	"\xEFD0" => '&#25065;',
	"\xEFD1" => '&#25855;',
	"\xEFD2" => '&#25860;',
	"\xEFD3" => '&#25853;',
	"\xEFD4" => '&#25848;',
	"\xEFD5" => '&#25857;',
	"\xEFD6" => '&#25859;',
	"\xEFD7" => '&#25852;',
	"\xEFD8" => '&#26004;',
	"\xEFD9" => '&#26075;',
	"\xEFDA" => '&#26330;',
	"\xEFDB" => '&#26331;',
	"\xEFDC" => '&#26328;',
	"\xEFDD" => '&#27333;',
	"\xEFDE" => '&#27321;',
	"\xEFDF" => '&#27325;',
	"\xEFE0" => '&#27361;',
	"\xEFE1" => '&#27334;',
	"\xEFE2" => '&#27322;',
	"\xEFE3" => '&#27318;',
	"\xEFE4" => '&#27319;',
	"\xEFE5" => '&#27335;',
	"\xEFE6" => '&#27316;',
	"\xEFE7" => '&#27309;',
	"\xEFE8" => '&#27486;',
	"\xEFE9" => '&#27593;',
	"\xEFEA" => '&#27659;',
	"\xEFEB" => '&#28679;',
	"\xEFEC" => '&#28684;',
	"\xEFED" => '&#28685;',
	"\xEFEE" => '&#28673;',
	"\xEFEF" => '&#28677;',
	"\xEFF0" => '&#28692;',
	"\xEFF1" => '&#28686;',
	"\xEFF2" => '&#28671;',
	"\xEFF3" => '&#28672;',
	"\xEFF4" => '&#28667;',
	"\xEFF5" => '&#28710;',
	"\xEFF6" => '&#28668;',
	"\xEFF7" => '&#28663;',
	"\xEFF8" => '&#28682;',
	"\xEFF9" => '&#29185;',
	"\xEFFA" => '&#29183;',
	"\xEFFB" => '&#29177;',
	"\xEFFC" => '&#29187;',
	"\xEFFD" => '&#29181;',
	"\xEFFE" => '&#29558;',
	"\xF040" => '&#29880;',
	"\xF041" => '&#29888;',
	"\xF042" => '&#29877;',
	"\xF043" => '&#29889;',
	"\xF044" => '&#29886;',
	"\xF045" => '&#29878;',
	"\xF046" => '&#29883;',
	"\xF047" => '&#29890;',
	"\xF048" => '&#29972;',
	"\xF049" => '&#29971;',
	"\xF04A" => '&#30300;',
	"\xF04B" => '&#30308;',
	"\xF04C" => '&#30297;',
	"\xF04D" => '&#30288;',
	"\xF04E" => '&#30291;',
	"\xF04F" => '&#30295;',
	"\xF050" => '&#30298;',
	"\xF051" => '&#30374;',
	"\xF052" => '&#30397;',
	"\xF053" => '&#30444;',
	"\xF054" => '&#30658;',
	"\xF055" => '&#30650;',
	"\xF056" => '&#30975;',
	"\xF057" => '&#30988;',
	"\xF058" => '&#30995;',
	"\xF059" => '&#30996;',
	"\xF05A" => '&#30985;',
	"\xF05B" => '&#30992;',
	"\xF05C" => '&#30994;',
	"\xF05D" => '&#30993;',
	"\xF05E" => '&#31149;',
	"\xF05F" => '&#31148;',
	"\xF060" => '&#31327;',
	"\xF061" => '&#31772;',
	"\xF062" => '&#31785;',
	"\xF063" => '&#31769;',
	"\xF064" => '&#31776;',
	"\xF065" => '&#31775;',
	"\xF066" => '&#31789;',
	"\xF067" => '&#31773;',
	"\xF068" => '&#31782;',
	"\xF069" => '&#31784;',
	"\xF06A" => '&#31778;',
	"\xF06B" => '&#31781;',
	"\xF06C" => '&#31792;',
	"\xF06D" => '&#32348;',
	"\xF06E" => '&#32336;',
	"\xF06F" => '&#32342;',
	"\xF070" => '&#32355;',
	"\xF071" => '&#32344;',
	"\xF072" => '&#32354;',
	"\xF073" => '&#32351;',
	"\xF074" => '&#32337;',
	"\xF075" => '&#32352;',
	"\xF076" => '&#32343;',
	"\xF077" => '&#32339;',
	"\xF078" => '&#32693;',
	"\xF079" => '&#32691;',
	"\xF07A" => '&#32759;',
	"\xF07B" => '&#32760;',
	"\xF07C" => '&#32885;',
	"\xF07D" => '&#33233;',
	"\xF07E" => '&#33234;',
	"\xF0A1" => '&#33232;',
	"\xF0A2" => '&#33375;',
	"\xF0A3" => '&#33374;',
	"\xF0A4" => '&#34228;',
	"\xF0A5" => '&#34246;',
	"\xF0A6" => '&#34240;',
	"\xF0A7" => '&#34243;',
	"\xF0A8" => '&#34242;',
	"\xF0A9" => '&#34227;',
	"\xF0AA" => '&#34229;',
	"\xF0AB" => '&#34237;',
	"\xF0AC" => '&#34247;',
	"\xF0AD" => '&#34244;',
	"\xF0AE" => '&#34239;',
	"\xF0AF" => '&#34251;',
	"\xF0B0" => '&#34254;',
	"\xF0B1" => '&#34248;',
	"\xF0B2" => '&#34245;',
	"\xF0B3" => '&#34225;',
	"\xF0B4" => '&#34230;',
	"\xF0B5" => '&#34258;',
	"\xF0B6" => '&#34340;',
	"\xF0B7" => '&#34232;',
	"\xF0B8" => '&#34231;',
	"\xF0B9" => '&#34238;',
	"\xF0BA" => '&#34409;',
	"\xF0BB" => '&#34791;',
	"\xF0BC" => '&#34790;',
	"\xF0BD" => '&#34786;',
	"\xF0BE" => '&#34779;',
	"\xF0BF" => '&#34795;',
	"\xF0C0" => '&#34794;',
	"\xF0C1" => '&#34789;',
	"\xF0C2" => '&#34783;',
	"\xF0C3" => '&#34803;',
	"\xF0C4" => '&#34788;',
	"\xF0C5" => '&#34772;',
	"\xF0C6" => '&#34780;',
	"\xF0C7" => '&#34771;',
	"\xF0C8" => '&#34797;',
	"\xF0C9" => '&#34776;',
	"\xF0CA" => '&#34787;',
	"\xF0CB" => '&#34724;',
	"\xF0CC" => '&#34775;',
	"\xF0CD" => '&#34777;',
	"\xF0CE" => '&#34817;',
	"\xF0CF" => '&#34804;',
	"\xF0D0" => '&#34792;',
	"\xF0D1" => '&#34781;',
	"\xF0D2" => '&#35155;',
	"\xF0D3" => '&#35147;',
	"\xF0D4" => '&#35151;',
	"\xF0D5" => '&#35148;',
	"\xF0D6" => '&#35142;',
	"\xF0D7" => '&#35152;',
	"\xF0D8" => '&#35153;',
	"\xF0D9" => '&#35145;',
	"\xF0DA" => '&#35626;',
	"\xF0DB" => '&#35623;',
	"\xF0DC" => '&#35619;',
	"\xF0DD" => '&#35635;',
	"\xF0DE" => '&#35632;',
	"\xF0DF" => '&#35637;',
	"\xF0E0" => '&#35655;',
	"\xF0E1" => '&#35631;',
	"\xF0E2" => '&#35644;',
	"\xF0E3" => '&#35646;',
	"\xF0E4" => '&#35633;',
	"\xF0E5" => '&#35621;',
	"\xF0E6" => '&#35639;',
	"\xF0E7" => '&#35622;',
	"\xF0E8" => '&#35638;',
	"\xF0E9" => '&#35630;',
	"\xF0EA" => '&#35620;',
	"\xF0EB" => '&#35643;',
	"\xF0EC" => '&#35645;',
	"\xF0ED" => '&#35642;',
	"\xF0EE" => '&#35906;',
	"\xF0EF" => '&#35957;',
	"\xF0F0" => '&#35993;',
	"\xF0F1" => '&#35992;',
	"\xF0F2" => '&#35991;',
	"\xF0F3" => '&#36094;',
	"\xF0F4" => '&#36100;',
	"\xF0F5" => '&#36098;',
	"\xF0F6" => '&#36096;',
	"\xF0F7" => '&#36444;',
	"\xF0F8" => '&#36450;',
	"\xF0F9" => '&#36448;',
	"\xF0FA" => '&#36439;',
	"\xF0FB" => '&#36438;',
	"\xF0FC" => '&#36446;',
	"\xF0FD" => '&#36453;',
	"\xF0FE" => '&#36455;',
	"\xF140" => '&#36443;',
	"\xF141" => '&#36442;',
	"\xF142" => '&#36449;',
	"\xF143" => '&#36445;',
	"\xF144" => '&#36457;',
	"\xF145" => '&#36436;',
	"\xF146" => '&#36678;',
	"\xF147" => '&#36679;',
	"\xF148" => '&#36680;',
	"\xF149" => '&#36683;',
	"\xF14A" => '&#37160;',
	"\xF14B" => '&#37178;',
	"\xF14C" => '&#37179;',
	"\xF14D" => '&#37182;',
	"\xF14E" => '&#37288;',
	"\xF14F" => '&#37285;',
	"\xF150" => '&#37287;',
	"\xF151" => '&#37295;',
	"\xF152" => '&#37290;',
	"\xF153" => '&#37813;',
	"\xF154" => '&#37772;',
	"\xF155" => '&#37778;',
	"\xF156" => '&#37815;',
	"\xF157" => '&#37787;',
	"\xF158" => '&#37789;',
	"\xF159" => '&#37769;',
	"\xF15A" => '&#37799;',
	"\xF15B" => '&#37774;',
	"\xF15C" => '&#37802;',
	"\xF15D" => '&#37790;',
	"\xF15E" => '&#37798;',
	"\xF15F" => '&#37781;',
	"\xF160" => '&#37768;',
	"\xF161" => '&#37785;',
	"\xF162" => '&#37791;',
	"\xF163" => '&#37773;',
	"\xF164" => '&#37809;',
	"\xF165" => '&#37777;',
	"\xF166" => '&#37810;',
	"\xF167" => '&#37796;',
	"\xF168" => '&#37800;',
	"\xF169" => '&#37812;',
	"\xF16A" => '&#37795;',
	"\xF16B" => '&#37797;',
	"\xF16C" => '&#38354;',
	"\xF16D" => '&#38355;',
	"\xF16E" => '&#38353;',
	"\xF16F" => '&#38579;',
	"\xF170" => '&#38615;',
	"\xF171" => '&#38618;',
	"\xF172" => '&#24002;',
	"\xF173" => '&#38623;',
	"\xF174" => '&#38616;',
	"\xF175" => '&#38621;',
	"\xF176" => '&#38691;',
	"\xF177" => '&#38690;',
	"\xF178" => '&#38693;',
	"\xF179" => '&#38828;',
	"\xF17A" => '&#38830;',
	"\xF17B" => '&#38824;',
	"\xF17C" => '&#38827;',
	"\xF17D" => '&#38820;',
	"\xF17E" => '&#38826;',
	"\xF1A1" => '&#38818;',
	"\xF1A2" => '&#38821;',
	"\xF1A3" => '&#38871;',
	"\xF1A4" => '&#38873;',
	"\xF1A5" => '&#38870;',
	"\xF1A6" => '&#38872;',
	"\xF1A7" => '&#38906;',
	"\xF1A8" => '&#38992;',
	"\xF1A9" => '&#38993;',
	"\xF1AA" => '&#38994;',
	"\xF1AB" => '&#39096;',
	"\xF1AC" => '&#39233;',
	"\xF1AD" => '&#39228;',
	"\xF1AE" => '&#39226;',
	"\xF1AF" => '&#39439;',
	"\xF1B0" => '&#39435;',
	"\xF1B1" => '&#39433;',
	"\xF1B2" => '&#39437;',
	"\xF1B3" => '&#39428;',
	"\xF1B4" => '&#39441;',
	"\xF1B5" => '&#39434;',
	"\xF1B6" => '&#39429;',
	"\xF1B7" => '&#39431;',
	"\xF1B8" => '&#39430;',
	"\xF1B9" => '&#39616;',
	"\xF1BA" => '&#39644;',
	"\xF1BB" => '&#39688;',
	"\xF1BC" => '&#39684;',
	"\xF1BD" => '&#39685;',
	"\xF1BE" => '&#39721;',
	"\xF1BF" => '&#39733;',
	"\xF1C0" => '&#39754;',
	"\xF1C1" => '&#39756;',
	"\xF1C2" => '&#39755;',
	"\xF1C3" => '&#39879;',
	"\xF1C4" => '&#39878;',
	"\xF1C5" => '&#39875;',
	"\xF1C6" => '&#39871;',
	"\xF1C7" => '&#39873;',
	"\xF1C8" => '&#39861;',
	"\xF1C9" => '&#39864;',
	"\xF1CA" => '&#39891;',
	"\xF1CB" => '&#39862;',
	"\xF1CC" => '&#39876;',
	"\xF1CD" => '&#39865;',
	"\xF1CE" => '&#39869;',
	"\xF1CF" => '&#40284;',
	"\xF1D0" => '&#40275;',
	"\xF1D1" => '&#40271;',
	"\xF1D2" => '&#40266;',
	"\xF1D3" => '&#40283;',
	"\xF1D4" => '&#40267;',
	"\xF1D5" => '&#40281;',
	"\xF1D6" => '&#40278;',
	"\xF1D7" => '&#40268;',
	"\xF1D8" => '&#40279;',
	"\xF1D9" => '&#40274;',
	"\xF1DA" => '&#40276;',
	"\xF1DB" => '&#40287;',
	"\xF1DC" => '&#40280;',
	"\xF1DD" => '&#40282;',
	"\xF1DE" => '&#40590;',
	"\xF1DF" => '&#40588;',
	"\xF1E0" => '&#40671;',
	"\xF1E1" => '&#40705;',
	"\xF1E2" => '&#40704;',
	"\xF1E3" => '&#40726;',
	"\xF1E4" => '&#40741;',
	"\xF1E5" => '&#40747;',
	"\xF1E6" => '&#40746;',
	"\xF1E7" => '&#40745;',
	"\xF1E8" => '&#40744;',
	"\xF1E9" => '&#40780;',
	"\xF1EA" => '&#40789;',
	"\xF1EB" => '&#20788;',
	"\xF1EC" => '&#20789;',
	"\xF1ED" => '&#21142;',
	"\xF1EE" => '&#21239;',
	"\xF1EF" => '&#21428;',
	"\xF1F0" => '&#22187;',
	"\xF1F1" => '&#22189;',
	"\xF1F2" => '&#22182;',
	"\xF1F3" => '&#22183;',
	"\xF1F4" => '&#22186;',
	"\xF1F5" => '&#22188;',
	"\xF1F6" => '&#22746;',
	"\xF1F7" => '&#22749;',
	"\xF1F8" => '&#22747;',
	"\xF1F9" => '&#22802;',
	"\xF1FA" => '&#23357;',
	"\xF1FB" => '&#23358;',
	"\xF1FC" => '&#23359;',
	"\xF1FD" => '&#24003;',
	"\xF1FE" => '&#24176;',
	"\xF240" => '&#24511;',
	"\xF241" => '&#25083;',
	"\xF242" => '&#25863;',
	"\xF243" => '&#25872;',
	"\xF244" => '&#25869;',
	"\xF245" => '&#25865;',
	"\xF246" => '&#25868;',
	"\xF247" => '&#25870;',
	"\xF248" => '&#25988;',
	"\xF249" => '&#26078;',
	"\xF24A" => '&#26077;',
	"\xF24B" => '&#26334;',
	"\xF24C" => '&#27367;',
	"\xF24D" => '&#27360;',
	"\xF24E" => '&#27340;',
	"\xF24F" => '&#27345;',
	"\xF250" => '&#27353;',
	"\xF251" => '&#27339;',
	"\xF252" => '&#27359;',
	"\xF253" => '&#27356;',
	"\xF254" => '&#27344;',
	"\xF255" => '&#27371;',
	"\xF256" => '&#27343;',
	"\xF257" => '&#27341;',
	"\xF258" => '&#27358;',
	"\xF259" => '&#27488;',
	"\xF25A" => '&#27568;',
	"\xF25B" => '&#27660;',
	"\xF25C" => '&#28697;',
	"\xF25D" => '&#28711;',
	"\xF25E" => '&#28704;',
	"\xF25F" => '&#28694;',
	"\xF260" => '&#28715;',
	"\xF261" => '&#28705;',
	"\xF262" => '&#28706;',
	"\xF263" => '&#28707;',
	"\xF264" => '&#28713;',
	"\xF265" => '&#28695;',
	"\xF266" => '&#28708;',
	"\xF267" => '&#28700;',
	"\xF268" => '&#28714;',
	"\xF269" => '&#29196;',
	"\xF26A" => '&#29194;',
	"\xF26B" => '&#29191;',
	"\xF26C" => '&#29186;',
	"\xF26D" => '&#29189;',
	"\xF26E" => '&#29349;',
	"\xF26F" => '&#29350;',
	"\xF270" => '&#29348;',
	"\xF271" => '&#29347;',
	"\xF272" => '&#29345;',
	"\xF273" => '&#29899;',
	"\xF274" => '&#29893;',
	"\xF275" => '&#29879;',
	"\xF276" => '&#29891;',
	"\xF277" => '&#29974;',
	"\xF278" => '&#30304;',
	"\xF279" => '&#30665;',
	"\xF27A" => '&#30666;',
	"\xF27B" => '&#30660;',
	"\xF27C" => '&#30705;',
	"\xF27D" => '&#31005;',
	"\xF27E" => '&#31003;',
	"\xF2A1" => '&#31009;',
	"\xF2A2" => '&#31004;',
	"\xF2A3" => '&#30999;',
	"\xF2A4" => '&#31006;',
	"\xF2A5" => '&#31152;',
	"\xF2A6" => '&#31335;',
	"\xF2A7" => '&#31336;',
	"\xF2A8" => '&#31795;',
	"\xF2A9" => '&#31804;',
	"\xF2AA" => '&#31801;',
	"\xF2AB" => '&#31788;',
	"\xF2AC" => '&#31803;',
	"\xF2AD" => '&#31980;',
	"\xF2AE" => '&#31978;',
	"\xF2AF" => '&#32374;',
	"\xF2B0" => '&#32373;',
	"\xF2B1" => '&#32376;',
	"\xF2B2" => '&#32368;',
	"\xF2B3" => '&#32375;',
	"\xF2B4" => '&#32367;',
	"\xF2B5" => '&#32378;',
	"\xF2B6" => '&#32370;',
	"\xF2B7" => '&#32372;',
	"\xF2B8" => '&#32360;',
	"\xF2B9" => '&#32587;',
	"\xF2BA" => '&#32586;',
	"\xF2BB" => '&#32643;',
	"\xF2BC" => '&#32646;',
	"\xF2BD" => '&#32695;',
	"\xF2BE" => '&#32765;',
	"\xF2BF" => '&#32766;',
	"\xF2C0" => '&#32888;',
	"\xF2C1" => '&#33239;',
	"\xF2C2" => '&#33237;',
	"\xF2C3" => '&#33380;',
	"\xF2C4" => '&#33377;',
	"\xF2C5" => '&#33379;',
	"\xF2C6" => '&#34283;',
	"\xF2C7" => '&#34289;',
	"\xF2C8" => '&#34285;',
	"\xF2C9" => '&#34265;',
	"\xF2CA" => '&#34273;',
	"\xF2CB" => '&#34280;',
	"\xF2CC" => '&#34266;',
	"\xF2CD" => '&#34263;',
	"\xF2CE" => '&#34284;',
	"\xF2CF" => '&#34290;',
	"\xF2D0" => '&#34296;',
	"\xF2D1" => '&#34264;',
	"\xF2D2" => '&#34271;',
	"\xF2D3" => '&#34275;',
	"\xF2D4" => '&#34268;',
	"\xF2D5" => '&#34257;',
	"\xF2D6" => '&#34288;',
	"\xF2D7" => '&#34278;',
	"\xF2D8" => '&#34287;',
	"\xF2D9" => '&#34270;',
	"\xF2DA" => '&#34274;',
	"\xF2DB" => '&#34816;',
	"\xF2DC" => '&#34810;',
	"\xF2DD" => '&#34819;',
	"\xF2DE" => '&#34806;',
	"\xF2DF" => '&#34807;',
	"\xF2E0" => '&#34825;',
	"\xF2E1" => '&#34828;',
	"\xF2E2" => '&#34827;',
	"\xF2E3" => '&#34822;',
	"\xF2E4" => '&#34812;',
	"\xF2E5" => '&#34824;',
	"\xF2E6" => '&#34815;',
	"\xF2E7" => '&#34826;',
	"\xF2E8" => '&#34818;',
	"\xF2E9" => '&#35170;',
	"\xF2EA" => '&#35162;',
	"\xF2EB" => '&#35163;',
	"\xF2EC" => '&#35159;',
	"\xF2ED" => '&#35169;',
	"\xF2EE" => '&#35164;',
	"\xF2EF" => '&#35160;',
	"\xF2F0" => '&#35165;',
	"\xF2F1" => '&#35161;',
	"\xF2F2" => '&#35208;',
	"\xF2F3" => '&#35255;',
	"\xF2F4" => '&#35254;',
	"\xF2F5" => '&#35318;',
	"\xF2F6" => '&#35664;',
	"\xF2F7" => '&#35656;',
	"\xF2F8" => '&#35658;',
	"\xF2F9" => '&#35648;',
	"\xF2FA" => '&#35667;',
	"\xF2FB" => '&#35670;',
	"\xF2FC" => '&#35668;',
	"\xF2FD" => '&#35659;',
	"\xF2FE" => '&#35669;',
	"\xF340" => '&#35665;',
	"\xF341" => '&#35650;',
	"\xF342" => '&#35666;',
	"\xF343" => '&#35671;',
	"\xF344" => '&#35907;',
	"\xF345" => '&#35959;',
	"\xF346" => '&#35958;',
	"\xF347" => '&#35994;',
	"\xF348" => '&#36102;',
	"\xF349" => '&#36103;',
	"\xF34A" => '&#36105;',
	"\xF34B" => '&#36268;',
	"\xF34C" => '&#36266;',
	"\xF34D" => '&#36269;',
	"\xF34E" => '&#36267;',
	"\xF34F" => '&#36461;',
	"\xF350" => '&#36472;',
	"\xF351" => '&#36467;',
	"\xF352" => '&#36458;',
	"\xF353" => '&#36463;',
	"\xF354" => '&#36475;',
	"\xF355" => '&#36546;',
	"\xF356" => '&#36690;',
	"\xF357" => '&#36689;',
	"\xF358" => '&#36687;',
	"\xF359" => '&#36688;',
	"\xF35A" => '&#36691;',
	"\xF35B" => '&#36788;',
	"\xF35C" => '&#37184;',
	"\xF35D" => '&#37183;',
	"\xF35E" => '&#37296;',
	"\xF35F" => '&#37293;',
	"\xF360" => '&#37854;',
	"\xF361" => '&#37831;',
	"\xF362" => '&#37839;',
	"\xF363" => '&#37826;',
	"\xF364" => '&#37850;',
	"\xF365" => '&#37840;',
	"\xF366" => '&#37881;',
	"\xF367" => '&#37868;',
	"\xF368" => '&#37836;',
	"\xF369" => '&#37849;',
	"\xF36A" => '&#37801;',
	"\xF36B" => '&#37862;',
	"\xF36C" => '&#37834;',
	"\xF36D" => '&#37844;',
	"\xF36E" => '&#37870;',
	"\xF36F" => '&#37859;',
	"\xF370" => '&#37845;',
	"\xF371" => '&#37828;',
	"\xF372" => '&#37838;',
	"\xF373" => '&#37824;',
	"\xF374" => '&#37842;',
	"\xF375" => '&#37863;',
	"\xF376" => '&#38269;',
	"\xF377" => '&#38362;',
	"\xF378" => '&#38363;',
	"\xF379" => '&#38625;',
	"\xF37A" => '&#38697;',
	"\xF37B" => '&#38699;',
	"\xF37C" => '&#38700;',
	"\xF37D" => '&#38696;',
	"\xF37E" => '&#38694;',
	"\xF3A1" => '&#38835;',
	"\xF3A2" => '&#38839;',
	"\xF3A3" => '&#38838;',
	"\xF3A4" => '&#38877;',
	"\xF3A5" => '&#38878;',
	"\xF3A6" => '&#38879;',
	"\xF3A7" => '&#39004;',
	"\xF3A8" => '&#39001;',
	"\xF3A9" => '&#39005;',
	"\xF3AA" => '&#38999;',
	"\xF3AB" => '&#39103;',
	"\xF3AC" => '&#39101;',
	"\xF3AD" => '&#39099;',
	"\xF3AE" => '&#39102;',
	"\xF3AF" => '&#39240;',
	"\xF3B0" => '&#39239;',
	"\xF3B1" => '&#39235;',
	"\xF3B2" => '&#39334;',
	"\xF3B3" => '&#39335;',
	"\xF3B4" => '&#39450;',
	"\xF3B5" => '&#39445;',
	"\xF3B6" => '&#39461;',
	"\xF3B7" => '&#39453;',
	"\xF3B8" => '&#39460;',
	"\xF3B9" => '&#39451;',
	"\xF3BA" => '&#39458;',
	"\xF3BB" => '&#39456;',
	"\xF3BC" => '&#39463;',
	"\xF3BD" => '&#39459;',
	"\xF3BE" => '&#39454;',
	"\xF3BF" => '&#39452;',
	"\xF3C0" => '&#39444;',
	"\xF3C1" => '&#39618;',
	"\xF3C2" => '&#39691;',
	"\xF3C3" => '&#39690;',
	"\xF3C4" => '&#39694;',
	"\xF3C5" => '&#39692;',
	"\xF3C6" => '&#39735;',
	"\xF3C7" => '&#39914;',
	"\xF3C8" => '&#39915;',
	"\xF3C9" => '&#39904;',
	"\xF3CA" => '&#39902;',
	"\xF3CB" => '&#39908;',
	"\xF3CC" => '&#39910;',
	"\xF3CD" => '&#39906;',
	"\xF3CE" => '&#39920;',
	"\xF3CF" => '&#39892;',
	"\xF3D0" => '&#39895;',
	"\xF3D1" => '&#39916;',
	"\xF3D2" => '&#39900;',
	"\xF3D3" => '&#39897;',
	"\xF3D4" => '&#39909;',
	"\xF3D5" => '&#39893;',
	"\xF3D6" => '&#39905;',
	"\xF3D7" => '&#39898;',
	"\xF3D8" => '&#40311;',
	"\xF3D9" => '&#40321;',
	"\xF3DA" => '&#40330;',
	"\xF3DB" => '&#40324;',
	"\xF3DC" => '&#40328;',
	"\xF3DD" => '&#40305;',
	"\xF3DE" => '&#40320;',
	"\xF3DF" => '&#40312;',
	"\xF3E0" => '&#40326;',
	"\xF3E1" => '&#40331;',
	"\xF3E2" => '&#40332;',
	"\xF3E3" => '&#40317;',
	"\xF3E4" => '&#40299;',
	"\xF3E5" => '&#40308;',
	"\xF3E6" => '&#40309;',
	"\xF3E7" => '&#40304;',
	"\xF3E8" => '&#40297;',
	"\xF3E9" => '&#40325;',
	"\xF3EA" => '&#40307;',
	"\xF3EB" => '&#40315;',
	"\xF3EC" => '&#40322;',
	"\xF3ED" => '&#40303;',
	"\xF3EE" => '&#40313;',
	"\xF3EF" => '&#40319;',
	"\xF3F0" => '&#40327;',
	"\xF3F1" => '&#40296;',
	"\xF3F2" => '&#40596;',
	"\xF3F3" => '&#40593;',
	"\xF3F4" => '&#40640;',
	"\xF3F5" => '&#40700;',
	"\xF3F6" => '&#40749;',
	"\xF3F7" => '&#40768;',
	"\xF3F8" => '&#40769;',
	"\xF3F9" => '&#40781;',
	"\xF3FA" => '&#40790;',
	"\xF3FB" => '&#40791;',
	"\xF3FC" => '&#40792;',
	"\xF3FD" => '&#21303;',
	"\xF3FE" => '&#22194;',
	"\xF440" => '&#22197;',
	"\xF441" => '&#22195;',
	"\xF442" => '&#22755;',
	"\xF443" => '&#23365;',
	"\xF444" => '&#24006;',
	"\xF445" => '&#24007;',
	"\xF446" => '&#24302;',
	"\xF447" => '&#24303;',
	"\xF448" => '&#24512;',
	"\xF449" => '&#24513;',
	"\xF44A" => '&#25081;',
	"\xF44B" => '&#25879;',
	"\xF44C" => '&#25878;',
	"\xF44D" => '&#25877;',
	"\xF44E" => '&#25875;',
	"\xF44F" => '&#26079;',
	"\xF450" => '&#26344;',
	"\xF451" => '&#26339;',
	"\xF452" => '&#26340;',
	"\xF453" => '&#27379;',
	"\xF454" => '&#27376;',
	"\xF455" => '&#27370;',
	"\xF456" => '&#27368;',
	"\xF457" => '&#27385;',
	"\xF458" => '&#27377;',
	"\xF459" => '&#27374;',
	"\xF45A" => '&#27375;',
	"\xF45B" => '&#28732;',
	"\xF45C" => '&#28725;',
	"\xF45D" => '&#28719;',
	"\xF45E" => '&#28727;',
	"\xF45F" => '&#28724;',
	"\xF460" => '&#28721;',
	"\xF461" => '&#28738;',
	"\xF462" => '&#28728;',
	"\xF463" => '&#28735;',
	"\xF464" => '&#28730;',
	"\xF465" => '&#28729;',
	"\xF466" => '&#28736;',
	"\xF467" => '&#28731;',
	"\xF468" => '&#28723;',
	"\xF469" => '&#28737;',
	"\xF46A" => '&#29203;',
	"\xF46B" => '&#29204;',
	"\xF46C" => '&#29352;',
	"\xF46D" => '&#29565;',
	"\xF46E" => '&#29564;',
	"\xF46F" => '&#29882;',
	"\xF470" => '&#30379;',
	"\xF471" => '&#30378;',
	"\xF472" => '&#30398;',
	"\xF473" => '&#30445;',
	"\xF474" => '&#30668;',
	"\xF475" => '&#30670;',
	"\xF476" => '&#30671;',
	"\xF477" => '&#30669;',
	"\xF478" => '&#30706;',
	"\xF479" => '&#31013;',
	"\xF47A" => '&#31011;',
	"\xF47B" => '&#31015;',
	"\xF47C" => '&#31016;',
	"\xF47D" => '&#31012;',
	"\xF47E" => '&#31017;',
	"\xF4A1" => '&#31154;',
	"\xF4A2" => '&#31342;',
	"\xF4A3" => '&#31340;',
	"\xF4A4" => '&#31341;',
	"\xF4A5" => '&#31479;',
	"\xF4A6" => '&#31817;',
	"\xF4A7" => '&#31816;',
	"\xF4A8" => '&#31818;',
	"\xF4A9" => '&#31815;',
	"\xF4AA" => '&#31813;',
	"\xF4AB" => '&#31982;',
	"\xF4AC" => '&#32379;',
	"\xF4AD" => '&#32382;',
	"\xF4AE" => '&#32385;',
	"\xF4AF" => '&#32384;',
	"\xF4B0" => '&#32698;',
	"\xF4B1" => '&#32767;',
	"\xF4B2" => '&#32889;',
	"\xF4B3" => '&#33243;',
	"\xF4B4" => '&#33241;',
	"\xF4B5" => '&#33291;',
	"\xF4B6" => '&#33384;',
	"\xF4B7" => '&#33385;',
	"\xF4B8" => '&#34338;',
	"\xF4B9" => '&#34303;',
	"\xF4BA" => '&#34305;',
	"\xF4BB" => '&#34302;',
	"\xF4BC" => '&#34331;',
	"\xF4BD" => '&#34304;',
	"\xF4BE" => '&#34294;',
	"\xF4BF" => '&#34308;',
	"\xF4C0" => '&#34313;',
	"\xF4C1" => '&#34309;',
	"\xF4C2" => '&#34316;',
	"\xF4C3" => '&#34301;',
	"\xF4C4" => '&#34841;',
	"\xF4C5" => '&#34832;',
	"\xF4C6" => '&#34833;',
	"\xF4C7" => '&#34839;',
	"\xF4C8" => '&#34835;',
	"\xF4C9" => '&#34838;',
	"\xF4CA" => '&#35171;',
	"\xF4CB" => '&#35174;',
	"\xF4CC" => '&#35257;',
	"\xF4CD" => '&#35319;',
	"\xF4CE" => '&#35680;',
	"\xF4CF" => '&#35690;',
	"\xF4D0" => '&#35677;',
	"\xF4D1" => '&#35688;',
	"\xF4D2" => '&#35683;',
	"\xF4D3" => '&#35685;',
	"\xF4D4" => '&#35687;',
	"\xF4D5" => '&#35693;',
	"\xF4D6" => '&#36270;',
	"\xF4D7" => '&#36486;',
	"\xF4D8" => '&#36488;',
	"\xF4D9" => '&#36484;',
	"\xF4DA" => '&#36697;',
	"\xF4DB" => '&#36694;',
	"\xF4DC" => '&#36695;',
	"\xF4DD" => '&#36693;',
	"\xF4DE" => '&#36696;',
	"\xF4DF" => '&#36698;',
	"\xF4E0" => '&#37005;',
	"\xF4E1" => '&#37187;',
	"\xF4E2" => '&#37185;',
	"\xF4E3" => '&#37303;',
	"\xF4E4" => '&#37301;',
	"\xF4E5" => '&#37298;',
	"\xF4E6" => '&#37299;',
	"\xF4E7" => '&#37899;',
	"\xF4E8" => '&#37907;',
	"\xF4E9" => '&#37883;',
	"\xF4EA" => '&#37920;',
	"\xF4EB" => '&#37903;',
	"\xF4EC" => '&#37908;',
	"\xF4ED" => '&#37886;',
	"\xF4EE" => '&#37909;',
	"\xF4EF" => '&#37904;',
	"\xF4F0" => '&#37928;',
	"\xF4F1" => '&#37913;',
	"\xF4F2" => '&#37901;',
	"\xF4F3" => '&#37877;',
	"\xF4F4" => '&#37888;',
	"\xF4F5" => '&#37879;',
	"\xF4F6" => '&#37895;',
	"\xF4F7" => '&#37902;',
	"\xF4F8" => '&#37910;',
	"\xF4F9" => '&#37906;',
	"\xF4FA" => '&#37882;',
	"\xF4FB" => '&#37897;',
	"\xF4FC" => '&#37880;',
	"\xF4FD" => '&#37898;',
	"\xF4FE" => '&#37887;',
	"\xF540" => '&#37884;',
	"\xF541" => '&#37900;',
	"\xF542" => '&#37878;',
	"\xF543" => '&#37905;',
	"\xF544" => '&#37894;',
	"\xF545" => '&#38366;',
	"\xF546" => '&#38368;',
	"\xF547" => '&#38367;',
	"\xF548" => '&#38702;',
	"\xF549" => '&#38703;',
	"\xF54A" => '&#38841;',
	"\xF54B" => '&#38843;',
	"\xF54C" => '&#38909;',
	"\xF54D" => '&#38910;',
	"\xF54E" => '&#39008;',
	"\xF54F" => '&#39010;',
	"\xF550" => '&#39011;',
	"\xF551" => '&#39007;',
	"\xF552" => '&#39105;',
	"\xF553" => '&#39106;',
	"\xF554" => '&#39248;',
	"\xF555" => '&#39246;',
	"\xF556" => '&#39257;',
	"\xF557" => '&#39244;',
	"\xF558" => '&#39243;',
	"\xF559" => '&#39251;',
	"\xF55A" => '&#39474;',
	"\xF55B" => '&#39476;',
	"\xF55C" => '&#39473;',
	"\xF55D" => '&#39468;',
	"\xF55E" => '&#39466;',
	"\xF55F" => '&#39478;',
	"\xF560" => '&#39465;',
	"\xF561" => '&#39470;',
	"\xF562" => '&#39480;',
	"\xF563" => '&#39469;',
	"\xF564" => '&#39623;',
	"\xF565" => '&#39626;',
	"\xF566" => '&#39622;',
	"\xF567" => '&#39696;',
	"\xF568" => '&#39698;',
	"\xF569" => '&#39697;',
	"\xF56A" => '&#39947;',
	"\xF56B" => '&#39944;',
	"\xF56C" => '&#39927;',
	"\xF56D" => '&#39941;',
	"\xF56E" => '&#39954;',
	"\xF56F" => '&#39928;',
	"\xF570" => '&#40000;',
	"\xF571" => '&#39943;',
	"\xF572" => '&#39950;',
	"\xF573" => '&#39942;',
	"\xF574" => '&#39959;',
	"\xF575" => '&#39956;',
	"\xF576" => '&#39945;',
	"\xF577" => '&#40351;',
	"\xF578" => '&#40345;',
	"\xF579" => '&#40356;',
	"\xF57A" => '&#40349;',
	"\xF57B" => '&#40338;',
	"\xF57C" => '&#40344;',
	"\xF57D" => '&#40336;',
	"\xF57E" => '&#40347;',
	"\xF5A1" => '&#40352;',
	"\xF5A2" => '&#40340;',
	"\xF5A3" => '&#40348;',
	"\xF5A4" => '&#40362;',
	"\xF5A5" => '&#40343;',
	"\xF5A6" => '&#40353;',
	"\xF5A7" => '&#40346;',
	"\xF5A8" => '&#40354;',
	"\xF5A9" => '&#40360;',
	"\xF5AA" => '&#40350;',
	"\xF5AB" => '&#40355;',
	"\xF5AC" => '&#40383;',
	"\xF5AD" => '&#40361;',
	"\xF5AE" => '&#40342;',
	"\xF5AF" => '&#40358;',
	"\xF5B0" => '&#40359;',
	"\xF5B1" => '&#40601;',
	"\xF5B2" => '&#40603;',
	"\xF5B3" => '&#40602;',
	"\xF5B4" => '&#40677;',
	"\xF5B5" => '&#40676;',
	"\xF5B6" => '&#40679;',
	"\xF5B7" => '&#40678;',
	"\xF5B8" => '&#40752;',
	"\xF5B9" => '&#40750;',
	"\xF5BA" => '&#40795;',
	"\xF5BB" => '&#40800;',
	"\xF5BC" => '&#40798;',
	"\xF5BD" => '&#40797;',
	"\xF5BE" => '&#40793;',
	"\xF5BF" => '&#40849;',
	"\xF5C0" => '&#20794;',
	"\xF5C1" => '&#20793;',
	"\xF5C2" => '&#21144;',
	"\xF5C3" => '&#21143;',
	"\xF5C4" => '&#22211;',
	"\xF5C5" => '&#22205;',
	"\xF5C6" => '&#22206;',
	"\xF5C7" => '&#23368;',
	"\xF5C8" => '&#23367;',
	"\xF5C9" => '&#24011;',
	"\xF5CA" => '&#24015;',
	"\xF5CB" => '&#24305;',
	"\xF5CC" => '&#25085;',
	"\xF5CD" => '&#25883;',
	"\xF5CE" => '&#27394;',
	"\xF5CF" => '&#27388;',
	"\xF5D0" => '&#27395;',
	"\xF5D1" => '&#27384;',
	"\xF5D2" => '&#27392;',
	"\xF5D3" => '&#28739;',
	"\xF5D4" => '&#28740;',
	"\xF5D5" => '&#28746;',
	"\xF5D6" => '&#28744;',
	"\xF5D7" => '&#28745;',
	"\xF5D8" => '&#28741;',
	"\xF5D9" => '&#28742;',
	"\xF5DA" => '&#29213;',
	"\xF5DB" => '&#29210;',
	"\xF5DC" => '&#29209;',
	"\xF5DD" => '&#29566;',
	"\xF5DE" => '&#29975;',
	"\xF5DF" => '&#30314;',
	"\xF5E0" => '&#30672;',
	"\xF5E1" => '&#31021;',
	"\xF5E2" => '&#31025;',
	"\xF5E3" => '&#31023;',
	"\xF5E4" => '&#31828;',
	"\xF5E5" => '&#31827;',
	"\xF5E6" => '&#31986;',
	"\xF5E7" => '&#32394;',
	"\xF5E8" => '&#32391;',
	"\xF5E9" => '&#32392;',
	"\xF5EA" => '&#32395;',
	"\xF5EB" => '&#32390;',
	"\xF5EC" => '&#32397;',
	"\xF5ED" => '&#32589;',
	"\xF5EE" => '&#32699;',
	"\xF5EF" => '&#32816;',
	"\xF5F0" => '&#33245;',
	"\xF5F1" => '&#34328;',
	"\xF5F2" => '&#34346;',
	"\xF5F3" => '&#34342;',
	"\xF5F4" => '&#34335;',
	"\xF5F5" => '&#34339;',
	"\xF5F6" => '&#34332;',
	"\xF5F7" => '&#34329;',
	"\xF5F8" => '&#34343;',
	"\xF5F9" => '&#34350;',
	"\xF5FA" => '&#34337;',
	"\xF5FB" => '&#34336;',
	"\xF5FC" => '&#34345;',
	"\xF5FD" => '&#34334;',
	"\xF5FE" => '&#34341;',
	"\xF640" => '&#34857;',
	"\xF641" => '&#34845;',
	"\xF642" => '&#34843;',
	"\xF643" => '&#34848;',
	"\xF644" => '&#34852;',
	"\xF645" => '&#34844;',
	"\xF646" => '&#34859;',
	"\xF647" => '&#34890;',
	"\xF648" => '&#35181;',
	"\xF649" => '&#35177;',
	"\xF64A" => '&#35182;',
	"\xF64B" => '&#35179;',
	"\xF64C" => '&#35322;',
	"\xF64D" => '&#35705;',
	"\xF64E" => '&#35704;',
	"\xF64F" => '&#35653;',
	"\xF650" => '&#35706;',
	"\xF651" => '&#35707;',
	"\xF652" => '&#36112;',
	"\xF653" => '&#36116;',
	"\xF654" => '&#36271;',
	"\xF655" => '&#36494;',
	"\xF656" => '&#36492;',
	"\xF657" => '&#36702;',
	"\xF658" => '&#36699;',
	"\xF659" => '&#36701;',
	"\xF65A" => '&#37190;',
	"\xF65B" => '&#37188;',
	"\xF65C" => '&#37189;',
	"\xF65D" => '&#37305;',
	"\xF65E" => '&#37951;',
	"\xF65F" => '&#37947;',
	"\xF660" => '&#37942;',
	"\xF661" => '&#37929;',
	"\xF662" => '&#37949;',
	"\xF663" => '&#37948;',
	"\xF664" => '&#37936;',
	"\xF665" => '&#37945;',
	"\xF666" => '&#37930;',
	"\xF667" => '&#37943;',
	"\xF668" => '&#37932;',
	"\xF669" => '&#37952;',
	"\xF66A" => '&#37937;',
	"\xF66B" => '&#38373;',
	"\xF66C" => '&#38372;',
	"\xF66D" => '&#38371;',
	"\xF66E" => '&#38709;',
	"\xF66F" => '&#38714;',
	"\xF670" => '&#38847;',
	"\xF671" => '&#38881;',
	"\xF672" => '&#39012;',
	"\xF673" => '&#39113;',
	"\xF674" => '&#39110;',
	"\xF675" => '&#39104;',
	"\xF676" => '&#39256;',
	"\xF677" => '&#39254;',
	"\xF678" => '&#39481;',
	"\xF679" => '&#39485;',
	"\xF67A" => '&#39494;',
	"\xF67B" => '&#39492;',
	"\xF67C" => '&#39490;',
	"\xF67D" => '&#39489;',
	"\xF67E" => '&#39482;',
	"\xF6A1" => '&#39487;',
	"\xF6A2" => '&#39629;',
	"\xF6A3" => '&#39701;',
	"\xF6A4" => '&#39703;',
	"\xF6A5" => '&#39704;',
	"\xF6A6" => '&#39702;',
	"\xF6A7" => '&#39738;',
	"\xF6A8" => '&#39762;',
	"\xF6A9" => '&#39979;',
	"\xF6AA" => '&#39965;',
	"\xF6AB" => '&#39964;',
	"\xF6AC" => '&#39980;',
	"\xF6AD" => '&#39971;',
	"\xF6AE" => '&#39976;',
	"\xF6AF" => '&#39977;',
	"\xF6B0" => '&#39972;',
	"\xF6B1" => '&#39969;',
	"\xF6B2" => '&#40375;',
	"\xF6B3" => '&#40374;',
	"\xF6B4" => '&#40380;',
	"\xF6B5" => '&#40385;',
	"\xF6B6" => '&#40391;',
	"\xF6B7" => '&#40394;',
	"\xF6B8" => '&#40399;',
	"\xF6B9" => '&#40382;',
	"\xF6BA" => '&#40389;',
	"\xF6BB" => '&#40387;',
	"\xF6BC" => '&#40379;',
	"\xF6BD" => '&#40373;',
	"\xF6BE" => '&#40398;',
	"\xF6BF" => '&#40377;',
	"\xF6C0" => '&#40378;',
	"\xF6C1" => '&#40364;',
	"\xF6C2" => '&#40392;',
	"\xF6C3" => '&#40369;',
	"\xF6C4" => '&#40365;',
	"\xF6C5" => '&#40396;',
	"\xF6C6" => '&#40371;',
	"\xF6C7" => '&#40397;',
	"\xF6C8" => '&#40370;',
	"\xF6C9" => '&#40570;',
	"\xF6CA" => '&#40604;',
	"\xF6CB" => '&#40683;',
	"\xF6CC" => '&#40686;',
	"\xF6CD" => '&#40685;',
	"\xF6CE" => '&#40731;',
	"\xF6CF" => '&#40728;',
	"\xF6D0" => '&#40730;',
	"\xF6D1" => '&#40753;',
	"\xF6D2" => '&#40782;',
	"\xF6D3" => '&#40805;',
	"\xF6D4" => '&#40804;',
	"\xF6D5" => '&#40850;',
	"\xF6D6" => '&#20153;',
	"\xF6D7" => '&#22214;',
	"\xF6D8" => '&#22213;',
	"\xF6D9" => '&#22219;',
	"\xF6DA" => '&#22897;',
	"\xF6DB" => '&#23371;',
	"\xF6DC" => '&#23372;',
	"\xF6DD" => '&#24021;',
	"\xF6DE" => '&#24017;',
	"\xF6DF" => '&#24306;',
	"\xF6E0" => '&#25889;',
	"\xF6E1" => '&#25888;',
	"\xF6E2" => '&#25894;',
	"\xF6E3" => '&#25890;',
	"\xF6E4" => '&#27403;',
	"\xF6E5" => '&#27400;',
	"\xF6E6" => '&#27401;',
	"\xF6E7" => '&#27661;',
	"\xF6E8" => '&#28757;',
	"\xF6E9" => '&#28758;',
	"\xF6EA" => '&#28759;',
	"\xF6EB" => '&#28754;',
	"\xF6EC" => '&#29214;',
	"\xF6ED" => '&#29215;',
	"\xF6EE" => '&#29353;',
	"\xF6EF" => '&#29567;',
	"\xF6F0" => '&#29912;',
	"\xF6F1" => '&#29909;',
	"\xF6F2" => '&#29913;',
	"\xF6F3" => '&#29911;',
	"\xF6F4" => '&#30317;',
	"\xF6F5" => '&#30381;',
	"\xF6F6" => '&#31029;',
	"\xF6F7" => '&#31156;',
	"\xF6F8" => '&#31344;',
	"\xF6F9" => '&#31345;',
	"\xF6FA" => '&#31831;',
	"\xF6FB" => '&#31836;',
	"\xF6FC" => '&#31833;',
	"\xF6FD" => '&#31835;',
	"\xF6FE" => '&#31834;',
	"\xF740" => '&#31988;',
	"\xF741" => '&#31985;',
	"\xF742" => '&#32401;',
	"\xF743" => '&#32591;',
	"\xF744" => '&#32647;',
	"\xF745" => '&#33246;',
	"\xF746" => '&#33387;',
	"\xF747" => '&#34356;',
	"\xF748" => '&#34357;',
	"\xF749" => '&#34355;',
	"\xF74A" => '&#34348;',
	"\xF74B" => '&#34354;',
	"\xF74C" => '&#34358;',
	"\xF74D" => '&#34860;',
	"\xF74E" => '&#34856;',
	"\xF74F" => '&#34854;',
	"\xF750" => '&#34858;',
	"\xF751" => '&#34853;',
	"\xF752" => '&#35185;',
	"\xF753" => '&#35263;',
	"\xF754" => '&#35262;',
	"\xF755" => '&#35323;',
	"\xF756" => '&#35710;',
	"\xF757" => '&#35716;',
	"\xF758" => '&#35714;',
	"\xF759" => '&#35718;',
	"\xF75A" => '&#35717;',
	"\xF75B" => '&#35711;',
	"\xF75C" => '&#36117;',
	"\xF75D" => '&#36501;',
	"\xF75E" => '&#36500;',
	"\xF75F" => '&#36506;',
	"\xF760" => '&#36498;',
	"\xF761" => '&#36496;',
	"\xF762" => '&#36502;',
	"\xF763" => '&#36503;',
	"\xF764" => '&#36704;',
	"\xF765" => '&#36706;',
	"\xF766" => '&#37191;',
	"\xF767" => '&#37964;',
	"\xF768" => '&#37968;',
	"\xF769" => '&#37962;',
	"\xF76A" => '&#37963;',
	"\xF76B" => '&#37967;',
	"\xF76C" => '&#37959;',
	"\xF76D" => '&#37957;',
	"\xF76E" => '&#37960;',
	"\xF76F" => '&#37961;',
	"\xF770" => '&#37958;',
	"\xF771" => '&#38719;',
	"\xF772" => '&#38883;',
	"\xF773" => '&#39018;',
	"\xF774" => '&#39017;',
	"\xF775" => '&#39115;',
	"\xF776" => '&#39252;',
	"\xF777" => '&#39259;',
	"\xF778" => '&#39502;',
	"\xF779" => '&#39507;',
	"\xF77A" => '&#39508;',
	"\xF77B" => '&#39500;',
	"\xF77C" => '&#39503;',
	"\xF77D" => '&#39496;',
	"\xF77E" => '&#39498;',
	"\xF7A1" => '&#39497;',
	"\xF7A2" => '&#39506;',
	"\xF7A3" => '&#39504;',
	"\xF7A4" => '&#39632;',
	"\xF7A5" => '&#39705;',
	"\xF7A6" => '&#39723;',
	"\xF7A7" => '&#39739;',
	"\xF7A8" => '&#39766;',
	"\xF7A9" => '&#39765;',
	"\xF7AA" => '&#40006;',
	"\xF7AB" => '&#40008;',
	"\xF7AC" => '&#39999;',
	"\xF7AD" => '&#40004;',
	"\xF7AE" => '&#39993;',
	"\xF7AF" => '&#39987;',
	"\xF7B0" => '&#40001;',
	"\xF7B1" => '&#39996;',
	"\xF7B2" => '&#39991;',
	"\xF7B3" => '&#39988;',
	"\xF7B4" => '&#39986;',
	"\xF7B5" => '&#39997;',
	"\xF7B6" => '&#39990;',
	"\xF7B7" => '&#40411;',
	"\xF7B8" => '&#40402;',
	"\xF7B9" => '&#40414;',
	"\xF7BA" => '&#40410;',
	"\xF7BB" => '&#40395;',
	"\xF7BC" => '&#40400;',
	"\xF7BD" => '&#40412;',
	"\xF7BE" => '&#40401;',
	"\xF7BF" => '&#40415;',
	"\xF7C0" => '&#40425;',
	"\xF7C1" => '&#40409;',
	"\xF7C2" => '&#40408;',
	"\xF7C3" => '&#40406;',
	"\xF7C4" => '&#40437;',
	"\xF7C5" => '&#40405;',
	"\xF7C6" => '&#40413;',
	"\xF7C7" => '&#40630;',
	"\xF7C8" => '&#40688;',
	"\xF7C9" => '&#40757;',
	"\xF7CA" => '&#40755;',
	"\xF7CB" => '&#40754;',
	"\xF7CC" => '&#40770;',
	"\xF7CD" => '&#40811;',
	"\xF7CE" => '&#40853;',
	"\xF7CF" => '&#40866;',
	"\xF7D0" => '&#20797;',
	"\xF7D1" => '&#21145;',
	"\xF7D2" => '&#22760;',
	"\xF7D3" => '&#22759;',
	"\xF7D4" => '&#22898;',
	"\xF7D5" => '&#23373;',
	"\xF7D6" => '&#24024;',
	"\xF7D7" => '&#34863;',
	"\xF7D8" => '&#24399;',
	"\xF7D9" => '&#25089;',
	"\xF7DA" => '&#25091;',
	"\xF7DB" => '&#25092;',
	"\xF7DC" => '&#25897;',
	"\xF7DD" => '&#25893;',
	"\xF7DE" => '&#26006;',
	"\xF7DF" => '&#26347;',
	"\xF7E0" => '&#27409;',
	"\xF7E1" => '&#27410;',
	"\xF7E2" => '&#27407;',
	"\xF7E3" => '&#27594;',
	"\xF7E4" => '&#28763;',
	"\xF7E5" => '&#28762;',
	"\xF7E6" => '&#29218;',
	"\xF7E7" => '&#29570;',
	"\xF7E8" => '&#29569;',
	"\xF7E9" => '&#29571;',
	"\xF7EA" => '&#30320;',
	"\xF7EB" => '&#30676;',
	"\xF7EC" => '&#31847;',
	"\xF7ED" => '&#31846;',
	"\xF7EE" => '&#32405;',
	"\xF7EF" => '&#33388;',
	"\xF7F0" => '&#34362;',
	"\xF7F1" => '&#34368;',
	"\xF7F2" => '&#34361;',
	"\xF7F3" => '&#34364;',
	"\xF7F4" => '&#34353;',
	"\xF7F5" => '&#34363;',
	"\xF7F6" => '&#34366;',
	"\xF7F7" => '&#34864;',
	"\xF7F8" => '&#34866;',
	"\xF7F9" => '&#34862;',
	"\xF7FA" => '&#34867;',
	"\xF7FB" => '&#35190;',
	"\xF7FC" => '&#35188;',
	"\xF7FD" => '&#35187;',
	"\xF7FE" => '&#35326;',
	"\xF840" => '&#35724;',
	"\xF841" => '&#35726;',
	"\xF842" => '&#35723;',
	"\xF843" => '&#35720;',
	"\xF844" => '&#35909;',
	"\xF845" => '&#36121;',
	"\xF846" => '&#36504;',
	"\xF847" => '&#36708;',
	"\xF848" => '&#36707;',
	"\xF849" => '&#37308;',
	"\xF84A" => '&#37986;',
	"\xF84B" => '&#37973;',
	"\xF84C" => '&#37981;',
	"\xF84D" => '&#37975;',
	"\xF84E" => '&#37982;',
	"\xF84F" => '&#38852;',
	"\xF850" => '&#38853;',
	"\xF851" => '&#38912;',
	"\xF852" => '&#39510;',
	"\xF853" => '&#39513;',
	"\xF854" => '&#39710;',
	"\xF855" => '&#39711;',
	"\xF856" => '&#39712;',
	"\xF857" => '&#40018;',
	"\xF858" => '&#40024;',
	"\xF859" => '&#40016;',
	"\xF85A" => '&#40010;',
	"\xF85B" => '&#40013;',
	"\xF85C" => '&#40011;',
	"\xF85D" => '&#40021;',
	"\xF85E" => '&#40025;',
	"\xF85F" => '&#40012;',
	"\xF860" => '&#40014;',
	"\xF861" => '&#40443;',
	"\xF862" => '&#40439;',
	"\xF863" => '&#40431;',
	"\xF864" => '&#40419;',
	"\xF865" => '&#40427;',
	"\xF866" => '&#40440;',
	"\xF867" => '&#40420;',
	"\xF868" => '&#40438;',
	"\xF869" => '&#40417;',
	"\xF86A" => '&#40430;',
	"\xF86B" => '&#40422;',
	"\xF86C" => '&#40434;',
	"\xF86D" => '&#40432;',
	"\xF86E" => '&#40418;',
	"\xF86F" => '&#40428;',
	"\xF870" => '&#40436;',
	"\xF871" => '&#40435;',
	"\xF872" => '&#40424;',
	"\xF873" => '&#40429;',
	"\xF874" => '&#40642;',
	"\xF875" => '&#40656;',
	"\xF876" => '&#40690;',
	"\xF877" => '&#40691;',
	"\xF878" => '&#40710;',
	"\xF879" => '&#40732;',
	"\xF87A" => '&#40760;',
	"\xF87B" => '&#40759;',
	"\xF87C" => '&#40758;',
	"\xF87D" => '&#40771;',
	"\xF87E" => '&#40783;',
	"\xF8A1" => '&#40817;',
	"\xF8A2" => '&#40816;',
	"\xF8A3" => '&#40814;',
	"\xF8A4" => '&#40815;',
	"\xF8A5" => '&#22227;',
	"\xF8A6" => '&#22221;',
	"\xF8A7" => '&#23374;',
	"\xF8A8" => '&#23661;',
	"\xF8A9" => '&#25901;',
	"\xF8AA" => '&#26349;',
	"\xF8AB" => '&#26350;',
	"\xF8AC" => '&#27411;',
	"\xF8AD" => '&#28767;',
	"\xF8AE" => '&#28769;',
	"\xF8AF" => '&#28765;',
	"\xF8B0" => '&#28768;',
	"\xF8B1" => '&#29219;',
	"\xF8B2" => '&#29915;',
	"\xF8B3" => '&#29925;',
	"\xF8B4" => '&#30677;',
	"\xF8B5" => '&#31032;',
	"\xF8B6" => '&#31159;',
	"\xF8B7" => '&#31158;',
	"\xF8B8" => '&#31850;',
	"\xF8B9" => '&#32407;',
	"\xF8BA" => '&#32649;',
	"\xF8BB" => '&#33389;',
	"\xF8BC" => '&#34371;',
	"\xF8BD" => '&#34872;',
	"\xF8BE" => '&#34871;',
	"\xF8BF" => '&#34869;',
	"\xF8C0" => '&#34891;',
	"\xF8C1" => '&#35732;',
	"\xF8C2" => '&#35733;',
	"\xF8C3" => '&#36510;',
	"\xF8C4" => '&#36511;',
	"\xF8C5" => '&#36512;',
	"\xF8C6" => '&#36509;',
	"\xF8C7" => '&#37310;',
	"\xF8C8" => '&#37309;',
	"\xF8C9" => '&#37314;',
	"\xF8CA" => '&#37995;',
	"\xF8CB" => '&#37992;',
	"\xF8CC" => '&#37993;',
	"\xF8CD" => '&#38629;',
	"\xF8CE" => '&#38726;',
	"\xF8CF" => '&#38723;',
	"\xF8D0" => '&#38727;',
	"\xF8D1" => '&#38855;',
	"\xF8D2" => '&#38885;',
	"\xF8D3" => '&#39518;',
	"\xF8D4" => '&#39637;',
	"\xF8D5" => '&#39769;',
	"\xF8D6" => '&#40035;',
	"\xF8D7" => '&#40039;',
	"\xF8D8" => '&#40038;',
	"\xF8D9" => '&#40034;',
	"\xF8DA" => '&#40030;',
	"\xF8DB" => '&#40032;',
	"\xF8DC" => '&#40450;',
	"\xF8DD" => '&#40446;',
	"\xF8DE" => '&#40455;',
	"\xF8DF" => '&#40451;',
	"\xF8E0" => '&#40454;',
	"\xF8E1" => '&#40453;',
	"\xF8E2" => '&#40448;',
	"\xF8E3" => '&#40449;',
	"\xF8E4" => '&#40457;',
	"\xF8E5" => '&#40447;',
	"\xF8E6" => '&#40445;',
	"\xF8E7" => '&#40452;',
	"\xF8E8" => '&#40608;',
	"\xF8E9" => '&#40734;',
	"\xF8EA" => '&#40774;',
	"\xF8EB" => '&#40820;',
	"\xF8EC" => '&#40821;',
	"\xF8ED" => '&#40822;',
	"\xF8EE" => '&#22228;',
	"\xF8EF" => '&#25902;',
	"\xF8F0" => '&#26040;',
	"\xF8F1" => '&#27416;',
	"\xF8F2" => '&#27417;',
	"\xF8F3" => '&#27415;',
	"\xF8F4" => '&#27418;',
	"\xF8F5" => '&#28770;',
	"\xF8F6" => '&#29222;',
	"\xF8F7" => '&#29354;',
	"\xF8F8" => '&#30680;',
	"\xF8F9" => '&#30681;',
	"\xF8FA" => '&#31033;',
	"\xF8FB" => '&#31849;',
	"\xF8FC" => '&#31851;',
	"\xF8FD" => '&#31990;',
	"\xF8FE" => '&#32410;',
	"\xF940" => '&#32408;',
	"\xF941" => '&#32411;',
	"\xF942" => '&#32409;',
	"\xF943" => '&#33248;',
	"\xF944" => '&#33249;',
	"\xF945" => '&#34374;',
	"\xF946" => '&#34375;',
	"\xF947" => '&#34376;',
	"\xF948" => '&#35193;',
	"\xF949" => '&#35194;',
	"\xF94A" => '&#35196;',
	"\xF94B" => '&#35195;',
	"\xF94C" => '&#35327;',
	"\xF94D" => '&#35736;',
	"\xF94E" => '&#35737;',
	"\xF94F" => '&#36517;',
	"\xF950" => '&#36516;',
	"\xF951" => '&#36515;',
	"\xF952" => '&#37998;',
	"\xF953" => '&#37997;',
	"\xF954" => '&#37999;',
	"\xF955" => '&#38001;',
	"\xF956" => '&#38003;',
	"\xF957" => '&#38729;',
	"\xF958" => '&#39026;',
	"\xF959" => '&#39263;',
	"\xF95A" => '&#40040;',
	"\xF95B" => '&#40046;',
	"\xF95C" => '&#40045;',
	"\xF95D" => '&#40459;',
	"\xF95E" => '&#40461;',
	"\xF95F" => '&#40464;',
	"\xF960" => '&#40463;',
	"\xF961" => '&#40466;',
	"\xF962" => '&#40465;',
	"\xF963" => '&#40609;',
	"\xF964" => '&#40693;',
	"\xF965" => '&#40713;',
	"\xF966" => '&#40775;',
	"\xF967" => '&#40824;',
	"\xF968" => '&#40827;',
	"\xF969" => '&#40826;',
	"\xF96A" => '&#40825;',
	"\xF96B" => '&#22302;',
	"\xF96C" => '&#28774;',
	"\xF96D" => '&#31855;',
	"\xF96E" => '&#34876;',
	"\xF96F" => '&#36274;',
	"\xF970" => '&#36518;',
	"\xF971" => '&#37315;',
	"\xF972" => '&#38004;',
	"\xF973" => '&#38008;',
	"\xF974" => '&#38006;',
	"\xF975" => '&#38005;',
	"\xF976" => '&#39520;',
	"\xF977" => '&#40052;',
	"\xF978" => '&#40051;',
	"\xF979" => '&#40049;',
	"\xF97A" => '&#40053;',
	"\xF97B" => '&#40468;',
	"\xF97C" => '&#40467;',
	"\xF97D" => '&#40694;',
	"\xF97E" => '&#40714;',
	"\xF9A1" => '&#40868;',
	"\xF9A2" => '&#28776;',
	"\xF9A3" => '&#28773;',
	"\xF9A4" => '&#31991;',
	"\xF9A5" => '&#34410;',
	"\xF9A6" => '&#34878;',
	"\xF9A7" => '&#34877;',
	"\xF9A8" => '&#34879;',
	"\xF9A9" => '&#35742;',
	"\xF9AA" => '&#35996;',
	"\xF9AB" => '&#36521;',
	"\xF9AC" => '&#36553;',
	"\xF9AD" => '&#38731;',
	"\xF9AE" => '&#39027;',
	"\xF9AF" => '&#39028;',
	"\xF9B0" => '&#39116;',
	"\xF9B1" => '&#39265;',
	"\xF9B2" => '&#39339;',
	"\xF9B3" => '&#39524;',
	"\xF9B4" => '&#39526;',
	"\xF9B5" => '&#39527;',
	"\xF9B6" => '&#39716;',
	"\xF9B7" => '&#40469;',
	"\xF9B8" => '&#40471;',
	"\xF9B9" => '&#40776;',
	"\xF9BA" => '&#25095;',
	"\xF9BB" => '&#27422;',
	"\xF9BC" => '&#29223;',
	"\xF9BD" => '&#34380;',
	"\xF9BE" => '&#36520;',
	"\xF9BF" => '&#38018;',
	"\xF9C0" => '&#38016;',
	"\xF9C1" => '&#38017;',
	"\xF9C2" => '&#39529;',
	"\xF9C3" => '&#39528;',
	"\xF9C4" => '&#39726;',
	"\xF9C5" => '&#40473;',
	"\xF9C6" => '&#29225;',
	"\xF9C7" => '&#34379;',
	"\xF9C8" => '&#35743;',
	"\xF9C9" => '&#38019;',
	"\xF9CA" => '&#40057;',
	"\xF9CB" => '&#40631;',
	"\xF9CC" => '&#30325;',
	"\xF9CD" => '&#39531;',
	"\xF9CE" => '&#40058;',
	"\xF9CF" => '&#40477;',
	"\xF9D0" => '&#28777;',
	"\xF9D1" => '&#28778;',
	"\xF9D2" => '&#40612;',
	"\xF9D3" => '&#40830;',
	"\xF9D4" => '&#40777;',
	"\xF9D5" => '&#40856;');

    $index=0;
    $ret="";

    while ( $index < strlen($string)) {
        if ( ereg("[\241-\364]", $string[$index])) {
            $ret.= str_replace(array_keys($mac_chintrad), array_values($mac_chintrad), $string[$index] . $string[$index+1]);
            $index=$index+2;
        } else {
            $ret.= $string[$index];
            $index=$index+1;
        }
    }

    return $ret;
}
