<?php

/***************************************************************************\
 *  SPIP, Système de publication pour l'internet                           *
 *                                                                         *
 *  Copyright © avec tendresse depuis 2001                                 *
 *  Arnaud Martin, Antoine Pitrou, Philippe Rivière, Emmanuel Saint-James  *
 *                                                                         *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.     *
\***************************************************************************/

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

function formulaires_importer_sites_charger_dist() {

	if (!autoriser('importer', '_sites')) {
		return false;
	}

	return [
		'fichier_import' => 0,
		'id_parent' => 0,
		'importer_statut_publie' => 0,
		'importer_les_tags' => 1,
	];
}

function formulaires_importer_sites_verifier_dist() {
	$erreurs = [];

	if (!_request('id_parent')) {
		$erreurs['id_parent'] = _T('info_obligatoire');
	}

	$fichier_ok = info_fichiers_import('fichier_import');
	if (!$fichier_ok) {
		$erreurs['fichier_import'] = _T('sites:erreur_fichier_incorrect');
	} elseif (!charger_fonction('importer_bookmarks_' . $fichier_ok['format'], 'action', true)) {
		$erreurs['fichier_import'] = _T(
			'sites:erreur_fichier_format_inconnu',
			['fichier' => '<tt>' . $fichier_ok['name'] . '</tt>']
		);
	}

	return $erreurs;
}

function formulaires_importer_sites_traiter_dist() {
	$id_parent = intval(_request('id_parent'));
	$importer_statut_publie = _request('importer_statut_publie') ? true : false;
	$importer_tags = _request('importer_les_tags') ? true : false;
	$fichier_ok = info_fichiers_import('fichier_import');

	$importer_bookmarks = charger_fonction('importer_bookmarks_' . $fichier_ok['format'], 'action');
	$nb = $importer_bookmarks($fichier_ok, $id_parent, $importer_statut_publie, $importer_tags);

	if (!$nb) {
		$res = ['message_erreur' => _T('sites:info_aucun_site_importe')];
	} else {
		$res = [
			'message_ok' => singulier_ou_pluriel($nb, 'sites:info_1_site_importe', 'sites:info_nb_sites_importes')
		];
	}

	return $res;
}

function info_fichiers_import($name) {
	static $fichier_ok = [];

	if (!isset($fichier_ok[$name])) {
		if (
			sizeof($_FILES) < 0
			or !isset($_FILES[$name])
			or !$_FILES[$name]['size'] > 0
		) {
			return false;
		}

		if ($_FILES[$name]['error'] != 0) {
			return false;
		}

		$fichier_ok[$name] = [];
		$fichier_ok[$name]['name'] = $_FILES[$name]['name'];
		$fichier_ok[$name]['chemin'] = $_FILES[$name]['tmp_name'];

		// On r�cup�re le contenu du fichier
		$fichier_ok[$name]['format'] = '';
		lire_fichier($fichier_ok[$name]['chemin'], $fichier_ok[$name]['contenu']);
		if (stripos($fichier_ok[$name]['contenu'], 'NETSCAPE-Bookmark-file') !== false) {
			$fichier_ok[$name]['format'] = 'netscape';
		}
		if ($_FILES[$name]['type'] == 'text/xml' and stripos($fichier_ok[$name]['contenu'], 'opml') !== false) {
			$fichier_ok[$name]['format'] = 'opml';
		}
	}

	return $fichier_ok[$name];
}
