-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--WriteVCInfo procedure for VCS package.                                      --
--                                                                            --
--------------------------------------------------------------------------------
separate (VCS)
procedure WriteVCInfo (Report_File                : in     SPARK_IO.File_Type;
                       VC_Info                    : in     VC_Info_Type;
                       Anything_Printed_This_Time :    out Boolean) is

   procedure Print_Line_Number (Report_File   : in SPARK_IO.File_Type;
                                Line_Number   : in VC_Line_Type;
                                Start_Of_Line : in Boolean)
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Line_Number,
   --#                                Report_File,
   --#                                Start_Of_Line;
   is
      Width : Natural;
   begin
      if Line_Number = VC_Line_Start then
         SPARK_IO.Put_String (Report_File, "start", 0);
      elsif Line_Number = VC_Line_End then
         SPARK_IO.Put_String (Report_File, "finish", 0);
      else
         if Start_Of_Line then
            Width := 5;
         else
            Width := 0;
         end if;
         SPARK_IO.Put_Integer (Report_File, Line_Number, Width, 10);
      end if;
   end Print_Line_Number;

begin -- WriteVCInfo
   if VC_Info.Number_Of_VCs > 0 then
      Anything_Printed_This_Time := True;

      if VC_Info.File_Type = Simplified_VC_File_Type and not VC_Info.Any_VCs_Printed then

         SPARK_IO.New_Line (Report_File, 1);
         SPARK_IO.Put_Line (Report_File, "Undischarged VCs remain for lines:", 0);
      end if;

      if not VC_Info.This_Start_Line_Printed or else SPARK_IO.Col (Report_File) > Report_Wrap_Column then
         SPARK_IO.New_Line (Report_File, 1);
         -- write new start line
         Print_Line_Number (Report_File   => Report_File,
                            Line_Number   => VC_Info.Start_Line,
                            Start_Of_Line => True);
         SPARK_IO.Put_String (Report_File, " to: ", 0);
      else
         SPARK_IO.Put_String (Report_File, ", ", 0);
      end if;

      -- write last line of range
      Print_Line_Number (Report_File   => Report_File,
                         Line_Number   => VC_Info.End_Line,
                         Start_Of_Line => False);
      -- print VC count
      SPARK_IO.Put_Char (Report_File, '(');
      SPARK_IO.Put_Integer (Report_File, VC_Info.Number_Of_VCs, 0, 10);
      SPARK_IO.Put_Char (Report_File, ')');
   else
      Anything_Printed_This_Time := False;
   end if;
end WriteVCInfo;
