/*
 * Test program for parsing nodelists from strings
 */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "nodespec.h"

int main(int ac, char **av)
{
	struct nodespec *ns_head, *cur;

	while (--ac) {
		printf("\"%s\": ", *++av);

		ns_head = parse_nodelist(*av);

		for (cur = ns_head; cur; cur = cur->next) {
			printf("%s%u", cur == ns_head ? "" : ",", cur->start);
			if (cur->start != cur->end)
				printf("-%u", cur->end);
		}

		printf("%s\n", ns_head ? "\n" : "FAILED");
		free_nodespec(ns_head);
	}

	return EXIT_SUCCESS;
}
