---
name: Bug report
about: Create a report to help us improve SLEEF
title: ''
labels: ''
---

**Describe the bug**
A clear and concise description of what the bug is.

**Command lines and logs**
 - CMake configuration AND build command
 - CMake configuration logs
 - CMake build logs (only the relevant part)

**To Reproduce**
Always try to provide a minimal reproducer, wherever possible.
 - Link to a [Compiler Explorer](https://godbolt.org/) reproducer, if applicable.
 - Provide source code for reproducer along with command used to build and run reproducer.

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
Consider attaching screenshots to help explain your problem.

**Environment**
 - Is it a native build or cross-compilation?
 - Host/Target Architecture [e.g. x86_64 if native build, x86_64/aarch64 if cross build, ..]
 - OS with version [e.g. Linux/Ubuntu-22.04, Windows, macOS, iOS, ...]
 - CMake version [e.g. 3.18, ...]
 - Makefile Generator [e.g. GNU Make, Ninja, ...]
 - Compiler with version [e.g. gcc-14, clang-18, apple-clang-15.2, msvc-15.0, ...]
 - If CUDA, please provide the version of the CUDA ToolKit.

**Additional context**
Add any other context about the problem here.

