/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file defines the main of an application.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skguniqueapplication.h"

#include <KStandardDirs>
#include <KDE/KLocale>
#include <KSplashScreen>
#include <KConfigGroup>
#include <KCmdLineArgs>

#include <QTimer>
#include <QBitmap>

#include "skgtraces.h"
#include "skgmainpanel.h"

SKGUniqueApplication::SKGUniqueApplication(SKGDocument* iDoc) : KUniqueApplication(), m_splash(NULL), m_doc(iDoc), m_widget(NULL)
{
    SKGTRACEIN(1, "SKGUniqueApplication::SKGUniqueApplication");
//    setAttribute(Qt::AA_DontUseNativeMenuBar, !SKGServices::getenv("SKGNATIVEMENU").isEmpty());

    m_timer.setSingleShot(true);
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(closeSpashScreen()), Qt::QueuedConnection);
}

/**
 * Destructor
 */
SKGUniqueApplication::~SKGUniqueApplication()
{
    SKGTRACEIN(1, "SKGUniqueApplication::~SKGUniqueApplication");
    m_splash = NULL;
    m_doc = NULL;
    m_widget = NULL;
}

/**
 * Create a new instance
 * @return error code
 */
int SKGUniqueApplication::newInstance()
{
    SKGTRACEIN(1, "SKGUniqueApplication::newInstance");

    // Build list of arguments
    QStringList argument;
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    int nb = args->count();
    for (int i = 0; i < nb ; ++i) {
        argument.push_back(args->arg(i));
    }
    args->clear();  // Free up some memory.

    // Build widget
    if (!m_widget) {
        // Creation splash screen
        KConfigGroup pref = SKGMainPanel::getMainConfigGroup();
        if (pref.readEntry("show_splash_screen", true)) {
            QString splashPathRelativePath = KGlobal::mainComponent().aboutData()->appName() % "/images/splash.png";
            QString splashPath = KStandardDirs::locate("data", splashPathRelativePath.toLatin1());
            if (!splashPath.isEmpty()) {
                QPixmap pix(splashPath);

                m_splash = new KSplashScreen(pix);
                if (m_splash) {
                    m_splash->setMask(pix.createMaskFromColor(Qt::blue));
                    m_splash->show();
                    m_splash->showMessage(i18nc("Splash screen message", "Loading ..."), Qt::AlignLeft, QColor(221, 130, 8));  // krazy:exclude=qmethods
                }
            } else {
                SKGTRACE << "WARNING: Splash screen (" << splashPathRelativePath << ") not found !" << endl;
            }
        }

        // First instance
        m_widget = new SKGMainPanel(m_splash, m_doc, argument);
        m_widget->setUnifiedTitleAndToolBarOnMac(true);
        m_widget->show();
    } else {
        // Set new parameters
        m_widget->processArguments(argument);
    }

    if (m_splash) {
        SKGTRACEIN(1, "SKGUniqueApplication::newInstance-finish splash screen");

        m_splash->clearMessage();
        // m_splash->finish(m_widget); wait 2s
        m_timer.start(300);
    }

    return 0;
}

void SKGUniqueApplication::closeSpashScreen()
{
    if (m_splash) {
        delete m_splash;
        m_splash = NULL;
    }
}

#include "skguniqueapplication.moc"
