# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** pot file generation

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/src_po4a_share.rb;hb=HEAD>

=end
#module SiSU_SStm_AO_SStm
module SiSU_Languages_Selected
  require_relative 'utils_response'                   # utils_response.rb
  def language
    def sisu_languages_available
      Px[:lng_lst]
    end
    def source_language_selected_str
      @opt.act[:po4a_lang][:src] \
      ? @opt.act[:po4a_lang][:src]
      : 'en'
    end
    def translation_languages_selected
      @opt.act[:po4a_lang][:trn] \
      ? @opt.act[:po4a_lang][:trn]
      : []
    end
    def translation_languages_available
      sisu_languages_available - [source_language_selected_str]
    end
    def translation_languages_selected_that_are_available
      translation_languages_selected & sisu_languages_available
    end
    def translation_languages_selected_that_are_available_str
      translation_languages_selected_that_are_available.join(' ')
    end
    def translation_languages_selected_str
      @opt.act[:po4a_lang][:trn].join(' ')
    end
    self
  end
end
module SiSU_Po4a_Project
  class Po4aCfg
    include SiSU_Composite_Doc_Utils                    # composite doc, .ssm, extract all related insert files, array of filenames test
    include SiSU_Response
    include SiSU_Languages_Selected
    def initialize(opt,file)
      @opt,@file=opt,file
    end
    def song
      if @opt.lng==language.source_language_selected_str
        ans=response?('po4a config file')
        if ans
          po4a_cfg
        end
      end
    end
    def po4a_cfg_filename
      'po4a.cfg'
    end
    def dir
      def pwd
        Dir.pwd
      end
      def po4a_
        'po4a/' # ''
      end
      def pot
        #po4a_ + 'pot'
        'pot'
      end
      def po
        #po4a_ + 'po'
        'po'
      end
      self
    end
    def po4a_cfg_file
      File.open("#{Dir.pwd}/#{po4a_cfg_filename}",'w')
    end
    def po4a_cfg
      lng=language.source_language_selected_str
      doc_import_list=composite_and_imported_filenames_array(@opt.fno)
      po4a_cfg_arr=[]
      po4a_cfg_arr \
        << "[po4a_langs] #{language.translation_languages_selected_that_are_available_str}"
      po4a_cfg_arr \
        << "[po4a_paths] #{dir.pot}/$master.pot $lang:#{dir.po}/$lang/$master.po"
      doc_import_list.each do |file_src|
        file_src_fn=
          file_src.gsub(/#{language.source_language_selected_str}\//,'')
        po4a_cfg_arr \
          << "[type: text] #{lng}/#{file_src} $lang:$lang/#{file_src_fn}"
      end
      file=@file.write_file.po4a_cfg
      po4a_cfg_arr.each do |txt|
      puts txt
        file << txt << "\n"
      end
      file.close
    end
  end
  class Po4aProject
    include SiSU_Languages_Selected
    include SiSU_Response
    def initialize(opt,file)
      @opt,@file=opt,file
    end
    def song
      make_paths
      if FileTest.directory?(@file.output_path.po4a.dir)
        Dir.chdir(@file.output_path.po4a.dir)
        dirs=Dir['*/']
        dirs_language=[]
        dirs.each do |x|
          dirs_language << x.gsub(/\/$/,'')
        end
        dirs_translation = \
          (language.translation_languages_available & dirs_language)
      end
      if (language.translation_languages_available & [@opt.lng]).length == 1
        puts %{gettext for: #{dirs_translation}
in #{Dir.pwd}}
        ans=response?('gettext?')
        if ans
          gettext_if_any_build_src_trans_po
        end
      end
      ans=response?('build project?')
      if ans
        build_src_master_to_pot_and_po_and_srcs
      end
    end
    def flags
      def debug
        '-d -v'
      end
      def normal
        ''
      end
      def quiet
        '-q'
      end
      self
    end
    def build_src_master_to_pot_and_po_and_srcs
      if SiSU_Sys_Call::SystemCall.new.po4a
        pwd=Dir.pwd
        #cmd='po4a --keep 0 -M UTF-8 --no-backups ' \
        #+ '--package-name ' \
        #+ 'sisu-manual' + ' ' \
        #+ flags.normal + ' ' \
        #+ filename.po4a_cfg
        cmd='po4a --keep 0 -M UTF-8' \
        + flags.normal + ' ' \
        + @file.base_filename.po4a_cfg
        Dir.chdir(@file.output_path.po4a.dir)
        system("
          cd #{@file.output_path.po4a.dir}
          #{cmd}
          cd -
        "); puts cmd
        Dir.chdir(pwd)
      end
    end
    def gettext_if_any_build_src_trans_po
        Dir.chdir(@file.output_path.po4a.dir)
        dirs=Dir['*/']
        dirs_language=[]
        dirs.each do |x|
          dirs_language << x.gsub(/\/$/,'')
        end
        dirs_translation = \
          (language.translation_languages_available & dirs_language)
        files_src=Dir.glob("./#{source_language_selected_str}/*.ss[tmi]")
        dirs_translation.each do |lng|
          files_src.each do |file|
            fn=file.gsub(/\.\/#{source_language_selected_str}\//,'')
            system("
              po4a-gettextize -f text -M utf-8 \
              -m ./#{source_language_selected_str}/#{fn} \
              -l ./#{lng}/#{fn} \
              -p ./po/#{lng}/#{fn}.po
            ")
            puts fn
          end
        end
    end
    def dir_mk(dir)
      unless FileTest.directory?(dir)
        FileUtils::mkdir_p(dir)
      end
    end
    def make_paths
      dir_mk(@file.output_path.pot.dir)
      dir_mk(@file.output_path.po.dir)
    end
    def clean
      #rm -f po/*/*.po~
      #rm -rf ../build
      FileUtils.rm_f Dir.glob("./#{dir.po}/*/*.po~")
    end
    def distclean
      #rm -f po4a.cfg
      #rm -rf $(LANGUAGES)
      FileUtils::rm_f(filename.po4a_cfg)
      FileUtils::rm_r(language.possible_translations,:force => true)
      #FileUtils::rm_r(language.translation_languages_selected_that_are_available,:force => true)
    end
  end
  class Po4aDistClean
    include SiSU_Languages_Selected
    include SiSU_Response
    def initialize(opt,file)
      @opt,@file=opt,file
    end
    def song
      pwd=Dir.pwd
      if FileTest.directory?(@file.output_path.po4a.dir)
        Dir.chdir(@file.output_path.po4a.dir)
        dirs=Dir['*/']
        dirs_language=[]
        dirs.each do |x|
          dirs_language << x.gsub(/\/$/,'')
        end
        dirs_translation = \
          (language.translation_languages_available & dirs_language)
        if dirs_translation.length > 0
          puts %{remove language translation directorie(s): #{dirs_translation}
in #{Dir  .pwd}}
          ans=response?('disclean?')
          if ans
            FileUtils::rm_f(@file.base_filename.po4a_cfg)
            FileUtils::rm_r(dirs_translation,:force => true)
            #FileUtils::rm_r(language.translation_languages_available,:force => true)
          end
        end
        Dir.chdir(pwd)
      end
    end
  end
end
#end
__END__
REMOVE
&#033;\|&#035;\|&&#042;\|&#045;\|&#047;\|&#095;\|&#123;\|&#125;\|&#126;\|&#

tables are problematic, difficult to reconstitute instruction, check

metadata, move to top? and work on

footnotes, different types, asterisk, also do you want to have separate
paragraphs, or breaks within one block?

where no ocn appropriately use ~# or -# or indeed 1~name-

comments in document, what to do about them, not sure they are currently
retained in dal, could be quite valuable to keep

Translate Shell
http://www.soimort.org/translate-shell/
translate.google.com
