# -- Determine the version of OSX
# -- 8 and less are OSX 10.0 - 10.4
# -- 9 is 10.5 (LEOPARD)
IF (APPLE)
  EXEC_PROGRAM(uname ARGS -r  OUTPUT_VARIABLE DARWIN_VERSION)
  STRING(REGEX MATCH "[0-9]+" DARWIN_VERSION ${DARWIN_VERSION})
  MESSAGE(STATUS "DARWIN_VERSION=${DARWIN_VERSION}")
  IF (DARWIN_VERSION GREATER 9)
    SET(APPLE_SNOW_LEOPARD 1 INTERNAL)
    ADD_DEFINITIONS(-DAPPLE_SNOW_LEOPARD)
  ELSEIF(DARWIN_VERSION GREATER 8)
    SET(APPLE_LEOPARD 1 INTERNAL)
    ADD_DEFINITIONS(-DAPPLE_LEOPARD)
  ENDIF ()
ENDIF(APPLE)

