/************************************************************************
 *
 * Copyright (C) 2023-2024 IRCAD France
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

// This file was automatically generated by the '/libs/core/data/dicom/class_generator.py' script. DO NOT EDIT !
// Used arguments: 'Namespace(verbose=False, source_url='http://dicom.nema.org/medical/dicom/current/source/docbook',
// sop_list=None, mandatory_tags=[Tag(group='7FE0', element='0010'), Tag(group='0062', element='0002'),
// Tag(group='0066', element='0002'), Tag(group='0066', element='0011'), Tag(group='0070', element='031C')])'

#include "data/dicom/attribute.hpp"

#include <core/exceptionmacros.hpp>

// cspell: ignore Wundefined afterloader angio autorefraction autosequence boli bscan cadsr ciexy ctdi ctdivol decf
// cspell: ignore deidentification dermoscopic diconde dicos dvhroi exif fiducials fluence fnumber frameof gpsdop hicpp
// cspell: ignore hpgl imager inms inua inus iods isop ivol ivus keratoconus keratometer keratometric kerma lensometry
// cspell: ignore lookat meterset metersets mrfov multiway nmpet nmtomo nolintbegin nolintend octb octz oecf olink
// cspell: ignore postamble powerline prcs presaturation radiofluoroscopic relaxivity reprojection rgblut rtdvh rtroi
// cspell: ignore sddn sdhn sdvn softcopy soundpath stereometric stowrs tlhc tomo tomosynthesis tomotherapeutic toric
// cspell: ignore tractography xaxrf Ascan Framek

// NOLINTBEGIN

namespace sight::data::dicom::attribute
{

//------------------------------------------------------------------------------

template<Keyword keyword>
inline static const Attribute<keyword>& get()
{
    static constexpr Attribute<keyword> instance;
    return instance;
}

//------------------------------------------------------------------------------

template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecificCharacterSet>::s_keyword = Keyword::SpecificCharacterSet;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecificCharacterSet>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecificCharacterSet>::s_element = 0x0005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecificCharacterSet>::s_name = "Specific Character Set";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecificCharacterSet>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecificCharacterSet>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LanguageCodeSequence>::s_keyword = Keyword::LanguageCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LanguageCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LanguageCodeSequence>::s_element = 0x0006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LanguageCodeSequence>::s_name = "Language Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LanguageCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LanguageCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageType>::s_keyword = Keyword::ImageType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageType>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageType>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageType>::s_name = "Image Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageType>::s_vm = VM::MIN_2_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstanceCreationDate>::s_keyword = Keyword::InstanceCreationDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreationDate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreationDate>::s_element = 0x0012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstanceCreationDate>::s_name = "Instance Creation Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstanceCreationDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstanceCreationDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstanceCreationTime>::s_keyword = Keyword::InstanceCreationTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreationTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreationTime>::s_element = 0x0013;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstanceCreationTime>::s_name = "Instance Creation Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstanceCreationTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstanceCreationTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstanceCreatorUID>::s_keyword = Keyword::InstanceCreatorUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreatorUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCreatorUID>::s_element = 0x0014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstanceCreatorUID>::s_name = "Instance Creator UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstanceCreatorUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstanceCreatorUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstanceCoercionDateTime>::s_keyword = Keyword::InstanceCoercionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCoercionDateTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceCoercionDateTime>::s_element = 0x0015;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstanceCoercionDateTime>::s_name = "Instance Coercion DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstanceCoercionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstanceCoercionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::sop_classUID>::s_keyword = Keyword::sop_classUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::sop_classUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::sop_classUID>::s_element = 0x0016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::sop_classUID>::s_name = "SOP Class UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::sop_classUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::sop_classUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionUID>::s_keyword = Keyword::AcquisitionUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionUID>::s_element = 0x0017;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionUID>::s_name = "Acquisition UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SOPInstanceUID>::s_keyword = Keyword::SOPInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SOPInstanceUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SOPInstanceUID>::s_element = 0x0018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SOPInstanceUID>::s_name = "SOP Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SOPInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SOPInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PyramidUID>::s_keyword = Keyword::PyramidUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidUID>::s_element = 0x0019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PyramidUID>::s_name = "Pyramid UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PyramidUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PyramidUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RelatedGeneralsop_classUID>::s_keyword = Keyword::RelatedGeneralsop_classUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelatedGeneralsop_classUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelatedGeneralsop_classUID>::s_element = 0x001A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RelatedGeneralsop_classUID>::s_name =
    "Related General SOP Class UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RelatedGeneralsop_classUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RelatedGeneralsop_classUID>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OriginalSpecializedsop_classUID>::s_keyword =
    Keyword::OriginalSpecializedsop_classUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OriginalSpecializedsop_classUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OriginalSpecializedsop_classUID>::s_element = 0x001B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OriginalSpecializedsop_classUID>::s_name =
    "Original Specialized SOP Class UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OriginalSpecializedsop_classUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OriginalSpecializedsop_classUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudyDate>::s_keyword = Keyword::StudyDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyDate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyDate>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudyDate>::s_name = "Study Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudyDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudyDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesDate>::s_keyword = Keyword::SeriesDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDate>::s_element = 0x0021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesDate>::s_name = "Series Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDate>::s_keyword = Keyword::AcquisitionDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDate>::s_element = 0x0022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDate>::s_name = "Acquisition Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContentDate>::s_keyword = Keyword::ContentDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentDate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentDate>::s_element = 0x0023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContentDate>::s_name = "Content Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContentDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContentDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDateTime>::s_keyword = Keyword::AcquisitionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDateTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDateTime>::s_element = 0x002A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDateTime>::s_name = "Acquisition DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudyTime>::s_keyword = Keyword::StudyTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyTime>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudyTime>::s_name = "Study Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudyTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudyTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesTime>::s_keyword = Keyword::SeriesTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesTime>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesTime>::s_name = "Series Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionTime>::s_keyword = Keyword::AcquisitionTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTime>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionTime>::s_name = "Acquisition Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContentTime>::s_keyword = Keyword::ContentTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentTime>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentTime>::s_element = 0x0033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContentTime>::s_name = "Content Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContentTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContentTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AccessionNumber>::s_keyword = Keyword::AccessionNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AccessionNumber>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AccessionNumber>::s_element = 0x0050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AccessionNumber>::s_name = "Accession Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AccessionNumber>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AccessionNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_keyword =
    Keyword::IssuerOfAccessionNumberSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_element = 0x0051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_name =
    "Issuer of Accession Number Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfAccessionNumberSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::QueryRetrieveView>::s_keyword = Keyword::QueryRetrieveView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QueryRetrieveView>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QueryRetrieveView>::s_element = 0x0053;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::QueryRetrieveView>::s_name = "Query/Retrieve view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::QueryRetrieveView>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::QueryRetrieveView>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RetrieveAETitle>::s_keyword = Keyword::RetrieveAETitle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetrieveAETitle>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetrieveAETitle>::s_element = 0x0054;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RetrieveAETitle>::s_name = "Retrieve AE Title";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RetrieveAETitle>::s_vr = VR::AE;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RetrieveAETitle>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StationAETitle>::s_keyword = Keyword::StationAETitle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StationAETitle>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StationAETitle>::s_element = 0x0055;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StationAETitle>::s_name = "Station AE Title";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StationAETitle>::s_vr = VR::AE;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StationAETitle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Modality>::s_keyword = Keyword::Modality;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Modality>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Modality>::s_element = 0x0060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Modality>::s_name = "Modality";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Modality>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Modality>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConversionType>::s_keyword = Keyword::ConversionType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConversionType>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConversionType>::s_element = 0x0064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConversionType>::s_name = "Conversion Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConversionType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConversionType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PresentationIntentType>::s_keyword = Keyword::PresentationIntentType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PresentationIntentType>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PresentationIntentType>::s_element = 0x0068;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PresentationIntentType>::s_name = "Presentation Intent Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PresentationIntentType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PresentationIntentType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Manufacturer>::s_keyword = Keyword::Manufacturer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Manufacturer>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Manufacturer>::s_element = 0x0070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Manufacturer>::s_name = "Manufacturer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Manufacturer>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Manufacturer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstitutionName>::s_keyword = Keyword::InstitutionName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionName>::s_element = 0x0080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstitutionName>::s_name = "Institution Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstitutionName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstitutionName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstitutionAddress>::s_keyword = Keyword::InstitutionAddress;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionAddress>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionAddress>::s_element = 0x0081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstitutionAddress>::s_name = "Institution Address";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstitutionAddress>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstitutionAddress>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstitutionCodeSequence>::s_keyword = Keyword::InstitutionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionCodeSequence>::s_element = 0x0082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstitutionCodeSequence>::s_name = "Institution Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstitutionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstitutionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferringPhysicianName>::s_keyword = Keyword::ReferringPhysicianName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferringPhysicianName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferringPhysicianName>::s_element = 0x0090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferringPhysicianName>::s_name = "Referring Physician's Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferringPhysicianName>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferringPhysicianName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_keyword =
    Keyword::ReferringPhysicianIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_element = 0x0096;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_name =
    "Referring Physician Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferringPhysicianIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConsultingPhysicianName>::s_keyword = Keyword::ConsultingPhysicianName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsultingPhysicianName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsultingPhysicianName>::s_element = 0x009C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConsultingPhysicianName>::s_name = "Consulting Physician's Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConsultingPhysicianName>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConsultingPhysicianName>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_keyword =
    Keyword::ConsultingPhysicianIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_element = 0x009D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_name =
    "Consulting Physician Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConsultingPhysicianIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodeValue>::s_keyword = Keyword::CodeValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodeValue>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodeValue>::s_element = 0x0100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodeValue>::s_name = "Code Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodeValue>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodeValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeDesignator>::s_keyword = Keyword::CodingSchemeDesignator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeDesignator>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeDesignator>::s_element = 0x0102;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeDesignator>::s_name = "Coding Scheme Designator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeDesignator>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeDesignator>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeVersion>::s_keyword = Keyword::CodingSchemeVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeVersion>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeVersion>::s_element = 0x0103;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeVersion>::s_name = "Coding Scheme Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeVersion>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodeMeaning>::s_keyword = Keyword::CodeMeaning;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodeMeaning>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodeMeaning>::s_element = 0x0104;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodeMeaning>::s_name = "Code Meaning";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodeMeaning>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodeMeaning>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MappingResource>::s_keyword = Keyword::MappingResource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResource>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResource>::s_element = 0x0105;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MappingResource>::s_name = "Mapping Resource";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MappingResource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MappingResource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextGroupVersion>::s_keyword = Keyword::ContextGroupVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupVersion>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupVersion>::s_element = 0x0106;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextGroupVersion>::s_name = "Context Group Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextGroupVersion>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextGroupVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextGroupLocalVersion>::s_keyword = Keyword::ContextGroupLocalVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupLocalVersion>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupLocalVersion>::s_element = 0x0107;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextGroupLocalVersion>::s_name = "Context Group Local Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextGroupLocalVersion>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextGroupLocalVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeResourcesSequence>::s_keyword =
    Keyword::CodingSchemeResourcesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeResourcesSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeResourcesSequence>::s_element = 0x0109;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeResourcesSequence>::s_name =
    "Coding Scheme Resources Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeResourcesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeResourcesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextGroupExtensionFlag>::s_keyword = Keyword::ContextGroupExtensionFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupExtensionFlag>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupExtensionFlag>::s_element = 0x010B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextGroupExtensionFlag>::s_name = "Context Group Extension Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextGroupExtensionFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextGroupExtensionFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeUID>::s_keyword = Keyword::CodingSchemeUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeUID>::s_element = 0x010C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeUID>::s_name = "Coding Scheme UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_keyword =
    Keyword::ContextGroupExtensionCreatorUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_element = 0x010D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_name =
    "Context Group Extension Creator UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextGroupExtensionCreatorUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextIdentifier>::s_keyword = Keyword::ContextIdentifier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextIdentifier>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextIdentifier>::s_element = 0x010F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextIdentifier>::s_name = "Context Identifier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextIdentifier>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextIdentifier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeIdentificationSequence>::s_keyword =
    Keyword::CodingSchemeIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeIdentificationSequence>::s_element = 0x0110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeIdentificationSequence>::s_name =
    "Coding Scheme Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeRegistry>::s_keyword = Keyword::CodingSchemeRegistry;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeRegistry>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeRegistry>::s_element = 0x0112;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeRegistry>::s_name = "Coding Scheme Registry";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeRegistry>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeRegistry>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeExternalID>::s_keyword = Keyword::CodingSchemeExternalID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeExternalID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeExternalID>::s_element = 0x0114;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeExternalID>::s_name = "Coding Scheme External ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeExternalID>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeExternalID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeName>::s_keyword = Keyword::CodingSchemeName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeName>::s_element = 0x0115;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeName>::s_name = "Coding Scheme Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeName>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_keyword =
    Keyword::CodingSchemeResponsibleOrganization;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_element = 0x0116;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_name =
    "Coding Scheme Responsible Organization";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CodingSchemeResponsibleOrganization>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextUID>::s_keyword = Keyword::ContextUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextUID>::s_element = 0x0117;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextUID>::s_name = "Context UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MappingResourceUID>::s_keyword = Keyword::MappingResourceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceUID>::s_element = 0x0118;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MappingResourceUID>::s_name = "Mapping Resource UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MappingResourceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MappingResourceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LongCodeValue>::s_keyword = Keyword::LongCodeValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongCodeValue>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongCodeValue>::s_element = 0x0119;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LongCodeValue>::s_name = "Long Code Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LongCodeValue>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LongCodeValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::URNCodeValue>::s_keyword = Keyword::URNCodeValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::URNCodeValue>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::URNCodeValue>::s_element = 0x0120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::URNCodeValue>::s_name = "URN Code Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::URNCodeValue>::s_vr = VR::UR;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::URNCodeValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EquivalentCodeSequence>::s_keyword = Keyword::EquivalentCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EquivalentCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EquivalentCodeSequence>::s_element = 0x0121;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EquivalentCodeSequence>::s_name = "Equivalent Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EquivalentCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EquivalentCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MappingResourceName>::s_keyword = Keyword::MappingResourceName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceName>::s_element = 0x0122;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MappingResourceName>::s_name = "Mapping Resource Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MappingResourceName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MappingResourceName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContextGroupIdentificationSequence>::s_keyword =
    Keyword::ContextGroupIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContextGroupIdentificationSequence>::s_element = 0x0123;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContextGroupIdentificationSequence>::s_name =
    "Context Group Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContextGroupIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContextGroupIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MappingResourceIdentificationSequence>::s_keyword =
    Keyword::MappingResourceIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappingResourceIdentificationSequence>::s_element = 0x0124;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MappingResourceIdentificationSequence>::s_name =
    "Mapping Resource Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MappingResourceIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MappingResourceIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimezoneOffsetFromUTC>::s_keyword = Keyword::TimezoneOffsetFromUTC;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimezoneOffsetFromUTC>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimezoneOffsetFromUTC>::s_element = 0x0201;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimezoneOffsetFromUTC>::s_name = "Timezone Offset From UTC";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimezoneOffsetFromUTC>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimezoneOffsetFromUTC>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ResponsibleGroupCodeSequence>::s_keyword =
    Keyword::ResponsibleGroupCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsibleGroupCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsibleGroupCodeSequence>::s_element = 0x0220;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ResponsibleGroupCodeSequence>::s_name =
    "Responsible Group Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ResponsibleGroupCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ResponsibleGroupCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_keyword =
    Keyword::PrivateDataElementCharacteristicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_element = 0x0300;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_name =
    "Private Data Element Characteristics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrivateDataElementCharacteristicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrivateGroupReference>::s_keyword = Keyword::PrivateGroupReference;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateGroupReference>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateGroupReference>::s_element = 0x0301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrivateGroupReference>::s_name = "Private Group Reference";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrivateGroupReference>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrivateGroupReference>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrivateCreatorReference>::s_keyword = Keyword::PrivateCreatorReference;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateCreatorReference>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateCreatorReference>::s_element = 0x0302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrivateCreatorReference>::s_name = "Private Creator Reference";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrivateCreatorReference>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrivateCreatorReference>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlockIdentifyingInformationStatus>::s_keyword =
    Keyword::BlockIdentifyingInformationStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlockIdentifyingInformationStatus>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlockIdentifyingInformationStatus>::s_element = 0x0303;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlockIdentifyingInformationStatus>::s_name =
    "Block Identifying Information Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlockIdentifyingInformationStatus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlockIdentifyingInformationStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NonidentifyingPrivateElements>::s_keyword =
    Keyword::NonidentifyingPrivateElements;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NonidentifyingPrivateElements>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NonidentifyingPrivateElements>::s_element = 0x0304;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NonidentifyingPrivateElements>::s_name =
    "Nonidentifying Private Elements";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NonidentifyingPrivateElements>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NonidentifyingPrivateElements>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeidentificationActionSequence>::s_keyword =
    Keyword::DeidentificationActionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationActionSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationActionSequence>::s_element = 0x0305;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeidentificationActionSequence>::s_name =
    "Deidentification action Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeidentificationActionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeidentificationActionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_keyword =
    Keyword::PrivateDataElementDefinitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_element = 0x0310;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_name =
    "Private Data Element Definition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrivateDataElementDefinitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StationName>::s_keyword = Keyword::StationName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StationName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StationName>::s_element = 0x1010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StationName>::s_name = "Station Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StationName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StationName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudyDescription>::s_keyword = Keyword::StudyDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyDescription>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyDescription>::s_element = 0x1030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudyDescription>::s_name = "Study Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudyDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudyDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProcedureCodeSequence>::s_keyword = Keyword::ProcedureCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProcedureCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProcedureCodeSequence>::s_element = 0x1032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProcedureCodeSequence>::s_name = "Procedure Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProcedureCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProcedureCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesDescription>::s_keyword = Keyword::SeriesDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDescription>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDescription>::s_element = 0x103E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesDescription>::s_name = "Series Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesDescriptionCodeSequence>::s_keyword =
    Keyword::SeriesDescriptionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDescriptionCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesDescriptionCodeSequence>::s_element = 0x103F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesDescriptionCodeSequence>::s_name =
    "Series Description Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesDescriptionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesDescriptionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstitutionalDepartmentName>::s_keyword =
    Keyword::InstitutionalDepartmentName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionalDepartmentName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionalDepartmentName>::s_element = 0x1040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstitutionalDepartmentName>::s_name =
    "Institutional Department Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstitutionalDepartmentName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstitutionalDepartmentName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_keyword =
    Keyword::InstitutionalDepartmentTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_element = 0x1041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_name =
    "Institutional Department Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstitutionalDepartmentTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysiciansOfRecord>::s_keyword = Keyword::PhysiciansOfRecord;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansOfRecord>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansOfRecord>::s_element = 0x1048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysiciansOfRecord>::s_name = "Physician(s) of Record";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysiciansOfRecord>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysiciansOfRecord>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_keyword =
    Keyword::PhysiciansOfRecordIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_element = 0x1049;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_name =
    "Physician(s) of Record Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysiciansOfRecordIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformingPhysicianName>::s_keyword = Keyword::PerformingPhysicianName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformingPhysicianName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformingPhysicianName>::s_element = 0x1050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformingPhysicianName>::s_name = "Performing Physician's Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformingPhysicianName>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformingPhysicianName>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_keyword =
    Keyword::PerformingPhysicianIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_element = 0x1052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_name =
    "Performing Physician Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformingPhysicianIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_keyword =
    Keyword::NameOfPhysiciansReadingStudy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_element = 0x1060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_name =
    "Name of Physician(s) Reading Study";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NameOfPhysiciansReadingStudy>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_keyword =
    Keyword::PhysiciansReadingStudyIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_element = 0x1062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_name =
    "Physician(s) Reading Study Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysiciansReadingStudyIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OperatorsName>::s_keyword = Keyword::OperatorsName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatorsName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatorsName>::s_element = 0x1070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OperatorsName>::s_name = "Operators' Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OperatorsName>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OperatorsName>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OperatorIdentificationSequence>::s_keyword =
    Keyword::OperatorIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatorIdentificationSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatorIdentificationSequence>::s_element = 0x1072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OperatorIdentificationSequence>::s_name =
    "Operator Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OperatorIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OperatorIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AdmittingDiagnosesDescription>::s_keyword =
    Keyword::AdmittingDiagnosesDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmittingDiagnosesDescription>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmittingDiagnosesDescription>::s_element = 0x1080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AdmittingDiagnosesDescription>::s_name =
    "Admitting Diagnoses Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AdmittingDiagnosesDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AdmittingDiagnosesDescription>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_keyword =
    Keyword::AdmittingDiagnosesCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_element = 0x1084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_name =
    "Admitting Diagnoses Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AdmittingDiagnosesCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PyramidDescription>::s_keyword = Keyword::PyramidDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidDescription>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidDescription>::s_element = 0x1088;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PyramidDescription>::s_name = "Pyramid Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PyramidDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PyramidDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ManufacturerModelName>::s_keyword = Keyword::ManufacturerModelName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ManufacturerModelName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ManufacturerModelName>::s_element = 0x1090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ManufacturerModelName>::s_name = "Manufacturer's Model Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ManufacturerModelName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ManufacturerModelName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedStudySequence>::s_keyword = Keyword::ReferencedStudySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedStudySequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedStudySequence>::s_element = 0x1110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedStudySequence>::s_name = "Referenced Study Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedStudySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedStudySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_keyword =
    Keyword::ReferencedPerformedProcedureStepSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_element = 0x1111;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_name =
    "Referenced Performed Procedure Step Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPerformedProcedureStepSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedSeriesSequence>::s_keyword = Keyword::ReferencedSeriesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSeriesSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSeriesSequence>::s_element = 0x1115;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedSeriesSequence>::s_name = "Referenced Series Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedSeriesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedSeriesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPatientSequence>::s_keyword = Keyword::ReferencedPatientSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPatientSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPatientSequence>::s_element = 0x1120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPatientSequence>::s_name = "Referenced Patient Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPatientSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPatientSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_keyword =
    Keyword::ReferencedStereometricInstanceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_element = 0x1134;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_name =
    "Referenced Stereometric Instance Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedStereometricInstanceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedWaveformSequence>::s_keyword = Keyword::ReferencedWaveformSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedWaveformSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedWaveformSequence>::s_element = 0x113A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedWaveformSequence>::s_name = "Referenced Waveform Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedWaveformSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedWaveformSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedImageSequence>::s_keyword = Keyword::ReferencedImageSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedImageSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedImageSequence>::s_element = 0x1140;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedImageSequence>::s_name = "Referenced Image Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedImageSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedImageSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedInstanceSequence>::s_keyword = Keyword::ReferencedInstanceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedInstanceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedInstanceSequence>::s_element = 0x114A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedInstanceSequence>::s_name = "Referenced Instance Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedInstanceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedInstanceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_keyword =
    Keyword::ReferencedRealWorldValueMappingInstanceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_element = 0x114B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_name =
    "Referenced Real World Value Mapping Instance Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedSOPClassUID>::s_keyword = Keyword::ReferencedSOPClassUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPClassUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPClassUID>::s_element = 0x1150;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedSOPClassUID>::s_name = "Referenced SOP Class UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedSOPClassUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedSOPClassUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedSOPInstanceUID>::s_keyword = Keyword::ReferencedSOPInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPInstanceUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPInstanceUID>::s_element = 0x1155;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedSOPInstanceUID>::s_name = "Referenced SOP Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedSOPInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedSOPInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DefinitionSourceSequence>::s_keyword = Keyword::DefinitionSourceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DefinitionSourceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DefinitionSourceSequence>::s_element = 0x1156;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DefinitionSourceSequence>::s_name = "Definition Source Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DefinitionSourceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DefinitionSourceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedFrameNumber>::s_keyword = Keyword::ReferencedFrameNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedFrameNumber>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedFrameNumber>::s_element = 0x1160;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedFrameNumber>::s_name = "Referenced Frame Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedFrameNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedFrameNumber>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SimpleFrameList>::s_keyword = Keyword::SimpleFrameList;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SimpleFrameList>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SimpleFrameList>::s_element = 0x1161;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SimpleFrameList>::s_name = "Simple Frame List";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SimpleFrameList>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SimpleFrameList>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalculatedFrameList>::s_keyword = Keyword::CalculatedFrameList;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedFrameList>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedFrameList>::s_element = 0x1162;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalculatedFrameList>::s_name = "Calculated Frame List";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalculatedFrameList>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalculatedFrameList>::s_vm = VM::MIN_3_MAX_3N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeRange>::s_keyword = Keyword::TimeRange;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeRange>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeRange>::s_element = 0x1163;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeRange>::s_name = "Time Range";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeRange>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeRange>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameExtractionSequence>::s_keyword = Keyword::FrameExtractionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameExtractionSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameExtractionSequence>::s_element = 0x1164;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameExtractionSequence>::s_name = "Frame Extraction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameExtractionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameExtractionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_keyword =
    Keyword::MultiFrameSourceSOPInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_element = 0x1167;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_name =
    "Multi-frame Source SOP Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultiFrameSourceSOPInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RetrieveURL>::s_keyword = Keyword::RetrieveURL;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetrieveURL>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetrieveURL>::s_element = 0x1190;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RetrieveURL>::s_name = "Retrieve URL";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RetrieveURL>::s_vr = VR::UR;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RetrieveURL>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedSOPSequence>::s_keyword = Keyword::ReferencedSOPSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSOPSequence>::s_element = 0x1199;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedSOPSequence>::s_name = "Referenced SOP Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedSOPSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedSOPSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_keyword =
    Keyword::StudiesContainingOtherReferencedInstancesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_element = 0x1200;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_name =
    "Studies Containing Other Referenced Instances Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RelatedSeriesSequence>::s_keyword = Keyword::RelatedSeriesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelatedSeriesSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelatedSeriesSequence>::s_element = 0x1250;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RelatedSeriesSequence>::s_name = "Related Series Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RelatedSeriesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RelatedSeriesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DerivationDescription>::s_keyword = Keyword::DerivationDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationDescription>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationDescription>::s_element = 0x2111;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DerivationDescription>::s_name = "Derivation Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DerivationDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DerivationDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceImageSequence>::s_keyword = Keyword::SourceImageSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceImageSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceImageSequence>::s_element = 0x2112;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceImageSequence>::s_name = "Source Image Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceImageSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceImageSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StageName>::s_keyword = Keyword::StageName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageName>::s_element = 0x2120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StageName>::s_name = "Stage Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StageName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StageName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StageNumber>::s_keyword = Keyword::StageNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageNumber>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageNumber>::s_element = 0x2122;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StageNumber>::s_name = "Stage Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StageNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StageNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfStages>::s_keyword = Keyword::NumberOfStages;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfStages>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfStages>::s_element = 0x2124;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfStages>::s_name = "Number of Stages";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfStages>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfStages>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ViewName>::s_keyword = Keyword::ViewName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewName>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewName>::s_element = 0x2127;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ViewName>::s_name = "view Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ViewName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ViewName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ViewNumber>::s_keyword = Keyword::ViewNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewNumber>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewNumber>::s_element = 0x2128;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ViewNumber>::s_name = "view Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ViewNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ViewNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfEventTimers>::s_keyword = Keyword::NumberOfEventTimers;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfEventTimers>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfEventTimers>::s_element = 0x2129;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfEventTimers>::s_name = "Number of Event Timers";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfEventTimers>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfEventTimers>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfViewsInStage>::s_keyword = Keyword::NumberOfViewsInStage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfViewsInStage>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfViewsInStage>::s_element = 0x212A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfViewsInStage>::s_name = "Number of Views in Stage";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfViewsInStage>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfViewsInStage>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EventElapsedTimes>::s_keyword = Keyword::EventElapsedTimes;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventElapsedTimes>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventElapsedTimes>::s_element = 0x2130;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EventElapsedTimes>::s_name = "Event Elapsed Time(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EventElapsedTimes>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EventElapsedTimes>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EventTimerNames>::s_keyword = Keyword::EventTimerNames;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimerNames>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimerNames>::s_element = 0x2132;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EventTimerNames>::s_name = "Event Timer Name(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EventTimerNames>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EventTimerNames>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EventTimerSequence>::s_keyword = Keyword::EventTimerSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimerSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimerSequence>::s_element = 0x2133;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EventTimerSequence>::s_name = "Event Timer Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EventTimerSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EventTimerSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EventTimeOffset>::s_keyword = Keyword::EventTimeOffset;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimeOffset>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventTimeOffset>::s_element = 0x2134;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EventTimeOffset>::s_name = "Event Time Offset";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EventTimeOffset>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EventTimeOffset>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EventCodeSequence>::s_keyword = Keyword::EventCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EventCodeSequence>::s_element = 0x2135;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EventCodeSequence>::s_name = "Event Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EventCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EventCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartTrim>::s_keyword = Keyword::StartTrim;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartTrim>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartTrim>::s_element = 0x2142;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartTrim>::s_name = "Start Trim";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartTrim>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartTrim>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StopTrim>::s_keyword = Keyword::StopTrim;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StopTrim>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StopTrim>::s_element = 0x2143;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StopTrim>::s_name = "Stop Trim";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StopTrim>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StopTrim>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RecommendedDisplayFrameRate>::s_keyword =
    Keyword::RecommendedDisplayFrameRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedDisplayFrameRate>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedDisplayFrameRate>::s_element = 0x2144;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RecommendedDisplayFrameRate>::s_name =
    "Recommended Display Frame Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RecommendedDisplayFrameRate>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RecommendedDisplayFrameRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AnatomicRegionSequence>::s_keyword = Keyword::AnatomicRegionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicRegionSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicRegionSequence>::s_element = 0x2218;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AnatomicRegionSequence>::s_name = "Anatomic Region Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AnatomicRegionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AnatomicRegionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AnatomicRegionModifierSequence>::s_keyword =
    Keyword::AnatomicRegionModifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicRegionModifierSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicRegionModifierSequence>::s_element = 0x2220;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AnatomicRegionModifierSequence>::s_name =
    "Anatomic Region Modifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AnatomicRegionModifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AnatomicRegionModifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_keyword =
    Keyword::PrimaryAnatomicStructureSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_element = 0x2228;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_name =
    "Primary Anatomic Structure Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryAnatomicStructureSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_keyword =
    Keyword::PrimaryAnatomicStructureModifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_element = 0x2230;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_name =
    "Primary Anatomic Structure Modifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryAnatomicStructureModifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IrradiationEventUID>::s_keyword = Keyword::IrradiationEventUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IrradiationEventUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IrradiationEventUID>::s_element = 0x3010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IrradiationEventUID>::s_name = "Irradiation Event UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IrradiationEventUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IrradiationEventUID>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceIrradiationEventSequence>::s_keyword =
    Keyword::SourceIrradiationEventSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceIrradiationEventSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceIrradiationEventSequence>::s_element = 0x3011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceIrradiationEventSequence>::s_name =
    "Source Irradiation Event Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceIrradiationEventSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceIrradiationEventSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_keyword =
    Keyword::RadiopharmaceuticalAdministrationEventUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_element = 0x3012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_name =
    "Radiopharmaceutical Administration Event UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalAdministrationEventUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameType>::s_keyword = Keyword::FrameType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameType>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameType>::s_element = 0x9007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameType>::s_name = "Frame Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameType>::s_vm = VM::MIN_4_MAX_5;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedImageEvidenceSequence>::s_keyword =
    Keyword::ReferencedImageEvidenceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedImageEvidenceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedImageEvidenceSequence>::s_element = 0x9092;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedImageEvidenceSequence>::s_name =
    "Referenced Image Evidence Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedImageEvidenceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedImageEvidenceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedRawDataSequence>::s_keyword = Keyword::ReferencedRawDataSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedRawDataSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedRawDataSequence>::s_element = 0x9121;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedRawDataSequence>::s_name = "Referenced Raw Data Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedRawDataSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedRawDataSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DerivationImageSequence>::s_keyword = Keyword::DerivationImageSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationImageSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationImageSequence>::s_element = 0x9124;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DerivationImageSequence>::s_name = "Derivation Image Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DerivationImageSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DerivationImageSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceImageEvidenceSequence>::s_keyword =
    Keyword::SourceImageEvidenceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceImageEvidenceSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceImageEvidenceSequence>::s_element = 0x9154;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceImageEvidenceSequence>::s_name =
    "Source Image Evidence Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceImageEvidenceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceImageEvidenceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelPresentation>::s_keyword = Keyword::PixelPresentation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPresentation>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPresentation>::s_element = 0x9205;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelPresentation>::s_name = "Pixel Presentation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelPresentation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelPresentation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumetricProperties>::s_keyword = Keyword::VolumetricProperties;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumetricProperties>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumetricProperties>::s_element = 0x9206;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumetricProperties>::s_name = "Volumetric Properties";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumetricProperties>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumetricProperties>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumeBasedCalculationTechnique>::s_keyword =
    Keyword::VolumeBasedCalculationTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeBasedCalculationTechnique>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeBasedCalculationTechnique>::s_element = 0x9207;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumeBasedCalculationTechnique>::s_name =
    "Volume Based Calculation technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumeBasedCalculationTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumeBasedCalculationTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ComplexImageComponent>::s_keyword = Keyword::ComplexImageComponent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ComplexImageComponent>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ComplexImageComponent>::s_element = 0x9208;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ComplexImageComponent>::s_name = "Complex Image Component";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ComplexImageComponent>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ComplexImageComponent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionContrast>::s_keyword = Keyword::AcquisitionContrast;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContrast>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContrast>::s_element = 0x9209;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionContrast>::s_name = "Acquisition Contrast";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionContrast>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionContrast>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DerivationCodeSequence>::s_keyword = Keyword::DerivationCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationCodeSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationCodeSequence>::s_element = 0x9215;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DerivationCodeSequence>::s_name = "Derivation Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DerivationCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DerivationCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPresentationStateSequence>::s_keyword =
    Keyword::ReferencedPresentationStateSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPresentationStateSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPresentationStateSequence>::s_element = 0x9237;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPresentationStateSequence>::s_name =
    "Referenced Presentation State Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPresentationStateSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPresentationStateSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedOtherPlaneSequence>::s_keyword =
    Keyword::ReferencedOtherPlaneSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedOtherPlaneSequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedOtherPlaneSequence>::s_element = 0x9410;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedOtherPlaneSequence>::s_name =
    "Referenced Other Plane Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedOtherPlaneSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedOtherPlaneSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameDisplaySequence>::s_keyword = Keyword::FrameDisplaySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDisplaySequence>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDisplaySequence>::s_element = 0x9458;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameDisplaySequence>::s_name = "Frame Display Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameDisplaySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameDisplaySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_keyword =
    Keyword::RecommendedDisplayFrameRateInFloat;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_element = 0x9459;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_name =
    "Recommended Display Frame Rate in Float";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RecommendedDisplayFrameRateInFloat>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SkipFrameRangeFlag>::s_keyword = Keyword::SkipFrameRangeFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SkipFrameRangeFlag>::s_group = 0x0008;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SkipFrameRangeFlag>::s_element = 0x9460;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SkipFrameRangeFlag>::s_name = "Skip Frame Range Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SkipFrameRangeFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SkipFrameRangeFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientName>::s_keyword = Keyword::PatientName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientName>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientName>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientName>::s_name = "Patient's Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientName>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientID>::s_keyword = Keyword::PatientID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientID>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientID>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientID>::s_name = "Patient ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfPatientID>::s_keyword = Keyword::IssuerOfPatientID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfPatientID>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfPatientID>::s_element = 0x0021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfPatientID>::s_name = "Issuer of Patient ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfPatientID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfPatientID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TypeOfPatientID>::s_keyword = Keyword::TypeOfPatientID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TypeOfPatientID>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TypeOfPatientID>::s_element = 0x0022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TypeOfPatientID>::s_name = "Type of Patient ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TypeOfPatientID>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TypeOfPatientID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_keyword =
    Keyword::IssuerOfPatientIDQualifiersSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_element = 0x0024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_name =
    "Issuer of Patient ID Qualifiers Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfPatientIDQualifiersSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_keyword =
    Keyword::SourcePatientGroupIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_element = 0x0026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_name =
    "Source Patient Group Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourcePatientGroupIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_keyword =
    Keyword::GroupOfPatientsIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_element = 0x0027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_name =
    "Group of Patients Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GroupOfPatientsIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubjectRelativePositionInImage>::s_keyword =
    Keyword::SubjectRelativePositionInImage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectRelativePositionInImage>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectRelativePositionInImage>::s_element = 0x0028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubjectRelativePositionInImage>::s_name =
    "Subject Relative Position in Image";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubjectRelativePositionInImage>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubjectRelativePositionInImage>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBirthDate>::s_keyword = Keyword::PatientBirthDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthDate>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthDate>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBirthDate>::s_name = "Patient's Birth Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBirthDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBirthDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBirthTime>::s_keyword = Keyword::PatientBirthTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthTime>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthTime>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBirthTime>::s_name = "Patient's Birth Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBirthTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBirthTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_keyword =
    Keyword::PatientBirthDateInAlternativeCalendar;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_element = 0x0033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_name =
    "Patient's Birth Date in Alternative Calendar";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBirthDateInAlternativeCalendar>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_keyword =
    Keyword::PatientDeathDateInAlternativeCalendar;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_element = 0x0034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_name =
    "Patient's Death Date in Alternative Calendar";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientDeathDateInAlternativeCalendar>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientAlternativeCalendar>::s_keyword = Keyword::PatientAlternativeCalendar;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientAlternativeCalendar>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientAlternativeCalendar>::s_element = 0x0035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientAlternativeCalendar>::s_name =
    "Patient's Alternative Calendar";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientAlternativeCalendar>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientAlternativeCalendar>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSex>::s_keyword = Keyword::PatientSex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSex>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSex>::s_element = 0x0040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSex>::s_name = "Patient's Sex";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSex>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::QualityControlSubject>::s_keyword = Keyword::QualityControlSubject;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityControlSubject>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityControlSubject>::s_element = 0x0200;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::QualityControlSubject>::s_name = "Quality Control Subject";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::QualityControlSubject>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::QualityControlSubject>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainDescription>::s_keyword = Keyword::StrainDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainDescription>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainDescription>::s_element = 0x0212;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainDescription>::s_name = "Strain Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainDescription>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainNomenclature>::s_keyword = Keyword::StrainNomenclature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainNomenclature>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainNomenclature>::s_element = 0x0213;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainNomenclature>::s_name = "Strain Nomenclature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainNomenclature>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainNomenclature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainStockNumber>::s_keyword = Keyword::StrainStockNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainStockNumber>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainStockNumber>::s_element = 0x0214;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainStockNumber>::s_name = "Strain Stock Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainStockNumber>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainStockNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_keyword =
    Keyword::StrainSourceRegistryCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_element = 0x0215;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_name =
    "Strain Source Registry Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainSourceRegistryCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainStockSequence>::s_keyword = Keyword::StrainStockSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainStockSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainStockSequence>::s_element = 0x0216;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainStockSequence>::s_name = "Strain Stock Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainStockSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainStockSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainSource>::s_keyword = Keyword::StrainSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainSource>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainSource>::s_element = 0x0217;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainSource>::s_name = "Strain Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainSource>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainAdditionalInformation>::s_keyword =
    Keyword::StrainAdditionalInformation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainAdditionalInformation>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainAdditionalInformation>::s_element = 0x0218;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainAdditionalInformation>::s_name =
    "Strain Additional Information";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainAdditionalInformation>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainAdditionalInformation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StrainCodeSequence>::s_keyword = Keyword::StrainCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StrainCodeSequence>::s_element = 0x0219;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StrainCodeSequence>::s_name = "Strain Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StrainCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StrainCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneticModificationsSequence>::s_keyword =
    Keyword::GeneticModificationsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsSequence>::s_element = 0x0221;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneticModificationsSequence>::s_name =
    "Genetic Modifications Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneticModificationsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneticModificationsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneticModificationsDescription>::s_keyword =
    Keyword::GeneticModificationsDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsDescription>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsDescription>::s_element = 0x0222;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneticModificationsDescription>::s_name =
    "Genetic Modifications Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneticModificationsDescription>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneticModificationsDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneticModificationsNomenclature>::s_keyword =
    Keyword::GeneticModificationsNomenclature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsNomenclature>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsNomenclature>::s_element = 0x0223;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneticModificationsNomenclature>::s_name =
    "Genetic Modifications Nomenclature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneticModificationsNomenclature>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneticModificationsNomenclature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneticModificationsCodeSequence>::s_keyword =
    Keyword::GeneticModificationsCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneticModificationsCodeSequence>::s_element = 0x0229;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneticModificationsCodeSequence>::s_name =
    "Genetic Modifications Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneticModificationsCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneticModificationsCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OtherPatientNames>::s_keyword = Keyword::OtherPatientNames;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OtherPatientNames>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OtherPatientNames>::s_element = 0x1001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OtherPatientNames>::s_name = "Other Patient Names";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OtherPatientNames>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OtherPatientNames>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OtherPatientIDsSequence>::s_keyword = Keyword::OtherPatientIDsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OtherPatientIDsSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OtherPatientIDsSequence>::s_element = 0x1002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OtherPatientIDsSequence>::s_name = "Other Patient IDs Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OtherPatientIDsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OtherPatientIDsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientAge>::s_keyword = Keyword::PatientAge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientAge>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientAge>::s_element = 0x1010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientAge>::s_name = "Patient's Age";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientAge>::s_vr = VR::AS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientAge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSize>::s_keyword = Keyword::PatientSize;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSize>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSize>::s_element = 0x1020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSize>::s_name = "Patient's Size";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSize>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSize>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSizeCodeSequence>::s_keyword = Keyword::PatientSizeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSizeCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSizeCodeSequence>::s_element = 0x1021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSizeCodeSequence>::s_name = "Patient's Size Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSizeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSizeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBodyMassIndex>::s_keyword = Keyword::PatientBodyMassIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBodyMassIndex>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBodyMassIndex>::s_element = 0x1022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBodyMassIndex>::s_name = "Patient's Body Mass Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBodyMassIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBodyMassIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MeasuredAPDimension>::s_keyword = Keyword::MeasuredAPDimension;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasuredAPDimension>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasuredAPDimension>::s_element = 0x1023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MeasuredAPDimension>::s_name = "Measured AP Dimension";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MeasuredAPDimension>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MeasuredAPDimension>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MeasuredLateralDimension>::s_keyword = Keyword::MeasuredLateralDimension;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasuredLateralDimension>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasuredLateralDimension>::s_element = 0x1024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MeasuredLateralDimension>::s_name = "Measured Lateral Dimension";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MeasuredLateralDimension>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MeasuredLateralDimension>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientWeight>::s_keyword = Keyword::PatientWeight;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientWeight>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientWeight>::s_element = 0x1030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientWeight>::s_name = "Patient's Weight";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientWeight>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientWeight>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPatientPhotoSequence>::s_keyword =
    Keyword::ReferencedPatientPhotoSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPatientPhotoSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPatientPhotoSequence>::s_element = 0x1100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPatientPhotoSequence>::s_name =
    "Referenced Patient Photo Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPatientPhotoSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPatientPhotoSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MedicalAlerts>::s_keyword = Keyword::MedicalAlerts;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MedicalAlerts>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MedicalAlerts>::s_element = 0x2000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MedicalAlerts>::s_name = "Medical Alerts";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MedicalAlerts>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MedicalAlerts>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Allergies>::s_keyword = Keyword::Allergies;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Allergies>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Allergies>::s_element = 0x2110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Allergies>::s_name = "Allergies";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Allergies>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Allergies>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EthnicGroup>::s_keyword = Keyword::EthnicGroup;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EthnicGroup>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EthnicGroup>::s_element = 0x2160;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EthnicGroup>::s_name = "Ethnic Group";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EthnicGroup>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EthnicGroup>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Occupation>::s_keyword = Keyword::Occupation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Occupation>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Occupation>::s_element = 0x2180;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Occupation>::s_name = "Occupation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Occupation>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Occupation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SmokingStatus>::s_keyword = Keyword::SmokingStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmokingStatus>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmokingStatus>::s_element = 0x21A0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SmokingStatus>::s_name = "Smoking Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SmokingStatus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SmokingStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AdditionalPatientHistory>::s_keyword = Keyword::AdditionalPatientHistory;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdditionalPatientHistory>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdditionalPatientHistory>::s_element = 0x21B0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AdditionalPatientHistory>::s_name = "Additional Patient History";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AdditionalPatientHistory>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AdditionalPatientHistory>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PregnancyStatus>::s_keyword = Keyword::PregnancyStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PregnancyStatus>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PregnancyStatus>::s_element = 0x21C0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PregnancyStatus>::s_name = "Pregnancy Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PregnancyStatus>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PregnancyStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LastMenstrualDate>::s_keyword = Keyword::LastMenstrualDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LastMenstrualDate>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LastMenstrualDate>::s_element = 0x21D0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LastMenstrualDate>::s_name = "Last Menstrual Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LastMenstrualDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LastMenstrualDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSpeciesDescription>::s_keyword = Keyword::PatientSpeciesDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSpeciesDescription>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSpeciesDescription>::s_element = 0x2201;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSpeciesDescription>::s_name = "Patient Species Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSpeciesDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSpeciesDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSpeciesCodeSequence>::s_keyword = Keyword::PatientSpeciesCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSpeciesCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSpeciesCodeSequence>::s_element = 0x2202;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSpeciesCodeSequence>::s_name =
    "Patient Species Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSpeciesCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSpeciesCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientSexNeutered>::s_keyword = Keyword::PatientSexNeutered;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSexNeutered>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientSexNeutered>::s_element = 0x2203;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientSexNeutered>::s_name = "Patient's Sex Neutered";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientSexNeutered>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientSexNeutered>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AnatomicalOrientationType>::s_keyword = Keyword::AnatomicalOrientationType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicalOrientationType>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicalOrientationType>::s_element = 0x2210;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AnatomicalOrientationType>::s_name = "Anatomical Orientation Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AnatomicalOrientationType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AnatomicalOrientationType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBreedDescription>::s_keyword = Keyword::PatientBreedDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBreedDescription>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBreedDescription>::s_element = 0x2292;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBreedDescription>::s_name = "Patient Breed Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBreedDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBreedDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientBreedCodeSequence>::s_keyword = Keyword::PatientBreedCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBreedCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientBreedCodeSequence>::s_element = 0x2293;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientBreedCodeSequence>::s_name = "Patient Breed Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientBreedCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientBreedCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreedRegistrationSequence>::s_keyword = Keyword::BreedRegistrationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistrationSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistrationSequence>::s_element = 0x2294;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreedRegistrationSequence>::s_name = "Breed Registration Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreedRegistrationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreedRegistrationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreedRegistrationNumber>::s_keyword = Keyword::BreedRegistrationNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistrationNumber>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistrationNumber>::s_element = 0x2295;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreedRegistrationNumber>::s_name = "Breed Registration Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreedRegistrationNumber>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreedRegistrationNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreedRegistryCodeSequence>::s_keyword = Keyword::BreedRegistryCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistryCodeSequence>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreedRegistryCodeSequence>::s_element = 0x2296;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreedRegistryCodeSequence>::s_name = "Breed Registry Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreedRegistryCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreedRegistryCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ResponsiblePerson>::s_keyword = Keyword::ResponsiblePerson;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsiblePerson>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsiblePerson>::s_element = 0x2297;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ResponsiblePerson>::s_name = "Responsible Person";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ResponsiblePerson>::s_vr = VR::PN;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ResponsiblePerson>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ResponsiblePersonRole>::s_keyword = Keyword::ResponsiblePersonRole;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsiblePersonRole>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsiblePersonRole>::s_element = 0x2298;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ResponsiblePersonRole>::s_name = "Responsible Person Role";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ResponsiblePersonRole>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ResponsiblePersonRole>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ResponsibleOrganization>::s_keyword = Keyword::ResponsibleOrganization;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsibleOrganization>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResponsibleOrganization>::s_element = 0x2299;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ResponsibleOrganization>::s_name = "Responsible Organization";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ResponsibleOrganization>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ResponsibleOrganization>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientComments>::s_keyword = Keyword::PatientComments;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientComments>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientComments>::s_element = 0x4000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientComments>::s_name = "Patient Comments";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientComments>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientComments>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExaminedBodyThickness>::s_keyword = Keyword::ExaminedBodyThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExaminedBodyThickness>::s_group = 0x0010;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExaminedBodyThickness>::s_element = 0x9431;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExaminedBodyThickness>::s_name = "Examined Body Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExaminedBodyThickness>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExaminedBodyThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSponsorName>::s_keyword = Keyword::ClinicalTrialSponsorName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSponsorName>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSponsorName>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSponsorName>::s_name = "Clinical Trial Sponsor Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSponsorName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSponsorName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialProtocolID>::s_keyword = Keyword::ClinicalTrialProtocolID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolID>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialProtocolID>::s_name = "Clinical Trial Protocol ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialProtocolID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialProtocolID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialProtocolName>::s_keyword = Keyword::ClinicalTrialProtocolName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolName>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolName>::s_element = 0x0021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialProtocolName>::s_name = "Clinical Trial Protocol Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialProtocolName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialProtocolName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSiteID>::s_keyword = Keyword::ClinicalTrialSiteID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSiteID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSiteID>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSiteID>::s_name = "Clinical Trial Site ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSiteID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSiteID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSiteName>::s_keyword = Keyword::ClinicalTrialSiteName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSiteName>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSiteName>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSiteName>::s_name = "Clinical Trial Site Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSiteName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSiteName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSubjectID>::s_keyword = Keyword::ClinicalTrialSubjectID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSubjectID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSubjectID>::s_element = 0x0040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSubjectID>::s_name = "Clinical Trial Subject ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSubjectID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSubjectID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_keyword =
    Keyword::ClinicalTrialSubjectReadingID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_element = 0x0042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_name =
    "Clinical Trial Subject Reading ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSubjectReadingID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialTimePointID>::s_keyword = Keyword::ClinicalTrialTimePointID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointID>::s_element = 0x0050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialTimePointID>::s_name = "Clinical Trial Time Point ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialTimePointID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialTimePointID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialTimePointDescription>::s_keyword =
    Keyword::ClinicalTrialTimePointDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointDescription>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointDescription>::s_element = 0x0051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialTimePointDescription>::s_name =
    "Clinical Trial Time Point Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialTimePointDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialTimePointDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_keyword =
    Keyword::LongitudinalTemporalOffsetFromEvent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_element = 0x0052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_name =
    "Longitudinal Temporal Offset from Event";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LongitudinalTemporalOffsetFromEvent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LongitudinalTemporalEventType>::s_keyword =
    Keyword::LongitudinalTemporalEventType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalEventType>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalEventType>::s_element = 0x0053;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LongitudinalTemporalEventType>::s_name =
    "Longitudinal Temporal Event Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LongitudinalTemporalEventType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LongitudinalTemporalEventType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_keyword =
    Keyword::ClinicalTrialTimePointTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_element = 0x0054;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_name =
    "Clinical Trial Time Point Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_keyword =
    Keyword::ClinicalTrialCoordinatingCenterName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_element = 0x0060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_name =
    "Clinical Trial Coordinating Center Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialCoordinatingCenterName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientIdentityRemoved>::s_keyword = Keyword::PatientIdentityRemoved;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientIdentityRemoved>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientIdentityRemoved>::s_element = 0x0062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientIdentityRemoved>::s_name = "Patient Identity Removed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientIdentityRemoved>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientIdentityRemoved>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeidentificationMethod>::s_keyword = Keyword::DeidentificationMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationMethod>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationMethod>::s_element = 0x0063;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeidentificationMethod>::s_name = "De-identification Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeidentificationMethod>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeidentificationMethod>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeidentificationMethodCodeSequence>::s_keyword =
    Keyword::DeidentificationMethodCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationMethodCodeSequence>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeidentificationMethodCodeSequence>::s_element = 0x0064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeidentificationMethodCodeSequence>::s_name =
    "De-identification Method Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeidentificationMethodCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeidentificationMethodCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSeriesID>::s_keyword = Keyword::ClinicalTrialSeriesID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSeriesID>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSeriesID>::s_element = 0x0071;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSeriesID>::s_name = "Clinical Trial Series ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSeriesID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSeriesID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialSeriesDescription>::s_keyword =
    Keyword::ClinicalTrialSeriesDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSeriesDescription>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialSeriesDescription>::s_element = 0x0072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialSeriesDescription>::s_name =
    "Clinical Trial Series Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialSeriesDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialSeriesDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_keyword =
    Keyword::ClinicalTrialProtocolEthicsCommitteeName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_element = 0x0081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_name =
    "Clinical Trial Protocol Ethics Committee Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_keyword =
    Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_element = 0x0082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_name =
    "Clinical Trial Protocol Ethics Committee Approval Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_keyword =
    Keyword::ConsentForClinicalTrialUseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_element = 0x0083;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_name =
    "Consent for Clinical Trial Use Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConsentForClinicalTrialUseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistributionType>::s_keyword = Keyword::DistributionType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistributionType>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistributionType>::s_element = 0x0084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistributionType>::s_name = "Distribution Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistributionType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistributionType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConsentForDistributionFlag>::s_keyword = Keyword::ConsentForDistributionFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsentForDistributionFlag>::s_group = 0x0012;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConsentForDistributionFlag>::s_element = 0x0085;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConsentForDistributionFlag>::s_name =
    "Consent for Distribution Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConsentForDistributionFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConsentForDistributionFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WhitePoint>::s_keyword = Keyword::WhitePoint;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WhitePoint>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WhitePoint>::s_element = 0x0001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WhitePoint>::s_name = "White Point";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WhitePoint>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WhitePoint>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryChromaticities>::s_keyword = Keyword::PrimaryChromaticities;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryChromaticities>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryChromaticities>::s_element = 0x0002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryChromaticities>::s_name = "Primary Chromaticities";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryChromaticities>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryChromaticities>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BatteryLevel>::s_keyword = Keyword::BatteryLevel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BatteryLevel>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BatteryLevel>::s_element = 0x0003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BatteryLevel>::s_name = "Battery Level";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BatteryLevel>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BatteryLevel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureTimeInSeconds>::s_keyword = Keyword::ExposureTimeInSeconds;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInSeconds>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInSeconds>::s_element = 0x0004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureTimeInSeconds>::s_name = "Exposure Time in Seconds";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureTimeInSeconds>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureTimeInSeconds>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FNumber>::s_keyword = Keyword::FNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FNumber>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FNumber>::s_element = 0x0005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FNumber>::s_name = "F-Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FNumber>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OECFRows>::s_keyword = Keyword::OECFRows;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFRows>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFRows>::s_element = 0x0006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OECFRows>::s_name = "OECF Rows";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OECFRows>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OECFRows>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OECFColumns>::s_keyword = Keyword::OECFColumns;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFColumns>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFColumns>::s_element = 0x0007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OECFColumns>::s_name = "OECF Columns";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OECFColumns>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OECFColumns>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OECFColumnNames>::s_keyword = Keyword::OECFColumnNames;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFColumnNames>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFColumnNames>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OECFColumnNames>::s_name = "OECF Column Names";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OECFColumnNames>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OECFColumnNames>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OECFValues>::s_keyword = Keyword::OECFValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFValues>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OECFValues>::s_element = 0x0009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OECFValues>::s_name = "OECF Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OECFValues>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OECFValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialFrequencyResponseRows>::s_keyword =
    Keyword::SpatialFrequencyResponseRows;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseRows>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseRows>::s_element = 0x000A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialFrequencyResponseRows>::s_name =
    "Spatial Frequency Response Rows";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialFrequencyResponseRows>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialFrequencyResponseRows>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialFrequencyResponseColumns>::s_keyword =
    Keyword::SpatialFrequencyResponseColumns;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseColumns>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseColumns>::s_element = 0x000B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialFrequencyResponseColumns>::s_name =
    "Spatial Frequency Response Columns";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialFrequencyResponseColumns>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialFrequencyResponseColumns>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_keyword =
    Keyword::SpatialFrequencyResponseColumnNames;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_element = 0x000C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_name =
    "Spatial Frequency Response Column Names";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialFrequencyResponseColumnNames>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialFrequencyResponseValues>::s_keyword =
    Keyword::SpatialFrequencyResponseValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseValues>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialFrequencyResponseValues>::s_element = 0x000D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialFrequencyResponseValues>::s_name =
    "Spatial Frequency Response Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialFrequencyResponseValues>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialFrequencyResponseValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColorFilterArrayPatternRows>::s_keyword =
    Keyword::ColorFilterArrayPatternRows;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternRows>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternRows>::s_element = 0x000E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColorFilterArrayPatternRows>::s_name =
    "Color filter Array Pattern Rows";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColorFilterArrayPatternRows>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColorFilterArrayPatternRows>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColorFilterArrayPatternColumns>::s_keyword =
    Keyword::ColorFilterArrayPatternColumns;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternColumns>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternColumns>::s_element = 0x000F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColorFilterArrayPatternColumns>::s_name =
    "Color filter Array Pattern Columns";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColorFilterArrayPatternColumns>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColorFilterArrayPatternColumns>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColorFilterArrayPatternValues>::s_keyword =
    Keyword::ColorFilterArrayPatternValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternValues>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorFilterArrayPatternValues>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColorFilterArrayPatternValues>::s_name =
    "Color filter Array Pattern Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColorFilterArrayPatternValues>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColorFilterArrayPatternValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashFiringStatus>::s_keyword = Keyword::FlashFiringStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashFiringStatus>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashFiringStatus>::s_element = 0x0011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashFiringStatus>::s_name = "Flash Firing Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashFiringStatus>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashFiringStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashReturnStatus>::s_keyword = Keyword::FlashReturnStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashReturnStatus>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashReturnStatus>::s_element = 0x0012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashReturnStatus>::s_name = "Flash Return Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashReturnStatus>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashReturnStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashMode>::s_keyword = Keyword::FlashMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashMode>::s_element = 0x0013;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashMode>::s_name = "Flash Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashMode>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashFunctionPresent>::s_keyword = Keyword::FlashFunctionPresent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashFunctionPresent>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashFunctionPresent>::s_element = 0x0014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashFunctionPresent>::s_name = "Flash Function Present";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashFunctionPresent>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashFunctionPresent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashRedEyeMode>::s_keyword = Keyword::FlashRedEyeMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashRedEyeMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashRedEyeMode>::s_element = 0x0015;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashRedEyeMode>::s_name = "Flash Red Eye Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashRedEyeMode>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashRedEyeMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureProgram>::s_keyword = Keyword::ExposureProgram;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureProgram>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureProgram>::s_element = 0x0016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureProgram>::s_name = "Exposure Program";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureProgram>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureProgram>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpectralSensitivity>::s_keyword = Keyword::SpectralSensitivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectralSensitivity>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectralSensitivity>::s_element = 0x0017;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpectralSensitivity>::s_name = "Spectral Sensitivity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpectralSensitivity>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpectralSensitivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhotographicSensitivity>::s_keyword = Keyword::PhotographicSensitivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotographicSensitivity>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotographicSensitivity>::s_element = 0x0018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhotographicSensitivity>::s_name = "Photographic Sensitivity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhotographicSensitivity>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhotographicSensitivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SelfTimerMode>::s_keyword = Keyword::SelfTimerMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SelfTimerMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SelfTimerMode>::s_element = 0x0019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SelfTimerMode>::s_name = "Self Timer Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SelfTimerMode>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SelfTimerMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SensitivityType>::s_keyword = Keyword::SensitivityType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensitivityType>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensitivityType>::s_element = 0x001A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SensitivityType>::s_name = "Sensitivity Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SensitivityType>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SensitivityType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StandardOutputSensitivity>::s_keyword = Keyword::StandardOutputSensitivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StandardOutputSensitivity>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StandardOutputSensitivity>::s_element = 0x001B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StandardOutputSensitivity>::s_name = "Standard Output Sensitivity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StandardOutputSensitivity>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StandardOutputSensitivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RecommendedExposureIndex>::s_keyword = Keyword::RecommendedExposureIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedExposureIndex>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedExposureIndex>::s_element = 0x001C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RecommendedExposureIndex>::s_name = "Recommended Exposure Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RecommendedExposureIndex>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RecommendedExposureIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ISOSpeed>::s_keyword = Keyword::ISOSpeed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeed>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeed>::s_element = 0x001D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ISOSpeed>::s_name = "ISO Speed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ISOSpeed>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ISOSpeed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ISOSpeedLatitudeyyy>::s_keyword = Keyword::ISOSpeedLatitudeyyy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeedLatitudeyyy>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeedLatitudeyyy>::s_element = 0x001E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ISOSpeedLatitudeyyy>::s_name = "ISO Speed Latitude yyy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ISOSpeedLatitudeyyy>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ISOSpeedLatitudeyyy>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ISOSpeedLatitudezzz>::s_keyword = Keyword::ISOSpeedLatitudezzz;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeedLatitudezzz>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ISOSpeedLatitudezzz>::s_element = 0x001F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ISOSpeedLatitudezzz>::s_name = "ISO Speed Latitude zzz";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ISOSpeedLatitudezzz>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ISOSpeedLatitudezzz>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EXIFVersion>::s_keyword = Keyword::EXIFVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EXIFVersion>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EXIFVersion>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EXIFVersion>::s_name = "EXIF Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EXIFVersion>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EXIFVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterSpeedValue>::s_keyword = Keyword::ShutterSpeedValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterSpeedValue>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterSpeedValue>::s_element = 0x0021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterSpeedValue>::s_name = "Shutter Speed Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterSpeedValue>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterSpeedValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApertureValue>::s_keyword = Keyword::ApertureValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApertureValue>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApertureValue>::s_element = 0x0022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApertureValue>::s_name = "Aperture Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApertureValue>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApertureValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BrightnessValue>::s_keyword = Keyword::BrightnessValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BrightnessValue>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BrightnessValue>::s_element = 0x0023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BrightnessValue>::s_name = "Brightness Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BrightnessValue>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BrightnessValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureBiasValue>::s_keyword = Keyword::ExposureBiasValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureBiasValue>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureBiasValue>::s_element = 0x0024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureBiasValue>::s_name = "Exposure Bias Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureBiasValue>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureBiasValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaxApertureValue>::s_keyword = Keyword::MaxApertureValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaxApertureValue>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaxApertureValue>::s_element = 0x0025;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaxApertureValue>::s_name = "Max Aperture Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaxApertureValue>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaxApertureValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubjectDistance>::s_keyword = Keyword::SubjectDistance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectDistance>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectDistance>::s_element = 0x0026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubjectDistance>::s_name = "Subject Distance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubjectDistance>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubjectDistance>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MeteringMode>::s_keyword = Keyword::MeteringMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeteringMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeteringMode>::s_element = 0x0027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MeteringMode>::s_name = "Metering Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MeteringMode>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MeteringMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LightSource>::s_keyword = Keyword::LightSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightSource>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightSource>::s_element = 0x0028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LightSource>::s_name = "Light Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LightSource>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LightSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FocalLength>::s_keyword = Keyword::FocalLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalLength>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalLength>::s_element = 0x0029;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FocalLength>::s_name = "Focal Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FocalLength>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FocalLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubjectArea>::s_keyword = Keyword::SubjectArea;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectArea>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectArea>::s_element = 0x002A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubjectArea>::s_name = "Subject Area";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubjectArea>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubjectArea>::s_vm = VM::MIN_2_MAX_4;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MakerNote>::s_keyword = Keyword::MakerNote;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MakerNote>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MakerNote>::s_element = 0x002B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MakerNote>::s_name = "Maker Note";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MakerNote>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MakerNote>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Temperature>::s_keyword = Keyword::Temperature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Temperature>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Temperature>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Temperature>::s_name = "Temperature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Temperature>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Temperature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Humidity>::s_keyword = Keyword::Humidity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Humidity>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Humidity>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Humidity>::s_name = "Humidity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Humidity>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Humidity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Pressure>::s_keyword = Keyword::Pressure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Pressure>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Pressure>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Pressure>::s_name = "Pressure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Pressure>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Pressure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WaterDepth>::s_keyword = Keyword::WaterDepth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterDepth>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterDepth>::s_element = 0x0033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WaterDepth>::s_name = "Water Depth";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WaterDepth>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WaterDepth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Acceleration>::s_keyword = Keyword::Acceleration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Acceleration>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Acceleration>::s_element = 0x0034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Acceleration>::s_name = "Acceleration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Acceleration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Acceleration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CameraElevationAngle>::s_keyword = Keyword::CameraElevationAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraElevationAngle>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraElevationAngle>::s_element = 0x0035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CameraElevationAngle>::s_name = "Camera Elevation Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CameraElevationAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CameraElevationAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlashEnergy>::s_keyword = Keyword::FlashEnergy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashEnergy>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlashEnergy>::s_element = 0x0036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlashEnergy>::s_name = "Flash Energy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlashEnergy>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlashEnergy>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubjectLocation>::s_keyword = Keyword::SubjectLocation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectLocation>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectLocation>::s_element = 0x0037;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubjectLocation>::s_name = "Subject Location";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubjectLocation>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubjectLocation>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhotographicExposureIndex>::s_keyword = Keyword::PhotographicExposureIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotographicExposureIndex>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotographicExposureIndex>::s_element = 0x0038;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhotographicExposureIndex>::s_name = "Photographic Exposure Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhotographicExposureIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhotographicExposureIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SensingMethod>::s_keyword = Keyword::SensingMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensingMethod>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensingMethod>::s_element = 0x0039;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SensingMethod>::s_name = "Sensing Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SensingMethod>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SensingMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FileSource>::s_keyword = Keyword::FileSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FileSource>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FileSource>::s_element = 0x003A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FileSource>::s_name = "File Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FileSource>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FileSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SceneType>::s_keyword = Keyword::SceneType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SceneType>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SceneType>::s_element = 0x003B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SceneType>::s_name = "scene Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SceneType>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SceneType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CustomRendered>::s_keyword = Keyword::CustomRendered;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CustomRendered>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CustomRendered>::s_element = 0x0041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CustomRendered>::s_name = "Custom Rendered";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CustomRendered>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CustomRendered>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureMode>::s_keyword = Keyword::ExposureMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureMode>::s_element = 0x0042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureMode>::s_name = "Exposure Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureMode>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WhiteBalance>::s_keyword = Keyword::WhiteBalance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WhiteBalance>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WhiteBalance>::s_element = 0x0043;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WhiteBalance>::s_name = "White Balance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WhiteBalance>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WhiteBalance>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DigitalZoomRatio>::s_keyword = Keyword::DigitalZoomRatio;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitalZoomRatio>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitalZoomRatio>::s_element = 0x0044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DigitalZoomRatio>::s_name = "Digital Zoom Ratio";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DigitalZoomRatio>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DigitalZoomRatio>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FocalLengthIn35mmFilm>::s_keyword = Keyword::FocalLengthIn35mmFilm;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalLengthIn35mmFilm>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalLengthIn35mmFilm>::s_element = 0x0045;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FocalLengthIn35mmFilm>::s_name = "Focal Length In 35mm Film";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FocalLengthIn35mmFilm>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FocalLengthIn35mmFilm>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SceneCaptureType>::s_keyword = Keyword::SceneCaptureType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SceneCaptureType>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SceneCaptureType>::s_element = 0x0046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SceneCaptureType>::s_name = "scene Capture Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SceneCaptureType>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SceneCaptureType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GainControl>::s_keyword = Keyword::GainControl;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GainControl>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GainControl>::s_element = 0x0047;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GainControl>::s_name = "Gain Control";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GainControl>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GainControl>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Contrast>::s_keyword = Keyword::Contrast;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Contrast>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Contrast>::s_element = 0x0048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Contrast>::s_name = "Contrast";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Contrast>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Contrast>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Saturation>::s_keyword = Keyword::Saturation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Saturation>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Saturation>::s_element = 0x0049;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Saturation>::s_name = "Saturation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Saturation>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Saturation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Sharpness>::s_keyword = Keyword::Sharpness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Sharpness>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Sharpness>::s_element = 0x004A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Sharpness>::s_name = "Sharpness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Sharpness>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Sharpness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeviceSettingDescription>::s_keyword = Keyword::DeviceSettingDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceSettingDescription>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceSettingDescription>::s_element = 0x004B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeviceSettingDescription>::s_name = "Device Setting Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeviceSettingDescription>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeviceSettingDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubjectDistanceRange>::s_keyword = Keyword::SubjectDistanceRange;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectDistanceRange>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubjectDistanceRange>::s_element = 0x004C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubjectDistanceRange>::s_name = "Subject Distance Range";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubjectDistanceRange>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubjectDistanceRange>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CameraOwnerName>::s_keyword = Keyword::CameraOwnerName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraOwnerName>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraOwnerName>::s_element = 0x004D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CameraOwnerName>::s_name = "Camera Owner Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CameraOwnerName>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CameraOwnerName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LensSpecification>::s_keyword = Keyword::LensSpecification;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensSpecification>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensSpecification>::s_element = 0x004E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LensSpecification>::s_name = "Lens Specification";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LensSpecification>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LensSpecification>::s_vm = VM::MIN_4_MAX_4;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LensMake>::s_keyword = Keyword::LensMake;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensMake>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensMake>::s_element = 0x004F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LensMake>::s_name = "Lens Make";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LensMake>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LensMake>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LensModel>::s_keyword = Keyword::LensModel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensModel>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensModel>::s_element = 0x0050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LensModel>::s_name = "Lens Model";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LensModel>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LensModel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LensSerialNumber>::s_keyword = Keyword::LensSerialNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensSerialNumber>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensSerialNumber>::s_element = 0x0051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LensSerialNumber>::s_name = "Lens Serial Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LensSerialNumber>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LensSerialNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InteroperabilityIndex>::s_keyword = Keyword::InteroperabilityIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InteroperabilityIndex>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InteroperabilityIndex>::s_element = 0x0061;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InteroperabilityIndex>::s_name = "Interoperability Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InteroperabilityIndex>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InteroperabilityIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InteroperabilityVersion>::s_keyword = Keyword::InteroperabilityVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InteroperabilityVersion>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InteroperabilityVersion>::s_element = 0x0062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InteroperabilityVersion>::s_name = "Interoperability Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InteroperabilityVersion>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InteroperabilityVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSVersionID>::s_keyword = Keyword::GPSVersionID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSVersionID>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSVersionID>::s_element = 0x0070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSVersionID>::s_name = "GPS Version ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSVersionID>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSVersionID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSLatitudeRef>::s_keyword = Keyword::GPSLatitudeRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLatitudeRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLatitudeRef>::s_element = 0x0071;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSLatitudeRef>::s_name = "GPS Latitude Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSLatitudeRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSLatitudeRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSLatitude>::s_keyword = Keyword::GPSLatitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLatitude>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLatitude>::s_element = 0x0072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSLatitude>::s_name = "GPS Latitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSLatitude>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSLatitude>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSLongitudeRef>::s_keyword = Keyword::GPSLongitudeRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLongitudeRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLongitudeRef>::s_element = 0x0073;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSLongitudeRef>::s_name = "GPS Longitude Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSLongitudeRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSLongitudeRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSLongitude>::s_keyword = Keyword::GPSLongitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLongitude>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSLongitude>::s_element = 0x0074;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSLongitude>::s_name = "GPS Longitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSLongitude>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSLongitude>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSAltitudeRef>::s_keyword = Keyword::GPSAltitudeRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAltitudeRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAltitudeRef>::s_element = 0x0075;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSAltitudeRef>::s_name = "GPS Altitude Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSAltitudeRef>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSAltitudeRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSAltitude>::s_keyword = Keyword::GPSAltitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAltitude>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAltitude>::s_element = 0x0076;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSAltitude>::s_name = "GPS Altitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSAltitude>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSAltitude>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSTimeStamp>::s_keyword = Keyword::GPSTimeStamp;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTimeStamp>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTimeStamp>::s_element = 0x0077;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSTimeStamp>::s_name = "GPS Time Stamp";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSTimeStamp>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSTimeStamp>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSSatellites>::s_keyword = Keyword::GPSSatellites;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSatellites>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSatellites>::s_element = 0x0078;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSSatellites>::s_name = "GPS Satellites";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSSatellites>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSSatellites>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPstatus>::s_keyword = Keyword::GPstatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPstatus>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPstatus>::s_element = 0x0079;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPstatus>::s_name = "GPS Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPstatus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPstatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSMeasureMode>::s_keyword = Keyword::GPSMeasureMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSMeasureMode>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSMeasureMode>::s_element = 0x007A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSMeasureMode>::s_name = "GPS Measure Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSMeasureMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSMeasureMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDOP>::s_keyword = Keyword::GPSDOP;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDOP>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDOP>::s_element = 0x007B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDOP>::s_name = "GPS DOP";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDOP>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDOP>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSSpeedRef>::s_keyword = Keyword::GPSSpeedRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSpeedRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSpeedRef>::s_element = 0x007C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSSpeedRef>::s_name = "GPS Speed Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSSpeedRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSSpeedRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSSpeed>::s_keyword = Keyword::GPSSpeed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSpeed>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSSpeed>::s_element = 0x007D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSSpeed>::s_name = "GPS Speed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSSpeed>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSSpeed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSTrackRef>::s_keyword = Keyword::GPSTrackRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTrackRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTrackRef>::s_element = 0x007E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSTrackRef>::s_name = "GPS Track Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSTrackRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSTrackRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSTrack>::s_keyword = Keyword::GPSTrack;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTrack>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSTrack>::s_element = 0x007F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSTrack>::s_name = "GPS Track";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSTrack>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSTrack>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSImgDirectionRef>::s_keyword = Keyword::GPSImgDirectionRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSImgDirectionRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSImgDirectionRef>::s_element = 0x0080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSImgDirectionRef>::s_name = "GPS Img Direction Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSImgDirectionRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSImgDirectionRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSImgDirection>::s_keyword = Keyword::GPSImgDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSImgDirection>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSImgDirection>::s_element = 0x0081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSImgDirection>::s_name = "GPS Img Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSImgDirection>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSImgDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSMapDatum>::s_keyword = Keyword::GPSMapDatum;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSMapDatum>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSMapDatum>::s_element = 0x0082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSMapDatum>::s_name = "GPS Map Datum";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSMapDatum>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSMapDatum>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestLatitudeRef>::s_keyword = Keyword::GPSDestLatitudeRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLatitudeRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLatitudeRef>::s_element = 0x0083;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestLatitudeRef>::s_name = "GPS Dest Latitude Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestLatitudeRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestLatitudeRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestLatitude>::s_keyword = Keyword::GPSDestLatitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLatitude>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLatitude>::s_element = 0x0084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestLatitude>::s_name = "GPS Dest Latitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestLatitude>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestLatitude>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestLongitudeRef>::s_keyword = Keyword::GPSDestLongitudeRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLongitudeRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLongitudeRef>::s_element = 0x0085;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestLongitudeRef>::s_name = "GPS Dest Longitude Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestLongitudeRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestLongitudeRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestLongitude>::s_keyword = Keyword::GPSDestLongitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLongitude>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestLongitude>::s_element = 0x0086;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestLongitude>::s_name = "GPS Dest Longitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestLongitude>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestLongitude>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestBearingRef>::s_keyword = Keyword::GPSDestBearingRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestBearingRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestBearingRef>::s_element = 0x0087;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestBearingRef>::s_name = "GPS Dest Bearing Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestBearingRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestBearingRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestBearing>::s_keyword = Keyword::GPSDestBearing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestBearing>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestBearing>::s_element = 0x0088;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestBearing>::s_name = "GPS Dest Bearing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestBearing>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestBearing>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestDistanceRef>::s_keyword = Keyword::GPSDestDistanceRef;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestDistanceRef>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestDistanceRef>::s_element = 0x0089;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestDistanceRef>::s_name = "GPS Dest Distance Ref";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestDistanceRef>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestDistanceRef>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDestDistance>::s_keyword = Keyword::GPSDestDistance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestDistance>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDestDistance>::s_element = 0x008A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDestDistance>::s_name = "GPS Dest Distance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDestDistance>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDestDistance>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSProcessingMethod>::s_keyword = Keyword::GPSProcessingMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSProcessingMethod>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSProcessingMethod>::s_element = 0x008B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSProcessingMethod>::s_name = "GPS Processing Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSProcessingMethod>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSProcessingMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSAreaInformation>::s_keyword = Keyword::GPSAreaInformation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAreaInformation>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSAreaInformation>::s_element = 0x008C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSAreaInformation>::s_name = "GPS Area Information";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSAreaInformation>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSAreaInformation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDateStamp>::s_keyword = Keyword::GPSDateStamp;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDateStamp>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDateStamp>::s_element = 0x008D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDateStamp>::s_name = "GPS Date Stamp";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDateStamp>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDateStamp>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GPSDifferential>::s_keyword = Keyword::GPSDifferential;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDifferential>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GPSDifferential>::s_element = 0x008E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GPSDifferential>::s_name = "GPS Differential";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GPSDifferential>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GPSDifferential>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LightSourcePolarization>::s_keyword = Keyword::LightSourcePolarization;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightSourcePolarization>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightSourcePolarization>::s_element = 0x1001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LightSourcePolarization>::s_name = "Light Source Polarization";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LightSourcePolarization>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LightSourcePolarization>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EmitterColorTemperature>::s_keyword = Keyword::EmitterColorTemperature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EmitterColorTemperature>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EmitterColorTemperature>::s_element = 0x1002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EmitterColorTemperature>::s_name = "Emitter Color Temperature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EmitterColorTemperature>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EmitterColorTemperature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContactMethod>::s_keyword = Keyword::ContactMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContactMethod>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContactMethod>::s_element = 0x1003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContactMethod>::s_name = "Contact Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContactMethod>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContactMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImmersionMedia>::s_keyword = Keyword::ImmersionMedia;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImmersionMedia>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImmersionMedia>::s_element = 0x1004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImmersionMedia>::s_name = "Immersion Media";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImmersionMedia>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImmersionMedia>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OpticalMagnificationFactor>::s_keyword = Keyword::OpticalMagnificationFactor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OpticalMagnificationFactor>::s_group = 0x0016;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OpticalMagnificationFactor>::s_element = 0x1005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OpticalMagnificationFactor>::s_name = "Optical Magnification Factor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OpticalMagnificationFactor>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OpticalMagnificationFactor>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgent>::s_keyword = Keyword::ContrastBolusAgent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgent>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgent>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgent>::s_name = "Contrast/Bolus Agent";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgent>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgentSequence>::s_keyword = Keyword::ContrastBolusAgentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentSequence>::s_element = 0x0012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgentSequence>::s_name =
    "Contrast/Bolus Agent Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusT1Relaxivity>::s_keyword = Keyword::ContrastBolusT1Relaxivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusT1Relaxivity>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusT1Relaxivity>::s_element = 0x0013;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusT1Relaxivity>::s_name = "Contrast/Bolus T1 Relaxivity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusT1Relaxivity>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusT1Relaxivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_keyword =
    Keyword::ContrastBolusAdministrationRouteSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_element = 0x0014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_name =
    "Contrast/Bolus Administration Route Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAdministrationRouteSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BodyPartExamined>::s_keyword = Keyword::BodyPartExamined;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BodyPartExamined>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BodyPartExamined>::s_element = 0x0015;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BodyPartExamined>::s_name = "Body Part Examined";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BodyPartExamined>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BodyPartExamined>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanningSequence>::s_keyword = Keyword::ScanningSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanningSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanningSequence>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanningSequence>::s_name = "Scanning Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanningSequence>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanningSequence>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SequenceVariant>::s_keyword = Keyword::SequenceVariant;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceVariant>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceVariant>::s_element = 0x0021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SequenceVariant>::s_name = "Sequence Variant";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SequenceVariant>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SequenceVariant>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanOptions>::s_keyword = Keyword::ScanOptions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanOptions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanOptions>::s_element = 0x0022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanOptions>::s_name = "Scan Options";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanOptions>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanOptions>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRAcquisitionType>::s_keyword = Keyword::MRAcquisitionType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionType>::s_element = 0x0023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRAcquisitionType>::s_name = "MR Acquisition Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRAcquisitionType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRAcquisitionType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SequenceName>::s_keyword = Keyword::SequenceName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceName>::s_element = 0x0024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SequenceName>::s_name = "Sequence Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SequenceName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SequenceName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AngioFlag>::s_keyword = Keyword::AngioFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AngioFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AngioFlag>::s_element = 0x0025;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AngioFlag>::s_name = "Angio Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AngioFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AngioFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugInformationSequence>::s_keyword =
    Keyword::InterventionDrugInformationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugInformationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugInformationSequence>::s_element = 0x0026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugInformationSequence>::s_name =
    "Intervention Drug Information Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugInformationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugInformationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugStopTime>::s_keyword = Keyword::InterventionDrugStopTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugStopTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugStopTime>::s_element = 0x0027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugStopTime>::s_name = "Intervention Drug Stop Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugStopTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugStopTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugDose>::s_keyword = Keyword::InterventionDrugDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugDose>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugDose>::s_element = 0x0028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugDose>::s_name = "Intervention Drug Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugDose>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugCodeSequence>::s_keyword =
    Keyword::InterventionDrugCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugCodeSequence>::s_element = 0x0029;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugCodeSequence>::s_name =
    "Intervention Drug Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AdditionalDrugSequence>::s_keyword = Keyword::AdditionalDrugSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdditionalDrugSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdditionalDrugSequence>::s_element = 0x002A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AdditionalDrugSequence>::s_name = "Additional Drug Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AdditionalDrugSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AdditionalDrugSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Radiopharmaceutical>::s_keyword = Keyword::Radiopharmaceutical;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Radiopharmaceutical>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Radiopharmaceutical>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Radiopharmaceutical>::s_name = "Radiopharmaceutical";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Radiopharmaceutical>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Radiopharmaceutical>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugName>::s_keyword = Keyword::InterventionDrugName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugName>::s_element = 0x0034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugName>::s_name = "Intervention Drug Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDrugStartTime>::s_keyword = Keyword::InterventionDrugStartTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugStartTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDrugStartTime>::s_element = 0x0035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDrugStartTime>::s_name = "Intervention Drug Start Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDrugStartTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDrugStartTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionSequence>::s_keyword = Keyword::InterventionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionSequence>::s_element = 0x0036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionSequence>::s_name = "Intervention Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionStatus>::s_keyword = Keyword::InterventionStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionStatus>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionStatus>::s_element = 0x0038;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionStatus>::s_name = "Intervention Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionStatus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InterventionDescription>::s_keyword = Keyword::InterventionDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InterventionDescription>::s_element = 0x003A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InterventionDescription>::s_name = "Intervention Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InterventionDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InterventionDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CineRate>::s_keyword = Keyword::CineRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CineRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CineRate>::s_element = 0x0040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CineRate>::s_name = "Cine Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CineRate>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CineRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InitialCineRunState>::s_keyword = Keyword::InitialCineRunState;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InitialCineRunState>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InitialCineRunState>::s_element = 0x0042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InitialCineRunState>::s_name = "Initial Cine Run State";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InitialCineRunState>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InitialCineRunState>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SliceThickness>::s_keyword = Keyword::SliceThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceThickness>::s_element = 0x0050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SliceThickness>::s_name = "Slice Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SliceThickness>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SliceThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::KVP>::s_keyword = Keyword::KVP;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::KVP>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::KVP>::s_element = 0x0060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::KVP>::s_name = "KVP";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::KVP>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::KVP>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CountsAccumulated>::s_keyword = Keyword::CountsAccumulated;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountsAccumulated>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountsAccumulated>::s_element = 0x0070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CountsAccumulated>::s_name = "Counts Accumulated";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CountsAccumulated>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CountsAccumulated>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionTerminationCondition>::s_keyword =
    Keyword::AcquisitionTerminationCondition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTerminationCondition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTerminationCondition>::s_element = 0x0071;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionTerminationCondition>::s_name =
    "Acquisition Termination Condition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionTerminationCondition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionTerminationCondition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EffectiveDuration>::s_keyword = Keyword::EffectiveDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveDuration>::s_element = 0x0072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EffectiveDuration>::s_name = "Effective Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EffectiveDuration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EffectiveDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionStartCondition>::s_keyword = Keyword::AcquisitionStartCondition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionStartCondition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionStartCondition>::s_element = 0x0073;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionStartCondition>::s_name = "Acquisition Start Condition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionStartCondition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionStartCondition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionStartConditionData>::s_keyword =
    Keyword::AcquisitionStartConditionData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionStartConditionData>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionStartConditionData>::s_element = 0x0074;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionStartConditionData>::s_name =
    "Acquisition Start Condition Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionStartConditionData>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionStartConditionData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionTerminationConditionData>::s_keyword =
    Keyword::AcquisitionTerminationConditionData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTerminationConditionData>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTerminationConditionData>::s_element = 0x0075;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionTerminationConditionData>::s_name =
    "Acquisition Termination Condition Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionTerminationConditionData>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionTerminationConditionData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RepetitionTime>::s_keyword = Keyword::RepetitionTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RepetitionTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RepetitionTime>::s_element = 0x0080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RepetitionTime>::s_name = "Repetition Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RepetitionTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RepetitionTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EchoTime>::s_keyword = Keyword::EchoTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoTime>::s_element = 0x0081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EchoTime>::s_name = "Echo Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EchoTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EchoTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InversionTime>::s_keyword = Keyword::InversionTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionTime>::s_element = 0x0082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InversionTime>::s_name = "Inversion Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InversionTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InversionTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfAverages>::s_keyword = Keyword::NumberOfAverages;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfAverages>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfAverages>::s_element = 0x0083;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfAverages>::s_name = "Number of Averages";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfAverages>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfAverages>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagingFrequency>::s_keyword = Keyword::ImagingFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagingFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagingFrequency>::s_element = 0x0084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagingFrequency>::s_name = "Imaging Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagingFrequency>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagingFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagedNucleus>::s_keyword = Keyword::ImagedNucleus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagedNucleus>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagedNucleus>::s_element = 0x0085;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagedNucleus>::s_name = "Imaged Nucleus";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagedNucleus>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagedNucleus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EchoNumbers>::s_keyword = Keyword::EchoNumbers;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoNumbers>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoNumbers>::s_element = 0x0086;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EchoNumbers>::s_name = "Echo Number(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EchoNumbers>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EchoNumbers>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MagneticFieldStrength>::s_keyword = Keyword::MagneticFieldStrength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MagneticFieldStrength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MagneticFieldStrength>::s_element = 0x0087;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MagneticFieldStrength>::s_name = "Magnetic field Strength";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MagneticFieldStrength>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MagneticFieldStrength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpacingBetweenSlices>::s_keyword = Keyword::SpacingBetweenSlices;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpacingBetweenSlices>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpacingBetweenSlices>::s_element = 0x0088;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpacingBetweenSlices>::s_name = "Spacing Between Slices";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpacingBetweenSlices>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpacingBetweenSlices>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_keyword = Keyword::NumberOfPhaseEncodingSteps;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_element = 0x0089;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_name =
    "Number of Phase Encoding Steps";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfPhaseEncodingSteps>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataCollectionDiameter>::s_keyword = Keyword::DataCollectionDiameter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataCollectionDiameter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataCollectionDiameter>::s_element = 0x0090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataCollectionDiameter>::s_name = "Data Collection Diameter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataCollectionDiameter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataCollectionDiameter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EchoTrainLength>::s_keyword = Keyword::EchoTrainLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoTrainLength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoTrainLength>::s_element = 0x0091;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EchoTrainLength>::s_name = "Echo Train Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EchoTrainLength>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EchoTrainLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PercentSampling>::s_keyword = Keyword::PercentSampling;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PercentSampling>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PercentSampling>::s_element = 0x0093;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PercentSampling>::s_name = "Percent Sampling";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PercentSampling>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PercentSampling>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PercentPhaseFieldOfView>::s_keyword = Keyword::PercentPhaseFieldOfView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PercentPhaseFieldOfView>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PercentPhaseFieldOfView>::s_element = 0x0094;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PercentPhaseFieldOfView>::s_name = "Percent Phase field of view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PercentPhaseFieldOfView>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PercentPhaseFieldOfView>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelBandwidth>::s_keyword = Keyword::PixelBandwidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelBandwidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelBandwidth>::s_element = 0x0095;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelBandwidth>::s_name = "Pixel Bandwidth";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelBandwidth>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelBandwidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeviceSerialNumber>::s_keyword = Keyword::DeviceSerialNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceSerialNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceSerialNumber>::s_element = 0x1000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeviceSerialNumber>::s_name = "Device Serial Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeviceSerialNumber>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeviceSerialNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeviceUID>::s_keyword = Keyword::DeviceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceUID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceUID>::s_element = 0x1002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeviceUID>::s_name = "Device UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeviceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeviceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeviceID>::s_keyword = Keyword::DeviceID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviceID>::s_element = 0x1003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeviceID>::s_name = "Device ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeviceID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeviceID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlateID>::s_keyword = Keyword::PlateID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlateID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlateID>::s_element = 0x1004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlateID>::s_name = "Plate ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlateID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlateID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneratorID>::s_keyword = Keyword::GeneratorID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneratorID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneratorID>::s_element = 0x1005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneratorID>::s_name = "Generator ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneratorID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneratorID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridID>::s_keyword = Keyword::GridID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridID>::s_element = 0x1006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridID>::s_name = "Grid ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CassetteID>::s_keyword = Keyword::CassetteID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteID>::s_element = 0x1007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CassetteID>::s_name = "Cassette ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CassetteID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CassetteID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GantryID>::s_keyword = Keyword::GantryID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryID>::s_element = 0x1008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GantryID>::s_name = "Gantry ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GantryID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GantryID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UniqueDeviceIdentifier>::s_keyword = Keyword::UniqueDeviceIdentifier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniqueDeviceIdentifier>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniqueDeviceIdentifier>::s_element = 0x1009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UniqueDeviceIdentifier>::s_name = "Unique Device Identifier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UniqueDeviceIdentifier>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UniqueDeviceIdentifier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UDISequence>::s_keyword = Keyword::UDISequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UDISequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UDISequence>::s_element = 0x100A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UDISequence>::s_name = "UDI Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UDISequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UDISequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ManufacturerDeviceClassUID>::s_keyword = Keyword::ManufacturerDeviceClassUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ManufacturerDeviceClassUID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ManufacturerDeviceClassUID>::s_element = 0x100B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ManufacturerDeviceClassUID>::s_name =
    "Manufacturer's Device Class UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ManufacturerDeviceClassUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ManufacturerDeviceClassUID>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryCaptureDeviceID>::s_keyword = Keyword::SecondaryCaptureDeviceID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceID>::s_element = 0x1010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryCaptureDeviceID>::s_name = "Secondary Capture Device ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryCaptureDeviceID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryCaptureDeviceID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DateOfSecondaryCapture>::s_keyword = Keyword::DateOfSecondaryCapture;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfSecondaryCapture>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfSecondaryCapture>::s_element = 0x1012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DateOfSecondaryCapture>::s_name = "Date of Secondary Capture";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DateOfSecondaryCapture>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DateOfSecondaryCapture>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfSecondaryCapture>::s_keyword = Keyword::TimeOfSecondaryCapture;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfSecondaryCapture>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfSecondaryCapture>::s_element = 0x1014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfSecondaryCapture>::s_name = "Time of Secondary Capture";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfSecondaryCapture>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfSecondaryCapture>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_keyword =
    Keyword::SecondaryCaptureDeviceManufacturer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_element = 0x1016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_name =
    "Secondary Capture Device Manufacturer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryCaptureDeviceManufacturer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_keyword =
    Keyword::SecondaryCaptureDeviceManufacturerModelName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_element = 0x1018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_name =
    "Secondary Capture Device Manufacturer's Model Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_keyword =
    Keyword::SecondaryCaptureDeviceSoftwareVersions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_element = 0x1019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_name =
    "Secondary Capture Device Software Versions";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SoftwareVersions>::s_keyword = Keyword::SoftwareVersions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftwareVersions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftwareVersions>::s_element = 0x1020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SoftwareVersions>::s_name = "Software Versions";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SoftwareVersions>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SoftwareVersions>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VideoImageFormatAcquired>::s_keyword = Keyword::VideoImageFormatAcquired;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VideoImageFormatAcquired>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VideoImageFormatAcquired>::s_element = 0x1022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VideoImageFormatAcquired>::s_name = "Video Image Format Acquired";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VideoImageFormatAcquired>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VideoImageFormatAcquired>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DigitalImageFormatAcquired>::s_keyword = Keyword::DigitalImageFormatAcquired;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitalImageFormatAcquired>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitalImageFormatAcquired>::s_element = 0x1023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DigitalImageFormatAcquired>::s_name =
    "Digital Image Format Acquired";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DigitalImageFormatAcquired>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DigitalImageFormatAcquired>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProtocolName>::s_keyword = Keyword::ProtocolName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProtocolName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProtocolName>::s_element = 0x1030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProtocolName>::s_name = "Protocol Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProtocolName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProtocolName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusRoute>::s_keyword = Keyword::ContrastBolusRoute;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusRoute>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusRoute>::s_element = 0x1040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusRoute>::s_name = "Contrast/Bolus Route";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusRoute>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusRoute>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusVolume>::s_keyword = Keyword::ContrastBolusVolume;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusVolume>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusVolume>::s_element = 0x1041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusVolume>::s_name = "Contrast/Bolus Volume";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusVolume>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusVolume>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusStartTime>::s_keyword = Keyword::ContrastBolusStartTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusStartTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusStartTime>::s_element = 0x1042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusStartTime>::s_name = "Contrast/Bolus Start Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusStartTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusStartTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusStopTime>::s_keyword = Keyword::ContrastBolusStopTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusStopTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusStopTime>::s_element = 0x1043;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusStopTime>::s_name = "Contrast/Bolus Stop Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusStopTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusStopTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusTotalDose>::s_keyword = Keyword::ContrastBolusTotalDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusTotalDose>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusTotalDose>::s_element = 0x1044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusTotalDose>::s_name = "Contrast/Bolus Total Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusTotalDose>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusTotalDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastFlowRate>::s_keyword = Keyword::ContrastFlowRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFlowRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFlowRate>::s_element = 0x1046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastFlowRate>::s_name = "Contrast Flow Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastFlowRate>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastFlowRate>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastFlowDuration>::s_keyword = Keyword::ContrastFlowDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFlowDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFlowDuration>::s_element = 0x1047;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastFlowDuration>::s_name = "Contrast Flow Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastFlowDuration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastFlowDuration>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusIngredient>::s_keyword = Keyword::ContrastBolusIngredient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredient>::s_element = 0x1048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusIngredient>::s_name = "Contrast/Bolus Ingredient";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusIngredient>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusIngredient>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusIngredientConcentration>::s_keyword =
    Keyword::ContrastBolusIngredientConcentration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientConcentration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientConcentration>::s_element = 0x1049;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusIngredientConcentration>::s_name =
    "Contrast/Bolus Ingredient Concentration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusIngredientConcentration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusIngredientConcentration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialResolution>::s_keyword = Keyword::SpatialResolution;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialResolution>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialResolution>::s_element = 0x1050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialResolution>::s_name = "Spatial Resolution";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialResolution>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialResolution>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TriggerTime>::s_keyword = Keyword::TriggerTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerTime>::s_element = 0x1060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TriggerTime>::s_name = "Trigger Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TriggerTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TriggerTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TriggerSourceOrType>::s_keyword = Keyword::TriggerSourceOrType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerSourceOrType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerSourceOrType>::s_element = 0x1061;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TriggerSourceOrType>::s_name = "Trigger Source or Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TriggerSourceOrType>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TriggerSourceOrType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalInterval>::s_keyword = Keyword::NominalInterval;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalInterval>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalInterval>::s_element = 0x1062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalInterval>::s_name = "Nominal Interval";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalInterval>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalInterval>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameTime>::s_keyword = Keyword::FrameTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameTime>::s_element = 0x1063;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameTime>::s_name = "Frame Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacFramingType>::s_keyword = Keyword::CardiacFramingType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacFramingType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacFramingType>::s_element = 0x1064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacFramingType>::s_name = "Cardiac Framing Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacFramingType>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacFramingType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameTimeVector>::s_keyword = Keyword::FrameTimeVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameTimeVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameTimeVector>::s_element = 0x1065;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameTimeVector>::s_name = "Frame Time Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameTimeVector>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameTimeVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameDelay>::s_keyword = Keyword::FrameDelay;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDelay>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDelay>::s_element = 0x1066;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameDelay>::s_name = "Frame Delay";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameDelay>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameDelay>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageTriggerDelay>::s_keyword = Keyword::ImageTriggerDelay;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageTriggerDelay>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageTriggerDelay>::s_element = 0x1067;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageTriggerDelay>::s_name = "Image Trigger Delay";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageTriggerDelay>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageTriggerDelay>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SynchronizationTrigger>::s_keyword = Keyword::SynchronizationTrigger;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationTrigger>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationTrigger>::s_element = 0x106A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SynchronizationTrigger>::s_name = "Synchronization Trigger";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SynchronizationTrigger>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SynchronizationTrigger>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SynchronizationChannel>::s_keyword = Keyword::SynchronizationChannel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationChannel>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationChannel>::s_element = 0x106C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SynchronizationChannel>::s_name = "Synchronization Channel";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SynchronizationChannel>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SynchronizationChannel>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalRoute>::s_keyword = Keyword::RadiopharmaceuticalRoute;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalRoute>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalRoute>::s_element = 0x1070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalRoute>::s_name = "Radiopharmaceutical Route";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalRoute>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalRoute>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalVolume>::s_keyword = Keyword::RadiopharmaceuticalVolume;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalVolume>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalVolume>::s_element = 0x1071;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalVolume>::s_name = "Radiopharmaceutical Volume";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalVolume>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalVolume>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalStartTime>::s_keyword =
    Keyword::RadiopharmaceuticalStartTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStartTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStartTime>::s_element = 0x1072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalStartTime>::s_name =
    "Radiopharmaceutical Start Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalStartTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalStartTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalStopTime>::s_keyword =
    Keyword::RadiopharmaceuticalStopTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStopTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStopTime>::s_element = 0x1073;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalStopTime>::s_name =
    "Radiopharmaceutical Stop Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalStopTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalStopTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadionuclideTotalDose>::s_keyword = Keyword::RadionuclideTotalDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclideTotalDose>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclideTotalDose>::s_element = 0x1074;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadionuclideTotalDose>::s_name = "Radionuclide Total Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadionuclideTotalDose>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadionuclideTotalDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadionuclideHalfLife>::s_keyword = Keyword::RadionuclideHalfLife;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclideHalfLife>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclideHalfLife>::s_element = 0x1075;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadionuclideHalfLife>::s_name = "Radionuclide Half Life";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadionuclideHalfLife>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadionuclideHalfLife>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadionuclidePositronFraction>::s_keyword =
    Keyword::RadionuclidePositronFraction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclidePositronFraction>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadionuclidePositronFraction>::s_element = 0x1076;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadionuclidePositronFraction>::s_name =
    "Radionuclide Positron Fraction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadionuclidePositronFraction>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadionuclidePositronFraction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_keyword =
    Keyword::RadiopharmaceuticalSpecificActivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_element = 0x1077;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_name =
    "Radiopharmaceutical Specific Activity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalSpecificActivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_keyword =
    Keyword::RadiopharmaceuticalStartDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_element = 0x1078;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_name =
    "Radiopharmaceutical Start DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalStartDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_keyword =
    Keyword::RadiopharmaceuticalStopDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_element = 0x1079;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_name =
    "Radiopharmaceutical Stop DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalStopDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BeatRejectionFlag>::s_keyword = Keyword::BeatRejectionFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BeatRejectionFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BeatRejectionFlag>::s_element = 0x1080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BeatRejectionFlag>::s_name = "Beat Rejection Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BeatRejectionFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BeatRejectionFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LowRRValue>::s_keyword = Keyword::LowRRValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LowRRValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LowRRValue>::s_element = 0x1081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LowRRValue>::s_name = "Low R-R Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LowRRValue>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LowRRValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::HighRRValue>::s_keyword = Keyword::HighRRValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HighRRValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HighRRValue>::s_element = 0x1082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::HighRRValue>::s_name = "High R-R Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::HighRRValue>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::HighRRValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntervalsAcquired>::s_keyword = Keyword::IntervalsAcquired;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntervalsAcquired>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntervalsAcquired>::s_element = 0x1083;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntervalsAcquired>::s_name = "Intervals Acquired";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntervalsAcquired>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntervalsAcquired>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntervalsRejected>::s_keyword = Keyword::IntervalsRejected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntervalsRejected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntervalsRejected>::s_element = 0x1084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntervalsRejected>::s_name = "Intervals Rejected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntervalsRejected>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntervalsRejected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PVCRejection>::s_keyword = Keyword::PVCRejection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PVCRejection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PVCRejection>::s_element = 0x1085;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PVCRejection>::s_name = "PVC Rejection";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PVCRejection>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PVCRejection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SkipBeats>::s_keyword = Keyword::SkipBeats;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SkipBeats>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SkipBeats>::s_element = 0x1086;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SkipBeats>::s_name = "Skip Beats";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SkipBeats>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SkipBeats>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::HeartRate>::s_keyword = Keyword::HeartRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HeartRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HeartRate>::s_element = 0x1088;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::HeartRate>::s_name = "Heart Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::HeartRate>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::HeartRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacNumberOfImages>::s_keyword = Keyword::CardiacNumberOfImages;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacNumberOfImages>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacNumberOfImages>::s_element = 0x1090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacNumberOfImages>::s_name = "Cardiac Number of Images";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacNumberOfImages>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacNumberOfImages>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TriggerWindow>::s_keyword = Keyword::TriggerWindow;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerWindow>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TriggerWindow>::s_element = 0x1094;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TriggerWindow>::s_name = "Trigger Window";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TriggerWindow>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TriggerWindow>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionDiameter>::s_keyword = Keyword::ReconstructionDiameter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionDiameter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionDiameter>::s_element = 0x1100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionDiameter>::s_name = "Reconstruction Diameter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionDiameter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionDiameter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceSourceToDetector>::s_keyword = Keyword::DistanceSourceToDetector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToDetector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToDetector>::s_element = 0x1110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceSourceToDetector>::s_name = "Distance Source to Detector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceSourceToDetector>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceSourceToDetector>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceSourceToPatient>::s_keyword = Keyword::DistanceSourceToPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToPatient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToPatient>::s_element = 0x1111;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceSourceToPatient>::s_name = "Distance Source to Patient";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceSourceToPatient>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceSourceToPatient>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_keyword =
    Keyword::EstimatedRadiographicMagnificationFactor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_element = 0x1114;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_name =
    "Estimated Radiographic Magnification Factor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EstimatedRadiographicMagnificationFactor>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GantryDetectorTilt>::s_keyword = Keyword::GantryDetectorTilt;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryDetectorTilt>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryDetectorTilt>::s_element = 0x1120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GantryDetectorTilt>::s_name = "Gantry/Detector Tilt";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GantryDetectorTilt>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GantryDetectorTilt>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GantryDetectorSlew>::s_keyword = Keyword::GantryDetectorSlew;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryDetectorSlew>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryDetectorSlew>::s_element = 0x1121;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GantryDetectorSlew>::s_name = "Gantry/Detector Slew";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GantryDetectorSlew>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GantryDetectorSlew>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableHeight>::s_keyword = Keyword::TableHeight;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHeight>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHeight>::s_element = 0x1130;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableHeight>::s_name = "Table Height";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableHeight>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableHeight>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableTraverse>::s_keyword = Keyword::TableTraverse;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableTraverse>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableTraverse>::s_element = 0x1131;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableTraverse>::s_name = "Table Traverse";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableTraverse>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableTraverse>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableMotion>::s_keyword = Keyword::TableMotion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableMotion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableMotion>::s_element = 0x1134;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableMotion>::s_name = "Table Motion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableMotion>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableMotion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableVerticalIncrement>::s_keyword = Keyword::TableVerticalIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableVerticalIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableVerticalIncrement>::s_element = 0x1135;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableVerticalIncrement>::s_name = "Table Vertical Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableVerticalIncrement>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableVerticalIncrement>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableLateralIncrement>::s_keyword = Keyword::TableLateralIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableLateralIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableLateralIncrement>::s_element = 0x1136;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableLateralIncrement>::s_name = "Table Lateral Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableLateralIncrement>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableLateralIncrement>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableLongitudinalIncrement>::s_keyword = Keyword::TableLongitudinalIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableLongitudinalIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableLongitudinalIncrement>::s_element = 0x1137;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableLongitudinalIncrement>::s_name = "Table Longitudinal Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableLongitudinalIncrement>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableLongitudinalIncrement>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableAngle>::s_keyword = Keyword::TableAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableAngle>::s_element = 0x1138;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableAngle>::s_name = "Table Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableType>::s_keyword = Keyword::TableType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableType>::s_element = 0x113A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableType>::s_name = "Table Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RotationDirection>::s_keyword = Keyword::RotationDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RotationDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RotationDirection>::s_element = 0x1140;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RotationDirection>::s_name = "Rotation Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RotationDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RotationDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadialPosition>::s_keyword = Keyword::RadialPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadialPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadialPosition>::s_element = 0x1142;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadialPosition>::s_name = "Radial Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadialPosition>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadialPosition>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanArc>::s_keyword = Keyword::ScanArc;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanArc>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanArc>::s_element = 0x1143;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanArc>::s_name = "Scan Arc";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanArc>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanArc>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AngularStep>::s_keyword = Keyword::AngularStep;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AngularStep>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AngularStep>::s_element = 0x1144;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AngularStep>::s_name = "Angular Step";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AngularStep>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AngularStep>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterOfRotationOffset>::s_keyword = Keyword::CenterOfRotationOffset;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfRotationOffset>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfRotationOffset>::s_element = 0x1145;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterOfRotationOffset>::s_name = "Center of Rotation Offset";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterOfRotationOffset>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterOfRotationOffset>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewShape>::s_keyword = Keyword::FieldOfViewShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewShape>::s_element = 0x1147;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewShape>::s_name = "field of view Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewShape>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewDimensions>::s_keyword = Keyword::FieldOfViewDimensions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDimensions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDimensions>::s_element = 0x1149;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewDimensions>::s_name = "field of view Dimension(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewDimensions>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewDimensions>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureTime>::s_keyword = Keyword::ExposureTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTime>::s_element = 0x1150;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureTime>::s_name = "Exposure Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureTime>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayTubeCurrent>::s_keyword = Keyword::XRayTubeCurrent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrent>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrent>::s_element = 0x1151;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayTubeCurrent>::s_name = "X-Ray Tube Current";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayTubeCurrent>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayTubeCurrent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Exposure>::s_keyword = Keyword::Exposure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Exposure>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Exposure>::s_element = 0x1152;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Exposure>::s_name = "Exposure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Exposure>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Exposure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureInuAs>::s_keyword = Keyword::ExposureInuAs;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureInuAs>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureInuAs>::s_element = 0x1153;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureInuAs>::s_name = "Exposure in uAs";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureInuAs>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureInuAs>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AveragePulseWidth>::s_keyword = Keyword::AveragePulseWidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AveragePulseWidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AveragePulseWidth>::s_element = 0x1154;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AveragePulseWidth>::s_name = "Average Pulse Width";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AveragePulseWidth>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AveragePulseWidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiationSetting>::s_keyword = Keyword::RadiationSetting;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiationSetting>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiationSetting>::s_element = 0x1155;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiationSetting>::s_name = "Radiation Setting";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiationSetting>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiationSetting>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RectificationType>::s_keyword = Keyword::RectificationType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RectificationType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RectificationType>::s_element = 0x1156;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RectificationType>::s_name = "Rectification Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RectificationType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RectificationType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiationMode>::s_keyword = Keyword::RadiationMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiationMode>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiationMode>::s_element = 0x115A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiationMode>::s_name = "Radiation Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiationMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiationMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_keyword =
    Keyword::ImageAndFluoroscopyAreaDoseProduct;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_element = 0x115E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_name =
    "Image and Fluoroscopy Area Dose Product";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterType>::s_keyword = Keyword::FilterType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterType>::s_element = 0x1160;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterType>::s_name = "filter Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterType>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TypeOfFilters>::s_keyword = Keyword::TypeOfFilters;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TypeOfFilters>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TypeOfFilters>::s_element = 0x1161;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TypeOfFilters>::s_name = "Type of Filters";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TypeOfFilters>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TypeOfFilters>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntensifierSize>::s_keyword = Keyword::IntensifierSize;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierSize>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierSize>::s_element = 0x1162;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntensifierSize>::s_name = "Intensifier Size";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntensifierSize>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntensifierSize>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagerPixelSpacing>::s_keyword = Keyword::ImagerPixelSpacing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagerPixelSpacing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagerPixelSpacing>::s_element = 0x1164;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagerPixelSpacing>::s_name = "Imager Pixel Spacing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagerPixelSpacing>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagerPixelSpacing>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Grid>::s_keyword = Keyword::Grid;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Grid>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Grid>::s_element = 0x1166;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Grid>::s_name = "Grid";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Grid>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Grid>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeneratorPower>::s_keyword = Keyword::GeneratorPower;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneratorPower>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeneratorPower>::s_element = 0x1170;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeneratorPower>::s_name = "Generator Power";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeneratorPower>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeneratorPower>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorGridName>::s_keyword = Keyword::CollimatorGridName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorGridName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorGridName>::s_element = 0x1180;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorGridName>::s_name = "Collimator/grid Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorGridName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorGridName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorType>::s_keyword = Keyword::CollimatorType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorType>::s_element = 0x1181;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorType>::s_name = "Collimator Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FocalDistance>::s_keyword = Keyword::FocalDistance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalDistance>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalDistance>::s_element = 0x1182;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FocalDistance>::s_name = "Focal Distance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FocalDistance>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FocalDistance>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XFocusCenter>::s_keyword = Keyword::XFocusCenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XFocusCenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XFocusCenter>::s_element = 0x1183;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XFocusCenter>::s_name = "X Focus Center";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XFocusCenter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XFocusCenter>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::YFocusCenter>::s_keyword = Keyword::YFocusCenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YFocusCenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YFocusCenter>::s_element = 0x1184;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::YFocusCenter>::s_name = "Y Focus Center";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::YFocusCenter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::YFocusCenter>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FocalSpots>::s_keyword = Keyword::FocalSpots;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalSpots>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocalSpots>::s_element = 0x1190;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FocalSpots>::s_name = "Focal Spot(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FocalSpots>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FocalSpots>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AnodeTargetMaterial>::s_keyword = Keyword::AnodeTargetMaterial;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnodeTargetMaterial>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnodeTargetMaterial>::s_element = 0x1191;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AnodeTargetMaterial>::s_name = "Anode Target Material";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AnodeTargetMaterial>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AnodeTargetMaterial>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BodyPartThickness>::s_keyword = Keyword::BodyPartThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BodyPartThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BodyPartThickness>::s_element = 0x11A0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BodyPartThickness>::s_name = "Body Part Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BodyPartThickness>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BodyPartThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CompressionForce>::s_keyword = Keyword::CompressionForce;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionForce>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionForce>::s_element = 0x11A2;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CompressionForce>::s_name = "Compression Force";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CompressionForce>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CompressionForce>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CompressionPressure>::s_keyword = Keyword::CompressionPressure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionPressure>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionPressure>::s_element = 0x11A3;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CompressionPressure>::s_name = "Compression Pressure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CompressionPressure>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CompressionPressure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PaddleDescription>::s_keyword = Keyword::PaddleDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PaddleDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PaddleDescription>::s_element = 0x11A4;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PaddleDescription>::s_name = "Paddle Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PaddleDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PaddleDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CompressionContactArea>::s_keyword = Keyword::CompressionContactArea;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionContactArea>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CompressionContactArea>::s_element = 0x11A5;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CompressionContactArea>::s_name = "Compression Contact Area";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CompressionContactArea>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CompressionContactArea>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DateOfLastCalibration>::s_keyword = Keyword::DateOfLastCalibration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfLastCalibration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfLastCalibration>::s_element = 0x1200;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DateOfLastCalibration>::s_name = "Date of Last Calibration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DateOfLastCalibration>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DateOfLastCalibration>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfLastCalibration>::s_keyword = Keyword::TimeOfLastCalibration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfLastCalibration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfLastCalibration>::s_element = 0x1201;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfLastCalibration>::s_name = "Time of Last Calibration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfLastCalibration>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfLastCalibration>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DateOfManufacture>::s_keyword = Keyword::DateOfManufacture;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfManufacture>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfManufacture>::s_element = 0x1204;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DateOfManufacture>::s_name = "Date of Manufacture";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DateOfManufacture>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DateOfManufacture>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DateOfInstallation>::s_keyword = Keyword::DateOfInstallation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfInstallation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfInstallation>::s_element = 0x1205;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DateOfInstallation>::s_name = "Date of Installation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DateOfInstallation>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DateOfInstallation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConvolutionKernel>::s_keyword = Keyword::ConvolutionKernel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConvolutionKernel>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConvolutionKernel>::s_element = 0x1210;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConvolutionKernel>::s_name = "Convolution Kernel";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConvolutionKernel>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConvolutionKernel>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ActualFrameDuration>::s_keyword = Keyword::ActualFrameDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualFrameDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualFrameDuration>::s_element = 0x1242;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ActualFrameDuration>::s_name = "Actual Frame Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ActualFrameDuration>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ActualFrameDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CountRate>::s_keyword = Keyword::CountRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountRate>::s_element = 0x1243;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CountRate>::s_name = "Count Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CountRate>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CountRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PreferredPlaybackSequencing>::s_keyword =
    Keyword::PreferredPlaybackSequencing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PreferredPlaybackSequencing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PreferredPlaybackSequencing>::s_element = 0x1244;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PreferredPlaybackSequencing>::s_name =
    "Preferred Playback Sequencing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PreferredPlaybackSequencing>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PreferredPlaybackSequencing>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReceiveCoilName>::s_keyword = Keyword::ReceiveCoilName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilName>::s_element = 0x1250;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReceiveCoilName>::s_name = "Receive Coil Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReceiveCoilName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReceiveCoilName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransmitCoilName>::s_keyword = Keyword::TransmitCoilName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilName>::s_element = 0x1251;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransmitCoilName>::s_name = "Transmit Coil Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransmitCoilName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransmitCoilName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlateType>::s_keyword = Keyword::PlateType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlateType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlateType>::s_element = 0x1260;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlateType>::s_name = "Plate Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlateType>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlateType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhosphorType>::s_keyword = Keyword::PhosphorType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhosphorType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhosphorType>::s_element = 0x1261;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhosphorType>::s_name = "Phosphor Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhosphorType>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhosphorType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WaterEquivalentDiameter>::s_keyword = Keyword::WaterEquivalentDiameter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterEquivalentDiameter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterEquivalentDiameter>::s_element = 0x1271;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WaterEquivalentDiameter>::s_name = "Water Equivalent Diameter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WaterEquivalentDiameter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WaterEquivalentDiameter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_keyword =
    Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_element =
    0x1272;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_name =
    "Water Equivalent Diameter Calculation Method Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanVelocity>::s_keyword = Keyword::ScanVelocity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanVelocity>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanVelocity>::s_element = 0x1300;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanVelocity>::s_name = "Scan Velocity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanVelocity>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanVelocity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WholeBodyTechnique>::s_keyword = Keyword::WholeBodyTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WholeBodyTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WholeBodyTechnique>::s_element = 0x1301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WholeBodyTechnique>::s_name = "Whole Body technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WholeBodyTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WholeBodyTechnique>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanLength>::s_keyword = Keyword::ScanLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanLength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanLength>::s_element = 0x1302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanLength>::s_name = "Scan Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanLength>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionMatrix>::s_keyword = Keyword::AcquisitionMatrix;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMatrix>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMatrix>::s_element = 0x1310;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionMatrix>::s_name = "Acquisition Matrix";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionMatrix>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionMatrix>::s_vm = VM::MIN_4_MAX_4;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InPlanePhaseEncodingDirection>::s_keyword =
    Keyword::InPlanePhaseEncodingDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InPlanePhaseEncodingDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InPlanePhaseEncodingDirection>::s_element = 0x1312;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InPlanePhaseEncodingDirection>::s_name =
    "In-plane Phase Encoding Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InPlanePhaseEncodingDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InPlanePhaseEncodingDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlipAngle>::s_keyword = Keyword::FlipAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlipAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlipAngle>::s_element = 0x1314;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlipAngle>::s_name = "Flip Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlipAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlipAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VariableFlipAngleFlag>::s_keyword = Keyword::VariableFlipAngleFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VariableFlipAngleFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VariableFlipAngleFlag>::s_element = 0x1315;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VariableFlipAngleFlag>::s_name = "Variable Flip Angle Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VariableFlipAngleFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VariableFlipAngleFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SAR>::s_keyword = Keyword::SAR;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SAR>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SAR>::s_element = 0x1316;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SAR>::s_name = "SAR";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SAR>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SAR>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::dBdt>::s_keyword = Keyword::dBdt;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::dBdt>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::dBdt>::s_element = 0x1318;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::dBdt>::s_name = "dB/dt";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::dBdt>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::dBdt>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::B1rms>::s_keyword = Keyword::B1rms;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::B1rms>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::B1rms>::s_element = 0x1320;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::B1rms>::s_name = "B1rms";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::B1rms>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::B1rms>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_keyword =
    Keyword::AcquisitionDeviceProcessingDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_element = 0x1400;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_name =
    "Acquisition Device Processing Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDeviceProcessingDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_keyword =
    Keyword::AcquisitionDeviceProcessingCode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_element = 0x1401;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_name =
    "Acquisition Device Processing Code";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDeviceProcessingCode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CassetteOrientation>::s_keyword = Keyword::CassetteOrientation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteOrientation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteOrientation>::s_element = 0x1402;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CassetteOrientation>::s_name = "Cassette Orientation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CassetteOrientation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CassetteOrientation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CassetteSize>::s_keyword = Keyword::CassetteSize;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteSize>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CassetteSize>::s_element = 0x1403;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CassetteSize>::s_name = "Cassette Size";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CassetteSize>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CassetteSize>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposuresOnPlate>::s_keyword = Keyword::ExposuresOnPlate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnPlate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnPlate>::s_element = 0x1404;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposuresOnPlate>::s_name = "Exposures on Plate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposuresOnPlate>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposuresOnPlate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RelativeXRayExposure>::s_keyword = Keyword::RelativeXRayExposure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelativeXRayExposure>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelativeXRayExposure>::s_element = 0x1405;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RelativeXRayExposure>::s_name = "Relative X-Ray Exposure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RelativeXRayExposure>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RelativeXRayExposure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureIndex>::s_keyword = Keyword::ExposureIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureIndex>::s_element = 0x1411;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureIndex>::s_name = "Exposure Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TargetExposureIndex>::s_keyword = Keyword::TargetExposureIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetExposureIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetExposureIndex>::s_element = 0x1412;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TargetExposureIndex>::s_name = "Target Exposure Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TargetExposureIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TargetExposureIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeviationIndex>::s_keyword = Keyword::DeviationIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviationIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeviationIndex>::s_element = 0x1413;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeviationIndex>::s_name = "Deviation Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeviationIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeviationIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColumnAngulation>::s_keyword = Keyword::ColumnAngulation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColumnAngulation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColumnAngulation>::s_element = 0x1450;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColumnAngulation>::s_name = "Column Angulation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColumnAngulation>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColumnAngulation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TomoLayerHeight>::s_keyword = Keyword::TomoLayerHeight;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoLayerHeight>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoLayerHeight>::s_element = 0x1460;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TomoLayerHeight>::s_name = "Tomo Layer Height";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TomoLayerHeight>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TomoLayerHeight>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TomoAngle>::s_keyword = Keyword::TomoAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoAngle>::s_element = 0x1470;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TomoAngle>::s_name = "Tomo Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TomoAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TomoAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TomoTime>::s_keyword = Keyword::TomoTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoTime>::s_element = 0x1480;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TomoTime>::s_name = "Tomo Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TomoTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TomoTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TomoType>::s_keyword = Keyword::TomoType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoType>::s_element = 0x1490;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TomoType>::s_name = "Tomo Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TomoType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TomoType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TomoClass>::s_keyword = Keyword::TomoClass;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoClass>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TomoClass>::s_element = 0x1491;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TomoClass>::s_name = "Tomo Class";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TomoClass>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TomoClass>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_keyword =
    Keyword::NumberOfTomosynthesisSourceImages;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_element = 0x1495;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_name =
    "Number of Tomosynthesis Source Images";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfTomosynthesisSourceImages>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerMotion>::s_keyword = Keyword::PositionerMotion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerMotion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerMotion>::s_element = 0x1500;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerMotion>::s_name = "Positioner Motion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerMotion>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerMotion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerType>::s_keyword = Keyword::PositionerType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerType>::s_element = 0x1508;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerType>::s_name = "Positioner Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerPrimaryAngle>::s_keyword = Keyword::PositionerPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngle>::s_element = 0x1510;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerPrimaryAngle>::s_name = "Positioner Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerPrimaryAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerSecondaryAngle>::s_keyword = Keyword::PositionerSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerSecondaryAngle>::s_element = 0x1511;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerSecondaryAngle>::s_name = "Positioner Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerSecondaryAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_keyword =
    Keyword::PositionerPrimaryAngleIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_element = 0x1520;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_name =
    "Positioner Primary Angle Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerPrimaryAngleIncrement>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_keyword =
    Keyword::PositionerSecondaryAngleIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_element = 0x1521;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_name =
    "Positioner Secondary Angle Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerSecondaryAngleIncrement>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorPrimaryAngle>::s_keyword = Keyword::DetectorPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorPrimaryAngle>::s_element = 0x1530;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorPrimaryAngle>::s_name = "Detector Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorPrimaryAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorSecondaryAngle>::s_keyword = Keyword::DetectorSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorSecondaryAngle>::s_element = 0x1531;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorSecondaryAngle>::s_name = "Detector Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorSecondaryAngle>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterShape>::s_keyword = Keyword::ShutterShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterShape>::s_element = 0x1600;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterShape>::s_name = "Shutter Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterShape>::s_vm = VM::MIN_1_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterLeftVerticalEdge>::s_keyword = Keyword::ShutterLeftVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterLeftVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterLeftVerticalEdge>::s_element = 0x1602;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterLeftVerticalEdge>::s_name = "Shutter Left Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterLeftVerticalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterLeftVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterRightVerticalEdge>::s_keyword = Keyword::ShutterRightVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterRightVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterRightVerticalEdge>::s_element = 0x1604;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterRightVerticalEdge>::s_name = "Shutter Right Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterRightVerticalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterRightVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterUpperHorizontalEdge>::s_keyword = Keyword::ShutterUpperHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterUpperHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterUpperHorizontalEdge>::s_element = 0x1606;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterUpperHorizontalEdge>::s_name =
    "Shutter Upper Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterUpperHorizontalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterUpperHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterLowerHorizontalEdge>::s_keyword = Keyword::ShutterLowerHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterLowerHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterLowerHorizontalEdge>::s_element = 0x1608;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterLowerHorizontalEdge>::s_name =
    "Shutter Lower Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterLowerHorizontalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterLowerHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterOfCircularShutter>::s_keyword = Keyword::CenterOfCircularShutter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularShutter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularShutter>::s_element = 0x1610;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterOfCircularShutter>::s_name = "Center of Circular Shutter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterOfCircularShutter>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterOfCircularShutter>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiusOfCircularShutter>::s_keyword = Keyword::RadiusOfCircularShutter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularShutter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularShutter>::s_element = 0x1612;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiusOfCircularShutter>::s_name = "Radius of Circular Shutter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiusOfCircularShutter>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiusOfCircularShutter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VerticesOfThePolygonalShutter>::s_keyword =
    Keyword::VerticesOfThePolygonalShutter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalShutter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalShutter>::s_element = 0x1620;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VerticesOfThePolygonalShutter>::s_name =
    "Vertices of the Polygonal Shutter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VerticesOfThePolygonalShutter>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VerticesOfThePolygonalShutter>::s_vm = VM::MIN_2_MAX_2N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterPresentationValue>::s_keyword = Keyword::ShutterPresentationValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterPresentationValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterPresentationValue>::s_element = 0x1622;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterPresentationValue>::s_name = "Shutter Presentation Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterPresentationValue>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterPresentationValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterOverlayGroup>::s_keyword = Keyword::ShutterOverlayGroup;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterOverlayGroup>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterOverlayGroup>::s_element = 0x1623;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterOverlayGroup>::s_name = "Shutter Overlay Group";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterOverlayGroup>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterOverlayGroup>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_keyword =
    Keyword::ShutterPresentationColorCIELabValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_element = 0x1624;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_name =
    "Shutter Presentation Color CIELab Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ShutterPresentationColorCIELabValue>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutlineShapeType>::s_keyword = Keyword::OutlineShapeType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineShapeType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineShapeType>::s_element = 0x1630;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutlineShapeType>::s_name = "Outline Shape Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutlineShapeType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutlineShapeType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutlineLeftVerticalEdge>::s_keyword = Keyword::OutlineLeftVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineLeftVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineLeftVerticalEdge>::s_element = 0x1631;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutlineLeftVerticalEdge>::s_name = "Outline Left Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutlineLeftVerticalEdge>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutlineLeftVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutlineRightVerticalEdge>::s_keyword = Keyword::OutlineRightVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineRightVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineRightVerticalEdge>::s_element = 0x1632;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutlineRightVerticalEdge>::s_name = "Outline Right Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutlineRightVerticalEdge>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutlineRightVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutlineUpperHorizontalEdge>::s_keyword = Keyword::OutlineUpperHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineUpperHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineUpperHorizontalEdge>::s_element = 0x1633;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutlineUpperHorizontalEdge>::s_name =
    "Outline Upper Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutlineUpperHorizontalEdge>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutlineUpperHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutlineLowerHorizontalEdge>::s_keyword = Keyword::OutlineLowerHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineLowerHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutlineLowerHorizontalEdge>::s_element = 0x1634;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutlineLowerHorizontalEdge>::s_name =
    "Outline Lower Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutlineLowerHorizontalEdge>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutlineLowerHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterOfCircularOutline>::s_keyword = Keyword::CenterOfCircularOutline;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularOutline>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularOutline>::s_element = 0x1635;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterOfCircularOutline>::s_name = "Center of Circular Outline";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterOfCircularOutline>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterOfCircularOutline>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiameterOfCircularOutline>::s_keyword = Keyword::DiameterOfCircularOutline;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiameterOfCircularOutline>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiameterOfCircularOutline>::s_element = 0x1636;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiameterOfCircularOutline>::s_name = "Diameter of Circular Outline";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiameterOfCircularOutline>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiameterOfCircularOutline>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfPolygonalVertices>::s_keyword = Keyword::NumberOfPolygonalVertices;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfPolygonalVertices>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfPolygonalVertices>::s_element = 0x1637;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfPolygonalVertices>::s_name = "Number of Polygonal Vertices";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfPolygonalVertices>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfPolygonalVertices>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VerticesOfThePolygonalOutline>::s_keyword =
    Keyword::VerticesOfThePolygonalOutline;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalOutline>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalOutline>::s_element = 0x1638;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VerticesOfThePolygonalOutline>::s_name =
    "Vertices of the Polygonal Outline";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VerticesOfThePolygonalOutline>::s_vr = VR::OF;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VerticesOfThePolygonalOutline>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorShape>::s_keyword = Keyword::CollimatorShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorShape>::s_element = 0x1700;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorShape>::s_name = "Collimator Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorShape>::s_vm = VM::MIN_1_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorLeftVerticalEdge>::s_keyword = Keyword::CollimatorLeftVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorLeftVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorLeftVerticalEdge>::s_element = 0x1702;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorLeftVerticalEdge>::s_name =
    "Collimator Left Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorLeftVerticalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorLeftVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorRightVerticalEdge>::s_keyword =
    Keyword::CollimatorRightVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorRightVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorRightVerticalEdge>::s_element = 0x1704;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorRightVerticalEdge>::s_name =
    "Collimator Right Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorRightVerticalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorRightVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_keyword =
    Keyword::CollimatorUpperHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_element = 0x1706;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_name =
    "Collimator Upper Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorUpperHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_keyword =
    Keyword::CollimatorLowerHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_element = 0x1708;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_name =
    "Collimator Lower Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorLowerHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterOfCircularCollimator>::s_keyword = Keyword::CenterOfCircularCollimator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularCollimator>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularCollimator>::s_element = 0x1710;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterOfCircularCollimator>::s_name =
    "Center of Circular Collimator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterOfCircularCollimator>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterOfCircularCollimator>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiusOfCircularCollimator>::s_keyword = Keyword::RadiusOfCircularCollimator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularCollimator>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularCollimator>::s_element = 0x1712;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiusOfCircularCollimator>::s_name =
    "Radius of Circular Collimator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiusOfCircularCollimator>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiusOfCircularCollimator>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_keyword =
    Keyword::VerticesOfThePolygonalCollimator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_element = 0x1720;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_name =
    "Vertices of the Polygonal Collimator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VerticesOfThePolygonalCollimator>::s_vm = VM::MIN_2_MAX_2N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionTimeSynchronized>::s_keyword =
    Keyword::AcquisitionTimeSynchronized;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTimeSynchronized>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionTimeSynchronized>::s_element = 0x1800;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionTimeSynchronized>::s_name =
    "Acquisition Time Synchronized";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionTimeSynchronized>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionTimeSynchronized>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeSource>::s_keyword = Keyword::TimeSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeSource>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeSource>::s_element = 0x1801;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeSource>::s_name = "Time Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeSource>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeDistributionProtocol>::s_keyword = Keyword::TimeDistributionProtocol;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeDistributionProtocol>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeDistributionProtocol>::s_element = 0x1802;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeDistributionProtocol>::s_name = "Time Distribution Protocol";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeDistributionProtocol>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeDistributionProtocol>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NTPSourceAddress>::s_keyword = Keyword::NTPSourceAddress;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NTPSourceAddress>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NTPSourceAddress>::s_element = 0x1803;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NTPSourceAddress>::s_name = "NTP Source Address";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NTPSourceAddress>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NTPSourceAddress>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PageNumberVector>::s_keyword = Keyword::PageNumberVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PageNumberVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PageNumberVector>::s_element = 0x2001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PageNumberVector>::s_name = "Page Number Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PageNumberVector>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PageNumberVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameLabelVector>::s_keyword = Keyword::FrameLabelVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLabelVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLabelVector>::s_element = 0x2002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameLabelVector>::s_name = "Frame Label Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameLabelVector>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameLabelVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FramePrimaryAngleVector>::s_keyword = Keyword::FramePrimaryAngleVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePrimaryAngleVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePrimaryAngleVector>::s_element = 0x2003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FramePrimaryAngleVector>::s_name = "Frame Primary Angle Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FramePrimaryAngleVector>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FramePrimaryAngleVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameSecondaryAngleVector>::s_keyword = Keyword::FrameSecondaryAngleVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameSecondaryAngleVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameSecondaryAngleVector>::s_element = 0x2004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameSecondaryAngleVector>::s_name = "Frame Secondary Angle Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameSecondaryAngleVector>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameSecondaryAngleVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SliceLocationVector>::s_keyword = Keyword::SliceLocationVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceLocationVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceLocationVector>::s_element = 0x2005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SliceLocationVector>::s_name = "Slice Location Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SliceLocationVector>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SliceLocationVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DisplayWindowLabelVector>::s_keyword = Keyword::DisplayWindowLabelVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayWindowLabelVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayWindowLabelVector>::s_element = 0x2006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DisplayWindowLabelVector>::s_name = "Display Window Label Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DisplayWindowLabelVector>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DisplayWindowLabelVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalScannedPixelSpacing>::s_keyword = Keyword::NominalScannedPixelSpacing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalScannedPixelSpacing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalScannedPixelSpacing>::s_element = 0x2010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalScannedPixelSpacing>::s_name =
    "Nominal Scanned Pixel Spacing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalScannedPixelSpacing>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalScannedPixelSpacing>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DigitizingDeviceTransportDirection>::s_keyword =
    Keyword::DigitizingDeviceTransportDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitizingDeviceTransportDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DigitizingDeviceTransportDirection>::s_element = 0x2020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DigitizingDeviceTransportDirection>::s_name =
    "Digitizing Device Transport Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DigitizingDeviceTransportDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DigitizingDeviceTransportDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RotationOfScannedFilm>::s_keyword = Keyword::RotationOfScannedFilm;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RotationOfScannedFilm>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RotationOfScannedFilm>::s_element = 0x2030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RotationOfScannedFilm>::s_name = "Rotation of Scanned Film";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RotationOfScannedFilm>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RotationOfScannedFilm>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BiopsyTargetSequence>::s_keyword = Keyword::BiopsyTargetSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BiopsyTargetSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BiopsyTargetSequence>::s_element = 0x2041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BiopsyTargetSequence>::s_name = "Biopsy Target Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BiopsyTargetSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BiopsyTargetSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TargetUID>::s_keyword = Keyword::TargetUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetUID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetUID>::s_element = 0x2042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TargetUID>::s_name = "Target UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TargetUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TargetUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LocalizingCursorPosition>::s_keyword = Keyword::LocalizingCursorPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LocalizingCursorPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LocalizingCursorPosition>::s_element = 0x2043;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LocalizingCursorPosition>::s_name = "Localizing cursor Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LocalizingCursorPosition>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LocalizingCursorPosition>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalculatedTargetPosition>::s_keyword = Keyword::CalculatedTargetPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedTargetPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedTargetPosition>::s_element = 0x2044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalculatedTargetPosition>::s_name = "Calculated Target Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalculatedTargetPosition>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalculatedTargetPosition>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TargetLabel>::s_keyword = Keyword::TargetLabel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetLabel>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TargetLabel>::s_element = 0x2045;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TargetLabel>::s_name = "Target Label";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TargetLabel>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TargetLabel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DisplayedZValue>::s_keyword = Keyword::DisplayedZValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayedZValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayedZValue>::s_element = 0x2046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DisplayedZValue>::s_name = "Displayed Z Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DisplayedZValue>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DisplayedZValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IVUSAcquisition>::s_keyword = Keyword::IVUSAcquisition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSAcquisition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSAcquisition>::s_element = 0x3100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IVUSAcquisition>::s_name = "IVUS Acquisition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IVUSAcquisition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IVUSAcquisition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IVUSPullbackRate>::s_keyword = Keyword::IVUSPullbackRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackRate>::s_element = 0x3101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IVUSPullbackRate>::s_name = "IVUS Pullback Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IVUSPullbackRate>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IVUSPullbackRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IVUSGatedRate>::s_keyword = Keyword::IVUSGatedRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSGatedRate>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSGatedRate>::s_element = 0x3102;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IVUSGatedRate>::s_name = "IVUS Gated Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IVUSGatedRate>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IVUSGatedRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_keyword =
    Keyword::IVUSPullbackStartFrameNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_element = 0x3103;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_name =
    "IVUS Pullback Start Frame Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IVUSPullbackStartFrameNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_keyword =
    Keyword::IVUSPullbackStopFrameNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_element = 0x3104;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_name =
    "IVUS Pullback Stop Frame Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IVUSPullbackStopFrameNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LesionNumber>::s_keyword = Keyword::LesionNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LesionNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LesionNumber>::s_element = 0x3105;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LesionNumber>::s_name = "Lesion Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LesionNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LesionNumber>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OutputPower>::s_keyword = Keyword::OutputPower;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutputPower>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OutputPower>::s_element = 0x5000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OutputPower>::s_name = "Output Power";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OutputPower>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OutputPower>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerData>::s_keyword = Keyword::TransducerData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerData>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerData>::s_element = 0x5010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerData>::s_name = "Transducer Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerData>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerData>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerIdentificationSequence>::s_keyword =
    Keyword::TransducerIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerIdentificationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerIdentificationSequence>::s_element = 0x5011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerIdentificationSequence>::s_name =
    "Transducer Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FocusDepth>::s_keyword = Keyword::FocusDepth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocusDepth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FocusDepth>::s_element = 0x5012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FocusDepth>::s_name = "Focus Depth";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FocusDepth>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FocusDepth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProcessingFunction>::s_keyword = Keyword::ProcessingFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProcessingFunction>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProcessingFunction>::s_element = 0x5020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProcessingFunction>::s_name = "Processing Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProcessingFunction>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProcessingFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MechanicalIndex>::s_keyword = Keyword::MechanicalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MechanicalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MechanicalIndex>::s_element = 0x5022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MechanicalIndex>::s_name = "Mechanical Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MechanicalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MechanicalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BoneThermalIndex>::s_keyword = Keyword::BoneThermalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BoneThermalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BoneThermalIndex>::s_element = 0x5024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BoneThermalIndex>::s_name = "Bone Thermal Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BoneThermalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BoneThermalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CranialThermalIndex>::s_keyword = Keyword::CranialThermalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CranialThermalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CranialThermalIndex>::s_element = 0x5026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CranialThermalIndex>::s_name = "Cranial Thermal Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CranialThermalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CranialThermalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SoftTissueThermalIndex>::s_keyword = Keyword::SoftTissueThermalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueThermalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueThermalIndex>::s_element = 0x5027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SoftTissueThermalIndex>::s_name = "Soft Tissue Thermal Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SoftTissueThermalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SoftTissueThermalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SoftTissueFocusThermalIndex>::s_keyword =
    Keyword::SoftTissueFocusThermalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueFocusThermalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueFocusThermalIndex>::s_element = 0x5028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SoftTissueFocusThermalIndex>::s_name =
    "Soft Tissue-focus Thermal Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SoftTissueFocusThermalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SoftTissueFocusThermalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_keyword =
    Keyword::SoftTissueSurfaceThermalIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_element = 0x5029;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_name =
    "Soft Tissue-surface Thermal Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SoftTissueSurfaceThermalIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DepthOfScanField>::s_keyword = Keyword::DepthOfScanField;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthOfScanField>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthOfScanField>::s_element = 0x5050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DepthOfScanField>::s_name = "Depth of Scan field";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DepthOfScanField>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DepthOfScanField>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientPosition>::s_keyword = Keyword::PatientPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPosition>::s_element = 0x5100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientPosition>::s_name = "Patient Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientPosition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientPosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ViewPosition>::s_keyword = Keyword::ViewPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ViewPosition>::s_element = 0x5101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ViewPosition>::s_name = "view Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ViewPosition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ViewPosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_keyword =
    Keyword::ProjectionEponymousNameCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_element = 0x5104;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_name =
    "Projection Eponymous Name Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProjectionEponymousNameCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Sensitivity>::s_keyword = Keyword::Sensitivity;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Sensitivity>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Sensitivity>::s_element = 0x6000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Sensitivity>::s_name = "Sensitivity";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Sensitivity>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Sensitivity>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SequenceOfUltrasoundRegions>::s_keyword =
    Keyword::SequenceOfUltrasoundRegions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceOfUltrasoundRegions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SequenceOfUltrasoundRegions>::s_element = 0x6011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SequenceOfUltrasoundRegions>::s_name =
    "Sequence of Ultrasound Regions";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SequenceOfUltrasoundRegions>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SequenceOfUltrasoundRegions>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionSpatialFormat>::s_keyword = Keyword::RegionSpatialFormat;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionSpatialFormat>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionSpatialFormat>::s_element = 0x6012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionSpatialFormat>::s_name = "Region Spatial Format";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionSpatialFormat>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionSpatialFormat>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionDataType>::s_keyword = Keyword::RegionDataType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionDataType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionDataType>::s_element = 0x6014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionDataType>::s_name = "Region Data Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionDataType>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionDataType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionFlags>::s_keyword = Keyword::RegionFlags;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionFlags>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionFlags>::s_element = 0x6016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionFlags>::s_name = "Region Flags";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionFlags>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionFlags>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionLocationMinX0>::s_keyword = Keyword::RegionLocationMinX0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMinX0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMinX0>::s_element = 0x6018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionLocationMinX0>::s_name = "Region Location Min X0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionLocationMinX0>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionLocationMinX0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionLocationMinY0>::s_keyword = Keyword::RegionLocationMinY0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMinY0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMinY0>::s_element = 0x601A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionLocationMinY0>::s_name = "Region Location Min Y0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionLocationMinY0>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionLocationMinY0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionLocationMaxX1>::s_keyword = Keyword::RegionLocationMaxX1;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMaxX1>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMaxX1>::s_element = 0x601C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionLocationMaxX1>::s_name = "Region Location Max X1";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionLocationMaxX1>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionLocationMaxX1>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegionLocationMaxY1>::s_keyword = Keyword::RegionLocationMaxY1;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMaxY1>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegionLocationMaxY1>::s_element = 0x601E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegionLocationMaxY1>::s_name = "Region Location Max Y1";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegionLocationMaxY1>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegionLocationMaxY1>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencePixelX0>::s_keyword = Keyword::ReferencePixelX0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelX0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelX0>::s_element = 0x6020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencePixelX0>::s_name = "Reference Pixel X0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencePixelX0>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencePixelX0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencePixelY0>::s_keyword = Keyword::ReferencePixelY0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelY0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelY0>::s_element = 0x6022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencePixelY0>::s_name = "Reference Pixel Y0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencePixelY0>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencePixelY0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysicalUnitsXDirection>::s_keyword = Keyword::PhysicalUnitsXDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalUnitsXDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalUnitsXDirection>::s_element = 0x6024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysicalUnitsXDirection>::s_name = "Physical Units X Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysicalUnitsXDirection>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysicalUnitsXDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysicalUnitsYDirection>::s_keyword = Keyword::PhysicalUnitsYDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalUnitsYDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalUnitsYDirection>::s_element = 0x6026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysicalUnitsYDirection>::s_name = "Physical Units Y Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysicalUnitsYDirection>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysicalUnitsYDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencePixelPhysicalValueX>::s_keyword =
    Keyword::ReferencePixelPhysicalValueX;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelPhysicalValueX>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelPhysicalValueX>::s_element = 0x6028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencePixelPhysicalValueX>::s_name =
    "Reference Pixel Physical Value X";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencePixelPhysicalValueX>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencePixelPhysicalValueX>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencePixelPhysicalValueY>::s_keyword =
    Keyword::ReferencePixelPhysicalValueY;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelPhysicalValueY>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencePixelPhysicalValueY>::s_element = 0x602A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencePixelPhysicalValueY>::s_name =
    "Reference Pixel Physical Value Y";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencePixelPhysicalValueY>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencePixelPhysicalValueY>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysicalDeltaX>::s_keyword = Keyword::PhysicalDeltaX;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDeltaX>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDeltaX>::s_element = 0x602C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysicalDeltaX>::s_name = "Physical Delta X";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysicalDeltaX>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysicalDeltaX>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysicalDeltaY>::s_keyword = Keyword::PhysicalDeltaY;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDeltaY>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDeltaY>::s_element = 0x602E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysicalDeltaY>::s_name = "Physical Delta Y";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysicalDeltaY>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysicalDeltaY>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerFrequency>::s_keyword = Keyword::TransducerFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerFrequency>::s_element = 0x6030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerFrequency>::s_name = "Transducer Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerFrequency>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerType>::s_keyword = Keyword::TransducerType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerType>::s_element = 0x6031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerType>::s_name = "Transducer Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PulseRepetitionFrequency>::s_keyword = Keyword::PulseRepetitionFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PulseRepetitionFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PulseRepetitionFrequency>::s_element = 0x6032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PulseRepetitionFrequency>::s_name = "Pulse Repetition Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PulseRepetitionFrequency>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PulseRepetitionFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DopplerCorrectionAngle>::s_keyword = Keyword::DopplerCorrectionAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerCorrectionAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerCorrectionAngle>::s_element = 0x6034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DopplerCorrectionAngle>::s_name = "Doppler Correction Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DopplerCorrectionAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DopplerCorrectionAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SteeringAngle>::s_keyword = Keyword::SteeringAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SteeringAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SteeringAngle>::s_element = 0x6036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SteeringAngle>::s_name = "Steering Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SteeringAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SteeringAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DopplerSampleVolumeXPosition>::s_keyword =
    Keyword::DopplerSampleVolumeXPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerSampleVolumeXPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerSampleVolumeXPosition>::s_element = 0x6039;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DopplerSampleVolumeXPosition>::s_name =
    "Doppler Sample Volume X Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DopplerSampleVolumeXPosition>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DopplerSampleVolumeXPosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DopplerSampleVolumeYPosition>::s_keyword =
    Keyword::DopplerSampleVolumeYPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerSampleVolumeYPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DopplerSampleVolumeYPosition>::s_element = 0x603B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DopplerSampleVolumeYPosition>::s_name =
    "Doppler Sample Volume Y Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DopplerSampleVolumeYPosition>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DopplerSampleVolumeYPosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TMLinePositionX0>::s_keyword = Keyword::TMLinePositionX0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionX0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionX0>::s_element = 0x603D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TMLinePositionX0>::s_name = "TM-Line Position X0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TMLinePositionX0>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TMLinePositionX0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TMLinePositionY0>::s_keyword = Keyword::TMLinePositionY0;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionY0>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionY0>::s_element = 0x603F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TMLinePositionY0>::s_name = "TM-Line Position Y0";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TMLinePositionY0>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TMLinePositionY0>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TMLinePositionX1>::s_keyword = Keyword::TMLinePositionX1;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionX1>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionX1>::s_element = 0x6041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TMLinePositionX1>::s_name = "TM-Line Position X1";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TMLinePositionX1>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TMLinePositionX1>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TMLinePositionY1>::s_keyword = Keyword::TMLinePositionY1;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionY1>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TMLinePositionY1>::s_element = 0x6043;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TMLinePositionY1>::s_name = "TM-Line Position Y1";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TMLinePositionY1>::s_vr = VR::SL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TMLinePositionY1>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentOrganization>::s_keyword = Keyword::PixelComponentOrganization;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentOrganization>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentOrganization>::s_element = 0x6044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentOrganization>::s_name = "Pixel Component Organization";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentOrganization>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentOrganization>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentMask>::s_keyword = Keyword::PixelComponentMask;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentMask>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentMask>::s_element = 0x6046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentMask>::s_name = "Pixel Component Mask";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentMask>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentMask>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentRangeStart>::s_keyword = Keyword::PixelComponentRangeStart;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentRangeStart>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentRangeStart>::s_element = 0x6048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentRangeStart>::s_name = "Pixel Component Range Start";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentRangeStart>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentRangeStart>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentRangeStop>::s_keyword = Keyword::PixelComponentRangeStop;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentRangeStop>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentRangeStop>::s_element = 0x604A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentRangeStop>::s_name = "Pixel Component Range Stop";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentRangeStop>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentRangeStop>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentPhysicalUnits>::s_keyword =
    Keyword::PixelComponentPhysicalUnits;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentPhysicalUnits>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentPhysicalUnits>::s_element = 0x604C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentPhysicalUnits>::s_name =
    "Pixel Component Physical Units";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentPhysicalUnits>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentPhysicalUnits>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelComponentDataType>::s_keyword = Keyword::PixelComponentDataType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentDataType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelComponentDataType>::s_element = 0x604E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelComponentDataType>::s_name = "Pixel Component Data Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelComponentDataType>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelComponentDataType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfTableBreakPoints>::s_keyword = Keyword::NumberOfTableBreakPoints;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTableBreakPoints>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTableBreakPoints>::s_element = 0x6050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfTableBreakPoints>::s_name = "Number of Table Break Points";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfTableBreakPoints>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfTableBreakPoints>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableOfXBreakPoints>::s_keyword = Keyword::TableOfXBreakPoints;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfXBreakPoints>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfXBreakPoints>::s_element = 0x6052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableOfXBreakPoints>::s_name = "Table of X Break Points";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableOfXBreakPoints>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableOfXBreakPoints>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableOfYBreakPoints>::s_keyword = Keyword::TableOfYBreakPoints;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfYBreakPoints>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfYBreakPoints>::s_element = 0x6054;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableOfYBreakPoints>::s_name = "Table of Y Break Points";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableOfYBreakPoints>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableOfYBreakPoints>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfTableEntries>::s_keyword = Keyword::NumberOfTableEntries;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTableEntries>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTableEntries>::s_element = 0x6056;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfTableEntries>::s_name = "Number of Table Entries";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfTableEntries>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfTableEntries>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableOfPixelValues>::s_keyword = Keyword::TableOfPixelValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfPixelValues>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfPixelValues>::s_element = 0x6058;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableOfPixelValues>::s_name = "Table of Pixel Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableOfPixelValues>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableOfPixelValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableOfParameterValues>::s_keyword = Keyword::TableOfParameterValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfParameterValues>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableOfParameterValues>::s_element = 0x605A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableOfParameterValues>::s_name = "Table of Parameter Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableOfParameterValues>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableOfParameterValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RWaveTimeVector>::s_keyword = Keyword::RWaveTimeVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RWaveTimeVector>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RWaveTimeVector>::s_element = 0x6060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RWaveTimeVector>::s_name = "R Wave Time Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RWaveTimeVector>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RWaveTimeVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_keyword =
    Keyword::ActiveImageAreaOverlayGroup;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_element = 0x6070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_name =
    "Active Image Area Overlay Group";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ActiveImageAreaOverlayGroup>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorConditionsNominalFlag>::s_keyword =
    Keyword::DetectorConditionsNominalFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorConditionsNominalFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorConditionsNominalFlag>::s_element = 0x7000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorConditionsNominalFlag>::s_name =
    "Detector Conditions Nominal Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorConditionsNominalFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorConditionsNominalFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorTemperature>::s_keyword = Keyword::DetectorTemperature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorTemperature>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorTemperature>::s_element = 0x7001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorTemperature>::s_name = "Detector Temperature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorTemperature>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorTemperature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorType>::s_keyword = Keyword::DetectorType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorType>::s_element = 0x7004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorType>::s_name = "Detector Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorConfiguration>::s_keyword = Keyword::DetectorConfiguration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorConfiguration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorConfiguration>::s_element = 0x7005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorConfiguration>::s_name = "Detector Configuration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorConfiguration>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorConfiguration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorDescription>::s_keyword = Keyword::DetectorDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorDescription>::s_element = 0x7006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorDescription>::s_name = "Detector Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorDescription>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorMode>::s_keyword = Keyword::DetectorMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorMode>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorMode>::s_element = 0x7008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorMode>::s_name = "Detector Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorMode>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorID>::s_keyword = Keyword::DetectorID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorID>::s_element = 0x700A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorID>::s_name = "Detector ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DateOfLastDetectorCalibration>::s_keyword =
    Keyword::DateOfLastDetectorCalibration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfLastDetectorCalibration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DateOfLastDetectorCalibration>::s_element = 0x700C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DateOfLastDetectorCalibration>::s_name =
    "Date of Last Detector Calibration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DateOfLastDetectorCalibration>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DateOfLastDetectorCalibration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfLastDetectorCalibration>::s_keyword =
    Keyword::TimeOfLastDetectorCalibration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfLastDetectorCalibration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfLastDetectorCalibration>::s_element = 0x700E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfLastDetectorCalibration>::s_name =
    "Time of Last Detector Calibration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfLastDetectorCalibration>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfLastDetectorCalibration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_keyword =
    Keyword::ExposuresOnDetectorSinceLastCalibration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_element = 0x7010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_name =
    "Exposures on Detector Since Last Calibration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposuresOnDetectorSinceLastCalibration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_keyword =
    Keyword::ExposuresOnDetectorSinceManufactured;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_element = 0x7011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_name =
    "Exposures on Detector Since Manufactured";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposuresOnDetectorSinceManufactured>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorTimeSinceLastExposure>::s_keyword =
    Keyword::DetectorTimeSinceLastExposure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorTimeSinceLastExposure>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorTimeSinceLastExposure>::s_element = 0x7012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorTimeSinceLastExposure>::s_name =
    "Detector Time Since Last Exposure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorTimeSinceLastExposure>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorTimeSinceLastExposure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveTime>::s_keyword = Keyword::DetectorActiveTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveTime>::s_element = 0x7014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveTime>::s_name = "Detector Active Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveTime>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_keyword =
    Keyword::DetectorActivationOffsetFromExposure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_element = 0x7016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_name =
    "Detector Activation Offset From Exposure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActivationOffsetFromExposure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorBinning>::s_keyword = Keyword::DetectorBinning;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorBinning>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorBinning>::s_element = 0x701A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorBinning>::s_name = "Detector Binning";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorBinning>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorBinning>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorElementPhysicalSize>::s_keyword =
    Keyword::DetectorElementPhysicalSize;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorElementPhysicalSize>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorElementPhysicalSize>::s_element = 0x7020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorElementPhysicalSize>::s_name =
    "Detector Element Physical Size";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorElementPhysicalSize>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorElementPhysicalSize>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorElementSpacing>::s_keyword = Keyword::DetectorElementSpacing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorElementSpacing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorElementSpacing>::s_element = 0x7022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorElementSpacing>::s_name = "Detector Element Spacing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorElementSpacing>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorElementSpacing>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveShape>::s_keyword = Keyword::DetectorActiveShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveShape>::s_element = 0x7024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveShape>::s_name = "Detector Active Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveShape>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveDimensions>::s_keyword = Keyword::DetectorActiveDimensions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveDimensions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveDimensions>::s_element = 0x7026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveDimensions>::s_name = "Detector Active Dimension(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveDimensions>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveDimensions>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveOrigin>::s_keyword = Keyword::DetectorActiveOrigin;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveOrigin>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveOrigin>::s_element = 0x7028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveOrigin>::s_name = "Detector Active Origin";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveOrigin>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveOrigin>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorManufacturerName>::s_keyword = Keyword::DetectorManufacturerName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorManufacturerName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorManufacturerName>::s_element = 0x702A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorManufacturerName>::s_name = "Detector Manufacturer Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorManufacturerName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorManufacturerName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorManufacturerModelName>::s_keyword =
    Keyword::DetectorManufacturerModelName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorManufacturerModelName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorManufacturerModelName>::s_element = 0x702B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorManufacturerModelName>::s_name =
    "Detector Manufacturer's Model Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorManufacturerModelName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorManufacturerModelName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewOrigin>::s_keyword = Keyword::FieldOfViewOrigin;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewOrigin>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewOrigin>::s_element = 0x7030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewOrigin>::s_name = "field of view Origin";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewOrigin>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewOrigin>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewRotation>::s_keyword = Keyword::FieldOfViewRotation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewRotation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewRotation>::s_element = 0x7032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewRotation>::s_name = "field of view Rotation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewRotation>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewRotation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewHorizontalFlip>::s_keyword = Keyword::FieldOfViewHorizontalFlip;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewHorizontalFlip>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewHorizontalFlip>::s_element = 0x7034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewHorizontalFlip>::s_name = "field of view Horizontal Flip";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewHorizontalFlip>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewHorizontalFlip>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_keyword =
    Keyword::PixelDataAreaOriginRelativeToFOV;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_element = 0x7036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_name =
    "Pixel Data Area Origin Relative To FOV";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelDataAreaOriginRelativeToFOV>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_keyword =
    Keyword::PixelDataAreaRotationAngleRelativeToFOV;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_element = 0x7038;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_name =
    "Pixel Data Area Rotation Angle Relative To FOV";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridAbsorbingMaterial>::s_keyword = Keyword::GridAbsorbingMaterial;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridAbsorbingMaterial>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridAbsorbingMaterial>::s_element = 0x7040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridAbsorbingMaterial>::s_name = "Grid Absorbing Material";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridAbsorbingMaterial>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridAbsorbingMaterial>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridSpacingMaterial>::s_keyword = Keyword::GridSpacingMaterial;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridSpacingMaterial>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridSpacingMaterial>::s_element = 0x7041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridSpacingMaterial>::s_name = "Grid Spacing Material";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridSpacingMaterial>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridSpacingMaterial>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridThickness>::s_keyword = Keyword::GridThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridThickness>::s_element = 0x7042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridThickness>::s_name = "Grid Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridThickness>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridPitch>::s_keyword = Keyword::GridPitch;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridPitch>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridPitch>::s_element = 0x7044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridPitch>::s_name = "Grid Pitch";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridPitch>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridPitch>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridAspectRatio>::s_keyword = Keyword::GridAspectRatio;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridAspectRatio>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridAspectRatio>::s_element = 0x7046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridAspectRatio>::s_name = "Grid Aspect Ratio";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridAspectRatio>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridAspectRatio>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridPeriod>::s_keyword = Keyword::GridPeriod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridPeriod>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridPeriod>::s_element = 0x7048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridPeriod>::s_name = "Grid Period";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridPeriod>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridPeriod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GridFocalDistance>::s_keyword = Keyword::GridFocalDistance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridFocalDistance>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GridFocalDistance>::s_element = 0x704C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GridFocalDistance>::s_name = "Grid Focal Distance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GridFocalDistance>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GridFocalDistance>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterMaterial>::s_keyword = Keyword::FilterMaterial;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterMaterial>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterMaterial>::s_element = 0x7050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterMaterial>::s_name = "filter Material";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterMaterial>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterMaterial>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterThicknessMinimum>::s_keyword = Keyword::FilterThicknessMinimum;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterThicknessMinimum>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterThicknessMinimum>::s_element = 0x7052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterThicknessMinimum>::s_name = "filter Thickness Minimum";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterThicknessMinimum>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterThicknessMinimum>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterThicknessMaximum>::s_keyword = Keyword::FilterThicknessMaximum;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterThicknessMaximum>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterThicknessMaximum>::s_element = 0x7054;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterThicknessMaximum>::s_name = "filter Thickness Maximum";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterThicknessMaximum>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterThicknessMaximum>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterBeamPathLengthMinimum>::s_keyword =
    Keyword::FilterBeamPathLengthMinimum;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterBeamPathLengthMinimum>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterBeamPathLengthMinimum>::s_element = 0x7056;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterBeamPathLengthMinimum>::s_name =
    "filter Beam Path Length Minimum";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterBeamPathLengthMinimum>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterBeamPathLengthMinimum>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FilterBeamPathLengthMaximum>::s_keyword =
    Keyword::FilterBeamPathLengthMaximum;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterBeamPathLengthMaximum>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FilterBeamPathLengthMaximum>::s_element = 0x7058;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FilterBeamPathLengthMaximum>::s_name =
    "filter Beam Path Length Maximum";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FilterBeamPathLengthMaximum>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FilterBeamPathLengthMaximum>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlMode>::s_keyword = Keyword::ExposureControlMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlMode>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlMode>::s_element = 0x7060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlMode>::s_name = "Exposure Control Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlModeDescription>::s_keyword =
    Keyword::ExposureControlModeDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlModeDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlModeDescription>::s_element = 0x7062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlModeDescription>::s_name =
    "Exposure Control Mode Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlModeDescription>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlModeDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureStatus>::s_keyword = Keyword::ExposureStatus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureStatus>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureStatus>::s_element = 0x7064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureStatus>::s_name = "Exposure Status";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureStatus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureStatus>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhototimerSetting>::s_keyword = Keyword::PhototimerSetting;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhototimerSetting>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhototimerSetting>::s_element = 0x7065;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhototimerSetting>::s_name = "Phototimer Setting";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhototimerSetting>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhototimerSetting>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureTimeInuS>::s_keyword = Keyword::ExposureTimeInuS;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInuS>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInuS>::s_element = 0x8150;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureTimeInuS>::s_name = "Exposure Time in uS";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureTimeInuS>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureTimeInuS>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayTubeCurrentInuA>::s_keyword = Keyword::XRayTubeCurrentInuA;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrentInuA>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrentInuA>::s_element = 0x8151;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayTubeCurrentInuA>::s_name = "X-Ray Tube Current in uA";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayTubeCurrentInuA>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayTubeCurrentInuA>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContentQualification>::s_keyword = Keyword::ContentQualification;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentQualification>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentQualification>::s_element = 0x9004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContentQualification>::s_name = "Content Qualification";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContentQualification>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContentQualification>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PulseSequenceName>::s_keyword = Keyword::PulseSequenceName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PulseSequenceName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PulseSequenceName>::s_element = 0x9005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PulseSequenceName>::s_name = "Pulse Sequence Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PulseSequenceName>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PulseSequenceName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRImagingModifierSequence>::s_keyword = Keyword::MRImagingModifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRImagingModifierSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRImagingModifierSequence>::s_element = 0x9006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRImagingModifierSequence>::s_name = "MR Imaging Modifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRImagingModifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRImagingModifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EchoPulseSequence>::s_keyword = Keyword::EchoPulseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoPulseSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoPulseSequence>::s_element = 0x9008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EchoPulseSequence>::s_name = "Echo Pulse Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EchoPulseSequence>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EchoPulseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InversionRecovery>::s_keyword = Keyword::InversionRecovery;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionRecovery>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionRecovery>::s_element = 0x9009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InversionRecovery>::s_name = "Inversion Recovery";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InversionRecovery>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InversionRecovery>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlowCompensation>::s_keyword = Keyword::FlowCompensation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlowCompensation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlowCompensation>::s_element = 0x9010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlowCompensation>::s_name = "Flow Compensation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlowCompensation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlowCompensation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultipleSpinEcho>::s_keyword = Keyword::MultipleSpinEcho;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultipleSpinEcho>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultipleSpinEcho>::s_element = 0x9011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultipleSpinEcho>::s_name = "Multiple Spin Echo";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultipleSpinEcho>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultipleSpinEcho>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultiPlanarExcitation>::s_keyword = Keyword::MultiPlanarExcitation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiPlanarExcitation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiPlanarExcitation>::s_element = 0x9012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultiPlanarExcitation>::s_name = "Multi-planar Excitation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultiPlanarExcitation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultiPlanarExcitation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhaseContrast>::s_keyword = Keyword::PhaseContrast;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhaseContrast>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhaseContrast>::s_element = 0x9014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhaseContrast>::s_name = "Phase Contrast";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhaseContrast>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhaseContrast>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfFlightContrast>::s_keyword = Keyword::TimeOfFlightContrast;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFlightContrast>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFlightContrast>::s_element = 0x9015;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfFlightContrast>::s_name = "Time of Flight Contrast";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfFlightContrast>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfFlightContrast>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Spoiling>::s_keyword = Keyword::Spoiling;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Spoiling>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Spoiling>::s_element = 0x9016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Spoiling>::s_name = "Spoiling";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Spoiling>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Spoiling>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SteadyStatePulseSequence>::s_keyword = Keyword::SteadyStatePulseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SteadyStatePulseSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SteadyStatePulseSequence>::s_element = 0x9017;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SteadyStatePulseSequence>::s_name = "Steady State Pulse Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SteadyStatePulseSequence>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SteadyStatePulseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EchoPlanarPulseSequence>::s_keyword = Keyword::EchoPlanarPulseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoPlanarPulseSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EchoPlanarPulseSequence>::s_element = 0x9018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EchoPlanarPulseSequence>::s_name = "Echo Planar Pulse Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EchoPlanarPulseSequence>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EchoPlanarPulseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TagAngleFirstAxis>::s_keyword = Keyword::TagAngleFirstAxis;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagAngleFirstAxis>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagAngleFirstAxis>::s_element = 0x9019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TagAngleFirstAxis>::s_name = "Tag Angle First Axis";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TagAngleFirstAxis>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TagAngleFirstAxis>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MagnetizationTransfer>::s_keyword = Keyword::MagnetizationTransfer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MagnetizationTransfer>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MagnetizationTransfer>::s_element = 0x9020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MagnetizationTransfer>::s_name = "Magnetization Transfer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MagnetizationTransfer>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MagnetizationTransfer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::T2Preparation>::s_keyword = Keyword::T2Preparation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::T2Preparation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::T2Preparation>::s_element = 0x9021;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::T2Preparation>::s_name = "T2 Preparation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::T2Preparation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::T2Preparation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BloodSignalNulling>::s_keyword = Keyword::BloodSignalNulling;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BloodSignalNulling>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BloodSignalNulling>::s_element = 0x9022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BloodSignalNulling>::s_name = "Blood Signal Nulling";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BloodSignalNulling>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BloodSignalNulling>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SaturationRecovery>::s_keyword = Keyword::SaturationRecovery;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SaturationRecovery>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SaturationRecovery>::s_element = 0x9024;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SaturationRecovery>::s_name = "Saturation Recovery";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SaturationRecovery>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SaturationRecovery>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpectrallySelectedSuppression>::s_keyword =
    Keyword::SpectrallySelectedSuppression;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectrallySelectedSuppression>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectrallySelectedSuppression>::s_element = 0x9025;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpectrallySelectedSuppression>::s_name =
    "Spectrally Selected Suppression";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpectrallySelectedSuppression>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpectrallySelectedSuppression>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpectrallySelectedExcitation>::s_keyword =
    Keyword::SpectrallySelectedExcitation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectrallySelectedExcitation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpectrallySelectedExcitation>::s_element = 0x9026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpectrallySelectedExcitation>::s_name =
    "Spectrally Selected Excitation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpectrallySelectedExcitation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpectrallySelectedExcitation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialPresaturation>::s_keyword = Keyword::SpatialPresaturation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialPresaturation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialPresaturation>::s_element = 0x9027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialPresaturation>::s_name = "Spatial Pre-saturation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialPresaturation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialPresaturation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Tagging>::s_keyword = Keyword::Tagging;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Tagging>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Tagging>::s_element = 0x9028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Tagging>::s_name = "Tagging";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Tagging>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Tagging>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OversamplingPhase>::s_keyword = Keyword::OversamplingPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OversamplingPhase>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OversamplingPhase>::s_element = 0x9029;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OversamplingPhase>::s_name = "Oversampling Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OversamplingPhase>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OversamplingPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TagSpacingFirstDimension>::s_keyword = Keyword::TagSpacingFirstDimension;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagSpacingFirstDimension>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagSpacingFirstDimension>::s_element = 0x9030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TagSpacingFirstDimension>::s_name = "Tag Spacing First Dimension";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TagSpacingFirstDimension>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TagSpacingFirstDimension>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeometryOfKSpaceTraversal>::s_keyword = Keyword::GeometryOfKSpaceTraversal;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometryOfKSpaceTraversal>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometryOfKSpaceTraversal>::s_element = 0x9032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeometryOfKSpaceTraversal>::s_name = "Geometry of k-Space Traversal";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeometryOfKSpaceTraversal>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeometryOfKSpaceTraversal>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SegmentedKSpaceTraversal>::s_keyword = Keyword::SegmentedKSpaceTraversal;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedKSpaceTraversal>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedKSpaceTraversal>::s_element = 0x9033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SegmentedKSpaceTraversal>::s_name = "Segmented k-Space Traversal";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SegmentedKSpaceTraversal>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SegmentedKSpaceTraversal>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_keyword =
    Keyword::RectilinearPhaseEncodeReordering;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_element = 0x9034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_name =
    "Rectilinear Phase Encode Reordering";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RectilinearPhaseEncodeReordering>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TagThickness>::s_keyword = Keyword::TagThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagThickness>::s_element = 0x9035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TagThickness>::s_name = "Tag Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TagThickness>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TagThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PartialFourierDirection>::s_keyword = Keyword::PartialFourierDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialFourierDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialFourierDirection>::s_element = 0x9036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PartialFourierDirection>::s_name = "Partial Fourier Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PartialFourierDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PartialFourierDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacSynchronizationTechnique>::s_keyword =
    Keyword::CardiacSynchronizationTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSynchronizationTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSynchronizationTechnique>::s_element = 0x9037;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacSynchronizationTechnique>::s_name =
    "Cardiac Synchronization technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacSynchronizationTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacSynchronizationTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReceiveCoilManufacturerName>::s_keyword =
    Keyword::ReceiveCoilManufacturerName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilManufacturerName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilManufacturerName>::s_element = 0x9041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReceiveCoilManufacturerName>::s_name =
    "Receive Coil Manufacturer Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReceiveCoilManufacturerName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReceiveCoilManufacturerName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRReceiveCoilSequence>::s_keyword = Keyword::MRReceiveCoilSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRReceiveCoilSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRReceiveCoilSequence>::s_element = 0x9042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRReceiveCoilSequence>::s_name = "MR Receive Coil Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRReceiveCoilSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRReceiveCoilSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReceiveCoilType>::s_keyword = Keyword::ReceiveCoilType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReceiveCoilType>::s_element = 0x9043;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReceiveCoilType>::s_name = "Receive Coil Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReceiveCoilType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReceiveCoilType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::QuadratureReceiveCoil>::s_keyword = Keyword::QuadratureReceiveCoil;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QuadratureReceiveCoil>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QuadratureReceiveCoil>::s_element = 0x9044;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::QuadratureReceiveCoil>::s_name = "Quadrature Receive Coil";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::QuadratureReceiveCoil>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::QuadratureReceiveCoil>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultiCoilDefinitionSequence>::s_keyword =
    Keyword::MultiCoilDefinitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiCoilDefinitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiCoilDefinitionSequence>::s_element = 0x9045;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultiCoilDefinitionSequence>::s_name =
    "Multi-Coil Definition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultiCoilDefinitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultiCoilDefinitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultiCoilConfiguration>::s_keyword = Keyword::MultiCoilConfiguration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiCoilConfiguration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiCoilConfiguration>::s_element = 0x9046;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultiCoilConfiguration>::s_name = "Multi-Coil Configuration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultiCoilConfiguration>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultiCoilConfiguration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRTransmitCoilSequence>::s_keyword = Keyword::MRTransmitCoilSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRTransmitCoilSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRTransmitCoilSequence>::s_element = 0x9049;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRTransmitCoilSequence>::s_name = "MR Transmit Coil Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRTransmitCoilSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRTransmitCoilSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransmitCoilManufacturerName>::s_keyword =
    Keyword::TransmitCoilManufacturerName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilManufacturerName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilManufacturerName>::s_element = 0x9050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransmitCoilManufacturerName>::s_name =
    "Transmit Coil Manufacturer Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransmitCoilManufacturerName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransmitCoilManufacturerName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransmitCoilType>::s_keyword = Keyword::TransmitCoilType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitCoilType>::s_element = 0x9051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransmitCoilType>::s_name = "Transmit Coil Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransmitCoilType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransmitCoilType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_keyword =
    Keyword::MRAcquisitionFrequencyEncodingSteps;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_element = 0x9058;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_name =
    "MR Acquisition Frequency Encoding Steps";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRAcquisitionFrequencyEncodingSteps>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::KSpaceFiltering>::s_keyword = Keyword::KSpaceFiltering;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::KSpaceFiltering>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::KSpaceFiltering>::s_element = 0x9064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::KSpaceFiltering>::s_name = "k-space Filtering";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::KSpaceFiltering>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::KSpaceFiltering>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ParallelReductionFactorInPlane>::s_keyword =
    Keyword::ParallelReductionFactorInPlane;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorInPlane>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorInPlane>::s_element = 0x9069;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ParallelReductionFactorInPlane>::s_name =
    "Parallel Reduction Factor In-plane";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ParallelReductionFactorInPlane>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ParallelReductionFactorInPlane>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacRRIntervalSpecified>::s_keyword = Keyword::CardiacRRIntervalSpecified;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacRRIntervalSpecified>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacRRIntervalSpecified>::s_element = 0x9070;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacRRIntervalSpecified>::s_name =
    "Cardiac R-R Interval Specified";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacRRIntervalSpecified>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacRRIntervalSpecified>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDuration>::s_keyword = Keyword::AcquisitionDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDuration>::s_element = 0x9073;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDuration>::s_name = "Acquisition Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDuration>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameAcquisitionDateTime>::s_keyword = Keyword::FrameAcquisitionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionDateTime>::s_element = 0x9074;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameAcquisitionDateTime>::s_name = "Frame Acquisition DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameAcquisitionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameAcquisitionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiffusionDirectionality>::s_keyword = Keyword::DiffusionDirectionality;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionDirectionality>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionDirectionality>::s_element = 0x9075;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiffusionDirectionality>::s_name = "Diffusion Directionality";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiffusionDirectionality>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiffusionDirectionality>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiffusionGradientDirectionSequence>::s_keyword =
    Keyword::DiffusionGradientDirectionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionGradientDirectionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionGradientDirectionSequence>::s_element = 0x9076;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiffusionGradientDirectionSequence>::s_name =
    "Diffusion Gradient Direction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiffusionGradientDirectionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiffusionGradientDirectionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ParallelAcquisition>::s_keyword = Keyword::ParallelAcquisition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelAcquisition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelAcquisition>::s_element = 0x9077;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ParallelAcquisition>::s_name = "Parallel Acquisition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ParallelAcquisition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ParallelAcquisition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ParallelAcquisitionTechnique>::s_keyword =
    Keyword::ParallelAcquisitionTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelAcquisitionTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelAcquisitionTechnique>::s_element = 0x9078;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ParallelAcquisitionTechnique>::s_name =
    "Parallel Acquisition technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ParallelAcquisitionTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ParallelAcquisitionTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InversionTimes>::s_keyword = Keyword::InversionTimes;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionTimes>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InversionTimes>::s_element = 0x9079;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InversionTimes>::s_name = "Inversion Times";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InversionTimes>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InversionTimes>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MetaboliteMapDescription>::s_keyword = Keyword::MetaboliteMapDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MetaboliteMapDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MetaboliteMapDescription>::s_element = 0x9080;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MetaboliteMapDescription>::s_name = "Metabolite Map Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MetaboliteMapDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MetaboliteMapDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PartialFourier>::s_keyword = Keyword::PartialFourier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialFourier>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialFourier>::s_element = 0x9081;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PartialFourier>::s_name = "Partial Fourier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PartialFourier>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PartialFourier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EffectiveEchoTime>::s_keyword = Keyword::EffectiveEchoTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveEchoTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveEchoTime>::s_element = 0x9082;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EffectiveEchoTime>::s_name = "Effective Echo Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EffectiveEchoTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EffectiveEchoTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MetaboliteMapCodeSequence>::s_keyword = Keyword::MetaboliteMapCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MetaboliteMapCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MetaboliteMapCodeSequence>::s_element = 0x9083;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MetaboliteMapCodeSequence>::s_name = "Metabolite Map Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MetaboliteMapCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MetaboliteMapCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ChemicalShiftSequence>::s_keyword = Keyword::ChemicalShiftSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChemicalShiftSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChemicalShiftSequence>::s_element = 0x9084;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ChemicalShiftSequence>::s_name = "Chemical Shift Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ChemicalShiftSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ChemicalShiftSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacSignalSource>::s_keyword = Keyword::CardiacSignalSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSignalSource>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSignalSource>::s_element = 0x9085;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacSignalSource>::s_name = "Cardiac Signal Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacSignalSource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacSignalSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiffusionBValue>::s_keyword = Keyword::DiffusionBValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionBValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionBValue>::s_element = 0x9087;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiffusionBValue>::s_name = "Diffusion b-value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiffusionBValue>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiffusionBValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VelocityEncodingDirection>::s_keyword = Keyword::VelocityEncodingDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingDirection>::s_element = 0x9090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VelocityEncodingDirection>::s_name = "Velocity Encoding Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VelocityEncodingDirection>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VelocityEncodingDirection>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VelocityEncodingMinimumValue>::s_keyword =
    Keyword::VelocityEncodingMinimumValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingMinimumValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingMinimumValue>::s_element = 0x9091;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VelocityEncodingMinimumValue>::s_name =
    "Velocity Encoding Minimum Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VelocityEncodingMinimumValue>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VelocityEncodingMinimumValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_keyword =
    Keyword::VelocityEncodingAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_element = 0x9092;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_name =
    "Velocity Encoding Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VelocityEncodingAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfKSpaceTrajectories>::s_keyword = Keyword::NumberOfKSpaceTrajectories;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfKSpaceTrajectories>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfKSpaceTrajectories>::s_element = 0x9093;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfKSpaceTrajectories>::s_name =
    "Number of k-Space Trajectories";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfKSpaceTrajectories>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfKSpaceTrajectories>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CoverageOfKSpace>::s_keyword = Keyword::CoverageOfKSpace;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CoverageOfKSpace>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CoverageOfKSpace>::s_element = 0x9094;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CoverageOfKSpace>::s_name = "Coverage of k-Space";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CoverageOfKSpace>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CoverageOfKSpace>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransmitterFrequency>::s_keyword = Keyword::TransmitterFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitterFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransmitterFrequency>::s_element = 0x9098;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransmitterFrequency>::s_name = "Transmitter Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransmitterFrequency>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransmitterFrequency>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ResonantNucleus>::s_keyword = Keyword::ResonantNucleus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResonantNucleus>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ResonantNucleus>::s_element = 0x9100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ResonantNucleus>::s_name = "Resonant Nucleus";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ResonantNucleus>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ResonantNucleus>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SlabThickness>::s_keyword = Keyword::SlabThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SlabThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SlabThickness>::s_element = 0x9104;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SlabThickness>::s_name = "Slab Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SlabThickness>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SlabThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SlabOrientation>::s_keyword = Keyword::SlabOrientation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SlabOrientation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SlabOrientation>::s_element = 0x9105;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SlabOrientation>::s_name = "Slab Orientation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SlabOrientation>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SlabOrientation>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MidSlabPosition>::s_keyword = Keyword::MidSlabPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MidSlabPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MidSlabPosition>::s_element = 0x9106;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MidSlabPosition>::s_name = "Mid Slab Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MidSlabPosition>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MidSlabPosition>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRSpatialSaturationSequence>::s_keyword =
    Keyword::MRSpatialSaturationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRSpatialSaturationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRSpatialSaturationSequence>::s_element = 0x9107;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRSpatialSaturationSequence>::s_name =
    "MR Spatial Saturation Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRSpatialSaturationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRSpatialSaturationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_keyword =
    Keyword::MRTimingAndRelatedParametersSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_element = 0x9112;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_name =
    "MR Timing and Related Parameters Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRTimingAndRelatedParametersSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MREchoSequence>::s_keyword = Keyword::MREchoSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MREchoSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MREchoSequence>::s_element = 0x9114;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MREchoSequence>::s_name = "MR Echo Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MREchoSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MREchoSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRModifierSequence>::s_keyword = Keyword::MRModifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRModifierSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRModifierSequence>::s_element = 0x9115;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRModifierSequence>::s_name = "MR Modifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRModifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRModifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRDiffusionSequence>::s_keyword = Keyword::MRDiffusionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRDiffusionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRDiffusionSequence>::s_element = 0x9117;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRDiffusionSequence>::s_name = "MR Diffusion Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRDiffusionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRDiffusionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacSynchronizationSequence>::s_keyword =
    Keyword::CardiacSynchronizationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSynchronizationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacSynchronizationSequence>::s_element = 0x9118;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacSynchronizationSequence>::s_name =
    "Cardiac Synchronization Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacSynchronizationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacSynchronizationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRAveragesSequence>::s_keyword = Keyword::MRAveragesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAveragesSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAveragesSequence>::s_element = 0x9119;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRAveragesSequence>::s_name = "MR Averages Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRAveragesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRAveragesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRFOVGeometrySequence>::s_keyword = Keyword::MRFOVGeometrySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRFOVGeometrySequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRFOVGeometrySequence>::s_element = 0x9125;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRFOVGeometrySequence>::s_name = "MR FOV/Geometry Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRFOVGeometrySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRFOVGeometrySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiffusionAnisotropyType>::s_keyword = Keyword::DiffusionAnisotropyType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionAnisotropyType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionAnisotropyType>::s_element = 0x9147;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiffusionAnisotropyType>::s_name = "Diffusion Anisotropy Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiffusionAnisotropyType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiffusionAnisotropyType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameReferenceDateTime>::s_keyword = Keyword::FrameReferenceDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameReferenceDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameReferenceDateTime>::s_element = 0x9151;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameReferenceDateTime>::s_name = "Frame Reference DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameReferenceDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameReferenceDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRMetaboliteMapSequence>::s_keyword = Keyword::MRMetaboliteMapSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRMetaboliteMapSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRMetaboliteMapSequence>::s_element = 0x9152;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRMetaboliteMapSequence>::s_name = "MR Metabolite Map Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRMetaboliteMapSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRMetaboliteMapSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_keyword =
    Keyword::ParallelReductionFactorOutOfPlane;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_element = 0x9155;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_name =
    "Parallel Reduction Factor out-of-plane";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ParallelReductionFactorOutOfPlane>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_keyword =
    Keyword::ParallelReductionFactorSecondInPlane;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_element = 0x9168;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_name =
    "Parallel Reduction Factor Second In-plane";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ParallelReductionFactorSecondInPlane>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacBeatRejectionTechnique>::s_keyword =
    Keyword::CardiacBeatRejectionTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacBeatRejectionTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacBeatRejectionTechnique>::s_element = 0x9169;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacBeatRejectionTechnique>::s_name =
    "Cardiac Beat Rejection technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacBeatRejectionTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacBeatRejectionTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_keyword =
    Keyword::RespiratoryMotionCompensationTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_element = 0x9170;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_name =
    "Respiratory Motion Compensation technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratoryMotionCompensationTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratorySignalSource>::s_keyword = Keyword::RespiratorySignalSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratorySignalSource>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratorySignalSource>::s_element = 0x9171;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratorySignalSource>::s_name = "Respiratory Signal Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratorySignalSource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratorySignalSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BulkMotionCompensationTechnique>::s_keyword =
    Keyword::BulkMotionCompensationTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BulkMotionCompensationTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BulkMotionCompensationTechnique>::s_element = 0x9172;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BulkMotionCompensationTechnique>::s_name =
    "Bulk Motion Compensation technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BulkMotionCompensationTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BulkMotionCompensationTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BulkMotionSignalSource>::s_keyword = Keyword::BulkMotionSignalSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BulkMotionSignalSource>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BulkMotionSignalSource>::s_element = 0x9173;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BulkMotionSignalSource>::s_name = "Bulk Motion Signal Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BulkMotionSignalSource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BulkMotionSignalSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicableSafetyStandardAgency>::s_keyword =
    Keyword::ApplicableSafetyStandardAgency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableSafetyStandardAgency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableSafetyStandardAgency>::s_element = 0x9174;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicableSafetyStandardAgency>::s_name =
    "Applicable Safety Standard Agency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicableSafetyStandardAgency>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicableSafetyStandardAgency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicableSafetyStandardDescription>::s_keyword =
    Keyword::ApplicableSafetyStandardDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableSafetyStandardDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableSafetyStandardDescription>::s_element = 0x9175;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicableSafetyStandardDescription>::s_name =
    "Applicable Safety Standard Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicableSafetyStandardDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicableSafetyStandardDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OperatingModeSequence>::s_keyword = Keyword::OperatingModeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatingModeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OperatingModeSequence>::s_element = 0x9176;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OperatingModeSequence>::s_name = "Operating Mode Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OperatingModeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OperatingModeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GradientOutputType>::s_keyword = Keyword::GradientOutputType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientOutputType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientOutputType>::s_element = 0x9180;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GradientOutputType>::s_name = "Gradient Output Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GradientOutputType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GradientOutputType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GradientOutput>::s_keyword = Keyword::GradientOutput;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientOutput>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientOutput>::s_element = 0x9182;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GradientOutput>::s_name = "Gradient Output";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GradientOutput>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GradientOutput>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FlowCompensationDirection>::s_keyword = Keyword::FlowCompensationDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlowCompensationDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FlowCompensationDirection>::s_element = 0x9183;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FlowCompensationDirection>::s_name = "Flow Compensation Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FlowCompensationDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FlowCompensationDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TaggingDelay>::s_keyword = Keyword::TaggingDelay;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TaggingDelay>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TaggingDelay>::s_element = 0x9184;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TaggingDelay>::s_name = "Tagging Delay";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TaggingDelay>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TaggingDelay>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRVelocityEncodingSequence>::s_keyword = Keyword::MRVelocityEncodingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRVelocityEncodingSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRVelocityEncodingSequence>::s_element = 0x9197;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRVelocityEncodingSequence>::s_name =
    "MR Velocity Encoding Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRVelocityEncodingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRVelocityEncodingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratoryCyclePosition>::s_keyword = Keyword::RespiratoryCyclePosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryCyclePosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryCyclePosition>::s_element = 0x9214;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratoryCyclePosition>::s_name = "Respiratory Cycle Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratoryCyclePosition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratoryCyclePosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VelocityEncodingMaximumValue>::s_keyword =
    Keyword::VelocityEncodingMaximumValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingMaximumValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VelocityEncodingMaximumValue>::s_element = 0x9217;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VelocityEncodingMaximumValue>::s_name =
    "Velocity Encoding Maximum Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VelocityEncodingMaximumValue>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VelocityEncodingMaximumValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TagSpacingSecondDimension>::s_keyword = Keyword::TagSpacingSecondDimension;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagSpacingSecondDimension>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagSpacingSecondDimension>::s_element = 0x9218;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TagSpacingSecondDimension>::s_name = "Tag Spacing Second Dimension";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TagSpacingSecondDimension>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TagSpacingSecondDimension>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TagAngleSecondAxis>::s_keyword = Keyword::TagAngleSecondAxis;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagAngleSecondAxis>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TagAngleSecondAxis>::s_element = 0x9219;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TagAngleSecondAxis>::s_name = "Tag Angle Second Axis";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TagAngleSecondAxis>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TagAngleSecondAxis>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameAcquisitionDuration>::s_keyword = Keyword::FrameAcquisitionDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionDuration>::s_element = 0x9220;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameAcquisitionDuration>::s_name = "Frame Acquisition Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameAcquisitionDuration>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameAcquisitionDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRImageFrameTypeSequence>::s_keyword = Keyword::MRImageFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRImageFrameTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRImageFrameTypeSequence>::s_element = 0x9226;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRImageFrameTypeSequence>::s_name = "MR Image Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRImageFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRImageFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_keyword =
    Keyword::MRAcquisitionPhaseEncodingStepsInPlane;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_element = 0x9231;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_name =
    "MR Acquisition Phase Encoding Steps in-plane";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_keyword =
    Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_element = 0x9232;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_name =
    "MR Acquisition Phase Encoding Steps out-of-plane";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CardiacCyclePosition>::s_keyword = Keyword::CardiacCyclePosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacCyclePosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CardiacCyclePosition>::s_element = 0x9236;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CardiacCyclePosition>::s_name = "Cardiac Cycle Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CardiacCyclePosition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CardiacCyclePosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecificAbsorptionRateSequence>::s_keyword =
    Keyword::SpecificAbsorptionRateSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecificAbsorptionRateSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecificAbsorptionRateSequence>::s_element = 0x9239;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecificAbsorptionRateSequence>::s_name =
    "Specific Absorption Rate Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecificAbsorptionRateSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecificAbsorptionRateSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RFEchoTrainLength>::s_keyword = Keyword::RFEchoTrainLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RFEchoTrainLength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RFEchoTrainLength>::s_element = 0x9240;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RFEchoTrainLength>::s_name = "RF Echo Train Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RFEchoTrainLength>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RFEchoTrainLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GradientEchoTrainLength>::s_keyword = Keyword::GradientEchoTrainLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientEchoTrainLength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GradientEchoTrainLength>::s_element = 0x9241;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GradientEchoTrainLength>::s_name = "Gradient Echo Train Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GradientEchoTrainLength>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GradientEchoTrainLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ArterialSpinLabelingContrast>::s_keyword =
    Keyword::ArterialSpinLabelingContrast;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ArterialSpinLabelingContrast>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ArterialSpinLabelingContrast>::s_element = 0x9250;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ArterialSpinLabelingContrast>::s_name =
    "Arterial Spin Labeling Contrast";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ArterialSpinLabelingContrast>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ArterialSpinLabelingContrast>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MRArterialSpinLabelingSequence>::s_keyword =
    Keyword::MRArterialSpinLabelingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRArterialSpinLabelingSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MRArterialSpinLabelingSequence>::s_element = 0x9251;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MRArterialSpinLabelingSequence>::s_name =
    "MR Arterial Spin Labeling Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MRArterialSpinLabelingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MRArterialSpinLabelingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLTechniqueDescription>::s_keyword = Keyword::ASLTechniqueDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLTechniqueDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLTechniqueDescription>::s_element = 0x9252;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLTechniqueDescription>::s_name = "ASL technique Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLTechniqueDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLTechniqueDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLContext>::s_keyword = Keyword::ASLContext;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLContext>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLContext>::s_element = 0x9257;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLContext>::s_name = "ASL Context";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLContext>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLContext>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLCrusherFlag>::s_keyword = Keyword::ASLCrusherFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherFlag>::s_element = 0x9259;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLCrusherFlag>::s_name = "ASL Crusher Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLCrusherFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLCrusherFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLCrusherFlowLimit>::s_keyword = Keyword::ASLCrusherFlowLimit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherFlowLimit>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherFlowLimit>::s_element = 0x925A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLCrusherFlowLimit>::s_name = "ASL Crusher Flow Limit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLCrusherFlowLimit>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLCrusherFlowLimit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLCrusherDescription>::s_keyword = Keyword::ASLCrusherDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLCrusherDescription>::s_element = 0x925B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLCrusherDescription>::s_name = "ASL Crusher Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLCrusherDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLCrusherDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLBolusCutoffFlag>::s_keyword = Keyword::ASLBolusCutoffFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLBolusCutoffFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLBolusCutoffFlag>::s_element = 0x925C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLBolusCutoffFlag>::s_name = "ASL Bolus Cut-off Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLBolusCutoffFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLBolusCutoffFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_keyword =
    Keyword::ASLBolusCutoffTimingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_element = 0x925D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_name =
    "ASL Bolus Cut-off Timing Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLBolusCutoffTimingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ASLSlabSequence>::s_keyword = Keyword::ASLSlabSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLSlabSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ASLSlabSequence>::s_element = 0x9260;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ASLSlabSequence>::s_name = "ASL Slab Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ASLSlabSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ASLSlabSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTAcquisitionTypeSequence>::s_keyword = Keyword::CTAcquisitionTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAcquisitionTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAcquisitionTypeSequence>::s_element = 0x9301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTAcquisitionTypeSequence>::s_name = "CT Acquisition Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTAcquisitionTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTAcquisitionTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionType>::s_keyword = Keyword::AcquisitionType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionType>::s_element = 0x9302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionType>::s_name = "Acquisition Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TubeAngle>::s_keyword = Keyword::TubeAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TubeAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TubeAngle>::s_element = 0x9303;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TubeAngle>::s_name = "Tube Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TubeAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TubeAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTAcquisitionDetailsSequence>::s_keyword =
    Keyword::CTAcquisitionDetailsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAcquisitionDetailsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAcquisitionDetailsSequence>::s_element = 0x9304;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTAcquisitionDetailsSequence>::s_name =
    "CT Acquisition Details Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTAcquisitionDetailsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTAcquisitionDetailsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RevolutionTime>::s_keyword = Keyword::RevolutionTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RevolutionTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RevolutionTime>::s_element = 0x9305;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RevolutionTime>::s_name = "Revolution Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RevolutionTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RevolutionTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SingleCollimationWidth>::s_keyword = Keyword::SingleCollimationWidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SingleCollimationWidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SingleCollimationWidth>::s_element = 0x9306;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SingleCollimationWidth>::s_name = "Single Collimation Width";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SingleCollimationWidth>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SingleCollimationWidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TotalCollimationWidth>::s_keyword = Keyword::TotalCollimationWidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TotalCollimationWidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TotalCollimationWidth>::s_element = 0x9307;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TotalCollimationWidth>::s_name = "Total Collimation Width";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TotalCollimationWidth>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TotalCollimationWidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTTableDynamicsSequence>::s_keyword = Keyword::CTTableDynamicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTTableDynamicsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTTableDynamicsSequence>::s_element = 0x9308;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTTableDynamicsSequence>::s_name = "CT Table Dynamics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTTableDynamicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTTableDynamicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableSpeed>::s_keyword = Keyword::TableSpeed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableSpeed>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableSpeed>::s_element = 0x9309;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableSpeed>::s_name = "Table Speed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableSpeed>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableSpeed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableFeedPerRotation>::s_keyword = Keyword::TableFeedPerRotation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableFeedPerRotation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableFeedPerRotation>::s_element = 0x9310;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableFeedPerRotation>::s_name = "Table Feed per Rotation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableFeedPerRotation>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableFeedPerRotation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpiralPitchFactor>::s_keyword = Keyword::SpiralPitchFactor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpiralPitchFactor>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpiralPitchFactor>::s_element = 0x9311;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpiralPitchFactor>::s_name = "Spiral Pitch Factor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpiralPitchFactor>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpiralPitchFactor>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTGeometrySequence>::s_keyword = Keyword::CTGeometrySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTGeometrySequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTGeometrySequence>::s_element = 0x9312;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTGeometrySequence>::s_name = "CT Geometry Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTGeometrySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTGeometrySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataCollectionCenterPatient>::s_keyword =
    Keyword::DataCollectionCenterPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataCollectionCenterPatient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataCollectionCenterPatient>::s_element = 0x9313;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataCollectionCenterPatient>::s_name =
    "Data Collection Center (Patient)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataCollectionCenterPatient>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataCollectionCenterPatient>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTReconstructionSequence>::s_keyword = Keyword::CTReconstructionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTReconstructionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTReconstructionSequence>::s_element = 0x9314;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTReconstructionSequence>::s_name = "CT Reconstruction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTReconstructionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTReconstructionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionAlgorithm>::s_keyword = Keyword::ReconstructionAlgorithm;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAlgorithm>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAlgorithm>::s_element = 0x9315;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionAlgorithm>::s_name = "Reconstruction Algorithm";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionAlgorithm>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionAlgorithm>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConvolutionKernelGroup>::s_keyword = Keyword::ConvolutionKernelGroup;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConvolutionKernelGroup>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConvolutionKernelGroup>::s_element = 0x9316;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConvolutionKernelGroup>::s_name = "Convolution Kernel Group";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConvolutionKernelGroup>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConvolutionKernelGroup>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionFieldOfView>::s_keyword = Keyword::ReconstructionFieldOfView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionFieldOfView>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionFieldOfView>::s_element = 0x9317;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionFieldOfView>::s_name = "Reconstruction field of view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionFieldOfView>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionFieldOfView>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionTargetCenterPatient>::s_keyword =
    Keyword::ReconstructionTargetCenterPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionTargetCenterPatient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionTargetCenterPatient>::s_element = 0x9318;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionTargetCenterPatient>::s_name =
    "Reconstruction Target Center (Patient)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionTargetCenterPatient>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionTargetCenterPatient>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionAngle>::s_keyword = Keyword::ReconstructionAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAngle>::s_element = 0x9319;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionAngle>::s_name = "Reconstruction Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageFilter>::s_keyword = Keyword::ImageFilter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageFilter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageFilter>::s_element = 0x9320;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageFilter>::s_name = "Image filter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageFilter>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageFilter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTExposureSequence>::s_keyword = Keyword::CTExposureSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTExposureSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTExposureSequence>::s_element = 0x9321;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTExposureSequence>::s_name = "CT Exposure Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTExposureSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTExposureSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionPixelSpacing>::s_keyword = Keyword::ReconstructionPixelSpacing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionPixelSpacing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionPixelSpacing>::s_element = 0x9322;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionPixelSpacing>::s_name = "Reconstruction Pixel Spacing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionPixelSpacing>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionPixelSpacing>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureModulationType>::s_keyword = Keyword::ExposureModulationType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureModulationType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureModulationType>::s_element = 0x9323;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureModulationType>::s_name = "Exposure Modulation Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureModulationType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureModulationType>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTXRayDetailsSequence>::s_keyword = Keyword::CTXRayDetailsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTXRayDetailsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTXRayDetailsSequence>::s_element = 0x9325;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTXRayDetailsSequence>::s_name = "CT X-Ray Details Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTXRayDetailsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTXRayDetailsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTPositionSequence>::s_keyword = Keyword::CTPositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTPositionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTPositionSequence>::s_element = 0x9326;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTPositionSequence>::s_name = "CT Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTPositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTPositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TablePosition>::s_keyword = Keyword::TablePosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TablePosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TablePosition>::s_element = 0x9327;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TablePosition>::s_name = "Table Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TablePosition>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TablePosition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureTimeInms>::s_keyword = Keyword::ExposureTimeInms;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInms>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureTimeInms>::s_element = 0x9328;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureTimeInms>::s_name = "Exposure Time in ms";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureTimeInms>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureTimeInms>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTImageFrameTypeSequence>::s_keyword = Keyword::CTImageFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTImageFrameTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTImageFrameTypeSequence>::s_element = 0x9329;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTImageFrameTypeSequence>::s_name = "CT Image Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTImageFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTImageFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayTubeCurrentInmA>::s_keyword = Keyword::XRayTubeCurrentInmA;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrentInmA>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayTubeCurrentInmA>::s_element = 0x9330;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayTubeCurrentInmA>::s_name = "X-Ray Tube Current in mA";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayTubeCurrentInmA>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayTubeCurrentInmA>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureInmAs>::s_keyword = Keyword::ExposureInmAs;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureInmAs>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureInmAs>::s_element = 0x9332;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureInmAs>::s_name = "Exposure in mAs";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureInmAs>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureInmAs>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConstantVolumeFlag>::s_keyword = Keyword::ConstantVolumeFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConstantVolumeFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConstantVolumeFlag>::s_element = 0x9333;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConstantVolumeFlag>::s_name = "Constant Volume Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConstantVolumeFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConstantVolumeFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FluoroscopyFlag>::s_keyword = Keyword::FluoroscopyFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FluoroscopyFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FluoroscopyFlag>::s_element = 0x9334;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FluoroscopyFlag>::s_name = "Fluoroscopy Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FluoroscopyFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FluoroscopyFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_keyword =
    Keyword::DistanceSourceToDataCollectionCenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_element = 0x9335;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_name =
    "Distance Source to Data Collection Center";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceSourceToDataCollectionCenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgentNumber>::s_keyword = Keyword::ContrastBolusAgentNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentNumber>::s_element = 0x9337;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgentNumber>::s_name = "Contrast/Bolus Agent Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgentNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgentNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_keyword =
    Keyword::ContrastBolusIngredientCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_element = 0x9338;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_name =
    "Contrast/Bolus Ingredient Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusIngredientCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastAdministrationProfileSequence>::s_keyword =
    Keyword::ContrastAdministrationProfileSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastAdministrationProfileSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastAdministrationProfileSequence>::s_element = 0x9340;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastAdministrationProfileSequence>::s_name =
    "Contrast Administration Profile Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastAdministrationProfileSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastAdministrationProfileSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusUsageSequence>::s_keyword = Keyword::ContrastBolusUsageSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusUsageSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusUsageSequence>::s_element = 0x9341;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusUsageSequence>::s_name =
    "Contrast/Bolus Usage Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusUsageSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusUsageSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgentAdministered>::s_keyword =
    Keyword::ContrastBolusAgentAdministered;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentAdministered>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentAdministered>::s_element = 0x9342;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgentAdministered>::s_name =
    "Contrast/Bolus Agent Administered";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgentAdministered>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgentAdministered>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgentDetected>::s_keyword = Keyword::ContrastBolusAgentDetected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentDetected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentDetected>::s_element = 0x9343;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgentDetected>::s_name =
    "Contrast/Bolus Agent Detected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgentDetected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgentDetected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusAgentPhase>::s_keyword = Keyword::ContrastBolusAgentPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentPhase>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusAgentPhase>::s_element = 0x9344;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusAgentPhase>::s_name = "Contrast/Bolus Agent Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusAgentPhase>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusAgentPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTDIvol>::s_keyword = Keyword::CTDIvol;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTDIvol>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTDIvol>::s_element = 0x9345;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTDIvol>::s_name = "CTDIvol";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTDIvol>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTDIvol>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_keyword =
    Keyword::CTDIPhantomTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_element = 0x9346;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_name =
    "CTDI Phantom Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTDIPhantomTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalciumScoringMassFactorPatient>::s_keyword =
    Keyword::CalciumScoringMassFactorPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalciumScoringMassFactorPatient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalciumScoringMassFactorPatient>::s_element = 0x9351;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalciumScoringMassFactorPatient>::s_name =
    "Calcium Scoring Mass Factor Patient";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalciumScoringMassFactorPatient>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalciumScoringMassFactorPatient>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalciumScoringMassFactorDevice>::s_keyword =
    Keyword::CalciumScoringMassFactorDevice;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalciumScoringMassFactorDevice>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalciumScoringMassFactorDevice>::s_element = 0x9352;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalciumScoringMassFactorDevice>::s_name =
    "Calcium Scoring Mass Factor Device";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalciumScoringMassFactorDevice>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalciumScoringMassFactorDevice>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EnergyWeightingFactor>::s_keyword = Keyword::EnergyWeightingFactor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EnergyWeightingFactor>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EnergyWeightingFactor>::s_element = 0x9353;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EnergyWeightingFactor>::s_name = "Energy Weighting Factor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EnergyWeightingFactor>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EnergyWeightingFactor>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_keyword =
    Keyword::CTAdditionalXRaySourceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_element = 0x9360;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_name =
    "CT Additional X-Ray Source Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CTAdditionalXRaySourceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTAcquisition>::s_keyword = Keyword::MultienergyCTAcquisition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTAcquisition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTAcquisition>::s_element = 0x9361;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTAcquisition>::s_name = "Multi-energy CT Acquisition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTAcquisition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTAcquisition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_keyword =
    Keyword::MultienergyCTAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_element = 0x9362;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_name =
    "Multi-energy CT Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTProcessingSequence>::s_keyword =
    Keyword::MultienergyCTProcessingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTProcessingSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTProcessingSequence>::s_element = 0x9363;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTProcessingSequence>::s_name =
    "Multi-energy CT Processing Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTProcessingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTProcessingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_keyword =
    Keyword::MultienergyCTCharacteristicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_element = 0x9364;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_name =
    "Multi-energy CT Characteristics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTCharacteristicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_keyword =
    Keyword::MultienergyCTXRaySourceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_element = 0x9365;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_name =
    "Multi-energy CT X-Ray Source Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTXRaySourceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRaySourceIndex>::s_keyword = Keyword::XRaySourceIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIndex>::s_element = 0x9366;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRaySourceIndex>::s_name = "X-Ray Source Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRaySourceIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRaySourceIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRaySourceID>::s_keyword = Keyword::XRaySourceID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceID>::s_element = 0x9367;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRaySourceID>::s_name = "X-Ray Source ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRaySourceID>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRaySourceID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergySourceTechnique>::s_keyword = Keyword::MultienergySourceTechnique;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergySourceTechnique>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergySourceTechnique>::s_element = 0x9368;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergySourceTechnique>::s_name =
    "Multi-energy Source technique";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergySourceTechnique>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergySourceTechnique>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceStartDateTime>::s_keyword = Keyword::SourceStartDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceStartDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceStartDateTime>::s_element = 0x9369;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceStartDateTime>::s_name = "Source Start DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceStartDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceStartDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceEndDateTime>::s_keyword = Keyword::SourceEndDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceEndDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceEndDateTime>::s_element = 0x936A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceEndDateTime>::s_name = "Source End DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceEndDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceEndDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SwitchingPhaseNumber>::s_keyword = Keyword::SwitchingPhaseNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseNumber>::s_element = 0x936B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SwitchingPhaseNumber>::s_name = "Switching Phase Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SwitchingPhaseNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SwitchingPhaseNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SwitchingPhaseNominalDuration>::s_keyword =
    Keyword::SwitchingPhaseNominalDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseNominalDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseNominalDuration>::s_element = 0x936C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SwitchingPhaseNominalDuration>::s_name =
    "Switching Phase Nominal Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SwitchingPhaseNominalDuration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SwitchingPhaseNominalDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_keyword =
    Keyword::SwitchingPhaseTransitionDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_element = 0x936D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_name =
    "Switching Phase Transition Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SwitchingPhaseTransitionDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EffectiveBinEnergy>::s_keyword = Keyword::EffectiveBinEnergy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveBinEnergy>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EffectiveBinEnergy>::s_element = 0x936E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EffectiveBinEnergy>::s_name = "Effective Bin Energy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EffectiveBinEnergy>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EffectiveBinEnergy>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_keyword =
    Keyword::MultienergyCTXRayDetectorSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_element = 0x936F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_name =
    "Multi-energy CT X-Ray Detector Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTXRayDetectorSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayDetectorIndex>::s_keyword = Keyword::XRayDetectorIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorIndex>::s_element = 0x9370;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayDetectorIndex>::s_name = "X-Ray Detector Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayDetectorIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayDetectorIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayDetectorID>::s_keyword = Keyword::XRayDetectorID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorID>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorID>::s_element = 0x9371;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayDetectorID>::s_name = "X-Ray Detector ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayDetectorID>::s_vr = VR::UC;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayDetectorID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyDetectorType>::s_keyword = Keyword::MultienergyDetectorType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyDetectorType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyDetectorType>::s_element = 0x9372;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyDetectorType>::s_name = "Multi-energy Detector Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyDetectorType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyDetectorType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayDetectorLabel>::s_keyword = Keyword::XRayDetectorLabel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorLabel>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayDetectorLabel>::s_element = 0x9373;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayDetectorLabel>::s_name = "X-Ray Detector Label";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayDetectorLabel>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayDetectorLabel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalMaxEnergy>::s_keyword = Keyword::NominalMaxEnergy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalMaxEnergy>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalMaxEnergy>::s_element = 0x9374;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalMaxEnergy>::s_name = "Nominal Max Energy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalMaxEnergy>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalMaxEnergy>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalMinEnergy>::s_keyword = Keyword::NominalMinEnergy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalMinEnergy>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalMinEnergy>::s_element = 0x9375;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalMinEnergy>::s_name = "Nominal Min Energy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalMinEnergy>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalMinEnergy>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedXRayDetectorIndex>::s_keyword =
    Keyword::ReferencedXRayDetectorIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedXRayDetectorIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedXRayDetectorIndex>::s_element = 0x9376;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedXRayDetectorIndex>::s_name =
    "Referenced X-Ray Detector Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedXRayDetectorIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedXRayDetectorIndex>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedXRaySourceIndex>::s_keyword = Keyword::ReferencedXRaySourceIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedXRaySourceIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedXRaySourceIndex>::s_element = 0x9377;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedXRaySourceIndex>::s_name = "Referenced X-Ray Source Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedXRaySourceIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedXRaySourceIndex>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPathIndex>::s_keyword = Keyword::ReferencedPathIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPathIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPathIndex>::s_element = 0x9378;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPathIndex>::s_name = "Referenced Path Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPathIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPathIndex>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTPathSequence>::s_keyword = Keyword::MultienergyCTPathSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTPathSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTPathSequence>::s_element = 0x9379;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTPathSequence>::s_name = "Multi-energy CT Path Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTPathSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTPathSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyCTPathIndex>::s_keyword = Keyword::MultienergyCTPathIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTPathIndex>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyCTPathIndex>::s_element = 0x937A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyCTPathIndex>::s_name = "Multi-energy CT Path Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyCTPathIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyCTPathIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultienergyAcquisitionDescription>::s_keyword =
    Keyword::MultienergyAcquisitionDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyAcquisitionDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultienergyAcquisitionDescription>::s_element = 0x937B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultienergyAcquisitionDescription>::s_name =
    "Multi-energy Acquisition Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultienergyAcquisitionDescription>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultienergyAcquisitionDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_keyword =
    Keyword::MonoenergeticEnergyEquivalent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_element = 0x937C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_name =
    "Monoenergetic Energy Equivalent";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MonoenergeticEnergyEquivalent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecompositionMethod>::s_keyword = Keyword::DecompositionMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionMethod>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionMethod>::s_element = 0x937E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecompositionMethod>::s_name = "Decomposition Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecompositionMethod>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecompositionMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecompositionDescription>::s_keyword = Keyword::DecompositionDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionDescription>::s_element = 0x937F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecompositionDescription>::s_name = "Decomposition Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecompositionDescription>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecompositionDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_keyword =
    Keyword::DecompositionAlgorithmIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_element = 0x9380;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_name =
    "Decomposition Algorithm Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecompositionAlgorithmIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecompositionMaterialSequence>::s_keyword =
    Keyword::DecompositionMaterialSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionMaterialSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecompositionMaterialSequence>::s_element = 0x9381;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecompositionMaterialSequence>::s_name =
    "Decomposition Material Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecompositionMaterialSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecompositionMaterialSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_keyword =
    Keyword::ProjectionPixelCalibrationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_element = 0x9401;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_name =
    "Projection Pixel Calibration Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProjectionPixelCalibrationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceSourceToIsocenter>::s_keyword = Keyword::DistanceSourceToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToIsocenter>::s_element = 0x9402;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceSourceToIsocenter>::s_name = "Distance Source to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceSourceToIsocenter>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceSourceToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceObjectToTableTop>::s_keyword = Keyword::DistanceObjectToTableTop;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceObjectToTableTop>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceObjectToTableTop>::s_element = 0x9403;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceObjectToTableTop>::s_name = "Distance Object to Table Top";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceObjectToTableTop>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceObjectToTableTop>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_keyword =
    Keyword::ObjectPixelSpacingInCenterOfBeam;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_element = 0x9404;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_name =
    "Object Pixel Spacing in Center of Beam";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ObjectPixelSpacingInCenterOfBeam>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerPositionSequence>::s_keyword = Keyword::PositionerPositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPositionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPositionSequence>::s_element = 0x9405;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerPositionSequence>::s_name = "Positioner Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerPositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerPositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TablePositionSequence>::s_keyword = Keyword::TablePositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TablePositionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TablePositionSequence>::s_element = 0x9406;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TablePositionSequence>::s_name = "Table Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TablePositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TablePositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CollimatorShapeSequence>::s_keyword = Keyword::CollimatorShapeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorShapeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CollimatorShapeSequence>::s_element = 0x9407;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CollimatorShapeSequence>::s_name = "Collimator Shape Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CollimatorShapeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CollimatorShapeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlanesInAcquisition>::s_keyword = Keyword::PlanesInAcquisition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanesInAcquisition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanesInAcquisition>::s_element = 0x9410;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlanesInAcquisition>::s_name = "Planes in Acquisition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlanesInAcquisition>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlanesInAcquisition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_keyword =
    Keyword::XAXRFFrameCharacteristicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_element = 0x9412;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_name =
    "XA/XRF Frame Characteristics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XAXRFFrameCharacteristicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameAcquisitionSequence>::s_keyword = Keyword::FrameAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionSequence>::s_element = 0x9417;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameAcquisitionSequence>::s_name = "Frame Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayReceptorType>::s_keyword = Keyword::XRayReceptorType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayReceptorType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayReceptorType>::s_element = 0x9420;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayReceptorType>::s_name = "X-Ray Receptor Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayReceptorType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayReceptorType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionProtocolName>::s_keyword = Keyword::AcquisitionProtocolName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionProtocolName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionProtocolName>::s_element = 0x9423;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionProtocolName>::s_name = "Acquisition Protocol Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionProtocolName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionProtocolName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionProtocolDescription>::s_keyword =
    Keyword::AcquisitionProtocolDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionProtocolDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionProtocolDescription>::s_element = 0x9424;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionProtocolDescription>::s_name =
    "Acquisition Protocol Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionProtocolDescription>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionProtocolDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastBolusIngredientOpaque>::s_keyword =
    Keyword::ContrastBolusIngredientOpaque;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientOpaque>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastBolusIngredientOpaque>::s_element = 0x9425;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastBolusIngredientOpaque>::s_name =
    "Contrast/Bolus Ingredient Opaque";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastBolusIngredientOpaque>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastBolusIngredientOpaque>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_keyword =
    Keyword::DistanceReceptorPlaneToDetectorHousing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_element = 0x9426;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_name =
    "Distance Receptor Plane to Detector Housing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceReceptorPlaneToDetectorHousing>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntensifierActiveShape>::s_keyword = Keyword::IntensifierActiveShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierActiveShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierActiveShape>::s_element = 0x9427;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntensifierActiveShape>::s_name = "Intensifier Active Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntensifierActiveShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntensifierActiveShape>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntensifierActiveDimensions>::s_keyword =
    Keyword::IntensifierActiveDimensions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierActiveDimensions>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntensifierActiveDimensions>::s_element = 0x9428;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntensifierActiveDimensions>::s_name =
    "Intensifier Active Dimension(s)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntensifierActiveDimensions>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntensifierActiveDimensions>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhysicalDetectorSize>::s_keyword = Keyword::PhysicalDetectorSize;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDetectorSize>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhysicalDetectorSize>::s_element = 0x9429;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhysicalDetectorSize>::s_name = "Physical Detector Size";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhysicalDetectorSize>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhysicalDetectorSize>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionOfIsocenterProjection>::s_keyword =
    Keyword::PositionOfIsocenterProjection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionOfIsocenterProjection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionOfIsocenterProjection>::s_element = 0x9430;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionOfIsocenterProjection>::s_name =
    "Position of Isocenter Projection";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionOfIsocenterProjection>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionOfIsocenterProjection>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewSequence>::s_keyword = Keyword::FieldOfViewSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewSequence>::s_element = 0x9432;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewSequence>::s_name = "field of view Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewDescription>::s_keyword = Keyword::FieldOfViewDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDescription>::s_element = 0x9433;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewDescription>::s_name = "field of view Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_keyword =
    Keyword::ExposureControlSensingRegionsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_element = 0x9434;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_name =
    "Exposure Control Sensing Regions Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionShape>::s_keyword =
    Keyword::ExposureControlSensingRegionShape;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionShape>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionShape>::s_element = 0x9435;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionShape>::s_name =
    "Exposure Control Sensing Region Shape";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionShape>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionShape>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_keyword =
    Keyword::ExposureControlSensingRegionLeftVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_element = 0x9436;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_name =
    "Exposure Control Sensing Region Left Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_keyword =
    Keyword::ExposureControlSensingRegionRightVerticalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_element = 0x9437;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_name =
    "Exposure Control Sensing Region Right Vertical Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_keyword =
    Keyword::ExposureControlSensingRegionUpperHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_element = 0x9438;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_name =
    "Exposure Control Sensing Region Upper Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_keyword =
    Keyword::ExposureControlSensingRegionLowerHorizontalEdge;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_element = 0x9439;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_name =
    "Exposure Control Sensing Region Lower Horizontal Edge";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_keyword =
    Keyword::CenterOfCircularExposureControlSensingRegion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_element = 0x9440;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_name =
    "Center of Circular Exposure Control Sensing Region";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterOfCircularExposureControlSensingRegion>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_keyword =
    Keyword::RadiusOfCircularExposureControlSensingRegion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_element = 0x9441;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_name =
    "Radius of Circular Exposure Control Sensing Region";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiusOfCircularExposureControlSensingRegion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_keyword =
    Keyword::VerticesOfThePolygonalExposureControlSensingRegion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_element = 0x9442;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_name =
    "Vertices of the Polygonal Exposure Control Sensing Region";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_vm = VM::MIN_2_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColumnAngulationPatient>::s_keyword = Keyword::ColumnAngulationPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColumnAngulationPatient>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColumnAngulationPatient>::s_element = 0x9447;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColumnAngulationPatient>::s_name = "Column Angulation (Patient)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColumnAngulationPatient>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColumnAngulationPatient>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BeamAngle>::s_keyword = Keyword::BeamAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BeamAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BeamAngle>::s_element = 0x9449;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BeamAngle>::s_name = "Beam Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BeamAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BeamAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameDetectorParametersSequence>::s_keyword =
    Keyword::FrameDetectorParametersSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDetectorParametersSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDetectorParametersSequence>::s_element = 0x9451;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameDetectorParametersSequence>::s_name =
    "Frame Detector Parameters Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameDetectorParametersSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameDetectorParametersSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalculatedAnatomyThickness>::s_keyword = Keyword::CalculatedAnatomyThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedAnatomyThickness>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalculatedAnatomyThickness>::s_element = 0x9452;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalculatedAnatomyThickness>::s_name = "Calculated Anatomy Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalculatedAnatomyThickness>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalculatedAnatomyThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CalibrationSequence>::s_keyword = Keyword::CalibrationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalibrationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CalibrationSequence>::s_element = 0x9455;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CalibrationSequence>::s_name = "Calibration Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CalibrationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CalibrationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ObjectThicknessSequence>::s_keyword = Keyword::ObjectThicknessSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectThicknessSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectThicknessSequence>::s_element = 0x9456;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ObjectThicknessSequence>::s_name = "Object Thickness Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ObjectThicknessSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ObjectThicknessSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlaneIdentification>::s_keyword = Keyword::PlaneIdentification;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneIdentification>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneIdentification>::s_element = 0x9457;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlaneIdentification>::s_name = "Plane Identification";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlaneIdentification>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlaneIdentification>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_keyword =
    Keyword::FieldOfViewDimensionsInFloat;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_element = 0x9461;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_name =
    "field of view Dimension(s) in Float";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FieldOfViewDimensionsInFloat>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IsocenterReferenceSystemSequence>::s_keyword =
    Keyword::IsocenterReferenceSystemSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IsocenterReferenceSystemSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IsocenterReferenceSystemSequence>::s_element = 0x9462;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IsocenterReferenceSystemSequence>::s_name =
    "Isocenter Reference System Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IsocenterReferenceSystemSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IsocenterReferenceSystemSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_keyword =
    Keyword::PositionerIsocenterPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_element = 0x9463;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_name =
    "Positioner Isocenter Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerIsocenterPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_keyword =
    Keyword::PositionerIsocenterSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_element = 0x9464;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_name =
    "Positioner Isocenter Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerIsocenterSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_keyword =
    Keyword::PositionerIsocenterDetectorRotationAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_element = 0x9465;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_name =
    "Positioner Isocenter Detector Rotation Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerIsocenterDetectorRotationAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableXPositionToIsocenter>::s_keyword = Keyword::TableXPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableXPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableXPositionToIsocenter>::s_element = 0x9466;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableXPositionToIsocenter>::s_name = "Table X Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableXPositionToIsocenter>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableXPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableYPositionToIsocenter>::s_keyword = Keyword::TableYPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableYPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableYPositionToIsocenter>::s_element = 0x9467;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableYPositionToIsocenter>::s_name = "Table Y Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableYPositionToIsocenter>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableYPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableZPositionToIsocenter>::s_keyword = Keyword::TableZPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableZPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableZPositionToIsocenter>::s_element = 0x9468;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableZPositionToIsocenter>::s_name = "Table Z Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableZPositionToIsocenter>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableZPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableHorizontalRotationAngle>::s_keyword =
    Keyword::TableHorizontalRotationAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHorizontalRotationAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHorizontalRotationAngle>::s_element = 0x9469;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableHorizontalRotationAngle>::s_name =
    "Table Horizontal Rotation Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableHorizontalRotationAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableHorizontalRotationAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableHeadTiltAngle>::s_keyword = Keyword::TableHeadTiltAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHeadTiltAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableHeadTiltAngle>::s_element = 0x9470;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableHeadTiltAngle>::s_name = "Table Head Tilt Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableHeadTiltAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableHeadTiltAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableCradleTiltAngle>::s_keyword = Keyword::TableCradleTiltAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableCradleTiltAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableCradleTiltAngle>::s_element = 0x9471;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableCradleTiltAngle>::s_name = "Table Cradle Tilt Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableCradleTiltAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableCradleTiltAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameDisplayShutterSequence>::s_keyword =
    Keyword::FrameDisplayShutterSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDisplayShutterSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDisplayShutterSequence>::s_element = 0x9472;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameDisplayShutterSequence>::s_name =
    "Frame Display Shutter Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameDisplayShutterSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameDisplayShutterSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_keyword =
    Keyword::AcquiredImageAreaDoseProduct;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_element = 0x9473;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_name =
    "Acquired Image Area Dose Product";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquiredImageAreaDoseProduct>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CArmPositionerTabletopRelationship>::s_keyword =
    Keyword::CArmPositionerTabletopRelationship;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CArmPositionerTabletopRelationship>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CArmPositionerTabletopRelationship>::s_element = 0x9474;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CArmPositionerTabletopRelationship>::s_name =
    "C-arm Positioner Tabletop Relationship";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CArmPositionerTabletopRelationship>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CArmPositionerTabletopRelationship>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayGeometrySequence>::s_keyword = Keyword::XRayGeometrySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayGeometrySequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayGeometrySequence>::s_element = 0x9476;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayGeometrySequence>::s_name = "X-Ray Geometry Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayGeometrySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayGeometrySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IrradiationEventIdentificationSequence>::s_keyword =
    Keyword::IrradiationEventIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IrradiationEventIdentificationSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IrradiationEventIdentificationSequence>::s_element = 0x9477;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IrradiationEventIdentificationSequence>::s_name =
    "Irradiation Event Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IrradiationEventIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IrradiationEventIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRay3DFrameTypeSequence>::s_keyword = Keyword::XRay3DFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DFrameTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DFrameTypeSequence>::s_element = 0x9504;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRay3DFrameTypeSequence>::s_name = "X-Ray 3D Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRay3DFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRay3DFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContributingSourcesSequence>::s_keyword =
    Keyword::ContributingSourcesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingSourcesSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingSourcesSequence>::s_element = 0x9506;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContributingSourcesSequence>::s_name =
    "Contributing Sources Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContributingSourcesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContributingSourcesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRay3DAcquisitionSequence>::s_keyword = Keyword::XRay3DAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DAcquisitionSequence>::s_element = 0x9507;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRay3DAcquisitionSequence>::s_name = "X-Ray 3D Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRay3DAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRay3DAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryPositionerScanArc>::s_keyword = Keyword::PrimaryPositionerScanArc;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerScanArc>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerScanArc>::s_element = 0x9508;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryPositionerScanArc>::s_name = "Primary Positioner Scan Arc";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryPositionerScanArc>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryPositionerScanArc>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryPositionerScanArc>::s_keyword = Keyword::SecondaryPositionerScanArc;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerScanArc>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerScanArc>::s_element = 0x9509;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryPositionerScanArc>::s_name =
    "Secondary Positioner Scan Arc";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryPositionerScanArc>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryPositionerScanArc>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_keyword =
    Keyword::PrimaryPositionerScanStartAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_element = 0x9510;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_name =
    "Primary Positioner Scan Start Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryPositionerScanStartAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_keyword =
    Keyword::SecondaryPositionerScanStartAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_element = 0x9511;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_name =
    "Secondary Positioner Scan Start Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryPositionerScanStartAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryPositionerIncrement>::s_keyword = Keyword::PrimaryPositionerIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerIncrement>::s_element = 0x9514;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryPositionerIncrement>::s_name = "Primary Positioner Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryPositionerIncrement>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryPositionerIncrement>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryPositionerIncrement>::s_keyword =
    Keyword::SecondaryPositionerIncrement;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerIncrement>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerIncrement>::s_element = 0x9515;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryPositionerIncrement>::s_name =
    "Secondary Positioner Increment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryPositionerIncrement>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryPositionerIncrement>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartAcquisitionDateTime>::s_keyword = Keyword::StartAcquisitionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartAcquisitionDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartAcquisitionDateTime>::s_element = 0x9516;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartAcquisitionDateTime>::s_name = "Start Acquisition DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartAcquisitionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartAcquisitionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EndAcquisitionDateTime>::s_keyword = Keyword::EndAcquisitionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndAcquisitionDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndAcquisitionDateTime>::s_element = 0x9517;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EndAcquisitionDateTime>::s_name = "End Acquisition DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EndAcquisitionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EndAcquisitionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PrimaryPositionerIncrementSign>::s_keyword =
    Keyword::PrimaryPositionerIncrementSign;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerIncrementSign>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PrimaryPositionerIncrementSign>::s_element = 0x9518;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PrimaryPositionerIncrementSign>::s_name =
    "Primary Positioner Increment Sign";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PrimaryPositionerIncrementSign>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PrimaryPositionerIncrementSign>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SecondaryPositionerIncrementSign>::s_keyword =
    Keyword::SecondaryPositionerIncrementSign;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerIncrementSign>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SecondaryPositionerIncrementSign>::s_element = 0x9519;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SecondaryPositionerIncrementSign>::s_name =
    "Secondary Positioner Increment Sign";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SecondaryPositionerIncrementSign>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SecondaryPositionerIncrementSign>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicationName>::s_keyword = Keyword::ApplicationName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationName>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationName>::s_element = 0x9524;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicationName>::s_name = "application Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicationName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicationName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicationVersion>::s_keyword = Keyword::ApplicationVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationVersion>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationVersion>::s_element = 0x9525;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicationVersion>::s_name = "application Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicationVersion>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicationVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicationManufacturer>::s_keyword = Keyword::ApplicationManufacturer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationManufacturer>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicationManufacturer>::s_element = 0x9526;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicationManufacturer>::s_name = "application Manufacturer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicationManufacturer>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicationManufacturer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlgorithmType>::s_keyword = Keyword::AlgorithmType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmType>::s_element = 0x9527;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlgorithmType>::s_name = "Algorithm Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlgorithmType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlgorithmType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlgorithmDescription>::s_keyword = Keyword::AlgorithmDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmDescription>::s_element = 0x9528;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlgorithmDescription>::s_name = "Algorithm Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlgorithmDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlgorithmDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRay3DReconstructionSequence>::s_keyword =
    Keyword::XRay3DReconstructionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DReconstructionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRay3DReconstructionSequence>::s_element = 0x9530;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRay3DReconstructionSequence>::s_name =
    "X-Ray 3D Reconstruction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRay3DReconstructionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRay3DReconstructionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionDescription>::s_keyword = Keyword::ReconstructionDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionDescription>::s_element = 0x9531;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionDescription>::s_name = "Reconstruction Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerProjectionAcquisitionSequence>::s_keyword =
    Keyword::PerProjectionAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerProjectionAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerProjectionAcquisitionSequence>::s_element = 0x9538;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerProjectionAcquisitionSequence>::s_name =
    "Per Projection Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerProjectionAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerProjectionAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorPositionSequence>::s_keyword = Keyword::DetectorPositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorPositionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorPositionSequence>::s_element = 0x9541;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorPositionSequence>::s_name = "Detector Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorPositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorPositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayAcquisitionDoseSequence>::s_keyword =
    Keyword::XRayAcquisitionDoseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayAcquisitionDoseSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayAcquisitionDoseSequence>::s_element = 0x9542;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayAcquisitionDoseSequence>::s_name =
    "X-Ray Acquisition Dose Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayAcquisitionDoseSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayAcquisitionDoseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_keyword =
    Keyword::XRaySourceIsocenterPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_element = 0x9543;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_name =
    "X-Ray Source Isocenter Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRaySourceIsocenterPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_keyword =
    Keyword::XRaySourceIsocenterSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_element = 0x9544;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_name =
    "X-Ray Source Isocenter Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRaySourceIsocenterSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_keyword =
    Keyword::BreastSupportIsocenterPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_element = 0x9545;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_name =
    "Breast Support Isocenter Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastSupportIsocenterPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_keyword =
    Keyword::BreastSupportIsocenterSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_element = 0x9546;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_name =
    "Breast Support Isocenter Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastSupportIsocenterSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_keyword =
    Keyword::BreastSupportXPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_element = 0x9547;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_name =
    "Breast Support X Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastSupportXPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_keyword =
    Keyword::BreastSupportYPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_element = 0x9548;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_name =
    "Breast Support Y Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastSupportYPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_keyword =
    Keyword::BreastSupportZPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_element = 0x9549;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_name =
    "Breast Support Z Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastSupportZPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_keyword =
    Keyword::DetectorIsocenterPrimaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_element = 0x9550;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_name =
    "Detector Isocenter Primary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorIsocenterPrimaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_keyword =
    Keyword::DetectorIsocenterSecondaryAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_element = 0x9551;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_name =
    "Detector Isocenter Secondary Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorIsocenterSecondaryAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorXPositionToIsocenter>::s_keyword =
    Keyword::DetectorXPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorXPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorXPositionToIsocenter>::s_element = 0x9552;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorXPositionToIsocenter>::s_name =
    "Detector X Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorXPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorXPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorYPositionToIsocenter>::s_keyword =
    Keyword::DetectorYPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorYPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorYPositionToIsocenter>::s_element = 0x9553;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorYPositionToIsocenter>::s_name =
    "Detector Y Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorYPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorYPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorZPositionToIsocenter>::s_keyword =
    Keyword::DetectorZPositionToIsocenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorZPositionToIsocenter>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorZPositionToIsocenter>::s_element = 0x9554;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorZPositionToIsocenter>::s_name =
    "Detector Z Position to Isocenter";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorZPositionToIsocenter>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorZPositionToIsocenter>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayGridSequence>::s_keyword = Keyword::XRayGridSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayGridSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayGridSequence>::s_element = 0x9555;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayGridSequence>::s_name = "X-Ray Grid Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayGridSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayGridSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayFilterSequence>::s_keyword = Keyword::XRayFilterSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayFilterSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayFilterSequence>::s_element = 0x9556;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayFilterSequence>::s_name = "X-Ray filter Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayFilterSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayFilterSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_keyword =
    Keyword::DetectorActiveAreaTLHCPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_element = 0x9557;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_name =
    "Detector Active Area TLHC Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveAreaTLHCPosition>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorActiveAreaOrientation>::s_keyword =
    Keyword::DetectorActiveAreaOrientation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveAreaOrientation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorActiveAreaOrientation>::s_element = 0x9558;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorActiveAreaOrientation>::s_name =
    "Detector Active Area Orientation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorActiveAreaOrientation>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorActiveAreaOrientation>::s_vm = VM::MIN_6_MAX_6;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionerPrimaryAngleDirection>::s_keyword =
    Keyword::PositionerPrimaryAngleDirection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngleDirection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionerPrimaryAngleDirection>::s_element = 0x9559;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionerPrimaryAngleDirection>::s_name =
    "Positioner Primary Angle Direction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionerPrimaryAngleDirection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionerPrimaryAngleDirection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DiffusionBMatrixSequence>::s_keyword = Keyword::DiffusionBMatrixSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionBMatrixSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DiffusionBMatrixSequence>::s_element = 0x9601;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DiffusionBMatrixSequence>::s_name = "Diffusion b-matrix Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DiffusionBMatrixSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DiffusionBMatrixSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FunctionalMRSequence>::s_keyword = Keyword::FunctionalMRSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalMRSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalMRSequence>::s_element = 0x9621;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FunctionalMRSequence>::s_name = "Functional MR Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FunctionalMRSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FunctionalMRSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_keyword =
    Keyword::FunctionalSettlingPhaseFramesPresent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_element = 0x9622;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_name =
    "Functional Settling Phase Frames Present";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FunctionalSettlingPhaseFramesPresent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FunctionalSyncPulse>::s_keyword = Keyword::FunctionalSyncPulse;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalSyncPulse>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalSyncPulse>::s_element = 0x9623;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FunctionalSyncPulse>::s_name = "Functional Sync Pulse";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FunctionalSyncPulse>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FunctionalSyncPulse>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SettlingPhaseFrame>::s_keyword = Keyword::SettlingPhaseFrame;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SettlingPhaseFrame>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SettlingPhaseFrame>::s_element = 0x9624;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SettlingPhaseFrame>::s_name = "Settling Phase Frame";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SettlingPhaseFrame>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SettlingPhaseFrame>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecayCorrectionDateTime>::s_keyword = Keyword::DecayCorrectionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecayCorrectionDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecayCorrectionDateTime>::s_element = 0x9701;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecayCorrectionDateTime>::s_name = "Decay Correction DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecayCorrectionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecayCorrectionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartDensityThreshold>::s_keyword = Keyword::StartDensityThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartDensityThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartDensityThreshold>::s_element = 0x9715;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartDensityThreshold>::s_name = "Start Density Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartDensityThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartDensityThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_keyword =
    Keyword::StartRelativeDensityDifferenceThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_element = 0x9716;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_name =
    "Start Relative Density Difference Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartRelativeDensityDifferenceThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_keyword =
    Keyword::StartCardiacTriggerCountThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_element = 0x9717;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_name =
    "Start Cardiac Trigger Count Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartCardiacTriggerCountThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_keyword =
    Keyword::StartRespiratoryTriggerCountThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_element = 0x9718;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_name =
    "Start Respiratory Trigger Count Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartRespiratoryTriggerCountThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationCountsThreshold>::s_keyword = Keyword::TerminationCountsThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationCountsThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationCountsThreshold>::s_element = 0x9719;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationCountsThreshold>::s_name = "Termination Counts Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationCountsThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationCountsThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationDensityThreshold>::s_keyword =
    Keyword::TerminationDensityThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationDensityThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationDensityThreshold>::s_element = 0x9720;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationDensityThreshold>::s_name =
    "Termination Density Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationDensityThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationDensityThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationRelativeDensityThreshold>::s_keyword =
    Keyword::TerminationRelativeDensityThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationRelativeDensityThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationRelativeDensityThreshold>::s_element = 0x9721;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationRelativeDensityThreshold>::s_name =
    "Termination Relative Density Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationRelativeDensityThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationRelativeDensityThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationTimeThreshold>::s_keyword = Keyword::TerminationTimeThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationTimeThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationTimeThreshold>::s_element = 0x9722;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationTimeThreshold>::s_name = "Termination Time Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationTimeThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationTimeThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_keyword =
    Keyword::TerminationCardiacTriggerCountThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_element = 0x9723;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_name =
    "Termination Cardiac Trigger Count Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationCardiacTriggerCountThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_keyword =
    Keyword::TerminationRespiratoryTriggerCountThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_element = 0x9724;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_name =
    "Termination Respiratory Trigger Count Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TerminationRespiratoryTriggerCountThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorGeometry>::s_keyword = Keyword::DetectorGeometry;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorGeometry>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorGeometry>::s_element = 0x9725;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorGeometry>::s_name = "Detector Geometry";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorGeometry>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorGeometry>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransverseDetectorSeparation>::s_keyword =
    Keyword::TransverseDetectorSeparation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransverseDetectorSeparation>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransverseDetectorSeparation>::s_element = 0x9726;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransverseDetectorSeparation>::s_name =
    "Transverse Detector Separation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransverseDetectorSeparation>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransverseDetectorSeparation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AxialDetectorDimension>::s_keyword = Keyword::AxialDetectorDimension;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AxialDetectorDimension>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AxialDetectorDimension>::s_element = 0x9727;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AxialDetectorDimension>::s_name = "Axial Detector Dimension";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AxialDetectorDimension>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AxialDetectorDimension>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_keyword =
    Keyword::RadiopharmaceuticalAgentNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_element = 0x9729;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_name =
    "Radiopharmaceutical Agent Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalAgentNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETFrameAcquisitionSequence>::s_keyword =
    Keyword::PETFrameAcquisitionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameAcquisitionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameAcquisitionSequence>::s_element = 0x9732;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETFrameAcquisitionSequence>::s_name =
    "PET Frame Acquisition Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETFrameAcquisitionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETFrameAcquisitionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_keyword =
    Keyword::PETDetectorMotionDetailsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_element = 0x9733;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_name =
    "PET Detector Motion Details Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETDetectorMotionDetailsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETTableDynamicsSequence>::s_keyword = Keyword::PETTableDynamicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETTableDynamicsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETTableDynamicsSequence>::s_element = 0x9734;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETTableDynamicsSequence>::s_name = "PET Table Dynamics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETTableDynamicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETTableDynamicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETPositionSequence>::s_keyword = Keyword::PETPositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETPositionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETPositionSequence>::s_element = 0x9735;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETPositionSequence>::s_name = "PET Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETPositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETPositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_keyword =
    Keyword::PETFrameCorrectionFactorsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_element = 0x9736;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_name =
    "PET Frame Correction Factors Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETFrameCorrectionFactorsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_keyword =
    Keyword::RadiopharmaceuticalUsageSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_element = 0x9737;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_name =
    "Radiopharmaceutical Usage Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RadiopharmaceuticalUsageSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AttenuationCorrectionSource>::s_keyword =
    Keyword::AttenuationCorrectionSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrectionSource>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrectionSource>::s_element = 0x9738;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AttenuationCorrectionSource>::s_name =
    "Attenuation Correction Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AttenuationCorrectionSource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AttenuationCorrectionSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfIterations>::s_keyword = Keyword::NumberOfIterations;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfIterations>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfIterations>::s_element = 0x9739;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfIterations>::s_name = "Number of Iterations";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfIterations>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfIterations>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfSubsets>::s_keyword = Keyword::NumberOfSubsets;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfSubsets>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfSubsets>::s_element = 0x9740;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfSubsets>::s_name = "Number of Subsets";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfSubsets>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfSubsets>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETReconstructionSequence>::s_keyword = Keyword::PETReconstructionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETReconstructionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETReconstructionSequence>::s_element = 0x9749;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETReconstructionSequence>::s_name = "PET Reconstruction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETReconstructionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETReconstructionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PETFrameTypeSequence>::s_keyword = Keyword::PETFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PETFrameTypeSequence>::s_element = 0x9751;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PETFrameTypeSequence>::s_name = "PET Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PETFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PETFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfFlightInformationUsed>::s_keyword =
    Keyword::TimeOfFlightInformationUsed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFlightInformationUsed>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFlightInformationUsed>::s_element = 0x9755;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfFlightInformationUsed>::s_name =
    "Time of Flight Information Used";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfFlightInformationUsed>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfFlightInformationUsed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionType>::s_keyword = Keyword::ReconstructionType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionType>::s_element = 0x9756;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionType>::s_name = "Reconstruction Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DecayCorrected>::s_keyword = Keyword::DecayCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecayCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DecayCorrected>::s_element = 0x9758;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DecayCorrected>::s_name = "Decay Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DecayCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DecayCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AttenuationCorrected>::s_keyword = Keyword::AttenuationCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrected>::s_element = 0x9759;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AttenuationCorrected>::s_name = "Attenuation Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AttenuationCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AttenuationCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScatterCorrected>::s_keyword = Keyword::ScatterCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScatterCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScatterCorrected>::s_element = 0x9760;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScatterCorrected>::s_name = "Scatter Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScatterCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScatterCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DeadTimeCorrected>::s_keyword = Keyword::DeadTimeCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeadTimeCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DeadTimeCorrected>::s_element = 0x9761;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DeadTimeCorrected>::s_name = "Dead Time Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DeadTimeCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DeadTimeCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GantryMotionCorrected>::s_keyword = Keyword::GantryMotionCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryMotionCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GantryMotionCorrected>::s_element = 0x9762;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GantryMotionCorrected>::s_name = "Gantry Motion Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GantryMotionCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GantryMotionCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientMotionCorrected>::s_keyword = Keyword::PatientMotionCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientMotionCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientMotionCorrected>::s_element = 0x9763;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientMotionCorrected>::s_name = "Patient Motion Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientMotionCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientMotionCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CountLossNormalizationCorrected>::s_keyword =
    Keyword::CountLossNormalizationCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountLossNormalizationCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CountLossNormalizationCorrected>::s_element = 0x9764;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CountLossNormalizationCorrected>::s_name =
    "Count Loss Normalization Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CountLossNormalizationCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CountLossNormalizationCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RandomsCorrected>::s_keyword = Keyword::RandomsCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RandomsCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RandomsCorrected>::s_element = 0x9765;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RandomsCorrected>::s_name = "Randoms Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RandomsCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RandomsCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_keyword =
    Keyword::NonUniformRadialSamplingCorrected;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_element = 0x9766;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_name =
    "Non-uniform Radial Sampling Corrected";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NonUniformRadialSamplingCorrected>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SensitivityCalibrated>::s_keyword = Keyword::SensitivityCalibrated;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensitivityCalibrated>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SensitivityCalibrated>::s_element = 0x9767;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SensitivityCalibrated>::s_name = "Sensitivity Calibrated";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SensitivityCalibrated>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SensitivityCalibrated>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DetectorNormalizationCorrection>::s_keyword =
    Keyword::DetectorNormalizationCorrection;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorNormalizationCorrection>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DetectorNormalizationCorrection>::s_element = 0x9768;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DetectorNormalizationCorrection>::s_name =
    "Detector Normalization Correction";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DetectorNormalizationCorrection>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DetectorNormalizationCorrection>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IterativeReconstructionMethod>::s_keyword =
    Keyword::IterativeReconstructionMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IterativeReconstructionMethod>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IterativeReconstructionMethod>::s_element = 0x9769;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IterativeReconstructionMethod>::s_name =
    "Iterative Reconstruction Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IterativeReconstructionMethod>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IterativeReconstructionMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_keyword =
    Keyword::AttenuationCorrectionTemporalRelationship;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_element = 0x9770;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_name =
    "Attenuation Correction Temporal Relationship";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AttenuationCorrectionTemporalRelationship>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientPhysiologicalStateSequence>::s_keyword =
    Keyword::PatientPhysiologicalStateSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPhysiologicalStateSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPhysiologicalStateSequence>::s_element = 0x9771;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientPhysiologicalStateSequence>::s_name =
    "Patient Physiological State Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientPhysiologicalStateSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientPhysiologicalStateSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_keyword =
    Keyword::PatientPhysiologicalStateCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_element = 0x9772;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_name =
    "Patient Physiological State Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientPhysiologicalStateCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DepthsOfFocus>::s_keyword = Keyword::DepthsOfFocus;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthsOfFocus>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthsOfFocus>::s_element = 0x9801;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DepthsOfFocus>::s_name = "Depth(s) of Focus";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DepthsOfFocus>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DepthsOfFocus>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcludedIntervalsSequence>::s_keyword = Keyword::ExcludedIntervalsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcludedIntervalsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcludedIntervalsSequence>::s_element = 0x9803;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcludedIntervalsSequence>::s_name = "Excluded Intervals Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcludedIntervalsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcludedIntervalsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExclusionStartDateTime>::s_keyword = Keyword::ExclusionStartDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExclusionStartDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExclusionStartDateTime>::s_element = 0x9804;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExclusionStartDateTime>::s_name = "Exclusion Start DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExclusionStartDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExclusionStartDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExclusionDuration>::s_keyword = Keyword::ExclusionDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExclusionDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExclusionDuration>::s_element = 0x9805;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExclusionDuration>::s_name = "Exclusion Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExclusionDuration>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExclusionDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::USImageDescriptionSequence>::s_keyword = Keyword::USImageDescriptionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::USImageDescriptionSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::USImageDescriptionSequence>::s_element = 0x9806;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::USImageDescriptionSequence>::s_name =
    "US Image Description Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::USImageDescriptionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::USImageDescriptionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageDataTypeSequence>::s_keyword = Keyword::ImageDataTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageDataTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageDataTypeSequence>::s_element = 0x9807;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageDataTypeSequence>::s_name = "Image Data Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageDataTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageDataTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataType>::s_keyword = Keyword::DataType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataType>::s_element = 0x9808;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataType>::s_name = "Data Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerScanPatternCodeSequence>::s_keyword =
    Keyword::TransducerScanPatternCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerScanPatternCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerScanPatternCodeSequence>::s_element = 0x9809;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerScanPatternCodeSequence>::s_name =
    "Transducer Scan Pattern Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerScanPatternCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerScanPatternCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AliasedDataType>::s_keyword = Keyword::AliasedDataType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AliasedDataType>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AliasedDataType>::s_element = 0x980B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AliasedDataType>::s_name = "Aliased Data Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AliasedDataType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AliasedDataType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionMeasuringDeviceUsed>::s_keyword =
    Keyword::PositionMeasuringDeviceUsed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionMeasuringDeviceUsed>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionMeasuringDeviceUsed>::s_element = 0x980C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionMeasuringDeviceUsed>::s_name =
    "Position Measuring Device Used";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionMeasuringDeviceUsed>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionMeasuringDeviceUsed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerGeometryCodeSequence>::s_keyword =
    Keyword::TransducerGeometryCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerGeometryCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerGeometryCodeSequence>::s_element = 0x980D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerGeometryCodeSequence>::s_name =
    "Transducer Geometry Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerGeometryCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerGeometryCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_keyword =
    Keyword::TransducerBeamSteeringCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_element = 0x980E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_name =
    "Transducer Beam Steering Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerBeamSteeringCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerApplicationCodeSequence>::s_keyword =
    Keyword::TransducerApplicationCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerApplicationCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerApplicationCodeSequence>::s_element = 0x980F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerApplicationCodeSequence>::s_name =
    "Transducer application Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerApplicationCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerApplicationCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ZeroVelocityPixelValue>::s_keyword = Keyword::ZeroVelocityPixelValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZeroVelocityPixelValue>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZeroVelocityPixelValue>::s_element = 0x9810;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ZeroVelocityPixelValue>::s_name = "Zero Velocity Pixel Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ZeroVelocityPixelValue>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ZeroVelocityPixelValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_keyword =
    Keyword::PhotoacousticExcitationCharacteristicsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_element = 0x9821;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_name =
    "Photoacoustic Excitation Characteristics Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcitationSpectralWidth>::s_keyword = Keyword::ExcitationSpectralWidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationSpectralWidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationSpectralWidth>::s_element = 0x9822;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcitationSpectralWidth>::s_name = "Excitation Spectral Width";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcitationSpectralWidth>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcitationSpectralWidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcitationEnergy>::s_keyword = Keyword::ExcitationEnergy;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationEnergy>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationEnergy>::s_element = 0x9823;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcitationEnergy>::s_name = "Excitation Energy";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcitationEnergy>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcitationEnergy>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcitationPulseDuration>::s_keyword = Keyword::ExcitationPulseDuration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationPulseDuration>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationPulseDuration>::s_element = 0x9824;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcitationPulseDuration>::s_name = "Excitation Pulse Duration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcitationPulseDuration>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcitationPulseDuration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcitationWavelengthSequence>::s_keyword =
    Keyword::ExcitationWavelengthSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationWavelengthSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationWavelengthSequence>::s_element = 0x9825;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcitationWavelengthSequence>::s_name =
    "Excitation Wavelength Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcitationWavelengthSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcitationWavelengthSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExcitationWavelength>::s_keyword = Keyword::ExcitationWavelength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationWavelength>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExcitationWavelength>::s_element = 0x9826;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExcitationWavelength>::s_name = "Excitation Wavelength";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExcitationWavelength>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExcitationWavelength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IlluminationTranslationFlag>::s_keyword =
    Keyword::IlluminationTranslationFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationTranslationFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationTranslationFlag>::s_element = 0x9828;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IlluminationTranslationFlag>::s_name =
    "Illumination Translation Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IlluminationTranslationFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IlluminationTranslationFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcousticCouplingMediumFlag>::s_keyword = Keyword::AcousticCouplingMediumFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumFlag>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumFlag>::s_element = 0x9829;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcousticCouplingMediumFlag>::s_name =
    "Acoustic Coupling Medium Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcousticCouplingMediumFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcousticCouplingMediumFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_keyword =
    Keyword::AcousticCouplingMediumCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_element = 0x982A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_name =
    "Acoustic Coupling Medium Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcousticCouplingMediumCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcousticCouplingMediumTemperature>::s_keyword =
    Keyword::AcousticCouplingMediumTemperature;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumTemperature>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumTemperature>::s_element = 0x982B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcousticCouplingMediumTemperature>::s_name =
    "Acoustic Coupling Medium Temperature";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcousticCouplingMediumTemperature>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcousticCouplingMediumTemperature>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerResponseSequence>::s_keyword = Keyword::TransducerResponseSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerResponseSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerResponseSequence>::s_element = 0x982C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerResponseSequence>::s_name = "Transducer Response Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerResponseSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerResponseSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CenterFrequency>::s_keyword = Keyword::CenterFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CenterFrequency>::s_element = 0x982D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CenterFrequency>::s_name = "Center Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CenterFrequency>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CenterFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FractionalBandwidth>::s_keyword = Keyword::FractionalBandwidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FractionalBandwidth>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FractionalBandwidth>::s_element = 0x982E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FractionalBandwidth>::s_name = "Fractional Bandwidth";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FractionalBandwidth>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FractionalBandwidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LowerCutoffFrequency>::s_keyword = Keyword::LowerCutoffFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LowerCutoffFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LowerCutoffFrequency>::s_element = 0x982F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LowerCutoffFrequency>::s_name = "Lower Cutoff Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LowerCutoffFrequency>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LowerCutoffFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UpperCutoffFrequency>::s_keyword = Keyword::UpperCutoffFrequency;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UpperCutoffFrequency>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UpperCutoffFrequency>::s_element = 0x9830;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UpperCutoffFrequency>::s_name = "Upper Cutoff Frequency";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UpperCutoffFrequency>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UpperCutoffFrequency>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransducerTechnologySequence>::s_keyword =
    Keyword::TransducerTechnologySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerTechnologySequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransducerTechnologySequence>::s_element = 0x9831;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransducerTechnologySequence>::s_name =
    "Transducer Technology Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransducerTechnologySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransducerTechnologySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_keyword =
    Keyword::SoundSpeedCorrectionMechanismCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_element = 0x9832;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_name =
    "Sound Speed Correction Mechanism Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ObjectSoundSpeed>::s_keyword = Keyword::ObjectSoundSpeed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectSoundSpeed>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ObjectSoundSpeed>::s_element = 0x9833;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ObjectSoundSpeed>::s_name = "Object Sound Speed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ObjectSoundSpeed>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ObjectSoundSpeed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_keyword =
    Keyword::AcousticCouplingMediumSoundSpeed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_element = 0x9834;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_name =
    "Acoustic Coupling Medium Sound Speed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcousticCouplingMediumSoundSpeed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_keyword =
    Keyword::PhotoacousticImageFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_element = 0x9835;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_name =
    "Photoacoustic Image Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhotoacousticImageFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageDataTypeCodeSequence>::s_keyword = Keyword::ImageDataTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageDataTypeCodeSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageDataTypeCodeSequence>::s_element = 0x9836;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageDataTypeCodeSequence>::s_name = "Image Data Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageDataTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageDataTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_keyword =
    Keyword::ReferencedDefinedProtocolSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_element = 0x990C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_name =
    "Referenced Defined Protocol Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedDefinedProtocolSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_keyword =
    Keyword::ReferencedPerformedProtocolSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_element = 0x990D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_name =
    "Referenced Performed Protocol Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedPerformedProtocolSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_keyword =
    Keyword::SourceAcquisitionProtocolElementNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_element = 0x9938;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_name =
    "Source Acquisition Protocol Element Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceAcquisitionProtocolElementNumber>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_keyword =
    Keyword::SourceReconstructionProtocolElementNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_element = 0x993A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_name =
    "Source Reconstruction Protocol Element Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SourceReconstructionProtocolElementNumber>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionAlgorithmSequence>::s_keyword =
    Keyword::ReconstructionAlgorithmSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAlgorithmSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionAlgorithmSequence>::s_element = 0x993D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionAlgorithmSequence>::s_name =
    "Reconstruction Algorithm Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionAlgorithmSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionAlgorithmSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContributingEquipmentSequence>::s_keyword =
    Keyword::ContributingEquipmentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingEquipmentSequence>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingEquipmentSequence>::s_element = 0xA001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContributingEquipmentSequence>::s_name =
    "Contributing Equipment Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContributingEquipmentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContributingEquipmentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContributionDateTime>::s_keyword = Keyword::ContributionDateTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributionDateTime>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributionDateTime>::s_element = 0xA002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContributionDateTime>::s_name = "Contribution DateTime";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContributionDateTime>::s_vr = VR::DT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContributionDateTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContributionDescription>::s_keyword = Keyword::ContributionDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributionDescription>::s_group = 0x0018;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributionDescription>::s_element = 0xA003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContributionDescription>::s_name = "Contribution Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContributionDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContributionDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudyInstanceUID>::s_keyword = Keyword::StudyInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyInstanceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyInstanceUID>::s_element = 0x000D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudyInstanceUID>::s_name = "Study Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudyInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudyInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesInstanceUID>::s_keyword = Keyword::SeriesInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesInstanceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesInstanceUID>::s_element = 0x000E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesInstanceUID>::s_name = "Series Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StudyID>::s_keyword = Keyword::StudyID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StudyID>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StudyID>::s_name = "Study ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StudyID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StudyID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SeriesNumber>::s_keyword = Keyword::SeriesNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SeriesNumber>::s_element = 0x0011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SeriesNumber>::s_name = "Series Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SeriesNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SeriesNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionNumber>::s_keyword = Keyword::AcquisitionNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionNumber>::s_element = 0x0012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionNumber>::s_name = "Acquisition Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InstanceNumber>::s_keyword = Keyword::InstanceNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InstanceNumber>::s_element = 0x0013;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InstanceNumber>::s_name = "Instance Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InstanceNumber>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InstanceNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientOrientation>::s_keyword = Keyword::PatientOrientation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientOrientation>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientOrientation>::s_element = 0x0020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientOrientation>::s_name = "Patient Orientation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientOrientation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientOrientation>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PyramidLabel>::s_keyword = Keyword::PyramidLabel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidLabel>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PyramidLabel>::s_element = 0x0027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PyramidLabel>::s_name = "Pyramid Label";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PyramidLabel>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PyramidLabel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagePositionPatient>::s_keyword = Keyword::ImagePositionPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePositionPatient>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePositionPatient>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagePositionPatient>::s_name = "Image Position (Patient)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagePositionPatient>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagePositionPatient>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageOrientationPatient>::s_keyword = Keyword::ImageOrientationPatient;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageOrientationPatient>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageOrientationPatient>::s_element = 0x0037;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageOrientationPatient>::s_name = "Image Orientation (Patient)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageOrientationPatient>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageOrientationPatient>::s_vm = VM::MIN_6_MAX_6;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameOfReferenceUID>::s_keyword = Keyword::FrameOfReferenceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfReferenceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfReferenceUID>::s_element = 0x0052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameOfReferenceUID>::s_name = "Frame of Reference UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameOfReferenceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameOfReferenceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Laterality>::s_keyword = Keyword::Laterality;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Laterality>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Laterality>::s_element = 0x0060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Laterality>::s_name = "Laterality";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Laterality>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Laterality>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageLaterality>::s_keyword = Keyword::ImageLaterality;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageLaterality>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageLaterality>::s_element = 0x0062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageLaterality>::s_name = "Image Laterality";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageLaterality>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageLaterality>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TemporalPositionIdentifier>::s_keyword = Keyword::TemporalPositionIdentifier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionIdentifier>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionIdentifier>::s_element = 0x0100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TemporalPositionIdentifier>::s_name = "Temporal Position Identifier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TemporalPositionIdentifier>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TemporalPositionIdentifier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfTemporalPositions>::s_keyword = Keyword::NumberOfTemporalPositions;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTemporalPositions>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfTemporalPositions>::s_element = 0x0105;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfTemporalPositions>::s_name = "Number of Temporal Positions";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfTemporalPositions>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfTemporalPositions>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TemporalResolution>::s_keyword = Keyword::TemporalResolution;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalResolution>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalResolution>::s_element = 0x0110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TemporalResolution>::s_name = "Temporal Resolution";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TemporalResolution>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TemporalResolution>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_keyword =
    Keyword::SynchronizationFrameOfReferenceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_element = 0x0200;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_name =
    "Synchronization Frame of Reference UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SynchronizationFrameOfReferenceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_keyword =
    Keyword::SOPInstanceUIDOfConcatenationSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_element = 0x0242;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_name =
    "SOP Instance UID of Concatenation Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SOPInstanceUIDOfConcatenationSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagesInAcquisition>::s_keyword = Keyword::ImagesInAcquisition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagesInAcquisition>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagesInAcquisition>::s_element = 0x1002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagesInAcquisition>::s_name = "Images in Acquisition";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagesInAcquisition>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagesInAcquisition>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PositionReferenceIndicator>::s_keyword = Keyword::PositionReferenceIndicator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionReferenceIndicator>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PositionReferenceIndicator>::s_element = 0x1040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PositionReferenceIndicator>::s_name = "Position Reference Indicator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PositionReferenceIndicator>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PositionReferenceIndicator>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SliceLocation>::s_keyword = Keyword::SliceLocation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceLocation>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SliceLocation>::s_element = 0x1041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SliceLocation>::s_name = "Slice Location";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SliceLocation>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SliceLocation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageComments>::s_keyword = Keyword::ImageComments;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageComments>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageComments>::s_element = 0x4000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageComments>::s_name = "Image Comments";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageComments>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageComments>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StackID>::s_keyword = Keyword::StackID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StackID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StackID>::s_element = 0x9056;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StackID>::s_name = "Stack ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StackID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StackID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InStackPositionNumber>::s_keyword = Keyword::InStackPositionNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InStackPositionNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InStackPositionNumber>::s_element = 0x9057;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InStackPositionNumber>::s_name = "In-Stack Position Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InStackPositionNumber>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InStackPositionNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameAnatomySequence>::s_keyword = Keyword::FrameAnatomySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAnatomySequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAnatomySequence>::s_element = 0x9071;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameAnatomySequence>::s_name = "Frame Anatomy Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameAnatomySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameAnatomySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameLaterality>::s_keyword = Keyword::FrameLaterality;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLaterality>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLaterality>::s_element = 0x9072;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameLaterality>::s_name = "Frame Laterality";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameLaterality>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameLaterality>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameContentSequence>::s_keyword = Keyword::FrameContentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameContentSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameContentSequence>::s_element = 0x9111;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameContentSequence>::s_name = "Frame Content Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameContentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameContentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlanePositionSequence>::s_keyword = Keyword::PlanePositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanePositionSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanePositionSequence>::s_element = 0x9113;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlanePositionSequence>::s_name = "Plane Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlanePositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlanePositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlaneOrientationSequence>::s_keyword = Keyword::PlaneOrientationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneOrientationSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneOrientationSequence>::s_element = 0x9116;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlaneOrientationSequence>::s_name = "Plane Orientation Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlaneOrientationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlaneOrientationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TemporalPositionIndex>::s_keyword = Keyword::TemporalPositionIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionIndex>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionIndex>::s_element = 0x9128;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TemporalPositionIndex>::s_name = "Temporal Position Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TemporalPositionIndex>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TemporalPositionIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_keyword =
    Keyword::NominalCardiacTriggerDelayTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_element = 0x9153;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_name =
    "Nominal Cardiac Trigger Delay Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalCardiacTriggerDelayTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_keyword =
    Keyword::NominalCardiacTriggerTimePriorToRPeak;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_element = 0x9154;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_name =
    "Nominal Cardiac Trigger Time Prior To R-Peak";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_keyword =
    Keyword::ActualCardiacTriggerTimePriorToRPeak;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_element = 0x9155;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_name =
    "Actual Cardiac Trigger Time Prior To R-Peak";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameAcquisitionNumber>::s_keyword = Keyword::FrameAcquisitionNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameAcquisitionNumber>::s_element = 0x9156;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameAcquisitionNumber>::s_name = "Frame Acquisition Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameAcquisitionNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameAcquisitionNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionIndexValues>::s_keyword = Keyword::DimensionIndexValues;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexValues>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexValues>::s_element = 0x9157;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionIndexValues>::s_name = "Dimension Index Values";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionIndexValues>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionIndexValues>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameComments>::s_keyword = Keyword::FrameComments;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameComments>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameComments>::s_element = 0x9158;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameComments>::s_name = "Frame Comments";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameComments>::s_vr = VR::LT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameComments>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConcatenationUID>::s_keyword = Keyword::ConcatenationUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConcatenationUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConcatenationUID>::s_element = 0x9161;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConcatenationUID>::s_name = "Concatenation UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConcatenationUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConcatenationUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InConcatenationNumber>::s_keyword = Keyword::InConcatenationNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InConcatenationNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InConcatenationNumber>::s_element = 0x9162;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InConcatenationNumber>::s_name = "In-concatenation Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InConcatenationNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InConcatenationNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::InConcatenationTotalNumber>::s_keyword = Keyword::InConcatenationTotalNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InConcatenationTotalNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::InConcatenationTotalNumber>::s_element = 0x9163;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::InConcatenationTotalNumber>::s_name =
    "In-concatenation Total Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::InConcatenationTotalNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::InConcatenationTotalNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionOrganizationUID>::s_keyword = Keyword::DimensionOrganizationUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationUID>::s_element = 0x9164;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionOrganizationUID>::s_name = "Dimension Organization UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionOrganizationUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionOrganizationUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionIndexPointer>::s_keyword = Keyword::DimensionIndexPointer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexPointer>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexPointer>::s_element = 0x9165;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionIndexPointer>::s_name = "Dimension Index Pointer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionIndexPointer>::s_vr = VR::AT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionIndexPointer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FunctionalGroupPointer>::s_keyword = Keyword::FunctionalGroupPointer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalGroupPointer>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalGroupPointer>::s_element = 0x9167;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FunctionalGroupPointer>::s_name = "Functional Group Pointer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FunctionalGroupPointer>::s_vr = VR::AT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FunctionalGroupPointer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_keyword =
    Keyword::UnassignedSharedConvertedAttributesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_element = 0x9170;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_name =
    "Unassigned Shared Converted Attributes Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UnassignedSharedConvertedAttributesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_keyword =
    Keyword::UnassignedPerFrameConvertedAttributesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_element = 0x9171;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_name =
    "Unassigned Per-Frame Converted Attributes Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConversionSourceAttributesSequence>::s_keyword =
    Keyword::ConversionSourceAttributesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConversionSourceAttributesSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConversionSourceAttributesSequence>::s_element = 0x9172;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConversionSourceAttributesSequence>::s_name =
    "Conversion Source Attributes Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConversionSourceAttributesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConversionSourceAttributesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionIndexPrivateCreator>::s_keyword =
    Keyword::DimensionIndexPrivateCreator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexPrivateCreator>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexPrivateCreator>::s_element = 0x9213;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionIndexPrivateCreator>::s_name =
    "Dimension Index Private Creator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionIndexPrivateCreator>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionIndexPrivateCreator>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionOrganizationSequence>::s_keyword =
    Keyword::DimensionOrganizationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationSequence>::s_element = 0x9221;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionOrganizationSequence>::s_name =
    "Dimension Organization Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionOrganizationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionOrganizationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionIndexSequence>::s_keyword = Keyword::DimensionIndexSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionIndexSequence>::s_element = 0x9222;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionIndexSequence>::s_name = "Dimension Index Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionIndexSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionIndexSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_keyword =
    Keyword::ConcatenationFrameOffsetNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_element = 0x9228;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_name =
    "Concatenation Frame Offset Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ConcatenationFrameOffsetNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FunctionalGroupPrivateCreator>::s_keyword =
    Keyword::FunctionalGroupPrivateCreator;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalGroupPrivateCreator>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FunctionalGroupPrivateCreator>::s_element = 0x9238;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FunctionalGroupPrivateCreator>::s_name =
    "Functional Group Private Creator";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FunctionalGroupPrivateCreator>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FunctionalGroupPrivateCreator>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_keyword =
    Keyword::NominalPercentageOfCardiacPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_element = 0x9241;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_name =
    "Nominal Percentage of Cardiac Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalPercentageOfCardiacPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_keyword =
    Keyword::NominalPercentageOfRespiratoryPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_element = 0x9245;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_name =
    "Nominal Percentage of Respiratory Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalPercentageOfRespiratoryPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartingRespiratoryAmplitude>::s_keyword =
    Keyword::StartingRespiratoryAmplitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartingRespiratoryAmplitude>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartingRespiratoryAmplitude>::s_element = 0x9246;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartingRespiratoryAmplitude>::s_name =
    "Starting Respiratory Amplitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartingRespiratoryAmplitude>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartingRespiratoryAmplitude>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StartingRespiratoryPhase>::s_keyword = Keyword::StartingRespiratoryPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartingRespiratoryPhase>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StartingRespiratoryPhase>::s_element = 0x9247;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StartingRespiratoryPhase>::s_name = "Starting Respiratory Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StartingRespiratoryPhase>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StartingRespiratoryPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EndingRespiratoryAmplitude>::s_keyword = Keyword::EndingRespiratoryAmplitude;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndingRespiratoryAmplitude>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndingRespiratoryAmplitude>::s_element = 0x9248;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EndingRespiratoryAmplitude>::s_name = "Ending Respiratory Amplitude";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EndingRespiratoryAmplitude>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EndingRespiratoryAmplitude>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EndingRespiratoryPhase>::s_keyword = Keyword::EndingRespiratoryPhase;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndingRespiratoryPhase>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EndingRespiratoryPhase>::s_element = 0x9249;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EndingRespiratoryPhase>::s_name = "Ending Respiratory Phase";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EndingRespiratoryPhase>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EndingRespiratoryPhase>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratoryTriggerType>::s_keyword = Keyword::RespiratoryTriggerType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryTriggerType>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryTriggerType>::s_element = 0x9250;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratoryTriggerType>::s_name = "Respiratory Trigger Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratoryTriggerType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratoryTriggerType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RRIntervalTimeNominal>::s_keyword = Keyword::RRIntervalTimeNominal;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RRIntervalTimeNominal>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RRIntervalTimeNominal>::s_element = 0x9251;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RRIntervalTimeNominal>::s_name = "R-R Interval Time Nominal";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RRIntervalTimeNominal>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RRIntervalTimeNominal>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_keyword =
    Keyword::ActualCardiacTriggerDelayTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_element = 0x9252;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_name =
    "Actual Cardiac Trigger Delay Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ActualCardiacTriggerDelayTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratorySynchronizationSequence>::s_keyword =
    Keyword::RespiratorySynchronizationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratorySynchronizationSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratorySynchronizationSequence>::s_element = 0x9253;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratorySynchronizationSequence>::s_name =
    "Respiratory Synchronization Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratorySynchronizationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratorySynchronizationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratoryIntervalTime>::s_keyword = Keyword::RespiratoryIntervalTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryIntervalTime>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryIntervalTime>::s_element = 0x9254;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratoryIntervalTime>::s_name = "Respiratory Interval Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratoryIntervalTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratoryIntervalTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_keyword =
    Keyword::NominalRespiratoryTriggerDelayTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_element = 0x9255;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_name =
    "Nominal Respiratory Trigger Delay Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NominalRespiratoryTriggerDelayTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_keyword =
    Keyword::RespiratoryTriggerDelayThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_element = 0x9256;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_name =
    "Respiratory Trigger Delay Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RespiratoryTriggerDelayThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_keyword =
    Keyword::ActualRespiratoryTriggerDelayTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_element = 0x9257;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_name =
    "Actual Respiratory Trigger Delay Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ActualRespiratoryTriggerDelayTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagePositionVolume>::s_keyword = Keyword::ImagePositionVolume;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePositionVolume>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePositionVolume>::s_element = 0x9301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagePositionVolume>::s_name = "Image Position (Volume)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagePositionVolume>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagePositionVolume>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageOrientationVolume>::s_keyword = Keyword::ImageOrientationVolume;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageOrientationVolume>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageOrientationVolume>::s_element = 0x9302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageOrientationVolume>::s_name = "Image Orientation (Volume)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageOrientationVolume>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageOrientationVolume>::s_vm = VM::MIN_6_MAX_6;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_keyword =
    Keyword::UltrasoundAcquisitionGeometry;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_element = 0x9307;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_name =
    "Ultrasound Acquisition Geometry";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UltrasoundAcquisitionGeometry>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApexPosition>::s_keyword = Keyword::ApexPosition;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApexPosition>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApexPosition>::s_element = 0x9308;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApexPosition>::s_name = "Apex Position";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApexPosition>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApexPosition>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_keyword =
    Keyword::VolumeToTransducerMappingMatrix;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_element = 0x9309;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_name =
    "Volume to Transducer Mapping Matrix";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumeToTransducerMappingMatrix>::s_vm = VM::MIN_16_MAX_16;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumeToTableMappingMatrix>::s_keyword = Keyword::VolumeToTableMappingMatrix;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTableMappingMatrix>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTableMappingMatrix>::s_element = 0x930A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumeToTableMappingMatrix>::s_name =
    "Volume to Table Mapping Matrix";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumeToTableMappingMatrix>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumeToTableMappingMatrix>::s_vm = VM::MIN_16_MAX_16;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumeToTransducerRelationship>::s_keyword =
    Keyword::VolumeToTransducerRelationship;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTransducerRelationship>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeToTransducerRelationship>::s_element = 0x930B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumeToTransducerRelationship>::s_name =
    "Volume to Transducer Relationship";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumeToTransducerRelationship>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumeToTransducerRelationship>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientFrameOfReferenceSource>::s_keyword =
    Keyword::PatientFrameOfReferenceSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientFrameOfReferenceSource>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientFrameOfReferenceSource>::s_element = 0x930C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientFrameOfReferenceSource>::s_name =
    "Patient Frame of Reference Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientFrameOfReferenceSource>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientFrameOfReferenceSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TemporalPositionTimeOffset>::s_keyword = Keyword::TemporalPositionTimeOffset;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionTimeOffset>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionTimeOffset>::s_element = 0x930D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TemporalPositionTimeOffset>::s_name =
    "Temporal Position Time Offset";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TemporalPositionTimeOffset>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TemporalPositionTimeOffset>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlanePositionVolumeSequence>::s_keyword =
    Keyword::PlanePositionVolumeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanePositionVolumeSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanePositionVolumeSequence>::s_element = 0x930E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlanePositionVolumeSequence>::s_name =
    "Plane Position (Volume) Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlanePositionVolumeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlanePositionVolumeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlaneOrientationVolumeSequence>::s_keyword =
    Keyword::PlaneOrientationVolumeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneOrientationVolumeSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlaneOrientationVolumeSequence>::s_element = 0x930F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlaneOrientationVolumeSequence>::s_name =
    "Plane Orientation (Volume) Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlaneOrientationVolumeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlaneOrientationVolumeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TemporalPositionSequence>::s_keyword = Keyword::TemporalPositionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TemporalPositionSequence>::s_element = 0x9310;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TemporalPositionSequence>::s_name = "Temporal Position Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TemporalPositionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TemporalPositionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionOrganizationType>::s_keyword = Keyword::DimensionOrganizationType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationType>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionOrganizationType>::s_element = 0x9311;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionOrganizationType>::s_name = "Dimension Organization Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionOrganizationType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionOrganizationType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VolumeFrameOfReferenceUID>::s_keyword = Keyword::VolumeFrameOfReferenceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeFrameOfReferenceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VolumeFrameOfReferenceUID>::s_element = 0x9312;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VolumeFrameOfReferenceUID>::s_name = "Volume Frame of Reference UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VolumeFrameOfReferenceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VolumeFrameOfReferenceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TableFrameOfReferenceUID>::s_keyword = Keyword::TableFrameOfReferenceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableFrameOfReferenceUID>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TableFrameOfReferenceUID>::s_element = 0x9313;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TableFrameOfReferenceUID>::s_name = "Table Frame of Reference UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TableFrameOfReferenceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TableFrameOfReferenceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DimensionDescriptionLabel>::s_keyword = Keyword::DimensionDescriptionLabel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionDescriptionLabel>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DimensionDescriptionLabel>::s_element = 0x9421;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DimensionDescriptionLabel>::s_name = "Dimension Description Label";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DimensionDescriptionLabel>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DimensionDescriptionLabel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientOrientationInFrameSequence>::s_keyword =
    Keyword::PatientOrientationInFrameSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientOrientationInFrameSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientOrientationInFrameSequence>::s_element = 0x9450;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientOrientationInFrameSequence>::s_name =
    "Patient Orientation in Frame Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientOrientationInFrameSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientOrientationInFrameSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameLabel>::s_keyword = Keyword::FrameLabel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLabel>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameLabel>::s_element = 0x9453;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameLabel>::s_name = "Frame Label";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameLabel>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameLabel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionIndex>::s_keyword = Keyword::AcquisitionIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionIndex>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionIndex>::s_element = 0x9518;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionIndex>::s_name = "Acquisition Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionIndex>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_keyword =
    Keyword::ContributingSOPInstancesReferenceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_element = 0x9529;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_name =
    "Contributing SOP Instances Reference Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContributingSOPInstancesReferenceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReconstructionIndex>::s_keyword = Keyword::ReconstructionIndex;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionIndex>::s_group = 0x0020;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReconstructionIndex>::s_element = 0x9536;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReconstructionIndex>::s_name = "Reconstruction Index";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReconstructionIndex>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReconstructionIndex>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_keyword =
    Keyword::LightPathFilterPassThroughWavelength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_element = 0x0001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_name =
    "Light Path filter Pass-Through Wavelength";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LightPathFilterPassThroughWavelength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LightPathFilterPassBand>::s_keyword = Keyword::LightPathFilterPassBand;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterPassBand>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterPassBand>::s_element = 0x0002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LightPathFilterPassBand>::s_name = "Light Path filter Pass Band";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LightPathFilterPassBand>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LightPathFilterPassBand>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_keyword =
    Keyword::ImagePathFilterPassThroughWavelength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_element = 0x0003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_name =
    "Image Path filter Pass-Through Wavelength";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagePathFilterPassThroughWavelength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagePathFilterPassBand>::s_keyword = Keyword::ImagePathFilterPassBand;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterPassBand>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterPassBand>::s_element = 0x0004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagePathFilterPassBand>::s_name = "Image Path filter Pass Band";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagePathFilterPassBand>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagePathFilterPassBand>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientEyeMovementCommanded>::s_keyword =
    Keyword::PatientEyeMovementCommanded;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientEyeMovementCommanded>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientEyeMovementCommanded>::s_element = 0x0005;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientEyeMovementCommanded>::s_name =
    "Patient Eye Movement Commanded";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientEyeMovementCommanded>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientEyeMovementCommanded>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_keyword =
    Keyword::PatientEyeMovementCommandCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_element = 0x0006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_name =
    "Patient Eye Movement Command Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientEyeMovementCommandCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SphericalLensPower>::s_keyword = Keyword::SphericalLensPower;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SphericalLensPower>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SphericalLensPower>::s_element = 0x0007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SphericalLensPower>::s_name = "Spherical Lens Power";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SphericalLensPower>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SphericalLensPower>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CylinderLensPower>::s_keyword = Keyword::CylinderLensPower;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CylinderLensPower>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CylinderLensPower>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CylinderLensPower>::s_name = "Cylinder Lens Power";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CylinderLensPower>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CylinderLensPower>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CylinderAxis>::s_keyword = Keyword::CylinderAxis;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CylinderAxis>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CylinderAxis>::s_element = 0x0009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CylinderAxis>::s_name = "Cylinder Axis";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CylinderAxis>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CylinderAxis>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EmmetropicMagnification>::s_keyword = Keyword::EmmetropicMagnification;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EmmetropicMagnification>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EmmetropicMagnification>::s_element = 0x000A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EmmetropicMagnification>::s_name = "Emmetropic Magnification";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EmmetropicMagnification>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EmmetropicMagnification>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IntraOcularPressure>::s_keyword = Keyword::IntraOcularPressure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntraOcularPressure>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IntraOcularPressure>::s_element = 0x000B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IntraOcularPressure>::s_name = "Intra Ocular Pressure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IntraOcularPressure>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IntraOcularPressure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::HorizontalFieldOfView>::s_keyword = Keyword::HorizontalFieldOfView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HorizontalFieldOfView>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HorizontalFieldOfView>::s_element = 0x000C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::HorizontalFieldOfView>::s_name = "Horizontal field of view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::HorizontalFieldOfView>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::HorizontalFieldOfView>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PupilDilated>::s_keyword = Keyword::PupilDilated;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PupilDilated>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PupilDilated>::s_element = 0x000D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PupilDilated>::s_name = "Pupil Dilated";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PupilDilated>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PupilDilated>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DegreeOfDilation>::s_keyword = Keyword::DegreeOfDilation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DegreeOfDilation>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DegreeOfDilation>::s_element = 0x000E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DegreeOfDilation>::s_name = "Degree of Dilation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DegreeOfDilation>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DegreeOfDilation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_keyword =
    Keyword::AcquisitionDeviceTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_element = 0x0015;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_name =
    "Acquisition Device Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionDeviceTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IlluminationTypeCodeSequence>::s_keyword =
    Keyword::IlluminationTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationTypeCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationTypeCodeSequence>::s_element = 0x0016;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IlluminationTypeCodeSequence>::s_name =
    "Illumination Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IlluminationTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IlluminationTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_keyword =
    Keyword::LightPathFilterTypeStackCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_element = 0x0017;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_name =
    "Light Path filter Type Stack Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LightPathFilterTypeStackCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_keyword =
    Keyword::ImagePathFilterTypeStackCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_element = 0x0018;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_name =
    "Image Path filter Type Stack Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImagePathFilterTypeStackCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LensesCodeSequence>::s_keyword = Keyword::LensesCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensesCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LensesCodeSequence>::s_element = 0x0019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LensesCodeSequence>::s_name = "Lenses Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LensesCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LensesCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ChannelDescriptionCodeSequence>::s_keyword =
    Keyword::ChannelDescriptionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelDescriptionCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelDescriptionCodeSequence>::s_element = 0x001A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ChannelDescriptionCodeSequence>::s_name =
    "Channel Description Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ChannelDescriptionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ChannelDescriptionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RefractiveStateSequence>::s_keyword = Keyword::RefractiveStateSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RefractiveStateSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RefractiveStateSequence>::s_element = 0x001B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RefractiveStateSequence>::s_name = "Refractive State Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RefractiveStateSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RefractiveStateSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MydriaticAgentCodeSequence>::s_keyword = Keyword::MydriaticAgentCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentCodeSequence>::s_element = 0x001C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MydriaticAgentCodeSequence>::s_name =
    "Mydriatic Agent Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MydriaticAgentCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MydriaticAgentCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RelativeImagePositionCodeSequence>::s_keyword =
    Keyword::RelativeImagePositionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelativeImagePositionCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelativeImagePositionCodeSequence>::s_element = 0x001D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RelativeImagePositionCodeSequence>::s_name =
    "Relative Image Position Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RelativeImagePositionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RelativeImagePositionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CameraAngleOfView>::s_keyword = Keyword::CameraAngleOfView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraAngleOfView>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraAngleOfView>::s_element = 0x001E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CameraAngleOfView>::s_name = "Camera Angle of view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CameraAngleOfView>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CameraAngleOfView>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StereoPairsPresent>::s_keyword = Keyword::StereoPairsPresent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StereoPairsPresent>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StereoPairsPresent>::s_element = 0x0028;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StereoPairsPresent>::s_name = "Stereo Pairs Present";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StereoPairsPresent>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StereoPairsPresent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AxialLengthOfTheEye>::s_keyword = Keyword::AxialLengthOfTheEye;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AxialLengthOfTheEye>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AxialLengthOfTheEye>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AxialLengthOfTheEye>::s_name = "Axial Length of the Eye";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AxialLengthOfTheEye>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AxialLengthOfTheEye>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicFrameLocationSequence>::s_keyword =
    Keyword::OphthalmicFrameLocationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicFrameLocationSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicFrameLocationSequence>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicFrameLocationSequence>::s_name =
    "Ophthalmic Frame Location Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicFrameLocationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicFrameLocationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferenceCoordinates>::s_keyword = Keyword::ReferenceCoordinates;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferenceCoordinates>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferenceCoordinates>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferenceCoordinates>::s_name = "Reference Coordinates";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferenceCoordinates>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferenceCoordinates>::s_vm = VM::MIN_2_MAX_2N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DepthSpatialResolution>::s_keyword = Keyword::DepthSpatialResolution;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthSpatialResolution>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthSpatialResolution>::s_element = 0x0035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DepthSpatialResolution>::s_name = "Depth Spatial Resolution";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DepthSpatialResolution>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DepthSpatialResolution>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaximumDepthDistortion>::s_keyword = Keyword::MaximumDepthDistortion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumDepthDistortion>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumDepthDistortion>::s_element = 0x0036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaximumDepthDistortion>::s_name = "Maximum Depth Distortion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaximumDepthDistortion>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaximumDepthDistortion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlongScanSpatialResolution>::s_keyword = Keyword::AlongScanSpatialResolution;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlongScanSpatialResolution>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlongScanSpatialResolution>::s_element = 0x0037;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlongScanSpatialResolution>::s_name =
    "Along-scan Spatial Resolution";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlongScanSpatialResolution>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlongScanSpatialResolution>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaximumAlongScanDistortion>::s_keyword = Keyword::MaximumAlongScanDistortion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumAlongScanDistortion>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumAlongScanDistortion>::s_element = 0x0038;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaximumAlongScanDistortion>::s_name =
    "Maximum Along-scan Distortion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaximumAlongScanDistortion>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaximumAlongScanDistortion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicImageOrientation>::s_keyword = Keyword::OphthalmicImageOrientation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageOrientation>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageOrientation>::s_element = 0x0039;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicImageOrientation>::s_name = "Ophthalmic Image Orientation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicImageOrientation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicImageOrientation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DepthOfTransverseImage>::s_keyword = Keyword::DepthOfTransverseImage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthOfTransverseImage>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DepthOfTransverseImage>::s_element = 0x0041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DepthOfTransverseImage>::s_name = "Depth of Transverse Image";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DepthOfTransverseImage>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DepthOfTransverseImage>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_keyword =
    Keyword::MydriaticAgentConcentrationUnitsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_element = 0x0042;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_name =
    "Mydriatic Agent Concentration Units Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MydriaticAgentConcentrationUnitsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcrossScanSpatialResolution>::s_keyword =
    Keyword::AcrossScanSpatialResolution;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcrossScanSpatialResolution>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcrossScanSpatialResolution>::s_element = 0x0048;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcrossScanSpatialResolution>::s_name =
    "Across-scan Spatial Resolution";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcrossScanSpatialResolution>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcrossScanSpatialResolution>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaximumAcrossScanDistortion>::s_keyword =
    Keyword::MaximumAcrossScanDistortion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumAcrossScanDistortion>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumAcrossScanDistortion>::s_element = 0x0049;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaximumAcrossScanDistortion>::s_name =
    "Maximum Across-scan Distortion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaximumAcrossScanDistortion>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaximumAcrossScanDistortion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MydriaticAgentConcentration>::s_keyword =
    Keyword::MydriaticAgentConcentration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentConcentration>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentConcentration>::s_element = 0x004E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MydriaticAgentConcentration>::s_name =
    "Mydriatic Agent Concentration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MydriaticAgentConcentration>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MydriaticAgentConcentration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IlluminationWaveLength>::s_keyword = Keyword::IlluminationWaveLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationWaveLength>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationWaveLength>::s_element = 0x0055;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IlluminationWaveLength>::s_name = "Illumination Wave Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IlluminationWaveLength>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IlluminationWaveLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IlluminationPower>::s_keyword = Keyword::IlluminationPower;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationPower>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationPower>::s_element = 0x0056;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IlluminationPower>::s_name = "Illumination Power";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IlluminationPower>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IlluminationPower>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IlluminationBandwidth>::s_keyword = Keyword::IlluminationBandwidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationBandwidth>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IlluminationBandwidth>::s_element = 0x0057;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IlluminationBandwidth>::s_name = "Illumination Bandwidth";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IlluminationBandwidth>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IlluminationBandwidth>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MydriaticAgentSequence>::s_keyword = Keyword::MydriaticAgentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MydriaticAgentSequence>::s_element = 0x0058;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MydriaticAgentSequence>::s_name = "Mydriatic Agent Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MydriaticAgentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MydriaticAgentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicAxialLength>::s_keyword = Keyword::OphthalmicAxialLength;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAxialLength>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAxialLength>::s_element = 0x1019;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicAxialLength>::s_name = "Ophthalmic Axial Length";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicAxialLength>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicAxialLength>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImplantName>::s_keyword = Keyword::ImplantName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImplantName>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImplantName>::s_element = 0x1095;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImplantName>::s_name = "Implant Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImplantName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImplantName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImplantPartNumber>::s_keyword = Keyword::ImplantPartNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImplantPartNumber>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImplantPartNumber>::s_element = 0x1097;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImplantPartNumber>::s_name = "Implant Part Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImplantPartNumber>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImplantPartNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicMappingDeviceType>::s_keyword =
    Keyword::OphthalmicMappingDeviceType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicMappingDeviceType>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicMappingDeviceType>::s_element = 0x1415;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicMappingDeviceType>::s_name =
    "Ophthalmic Mapping Device Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicMappingDeviceType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicMappingDeviceType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionMethodCodeSequence>::s_keyword =
    Keyword::AcquisitionMethodCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMethodCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMethodCodeSequence>::s_element = 0x1420;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionMethodCodeSequence>::s_name =
    "Acquisition Method Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionMethodCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionMethodCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_keyword =
    Keyword::AcquisitionMethodAlgorithmSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_element = 0x1423;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_name =
    "Acquisition Method Algorithm Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionMethodAlgorithmSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_keyword =
    Keyword::OphthalmicThicknessMapTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_element = 0x1436;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_name =
    "Ophthalmic Thickness Map Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_keyword =
    Keyword::OphthalmicThicknessMappingNormalsSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_element = 0x1443;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_name =
    "Ophthalmic Thickness Mapping Normals Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicThicknessMappingNormalsSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_keyword =
    Keyword::RetinalThicknessDefinitionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_element = 0x1445;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_name =
    "Retinal Thickness Definition Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RetinalThicknessDefinitionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_keyword =
    Keyword::PixelValueMappingToCodedConceptSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_element = 0x1450;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_name =
    "Pixel Value Mapping to Coded Concept Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelValueMappingToCodedConceptSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MappedPixelValue>::s_keyword = Keyword::MappedPixelValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappedPixelValue>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MappedPixelValue>::s_element = 0x1452;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MappedPixelValue>::s_name = "Mapped Pixel Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MappedPixelValue>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MappedPixelValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelValueMappingExplanation>::s_keyword =
    Keyword::PixelValueMappingExplanation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueMappingExplanation>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueMappingExplanation>::s_element = 0x1454;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelValueMappingExplanation>::s_name =
    "Pixel Value Mapping Explanation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelValueMappingExplanation>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelValueMappingExplanation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_keyword =
    Keyword::OphthalmicThicknessMapQualityThresholdSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_element = 0x1458;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_name =
    "Ophthalmic Thickness Map Quality Threshold Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AnatomicStructureReferencePoint>::s_keyword =
    Keyword::AnatomicStructureReferencePoint;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicStructureReferencePoint>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AnatomicStructureReferencePoint>::s_element = 0x1463;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AnatomicStructureReferencePoint>::s_name =
    "Anatomic Structure Reference Point";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AnatomicStructureReferencePoint>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AnatomicStructureReferencePoint>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegistrationToLocalizerSequence>::s_keyword =
    Keyword::RegistrationToLocalizerSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegistrationToLocalizerSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegistrationToLocalizerSequence>::s_element = 0x1465;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegistrationToLocalizerSequence>::s_name =
    "Registration to Localizer Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegistrationToLocalizerSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegistrationToLocalizerSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegisteredLocalizerUnits>::s_keyword = Keyword::RegisteredLocalizerUnits;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerUnits>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerUnits>::s_element = 0x1466;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegisteredLocalizerUnits>::s_name = "Registered Localizer Units";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegisteredLocalizerUnits>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegisteredLocalizerUnits>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_keyword =
    Keyword::RegisteredLocalizerTopLeftHandCorner;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_element = 0x1467;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_name =
    "Registered Localizer Top Left Hand Corner";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegisteredLocalizerTopLeftHandCorner>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_keyword =
    Keyword::RegisteredLocalizerBottomRightHandCorner;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_element = 0x1468;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_name =
    "Registered Localizer Bottom Right Hand Corner";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RegisteredLocalizerBottomRightHandCorner>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_keyword =
    Keyword::OphthalmicThicknessMapQualityRatingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_element = 0x1470;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_name =
    "Ophthalmic Thickness Map Quality Rating Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RelevantOPTAttributesSequence>::s_keyword =
    Keyword::RelevantOPTAttributesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelevantOPTAttributesSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RelevantOPTAttributesSequence>::s_element = 0x1472;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RelevantOPTAttributesSequence>::s_name =
    "Relevant OPT Attributes Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RelevantOPTAttributesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RelevantOPTAttributesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransformationMethodCodeSequence>::s_keyword =
    Keyword::TransformationMethodCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransformationMethodCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransformationMethodCodeSequence>::s_element = 0x1512;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransformationMethodCodeSequence>::s_name =
    "Transformation Method Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransformationMethodCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransformationMethodCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TransformationAlgorithmSequence>::s_keyword =
    Keyword::TransformationAlgorithmSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransformationAlgorithmSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TransformationAlgorithmSequence>::s_element = 0x1513;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TransformationAlgorithmSequence>::s_name =
    "Transformation Algorithm Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TransformationAlgorithmSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TransformationAlgorithmSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicAxialLengthMethod>::s_keyword =
    Keyword::OphthalmicAxialLengthMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAxialLengthMethod>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAxialLengthMethod>::s_element = 0x1515;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicAxialLengthMethod>::s_name =
    "Ophthalmic Axial Length Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicAxialLengthMethod>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicAxialLengthMethod>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicFOV>::s_keyword = Keyword::OphthalmicFOV;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicFOV>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicFOV>::s_element = 0x1517;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicFOV>::s_name = "Ophthalmic FOV";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicFOV>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicFOV>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_keyword =
    Keyword::TwoDimensionalToThreeDimensionalMapSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_element = 0x1518;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_name =
    "Two Dimensional to Three Dimensional Map Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_keyword =
    Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_element =
    0x1525;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_name =
    "Wide field Ophthalmic Photography Quality Rating Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_keyword =
    Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_group =
    0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_element =
    0x1526;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_name =
    "Wide field Ophthalmic Photography Quality Threshold Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_keyword =
    Keyword::XCoordinatesCenterPixelViewAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_element = 0x1528;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_name =
    "X Coordinates Center Pixel view Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XCoordinatesCenterPixelViewAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_keyword =
    Keyword::YCoordinatesCenterPixelViewAngle;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_element = 0x1529;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_name =
    "Y Coordinates Center Pixel view Angle";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::YCoordinatesCenterPixelViewAngle>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfMapPoints>::s_keyword = Keyword::NumberOfMapPoints;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfMapPoints>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfMapPoints>::s_element = 0x1530;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfMapPoints>::s_name = "Number of Map Points";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfMapPoints>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfMapPoints>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_keyword =
    Keyword::TwoDimensionalToThreeDimensionalMapData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_element = 0x1531;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_name =
    "Two Dimensional to Three Dimensional Map Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_vr = VR::OF;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TwoDimensionalToThreeDimensionalMapData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DerivationAlgorithmSequence>::s_keyword =
    Keyword::DerivationAlgorithmSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationAlgorithmSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DerivationAlgorithmSequence>::s_element = 0x1612;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DerivationAlgorithmSequence>::s_name =
    "Derivation Algorithm Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DerivationAlgorithmSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DerivationAlgorithmSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_keyword =
    Keyword::OphthalmicImageTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_element = 0x1615;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_name =
    "Ophthalmic Image Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicImageTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicImageTypeDescription>::s_keyword =
    Keyword::OphthalmicImageTypeDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageTypeDescription>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicImageTypeDescription>::s_element = 0x1616;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicImageTypeDescription>::s_name =
    "Ophthalmic Image Type Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicImageTypeDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicImageTypeDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScanPatternTypeCodeSequence>::s_keyword =
    Keyword::ScanPatternTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanPatternTypeCodeSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScanPatternTypeCodeSequence>::s_element = 0x1618;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScanPatternTypeCodeSequence>::s_name =
    "Scan Pattern Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScanPatternTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScanPatternTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_keyword =
    Keyword::ReferencedSurfaceMeshIdentificationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_element = 0x1620;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_name =
    "Referenced Surface Mesh Identification Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_keyword =
    Keyword::OphthalmicVolumetricPropertiesFlag;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_element = 0x1622;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_name =
    "Ophthalmic Volumetric Properties Flag";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicVolumetricPropertiesFlag>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_keyword =
    Keyword::OphthalmicAnatomicReferencePointXCoordinate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_element = 0x1624;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_name =
    "Ophthalmic Anatomic Reference Point X-Coordinate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_keyword =
    Keyword::OphthalmicAnatomicReferencePointYCoordinate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_element = 0x1626;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_name =
    "Ophthalmic Anatomic Reference Point Y-Coordinate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_keyword =
    Keyword::OphthalmicEnFaceImageQualityRatingSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_element = 0x1628;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_name =
    "Ophthalmic En Face Image Quality Rating Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::QualityThreshold>::s_keyword = Keyword::QualityThreshold;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityThreshold>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityThreshold>::s_element = 0x1630;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::QualityThreshold>::s_name = "Quality Threshold";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::QualityThreshold>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::QualityThreshold>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_keyword =
    Keyword::OCTBscanAnalysisAcquisitionParametersSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_element = 0x1640;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_name =
    "OCT B-scan Analysis Acquisition Parameters Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfBscansPerFrame>::s_keyword = Keyword::NumberOfBscansPerFrame;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfBscansPerFrame>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfBscansPerFrame>::s_element = 0x1642;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfBscansPerFrame>::s_name = "Number of B-scans Per Frame";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfBscansPerFrame>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfBscansPerFrame>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BscanSlabThickness>::s_keyword = Keyword::BscanSlabThickness;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanSlabThickness>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanSlabThickness>::s_element = 0x1643;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BscanSlabThickness>::s_name = "B-scan Slab Thickness";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BscanSlabThickness>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BscanSlabThickness>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceBetweenBscanSlabs>::s_keyword = Keyword::DistanceBetweenBscanSlabs;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceBetweenBscanSlabs>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceBetweenBscanSlabs>::s_element = 0x1644;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceBetweenBscanSlabs>::s_name = "Distance Between B-scan Slabs";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceBetweenBscanSlabs>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceBetweenBscanSlabs>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BscanCycleTime>::s_keyword = Keyword::BscanCycleTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanCycleTime>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanCycleTime>::s_element = 0x1645;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BscanCycleTime>::s_name = "B-scan Cycle Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BscanCycleTime>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BscanCycleTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BscanCycleTimeVector>::s_keyword = Keyword::BscanCycleTimeVector;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanCycleTimeVector>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanCycleTimeVector>::s_element = 0x1646;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BscanCycleTimeVector>::s_name = "B-scan Cycle Time Vector";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BscanCycleTimeVector>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BscanCycleTimeVector>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AscanRate>::s_keyword = Keyword::AscanRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AscanRate>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AscanRate>::s_element = 0x1649;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AscanRate>::s_name = "A-scan Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AscanRate>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AscanRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BscanRate>::s_keyword = Keyword::BscanRate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanRate>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BscanRate>::s_element = 0x1650;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BscanRate>::s_name = "B-scan Rate";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BscanRate>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BscanRate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SurfaceMeshZPixelOffset>::s_keyword = Keyword::SurfaceMeshZPixelOffset;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SurfaceMeshZPixelOffset>::s_group = 0x0022;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SurfaceMeshZPixelOffset>::s_element = 0x1658;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SurfaceMeshZPixelOffset>::s_name = "Surface Mesh Z-Pixel Offset";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SurfaceMeshZPixelOffset>::s_vr = VR::UL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SurfaceMeshZPixelOffset>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlgorithmSource>::s_keyword = Keyword::AlgorithmSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmSource>::s_group = 0x0024;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlgorithmSource>::s_element = 0x0202;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlgorithmSource>::s_name = "Algorithm Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlgorithmSource>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlgorithmSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataSetName>::s_keyword = Keyword::DataSetName;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetName>::s_group = 0x0024;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetName>::s_element = 0x0306;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataSetName>::s_name = "Data Set Name";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataSetName>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataSetName>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataSetVersion>::s_keyword = Keyword::DataSetVersion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetVersion>::s_group = 0x0024;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetVersion>::s_element = 0x0307;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataSetVersion>::s_name = "Data Set Version";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataSetVersion>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataSetVersion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataSetSource>::s_keyword = Keyword::DataSetSource;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetSource>::s_group = 0x0024;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetSource>::s_element = 0x0308;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataSetSource>::s_name = "Data Set Source";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataSetSource>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataSetSource>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataSetDescription>::s_keyword = Keyword::DataSetDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetDescription>::s_group = 0x0024;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataSetDescription>::s_element = 0x0309;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataSetDescription>::s_name = "Data Set Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataSetDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataSetDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SamplesPerPixel>::s_keyword = Keyword::SamplesPerPixel;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SamplesPerPixel>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SamplesPerPixel>::s_element = 0x0002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SamplesPerPixel>::s_name = "Samples per Pixel";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SamplesPerPixel>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SamplesPerPixel>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SamplesPerPixelUsed>::s_keyword = Keyword::SamplesPerPixelUsed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SamplesPerPixelUsed>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SamplesPerPixelUsed>::s_element = 0x0003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SamplesPerPixelUsed>::s_name = "Samples per Pixel Used";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SamplesPerPixelUsed>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SamplesPerPixelUsed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PhotometricInterpretation>::s_keyword = Keyword::PhotometricInterpretation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotometricInterpretation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PhotometricInterpretation>::s_element = 0x0004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PhotometricInterpretation>::s_name = "Photometric Interpretation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PhotometricInterpretation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PhotometricInterpretation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PlanarConfiguration>::s_keyword = Keyword::PlanarConfiguration;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanarConfiguration>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PlanarConfiguration>::s_element = 0x0006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PlanarConfiguration>::s_name = "Planar Configuration";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PlanarConfiguration>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PlanarConfiguration>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::NumberOfFrames>::s_keyword = Keyword::NumberOfFrames;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfFrames>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::NumberOfFrames>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::NumberOfFrames>::s_name = "Number of Frames";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::NumberOfFrames>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::NumberOfFrames>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameIncrementPointer>::s_keyword = Keyword::FrameIncrementPointer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameIncrementPointer>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameIncrementPointer>::s_element = 0x0009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameIncrementPointer>::s_name = "Frame Increment Pointer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameIncrementPointer>::s_vr = VR::AT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameIncrementPointer>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameDimensionPointer>::s_keyword = Keyword::FrameDimensionPointer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDimensionPointer>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameDimensionPointer>::s_element = 0x000A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameDimensionPointer>::s_name = "Frame Dimension Pointer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameDimensionPointer>::s_vr = VR::AT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameDimensionPointer>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Rows>::s_keyword = Keyword::Rows;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Rows>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Rows>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Rows>::s_name = "Rows";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Rows>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Rows>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::Columns>::s_keyword = Keyword::Columns;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Columns>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::Columns>::s_element = 0x0011;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::Columns>::s_name = "Columns";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::Columns>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::Columns>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UltrasoundColorDataPresent>::s_keyword = Keyword::UltrasoundColorDataPresent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UltrasoundColorDataPresent>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UltrasoundColorDataPresent>::s_element = 0x0014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UltrasoundColorDataPresent>::s_name =
    "Ultrasound Color Data Present";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UltrasoundColorDataPresent>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UltrasoundColorDataPresent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelSpacing>::s_keyword = Keyword::PixelSpacing;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacing>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacing>::s_element = 0x0030;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelSpacing>::s_name = "Pixel Spacing";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelSpacing>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelSpacing>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ZoomFactor>::s_keyword = Keyword::ZoomFactor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZoomFactor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZoomFactor>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ZoomFactor>::s_name = "Zoom Factor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ZoomFactor>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ZoomFactor>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ZoomCenter>::s_keyword = Keyword::ZoomCenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZoomCenter>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZoomCenter>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ZoomCenter>::s_name = "Zoom Center";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ZoomCenter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ZoomCenter>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelAspectRatio>::s_keyword = Keyword::PixelAspectRatio;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelAspectRatio>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelAspectRatio>::s_element = 0x0034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelAspectRatio>::s_name = "Pixel Aspect Ratio";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelAspectRatio>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelAspectRatio>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CorrectedImage>::s_keyword = Keyword::CorrectedImage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CorrectedImage>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CorrectedImage>::s_element = 0x0051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CorrectedImage>::s_name = "Corrected Image";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CorrectedImage>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CorrectedImage>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BitsAllocated>::s_keyword = Keyword::BitsAllocated;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsAllocated>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsAllocated>::s_element = 0x0100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BitsAllocated>::s_name = "Bits Allocated";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BitsAllocated>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BitsAllocated>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BitsStored>::s_keyword = Keyword::BitsStored;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsStored>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsStored>::s_element = 0x0101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BitsStored>::s_name = "Bits Stored";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BitsStored>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BitsStored>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::HighBit>::s_keyword = Keyword::HighBit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HighBit>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HighBit>::s_element = 0x0102;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::HighBit>::s_name = "High Bit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::HighBit>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::HighBit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelRepresentation>::s_keyword = Keyword::PixelRepresentation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelRepresentation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelRepresentation>::s_element = 0x0103;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelRepresentation>::s_name = "Pixel Representation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelRepresentation>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelRepresentation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SmallestImagePixelValue>::s_keyword = Keyword::SmallestImagePixelValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmallestImagePixelValue>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmallestImagePixelValue>::s_element = 0x0106;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SmallestImagePixelValue>::s_name = "Smallest Image Pixel Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SmallestImagePixelValue>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SmallestImagePixelValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LargestImagePixelValue>::s_keyword = Keyword::LargestImagePixelValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LargestImagePixelValue>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LargestImagePixelValue>::s_element = 0x0107;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LargestImagePixelValue>::s_name = "Largest Image Pixel Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LargestImagePixelValue>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LargestImagePixelValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SmallestPixelValueInSeries>::s_keyword = Keyword::SmallestPixelValueInSeries;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmallestPixelValueInSeries>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SmallestPixelValueInSeries>::s_element = 0x0108;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SmallestPixelValueInSeries>::s_name =
    "Smallest Pixel Value in Series";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SmallestPixelValueInSeries>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SmallestPixelValueInSeries>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LargestPixelValueInSeries>::s_keyword = Keyword::LargestPixelValueInSeries;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LargestPixelValueInSeries>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LargestPixelValueInSeries>::s_element = 0x0109;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LargestPixelValueInSeries>::s_name = "Largest Pixel Value in Series";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LargestPixelValueInSeries>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LargestPixelValueInSeries>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelPaddingValue>::s_keyword = Keyword::PixelPaddingValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPaddingValue>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPaddingValue>::s_element = 0x0120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelPaddingValue>::s_name = "Pixel Padding Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelPaddingValue>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelPaddingValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelPaddingRangeLimit>::s_keyword = Keyword::PixelPaddingRangeLimit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPaddingRangeLimit>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelPaddingRangeLimit>::s_element = 0x0121;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelPaddingRangeLimit>::s_name = "Pixel Padding Range Limit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelPaddingRangeLimit>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelPaddingRangeLimit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FloatPixelPaddingValue>::s_keyword = Keyword::FloatPixelPaddingValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FloatPixelPaddingValue>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FloatPixelPaddingValue>::s_element = 0x0122;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FloatPixelPaddingValue>::s_name = "Float Pixel Padding Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FloatPixelPaddingValue>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FloatPixelPaddingValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_keyword =
    Keyword::DoubleFloatPixelPaddingValue;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_element = 0x0123;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_name =
    "Double Float Pixel Padding Value";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DoubleFloatPixelPaddingValue>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_keyword =
    Keyword::FloatPixelPaddingRangeLimit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_element = 0x0124;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_name =
    "Float Pixel Padding Range Limit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FloatPixelPaddingRangeLimit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_keyword =
    Keyword::DoubleFloatPixelPaddingRangeLimit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_element = 0x0125;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_name =
    "Double Float Pixel Padding Range Limit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DoubleFloatPixelPaddingRangeLimit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::QualityControlImage>::s_keyword = Keyword::QualityControlImage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityControlImage>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::QualityControlImage>::s_element = 0x0300;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::QualityControlImage>::s_name = "Quality Control Image";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::QualityControlImage>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::QualityControlImage>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BurnedInAnnotation>::s_keyword = Keyword::BurnedInAnnotation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BurnedInAnnotation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BurnedInAnnotation>::s_element = 0x0301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BurnedInAnnotation>::s_name = "Burned In Annotation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BurnedInAnnotation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BurnedInAnnotation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RecognizableVisualFeatures>::s_keyword = Keyword::RecognizableVisualFeatures;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecognizableVisualFeatures>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecognizableVisualFeatures>::s_element = 0x0302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RecognizableVisualFeatures>::s_name = "Recognizable Visual Features";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RecognizableVisualFeatures>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RecognizableVisualFeatures>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LongitudinalTemporalInformationModified>::s_keyword =
    Keyword::LongitudinalTemporalInformationModified;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalInformationModified>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LongitudinalTemporalInformationModified>::s_element = 0x0303;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LongitudinalTemporalInformationModified>::s_name =
    "Longitudinal Temporal Information Modified";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LongitudinalTemporalInformationModified>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LongitudinalTemporalInformationModified>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_keyword =
    Keyword::ReferencedColorPaletteInstanceUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_element = 0x0304;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_name =
    "Referenced Color Palette Instance UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReferencedColorPaletteInstanceUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelSpacingCalibrationType>::s_keyword =
    Keyword::PixelSpacingCalibrationType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacingCalibrationType>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacingCalibrationType>::s_element = 0x0A02;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelSpacingCalibrationType>::s_name =
    "Pixel Spacing Calibration Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelSpacingCalibrationType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelSpacingCalibrationType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelSpacingCalibrationDescription>::s_keyword =
    Keyword::PixelSpacingCalibrationDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacingCalibrationDescription>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelSpacingCalibrationDescription>::s_element = 0x0A04;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelSpacingCalibrationDescription>::s_name =
    "Pixel Spacing Calibration Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelSpacingCalibrationDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelSpacingCalibrationDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelIntensityRelationship>::s_keyword = Keyword::PixelIntensityRelationship;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationship>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationship>::s_element = 0x1040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelIntensityRelationship>::s_name = "Pixel Intensity Relationship";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelIntensityRelationship>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelIntensityRelationship>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelIntensityRelationshipSign>::s_keyword =
    Keyword::PixelIntensityRelationshipSign;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationshipSign>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationshipSign>::s_element = 0x1041;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelIntensityRelationshipSign>::s_name =
    "Pixel Intensity Relationship Sign";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelIntensityRelationshipSign>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelIntensityRelationshipSign>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WindowCenter>::s_keyword = Keyword::WindowCenter;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowCenter>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowCenter>::s_element = 0x1050;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WindowCenter>::s_name = "Window Center";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WindowCenter>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WindowCenter>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WindowWidth>::s_keyword = Keyword::WindowWidth;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowWidth>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowWidth>::s_element = 0x1051;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WindowWidth>::s_name = "Window Width";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WindowWidth>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WindowWidth>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RescaleIntercept>::s_keyword = Keyword::RescaleIntercept;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleIntercept>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleIntercept>::s_element = 0x1052;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RescaleIntercept>::s_name = "Rescale Intercept";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RescaleIntercept>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RescaleIntercept>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RescaleSlope>::s_keyword = Keyword::RescaleSlope;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleSlope>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleSlope>::s_element = 0x1053;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RescaleSlope>::s_name = "Rescale Slope";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RescaleSlope>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RescaleSlope>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RescaleType>::s_keyword = Keyword::RescaleType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleType>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RescaleType>::s_element = 0x1054;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RescaleType>::s_name = "Rescale Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RescaleType>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RescaleType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WindowCenterWidthExplanation>::s_keyword =
    Keyword::WindowCenterWidthExplanation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowCenterWidthExplanation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WindowCenterWidthExplanation>::s_element = 0x1055;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WindowCenterWidthExplanation>::s_name =
    "Window Center & Width Explanation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WindowCenterWidthExplanation>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WindowCenterWidthExplanation>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VOILUTFunction>::s_keyword = Keyword::VOILUTFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VOILUTFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VOILUTFunction>::s_element = 0x1056;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VOILUTFunction>::s_name = "VOI LUT Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VOILUTFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VOILUTFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RecommendedViewingMode>::s_keyword = Keyword::RecommendedViewingMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedViewingMode>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RecommendedViewingMode>::s_element = 0x1090;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RecommendedViewingMode>::s_name = "Recommended Viewing Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RecommendedViewingMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RecommendedViewingMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_keyword =
    Keyword::RedPaletteColorLookupTableDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_element = 0x1101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_name =
    "Red Palette Color Lookup Table Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RedPaletteColorLookupTableDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_keyword =
    Keyword::GreenPaletteColorLookupTableDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_element = 0x1102;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_name =
    "Green Palette Color Lookup Table Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GreenPaletteColorLookupTableDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_keyword =
    Keyword::BluePaletteColorLookupTableDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_element = 0x1103;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_name =
    "Blue Palette Color Lookup Table Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BluePaletteColorLookupTableDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_keyword =
    Keyword::AlphaPaletteColorLookupTableDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_element = 0x1104;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_name =
    "Alpha Palette Color Lookup Table Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlphaPaletteColorLookupTableDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PaletteColorLookupTableUID>::s_keyword = Keyword::PaletteColorLookupTableUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PaletteColorLookupTableUID>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PaletteColorLookupTableUID>::s_element = 0x1199;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PaletteColorLookupTableUID>::s_name =
    "Palette Color Lookup Table UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PaletteColorLookupTableUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PaletteColorLookupTableUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RedPaletteColorLookupTableData>::s_keyword =
    Keyword::RedPaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RedPaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RedPaletteColorLookupTableData>::s_element = 0x1201;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RedPaletteColorLookupTableData>::s_name =
    "Red Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RedPaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RedPaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GreenPaletteColorLookupTableData>::s_keyword =
    Keyword::GreenPaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GreenPaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GreenPaletteColorLookupTableData>::s_element = 0x1202;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GreenPaletteColorLookupTableData>::s_name =
    "Green Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GreenPaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GreenPaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BluePaletteColorLookupTableData>::s_keyword =
    Keyword::BluePaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BluePaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BluePaletteColorLookupTableData>::s_element = 0x1203;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BluePaletteColorLookupTableData>::s_name =
    "Blue Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BluePaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BluePaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_keyword =
    Keyword::AlphaPaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_element = 0x1204;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_name =
    "Alpha Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlphaPaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_keyword =
    Keyword::SegmentedRedPaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_element = 0x1221;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_name =
    "Segmented Red Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SegmentedRedPaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_keyword =
    Keyword::SegmentedGreenPaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_element = 0x1222;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_name =
    "Segmented Green Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SegmentedGreenPaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_keyword =
    Keyword::SegmentedBluePaletteColorLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_element = 0x1223;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_name =
    "Segmented Blue Palette Color Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SegmentedBluePaletteColorLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StoredValueColorRangeSequence>::s_keyword =
    Keyword::StoredValueColorRangeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StoredValueColorRangeSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StoredValueColorRangeSequence>::s_element = 0x1230;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StoredValueColorRangeSequence>::s_name =
    "Stored Value Color Range Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StoredValueColorRangeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StoredValueColorRangeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MinimumStoredValueMapped>::s_keyword = Keyword::MinimumStoredValueMapped;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MinimumStoredValueMapped>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MinimumStoredValueMapped>::s_element = 0x1231;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MinimumStoredValueMapped>::s_name = "Minimum Stored Value Mapped";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MinimumStoredValueMapped>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MinimumStoredValueMapped>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaximumStoredValueMapped>::s_keyword = Keyword::MaximumStoredValueMapped;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumStoredValueMapped>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaximumStoredValueMapped>::s_element = 0x1232;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaximumStoredValueMapped>::s_name = "Maximum Stored Value Mapped";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaximumStoredValueMapped>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaximumStoredValueMapped>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BreastImplantPresent>::s_keyword = Keyword::BreastImplantPresent;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastImplantPresent>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BreastImplantPresent>::s_element = 0x1300;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BreastImplantPresent>::s_name = "Breast Implant Present";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BreastImplantPresent>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BreastImplantPresent>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PartialView>::s_keyword = Keyword::PartialView;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialView>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialView>::s_element = 0x1350;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PartialView>::s_name = "Partial view";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PartialView>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PartialView>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PartialViewDescription>::s_keyword = Keyword::PartialViewDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialViewDescription>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialViewDescription>::s_element = 0x1351;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PartialViewDescription>::s_name = "Partial view Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PartialViewDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PartialViewDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PartialViewCodeSequence>::s_keyword = Keyword::PartialViewCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialViewCodeSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PartialViewCodeSequence>::s_element = 0x1352;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PartialViewCodeSequence>::s_name = "Partial view Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PartialViewCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PartialViewCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpatialLocationsPreserved>::s_keyword = Keyword::SpatialLocationsPreserved;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialLocationsPreserved>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpatialLocationsPreserved>::s_element = 0x135A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpatialLocationsPreserved>::s_name = "Spatial Locations Preserved";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpatialLocationsPreserved>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpatialLocationsPreserved>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataFrameAssignmentSequence>::s_keyword =
    Keyword::DataFrameAssignmentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataFrameAssignmentSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataFrameAssignmentSequence>::s_element = 0x1401;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataFrameAssignmentSequence>::s_name =
    "Data Frame Assignment Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataFrameAssignmentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataFrameAssignmentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataPathAssignment>::s_keyword = Keyword::DataPathAssignment;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataPathAssignment>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataPathAssignment>::s_element = 0x1402;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataPathAssignment>::s_name = "Data Path Assignment";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataPathAssignment>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataPathAssignment>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BitsMappedToColorLookupTable>::s_keyword =
    Keyword::BitsMappedToColorLookupTable;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsMappedToColorLookupTable>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BitsMappedToColorLookupTable>::s_element = 0x1403;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BitsMappedToColorLookupTable>::s_name =
    "Bits Mapped to Color Lookup Table";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BitsMappedToColorLookupTable>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BitsMappedToColorLookupTable>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLUT1Sequence>::s_keyword = Keyword::BlendingLUT1Sequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT1Sequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT1Sequence>::s_element = 0x1404;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLUT1Sequence>::s_name = "Blending LUT 1 Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLUT1Sequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLUT1Sequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLUT1TransferFunction>::s_keyword =
    Keyword::BlendingLUT1TransferFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT1TransferFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT1TransferFunction>::s_element = 0x1405;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLUT1TransferFunction>::s_name =
    "Blending LUT 1 Transfer Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLUT1TransferFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLUT1TransferFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingWeightConstant>::s_keyword = Keyword::BlendingWeightConstant;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingWeightConstant>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingWeightConstant>::s_element = 0x1406;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingWeightConstant>::s_name = "Blending Weight Constant";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingWeightConstant>::s_vr = VR::FD;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingWeightConstant>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLookupTableDescriptor>::s_keyword =
    Keyword::BlendingLookupTableDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLookupTableDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLookupTableDescriptor>::s_element = 0x1407;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLookupTableDescriptor>::s_name =
    "Blending Lookup Table Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLookupTableDescriptor>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLookupTableDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLookupTableData>::s_keyword = Keyword::BlendingLookupTableData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLookupTableData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLookupTableData>::s_element = 0x1408;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLookupTableData>::s_name = "Blending Lookup Table Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLookupTableData>::s_vr = VR::OW;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLookupTableData>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_keyword =
    Keyword::EnhancedPaletteColorLookupTableSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_element = 0x140B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_name =
    "Enhanced Palette Color Lookup Table Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EnhancedPaletteColorLookupTableSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLUT2Sequence>::s_keyword = Keyword::BlendingLUT2Sequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT2Sequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT2Sequence>::s_element = 0x140C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLUT2Sequence>::s_name = "Blending LUT 2 Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLUT2Sequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLUT2Sequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::BlendingLUT2TransferFunction>::s_keyword =
    Keyword::BlendingLUT2TransferFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT2TransferFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::BlendingLUT2TransferFunction>::s_element = 0x140D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::BlendingLUT2TransferFunction>::s_name =
    "Blending LUT 2 Transfer Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::BlendingLUT2TransferFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::BlendingLUT2TransferFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DataPathID>::s_keyword = Keyword::DataPathID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataPathID>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DataPathID>::s_element = 0x140E;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DataPathID>::s_name = "Data Path ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DataPathID>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DataPathID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RGBLUTTransferFunction>::s_keyword = Keyword::RGBLUTTransferFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RGBLUTTransferFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RGBLUTTransferFunction>::s_element = 0x140F;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RGBLUTTransferFunction>::s_name = "RGB LUT Transfer Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RGBLUTTransferFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RGBLUTTransferFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlphaLUTTransferFunction>::s_keyword = Keyword::AlphaLUTTransferFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaLUTTransferFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlphaLUTTransferFunction>::s_element = 0x1410;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlphaLUTTransferFunction>::s_name = "Alpha LUT Transfer Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlphaLUTTransferFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlphaLUTTransferFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ICCProfile>::s_keyword = Keyword::ICCProfile;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ICCProfile>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ICCProfile>::s_element = 0x2000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ICCProfile>::s_name = "ICC Profile";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ICCProfile>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ICCProfile>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ColorSpace>::s_keyword = Keyword::ColorSpace;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorSpace>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ColorSpace>::s_element = 0x2002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ColorSpace>::s_name = "Color Space";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ColorSpace>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ColorSpace>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LossyImageCompression>::s_keyword = Keyword::LossyImageCompression;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompression>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompression>::s_element = 0x2110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LossyImageCompression>::s_name = "Lossy Image Compression";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LossyImageCompression>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LossyImageCompression>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LossyImageCompressionRatio>::s_keyword = Keyword::LossyImageCompressionRatio;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompressionRatio>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompressionRatio>::s_element = 0x2112;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LossyImageCompressionRatio>::s_name =
    "Lossy Image Compression Ratio";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LossyImageCompressionRatio>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LossyImageCompressionRatio>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LossyImageCompressionMethod>::s_keyword =
    Keyword::LossyImageCompressionMethod;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompressionMethod>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LossyImageCompressionMethod>::s_element = 0x2114;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LossyImageCompressionMethod>::s_name =
    "Lossy Image Compression Method";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LossyImageCompressionMethod>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LossyImageCompressionMethod>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ModalityLUTSequence>::s_keyword = Keyword::ModalityLUTSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ModalityLUTSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ModalityLUTSequence>::s_element = 0x3000;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ModalityLUTSequence>::s_name = "Modality LUT Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ModalityLUTSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ModalityLUTSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LUTDescriptor>::s_keyword = Keyword::LUTDescriptor;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTDescriptor>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTDescriptor>::s_element = 0x3002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LUTDescriptor>::s_name = "LUT Descriptor";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LUTDescriptor>::s_vr = VR::SS_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LUTDescriptor>::s_vm = VM::MIN_3_MAX_3;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LUTExplanation>::s_keyword = Keyword::LUTExplanation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTExplanation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTExplanation>::s_element = 0x3003;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LUTExplanation>::s_name = "LUT Explanation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LUTExplanation>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LUTExplanation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ModalityLUTType>::s_keyword = Keyword::ModalityLUTType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ModalityLUTType>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ModalityLUTType>::s_element = 0x3004;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ModalityLUTType>::s_name = "Modality LUT Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ModalityLUTType>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ModalityLUTType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LUTData>::s_keyword = Keyword::LUTData;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTData>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTData>::s_element = 0x3006;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LUTData>::s_name = "LUT Data";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LUTData>::s_vr = VR::OW_US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LUTData>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::VOILUTSequence>::s_keyword = Keyword::VOILUTSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VOILUTSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::VOILUTSequence>::s_element = 0x3010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::VOILUTSequence>::s_name = "VOI LUT Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::VOILUTSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::VOILUTSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RepresentativeFrameNumber>::s_keyword = Keyword::RepresentativeFrameNumber;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RepresentativeFrameNumber>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RepresentativeFrameNumber>::s_element = 0x6010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RepresentativeFrameNumber>::s_name = "Representative Frame Number";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RepresentativeFrameNumber>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RepresentativeFrameNumber>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameNumbersOfInterest>::s_keyword = Keyword::FrameNumbersOfInterest;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameNumbersOfInterest>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameNumbersOfInterest>::s_element = 0x6020;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameNumbersOfInterest>::s_name = "Frame Numbers of Interest (FOI)";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameNumbersOfInterest>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameNumbersOfInterest>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameOfInterestDescription>::s_keyword = Keyword::FrameOfInterestDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfInterestDescription>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfInterestDescription>::s_element = 0x6022;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameOfInterestDescription>::s_name =
    "Frame of Interest Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameOfInterestDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameOfInterestDescription>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameOfInterestType>::s_keyword = Keyword::FrameOfInterestType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfInterestType>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOfInterestType>::s_element = 0x6023;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameOfInterestType>::s_name = "Frame of Interest Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameOfInterestType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameOfInterestType>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RWavePointer>::s_keyword = Keyword::RWavePointer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RWavePointer>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RWavePointer>::s_element = 0x6040;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RWavePointer>::s_name = "R Wave Pointer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RWavePointer>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RWavePointer>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskSubtractionSequence>::s_keyword = Keyword::MaskSubtractionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSubtractionSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSubtractionSequence>::s_element = 0x6100;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskSubtractionSequence>::s_name = "Mask Subtraction Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskSubtractionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskSubtractionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskOperation>::s_keyword = Keyword::MaskOperation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskOperation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskOperation>::s_element = 0x6101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskOperation>::s_name = "Mask Operation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskOperation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskOperation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ApplicableFrameRange>::s_keyword = Keyword::ApplicableFrameRange;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableFrameRange>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ApplicableFrameRange>::s_element = 0x6102;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ApplicableFrameRange>::s_name = "Applicable Frame Range";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ApplicableFrameRange>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ApplicableFrameRange>::s_vm = VM::MIN_2_MAX_2N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskFrameNumbers>::s_keyword = Keyword::MaskFrameNumbers;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskFrameNumbers>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskFrameNumbers>::s_element = 0x6110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskFrameNumbers>::s_name = "Mask Frame Numbers";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskFrameNumbers>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskFrameNumbers>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContrastFrameAveraging>::s_keyword = Keyword::ContrastFrameAveraging;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFrameAveraging>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContrastFrameAveraging>::s_element = 0x6112;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContrastFrameAveraging>::s_name = "Contrast Frame Averaging";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContrastFrameAveraging>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContrastFrameAveraging>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskSubPixelShift>::s_keyword = Keyword::MaskSubPixelShift;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSubPixelShift>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSubPixelShift>::s_element = 0x6114;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskSubPixelShift>::s_name = "Mask Sub-pixel Shift";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskSubPixelShift>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskSubPixelShift>::s_vm = VM::MIN_2_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TIDOffset>::s_keyword = Keyword::TIDOffset;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TIDOffset>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TIDOffset>::s_element = 0x6120;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TIDOffset>::s_name = "TID Offset";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TIDOffset>::s_vr = VR::SS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TIDOffset>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskOperationExplanation>::s_keyword = Keyword::MaskOperationExplanation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskOperationExplanation>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskOperationExplanation>::s_element = 0x6190;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskOperationExplanation>::s_name = "Mask Operation Explanation";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskOperationExplanation>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskOperationExplanation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelDataProviderURL>::s_keyword = Keyword::PixelDataProviderURL;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataProviderURL>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelDataProviderURL>::s_element = 0x7FE0;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelDataProviderURL>::s_name = "Pixel Data Provider URL";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelDataProviderURL>::s_vr = VR::UR;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelDataProviderURL>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelMeasuresSequence>::s_keyword = Keyword::PixelMeasuresSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelMeasuresSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelMeasuresSequence>::s_element = 0x9110;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelMeasuresSequence>::s_name = "Pixel Measures Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelMeasuresSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelMeasuresSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameVOILUTSequence>::s_keyword = Keyword::FrameVOILUTSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameVOILUTSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameVOILUTSequence>::s_element = 0x9132;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameVOILUTSequence>::s_name = "Frame VOI LUT Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameVOILUTSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameVOILUTSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelValueTransformationSequence>::s_keyword =
    Keyword::PixelValueTransformationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueTransformationSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelValueTransformationSequence>::s_element = 0x9145;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelValueTransformationSequence>::s_name =
    "Pixel Value Transformation Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelValueTransformationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelValueTransformationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DisplayFilterPercentage>::s_keyword = Keyword::DisplayFilterPercentage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayFilterPercentage>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DisplayFilterPercentage>::s_element = 0x9411;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DisplayFilterPercentage>::s_name = "Display filter Percentage";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DisplayFilterPercentage>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DisplayFilterPercentage>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FramePixelShiftSequence>::s_keyword = Keyword::FramePixelShiftSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePixelShiftSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePixelShiftSequence>::s_element = 0x9415;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FramePixelShiftSequence>::s_name = "Frame Pixel Shift Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FramePixelShiftSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FramePixelShiftSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SubtractionItemID>::s_keyword = Keyword::SubtractionItemID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubtractionItemID>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SubtractionItemID>::s_element = 0x9416;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SubtractionItemID>::s_name = "Subtraction Item ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SubtractionItemID>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SubtractionItemID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_keyword =
    Keyword::PixelIntensityRelationshipLUTSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_element = 0x9422;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_name =
    "Pixel Intensity Relationship LUT Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PixelIntensityRelationshipLUTSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FramePixelDataPropertiesSequence>::s_keyword =
    Keyword::FramePixelDataPropertiesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePixelDataPropertiesSequence>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FramePixelDataPropertiesSequence>::s_element = 0x9443;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FramePixelDataPropertiesSequence>::s_name =
    "Frame Pixel Data Properties Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FramePixelDataPropertiesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FramePixelDataPropertiesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeometricalProperties>::s_keyword = Keyword::GeometricalProperties;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometricalProperties>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometricalProperties>::s_element = 0x9444;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeometricalProperties>::s_name = "Geometrical Properties";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeometricalProperties>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeometricalProperties>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::GeometricMaximumDistortion>::s_keyword = Keyword::GeometricMaximumDistortion;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometricMaximumDistortion>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::GeometricMaximumDistortion>::s_element = 0x9445;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::GeometricMaximumDistortion>::s_name = "Geometric Maximum Distortion";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::GeometricMaximumDistortion>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::GeometricMaximumDistortion>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageProcessingApplied>::s_keyword = Keyword::ImageProcessingApplied;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageProcessingApplied>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageProcessingApplied>::s_element = 0x9446;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageProcessingApplied>::s_name = "Image Processing Applied";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageProcessingApplied>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageProcessingApplied>::s_vm = VM::MIN_1_MAX_N;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskSelectionMode>::s_keyword = Keyword::MaskSelectionMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSelectionMode>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskSelectionMode>::s_element = 0x9454;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskSelectionMode>::s_name = "Mask Selection Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskSelectionMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskSelectionMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LUTFunction>::s_keyword = Keyword::LUTFunction;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTFunction>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LUTFunction>::s_element = 0x9474;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LUTFunction>::s_name = "LUT Function";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LUTFunction>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LUTFunction>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MaskVisibilityPercentage>::s_keyword = Keyword::MaskVisibilityPercentage;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskVisibilityPercentage>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MaskVisibilityPercentage>::s_element = 0x9478;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MaskVisibilityPercentage>::s_name = "Mask Visibility Percentage";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MaskVisibilityPercentage>::s_vr = VR::FL;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MaskVisibilityPercentage>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_keyword =
    Keyword::ImageToEquipmentMappingMatrix;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_element = 0x9520;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_name =
    "Image to Equipment Mapping Matrix";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageToEquipmentMappingMatrix>::s_vm = VM::MIN_16_MAX_16;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_keyword =
    Keyword::EquipmentCoordinateSystemIdentification;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_group = 0x0028;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_element = 0x9537;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_name =
    "Equipment Coordinate System Identification";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EquipmentCoordinateSystemIdentification>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestingService>::s_keyword = Keyword::RequestingService;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestingService>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestingService>::s_element = 0x1033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestingService>::s_name = "Requesting Service";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestingService>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestingService>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestingServiceCodeSequence>::s_keyword =
    Keyword::RequestingServiceCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestingServiceCodeSequence>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestingServiceCodeSequence>::s_element = 0x1034;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestingServiceCodeSequence>::s_name =
    "Requesting Service Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestingServiceCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestingServiceCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestedProcedureDescription>::s_keyword =
    Keyword::RequestedProcedureDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureDescription>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureDescription>::s_element = 0x1060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestedProcedureDescription>::s_name =
    "Requested Procedure Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestedProcedureDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestedProcedureDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestedProcedureCodeSequence>::s_keyword =
    Keyword::RequestedProcedureCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureCodeSequence>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureCodeSequence>::s_element = 0x1064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestedProcedureCodeSequence>::s_name =
    "Requested Procedure Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestedProcedureCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestedProcedureCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReasonForVisit>::s_keyword = Keyword::ReasonForVisit;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForVisit>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForVisit>::s_element = 0x1066;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReasonForVisit>::s_name = "Reason for Visit";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReasonForVisit>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReasonForVisit>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReasonForVisitCodeSequence>::s_keyword = Keyword::ReasonForVisitCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForVisitCodeSequence>::s_group = 0x0032;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForVisitCodeSequence>::s_element = 0x1067;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReasonForVisitCodeSequence>::s_name =
    "Reason for Visit Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReasonForVisitCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReasonForVisitCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameOriginTimestamp>::s_keyword = Keyword::FrameOriginTimestamp;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOriginTimestamp>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameOriginTimestamp>::s_element = 0x0007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameOriginTimestamp>::s_name = "Frame Origin Timestamp";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameOriginTimestamp>::s_vr = VR::OB;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameOriginTimestamp>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IncludesImagingSubject>::s_keyword = Keyword::IncludesImagingSubject;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IncludesImagingSubject>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IncludesImagingSubject>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IncludesImagingSubject>::s_name = "Includes Imaging Subject";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IncludesImagingSubject>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IncludesImagingSubject>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::FrameUsefulnessGroupSequence>::s_keyword =
    Keyword::FrameUsefulnessGroupSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameUsefulnessGroupSequence>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::FrameUsefulnessGroupSequence>::s_element = 0x0009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::FrameUsefulnessGroupSequence>::s_name =
    "Frame Usefulness Group Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::FrameUsefulnessGroupSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::FrameUsefulnessGroupSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CameraPositionGroupSequence>::s_keyword =
    Keyword::CameraPositionGroupSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraPositionGroupSequence>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CameraPositionGroupSequence>::s_element = 0x000B;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CameraPositionGroupSequence>::s_name =
    "Camera Position Group Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CameraPositionGroupSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CameraPositionGroupSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IncludesInformation>::s_keyword = Keyword::IncludesInformation;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IncludesInformation>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IncludesInformation>::s_element = 0x000C;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IncludesInformation>::s_name = "Includes Information";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IncludesInformation>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IncludesInformation>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::TimeOfFrameGroupSequence>::s_keyword = Keyword::TimeOfFrameGroupSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFrameGroupSequence>::s_group = 0x0034;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::TimeOfFrameGroupSequence>::s_element = 0x000D;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::TimeOfFrameGroupSequence>::s_name = "Time of Frame Group Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::TimeOfFrameGroupSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::TimeOfFrameGroupSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AdmissionID>::s_keyword = Keyword::AdmissionID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmissionID>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AdmissionID>::s_element = 0x0010;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AdmissionID>::s_name = "Admission ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AdmissionID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AdmissionID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_keyword =
    Keyword::IssuerOfAdmissionIDSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_element = 0x0014;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_name =
    "Issuer of Admission ID Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfAdmissionIDSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ServiceEpisodeID>::s_keyword = Keyword::ServiceEpisodeID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ServiceEpisodeID>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ServiceEpisodeID>::s_element = 0x0060;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ServiceEpisodeID>::s_name = "Service Episode ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ServiceEpisodeID>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ServiceEpisodeID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ServiceEpisodeDescription>::s_keyword = Keyword::ServiceEpisodeDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ServiceEpisodeDescription>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ServiceEpisodeDescription>::s_element = 0x0062;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ServiceEpisodeDescription>::s_name = "Service Episode Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ServiceEpisodeDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ServiceEpisodeDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_keyword =
    Keyword::IssuerOfServiceEpisodeIDSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_element = 0x0064;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_name =
    "Issuer of Service Episode ID Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfServiceEpisodeIDSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PatientState>::s_keyword = Keyword::PatientState;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientState>::s_group = 0x0038;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PatientState>::s_element = 0x0500;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PatientState>::s_name = "Patient State";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PatientState>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PatientState>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ChannelSourceSequence>::s_keyword = Keyword::ChannelSourceSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelSourceSequence>::s_group = 0x003A;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelSourceSequence>::s_element = 0x0208;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ChannelSourceSequence>::s_name = "Channel Source Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ChannelSourceSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ChannelSourceSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_keyword =
    Keyword::MultiplexedAudioChannelsDescriptionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_group = 0x003A;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_element = 0x0300;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_name =
    "Multiplexed Audio Channels Description Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ChannelIdentificationCode>::s_keyword = Keyword::ChannelIdentificationCode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelIdentificationCode>::s_group = 0x003A;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelIdentificationCode>::s_element = 0x0301;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ChannelIdentificationCode>::s_name = "Channel Identification Code";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ChannelIdentificationCode>::s_vr = VR::IS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ChannelIdentificationCode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ChannelMode>::s_keyword = Keyword::ChannelMode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelMode>::s_group = 0x003A;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ChannelMode>::s_element = 0x0302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ChannelMode>::s_name = "Channel Mode";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ChannelMode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ChannelMode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScheduledProcedureStepDescription>::s_keyword =
    Keyword::ScheduledProcedureStepDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProcedureStepDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProcedureStepDescription>::s_element = 0x0007;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScheduledProcedureStepDescription>::s_name =
    "Scheduled Procedure Step Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScheduledProcedureStepDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScheduledProcedureStepDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScheduledProtocolCodeSequence>::s_keyword =
    Keyword::ScheduledProtocolCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProtocolCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProtocolCodeSequence>::s_element = 0x0008;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScheduledProtocolCodeSequence>::s_name =
    "Scheduled Protocol Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScheduledProtocolCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScheduledProtocolCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ScheduledProcedureStepID>::s_keyword = Keyword::ScheduledProcedureStepID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProcedureStepID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ScheduledProcedureStepID>::s_element = 0x0009;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ScheduledProcedureStepID>::s_name = "Scheduled Procedure Step ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ScheduledProcedureStepID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ScheduledProcedureStepID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::StageCodeSequence>::s_keyword = Keyword::StageCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::StageCodeSequence>::s_element = 0x000A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::StageCodeSequence>::s_name = "Stage Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::StageCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::StageCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OrderPlacerIdentifierSequence>::s_keyword =
    Keyword::OrderPlacerIdentifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrderPlacerIdentifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrderPlacerIdentifierSequence>::s_element = 0x0026;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OrderPlacerIdentifierSequence>::s_name =
    "Order Placer Identifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OrderPlacerIdentifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OrderPlacerIdentifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OrderFillerIdentifierSequence>::s_keyword =
    Keyword::OrderFillerIdentifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrderFillerIdentifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrderFillerIdentifierSequence>::s_element = 0x0027;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OrderFillerIdentifierSequence>::s_name =
    "Order Filler Identifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OrderFillerIdentifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OrderFillerIdentifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::LocalNamespaceEntityID>::s_keyword = Keyword::LocalNamespaceEntityID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LocalNamespaceEntityID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::LocalNamespaceEntityID>::s_element = 0x0031;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::LocalNamespaceEntityID>::s_name = "Local Namespace Entity ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::LocalNamespaceEntityID>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::LocalNamespaceEntityID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UniversalEntityID>::s_keyword = Keyword::UniversalEntityID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniversalEntityID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniversalEntityID>::s_element = 0x0032;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UniversalEntityID>::s_name = "Universal Entity ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UniversalEntityID>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UniversalEntityID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::UniversalEntityIDType>::s_keyword = Keyword::UniversalEntityIDType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniversalEntityIDType>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::UniversalEntityIDType>::s_element = 0x0033;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::UniversalEntityIDType>::s_name = "Universal Entity ID Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::UniversalEntityIDType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::UniversalEntityIDType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IdentifierTypeCode>::s_keyword = Keyword::IdentifierTypeCode;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IdentifierTypeCode>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IdentifierTypeCode>::s_element = 0x0035;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IdentifierTypeCode>::s_name = "Identifier Type Code";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IdentifierTypeCode>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IdentifierTypeCode>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AssigningFacilitySequence>::s_keyword = Keyword::AssigningFacilitySequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningFacilitySequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningFacilitySequence>::s_element = 0x0036;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AssigningFacilitySequence>::s_name = "Assigning Facility Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AssigningFacilitySequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AssigningFacilitySequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_keyword =
    Keyword::AssigningJurisdictionCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_element = 0x0039;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_name =
    "Assigning Jurisdiction Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AssigningJurisdictionCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_keyword =
    Keyword::AssigningAgencyOrDepartmentCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_element = 0x003A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_name =
    "Assigning Agency or Department Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepStartDate>::s_keyword =
    Keyword::PerformedProcedureStepStartDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepStartDate>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepStartDate>::s_element = 0x0244;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepStartDate>::s_name =
    "Performed Procedure Step Start Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepStartDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepStartDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepStartTime>::s_keyword =
    Keyword::PerformedProcedureStepStartTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepStartTime>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepStartTime>::s_element = 0x0245;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepStartTime>::s_name =
    "Performed Procedure Step Start Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepStartTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepStartTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepEndDate>::s_keyword =
    Keyword::PerformedProcedureStepEndDate;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepEndDate>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepEndDate>::s_element = 0x0250;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepEndDate>::s_name =
    "Performed Procedure Step End Date";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepEndDate>::s_vr = VR::DA;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepEndDate>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepEndTime>::s_keyword =
    Keyword::PerformedProcedureStepEndTime;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepEndTime>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepEndTime>::s_element = 0x0251;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepEndTime>::s_name =
    "Performed Procedure Step End Time";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepEndTime>::s_vr = VR::TM;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepEndTime>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepID>::s_keyword = Keyword::PerformedProcedureStepID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepID>::s_element = 0x0253;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepID>::s_name = "Performed Procedure Step ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProcedureStepDescription>::s_keyword =
    Keyword::PerformedProcedureStepDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProcedureStepDescription>::s_element = 0x0254;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProcedureStepDescription>::s_name =
    "Performed Procedure Step Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProcedureStepDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProcedureStepDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProtocolCodeSequence>::s_keyword =
    Keyword::PerformedProtocolCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProtocolCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProtocolCodeSequence>::s_element = 0x0260;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProtocolCodeSequence>::s_name =
    "Performed Protocol Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProtocolCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProtocolCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PerformedProtocolType>::s_keyword = Keyword::PerformedProtocolType;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProtocolType>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PerformedProtocolType>::s_element = 0x0261;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PerformedProtocolType>::s_name = "Performed Protocol Type";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PerformedProtocolType>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PerformedProtocolType>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestAttributesSequence>::s_keyword = Keyword::RequestAttributesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestAttributesSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestAttributesSequence>::s_element = 0x0275;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestAttributesSequence>::s_name = "Request Attributes Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestAttributesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestAttributesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_keyword =
    Keyword::CommentsOnThePerformedProcedureStep;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_element = 0x0280;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_name =
    "Comments on the Performed Procedure Step";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CommentsOnThePerformedProcedureStep>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::EntranceDose>::s_keyword = Keyword::EntranceDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EntranceDose>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::EntranceDose>::s_element = 0x0302;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::EntranceDose>::s_name = "Entrance Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::EntranceDose>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::EntranceDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ExposedArea>::s_keyword = Keyword::ExposedArea;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposedArea>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ExposedArea>::s_element = 0x0303;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ExposedArea>::s_name = "Exposed Area";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ExposedArea>::s_vr = VR::US;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ExposedArea>::s_vm = VM::MIN_1_MAX_2;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::DistanceSourceToEntrance>::s_keyword = Keyword::DistanceSourceToEntrance;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToEntrance>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::DistanceSourceToEntrance>::s_element = 0x0306;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::DistanceSourceToEntrance>::s_name = "Distance Source to Entrance";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::DistanceSourceToEntrance>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::DistanceSourceToEntrance>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::CommentsOnRadiationDose>::s_keyword = Keyword::CommentsOnRadiationDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CommentsOnRadiationDose>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::CommentsOnRadiationDose>::s_element = 0x0310;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::CommentsOnRadiationDose>::s_name = "Comments on Radiation Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::CommentsOnRadiationDose>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::CommentsOnRadiationDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XRayOutput>::s_keyword = Keyword::XRayOutput;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayOutput>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XRayOutput>::s_element = 0x0312;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XRayOutput>::s_name = "X-Ray Output";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XRayOutput>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XRayOutput>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::HalfValueLayer>::s_keyword = Keyword::HalfValueLayer;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HalfValueLayer>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::HalfValueLayer>::s_element = 0x0314;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::HalfValueLayer>::s_name = "Half Value Layer";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::HalfValueLayer>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::HalfValueLayer>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OrganDose>::s_keyword = Keyword::OrganDose;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrganDose>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrganDose>::s_element = 0x0316;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OrganDose>::s_name = "Organ Dose";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OrganDose>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OrganDose>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::OrganExposed>::s_keyword = Keyword::OrganExposed;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrganExposed>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::OrganExposed>::s_element = 0x0318;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::OrganExposed>::s_name = "Organ Exposed";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::OrganExposed>::s_vr = VR::CS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::OrganExposed>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ProtocolContextSequence>::s_keyword = Keyword::ProtocolContextSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProtocolContextSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ProtocolContextSequence>::s_element = 0x0440;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ProtocolContextSequence>::s_name = "Protocol Context Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ProtocolContextSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ProtocolContextSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContentItemModifierSequence>::s_keyword =
    Keyword::ContentItemModifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentItemModifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContentItemModifierSequence>::s_element = 0x0441;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContentItemModifierSequence>::s_name =
    "Content Item Modifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContentItemModifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContentItemModifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContainerIdentifier>::s_keyword = Keyword::ContainerIdentifier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerIdentifier>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerIdentifier>::s_element = 0x0512;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContainerIdentifier>::s_name = "Container Identifier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContainerIdentifier>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContainerIdentifier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_keyword =
    Keyword::IssuerOfTheContainerIdentifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_element = 0x0513;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_name =
    "Issuer of the Container Identifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfTheContainerIdentifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AlternateContainerIdentifierSequence>::s_keyword =
    Keyword::AlternateContainerIdentifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlternateContainerIdentifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AlternateContainerIdentifierSequence>::s_element = 0x0515;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AlternateContainerIdentifierSequence>::s_name =
    "Alternate Container Identifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AlternateContainerIdentifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AlternateContainerIdentifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContainerTypeCodeSequence>::s_keyword = Keyword::ContainerTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerTypeCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerTypeCodeSequence>::s_element = 0x0518;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContainerTypeCodeSequence>::s_name = "Container Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContainerTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContainerTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContainerDescription>::s_keyword = Keyword::ContainerDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerDescription>::s_element = 0x051A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContainerDescription>::s_name = "Container Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContainerDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContainerDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ContainerComponentSequence>::s_keyword = Keyword::ContainerComponentSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerComponentSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ContainerComponentSequence>::s_element = 0x0520;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ContainerComponentSequence>::s_name = "Container Component Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ContainerComponentSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ContainerComponentSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenIdentifier>::s_keyword = Keyword::SpecimenIdentifier;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenIdentifier>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenIdentifier>::s_element = 0x0551;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenIdentifier>::s_name = "Specimen Identifier";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenIdentifier>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenIdentifier>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenUID>::s_keyword = Keyword::SpecimenUID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenUID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenUID>::s_element = 0x0554;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenUID>::s_name = "Specimen UID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenUID>::s_vr = VR::UI;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenUID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionContextSequence>::s_keyword = Keyword::AcquisitionContextSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContextSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContextSequence>::s_element = 0x0555;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionContextSequence>::s_name = "Acquisition Context Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionContextSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionContextSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::AcquisitionContextDescription>::s_keyword =
    Keyword::AcquisitionContextDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContextDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::AcquisitionContextDescription>::s_element = 0x0556;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::AcquisitionContextDescription>::s_name =
    "Acquisition Context Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::AcquisitionContextDescription>::s_vr = VR::ST;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::AcquisitionContextDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenDescriptionSequence>::s_keyword =
    Keyword::SpecimenDescriptionSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenDescriptionSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenDescriptionSequence>::s_element = 0x0560;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenDescriptionSequence>::s_name =
    "Specimen Description Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenDescriptionSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenDescriptionSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_keyword =
    Keyword::IssuerOfTheSpecimenIdentifierSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_element = 0x0562;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_name =
    "Issuer of the Specimen Identifier Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenTypeCodeSequence>::s_keyword = Keyword::SpecimenTypeCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenTypeCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenTypeCodeSequence>::s_element = 0x059A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenTypeCodeSequence>::s_name = "Specimen Type Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenTypeCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenTypeCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenShortDescription>::s_keyword = Keyword::SpecimenShortDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenShortDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenShortDescription>::s_element = 0x0600;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenShortDescription>::s_name = "Specimen Short Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenShortDescription>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenShortDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenDetailedDescription>::s_keyword =
    Keyword::SpecimenDetailedDescription;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenDetailedDescription>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenDetailedDescription>::s_element = 0x0602;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenDetailedDescription>::s_name =
    "Specimen Detailed Description";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenDetailedDescription>::s_vr = VR::UT;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenDetailedDescription>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenPreparationSequence>::s_keyword =
    Keyword::SpecimenPreparationSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenPreparationSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenPreparationSequence>::s_element = 0x0610;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenPreparationSequence>::s_name =
    "Specimen Preparation Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenPreparationSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenPreparationSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_keyword =
    Keyword::SpecimenLocalizationContentItemSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_element = 0x0620;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_name =
    "Specimen Localization Content Item Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::SpecimenLocalizationContentItemSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_keyword =
    Keyword::WholeSlideMicroscopyImageFrameTypeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_element = 0x0710;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_name =
    "Whole Slide Microscopy Image Frame Type Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_keyword =
    Keyword::ImageCenterPointCoordinatesSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_element = 0x071A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_name =
    "Image Center Point Coordinates Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ImageCenterPointCoordinatesSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_keyword =
    Keyword::XOffsetInSlideCoordinateSystem;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_element = 0x072A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_name =
    "X Offset in Slide Coordinate System";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::XOffsetInSlideCoordinateSystem>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_keyword =
    Keyword::YOffsetInSlideCoordinateSystem;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_element = 0x073A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_name =
    "Y Offset in Slide Coordinate System";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::YOffsetInSlideCoordinateSystem>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_keyword =
    Keyword::ZOffsetInSlideCoordinateSystem;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_element = 0x074A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_name =
    "Z Offset in Slide Coordinate System";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_vr = VR::DS;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ZOffsetInSlideCoordinateSystem>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::MeasurementUnitsCodeSequence>::s_keyword =
    Keyword::MeasurementUnitsCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasurementUnitsCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::MeasurementUnitsCodeSequence>::s_element = 0x08EA;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::MeasurementUnitsCodeSequence>::s_name =
    "Measurement Units Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::MeasurementUnitsCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::MeasurementUnitsCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::RequestedProcedureID>::s_keyword = Keyword::RequestedProcedureID;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureID>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::RequestedProcedureID>::s_element = 0x1001;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::RequestedProcedureID>::s_name = "Requested Procedure ID";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::RequestedProcedureID>::s_vr = VR::SH;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::RequestedProcedureID>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReasonForTheRequestedProcedure>::s_keyword =
    Keyword::ReasonForTheRequestedProcedure;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForTheRequestedProcedure>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForTheRequestedProcedure>::s_element = 0x1002;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReasonForTheRequestedProcedure>::s_name =
    "Reason for the Requested Procedure";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReasonForTheRequestedProcedure>::s_vr = VR::LO;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReasonForTheRequestedProcedure>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_keyword =
    Keyword::ReasonForRequestedProcedureCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_element = 0x100A;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_name =
    "Reason for Requested Procedure Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReasonForRequestedProcedureCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_keyword =
    Keyword::ReasonForPerformedProcedureCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_element = 0x1012;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_name =
    "Reason For Performed Procedure Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::ReasonForPerformedProcedureCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PersonIdentificationCodeSequence>::s_keyword =
    Keyword::PersonIdentificationCodeSequence;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PersonIdentificationCodeSequence>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PersonIdentificationCodeSequence>::s_element = 0x1101;
template<>
SIGHT_DATA_API const std::string_view Attribute<Keyword::PersonIdentificationCodeSequence>::s_name =
    "Person Identification Code Sequence";
template<>
SIGHT_DATA_API const VR Attribute<Keyword::PersonIdentificationCodeSequence>::s_vr = VR::SQ;
template<>
SIGHT_DATA_API const VM Attribute<Keyword::PersonIdentificationCodeSequence>::s_vm = VM::MIN_1_MAX_1;
template<>
SIGHT_DATA_API const Keyword Attribute<Keyword::PersonAddress>::s_keyword = Keyword::PersonAddress;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PersonAddress>::s_group = 0x0040;
template<>
SIGHT_DATA_API const std::uint16_t Attribute<Keyword::PersonAddress>::s_element = 0x1102;
template<>
SIGHT_DATA_API 