-- MySQL dump 10.13  Distrib 5.5.22, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: nconf
-- ------------------------------------------------------
-- Server version	5.5.22-0ubuntu1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `ConfigAttrs`
--

DROP TABLE IF EXISTS `ConfigAttrs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ConfigAttrs` (
  `id_attr` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attr_name` varchar(60) NOT NULL DEFAULT '',
  `friendly_name` varchar(80) NOT NULL DEFAULT '',
  `description` varchar(250) DEFAULT NULL,
  `datatype` enum('text','password','select','assign_one','assign_many','assign_cust_order') NOT NULL DEFAULT 'text',
  `max_length` int(11) DEFAULT NULL,
  `poss_values` text,
  `predef_value` varchar(1024) DEFAULT NULL,
  `mandatory` enum('yes','no') NOT NULL DEFAULT 'no',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `visible` enum('yes','no') NOT NULL DEFAULT 'yes',
  `write_to_conf` enum('yes','no') NOT NULL DEFAULT 'yes',
  `naming_attr` enum('yes','no') NOT NULL DEFAULT 'no',
  `link_as_child` enum('yes','no') NOT NULL DEFAULT 'no',
  `link_bidirectional` enum('yes','no') NOT NULL DEFAULT 'no',
  `fk_show_class_items` int(10) unsigned DEFAULT NULL,
  `fk_id_class` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_attr`),
  KEY `fk_show_class_items` (`fk_show_class_items`),
  KEY `fk_id_class` (`fk_id_class`),
  CONSTRAINT `ConfigAttrs_ibfk_1` FOREIGN KEY (`fk_show_class_items`) REFERENCES `ConfigClasses` (`id_class`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ConfigAttrs_ibfk_2` FOREIGN KEY (`fk_id_class`) REFERENCES `ConfigClasses` (`id_class`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ConfigAttrs`
--

LOCK TABLES `ConfigAttrs` WRITE;
/*!40000 ALTER TABLE `ConfigAttrs` DISABLE KEYS */;
INSERT INTO `ConfigAttrs` VALUES (1,'server_name','server name',NULL,'text',255,'','','yes',1,'yes','no','yes','no','no',NULL,10),(6,'server_name','server name',NULL,'text',255,'','','yes',1,'yes','no','yes','no','no',NULL,11),(12,'icon_image_alt','OS description',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,9),(13,'icon_image','icon image','img/logos/...','text',255,'','base/linux40.gif','no',2,'yes','yes','no','no','no',NULL,9),(14,'statusmap_image','statusmap image','img/logos/...','text',255,'','base/linux40.gd2','no',3,'yes','yes','no','no','no',NULL,9),(15,'host_name','hostname',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,1),(16,'alias','alias','alias or FQDN','text',255,'','','no',2,'yes','yes','no','no','no',NULL,1),(17,'address','address','IP-address / DNS name','text',255,'','','yes',3,'yes','yes','no','no','no',NULL,1),(18,'os','OS','','assign_one',0,'','Linux','yes',4,'yes','no','no','no','no',9,1),(19,'check_period','check period','time period to run checks','assign_one',0,'','24x7','no',8,'yes','yes','no','no','no',7,1),(20,'notification_period','notification period','time period to alarm','assign_one',0,'','24x7','no',9,'yes','yes','no','no','no',7,1),(22,'contact_groups','contact groups','responsible group','assign_many',0,'','','no',12,'yes','yes','no','no','no',6,1),(23,'parents','parent hosts','','assign_many',0,'','','no',14,'yes','yes','no','no','no',1,1),(24,'notes','notes',NULL,'text',1024,'','','no',15,'yes','yes','no','no','no',NULL,1),(25,'notes_url','notes URL',NULL,'text',1024,'','','no',16,'yes','yes','no','no','no',NULL,1),(26,'monitored_by','monitored by','monitoring server (empty = not monitored)','assign_one',0,'','','no',6,'yes','no','no','no','no',10,1),(27,'hostgroup_name','hostgroup name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,2),(28,'alias','alias',NULL,'text',255,'','','yes',2,'yes','yes','no','no','no',NULL,2),(29,'members','assign host to hostgroup',NULL,'assign_many',0,'','','no',3,'yes','yes','no','yes','yes',1,2),(30,'command_name','check command name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,8),(31,'command_line','check command line',NULL,'text',1024,'','','yes',3,'yes','yes','no','no','no',NULL,8),(32,'timeperiod_name','timeperiod name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,7),(33,'alias','alias',NULL,'text',255,'','','yes',2,'yes','yes','no','no','no',NULL,7),(34,'sunday','sunday timeperiod','00:00-24:00','text',255,'','','no',3,'yes','yes','no','no','no',NULL,7),(35,'monday','monday timeperiod','00:00-24:00','text',255,'','','no',4,'yes','yes','no','no','no',NULL,7),(36,'tuesday','tuesday timeperiod','00:00-24:00','text',255,'','','no',5,'yes','yes','no','no','no',NULL,7),(37,'wednesday','wednesday timeperiod','00:00-24:00','text',255,'','','no',6,'yes','yes','no','no','no',NULL,7),(38,'thursday','thursday timeperiod','00:00-24:00','text',255,'','','no',7,'yes','yes','no','no','no',NULL,7),(39,'friday','friday timeperiod','00:00-24:00','text',255,'','','no',8,'yes','yes','no','no','no',NULL,7),(40,'saturday','saturday timeperiod','00:00-24:00','text',255,'','','no',9,'yes','yes','no','no','no',NULL,7),(47,'contact_name','contact name','username','text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,5),(48,'alias','alias','firstname lastname','text',255,'','','yes',2,'yes','yes','no','no','no',NULL,5),(49,'host_notification_period','host notification period','host alarming timeperiod','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,5),(50,'service_notification_period','service notification period','service alarming timeperiod','assign_one',0,'','','no',5,'yes','yes','no','no','no',7,5),(51,'host_notification_options','host notification options','possible values: d,u,r,f,[n]','text',20,'','d','no',6,'yes','yes','no','no','no',NULL,5),(52,'service_notification_options','service notification options','possible values: w,u,c,r,f,[n]','text',20,'','c','no',7,'yes','yes','no','no','no',NULL,5),(53,'host_notification_commands','host notification commands','default: notify-host-by-email','assign_many',0,'','notify-host-by-email','no',10,'yes','yes','no','no','no',13,5),(54,'service_notification_commands','service notification commands','default: notify-service-by-email','assign_many',0,'','notify-service-by-email','no',11,'yes','yes','no','no','no',13,5),(55,'email','e-mail address',NULL,'text',255,'','','yes',8,'yes','yes','no','no','no',NULL,5),(56,'pager','pager / phone nr.','(country code) + (prefix) + (number)','text',255,'','','no',9,'yes','yes','no','no','no',NULL,5),(57,'contactgroup_name','contactgroup name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,6),(58,'alias','alias',NULL,'text',255,'','','yes',2,'yes','yes','no','no','no',NULL,6),(59,'members','assign contact to contactgroup',NULL,'assign_many',0,'','','no',3,'yes','yes','no','yes','yes',5,6),(60,'service_description','service name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,3),(61,'check_command','check command',NULL,'assign_one',0,'','','yes',3,'yes','yes','no','no','no',8,3),(62,'host_name','assigned to host',NULL,'assign_one',0,'','','yes',4,'yes','yes','no','no','no',1,3),(63,'check_period','check period','time period to run checks','assign_one',0,'','24x7','no',5,'yes','yes','no','no','no',7,3),(64,'notification_period','notification period','time period to alarm','assign_one',0,'','','no',6,'yes','yes','no','no','no',7,3),(65,'contact_groups','contact groups','responsible group','assign_many',0,'','','no',8,'yes','yes','no','no','no',6,3),(67,'notes','notes',NULL,'text',1024,'','','no',9,'yes','yes','no','no','no',NULL,3),(68,'notes_url','notes URL',NULL,'text',1024,'','','no',10,'yes','yes','no','no','no',NULL,3),(69,'event_handler_enabled','event-handler enabled',NULL,'select',0,'0::1','0','no',23,'no','yes','no','no','no',NULL,3),(70,'servicegroup_name','servicegroup name',NULL,'text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,4),(71,'alias','alias',NULL,'text',255,'','','yes',2,'yes','yes','no','no','no',NULL,4),(72,'members','assign service to servicegroup',NULL,'assign_many',0,'','','no',3,'yes','yes','no','yes','yes',3,4),(73,'template_name','host preset name',NULL,'text',255,'','','yes',1,'yes','no','yes','no','no',NULL,12),(74,'command_name','host preset commands','auto-create services for a new host based on these checkcommands','assign_many',0,'','','no',3,'yes','no','no','yes','no',8,12),(75,'host-preset','host preset','predefined services / host-alive check','assign_one',0,'','linux-server','yes',5,'yes','no','no','no','no',12,1),(79,'check_params','params for check command',NULL,'text',1024,'','!','no',24,'yes','no','no','no','no',NULL,3),(81,'hostalive_check','host-alive check','','assign_one',0,'','check-host-alive','yes',2,'yes','yes','no','no','no',13,12),(86,'command_syntax','params description','short description of each parameter (comma separated, same order)','text',1024,'','','no',5,'yes','no','no','no','no',NULL,8),(87,'default_params','default command params','separated by \"!\"','text',1024,'','!','no',4,'yes','no','no','no','no',NULL,8),(91,'collector_check_freshness','check freshness (of collectors)','value is applied to \"check_ssh\" service on \"host is collector\" flagged hosts','select',0,'0::1','1','yes',2,'yes','no','no','no','no',NULL,11),(92,'collector_freshness_threshold','freshness threshold (of collectors)','value is applied to \"check_ssh\" service on \"host is collector\" flagged hosts; sets the time until service becomes \"stale\" (useful to verify connection between collectors and monitors)','text',5,'','900','yes',3,'yes','no','no','no','no',NULL,11),(93,'host_is_collector','host is collector','is this host a collector itself?','select',0,'no::yes','no','yes',7,'yes','no','no','no','no',NULL,1),(94,'command_param_count','amount of params','','select',0,'0::1::2::3::4::5::6::7::8::9::10','1','yes',6,'yes','no','no','no','no',NULL,8),(95,'user_password','user password','password for NConf & Nagios GUI','password',255,'','','no',12,'no','no','no','no','no',NULL,5),(96,'nc_permission','nconf permissions','defines the permissions in NConf','select',0,'no access::user::admin','user','no',13,'no','no','no','no','no',NULL,5),(97,'nagios_access','nagios access','defines access to the Nagios GUI','select',0,'enabled::disabled','enabled','no',14,'no','no','no','no','no',NULL,5),(98,'command_name','misc command name','','text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,13),(99,'command_line','misc command line','','text',1024,'','','yes',2,'yes','yes','no','no','no',NULL,13),(101,'action_url','action URL','PNP URL (if installed)','select',0,'/nagios/html/pnp4nagios/index.php?host=$HOSTNAME$::https://URL_TO_NCONF/dependency.php?xmode=nagiosview&hostname=$HOSTNAME$&service_link=https://URL_TO_NAGIOS/nagios/cgi-bin/extinfo.cgi::https://URL_TO_NCONF/dependency.php?xmode=nagiosview&hostname=$HOSTNAME$&service_link=https://URL_TO_NAGIOS/nagios/cgi-bin/extinfo.cgi&pnp_link=https://URL_TO_NAGIOS/nagios/html/pnp4nagios/index.php','','no',17,'yes','yes','no','no','no',NULL,1),(102,'action_url','action URL','PNP URL (if installed)','select',0,'/nagios/html/pnp4nagios/index.php?host=$HOSTNAME$&srv=$SERVICEDESC$','','no',11,'yes','yes','no','no','no',NULL,3),(103,'default_service_name','default service name','default name to use for new services','text',255,NULL,NULL,'no',2,'yes','no','no','no','no',NULL,8),(104,'notes','notes',NULL,'text',1024,NULL,NULL,'no',5,'yes','yes','no','no','no',NULL,2),(105,'notes_url','notes URL',NULL,'text',1024,NULL,NULL,'no',6,'yes','yes','no','no','no',NULL,2),(106,'notes','notes',NULL,'text',1024,NULL,NULL,'no',5,'yes','yes','no','no','no',NULL,4),(107,'notes_url','notes URL',NULL,'text',1024,NULL,NULL,'no',6,'yes','yes','no','no','no',NULL,4),(108,'name','template name','','text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,14),(109,'host_name','host name','mandatory if \"register\" = 1','text',255,'','','no',2,'no','no','no','no','no',NULL,14),(110,'register','register','display this template as a host in Nagios','select',0,'0::1','0','yes',3,'no','yes','no','no','no',NULL,14),(111,'check_period','check period','time period to run checks','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,14),(112,'notification_period','notification period','time period to alarm','assign_one',0,'','','no',5,'yes','yes','no','no','no',7,14),(113,'check_command','check command','host-alive check','assign_one',0,'','','no',6,'yes','yes','no','no','no',13,14),(114,'use','parent template(s)','parent template(s) to inherit from','assign_cust_order',0,'','','no',7,'yes','yes','no','no','no',14,14),(115,'contact_groups','contact groups','responsible group','assign_many',0,'','','no',8,'yes','yes','no','no','no',6,14),(116,'notes','notes',NULL,'text',1024,'','','no',9,'yes','yes','no','no','no',NULL,14),(117,'notes_url','notes URL',NULL,'text',1024,'','','no',10,'yes','yes','no','no','no',NULL,14),(118,'action_url','action URL','PNP URL (if installed)','select',0,'/nagios/html/pnp4nagios/index.php?host=$HOSTNAME$::https://URL_TO_NCONF/dependency.php?xmode=nagiosview&hostname=$HOSTNAME$&service_link=https://URL_TO_NAGIOS/nagios/cgi-bin/extinfo.cgi::https://URL_TO_NCONF/dependency.php?xmode=nagiosview&hostname=$HOSTNAME$&service_link=https://URL_TO_NAGIOS/nagios/cgi-bin/extinfo.cgi&pnp_link=https://URL_TO_NAGIOS/nagios/html/pnp4nagios/index.php','','no',11,'yes','yes','no','no','no',NULL,14),(119,'max_check_attempts','max check attempts','number of times to retry checking','text',4,'','','no',12,'yes','yes','no','no','no',NULL,14),(120,'check_interval','check interval','number of [min.] between regularly scheduled checks','text',4,'','','no',13,'yes','yes','no','no','no',NULL,14),(121,'retry_interval','retry interval','number of [min.] to wait before scheduling a re-check','text',4,'','','no',14,'yes','yes','no','no','no',NULL,14),(122,'notification_interval','notification interval','number of [min.] to wait before re-notifying a contact','text',4,'','','no',16,'yes','yes','no','no','no',NULL,14),(123,'notification_options','notification options','possible values: d,u,r,f,s,[n]','text',20,'','','no',17,'yes','yes','no','no','no',NULL,14),(124,'active_checks_enabled','active checking','do active checking of hosts','select',0,'0::1','','no',18,'yes','yes','no','no','no',NULL,14),(125,'passive_checks_enabled','passive checking','do passive checking of hosts','select',0,'0::1','','no',19,'yes','yes','no','no','no',NULL,14),(126,'notifications_enabled','notification enabled','send notifications for hosts','select',0,'0::1','','no',20,'yes','yes','no','no','no',NULL,14),(127,'check_freshness','check freshness','check age of last check results','select',0,'0::1','','no',21,'yes','yes','no','no','no',NULL,14),(128,'freshness_threshold','freshness threshold','age threshold in [sec.]','text',5,'','','no',22,'yes','yes','no','no','no',NULL,14),(129,'name','template name','','text',255,'','','yes',1,'yes','yes','yes','no','no',NULL,15),(130,'service_description','service name','mandatory if \"register\" = 1','text',255,'','','no',2,'no','no','no','no','no',NULL,15),(131,'register','register','display this template as a service in Nagios','select',0,'0::1','0','yes',3,'no','yes','no','no','no',NULL,15),(132,'check_period','check period','time period to run checks','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,15),(133,'notification_period','notification period','time period to alarm','assign_one',0,'','','no',5,'yes','yes','no','no','no',7,15),(134,'use','parent template(s)','parent template(s) to inherit from','assign_cust_order',0,'','','no',6,'yes','yes','no','no','no',15,15),(135,'contact_groups','contact groups','responsible group','assign_many',0,'','','no',7,'yes','yes','no','no','no',6,15),(136,'notes','notes',NULL,'text',1024,'','','no',8,'yes','yes','no','no','no',NULL,15),(137,'notes_url','notes URL',NULL,'text',1024,'','','no',9,'yes','yes','no','no','no',NULL,15),(138,'action_url','action URL','PNP URL (if installed)','select',0,'/nagios/html/pnp4nagios/index.php?host=$HOSTNAME$&srv=$SERVICEDESC$','','no',10,'yes','yes','no','no','no',NULL,15),(139,'max_check_attempts','max check attempts','number of times to retry checking','text',4,'','','no',11,'yes','yes','no','no','no',NULL,15),(140,'check_interval','check interval','number of [min.] between regularly scheduled checks','text',4,'','','no',12,'yes','yes','no','no','no',NULL,15),(141,'retry_interval','retry interval','number of [min.] to wait before scheduling a re-check','text',4,'','','no',13,'yes','yes','no','no','no',NULL,15),(142,'notification_interval','notification interval','number of [min.] to wait before re-notifying a contact','text',4,'','','no',15,'yes','yes','no','no','no',NULL,15),(143,'notification_options','notification options','possible values: w,u,c,r,f,s,[n]','text',20,'','','no',16,'yes','yes','no','no','no',NULL,15),(144,'active_checks_enabled','active checking','do active checking of services','select',0,'0::1','','no',17,'yes','yes','no','no','no',NULL,15),(145,'passive_checks_enabled','passive checking','do passive checking of services','select',0,'0::1','','no',18,'yes','yes','no','no','no',NULL,15),(146,'notifications_enabled','notification enabled','send notifications for services','select',0,'0::1','','no',19,'yes','yes','no','no','no',NULL,15),(147,'check_freshness','check freshness','check age of last check results','select',0,'0::1','','no',20,'yes','yes','no','no','no',NULL,15),(148,'freshness_threshold','freshness threshold','age threshold in [sec.]','text',5,'','','no',21,'yes','yes','no','no','no',NULL,15),(149,'use','host template(s)','host template(s) to inherit properties from','assign_cust_order',NULL,NULL,NULL,'no',10,'yes','yes','no','no','no',14,1),(150,'use','service template(s)','service template(s) to inherit properties from','assign_cust_order',NULL,NULL,NULL,'no',7,'yes','yes','no','no','no',15,3),(151,'host_template','host template(s)','add the following template(s) to all hosts monitored by this server','assign_cust_order',NULL,NULL,'Default_collector_server','no',2,'yes','no','no','no','no',14,10),(152,'service_template','service template(s)','add the following template(s) to all services monitored by this server','assign_cust_order',NULL,NULL,'Default_collector_server','no',3,'yes','no','no','no','no',15,10),(153,'stale_service_command','stale service command','\"dummy\" command to run for stale services','assign_one',NULL,NULL,'service_is_stale','no',4,'yes','no','no','no','no',13,11),(154,'host_template','host template(s)','add the following template(s) to all hosts monitored by this server','assign_cust_order',NULL,NULL,'Default_monitor_server','no',5,'yes','no','no','no','no',14,11),(155,'service_template','service template(s)','add the following template(s) to all services monitored by this server','assign_cust_order',NULL,NULL,'Default_monitor_server','no',6,'yes','no','no','no','no',15,11),(156,'host_template','host template(s)','add the following template(s) to all hosts linked with this timeperiod','assign_cust_order',NULL,NULL,'','no',10,'yes','no','no','no','no',14,7),(157,'service_template','service template(s)','add the following template(s) to all services linked with this timeperiod','assign_cust_order',NULL,NULL,'','no',11,'yes','no','no','no','no',15,7),(158,'dependency_name','dependency name','description for the dependency definition','text',1024,'','','yes',1,'yes','no','yes','no','no',NULL,16),(159,'execution_failure_criteria','execution failure criteria','possible values: o,d,u,p,n','text',20,'','','no',2,'yes','yes','no','no','no',NULL,16),(160,'notification_failure_criteria','notification failure criteria','possible values: o,d,u,p,n','text',20,'','','no',3,'yes','yes','no','no','no',NULL,16),(161,'dependency_period','dependency time period','restrict dependency to this time period','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,16),(162,'inherits_parent','inherit dependencies','inherit dependencies from host(s) depended on','select',0,'0::1','0','no',5,'yes','yes','no','no','no',NULL,16),(163,'host_name','master host(s)','host(s) being depended upon','assign_many',0,'','','no',6,'yes','yes','no','no','no',1,16),(164,'hostgroup_name','master hostgroup(s)','hostgroup(s) being depended upon','assign_many',0,'','','no',7,'yes','yes','no','no','no',2,16),(165,'dependent_host_name','dependent host(s)','the dependent host(s)','assign_many',0,'','','no',8,'yes','yes','no','no','no',1,16),(166,'dependent_hostgroup_name','dependent hostgroup(s)','the dependent hostgroup(s)','assign_many',0,'','','no',9,'yes','yes','no','no','no',2,16),(167,'dependency_name','dependency name','description for the dependency definition','text',1024,'','','yes',1,'yes','no','yes','no','no',NULL,17),(168,'execution_failure_criteria','execution failure criteria','possible values: o,w,u,c,p,n','text',20,'','','no',2,'yes','yes','no','no','no',NULL,17),(169,'notification_failure_criteria','notification failure criteria','possible values: o,w,u,c,p,n','text',20,'','','no',3,'yes','yes','no','no','no',NULL,17),(170,'dependency_period','dependency time period','restrict dependency to this time period','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,17),(171,'inherits_parent','inherit dependencies','inherit dependencies from service(s) depended on','select',0,'0::1','0','no',5,'yes','yes','no','no','no',NULL,17),(172,'service_description','master service(s)','service(s) being depended upon','assign_many',0,'','','yes',6,'yes','yes','no','no','no',3,17),(173,'dependent_service_description','dependent service(s)','the dependent service(s)','assign_many',0,'','','yes',7,'yes','yes','no','no','no',3,17),(174,'service_enabled','service enabled','enable / disable this service','select',NULL,'yes::no','yes','yes',2,'yes','no','no','no','no',NULL,3),(175,'hostgroup_members','assign hostgroup to hostgroup','','assign_many',0,'','','no',4,'yes','yes','no','yes','no',2,2),(176,'servicegroup_members','assign servicegroup to servicegroup','','assign_many',0,'','','no',4,'yes','yes','no','yes','no',4,4),(177,'contactgroup_members','assign contactgroup to contactgroup','','assign_many',0,'','','no',4,'yes','yes','no','yes','no',6,6),(178,'service_template','default service template(s)','add the following template(s) to all advanced-/services linked with this checkcommand (linked templates are not visible in the GUI because they are linked when the config is generated)','assign_cust_order',NULL,NULL,'','no',7,'yes','no','no','no','no',15,8),(179,'default_service_dependency','default command to depend upon','make all services using the current command dependent on services on the same host using this command selected here','assign_one',NULL,NULL,'','no',8,'yes','no','no','no','no',8,8),(180,'dependency_execution_failure_criteria','execution_failure_criteria for dependency','the \'execution_failure_criteria\' value to use for the dependency; possible values: o,w,u,c,p,[n]','text',20,'','','no',9,'yes','no','no','no','no',NULL,8),(181,'dependency_notification_failure_criteria','notification_failure_criteria for dependency','the \'notification_failure_criteria\' value to use for the dependency; possible values: o,w,u,c,p,[n]','text',20,'','','no',10,'yes','no','no','no','no',NULL,8),(182,'advanced_service_name','advanced service name','NConf internal service name','text',255,'','','yes',1,'yes','no','yes','no','no',NULL,18),(183,'service_description','service description','Nagios specific service description','text',255,'','','yes',2,'yes','yes','no','no','no',NULL,18),(184,'check_command','check command','','assign_one',0,'','','yes',3,'yes','yes','no','no','no',8,18),(185,'check_period','check period','time period to run checks','assign_one',0,'','','no',4,'yes','yes','no','no','no',7,18),(186,'notification_period','notification period','time period to alarm','assign_one',0,'','','no',5,'yes','yes','no','no','no',7,18),(187,'host_name','assign advanced-service to host','','assign_many',0,'','','no',6,'yes','yes','no','no','no',1,18),(188,'hostgroup_name','assign advanced-service to hostgroup','','assign_many',0,'','','no',7,'yes','yes','no','no','yes',2,18),(189,'servicegroups','assign advanced-service to servicegroup','','assign_many',0,'','','no',8,'yes','yes','no','no','yes',4,18),(190,'use','service template(s)','parent template(s) to inherit from','assign_cust_order',0,'','','no',9,'yes','yes','no','no','no',15,18),(191,'contact_groups','contact groups','responsible group','assign_many',0,'','','no',10,'yes','yes','no','no','no',6,18),(192,'notes','notes','','text',1024,'','','no',11,'yes','yes','no','no','no',NULL,18),(193,'notes_url','notes URL','','text',1024,'','','no',12,'yes','yes','no','no','no',NULL,18),(194,'action_url','action URL','PNP URL (if installed)','select',0,'/nagios/html/pnp4nagios/index.php?host=$HOSTNAME$&srv=$SERVICEDESC$','','no',13,'yes','yes','no','no','no',NULL,18),(195,'max_check_attempts','max check attempts','number of times to retry checking','text',4,'','','no',14,'yes','yes','no','no','no',NULL,18),(196,'check_interval','check interval','number of [min.] between regularly scheduled checks','text',4,'','','no',15,'yes','yes','no','no','no',NULL,18),(197,'retry_interval','retry interval','number of [min.] to wait before scheduling a re-check','text',4,'','','no',16,'yes','yes','no','no','no',NULL,18),(198,'first_notification_delay','first notification delay','number of [min.] to wait before sending the first notification','text',4,'','','no',17,'yes','yes','no','no','no',NULL,18),(199,'notification_interval','notification interval','number of [min.] to wait before re-notifying a contact','text',4,'','','no',18,'yes','yes','no','no','no',NULL,18),(200,'notification_options','notification options','possible values: w,u,c,r,f,s,[n]','text',20,'','','no',19,'yes','yes','no','no','no',NULL,18),(201,'active_checks_enabled','active checking','do active checking of services','select',0,'0::1','','no',20,'yes','yes','no','no','no',NULL,18),(202,'passive_checks_enabled','passive checking','do passive checking of services','select',0,'0::1','','no',21,'yes','yes','no','no','no',NULL,18),(203,'notifications_enabled','notification enabled','send notifications for services','select',0,'0::1','','no',22,'yes','yes','no','no','no',NULL,18),(204,'check_freshness','check freshness','check age of last check results','select',0,'0::1','','no',23,'yes','yes','no','no','no',NULL,18),(205,'freshness_threshold','freshness threshold','age threshold in [sec.]','text',5,'','','no',24,'yes','yes','no','no','no',NULL,18),(206,'check_params','params for check command','','text',1024,'','!','no',25,'yes','no','no','no','no',NULL,18),(207,'max_check_attempts','max check attempts','number of times to retry checking','text',4,'','','no',18,'yes','yes','no','no','no',NULL,1),(208,'check_interval','check interval','number of [min.] between regularly scheduled checks','text',4,'','','no',19,'yes','yes','no','no','no',NULL,1),(209,'retry_interval','retry interval','number of [min.] to wait before scheduling a re-check','text',4,'','','no',20,'yes','yes','no','no','no',NULL,1),(210,'first_notification_delay','first notification delay','number of [min.] to wait before sending the first notification','text',4,'','','no',21,'yes','yes','no','no','no',NULL,1),(211,'notification_interval','notification interval','number of [min.] to wait before re-notifying a contact','text',4,'','','no',22,'yes','yes','no','no','no',NULL,1),(212,'notification_options','notification options','possible values: d,u,r,f,s,[n]','text',20,'','','no',23,'yes','yes','no','no','no',NULL,1),(213,'active_checks_enabled','active checking','do active checking of hosts','select',0,'0::1','','no',24,'yes','yes','no','no','no',NULL,1),(214,'passive_checks_enabled','passive checking','do passive checking of hosts','select',0,'0::1','','no',25,'yes','yes','no','no','no',NULL,1),(215,'notifications_enabled','notification enabled','send notifications for hosts','select',0,'0::1','','no',26,'yes','yes','no','no','no',NULL,1),(216,'check_freshness','check freshness','check age of last check results','select',0,'0::1','','no',27,'yes','yes','no','no','no',NULL,1),(217,'freshness_threshold','freshness threshold','age threshold in [sec.]','text',5,'','','no',28,'yes','yes','no','no','no',NULL,1),(218,'max_check_attempts','max check attempts','number of times to retry checking','text',4,'','','no',12,'yes','yes','no','no','no',NULL,3),(219,'check_interval','check interval','number of [min.] between regularly scheduled checks','text',4,'','','no',13,'yes','yes','no','no','no',NULL,3),(220,'retry_interval','retry interval','number of [min.] to wait before scheduling a re-check','text',4,'','','no',14,'yes','yes','no','no','no',NULL,3),(221,'first_notification_delay','first notification delay','number of [min.] to wait before sending the first notification','text',4,'','','no',15,'yes','yes','no','no','no',NULL,3),(222,'notification_interval','notification interval','number of [min.] to wait before re-notifying a contact','text',4,'','','no',16,'yes','yes','no','no','no',NULL,3),(223,'notification_options','notification options','possible values: w,u,c,r,f,s,[n]','text',20,'','','no',17,'yes','yes','no','no','no',NULL,3),(224,'active_checks_enabled','active checking','do active checking of services','select',0,'0::1','','no',18,'yes','yes','no','no','no',NULL,3),(225,'passive_checks_enabled','passive checking','do passive checking of services','select',0,'0::1','','no',19,'yes','yes','no','no','no',NULL,3),(226,'notifications_enabled','notification enabled','send notifications for services','select',0,'0::1','','no',20,'yes','yes','no','no','no',NULL,3),(227,'check_freshness','check freshness','check age of last check results','select',0,'0::1','','no',21,'yes','yes','no','no','no',NULL,3),(228,'freshness_threshold','freshness threshold','age threshold in [sec.]','text',5,'','','no',22,'yes','yes','no','no','no',NULL,3),(229,'first_notification_delay','first notification delay','number of [min.] to wait before sending the first notification','text',4,'','','no',15,'yes','yes','no','no','no',NULL,14),(230,'first_notification_delay','first notification delay','number of [min.] to wait before sending the first notification','text',4,'','','no',14,'yes','yes','no','no','no',NULL,15),(231,'password','shinken password','shinken password','text',1024,'','','no',3,'yes','yes','no','no','no',NULL,5);
/*!40000 ALTER TABLE `ConfigAttrs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ConfigClasses`
--

DROP TABLE IF EXISTS `ConfigClasses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ConfigClasses` (
  `id_class` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `config_class` varchar(50) NOT NULL DEFAULT '',
  `friendly_name` varchar(80) NOT NULL,
  `nav_visible` enum('yes','no') NOT NULL DEFAULT 'yes',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `grouping` varchar(30) NOT NULL,
  `nav_links` varchar(512) NOT NULL,
  `nav_privs` enum('user','admin') NOT NULL DEFAULT 'admin',
  `class_type` enum('global','monitor','collector') NOT NULL DEFAULT 'global',
  `out_file` varchar(50) DEFAULT NULL,
  `nagios_object` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_class`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ConfigClasses`
--

LOCK TABLES `ConfigClasses` WRITE;
/*!40000 ALTER TABLE `ConfigClasses` DISABLE KEYS */;
INSERT INTO `ConfigClasses` VALUES (1,'host','Hosts','yes',1,'','Show::overview.php?class=host;;Add::handle_item.php?item=host','user','collector','hosts.cfg','host'),(2,'hostgroup','Hostgroups','yes',2,'','Show::overview.php?class=hostgroup;;Add::handle_item.php?item=hostgroup','user','collector','hostgroups.cfg','hostgroup'),(3,'service','Services','yes',3,'','Show::overview.php?class=service;;Add::handle_item.php?item=service','user','collector','services.cfg','service'),(4,'servicegroup','Servicegroups','yes',5,'','Show::overview.php?class=servicegroup;;Add::handle_item.php?item=servicegroup','user','collector','servicegroups.cfg','servicegroup'),(5,'contact','Contacts','yes',2,'','Show::overview.php?class=contact;;Add::handle_item.php?item=contact','admin','global','contacts.cfg','contact'),(6,'contactgroup','Contactgroups','yes',3,'','Show::overview.php?class=contactgroup;;Add::handle_item.php?item=contactgroup','admin','global','contactgroups.cfg','contactgroup'),(7,'timeperiod','Timeperiods','yes',6,'','Show::overview.php?class=timeperiod;;Add::handle_item.php?item=timeperiod','admin','global','timeperiods.cfg','timeperiod'),(8,'checkcommand','Checkcommands','yes',4,'','Show::overview.php?class=checkcommand;;Add::handle_item.php?item=checkcommand','admin','global','checkcommands.cfg','command'),(9,'os','OS','yes',1,'','Show::overview.php?class=os;;Add::handle_item.php?item=os','admin','global',NULL,NULL),(10,'nagios-collector','Distrib. collectors','yes',2,'Nagios servers','Show::overview.php?class=nagios-collector;;Add::handle_item.php?item=nagios-collector','admin','global',NULL,NULL),(11,'nagios-monitor','Central monitors','yes',1,'Nagios servers','Show::overview.php?class=nagios-monitor;;Add::handle_item.php?item=nagios-monitor','admin','global',NULL,NULL),(12,'host-preset','Host presets','yes',1,'Advanced Items','Show::overview.php?class=host-preset;;Add::handle_item.php?item=host-preset','admin','global',NULL,NULL),(13,'misccommand','Misccommands','yes',5,'','Show::overview.php?class=misccommand;;Add::handle_item.php?item=misccommand','admin','global','misccommands.cfg','command'),(14,'host-template','Host templates','yes',2,'Advanced Items','Show::overview.php?class=host-template;;Add::handle_item.php?item=host-template','admin','global','host_templates.cfg','host'),(15,'service-template','Service templates','yes',3,'Advanced Items','Show::overview.php?class=service-template;;Add::handle_item.php?item=service-template','admin','global','service_templates.cfg','service'),(16,'host-dependency','Host deps.','yes',4,'Advanced Items','Show::overview.php?class=host-dependency;;Add::handle_item.php?item=host-dependency','admin','collector','host_dependencies.cfg','hostdependency'),(17,'service-dependency','Service deps.','yes',5,'Advanced Items','Show::overview.php?class=service-dependency;;Add::handle_item.php?item=service-dependency','admin','collector','service_dependencies.cfg','servicedependency'),(18,'advanced-service','Advanced Services','yes',4,'','Show::overview.php?class=advanced-service;;Add::handle_item.php?item=advanced-service','user','collector','advanced_services.cfg','service');
/*!40000 ALTER TABLE `ConfigClasses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ConfigItems`
--

DROP TABLE IF EXISTS `ConfigItems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ConfigItems` (
  `id_item` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_id_class` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_item`),
  KEY `fk_id_class` (`fk_id_class`),
  CONSTRAINT `ConfigItems_ibfk_1` FOREIGN KEY (`fk_id_class`) REFERENCES `ConfigClasses` (`id_class`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5740 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ConfigItems`
--

LOCK TABLES `ConfigItems` WRITE;
/*!40000 ALTER TABLE `ConfigItems` DISABLE KEYS */;
INSERT INTO `ConfigItems` VALUES (5333,5),(5334,6),(5305,7),(5306,7),(5307,7),(5,9),(7,9),(2528,9),(5254,9),(5255,9),(5256,9),(5257,9),(5277,9),(1,10),(5732,12),(5296,13),(5327,13),(5328,13),(5329,13),(5330,13),(5331,13),(5335,14),(5348,15);
/*!40000 ALTER TABLE `ConfigItems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ConfigValues`
--

DROP TABLE IF EXISTS `ConfigValues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ConfigValues` (
  `attr_value` varchar(1024) DEFAULT NULL,
  `fk_id_attr` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_id_item` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_id_attr`,`fk_id_item`),
  KEY `fk_id_item` (`fk_id_item`),
  CONSTRAINT `ConfigValues_ibfk_1` FOREIGN KEY (`fk_id_attr`) REFERENCES `ConfigAttrs` (`id_attr`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ConfigValues_ibfk_2` FOREIGN KEY (`fk_id_item`) REFERENCES `ConfigItems` (`id_item`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ConfigValues`
--

LOCK TABLES `ConfigValues` WRITE;
/*!40000 ALTER TABLE `ConfigValues` DISABLE KEYS */;
INSERT INTO `ConfigValues` VALUES ('Default Nagios',1,1),('Linux',12,5),('Windows Server',12,7),('Sun Solaris',12,2528),('HP Unix',12,5254),('Free BSD',12,5255),('Router',12,5256),('Switch',12,5257),('HP Printer',12,5277),('base/linux40.gif',13,5),('base/win40.gif',13,7),('base/sunlogo.gif',13,2528),('base/hpux.gif',13,5254),('base/freebsd40.gif',13,5255),('base/router40.gif',13,5256),('base/switch40.gif',13,5257),('base/hp-printer40.gif',13,5277),('base/linux40.gd2',14,5),('base/win40.gd2',14,7),('base/sunlogo.gd2',14,2528),('base/hpux.gd2',14,5254),('base/freebsd40.gd2',14,5255),('base/router40.gd2',14,5256),('base/switch40.gd2',14,5257),('base/hp-printer40.gd2',14,5277),('24x7',32,5305),('workhours',32,5306),('none',32,5307),('24 Hours A Day, 7 Days A Week',33,5305),('Normal Work Hours',33,5306),('No Time Is A Good Time',33,5307),('00:00-24:00',34,5305),('00:00-24:00',35,5305),('09:00-17:00',35,5306),('00:00-24:00',36,5305),('09:00-17:00',36,5306),('00:00-24:00',37,5305),('09:00-17:00',37,5306),('00:00-24:00',38,5305),('09:00-17:00',38,5306),('00:00-24:00',39,5305),('09:00-17:00',39,5306),('00:00-24:00',40,5305),('admin',47,5333),('admin',48,5333),('d,u,r,f,s',51,5333),('w,u,c,r,f,s',52,5333),('nagios@localhost',55,5333),('',56,5333),('admins',57,5334),('Nagios Administrators',58,5334),('generic-host',73,5732),('user',96,5333),('enabled',97,5333),('service_is_stale',98,5296),('notify-host-by-email',98,5327),('notify-service-by-email',98,5328),('process-host-perfdata',98,5329),('process-service-perfdata',98,5330),('check-host-alive',98,5331),('/usr/lib/nagios/plugins/eventhandlers/stale_service.sh',99,5296),('/usr/bin/printf \"%b\" \"***** Nagios *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\nHost: $HOSTNAME$\\nState: $HOSTSTATE$\\nAddress: $HOSTADDRESS$\\nInfo: $HOSTOUTPUT$\\n\\nDate/Time: $LONGDATETIME$\\n\" | /bin/mail -s \"** $NOTIFICATIONTYPE$ Host Alert: $HOSTNAME$ is $HOSTSTATE$ **\" $CONTACTEMAIL$',99,5327),('/usr/bin/printf \"%b\" \"***** Nagios *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\n\\nService: $SERVICEDESC$\\nHost: $HOSTALIAS$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\n\\nDate/Time: $LONGDATETIME$\\n\\nAdditional Info:\\n\\n$SERVICEOUTPUT$\\n\" | /bin/mail -s \"** $NOTIFICATIONTYPE$ Service Alert: $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$ **\" $CONTACTEMAIL$',99,5328),('/usr/bin/printf \"%b\" \"$LASTHOSTCHECK$\\t$HOSTNAME$\\t$HOSTSTATE$\\t$HOSTATTEMPT$\\t$HOSTSTATETYPE$\\t$HOSTEXECUTIONTIME$\\t$HOSTOUTPUT$\\t$HOSTPERFDATA$\\n\" >> /usr/local/nagios/var/host-perfdata.out',99,5329),('/usr/bin/printf \"%b\" \"$LASTSERVICECHECK$\\t$HOSTNAME$\\t$SERVICEDESC$\\t$SERVICESTATE$\\t$SERVICEATTEMPT$\\t$SERVICESTATETYPE$\\t$SERVICEEXECUTIONTIME$\\t$SERVICELATENCY$\\t$SERVICEOUTPUT$\\t$SERVICEPERFDATA$\\n\" >> /usr/local/nagios/var/service-perfdata.out',99,5330),('$USER1$/check_ping -H $HOSTADDRESS$ -w 3000.0,80% -c 5000.0,100% -p 5',99,5331),('generic-host',108,5335),('0',110,5335),('',116,5335),('',117,5335),('',118,5335),('3',119,5335),('5',120,5335),('2',121,5335),('30',122,5335),('d,u,r,f,s',123,5335),('1',124,5335),('0',125,5335),('1',126,5335),('',127,5335),('',128,5335),('generic-service',129,5348),('0',131,5348),('3',139,5348),('10',140,5348),('2',141,5348),('60',142,5348),('w,u,c,r',143,5348),('1',144,5348),('1',145,5348),('1',146,5348),('0',147,5348),('0',229,5335),('admin',231,5333);
/*!40000 ALTER TABLE `ConfigValues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `History`
--

DROP TABLE IF EXISTS `History`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `History` (
  `id_hist` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_str` varchar(250) NOT NULL,
  `action` enum('created','added','assigned','unassigned','modified','edited','removed','general','module') NOT NULL,
  `attr_name` varchar(80) NOT NULL,
  `attr_value` varchar(1024) DEFAULT NULL,
  `fk_id_item` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id_hist`),
  KEY `fk_id_item` (`fk_id_item`),
  CONSTRAINT `History_ibfk_1` FOREIGN KEY (`fk_id_item`) REFERENCES `ConfigItems` (`id_item`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3008 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `History`
--

LOCK TABLES `History` WRITE;
/*!40000 ALTER TABLE `History` DISABLE KEYS */;
INSERT INTO `History` VALUES (1,'2012-06-02 18:41:05','NConf Setup','general','installed','NConf 1.3.0',NULL),(2,'2012-06-02 18:41:22','admin','removed','service','hplj2605dn: Printer Status',NULL),(3,'2012-06-02 18:41:22','admin','removed','host','hplj2605dn',NULL),(4,'2012-06-02 18:41:22','admin','removed','service','linksys-srw224p: Port 1 Bandwidth Usage',NULL),(5,'2012-06-02 18:41:22','admin','removed','service','linksys-srw224p: Port 1 Link Status',NULL),(6,'2012-06-02 18:41:22','admin','removed','host','linksys-srw224p',NULL),(7,'2012-06-02 18:41:22','admin','removed','service','localhost: Root Partition',NULL),(8,'2012-06-02 18:41:22','admin','removed','host','localhost',NULL),(9,'2012-06-02 18:41:22','admin','removed','service','winserver: W3SVC',NULL),(10,'2012-06-02 18:41:23','admin','removed','host','winserver',NULL),(11,'2012-06-02 18:41:29','admin','removed','hostgroup','linux-servers',NULL),(12,'2012-06-02 18:41:29','admin','removed','hostgroup','network-printers',NULL),(13,'2012-06-02 18:41:29','admin','removed','hostgroup','switches',NULL),(14,'2012-06-02 18:41:29','admin','removed','hostgroup','windows-servers',NULL),(15,'2012-06-02 18:41:36','admin','removed','advanced-service','C: Drive Space',NULL),(16,'2012-06-02 18:41:36','admin','removed','advanced-service','CPU Load',NULL),(17,'2012-06-02 18:41:36','admin','removed','advanced-service','Current Load',NULL),(18,'2012-06-02 18:41:36','admin','removed','advanced-service','Current Users',NULL),(19,'2012-06-02 18:41:36','admin','removed','advanced-service','Explorer',NULL),(20,'2012-06-02 18:41:36','admin','removed','advanced-service','HTTP',NULL),(21,'2012-06-02 18:41:36','admin','removed','advanced-service','Memory Usage',NULL),(22,'2012-06-02 18:41:36','admin','removed','advanced-service','NSClient++ Version',NULL),(23,'2012-06-02 18:41:36','admin','removed','advanced-service','PING',NULL),(24,'2012-06-02 18:41:36','admin','removed','advanced-service','PING interval 10',NULL),(25,'2012-06-02 18:41:36','admin','removed','advanced-service','PING interval 5',NULL),(26,'2012-06-02 18:41:37','admin','removed','advanced-service','SSH',NULL),(27,'2012-06-02 18:41:37','admin','removed','advanced-service','Swap Usage',NULL),(28,'2012-06-02 18:41:37','admin','removed','advanced-service','Total Processes',NULL),(29,'2012-06-02 18:41:37','admin','removed','advanced-service','Uptime SNMP',NULL),(30,'2012-06-02 18:41:37','admin','removed','advanced-service','Uptime Windows',NULL),(31,'2012-06-02 18:41:42','admin','removed','servicegroup','web-services',NULL),(32,'2012-06-02 18:42:09','admin','removed','service-template','Default_collector_server',NULL),(33,'2012-06-02 18:42:09','admin','removed','service-template','Default_monitor_server',NULL),(34,'2012-06-02 18:42:09','admin','removed','service-template','local-service',NULL),(35,'2012-06-03 06:01:33','admin','removed','host-preset','generic-printer',NULL),(36,'2012-06-03 06:01:33','admin','removed','host-preset','generic-switch',NULL),(37,'2012-06-03 06:01:33','admin','removed','host-preset','linux-server',NULL),(38,'2012-06-03 06:01:33','admin','removed','host-preset','windows-server',NULL),(39,'2012-06-03 06:01:57','admin','removed','host-template','Default_collector_server',NULL),(40,'2012-06-03 06:01:57','admin','removed','host-template','Default_monitor_server',NULL),(41,'2012-06-03 06:01:57','admin','removed','host-template','generic-printer',NULL),(42,'2012-06-03 06:01:57','admin','removed','host-template','generic-switch',NULL),(43,'2012-06-03 06:01:57','admin','removed','host-template','linux-server',NULL),(44,'2012-06-03 06:01:57','admin','removed','host-template','windows-server',NULL),(45,'2012-06-03 06:03:38','admin','modified','contact name','admin',5333),(46,'2012-06-03 06:03:39','admin','modified','alias','admin',5333),(47,'2012-06-03 06:03:39','admin','modified','pager / phone nr.','',5333),(48,'2012-06-03 06:03:39','admin','edited','contact','admin',5333),(49,'2012-06-03 09:28:18','Database API','created','checkcommand','check_hp_bladechassis',NULL),(50,'2012-06-03 09:28:18','Database API','added','command_name','check_hp_bladechassis',NULL),(51,'2012-06-03 09:28:18','Database API','added','command_param_count','0',NULL),(52,'2012-06-03 09:28:18','Database API','added','command_line','$PLUGINSDIR$/check_hpasm -H $HOSTADDRESS$ -C $SNMPCOMMUNITY$ -t 60',NULL),(53,'2012-06-03 09:28:18','Database API','added','default_params','!',NULL),(54,'2012-06-03 09:28:18','Database API','created','checkcommand','check_hp_asm',NULL),(55,'2012-06-03 09:28:18','Database API','added','command_name','check_hp_asm',NULL),(56,'2012-06-03 09:28:18','Database API','added','command_param_count','0',NULL),(57,'2012-06-03 09:28:18','Database API','added','command_line','$PLUGINSDIR$/check_hpasm -H $HOSTADDRESS$ -C \"$_HOSTHP_ASM_COMMUNITY$\"',NULL),(58,'2012-06-03 09:28:19','Database API','added','default_params','!',NULL),(59,'2012-06-03 09:28:19','Database API','created','checkcommand','check_exchange_hub_transport_activity',NULL),(60,'2012-06-03 09:28:19','Database API','added','command_name','check_exchange_hub_transport_activity',NULL),(61,'2012-06-03 09:28:19','Database API','added','command_param_count','0',NULL),(62,'2012-06-03 09:28:19','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s HubTransportServer',NULL),(63,'2012-06-03 09:28:19','Database API','added','default_params','!',NULL),(64,'2012-06-03 09:28:19','Database API','created','checkcommand','check_exchange_hub_transport_queues',NULL),(65,'2012-06-03 09:28:19','Database API','added','command_name','check_exchange_hub_transport_queues',NULL),(66,'2012-06-03 09:28:20','Database API','added','command_param_count','0',NULL),(67,'2012-06-03 09:28:20','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s TransportQueues',NULL),(68,'2012-06-03 09:28:20','Database API','added','default_params','!',NULL),(69,'2012-06-03 09:28:20','Database API','created','checkcommand','check_exchange_db_activity',NULL),(70,'2012-06-03 09:28:20','Database API','added','command_name','check_exchange_db_activity',NULL),(71,'2012-06-03 09:28:20','Database API','added','command_param_count','0',NULL),(72,'2012-06-03 09:28:20','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s DBInstances',NULL),(73,'2012-06-03 09:28:20','Database API','added','default_params','!',NULL),(74,'2012-06-03 09:28:20','Database API','created','checkcommand','check_exchange_smtp_receive',NULL),(75,'2012-06-03 09:28:20','Database API','added','command_name','check_exchange_smtp_receive',NULL),(76,'2012-06-03 09:28:20','Database API','added','command_param_count','0',NULL),(77,'2012-06-03 09:28:20','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s SmtpReceive',NULL),(78,'2012-06-03 09:28:20','Database API','added','default_params','!',NULL),(79,'2012-06-03 09:28:20','Database API','created','checkcommand','check_exchange_smtp_send',NULL),(80,'2012-06-03 09:28:20','Database API','added','command_name','check_exchange_smtp_send',NULL),(81,'2012-06-03 09:28:21','Database API','added','command_param_count','0',NULL),(82,'2012-06-03 09:28:21','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s SmtpSend',NULL),(83,'2012-06-03 09:28:21','Database API','added','default_params','!',NULL),(84,'2012-06-03 09:28:21','Database API','created','checkcommand','check_ad_replications',NULL),(85,'2012-06-03 09:28:21','Database API','added','command_name','check_ad_replications',NULL),(86,'2012-06-03 09:28:21','Database API','added','command_param_count','0',NULL),(87,'2012-06-03 09:28:21','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkad -s replication -w 0 --nodatamode',NULL),(88,'2012-06-03 09:28:21','Database API','added','default_params','!',NULL),(89,'2012-06-03 09:28:22','Database API','created','checkcommand','check_iis_transferts_activity',NULL),(90,'2012-06-03 09:28:22','Database API','added','command_name','check_iis_transferts_activity',NULL),(91,'2012-06-03 09:28:22','Database API','added','command_param_count','0',NULL),(92,'2012-06-03 09:28:22','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s transfers -a \'_Total\'',NULL),(93,'2012-06-03 09:28:22','Database API','added','default_params','!',NULL),(94,'2012-06-03 09:28:22','Database API','created','checkcommand','check_iis_requests_activity',NULL),(95,'2012-06-03 09:28:22','Database API','added','command_name','check_iis_requests_activity',NULL),(96,'2012-06-03 09:28:22','Database API','added','command_param_count','0',NULL),(97,'2012-06-03 09:28:22','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s requests -a \'_Total\'',NULL),(98,'2012-06-03 09:28:22','Database API','added','default_params','!',NULL),(99,'2012-06-03 09:28:22','Database API','created','checkcommand','check_iis_errors',NULL),(100,'2012-06-03 09:28:22','Database API','added','command_name','check_iis_errors',NULL),(101,'2012-06-03 09:28:23','Database API','added','command_param_count','0',NULL),(102,'2012-06-03 09:28:23','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s errors -a \'_Total\'',NULL),(103,'2012-06-03 09:28:23','Database API','added','default_params','!',NULL),(104,'2012-06-03 09:28:23','Database API','created','checkcommand','check_iis_users',NULL),(105,'2012-06-03 09:28:23','Database API','added','command_name','check_iis_users',NULL),(106,'2012-06-03 09:28:23','Database API','added','command_param_count','0',NULL),(107,'2012-06-03 09:28:23','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s users -a \'_Total\'',NULL),(108,'2012-06-03 09:28:24','Database API','added','default_params','!',NULL),(109,'2012-06-03 09:28:24','Database API','created','checkcommand','check_iis_connections',NULL),(110,'2012-06-03 09:28:24','Database API','added','command_name','check_iis_connections',NULL),(111,'2012-06-03 09:28:24','Database API','added','command_param_count','0',NULL),(112,'2012-06-03 09:28:24','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s connections -a \'_Total\'',NULL),(113,'2012-06-03 09:28:24','Database API','added','default_params','!',NULL),(114,'2012-06-03 09:28:26','Database API','created','checkcommand','check_oracle_tnsping',NULL),(115,'2012-06-03 09:28:26','Database API','added','command_name','check_oracle_tnsping',NULL),(116,'2012-06-03 09:28:26','Database API','added','command_param_count','1',NULL),(117,'2012-06-03 09:28:26','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tnsping',NULL),(118,'2012-06-03 09:28:26','Database API','added','default_params','!',NULL),(119,'2012-06-03 09:28:26','Database API','created','checkcommand','check_oracle_connection_time',NULL),(120,'2012-06-03 09:28:26','Database API','added','command_name','check_oracle_connection_time',NULL),(121,'2012-06-03 09:28:26','Database API','added','command_param_count','1',NULL),(122,'2012-06-03 09:28:26','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode connection-time',NULL),(123,'2012-06-03 09:28:27','Database API','added','default_params','!',NULL),(124,'2012-06-03 09:28:27','Database API','created','checkcommand','check_oracle_connected_users',NULL),(125,'2012-06-03 09:28:27','Database API','added','command_name','check_oracle_connected_users',NULL),(126,'2012-06-03 09:28:27','Database API','added','command_param_count','1',NULL),(127,'2012-06-03 09:28:27','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode connected-users',NULL),(128,'2012-06-03 09:28:27','Database API','added','default_params','!',NULL),(129,'2012-06-03 09:28:27','Database API','created','checkcommand','check_oracle_session_usage',NULL),(130,'2012-06-03 09:28:27','Database API','added','command_name','check_oracle_session_usage',NULL),(131,'2012-06-03 09:28:27','Database API','added','command_param_count','1',NULL),(132,'2012-06-03 09:28:27','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode session-usage',NULL),(133,'2012-06-03 09:28:27','Database API','added','default_params','!',NULL),(134,'2012-06-03 09:28:27','Database API','created','checkcommand','check_oracle_process_usage',NULL),(135,'2012-06-03 09:28:27','Database API','added','command_name','check_oracle_process_usage',NULL),(136,'2012-06-03 09:28:27','Database API','added','command_param_count','1',NULL),(137,'2012-06-03 09:28:28','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode process-usage',NULL),(138,'2012-06-03 09:28:28','Database API','added','default_params','!',NULL),(139,'2012-06-03 09:28:28','Database API','created','checkcommand','check_oracle_rman_backup_problems',NULL),(140,'2012-06-03 09:28:28','Database API','added','command_name','check_oracle_rman_backup_problems',NULL),(141,'2012-06-03 09:28:28','Database API','added','command_param_count','1',NULL),(142,'2012-06-03 09:28:28','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode rman-backup-problems',NULL),(143,'2012-06-03 09:28:28','Database API','added','default_params','!',NULL),(144,'2012-06-03 09:28:28','Database API','created','checkcommand','check_oracle_sga_data_buffer_hit_ratio',NULL),(145,'2012-06-03 09:28:28','Database API','added','command_name','check_oracle_sga_data_buffer_hit_ratio',NULL),(146,'2012-06-03 09:28:28','Database API','added','command_param_count','1',NULL),(147,'2012-06-03 09:28:28','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-data-buffer-hit-ratio',NULL),(148,'2012-06-03 09:28:28','Database API','added','default_params','!',NULL),(149,'2012-06-03 09:28:29','Database API','created','checkcommand','check_oracle_sga_library_cache_gethit_ratio',NULL),(150,'2012-06-03 09:28:29','Database API','added','command_name','check_oracle_sga_library_cache_gethit_ratio',NULL),(151,'2012-06-03 09:28:29','Database API','added','command_param_count','1',NULL),(152,'2012-06-03 09:28:29','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-gethit-ratio',NULL),(153,'2012-06-03 09:28:29','Database API','added','default_params','!',NULL),(154,'2012-06-03 09:28:29','Database API','created','checkcommand','check_oracle_sga_library_cache_pinhit_ratio',NULL),(155,'2012-06-03 09:28:29','Database API','added','command_name','check_oracle_sga_library_cache_pinhit_ratio',NULL),(156,'2012-06-03 09:28:29','Database API','added','command_param_count','1',NULL),(157,'2012-06-03 09:28:29','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-pinhit-ratio',NULL),(158,'2012-06-03 09:28:29','Database API','added','default_params','!',NULL),(159,'2012-06-03 09:28:29','Database API','created','checkcommand','check_oracle_sga_library_cache_reloads',NULL),(160,'2012-06-03 09:28:29','Database API','added','command_name','check_oracle_sga_library_cache_reloads',NULL),(161,'2012-06-03 09:28:29','Database API','added','command_param_count','1',NULL),(162,'2012-06-03 09:28:29','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-reloads',NULL),(163,'2012-06-03 09:28:29','Database API','added','default_params','!',NULL),(164,'2012-06-03 09:28:30','Database API','created','checkcommand','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(165,'2012-06-03 09:28:30','Database API','added','command_name','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(166,'2012-06-03 09:28:30','Database API','added','command_param_count','1',NULL),(167,'2012-06-03 09:28:30','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-dictionary-cache-hit-ratio',NULL),(168,'2012-06-03 09:28:30','Database API','added','default_params','!',NULL),(169,'2012-06-03 09:28:30','Database API','created','checkcommand','check_oracle_sga_latches_hit_ratio',NULL),(170,'2012-06-03 09:28:30','Database API','added','command_name','check_oracle_sga_latches_hit_ratio',NULL),(171,'2012-06-03 09:28:30','Database API','added','command_param_count','1',NULL),(172,'2012-06-03 09:28:30','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-latches-hit-ratio',NULL),(173,'2012-06-03 09:28:30','Database API','added','default_params','!',NULL),(174,'2012-06-03 09:28:30','Database API','created','checkcommand','check_oracle_sga_shared_pool_reloads',NULL),(175,'2012-06-03 09:28:31','Database API','added','command_name','check_oracle_sga_shared_pool_reloads',NULL),(176,'2012-06-03 09:28:31','Database API','added','command_param_count','1',NULL),(177,'2012-06-03 09:28:31','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-shared-pool-reloads',NULL),(178,'2012-06-03 09:28:31','Database API','added','default_params','!',NULL),(179,'2012-06-03 09:28:31','Database API','created','checkcommand','check_oracle_sga_shared_pool_free',NULL),(180,'2012-06-03 09:28:31','Database API','added','command_name','check_oracle_sga_shared_pool_free',NULL),(181,'2012-06-03 09:28:31','Database API','added','command_param_count','1',NULL),(182,'2012-06-03 09:28:31','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-shared-pool-free',NULL),(183,'2012-06-03 09:28:31','Database API','added','default_params','!',NULL),(184,'2012-06-03 09:28:31','Database API','created','checkcommand','check_oracle_pga_in_memory_sort_ratio',NULL),(185,'2012-06-03 09:28:31','Database API','added','command_name','check_oracle_pga_in_memory_sort_ratio',NULL),(186,'2012-06-03 09:28:32','Database API','added','command_param_count','1',NULL),(187,'2012-06-03 09:28:32','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode pga-in-memory-sort-ratio',NULL),(188,'2012-06-03 09:28:32','Database API','added','default_params','!',NULL),(189,'2012-06-03 09:28:32','Database API','created','checkcommand','check_oracle_invalid_objects',NULL),(190,'2012-06-03 09:28:32','Database API','added','command_name','check_oracle_invalid_objects',NULL),(191,'2012-06-03 09:28:32','Database API','added','command_param_count','1',NULL),(192,'2012-06-03 09:28:32','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode invalid-objects',NULL),(193,'2012-06-03 09:28:32','Database API','added','default_params','!',NULL),(194,'2012-06-03 09:28:32','Database API','created','checkcommand','check_oracle_stale_statistics',NULL),(195,'2012-06-03 09:28:32','Database API','added','command_name','check_oracle_stale_statistics',NULL),(196,'2012-06-03 09:28:32','Database API','added','command_param_count','1',NULL),(197,'2012-06-03 09:28:32','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode stale-statistics',NULL),(198,'2012-06-03 09:28:32','Database API','added','default_params','!',NULL),(199,'2012-06-03 09:28:32','Database API','created','checkcommand','check_oracle_tablespace_usage',NULL),(200,'2012-06-03 09:28:32','Database API','added','command_name','check_oracle_tablespace_usage',NULL),(201,'2012-06-03 09:28:33','Database API','added','command_param_count','1',NULL),(202,'2012-06-03 09:28:33','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-usage',NULL),(203,'2012-06-03 09:28:33','Database API','added','default_params','!',NULL),(204,'2012-06-03 09:28:33','Database API','created','checkcommand','check_oracle_tablespace_free',NULL),(205,'2012-06-03 09:28:33','Database API','added','command_name','check_oracle_tablespace_free',NULL),(206,'2012-06-03 09:28:33','Database API','added','command_param_count','1',NULL),(207,'2012-06-03 09:28:33','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-free',NULL),(208,'2012-06-03 09:28:33','Database API','added','default_params','!',NULL),(209,'2012-06-03 09:28:33','Database API','created','checkcommand','check_oracle_tablespace_fragmentation',NULL),(210,'2012-06-03 09:28:33','Database API','added','command_name','check_oracle_tablespace_fragmentation',NULL),(211,'2012-06-03 09:28:33','Database API','added','command_param_count','1',NULL),(212,'2012-06-03 09:28:33','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-fragmentation',NULL),(213,'2012-06-03 09:28:34','Database API','added','default_params','!',NULL),(214,'2012-06-03 09:28:34','Database API','created','checkcommand','check_oracle_tablespace_io_balanc',NULL),(215,'2012-06-03 09:28:34','Database API','added','command_name','check_oracle_tablespace_io_balanc',NULL),(216,'2012-06-03 09:28:34','Database API','added','command_param_count','1',NULL),(217,'2012-06-03 09:28:34','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-io-balanc',NULL),(218,'2012-06-03 09:28:34','Database API','added','default_params','!',NULL),(219,'2012-06-03 09:28:34','Database API','created','checkcommand','check_oracle_tablespace_remaining_time',NULL),(220,'2012-06-03 09:28:35','Database API','added','command_name','check_oracle_tablespace_remaining_time',NULL),(221,'2012-06-03 09:28:35','Database API','added','command_param_count','1',NULL),(222,'2012-06-03 09:28:35','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-remaining-time',NULL),(223,'2012-06-03 09:28:35','Database API','added','default_params','!',NULL),(224,'2012-06-03 09:28:35','Database API','created','checkcommand','check_oracle_tablespace_can_allocate_next',NULL),(225,'2012-06-03 09:28:35','Database API','added','command_name','check_oracle_tablespace_can_allocate_next',NULL),(226,'2012-06-03 09:28:35','Database API','added','command_param_count','1',NULL),(227,'2012-06-03 09:28:35','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-can-allocate-next',NULL),(228,'2012-06-03 09:28:35','Database API','added','default_params','!',NULL),(229,'2012-06-03 09:28:35','Database API','created','checkcommand','check_oracle_flash_recovery_area_usage',NULL),(230,'2012-06-03 09:28:35','Database API','added','command_name','check_oracle_flash_recovery_area_usage',NULL),(231,'2012-06-03 09:28:35','Database API','added','command_param_count','1',NULL),(232,'2012-06-03 09:28:35','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode flash-recovery-area-usage',NULL),(233,'2012-06-03 09:28:36','Database API','added','default_params','!',NULL),(234,'2012-06-03 09:28:36','Database API','created','checkcommand','check_oracle_flash_recovery_area_free',NULL),(235,'2012-06-03 09:28:36','Database API','added','command_name','check_oracle_flash_recovery_area_free',NULL),(236,'2012-06-03 09:28:36','Database API','added','command_param_count','1',NULL),(237,'2012-06-03 09:28:36','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode flash-recovery-area-free',NULL),(238,'2012-06-03 09:28:36','Database API','added','default_params','!',NULL),(239,'2012-06-03 09:28:36','Database API','created','checkcommand','check_oracle_datafile_io_traffic',NULL),(240,'2012-06-03 09:28:36','Database API','added','command_name','check_oracle_datafile_io_traffic',NULL),(241,'2012-06-03 09:28:36','Database API','added','command_param_count','1',NULL),(242,'2012-06-03 09:28:36','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode datafile-io-traffic',NULL),(243,'2012-06-03 09:28:36','Database API','added','default_params','!',NULL),(244,'2012-06-03 09:28:36','Database API','created','checkcommand','check_oracle_datafiles_existing',NULL),(245,'2012-06-03 09:28:36','Database API','added','command_name','check_oracle_datafiles_existing',NULL),(246,'2012-06-03 09:28:37','Database API','added','command_param_count','1',NULL),(247,'2012-06-03 09:28:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode datafiles-existing',NULL),(248,'2012-06-03 09:28:37','Database API','added','default_params','!',NULL),(249,'2012-06-03 09:28:37','Database API','created','checkcommand','check_oracle_soft_parse_ratio',NULL),(250,'2012-06-03 09:28:37','Database API','added','command_name','check_oracle_soft_parse_ratio',NULL),(251,'2012-06-03 09:28:37','Database API','added','command_param_count','1',NULL),(252,'2012-06-03 09:28:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode soft-parse-ratio',NULL),(253,'2012-06-03 09:28:37','Database API','added','default_params','!',NULL),(254,'2012-06-03 09:28:37','Database API','created','checkcommand','check_oracle_switch_interval',NULL),(255,'2012-06-03 09:28:37','Database API','added','command_name','check_oracle_switch_interval',NULL),(256,'2012-06-03 09:28:37','Database API','added','command_param_count','1',NULL),(257,'2012-06-03 09:28:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode switch-interval',NULL),(258,'2012-06-03 09:28:38','Database API','added','default_params','!',NULL),(259,'2012-06-03 09:28:38','Database API','created','checkcommand','check_oracle_retry_ratio',NULL),(260,'2012-06-03 09:28:38','Database API','added','command_name','check_oracle_retry_ratio',NULL),(261,'2012-06-03 09:28:38','Database API','added','command_param_count','1',NULL),(262,'2012-06-03 09:28:38','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode retry-ratio',NULL),(263,'2012-06-03 09:28:38','Database API','added','default_params','!',NULL),(264,'2012-06-03 09:28:38','Database API','created','checkcommand','check_oracle_redo_io_traffic',NULL),(265,'2012-06-03 09:28:38','Database API','added','command_name','check_oracle_redo_io_traffic',NULL),(266,'2012-06-03 09:28:38','Database API','added','command_param_count','1',NULL),(267,'2012-06-03 09:28:38','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode redo-io-traffic',NULL),(268,'2012-06-03 09:28:38','Database API','added','default_params','!',NULL),(269,'2012-06-03 09:28:38','Database API','created','checkcommand','check_oracle_roll_header_contention',NULL),(270,'2012-06-03 09:28:39','Database API','added','command_name','check_oracle_roll_header_contention',NULL),(271,'2012-06-03 09:28:39','Database API','added','command_param_count','1',NULL),(272,'2012-06-03 09:28:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-header-contention',NULL),(273,'2012-06-03 09:28:39','Database API','added','default_params','!',NULL),(274,'2012-06-03 09:28:39','Database API','created','checkcommand','check_oracle_roll_block_contention',NULL),(275,'2012-06-03 09:28:39','Database API','added','command_name','check_oracle_roll_block_contention',NULL),(276,'2012-06-03 09:28:39','Database API','added','command_param_count','1',NULL),(277,'2012-06-03 09:28:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-block-contention',NULL),(278,'2012-06-03 09:28:39','Database API','added','default_params','!',NULL),(279,'2012-06-03 09:28:39','Database API','created','checkcommand','check_oracle_roll_hit_ratio',NULL),(280,'2012-06-03 09:28:39','Database API','added','command_name','check_oracle_roll_hit_ratio',NULL),(281,'2012-06-03 09:28:39','Database API','added','command_param_count','1',NULL),(282,'2012-06-03 09:28:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-hit-ratio',NULL),(283,'2012-06-03 09:28:40','Database API','added','default_params','!',NULL),(284,'2012-06-03 09:28:40','Database API','created','checkcommand','check_oracle_roll_extends',NULL),(285,'2012-06-03 09:28:40','Database API','added','command_name','check_oracle_roll_extends',NULL),(286,'2012-06-03 09:28:40','Database API','added','command_param_count','1',NULL),(287,'2012-06-03 09:28:40','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-extends',NULL),(288,'2012-06-03 09:28:40','Database API','added','default_params','!',NULL),(289,'2012-06-03 09:28:40','Database API','created','checkcommand','check_oracle_roll_wraps',NULL),(290,'2012-06-03 09:28:40','Database API','added','command_name','check_oracle_roll_wraps',NULL),(291,'2012-06-03 09:28:40','Database API','added','command_param_count','1',NULL),(292,'2012-06-03 09:28:40','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-wraps',NULL),(293,'2012-06-03 09:28:40','Database API','added','default_params','!',NULL),(294,'2012-06-03 09:28:40','Database API','created','checkcommand','check_oracle_seg_top10_logical_reads',NULL),(295,'2012-06-03 09:28:41','Database API','added','command_name','check_oracle_seg_top10_logical_reads',NULL),(296,'2012-06-03 09:28:41','Database API','added','command_param_count','1',NULL),(297,'2012-06-03 09:28:41','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-logical-reads',NULL),(298,'2012-06-03 09:28:41','Database API','added','default_params','!',NULL),(299,'2012-06-03 09:28:41','Database API','created','checkcommand','check_oracle_seg_top10_physical_reads',NULL),(300,'2012-06-03 09:28:41','Database API','added','command_name','check_oracle_seg_top10_physical_reads',NULL),(301,'2012-06-03 09:28:41','Database API','added','command_param_count','1',NULL),(302,'2012-06-03 09:28:41','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-physical-reads',NULL),(303,'2012-06-03 09:28:41','Database API','added','default_params','!',NULL),(304,'2012-06-03 09:28:41','Database API','created','checkcommand','check_oracle_seg_top10_buffer_busy_waits',NULL),(305,'2012-06-03 09:28:41','Database API','added','command_name','check_oracle_seg_top10_buffer_busy_waits',NULL),(306,'2012-06-03 09:28:41','Database API','added','command_param_count','1',NULL),(307,'2012-06-03 09:28:41','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-buffer-busy-waits',NULL),(308,'2012-06-03 09:28:42','Database API','added','default_params','!',NULL),(309,'2012-06-03 09:28:42','Database API','created','checkcommand','check_oracle_seg_top10_row_lock_waits',NULL),(310,'2012-06-03 09:28:42','Database API','added','command_name','check_oracle_seg_top10_row_lock_waits',NULL),(311,'2012-06-03 09:28:42','Database API','added','command_param_count','1',NULL),(312,'2012-06-03 09:28:42','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-row-lock-waits',NULL),(313,'2012-06-03 09:28:42','Database API','added','default_params','!',NULL),(314,'2012-06-03 09:28:42','Database API','created','checkcommand','check_oracle_event_waits',NULL),(315,'2012-06-03 09:28:42','Database API','added','command_name','check_oracle_event_waits',NULL),(316,'2012-06-03 09:28:42','Database API','added','command_param_count','1',NULL),(317,'2012-06-03 09:28:42','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode event-waits',NULL),(318,'2012-06-03 09:28:42','Database API','added','default_params','!',NULL),(319,'2012-06-03 09:28:43','Database API','created','checkcommand','check_oracle_event_waiting',NULL),(320,'2012-06-03 09:28:43','Database API','added','command_name','check_oracle_event_waiting',NULL),(321,'2012-06-03 09:28:43','Database API','added','command_param_count','1',NULL),(322,'2012-06-03 09:28:43','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode event-waiting',NULL),(323,'2012-06-03 09:28:43','Database API','added','default_params','!',NULL),(324,'2012-06-03 09:28:43','Database API','created','checkcommand','check_oracle_enqueue_contention',NULL),(325,'2012-06-03 09:28:43','Database API','added','command_name','check_oracle_enqueue_contention',NULL),(326,'2012-06-03 09:28:43','Database API','added','command_param_count','1',NULL),(327,'2012-06-03 09:28:43','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode enqueue-contention',NULL),(328,'2012-06-03 09:28:43','Database API','added','default_params','!',NULL),(329,'2012-06-03 09:28:43','Database API','created','checkcommand','check_oracle_enqueue_waiting',NULL),(330,'2012-06-03 09:28:43','Database API','added','command_name','check_oracle_enqueue_waiting',NULL),(331,'2012-06-03 09:28:44','Database API','added','command_param_count','1',NULL),(332,'2012-06-03 09:28:44','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode enqueue-waiting',NULL),(333,'2012-06-03 09:28:44','Database API','added','default_params','!',NULL),(334,'2012-06-03 09:28:44','Database API','created','checkcommand','check_oracle_latch_contention',NULL),(335,'2012-06-03 09:28:44','Database API','added','command_name','check_oracle_latch_contention',NULL),(336,'2012-06-03 09:28:44','Database API','added','command_param_count','1',NULL),(337,'2012-06-03 09:28:44','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode latch-contention',NULL),(338,'2012-06-03 09:28:44','Database API','added','default_params','!',NULL),(339,'2012-06-03 09:28:44','Database API','created','checkcommand','check_oracle_latch_waiting',NULL),(340,'2012-06-03 09:28:44','Database API','added','command_name','check_oracle_latch_waiting',NULL),(341,'2012-06-03 09:28:44','Database API','added','command_param_count','1',NULL),(342,'2012-06-03 09:28:45','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode latch-waiting',NULL),(343,'2012-06-03 09:28:45','Database API','added','default_params','!',NULL),(344,'2012-06-03 09:28:45','Database API','created','checkcommand','check_oracle_sysstat',NULL),(345,'2012-06-03 09:28:45','Database API','added','command_name','check_oracle_sysstat',NULL),(346,'2012-06-03 09:28:45','Database API','added','command_param_count','1',NULL),(347,'2012-06-03 09:28:45','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sysstat',NULL),(348,'2012-06-03 09:28:45','Database API','added','default_params','!',NULL),(349,'2012-06-03 09:28:46','Database API','created','checkcommand','check_mongodb_connection',NULL),(350,'2012-06-03 09:28:46','Database API','added','command_name','check_mongodb_connection',NULL),(351,'2012-06-03 09:28:46','Database API','added','command_param_count','0',NULL),(352,'2012-06-03 09:28:46','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A connect -W 2 -c 4',NULL),(353,'2012-06-03 09:28:46','Database API','added','default_params','!',NULL),(354,'2012-06-03 09:28:46','Database API','created','checkcommand','check_mongodb_open_connections',NULL),(355,'2012-06-03 09:28:46','Database API','added','command_name','check_mongodb_open_connections',NULL),(356,'2012-06-03 09:28:47','Database API','added','command_param_count','0',NULL),(357,'2012-06-03 09:28:47','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A connections -W 70 -c 80',NULL),(358,'2012-06-03 09:28:47','Database API','added','default_params','!',NULL),(359,'2012-06-03 09:28:47','Database API','created','checkcommand','check_mongodb_replication_lag',NULL),(360,'2012-06-03 09:28:47','Database API','added','command_name','check_mongodb_replication_lag',NULL),(361,'2012-06-03 09:28:47','Database API','added','command_param_count','0',NULL),(362,'2012-06-03 09:28:47','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A replication_lag -W 15 -c 30',NULL),(363,'2012-06-03 09:28:47','Database API','added','default_params','!',NULL),(364,'2012-06-03 09:28:47','Database API','created','checkcommand','check_mongodb_lock_time',NULL),(365,'2012-06-03 09:28:47','Database API','added','command_name','check_mongodb_lock_time',NULL),(366,'2012-06-03 09:28:47','Database API','added','command_param_count','0',NULL),(367,'2012-06-03 09:28:47','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A lock -W 5 -c 10',NULL),(368,'2012-06-03 09:28:48','Database API','added','default_params','!',NULL),(369,'2012-06-03 09:28:48','Database API','created','checkcommand','check_mongodb_flush_time',NULL),(370,'2012-06-03 09:28:48','Database API','added','command_name','check_mongodb_flush_time',NULL),(371,'2012-06-03 09:28:48','Database API','added','command_param_count','0',NULL),(372,'2012-06-03 09:28:48','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A flushing -W 100 -c 200',NULL),(373,'2012-06-03 09:28:48','Database API','added','default_params','!',NULL),(374,'2012-06-03 09:28:48','Database API','created','checkcommand','check_mongodb_last_flush',NULL),(375,'2012-06-03 09:28:48','Database API','added','command_name','check_mongodb_last_flush',NULL),(376,'2012-06-03 09:28:48','Database API','added','command_param_count','0',NULL),(377,'2012-06-03 09:28:48','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A last_flush_time -W 200 -c 400',NULL),(378,'2012-06-03 09:28:49','Database API','added','default_params','!',NULL),(379,'2012-06-03 09:28:49','Database API','created','checkcommand','check_mongodb_replicaset',NULL),(380,'2012-06-03 09:28:49','Database API','added','command_name','check_mongodb_replicaset',NULL),(381,'2012-06-03 09:28:49','Database API','added','command_param_count','0',NULL),(382,'2012-06-03 09:28:49','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A replset_state -W 0 -c 0',NULL),(383,'2012-06-03 09:28:49','Database API','added','default_params','!',NULL),(384,'2012-06-03 09:28:49','Database API','created','checkcommand','check_mongodb_index_miss_ratio',NULL),(385,'2012-06-03 09:28:49','Database API','added','command_name','check_mongodb_index_miss_ratio',NULL),(386,'2012-06-03 09:28:49','Database API','added','command_param_count','0',NULL),(387,'2012-06-03 09:28:49','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A index_miss_ration -W .005 -c .01',NULL),(388,'2012-06-03 09:28:49','Database API','added','default_params','!',NULL),(389,'2012-06-03 09:28:50','Database API','created','checkcommand','check_mysql_connection',NULL),(390,'2012-06-03 09:28:50','Database API','added','command_name','check_mysql_connection',NULL),(391,'2012-06-03 09:28:50','Database API','added','command_param_count','0',NULL),(392,'2012-06-03 09:28:51','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode connection-time --warning $_HOSTCONNECTIONTIME_WARN$ --critical $_HOSTCONNECTIONTIME_CRIT$',NULL),(393,'2012-06-03 09:28:51','Database API','added','default_params','!',NULL),(394,'2012-06-03 09:28:51','Database API','created','checkcommand','check_mysql_querycache_hitrate',NULL),(395,'2012-06-03 09:28:51','Database API','added','command_name','check_mysql_querycache_hitrate',NULL),(396,'2012-06-03 09:28:51','Database API','added','command_param_count','0',NULL),(397,'2012-06-03 09:28:51','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode querycache-hitrate --warning $_HOSTQUERYCACHEHITRATE_WARN$ --critical $_HOSTQUERYCACHEHITRATE_CRIT$',NULL),(398,'2012-06-03 09:28:51','Database API','added','default_params','!',NULL),(399,'2012-06-03 09:28:51','Database API','created','checkcommand','check_mysql_uptime',NULL),(400,'2012-06-03 09:28:51','Database API','added','command_name','check_mysql_uptime',NULL),(401,'2012-06-03 09:28:51','Database API','added','command_param_count','0',NULL),(402,'2012-06-03 09:28:52','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode uptime',NULL),(403,'2012-06-03 09:28:52','Database API','added','default_params','!',NULL),(404,'2012-06-03 09:28:52','Database API','created','checkcommand','check_mysql_threads_connected',NULL),(405,'2012-06-03 09:28:52','Database API','added','command_name','check_mysql_threads_connected',NULL),(406,'2012-06-03 09:28:52','Database API','added','command_param_count','0',NULL),(407,'2012-06-03 09:28:52','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode threads-connected --warning $_HOSTTHREADSCONNECTED_WARN$ --critical $_HOSTTHREADSCONNECTED_CRIT$',NULL),(408,'2012-06-03 09:28:52','Database API','added','default_params','!',NULL),(409,'2012-06-03 09:28:52','Database API','created','checkcommand','check_mysql_qcache_hitrate',NULL),(410,'2012-06-03 09:28:52','Database API','added','command_name','check_mysql_qcache_hitrate',NULL),(411,'2012-06-03 09:28:52','Database API','added','command_param_count','0',NULL),(412,'2012-06-03 09:28:52','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode qcache-hitrate --warning $_HOSTQCACHEHITRATE_WARN$ --critical $_HOSTQCACHEHITRATE_CRIT$',NULL),(413,'2012-06-03 09:28:52','Database API','added','default_params','!',NULL),(414,'2012-06-03 09:28:52','Database API','created','checkcommand','check_mysql_qcache_lowmem_prunes',NULL),(415,'2012-06-03 09:28:53','Database API','added','command_name','check_mysql_qcache_lowmem_prunes',NULL),(416,'2012-06-03 09:28:53','Database API','added','command_param_count','0',NULL),(417,'2012-06-03 09:28:53','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode qcache-lowmem-prunes --warning $_HOSTQCACHELOWMEMPRUNES_WARN$ --critical $_HOSTQCACHELOWMEMPRUNES_CRIT$',NULL),(418,'2012-06-03 09:28:53','Database API','added','default_params','!',NULL),(419,'2012-06-03 09:28:53','Database API','created','checkcommand','check_mysql_keycache_hitrate',NULL),(420,'2012-06-03 09:28:53','Database API','added','command_name','check_mysql_keycache_hitrate',NULL),(421,'2012-06-03 09:28:53','Database API','added','command_param_count','0',NULL),(422,'2012-06-03 09:28:53','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode keycache-hitrate --warning $_HOSTKEYCACHEHITRATE_WARN$ --critical $_HOSTKEYCACHEHITRATE_CRIT$',NULL),(423,'2012-06-03 09:28:53','Database API','added','default_params','!',NULL),(424,'2012-06-03 09:28:53','Database API','created','checkcommand','check_mysql_bufferpool_hitrate',NULL),(425,'2012-06-03 09:28:53','Database API','added','command_name','check_mysql_bufferpool_hitrate',NULL),(426,'2012-06-03 09:28:53','Database API','added','command_param_count','0',NULL),(427,'2012-06-03 09:28:53','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode bufferpool-hitrate --warning $_HOSTBUFFERPOOLHITRATE_WARN$ --critical $_HOSTBUFFERPOOLHITRATE_CRIT$',NULL),(428,'2012-06-03 09:28:53','Database API','added','default_params','!',NULL),(429,'2012-06-03 09:28:54','Database API','created','checkcommand','check_mysql_bufferpool_wait_free',NULL),(430,'2012-06-03 09:28:54','Database API','added','command_name','check_mysql_bufferpool_wait_free',NULL),(431,'2012-06-03 09:28:54','Database API','added','command_param_count','0',NULL),(432,'2012-06-03 09:28:54','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode bufferpool-wait-free --warning $_HOSTBUFFERPOOLWAITFREE_WARN$ --critical $_HOSTBUFFERPOOLWAITFREE_CRIT$',NULL),(433,'2012-06-03 09:28:54','Database API','added','default_params','!',NULL),(434,'2012-06-03 09:28:54','Database API','created','checkcommand','check_mysql_log_waits',NULL),(435,'2012-06-03 09:28:54','Database API','added','command_name','check_mysql_log_waits',NULL),(436,'2012-06-03 09:28:54','Database API','added','command_param_count','0',NULL),(437,'2012-06-03 09:28:54','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode log-waits --warning $_HOSTLOGWAITS_WARN$ --critical $_HOSTLOGWAITS_CRIT$',NULL),(438,'2012-06-03 09:28:54','Database API','added','default_params','!',NULL),(439,'2012-06-03 09:28:54','Database API','created','checkcommand','check_mysql_tablecache_hitrate',NULL),(440,'2012-06-03 09:28:54','Database API','added','command_name','check_mysql_tablecache_hitrate',NULL),(441,'2012-06-03 09:28:55','Database API','added','command_param_count','0',NULL),(442,'2012-06-03 09:28:55','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode tablecache-hitrate --warning $_HOSTTABLECACHEHITRATE_WARN$ --critical $_HOSTTABLECACHEHITRATE_CRIT$',NULL),(443,'2012-06-03 09:28:55','Database API','added','default_params','!',NULL),(444,'2012-06-03 09:28:55','Database API','created','checkcommand','check_mysql_table_lock_contention',NULL),(445,'2012-06-03 09:28:55','Database API','added','command_name','check_mysql_table_lock_contention',NULL),(446,'2012-06-03 09:28:55','Database API','added','command_param_count','0',NULL),(447,'2012-06-03 09:28:55','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode table-lock-contention --warning $_HOSTTABLELOCKCONTENTION_WARN$ --critical $_HOSTTABLELOCKCONTENTION_CRIT$',NULL),(448,'2012-06-03 09:28:56','Database API','added','default_params','!',NULL),(449,'2012-06-03 09:28:56','Database API','created','checkcommand','check_mysql_index_usage',NULL),(450,'2012-06-03 09:28:56','Database API','added','command_name','check_mysql_index_usage',NULL),(451,'2012-06-03 09:28:56','Database API','added','command_param_count','0',NULL),(452,'2012-06-03 09:28:56','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode index-usage --warning $_HOSTINDEXUSAGE_WARN$ --critical $_HOSTINDEXUSAGE_CRIT$',NULL),(453,'2012-06-03 09:28:56','Database API','added','default_params','!',NULL),(454,'2012-06-03 09:28:56','Database API','created','checkcommand','check_mysql_tmp_disk_tables',NULL),(455,'2012-06-03 09:28:56','Database API','added','command_name','check_mysql_tmp_disk_tables',NULL),(456,'2012-06-03 09:28:56','Database API','added','command_param_count','0',NULL),(457,'2012-06-03 09:28:56','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode tmp-disk-tables --warning $_HOSTTMPDISKTABLES_WARN$ --critical $_HOSTTMPDISKTABLES_CRIT$',NULL),(458,'2012-06-03 09:28:56','Database API','added','default_params','!',NULL),(459,'2012-06-03 09:28:56','Database API','created','checkcommand','check_mysql_slow_queries',NULL),(460,'2012-06-03 09:28:56','Database API','added','command_name','check_mysql_slow_queries',NULL),(461,'2012-06-03 09:28:56','Database API','added','command_param_count','0',NULL),(462,'2012-06-03 09:28:57','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slow-queries --warning $_HOSTSLOWQUERIES_WARN$ --critical $_HOSTSLOWQUERIES_CRIT$',NULL),(463,'2012-06-03 09:28:57','Database API','added','default_params','!',NULL),(464,'2012-06-03 09:28:57','Database API','created','checkcommand','check_mysql_long_running_procs',NULL),(465,'2012-06-03 09:28:57','Database API','added','command_name','check_mysql_long_running_procs',NULL),(466,'2012-06-03 09:28:57','Database API','added','command_param_count','0',NULL),(467,'2012-06-03 09:28:57','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode long-running-procs --warning $_HOSTLONGRUNNINGPROCS_WARN$ --critical $_HOSTLONGRUNNINGPROCS_CRIT$',NULL),(468,'2012-06-03 09:28:57','Database API','added','default_params','!',NULL),(469,'2012-06-03 09:28:57','Database API','created','checkcommand','check_mysql_slave_lag',NULL),(470,'2012-06-03 09:28:57','Database API','added','command_name','check_mysql_slave_lag',NULL),(471,'2012-06-03 09:28:57','Database API','added','command_param_count','0',NULL),(472,'2012-06-03 09:28:57','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-lag --warning $_HOSTSLAVELAG_WARN$ --critical $_HOSTSLAVELAG_CRIT$',NULL),(473,'2012-06-03 09:28:58','Database API','added','default_params','!',NULL),(474,'2012-06-03 09:28:58','Database API','created','checkcommand','check_mysql_slave_io_running',NULL),(475,'2012-06-03 09:28:58','Database API','added','command_name','check_mysql_slave_io_running',NULL),(476,'2012-06-03 09:28:58','Database API','added','command_param_count','0',NULL),(477,'2012-06-03 09:28:58','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-io-running',NULL),(478,'2012-06-03 09:28:58','Database API','added','default_params','!',NULL),(479,'2012-06-03 09:28:58','Database API','created','checkcommand','check_mysql_slave_sql_running',NULL),(480,'2012-06-03 09:28:58','Database API','added','command_name','check_mysql_slave_sql_running',NULL),(481,'2012-06-03 09:28:58','Database API','added','command_param_count','0',NULL),(482,'2012-06-03 09:28:58','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-sql-running',NULL),(483,'2012-06-03 09:28:58','Database API','added','default_params','!',NULL),(484,'2012-06-03 09:28:58','Database API','created','checkcommand','check_mysql_open_files',NULL),(485,'2012-06-03 09:28:58','Database API','added','command_name','check_mysql_open_files',NULL),(486,'2012-06-03 09:28:58','Database API','added','command_param_count','0',NULL),(487,'2012-06-03 09:28:59','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode open-files --warning $_HOSTOPENFILES_WARN$ --critical $_HOSTOPENFILES_CRIT$',NULL),(488,'2012-06-03 09:28:59','Database API','added','default_params','!',NULL),(489,'2012-06-03 09:28:59','Database API','created','checkcommand','check_mysql_cluster_ndb_running',NULL),(490,'2012-06-03 09:28:59','Database API','added','command_name','check_mysql_cluster_ndb_running',NULL),(491,'2012-06-03 09:28:59','Database API','added','command_param_count','0',NULL),(492,'2012-06-03 09:28:59','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode cluster-ndb-running',NULL),(493,'2012-06-03 09:28:59','Database API','added','default_params','!',NULL),(494,'2012-06-03 09:28:59','Database API','created','checkcommand','check_mysql_threadcache_hitrate',NULL),(495,'2012-06-03 09:28:59','Database API','added','command_name','check_mysql_threadcache_hitrate',NULL),(496,'2012-06-03 09:28:59','Database API','added','command_param_count','0',NULL),(497,'2012-06-03 09:29:00','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode threadcache-hitrate --warning $_HOSTTHREADCACHE_WARN$ --critical $_HOSTTHREADCACHE_CRIT$',NULL),(498,'2012-06-03 09:29:00','Database API','added','default_params','!',NULL),(499,'2012-06-03 09:29:01','Database API','created','checkcommand','check_mssql_connection',NULL),(500,'2012-06-03 09:29:01','Database API','added','command_name','check_mssql_connection',NULL),(501,'2012-06-03 09:29:01','Database API','added','command_param_count','0',NULL),(502,'2012-06-03 09:29:01','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode connection-time',NULL),(503,'2012-06-03 09:29:01','Database API','added','default_params','!',NULL),(504,'2012-06-03 09:29:01','Database API','created','checkcommand','check_mssql_connected_users',NULL),(505,'2012-06-03 09:29:01','Database API','added','command_name','check_mssql_connected_users',NULL),(506,'2012-06-03 09:29:01','Database API','added','command_param_count','0',NULL),(507,'2012-06-03 09:29:01','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode connected-users',NULL),(508,'2012-06-03 09:29:01','Database API','added','default_params','!',NULL),(509,'2012-06-03 09:29:01','Database API','created','checkcommand','check_mssql_cpu_busy',NULL),(510,'2012-06-03 09:29:01','Database API','added','command_name','check_mssql_cpu_busy',NULL),(511,'2012-06-03 09:29:02','Database API','added','command_param_count','0',NULL),(512,'2012-06-03 09:29:02','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode cpu-busy',NULL),(513,'2012-06-03 09:29:02','Database API','added','default_params','!',NULL),(514,'2012-06-03 09:29:02','Database API','created','checkcommand','check_mssql_io_busy',NULL),(515,'2012-06-03 09:29:02','Database API','added','command_name','check_mssql_io_busy',NULL),(516,'2012-06-03 09:29:02','Database API','added','command_param_count','0',NULL),(517,'2012-06-03 09:29:02','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode io-busy',NULL),(518,'2012-06-03 09:29:02','Database API','added','default_params','!',NULL),(519,'2012-06-03 09:29:02','Database API','created','checkcommand','check_mssql_full_scans',NULL),(520,'2012-06-03 09:29:02','Database API','added','command_name','check_mssql_full_scans',NULL),(521,'2012-06-03 09:29:02','Database API','added','command_param_count','0',NULL),(522,'2012-06-03 09:29:02','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode full-scans',NULL),(523,'2012-06-03 09:29:03','Database API','added','default_params','!',NULL),(524,'2012-06-03 09:29:03','Database API','created','checkcommand','check_mssql_transactions',NULL),(525,'2012-06-03 09:29:03','Database API','added','command_name','check_mssql_transactions',NULL),(526,'2012-06-03 09:29:03','Database API','added','command_param_count','0',NULL),(527,'2012-06-03 09:29:03','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode transactions',NULL),(528,'2012-06-03 09:29:03','Database API','added','default_params','!',NULL),(529,'2012-06-03 09:29:03','Database API','created','checkcommand','check_mssql_batch_requests',NULL),(530,'2012-06-03 09:29:03','Database API','added','command_name','check_mssql_batch_requests',NULL),(531,'2012-06-03 09:29:03','Database API','added','command_param_count','0',NULL),(532,'2012-06-03 09:29:03','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode batch-requests',NULL),(533,'2012-06-03 09:29:03','Database API','added','default_params','!',NULL),(534,'2012-06-03 09:29:03','Database API','created','checkcommand','check_mssql_latches_waits',NULL),(535,'2012-06-03 09:29:03','Database API','added','command_name','check_mssql_latches_waits',NULL),(536,'2012-06-03 09:29:03','Database API','added','command_param_count','0',NULL),(537,'2012-06-03 09:29:04','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode latches-waits',NULL),(538,'2012-06-03 09:29:04','Database API','added','default_params','!',NULL),(539,'2012-06-03 09:29:04','Database API','created','checkcommand','check_mssql_latches_wait_time',NULL),(540,'2012-06-03 09:29:04','Database API','added','command_name','check_mssql_latches_wait_time',NULL),(541,'2012-06-03 09:29:04','Database API','added','command_param_count','0',NULL),(542,'2012-06-03 09:29:04','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode latches-wait-time',NULL),(543,'2012-06-03 09:29:04','Database API','added','default_params','!',NULL),(544,'2012-06-03 09:29:04','Database API','created','checkcommand','check_mssql_locks_waits',NULL),(545,'2012-06-03 09:29:04','Database API','added','command_name','check_mssql_locks_waits',NULL),(546,'2012-06-03 09:29:04','Database API','added','command_param_count','0',NULL),(547,'2012-06-03 09:29:04','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-waits',NULL),(548,'2012-06-03 09:29:04','Database API','added','default_params','!',NULL),(549,'2012-06-03 09:29:05','Database API','created','checkcommand','check_mssql_locks_timeouts',NULL),(550,'2012-06-03 09:29:05','Database API','added','command_name','check_mssql_locks_timeouts',NULL),(551,'2012-06-03 09:29:05','Database API','added','command_param_count','0',NULL),(552,'2012-06-03 09:29:05','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-timeouts',NULL),(553,'2012-06-03 09:29:05','Database API','added','default_params','!',NULL),(554,'2012-06-03 09:29:05','Database API','created','checkcommand','check_mssql_locks_deadlocks',NULL),(555,'2012-06-03 09:29:05','Database API','added','command_name','check_mssql_locks_deadlocks',NULL),(556,'2012-06-03 09:29:05','Database API','added','command_param_count','0',NULL),(557,'2012-06-03 09:29:06','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-deadlocks',NULL),(558,'2012-06-03 09:29:06','Database API','added','default_params','!',NULL),(559,'2012-06-03 09:29:06','Database API','created','checkcommand','check_mssql_sql_recompilations',NULL),(560,'2012-06-03 09:29:06','Database API','added','command_name','check_mssql_sql_recompilations',NULL),(561,'2012-06-03 09:29:06','Database API','added','command_param_count','0',NULL),(562,'2012-06-03 09:29:06','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode sql-recompilations',NULL),(563,'2012-06-03 09:29:06','Database API','added','default_params','!',NULL),(564,'2012-06-03 09:29:06','Database API','created','checkcommand','check_mssql_sql_initcompilations',NULL),(565,'2012-06-03 09:29:07','Database API','added','command_name','check_mssql_sql_initcompilations',NULL),(566,'2012-06-03 09:29:07','Database API','added','command_param_count','0',NULL),(567,'2012-06-03 09:29:07','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode sql-initcompilations',NULL),(568,'2012-06-03 09:29:07','Database API','added','default_params','!',NULL),(569,'2012-06-03 09:29:07','Database API','created','checkcommand','check_mssql_total_server_memory',NULL),(570,'2012-06-03 09:29:07','Database API','added','command_name','check_mssql_total_server_memory',NULL),(571,'2012-06-03 09:29:07','Database API','added','command_param_count','0',NULL),(572,'2012-06-03 09:29:07','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode total-server-memory',NULL),(573,'2012-06-03 09:29:07','Database API','added','default_params','!',NULL),(574,'2012-06-03 09:29:07','Database API','created','checkcommand','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(575,'2012-06-03 09:29:07','Database API','added','command_name','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(576,'2012-06-03 09:29:07','Database API','added','command_param_count','0',NULL),(577,'2012-06-03 09:29:08','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode mem-pool-data-buffer-hit-ratio',NULL),(578,'2012-06-03 09:29:08','Database API','added','default_params','!',NULL),(579,'2012-06-03 09:29:08','Database API','created','checkcommand','check_mssql_lazy_writes',NULL),(580,'2012-06-03 09:29:08','Database API','added','command_name','check_mssql_lazy_writes',NULL),(581,'2012-06-03 09:29:08','Database API','added','command_param_count','0',NULL),(582,'2012-06-03 09:29:08','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode lazy-writes',NULL),(583,'2012-06-03 09:29:08','Database API','added','default_params','!',NULL),(584,'2012-06-03 09:29:08','Database API','created','checkcommand','check_mssql_page_life_expectancy',NULL),(585,'2012-06-03 09:29:08','Database API','added','command_name','check_mssql_page_life_expectancy',NULL),(586,'2012-06-03 09:29:08','Database API','added','command_param_count','0',NULL),(587,'2012-06-03 09:29:08','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode page-life-expectancy',NULL),(588,'2012-06-03 09:29:08','Database API','added','default_params','!',NULL),(589,'2012-06-03 09:29:09','Database API','created','checkcommand','check_mssql_free_list_stalls',NULL),(590,'2012-06-03 09:29:09','Database API','added','command_name','check_mssql_free_list_stalls',NULL),(591,'2012-06-03 09:29:09','Database API','added','command_param_count','0',NULL),(592,'2012-06-03 09:29:09','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode free-list-stalls',NULL),(593,'2012-06-03 09:29:09','Database API','added','default_params','!',NULL),(594,'2012-06-03 09:29:09','Database API','created','checkcommand','check_mssql_checkpoint_pages',NULL),(595,'2012-06-03 09:29:09','Database API','added','command_name','check_mssql_checkpoint_pages',NULL),(596,'2012-06-03 09:29:09','Database API','added','command_param_count','0',NULL),(597,'2012-06-03 09:29:09','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode checkpoint-pages',NULL),(598,'2012-06-03 09:29:09','Database API','added','default_params','!',NULL),(599,'2012-06-03 09:29:09','Database API','created','checkcommand','check_mssql_database_free',NULL),(600,'2012-06-03 09:29:09','Database API','added','command_name','check_mssql_database_free',NULL),(601,'2012-06-03 09:29:10','Database API','added','command_param_count','0',NULL),(602,'2012-06-03 09:29:10','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode database-free',NULL),(603,'2012-06-03 09:29:10','Database API','added','default_params','!',NULL),(604,'2012-06-03 09:29:10','Database API','created','checkcommand','check_mssql_database_backup_age',NULL),(605,'2012-06-03 09:29:10','Database API','added','command_name','check_mssql_database_backup_age',NULL),(606,'2012-06-03 09:29:10','Database API','added','command_param_count','0',NULL),(607,'2012-06-03 09:29:10','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode database-backup-age',NULL),(608,'2012-06-03 09:29:10','Database API','added','default_params','!',NULL),(609,'2012-06-03 09:29:10','Database API','created','checkcommand','check_akcp',NULL),(610,'2012-06-03 09:29:11','Database API','added','command_name','check_akcp',NULL),(611,'2012-06-03 09:29:11','Database API','added','command_param_count','0',NULL),(612,'2012-06-03 09:29:11','Database API','added','command_line','$PLUGINSDIR$/check_akcp.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -P 1 -w 26 -c 30',NULL),(613,'2012-06-03 09:29:11','Database API','added','default_params','!',NULL),(614,'2012-06-03 09:29:11','Database API','created','checkcommand','check_aix_disks',NULL),(615,'2012-06-03 09:29:11','Database API','added','command_name','check_aix_disks',NULL),(616,'2012-06-03 09:29:11','Database API','added','command_param_count','0',NULL),(617,'2012-06-03 09:29:11','Database API','added','command_line','$PLUGINSDIR$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -m / -f -w $_HOSTSTORAGE_WARN$ -c $_HOSTSTORAGE_CRIT$ -S0,1',NULL),(618,'2012-06-03 09:29:11','Database API','added','default_params','!',NULL),(619,'2012-06-03 09:29:11','Database API','created','checkcommand','check_aix_cpu',NULL),(620,'2012-06-03 09:29:12','Database API','added','command_name','check_aix_cpu',NULL),(621,'2012-06-03 09:29:12','Database API','added','command_param_count','0',NULL),(622,'2012-06-03 09:29:12','Database API','added','command_line','$PLUGINSDIR$/check_snmp_load.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTCPU_WARN$ -c $_HOSTCPU_CRIT$',NULL),(623,'2012-06-03 09:29:12','Database API','added','default_params','!',NULL),(624,'2012-06-03 09:29:12','Database API','created','checkcommand','check_aix_memory',NULL),(625,'2012-06-03 09:29:12','Database API','added','command_name','check_aix_memory',NULL),(626,'2012-06-03 09:29:12','Database API','added','command_param_count','0',NULL),(627,'2012-06-03 09:29:12','Database API','added','command_line','$PLUGINSDIR$/check_snmp_mem.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTMEMORY_WARN$ -c $_HOSTMEMORY_CRIT$',NULL),(628,'2012-06-03 09:29:12','Database API','added','default_params','!',NULL),(629,'2012-06-03 09:29:13','Database API','created','checkcommand','check_linux_disks',NULL),(630,'2012-06-03 09:29:13','Database API','added','command_name','check_linux_disks',NULL),(631,'2012-06-03 09:29:13','Database API','added','command_param_count','0',NULL),(632,'2012-06-03 09:29:13','Database API','added','command_line','$PLUGINSDIR$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -m / -f -w $_HOSTSTORAGE_WARN$ -c $_HOSTSTORAGE_CRIT$ -S0,1',NULL),(633,'2012-06-03 09:29:13','Database API','added','default_params','!',NULL),(634,'2012-06-03 09:29:13','Database API','created','checkcommand','check_linux_cpu',NULL),(635,'2012-06-03 09:29:13','Database API','added','command_name','check_linux_cpu',NULL),(636,'2012-06-03 09:29:13','Database API','added','command_param_count','0',NULL),(637,'2012-06-03 09:29:13','Database API','added','command_line','$PLUGINSDIR$/check_snmp_load.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTCPU_WARN$ -c $_HOSTCPU_CRIT$',NULL),(638,'2012-06-03 09:29:13','Database API','added','default_params','!',NULL),(639,'2012-06-03 09:29:13','Database API','created','checkcommand','check_linux_network_usage',NULL),(640,'2012-06-03 09:29:14','Database API','added','command_name','check_linux_network_usage',NULL),(641,'2012-06-03 09:29:14','Database API','added','command_param_count','0',NULL),(642,'2012-06-03 09:29:14','Database API','added','command_line','$PLUGINSDIR$/check_snmp_int.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -n eth -k -M -y -e -w 0,0 -c 0,0',NULL),(643,'2012-06-03 09:29:14','Database API','added','default_params','!',NULL),(644,'2012-06-03 09:29:14','Database API','created','checkcommand','check_linux_memory',NULL),(645,'2012-06-03 09:29:14','Database API','added','command_name','check_linux_memory',NULL),(646,'2012-06-03 09:29:14','Database API','added','command_param_count','0',NULL),(647,'2012-06-03 09:29:14','Database API','added','command_line','$PLUGINSDIR$/check_snmp_mem.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTMEMORY_WARN$ -c $_HOSTMEMORY_CRIT$',NULL),(648,'2012-06-03 09:29:14','Database API','added','default_params','!',NULL),(649,'2012-06-03 09:29:15','Database API','created','checkcommand','check_windows_disks',NULL),(650,'2012-06-03 09:29:15','Database API','added','command_name','check_windows_disks',NULL),(651,'2012-06-03 09:29:15','Database API','added','command_param_count','0',NULL),(652,'2012-06-03 09:29:15','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkdrivesize -a \'.\' -w 90 -c 95 -o 0 -3 0',NULL),(653,'2012-06-03 09:29:15','Database API','added','default_params','!',NULL),(654,'2012-06-03 09:29:15','Database API','created','checkcommand','check_windows_eventlogs',NULL),(655,'2012-06-03 09:29:15','Database API','added','command_name','check_windows_eventlogs',NULL),(656,'2012-06-03 09:29:15','Database API','added','command_param_count','1',NULL),(657,'2012-06-03 09:29:16','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkeventlog -a $ARG1$ -o 2 -3 1 -w 1 -c 2',NULL),(658,'2012-06-03 09:29:16','Database API','added','default_params','!',NULL),(659,'2012-06-03 09:29:16','Database API','created','checkcommand','check_windows_reboot',NULL),(660,'2012-06-03 09:29:16','Database API','added','command_name','check_windows_reboot',NULL),(661,'2012-06-03 09:29:16','Database API','added','command_param_count','0',NULL),(662,'2012-06-03 09:29:16','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkuptime -w \'5min:\' -c \'15min:\'',NULL),(663,'2012-06-03 09:29:16','Database API','added','default_params','!',NULL),(664,'2012-06-03 09:29:16','Database API','created','checkcommand','check_windows_physical_memory',NULL),(665,'2012-06-03 09:29:16','Database API','added','command_name','check_windows_physical_memory',NULL),(666,'2012-06-03 09:29:17','Database API','added','command_param_count','0',NULL),(667,'2012-06-03 09:29:17','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkmem -w 80 -c 90',NULL),(668,'2012-06-03 09:29:17','Database API','added','default_params','!',NULL),(669,'2012-06-03 09:29:17','Database API','created','checkcommand','check_windows_swap',NULL),(670,'2012-06-03 09:29:17','Database API','added','command_name','check_windows_swap',NULL),(671,'2012-06-03 09:29:17','Database API','added','command_param_count','0',NULL),(672,'2012-06-03 09:29:17','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkpage -a auto',NULL),(673,'2012-06-03 09:29:17','Database API','added','default_params','!',NULL),(674,'2012-06-03 09:29:17','Database API','created','checkcommand','check_windows_overall_cpu',NULL),(675,'2012-06-03 09:29:17','Database API','added','command_name','check_windows_overall_cpu',NULL),(676,'2012-06-03 09:29:17','Database API','added','command_param_count','0',NULL),(677,'2012-06-03 09:29:17','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkcpu -w 80 -c 90',NULL),(678,'2012-06-03 09:29:17','Database API','added','default_params','!',NULL),(679,'2012-06-03 09:29:17','Database API','created','checkcommand','check_windows_each_cpu',NULL),(680,'2012-06-03 09:29:17','Database API','added','command_name','check_windows_each_cpu',NULL),(681,'2012-06-03 09:29:18','Database API','added','command_param_count','0',NULL),(682,'2012-06-03 09:29:18','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkeachcpu -w 80 -c 90',NULL),(683,'2012-06-03 09:29:18','Database API','added','default_params','!',NULL),(684,'2012-06-03 09:29:18','Database API','created','checkcommand','check_windows_loadaverage',NULL),(685,'2012-06-03 09:29:18','Database API','added','command_name','check_windows_loadaverage',NULL),(686,'2012-06-03 09:29:18','Database API','added','command_param_count','0',NULL),(687,'2012-06-03 09:29:18','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkcpuq -w 10 -c 20 -a 20 -y 0',NULL),(688,'2012-06-03 09:29:18','Database API','added','default_params','!',NULL),(689,'2012-06-03 09:29:18','Database API','created','checkcommand','check_windows_auto_services',NULL),(690,'2012-06-03 09:29:18','Database API','added','command_name','check_windows_auto_services',NULL),(691,'2012-06-03 09:29:18','Database API','added','command_param_count','0',NULL),(692,'2012-06-03 09:29:18','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkservice -a Auto -o \'\' -w 0 -c 1',NULL),(693,'2012-06-03 09:29:19','Database API','added','default_params','!',NULL),(694,'2012-06-03 09:29:19','Database API','created','checkcommand','check_windows_big_processes',NULL),(695,'2012-06-03 09:29:19','Database API','added','command_name','check_windows_big_processes',NULL),(696,'2012-06-03 09:29:19','Database API','added','command_param_count','0',NULL),(697,'2012-06-03 09:29:19','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkproc -s cpuabove -a \'%\' -w 25 -exc _AvgCPU=@0:2 --nodataexit 0 --nodatastring \"No processes with high CPU found\"',NULL),(698,'2012-06-03 09:29:19','Database API','added','default_params','!',NULL),(699,'2012-06-03 09:29:19','Database API','created','checkcommand','check_windows_big_process',NULL),(700,'2012-06-03 09:29:19','Database API','added','command_name','check_windows_big_process',NULL),(701,'2012-06-03 09:29:19','Database API','added','command_param_count','1',NULL),(702,'2012-06-03 09:29:19','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkproc -s cpu -a \'$ARG1$\' --nodatamode',NULL),(703,'2012-06-03 09:29:19','Database API','added','default_params','!',NULL),(704,'2012-06-03 09:29:19','Database API','created','checkcommand','check_windows_disks_io',NULL),(705,'2012-06-03 09:29:19','Database API','added','command_name','check_windows_disks_io',NULL),(706,'2012-06-03 09:29:20','Database API','added','command_param_count','0',NULL),(707,'2012-06-03 09:29:20','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkio -s logical -a \'%\'',NULL),(708,'2012-06-03 09:29:20','Database API','added','default_params','!',NULL),(709,'2012-06-03 09:29:20','Database API','created','checkcommand','check_windows_inactive_ts_sessions',NULL),(710,'2012-06-03 09:29:20','Database API','added','command_name','check_windows_inactive_ts_sessions',NULL),(711,'2012-06-03 09:29:20','Database API','added','command_param_count','0',NULL),(712,'2012-06-03 09:29:20','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkts -s sessions2003 -w \'InactiveSessions=0:1\'',NULL),(713,'2012-06-03 09:29:20','Database API','added','default_params','!',NULL),(714,'2012-06-03 09:29:20','Database API','created','checkcommand','check_windows_share',NULL),(715,'2012-06-03 09:29:20','Database API','added','command_name','check_windows_share',NULL),(716,'2012-06-03 09:29:20','Database API','added','command_param_count','1',NULL),(717,'2012-06-03 09:29:21','Database API','added','command_line','$PLUGINSDIR$/check_disk_smb -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSERSHORT$\" -p \"$_HOSTDOMAINPASSWORD$\" -W \'$_HOSTDOMAIN$\' -s \'$ARG1$\' -w $_HOSTSHARE_WARN$ -c $_HOSTSHARE_CRIT$',NULL),(718,'2012-06-03 09:29:21','Database API','added','default_params','!',NULL),(719,'2012-06-03 09:29:21','Database API','created','checkcommand','check_netapp_cpu',NULL),(720,'2012-06-03 09:29:21','Database API','added','command_name','check_netapp_cpu',NULL),(721,'2012-06-03 09:29:21','Database API','added','command_param_count','0',NULL),(722,'2012-06-03 09:29:21','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v CPULOAD',NULL),(723,'2012-06-03 09:29:21','Database API','added','default_params','!',NULL),(724,'2012-06-03 09:29:22','Database API','created','checkcommand','check_netapp_disks',NULL),(725,'2012-06-03 09:29:22','Database API','added','command_name','check_netapp_disks',NULL),(726,'2012-06-03 09:29:22','Database API','added','command_param_count','0',NULL),(727,'2012-06-03 09:29:22','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v DISKUSED',NULL),(728,'2012-06-03 09:29:22','Database API','added','default_params','!',NULL),(729,'2012-06-03 09:29:22','Database API','created','checkcommand','check_netapp_faileddisk',NULL),(730,'2012-06-03 09:29:22','Database API','added','command_name','check_netapp_faileddisk',NULL),(731,'2012-06-03 09:29:22','Database API','added','command_param_count','0',NULL),(732,'2012-06-03 09:29:22','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v FAILEDDISK',NULL),(733,'2012-06-03 09:29:22','Database API','added','default_params','!',NULL),(734,'2012-06-03 09:29:22','Database API','created','checkcommand','check_netapp_fan',NULL),(735,'2012-06-03 09:29:22','Database API','added','command_name','check_netapp_fan',NULL),(736,'2012-06-03 09:29:22','Database API','added','command_param_count','0',NULL),(737,'2012-06-03 09:29:23','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v FAN',NULL),(738,'2012-06-03 09:29:23','Database API','added','default_params','!',NULL),(739,'2012-06-03 09:29:23','Database API','created','checkcommand','check_netapp_nvram',NULL),(740,'2012-06-03 09:29:23','Database API','added','command_name','check_netapp_nvram',NULL),(741,'2012-06-03 09:29:23','Database API','added','command_param_count','0',NULL),(742,'2012-06-03 09:29:23','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v NVRAM',NULL),(743,'2012-06-03 09:29:23','Database API','added','default_params','!',NULL),(744,'2012-06-03 09:29:23','Database API','created','checkcommand','check_netapp_power_supply',NULL),(745,'2012-06-03 09:29:23','Database API','added','command_name','check_netapp_power_supply',NULL),(746,'2012-06-03 09:29:23','Database API','added','command_param_count','0',NULL),(747,'2012-06-03 09:29:23','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v PS',NULL),(748,'2012-06-03 09:29:23','Database API','added','default_params','!',NULL),(749,'2012-06-03 09:29:24','Database API','created','checkcommand','check_netapp_snapshots',NULL),(750,'2012-06-03 09:29:24','Database API','added','command_name','check_netapp_snapshots',NULL),(751,'2012-06-03 09:29:24','Database API','added','command_param_count','0',NULL),(752,'2012-06-03 09:29:24','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v SNAPSHOT',NULL),(753,'2012-06-03 09:29:24','Database API','added','default_params','!',NULL),(754,'2012-06-03 09:29:24','Database API','created','checkcommand','check_netapp_temperature',NULL),(755,'2012-06-03 09:29:24','Database API','added','command_name','check_netapp_temperature',NULL),(756,'2012-06-03 09:29:24','Database API','added','command_param_count','0',NULL),(757,'2012-06-03 09:29:24','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v TEMP',NULL),(758,'2012-06-03 09:29:24','Database API','added','default_params','!',NULL),(759,'2012-06-03 09:29:24','Database API','created','checkcommand','check_netapp_uptime',NULL),(760,'2012-06-03 09:29:24','Database API','added','command_name','check_netapp_uptime',NULL),(761,'2012-06-03 09:29:24','Database API','added','command_param_count','0',NULL),(762,'2012-06-03 09:29:24','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v UPTIME',NULL),(763,'2012-06-03 09:29:25','Database API','added','default_params','!',NULL),(764,'2012-06-03 09:29:25','Database API','created','checkcommand','check_emc_spa',NULL),(765,'2012-06-03 09:29:25','Database API','added','command_name','check_emc_spa',NULL),(766,'2012-06-03 09:29:25','Database API','added','command_param_count','0',NULL),(767,'2012-06-03 09:29:25','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t sp --sp A',NULL),(768,'2012-06-03 09:29:25','Database API','added','default_params','!',NULL),(769,'2012-06-03 09:29:25','Database API','created','checkcommand','check_emc_spb',NULL),(770,'2012-06-03 09:29:26','Database API','added','command_name','check_emc_spb',NULL),(771,'2012-06-03 09:29:26','Database API','added','command_param_count','0',NULL),(772,'2012-06-03 09:29:26','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t sp --sp B',NULL),(773,'2012-06-03 09:29:26','Database API','added','default_params','!',NULL),(774,'2012-06-03 09:29:26','Database API','created','checkcommand','check_emc_disks',NULL),(775,'2012-06-03 09:29:26','Database API','added','command_name','check_emc_disks',NULL),(776,'2012-06-03 09:29:26','Database API','added','command_param_count','0',NULL),(777,'2012-06-03 09:29:26','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t disk',NULL),(778,'2012-06-03 09:29:26','Database API','added','default_params','!',NULL),(779,'2012-06-03 09:29:26','Database API','created','checkcommand','check_emc_cache',NULL),(780,'2012-06-03 09:29:27','Database API','added','command_name','check_emc_cache',NULL),(781,'2012-06-03 09:29:27','Database API','added','command_param_count','0',NULL),(782,'2012-06-03 09:29:27','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t cache',NULL),(783,'2012-06-03 09:29:27','Database API','added','default_params','!',NULL),(784,'2012-06-03 09:29:27','Database API','created','checkcommand','check_emc_faults',NULL),(785,'2012-06-03 09:29:27','Database API','added','command_name','check_emc_faults',NULL),(786,'2012-06-03 09:29:27','Database API','added','command_param_count','0',NULL),(787,'2012-06-03 09:29:27','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t faults',NULL),(788,'2012-06-03 09:29:27','Database API','added','default_params','!',NULL),(789,'2012-06-03 09:29:28','Database API','created','checkcommand','check_emc_ports',NULL),(790,'2012-06-03 09:29:28','Database API','added','command_name','check_emc_ports',NULL),(791,'2012-06-03 09:29:28','Database API','added','command_param_count','0',NULL),(792,'2012-06-03 09:29:28','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t portstate',NULL),(793,'2012-06-03 09:29:28','Database API','added','default_params','!',NULL),(794,'2012-06-03 09:29:28','Database API','created','checkcommand','check_esx_vm_cpu',NULL),(795,'2012-06-03 09:29:28','Database API','added','command_name','check_esx_vm_cpu',NULL),(796,'2012-06-03 09:29:28','Database API','added','command_param_count','0',NULL),(797,'2012-06-03 09:29:29','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l cpu',NULL),(798,'2012-06-03 09:29:29','Database API','added','default_params','!',NULL),(799,'2012-06-03 09:29:29','Database API','created','checkcommand','check_esx_vm_io',NULL),(800,'2012-06-03 09:29:29','Database API','added','command_name','check_esx_vm_io',NULL),(801,'2012-06-03 09:29:29','Database API','added','command_param_count','0',NULL),(802,'2012-06-03 09:29:29','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l io',NULL),(803,'2012-06-03 09:29:29','Database API','added','default_params','!',NULL),(804,'2012-06-03 09:29:29','Database API','created','checkcommand','check_esx_vm_net',NULL),(805,'2012-06-03 09:29:29','Database API','added','command_name','check_esx_vm_net',NULL),(806,'2012-06-03 09:29:29','Database API','added','command_param_count','0',NULL),(807,'2012-06-03 09:29:29','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l net',NULL),(808,'2012-06-03 09:29:29','Database API','added','default_params','!',NULL),(809,'2012-06-03 09:29:30','Database API','created','checkcommand','check_esx_vm_mem',NULL),(810,'2012-06-03 09:29:30','Database API','added','command_name','check_esx_vm_mem',NULL),(811,'2012-06-03 09:29:30','Database API','added','command_param_count','0',NULL),(812,'2012-06-03 09:29:30','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l mem',NULL),(813,'2012-06-03 09:29:30','Database API','added','default_params','!',NULL),(814,'2012-06-03 09:29:30','Database API','created','checkcommand','check_esx_host',NULL),(815,'2012-06-03 09:29:30','Database API','added','command_name','check_esx_host',NULL),(816,'2012-06-03 09:29:31','Database API','added','command_param_count','1',NULL),(817,'2012-06-03 09:29:31','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l $ARG1$',NULL),(818,'2012-06-03 09:29:31','Database API','added','default_params','!',NULL),(819,'2012-06-03 09:29:31','Database API','created','checkcommand','check_esx_vm',NULL),(820,'2012-06-03 09:29:31','Database API','added','command_name','check_esx_vm',NULL),(821,'2012-06-03 09:29:31','Database API','added','command_param_count','1',NULL),(822,'2012-06-03 09:29:31','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l $ARG1$',NULL),(823,'2012-06-03 09:29:31','Database API','added','default_params','!',NULL),(824,'2012-06-03 09:29:31','Database API','created','checkcommand','check_esx_host_cpu',NULL),(825,'2012-06-03 09:29:31','Database API','added','command_name','check_esx_host_cpu',NULL),(826,'2012-06-03 09:29:31','Database API','added','command_param_count','0',NULL),(827,'2012-06-03 09:29:31','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l cpu',NULL),(828,'2012-06-03 09:29:31','Database API','added','default_params','!',NULL),(829,'2012-06-03 09:29:32','Database API','created','checkcommand','check_esx_host_io',NULL),(830,'2012-06-03 09:29:32','Database API','added','command_name','check_esx_host_io',NULL),(831,'2012-06-03 09:29:32','Database API','added','command_param_count','0',NULL),(832,'2012-06-03 09:29:32','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l io',NULL),(833,'2012-06-03 09:29:32','Database API','added','default_params','!',NULL),(834,'2012-06-03 09:29:32','Database API','created','checkcommand','check_esx_host_net',NULL),(835,'2012-06-03 09:29:32','Database API','added','command_name','check_esx_host_net',NULL),(836,'2012-06-03 09:29:32','Database API','added','command_param_count','0',NULL),(837,'2012-06-03 09:29:32','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l net',NULL),(838,'2012-06-03 09:29:32','Database API','added','default_params','!',NULL),(839,'2012-06-03 09:29:32','Database API','created','checkcommand','check_esx_host_mem',NULL),(840,'2012-06-03 09:29:32','Database API','added','command_name','check_esx_host_mem',NULL),(841,'2012-06-03 09:29:33','Database API','added','command_param_count','0',NULL),(842,'2012-06-03 09:29:33','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l mem',NULL),(843,'2012-06-03 09:29:33','Database API','added','default_params','!',NULL),(844,'2012-06-03 09:29:33','Database API','created','checkcommand','check_ldap',NULL),(845,'2012-06-03 09:29:33','Database API','added','command_name','check_ldap',NULL),(846,'2012-06-03 09:29:33','Database API','added','command_param_count','0',NULL),(847,'2012-06-03 09:29:33','Database API','added','command_line','$PLUGINSDIR$/check_ldap -H $HOSTADDRESS$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\"',NULL),(848,'2012-06-03 09:29:33','Database API','added','default_params','!',NULL),(849,'2012-06-03 09:29:34','Database API','created','checkcommand','check_ldap3',NULL),(850,'2012-06-03 09:29:34','Database API','added','command_name','check_ldap3',NULL),(851,'2012-06-03 09:29:34','Database API','added','command_param_count','0',NULL),(852,'2012-06-03 09:29:34','Database API','added','command_line','$PLUGINSDIR$/check_ldap -H $HOSTADDRESS$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\" -3',NULL),(853,'2012-06-03 09:29:34','Database API','added','default_params','!',NULL),(854,'2012-06-03 09:29:34','Database API','created','checkcommand','check_ldaps',NULL),(855,'2012-06-03 09:29:34','Database API','added','command_name','check_ldaps',NULL),(856,'2012-06-03 09:29:34','Database API','added','command_param_count','0',NULL),(857,'2012-06-03 09:29:34','Database API','added','command_line','$PLUGINSDIR$/check_ldaps -H $HOSTNAME$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\"',NULL),(858,'2012-06-03 09:29:34','Database API','added','default_params','!',NULL),(859,'2012-06-03 09:29:34','Database API','created','checkcommand','check_ldaps_certificate',NULL),(860,'2012-06-03 09:29:34','Database API','added','command_name','check_ldaps_certificate',NULL),(861,'2012-06-03 09:29:34','Database API','added','command_param_count','0',NULL),(862,'2012-06-03 09:29:35','Database API','added','command_line','$PLUGINSDIR$/check_tcp -H $HOSTADDRESS$ -p 636 -D 30',NULL),(863,'2012-06-03 09:29:35','Database API','added','default_params','!',NULL),(864,'2012-06-03 09:29:35','Database API','created','checkcommand','check_dns',NULL),(865,'2012-06-03 09:29:35','Database API','added','command_name','check_dns',NULL),(866,'2012-06-03 09:29:35','Database API','added','command_param_count','0',NULL),(867,'2012-06-03 09:29:35','Database API','added','command_line','$PLUGINSDIR$/check_dns -H $_HOSTDNSHOSTNAME$ -a $_HOSTDNSEXPECTEDRESULT$ -s $HOSTADDRESS$',NULL),(868,'2012-06-03 09:29:35','Database API','added','default_params','!',NULL),(869,'2012-06-03 09:29:36','Database API','created','checkcommand','check_sip',NULL),(870,'2012-06-03 09:29:36','Database API','added','command_name','check_sip',NULL),(871,'2012-06-03 09:29:36','Database API','added','command_param_count','0',NULL),(872,'2012-06-03 09:29:36','Database API','added','command_line','$PLUGINSDIR$/check_sip -H $HOSTADDRESS$ -u sip:$SIPUSER$',NULL),(873,'2012-06-03 09:29:36','Database API','added','default_params','!',NULL),(874,'2012-06-03 09:29:37','Database API','created','checkcommand','check_pop3',NULL),(875,'2012-06-03 09:29:37','Database API','added','command_name','check_pop3',NULL),(876,'2012-06-03 09:29:38','Database API','added','command_param_count','0',NULL),(877,'2012-06-03 09:29:38','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$',NULL),(878,'2012-06-03 09:29:38','Database API','added','default_params','!',NULL),(879,'2012-06-03 09:29:38','Database API','created','checkcommand','check_pop3s',NULL),(880,'2012-06-03 09:29:38','Database API','added','command_name','check_pop3s',NULL),(881,'2012-06-03 09:29:38','Database API','added','command_param_count','0',NULL),(882,'2012-06-03 09:29:38','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$ -S',NULL),(883,'2012-06-03 09:29:38','Database API','added','default_params','!',NULL),(884,'2012-06-03 09:29:38','Database API','created','checkcommand','check_pop3s_certificate',NULL),(885,'2012-06-03 09:29:38','Database API','added','command_name','check_pop3s_certificate',NULL),(886,'2012-06-03 09:29:38','Database API','added','command_param_count','0',NULL),(887,'2012-06-03 09:29:39','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$ -S -D 30',NULL),(888,'2012-06-03 09:29:39','Database API','added','default_params','!',NULL),(889,'2012-06-03 09:29:39','Database API','created','checkcommand','check_switch_interface_status',NULL),(890,'2012-06-03 09:29:39','Database API','added','command_name','check_switch_interface_status',NULL),(891,'2012-06-03 09:29:39','Database API','added','command_param_count','0',NULL),(892,'2012-06-03 09:29:39','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-status',NULL),(893,'2012-06-03 09:29:39','Database API','added','default_params','!',NULL),(894,'2012-06-03 09:29:39','Database API','created','checkcommand','check_switch_interface_usage',NULL),(895,'2012-06-03 09:29:39','Database API','added','command_name','check_switch_interface_usage',NULL),(896,'2012-06-03 09:29:40','Database API','added','command_param_count','0',NULL),(897,'2012-06-03 09:29:40','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-usage',NULL),(898,'2012-06-03 09:29:40','Database API','added','default_params','!',NULL),(899,'2012-06-03 09:29:40','Database API','created','checkcommand','check_switch_interface_errors',NULL),(900,'2012-06-03 09:29:40','Database API','added','command_name','check_switch_interface_errors',NULL),(901,'2012-06-03 09:29:40','Database API','added','command_param_count','0',NULL),(902,'2012-06-03 09:29:40','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-errors',NULL),(903,'2012-06-03 09:29:40','Database API','added','default_params','!',NULL),(904,'2012-06-03 09:29:40','Database API','created','checkcommand','check_switch_hardware_health',NULL),(905,'2012-06-03 09:29:40','Database API','added','command_name','check_switch_hardware_health',NULL),(906,'2012-06-03 09:29:40','Database API','added','command_param_count','0',NULL),(907,'2012-06-03 09:29:40','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode hardware-health',NULL),(908,'2012-06-03 09:29:40','Database API','added','default_params','!',NULL),(909,'2012-06-03 09:29:41','Database API','created','checkcommand','check_switch_cpu',NULL),(910,'2012-06-03 09:29:41','Database API','added','command_name','check_switch_cpu',NULL),(911,'2012-06-03 09:29:41','Database API','added','command_param_count','0',NULL),(912,'2012-06-03 09:29:41','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode cpu-load',NULL),(913,'2012-06-03 09:29:41','Database API','added','default_params','!',NULL),(914,'2012-06-03 09:29:41','Database API','created','checkcommand','check_switch_memory',NULL),(915,'2012-06-03 09:29:41','Database API','added','command_name','check_switch_memory',NULL),(916,'2012-06-03 09:29:42','Database API','added','command_param_count','0',NULL),(917,'2012-06-03 09:29:42','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode memory-usage',NULL),(918,'2012-06-03 09:29:42','Database API','added','default_params','!',NULL),(919,'2012-06-03 09:30:05','admin','removed','checkcommand','check_ad_replications',NULL),(920,'2012-06-03 09:30:05','admin','removed','checkcommand','check_aix_cpu',NULL),(921,'2012-06-03 09:30:05','admin','removed','checkcommand','check_aix_disks',NULL),(922,'2012-06-03 09:30:05','admin','removed','checkcommand','check_aix_memory',NULL),(923,'2012-06-03 09:30:05','admin','removed','checkcommand','check_akcp',NULL),(924,'2012-06-03 09:30:05','admin','removed','checkcommand','check_dhcp',NULL),(925,'2012-06-03 09:30:05','admin','removed','checkcommand','check_dns',NULL),(926,'2012-06-03 09:30:05','admin','removed','checkcommand','check_emc_cache',NULL),(927,'2012-06-03 09:30:05','admin','removed','checkcommand','check_emc_disks',NULL),(928,'2012-06-03 09:30:05','admin','removed','checkcommand','check_emc_faults',NULL),(929,'2012-06-03 09:30:06','admin','removed','checkcommand','check_emc_ports',NULL),(930,'2012-06-03 09:30:06','admin','removed','checkcommand','check_emc_spa',NULL),(931,'2012-06-03 09:30:06','admin','removed','checkcommand','check_emc_spb',NULL),(932,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_host',NULL),(933,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_host_cpu',NULL),(934,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_host_io',NULL),(935,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_host_mem',NULL),(936,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_host_net',NULL),(937,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_vm',NULL),(938,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_vm_cpu',NULL),(939,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_vm_io',NULL),(940,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_vm_mem',NULL),(941,'2012-06-03 09:30:06','admin','removed','checkcommand','check_esx_vm_net',NULL),(942,'2012-06-03 09:30:07','admin','removed','checkcommand','check_exchange_db_activity',NULL),(943,'2012-06-03 09:30:07','admin','removed','checkcommand','check_exchange_hub_transport_activity',NULL),(944,'2012-06-03 09:30:07','admin','removed','checkcommand','check_exchange_hub_transport_queues',NULL),(945,'2012-06-03 09:30:07','admin','removed','checkcommand','check_exchange_smtp_receive',NULL),(946,'2012-06-03 09:30:07','admin','removed','checkcommand','check_exchange_smtp_send',NULL),(947,'2012-06-03 09:30:07','admin','removed','checkcommand','check_ftp',NULL),(948,'2012-06-03 09:30:07','admin','removed','checkcommand','check_hpjd',NULL),(949,'2012-06-03 09:30:07','admin','removed','checkcommand','check_hp_asm',NULL),(950,'2012-06-03 09:30:07','admin','removed','checkcommand','check_hp_bladechassis',NULL),(951,'2012-06-03 09:30:07','admin','removed','checkcommand','check_http',NULL),(952,'2012-06-03 09:30:07','admin','removed','checkcommand','check_iis_connections',NULL),(953,'2012-06-03 09:30:07','admin','removed','checkcommand','check_iis_errors',NULL),(954,'2012-06-03 09:30:08','admin','removed','checkcommand','check_iis_requests_activity',NULL),(955,'2012-06-03 09:30:08','admin','removed','checkcommand','check_iis_transferts_activity',NULL),(956,'2012-06-03 09:30:08','admin','removed','checkcommand','check_iis_users',NULL),(957,'2012-06-03 09:30:08','admin','removed','checkcommand','check_imap',NULL),(958,'2012-06-03 09:30:08','admin','removed','checkcommand','check_ldap',NULL),(959,'2012-06-03 09:30:08','admin','removed','checkcommand','check_ldap3',NULL),(960,'2012-06-03 09:30:08','admin','removed','checkcommand','check_ldaps',NULL),(961,'2012-06-03 09:30:09','admin','removed','checkcommand','check_ldaps_certificate',NULL),(962,'2012-06-03 09:30:09','admin','removed','checkcommand','check_linux_cpu',NULL),(963,'2012-06-03 09:30:09','admin','removed','checkcommand','check_linux_disks',NULL),(964,'2012-06-03 09:30:09','admin','removed','checkcommand','check_linux_memory',NULL),(965,'2012-06-03 09:30:09','admin','removed','checkcommand','check_linux_network_usage',NULL),(966,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_disk',NULL),(967,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_load',NULL),(968,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_mrtgtraf',NULL),(969,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_procs',NULL),(970,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_swap',NULL),(971,'2012-06-03 09:30:09','admin','removed','checkcommand','check_local_users',NULL),(972,'2012-06-03 09:30:09','admin','removed','checkcommand','check_mongodb_connection',NULL),(973,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_flush_time',NULL),(974,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_index_miss_ratio',NULL),(975,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_last_flush',NULL),(976,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_lock_time',NULL),(977,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_open_connections',NULL),(978,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_replicaset',NULL),(979,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mongodb_replication_lag',NULL),(980,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_batch_requests',NULL),(981,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_checkpoint_pages',NULL),(982,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_connected_users',NULL),(983,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_connection',NULL),(984,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_cpu_busy',NULL),(985,'2012-06-03 09:30:10','admin','removed','checkcommand','check_mssql_database_backup_age',NULL),(986,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_database_free',NULL),(987,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_free_list_stalls',NULL),(988,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_full_scans',NULL),(989,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_io_busy',NULL),(990,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_latches_waits',NULL),(991,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_latches_wait_time',NULL),(992,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_lazy_writes',NULL),(993,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_locks_deadlocks',NULL),(994,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_locks_timeouts',NULL),(995,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_locks_waits',NULL),(996,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(997,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_page_life_expectancy',NULL),(998,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_sql_initcompilations',NULL),(999,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_sql_recompilations',NULL),(1000,'2012-06-03 09:30:11','admin','removed','checkcommand','check_mssql_total_server_memory',NULL),(1001,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mssql_transactions',NULL),(1002,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_bufferpool_hitrate',NULL),(1003,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_bufferpool_wait_free',NULL),(1004,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_cluster_ndb_running',NULL),(1005,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_connection',NULL),(1006,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_index_usage',NULL),(1007,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_keycache_hitrate',NULL),(1008,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_log_waits',NULL),(1009,'2012-06-03 09:30:12','admin','removed','checkcommand','check_mysql_long_running_procs',NULL),(1010,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_open_files',NULL),(1011,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_qcache_hitrate',NULL),(1012,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_qcache_lowmem_prunes',NULL),(1013,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_querycache_hitrate',NULL),(1014,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_slave_io_running',NULL),(1015,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_slave_lag',NULL),(1016,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_slave_sql_running',NULL),(1017,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_slow_queries',NULL),(1018,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_tablecache_hitrate',NULL),(1019,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_table_lock_contention',NULL),(1020,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_threadcache_hitrate',NULL),(1021,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_threads_connected',NULL),(1022,'2012-06-03 09:30:13','admin','removed','checkcommand','check_mysql_tmp_disk_tables',NULL),(1023,'2012-06-03 09:30:14','admin','removed','checkcommand','check_mysql_uptime',NULL),(1024,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_cpu',NULL),(1025,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_disks',NULL),(1026,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_faileddisk',NULL),(1027,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_fan',NULL),(1028,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_nvram',NULL),(1029,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_power_supply',NULL),(1030,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_snapshots',NULL),(1031,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_temperature',NULL),(1032,'2012-06-03 09:30:14','admin','removed','checkcommand','check_netapp_uptime',NULL),(1033,'2012-06-03 09:30:14','admin','removed','checkcommand','check_nt',NULL),(1034,'2012-06-03 09:30:14','admin','removed','checkcommand','check_oracle_connected_users',NULL),(1035,'2012-06-03 09:30:14','admin','removed','checkcommand','check_oracle_connection_time',NULL),(1036,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_datafiles_existing',NULL),(1037,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_datafile_io_traffic',NULL),(1038,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_enqueue_contention',NULL),(1039,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_enqueue_waiting',NULL),(1040,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_event_waiting',NULL),(1041,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_event_waits',NULL),(1042,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_flash_recovery_area_free',NULL),(1043,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_flash_recovery_area_usage',NULL),(1044,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_invalid_objects',NULL),(1045,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_latch_contention',NULL),(1046,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_latch_waiting',NULL),(1047,'2012-06-03 09:30:15','admin','removed','checkcommand','check_oracle_pga_in_memory_sort_ratio',NULL),(1048,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_process_usage',NULL),(1049,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_redo_io_traffic',NULL),(1050,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_retry_ratio',NULL),(1051,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_rman_backup_problems',NULL),(1052,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_roll_block_contention',NULL),(1053,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_roll_extends',NULL),(1054,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_roll_header_contention',NULL),(1055,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_roll_hit_ratio',NULL),(1056,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_roll_wraps',NULL),(1057,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_seg_top10_buffer_busy_waits',NULL),(1058,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_seg_top10_logical_reads',NULL),(1059,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_seg_top10_physical_reads',NULL),(1060,'2012-06-03 09:30:16','admin','removed','checkcommand','check_oracle_seg_top10_row_lock_waits',NULL),(1061,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_session_usage',NULL),(1062,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_data_buffer_hit_ratio',NULL),(1063,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(1064,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_latches_hit_ratio',NULL),(1065,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_library_cache_gethit_ratio',NULL),(1066,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_library_cache_pinhit_ratio',NULL),(1067,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_library_cache_reloads',NULL),(1068,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_shared_pool_free',NULL),(1069,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_sga_shared_pool_reloads',NULL),(1070,'2012-06-03 09:30:17','admin','removed','checkcommand','check_oracle_soft_parse_ratio',NULL),(1071,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_stale_statistics',NULL),(1072,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_switch_interval',NULL),(1073,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_sysstat',NULL),(1074,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_can_allocate_next',NULL),(1075,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_fragmentation',NULL),(1076,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_free',NULL),(1077,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_io_balanc',NULL),(1078,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_remaining_time',NULL),(1079,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tablespace_usage',NULL),(1080,'2012-06-03 09:30:18','admin','removed','checkcommand','check_oracle_tnsping',NULL),(1081,'2012-06-03 09:30:19','admin','removed','checkcommand','check_ping',NULL),(1082,'2012-06-03 09:30:19','admin','removed','checkcommand','check_pop',NULL),(1083,'2012-06-03 09:30:19','admin','removed','checkcommand','check_pop3',NULL),(1084,'2012-06-03 09:30:19','admin','removed','checkcommand','check_pop3s',NULL),(1085,'2012-06-03 09:30:19','admin','removed','checkcommand','check_pop3s_certificate',NULL),(1086,'2012-06-03 09:30:19','admin','removed','checkcommand','check_sip',NULL),(1087,'2012-06-03 09:30:19','admin','removed','checkcommand','check_smtp',NULL),(1088,'2012-06-03 09:30:19','admin','removed','checkcommand','check_snmp',NULL),(1089,'2012-06-03 09:30:20','admin','removed','checkcommand','check_ssh',NULL),(1090,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_cpu',NULL),(1091,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_hardware_health',NULL),(1092,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_interface_errors',NULL),(1093,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_interface_status',NULL),(1094,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_interface_usage',NULL),(1095,'2012-06-03 09:30:20','admin','removed','checkcommand','check_switch_memory',NULL),(1096,'2012-06-03 09:30:20','admin','removed','checkcommand','check_tcp',NULL),(1097,'2012-06-03 09:30:20','admin','removed','checkcommand','check_udp',NULL),(1098,'2012-06-03 09:30:20','admin','removed','checkcommand','check_windows_auto_services',NULL),(1099,'2012-06-03 09:30:20','admin','removed','checkcommand','check_windows_big_process',NULL),(1100,'2012-06-03 09:30:20','admin','removed','checkcommand','check_windows_big_processes',NULL),(1101,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_disks',NULL),(1102,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_disks_io',NULL),(1103,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_each_cpu',NULL),(1104,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_eventlogs',NULL),(1105,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_inactive_ts_sessions',NULL),(1106,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_loadaverage',NULL),(1107,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_overall_cpu',NULL),(1108,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_physical_memory',NULL),(1109,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_reboot',NULL),(1110,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_share',NULL),(1111,'2012-06-03 09:30:21','admin','removed','checkcommand','check_windows_swap',NULL),(1112,'2012-06-03 09:30:26','Database API','created','checkcommand','check_hp_bladechassis',NULL),(1113,'2012-06-03 09:30:26','Database API','added','command_name','check_hp_bladechassis',NULL),(1114,'2012-06-03 09:30:26','Database API','added','command_param_count','0',NULL),(1115,'2012-06-03 09:30:27','Database API','added','command_line','$PLUGINSDIR$/check_hpasm -H $HOSTADDRESS$ -C $SNMPCOMMUNITY$ -t 60',NULL),(1116,'2012-06-03 09:30:27','Database API','added','default_params','!',NULL),(1117,'2012-06-03 09:30:27','Database API','created','checkcommand','check_hp_asm',NULL),(1118,'2012-06-03 09:30:27','Database API','added','command_name','check_hp_asm',NULL),(1119,'2012-06-03 09:30:27','Database API','added','command_param_count','0',NULL),(1120,'2012-06-03 09:30:27','Database API','added','command_line','$PLUGINSDIR$/check_hpasm -H $HOSTADDRESS$ -C \"$_HOSTHP_ASM_COMMUNITY$\"',NULL),(1121,'2012-06-03 09:30:27','Database API','added','default_params','!',NULL),(1122,'2012-06-03 09:30:28','Database API','created','checkcommand','check_exchange_hub_transport_activity',NULL),(1123,'2012-06-03 09:30:28','Database API','added','command_name','check_exchange_hub_transport_activity',NULL),(1124,'2012-06-03 09:30:28','Database API','added','command_param_count','0',NULL),(1125,'2012-06-03 09:30:28','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s HubTransportServer',NULL),(1126,'2012-06-03 09:30:28','Database API','added','default_params','!',NULL),(1127,'2012-06-03 09:30:28','Database API','created','checkcommand','check_exchange_hub_transport_queues',NULL),(1128,'2012-06-03 09:30:28','Database API','added','command_name','check_exchange_hub_transport_queues',NULL),(1129,'2012-06-03 09:30:28','Database API','added','command_param_count','0',NULL),(1130,'2012-06-03 09:30:28','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s TransportQueues',NULL),(1131,'2012-06-03 09:30:28','Database API','added','default_params','!',NULL),(1132,'2012-06-03 09:30:28','Database API','created','checkcommand','check_exchange_db_activity',NULL),(1133,'2012-06-03 09:30:28','Database API','added','command_name','check_exchange_db_activity',NULL),(1134,'2012-06-03 09:30:28','Database API','added','command_param_count','0',NULL),(1135,'2012-06-03 09:30:29','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s DBInstances',NULL),(1136,'2012-06-03 09:30:29','Database API','added','default_params','!',NULL),(1137,'2012-06-03 09:30:29','Database API','created','checkcommand','check_exchange_smtp_receive',NULL),(1138,'2012-06-03 09:30:29','Database API','added','command_name','check_exchange_smtp_receive',NULL),(1139,'2012-06-03 09:30:29','Database API','added','command_param_count','0',NULL),(1140,'2012-06-03 09:30:29','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s SmtpReceive',NULL),(1141,'2012-06-03 09:30:29','Database API','added','default_params','!',NULL),(1142,'2012-06-03 09:30:29','Database API','created','checkcommand','check_exchange_smtp_send',NULL),(1143,'2012-06-03 09:30:29','Database API','added','command_name','check_exchange_smtp_send',NULL),(1144,'2012-06-03 09:30:29','Database API','added','command_param_count','0',NULL),(1145,'2012-06-03 09:30:30','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkexchange -s SmtpSend',NULL),(1146,'2012-06-03 09:30:30','Database API','added','default_params','!',NULL),(1147,'2012-06-03 09:30:30','Database API','created','checkcommand','check_ad_replications',NULL),(1148,'2012-06-03 09:30:30','Database API','added','command_name','check_ad_replications',NULL),(1149,'2012-06-03 09:30:30','Database API','added','command_param_count','0',NULL),(1150,'2012-06-03 09:30:30','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkad -s replication -w 0 --nodatamode',NULL),(1151,'2012-06-03 09:30:30','Database API','added','default_params','!',NULL),(1152,'2012-06-03 09:30:31','Database API','created','checkcommand','check_iis_transferts_activity',NULL),(1153,'2012-06-03 09:30:31','Database API','added','command_name','check_iis_transferts_activity',NULL),(1154,'2012-06-03 09:30:31','Database API','added','command_param_count','0',NULL),(1155,'2012-06-03 09:30:31','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s transfers -a \'_Total\'',NULL),(1156,'2012-06-03 09:30:31','Database API','added','default_params','!',NULL),(1157,'2012-06-03 09:30:31','Database API','created','checkcommand','check_iis_requests_activity',NULL),(1158,'2012-06-03 09:30:31','Database API','added','command_name','check_iis_requests_activity',NULL),(1159,'2012-06-03 09:30:31','Database API','added','command_param_count','0',NULL),(1160,'2012-06-03 09:30:31','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s requests -a \'_Total\'',NULL),(1161,'2012-06-03 09:30:32','Database API','added','default_params','!',NULL),(1162,'2012-06-03 09:30:32','Database API','created','checkcommand','check_iis_errors',NULL),(1163,'2012-06-03 09:30:32','Database API','added','command_name','check_iis_errors',NULL),(1164,'2012-06-03 09:30:32','Database API','added','command_param_count','0',NULL),(1165,'2012-06-03 09:30:32','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s errors -a \'_Total\'',NULL),(1166,'2012-06-03 09:30:32','Database API','added','default_params','!',NULL),(1167,'2012-06-03 09:30:33','Database API','created','checkcommand','check_iis_users',NULL),(1168,'2012-06-03 09:30:33','Database API','added','command_name','check_iis_users',NULL),(1169,'2012-06-03 09:30:33','Database API','added','command_param_count','0',NULL),(1170,'2012-06-03 09:30:33','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s users -a \'_Total\'',NULL),(1171,'2012-06-03 09:30:33','Database API','added','default_params','!',NULL),(1172,'2012-06-03 09:30:33','Database API','created','checkcommand','check_iis_connections',NULL),(1173,'2012-06-03 09:30:33','Database API','added','command_name','check_iis_connections',NULL),(1174,'2012-06-03 09:30:33','Database API','added','command_param_count','0',NULL),(1175,'2012-06-03 09:30:33','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkiis -s connections -a \'_Total\'',NULL),(1176,'2012-06-03 09:30:33','Database API','added','default_params','!',NULL),(1177,'2012-06-03 09:30:35','Database API','created','checkcommand','check_oracle_tnsping',NULL),(1178,'2012-06-03 09:30:35','Database API','added','command_name','check_oracle_tnsping',NULL),(1179,'2012-06-03 09:30:35','Database API','added','command_param_count','1',NULL),(1180,'2012-06-03 09:30:35','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tnsping',NULL),(1181,'2012-06-03 09:30:36','Database API','added','default_params','!',NULL),(1182,'2012-06-03 09:30:36','Database API','created','checkcommand','check_oracle_connection_time',NULL),(1183,'2012-06-03 09:30:36','Database API','added','command_name','check_oracle_connection_time',NULL),(1184,'2012-06-03 09:30:36','Database API','added','command_param_count','1',NULL),(1185,'2012-06-03 09:30:36','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode connection-time',NULL),(1186,'2012-06-03 09:30:36','Database API','added','default_params','!',NULL),(1187,'2012-06-03 09:30:36','Database API','created','checkcommand','check_oracle_connected_users',NULL),(1188,'2012-06-03 09:30:36','Database API','added','command_name','check_oracle_connected_users',NULL),(1189,'2012-06-03 09:30:36','Database API','added','command_param_count','1',NULL),(1190,'2012-06-03 09:30:36','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode connected-users',NULL),(1191,'2012-06-03 09:30:36','Database API','added','default_params','!',NULL),(1192,'2012-06-03 09:30:36','Database API','created','checkcommand','check_oracle_session_usage',NULL),(1193,'2012-06-03 09:30:37','Database API','added','command_name','check_oracle_session_usage',NULL),(1194,'2012-06-03 09:30:37','Database API','added','command_param_count','1',NULL),(1195,'2012-06-03 09:30:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode session-usage',NULL),(1196,'2012-06-03 09:30:37','Database API','added','default_params','!',NULL),(1197,'2012-06-03 09:30:37','Database API','created','checkcommand','check_oracle_process_usage',NULL),(1198,'2012-06-03 09:30:37','Database API','added','command_name','check_oracle_process_usage',NULL),(1199,'2012-06-03 09:30:37','Database API','added','command_param_count','1',NULL),(1200,'2012-06-03 09:30:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode process-usage',NULL),(1201,'2012-06-03 09:30:37','Database API','added','default_params','!',NULL),(1202,'2012-06-03 09:30:37','Database API','created','checkcommand','check_oracle_rman_backup_problems',NULL),(1203,'2012-06-03 09:30:37','Database API','added','command_name','check_oracle_rman_backup_problems',NULL),(1204,'2012-06-03 09:30:37','Database API','added','command_param_count','1',NULL),(1205,'2012-06-03 09:30:37','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode rman-backup-problems',NULL),(1206,'2012-06-03 09:30:37','Database API','added','default_params','!',NULL),(1207,'2012-06-03 09:30:38','Database API','created','checkcommand','check_oracle_sga_data_buffer_hit_ratio',NULL),(1208,'2012-06-03 09:30:38','Database API','added','command_name','check_oracle_sga_data_buffer_hit_ratio',NULL),(1209,'2012-06-03 09:30:38','Database API','added','command_param_count','1',NULL),(1210,'2012-06-03 09:30:38','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-data-buffer-hit-ratio',NULL),(1211,'2012-06-03 09:30:38','Database API','added','default_params','!',NULL),(1212,'2012-06-03 09:30:38','Database API','created','checkcommand','check_oracle_sga_library_cache_gethit_ratio',NULL),(1213,'2012-06-03 09:30:38','Database API','added','command_name','check_oracle_sga_library_cache_gethit_ratio',NULL),(1214,'2012-06-03 09:30:38','Database API','added','command_param_count','1',NULL),(1215,'2012-06-03 09:30:38','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-gethit-ratio',NULL),(1216,'2012-06-03 09:30:38','Database API','added','default_params','!',NULL),(1217,'2012-06-03 09:30:38','Database API','created','checkcommand','check_oracle_sga_library_cache_pinhit_ratio',NULL),(1218,'2012-06-03 09:30:38','Database API','added','command_name','check_oracle_sga_library_cache_pinhit_ratio',NULL),(1219,'2012-06-03 09:30:39','Database API','added','command_param_count','1',NULL),(1220,'2012-06-03 09:30:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-pinhit-ratio',NULL),(1221,'2012-06-03 09:30:39','Database API','added','default_params','!',NULL),(1222,'2012-06-03 09:30:39','Database API','created','checkcommand','check_oracle_sga_library_cache_reloads',NULL),(1223,'2012-06-03 09:30:39','Database API','added','command_name','check_oracle_sga_library_cache_reloads',NULL),(1224,'2012-06-03 09:30:39','Database API','added','command_param_count','1',NULL),(1225,'2012-06-03 09:30:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-library-cache-reloads',NULL),(1226,'2012-06-03 09:30:39','Database API','added','default_params','!',NULL),(1227,'2012-06-03 09:30:39','Database API','created','checkcommand','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(1228,'2012-06-03 09:30:39','Database API','added','command_name','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(1229,'2012-06-03 09:30:39','Database API','added','command_param_count','1',NULL),(1230,'2012-06-03 09:30:39','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-dictionary-cache-hit-ratio',NULL),(1231,'2012-06-03 09:30:39','Database API','added','default_params','!',NULL),(1232,'2012-06-03 09:30:39','Database API','created','checkcommand','check_oracle_sga_latches_hit_ratio',NULL),(1233,'2012-06-03 09:30:40','Database API','added','command_name','check_oracle_sga_latches_hit_ratio',NULL),(1234,'2012-06-03 09:30:40','Database API','added','command_param_count','1',NULL),(1235,'2012-06-03 09:30:40','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-latches-hit-ratio',NULL),(1236,'2012-06-03 09:30:40','Database API','added','default_params','!',NULL),(1237,'2012-06-03 09:30:40','Database API','created','checkcommand','check_oracle_sga_shared_pool_reloads',NULL),(1238,'2012-06-03 09:30:40','Database API','added','command_name','check_oracle_sga_shared_pool_reloads',NULL),(1239,'2012-06-03 09:30:40','Database API','added','command_param_count','1',NULL),(1240,'2012-06-03 09:30:40','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-shared-pool-reloads',NULL),(1241,'2012-06-03 09:30:41','Database API','added','default_params','!',NULL),(1242,'2012-06-03 09:30:41','Database API','created','checkcommand','check_oracle_sga_shared_pool_free',NULL),(1243,'2012-06-03 09:30:41','Database API','added','command_name','check_oracle_sga_shared_pool_free',NULL),(1244,'2012-06-03 09:30:41','Database API','added','command_param_count','1',NULL),(1245,'2012-06-03 09:30:41','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sga-shared-pool-free',NULL),(1246,'2012-06-03 09:30:41','Database API','added','default_params','!',NULL),(1247,'2012-06-03 09:30:41','Database API','created','checkcommand','check_oracle_pga_in_memory_sort_ratio',NULL),(1248,'2012-06-03 09:30:41','Database API','added','command_name','check_oracle_pga_in_memory_sort_ratio',NULL),(1249,'2012-06-03 09:30:41','Database API','added','command_param_count','1',NULL),(1250,'2012-06-03 09:30:41','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode pga-in-memory-sort-ratio',NULL),(1251,'2012-06-03 09:30:41','Database API','added','default_params','!',NULL),(1252,'2012-06-03 09:30:42','Database API','created','checkcommand','check_oracle_invalid_objects',NULL),(1253,'2012-06-03 09:30:42','Database API','added','command_name','check_oracle_invalid_objects',NULL),(1254,'2012-06-03 09:30:42','Database API','added','command_param_count','1',NULL),(1255,'2012-06-03 09:30:42','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode invalid-objects',NULL),(1256,'2012-06-03 09:30:42','Database API','added','default_params','!',NULL),(1257,'2012-06-03 09:30:42','Database API','created','checkcommand','check_oracle_stale_statistics',NULL),(1258,'2012-06-03 09:30:42','Database API','added','command_name','check_oracle_stale_statistics',NULL),(1259,'2012-06-03 09:30:42','Database API','added','command_param_count','1',NULL),(1260,'2012-06-03 09:30:42','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode stale-statistics',NULL),(1261,'2012-06-03 09:30:42','Database API','added','default_params','!',NULL),(1262,'2012-06-03 09:30:42','Database API','created','checkcommand','check_oracle_tablespace_usage',NULL),(1263,'2012-06-03 09:30:42','Database API','added','command_name','check_oracle_tablespace_usage',NULL),(1264,'2012-06-03 09:30:42','Database API','added','command_param_count','1',NULL),(1265,'2012-06-03 09:30:43','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-usage',NULL),(1266,'2012-06-03 09:30:43','Database API','added','default_params','!',NULL),(1267,'2012-06-03 09:30:43','Database API','created','checkcommand','check_oracle_tablespace_free',NULL),(1268,'2012-06-03 09:30:43','Database API','added','command_name','check_oracle_tablespace_free',NULL),(1269,'2012-06-03 09:30:43','Database API','added','command_param_count','1',NULL),(1270,'2012-06-03 09:30:43','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-free',NULL),(1271,'2012-06-03 09:30:43','Database API','added','default_params','!',NULL),(1272,'2012-06-03 09:30:43','Database API','created','checkcommand','check_oracle_tablespace_fragmentation',NULL),(1273,'2012-06-03 09:30:43','Database API','added','command_name','check_oracle_tablespace_fragmentation',NULL),(1274,'2012-06-03 09:30:43','Database API','added','command_param_count','1',NULL),(1275,'2012-06-03 09:30:43','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-fragmentation',NULL),(1276,'2012-06-03 09:30:44','Database API','added','default_params','!',NULL),(1277,'2012-06-03 09:30:44','Database API','created','checkcommand','check_oracle_tablespace_io_balanc',NULL),(1278,'2012-06-03 09:30:44','Database API','added','command_name','check_oracle_tablespace_io_balanc',NULL),(1279,'2012-06-03 09:30:44','Database API','added','command_param_count','1',NULL),(1280,'2012-06-03 09:30:44','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-io-balanc',NULL),(1281,'2012-06-03 09:30:44','Database API','added','default_params','!',NULL),(1282,'2012-06-03 09:30:44','Database API','created','checkcommand','check_oracle_tablespace_remaining_time',NULL),(1283,'2012-06-03 09:30:44','Database API','added','command_name','check_oracle_tablespace_remaining_time',NULL),(1284,'2012-06-03 09:30:44','Database API','added','command_param_count','1',NULL),(1285,'2012-06-03 09:30:44','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-remaining-time',NULL),(1286,'2012-06-03 09:30:44','Database API','added','default_params','!',NULL),(1287,'2012-06-03 09:30:45','Database API','created','checkcommand','check_oracle_tablespace_can_allocate_next',NULL),(1288,'2012-06-03 09:30:45','Database API','added','command_name','check_oracle_tablespace_can_allocate_next',NULL),(1289,'2012-06-03 09:30:45','Database API','added','command_param_count','1',NULL),(1290,'2012-06-03 09:30:45','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode tablespace-can-allocate-next',NULL),(1291,'2012-06-03 09:30:45','Database API','added','default_params','!',NULL),(1292,'2012-06-03 09:30:45','Database API','created','checkcommand','check_oracle_flash_recovery_area_usage',NULL),(1293,'2012-06-03 09:30:45','Database API','added','command_name','check_oracle_flash_recovery_area_usage',NULL),(1294,'2012-06-03 09:30:45','Database API','added','command_param_count','1',NULL),(1295,'2012-06-03 09:30:45','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode flash-recovery-area-usage',NULL),(1296,'2012-06-03 09:30:45','Database API','added','default_params','!',NULL),(1297,'2012-06-03 09:30:45','Database API','created','checkcommand','check_oracle_flash_recovery_area_free',NULL),(1298,'2012-06-03 09:30:45','Database API','added','command_name','check_oracle_flash_recovery_area_free',NULL),(1299,'2012-06-03 09:30:46','Database API','added','command_param_count','1',NULL),(1300,'2012-06-03 09:30:46','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode flash-recovery-area-free',NULL),(1301,'2012-06-03 09:30:46','Database API','added','default_params','!',NULL),(1302,'2012-06-03 09:30:46','Database API','created','checkcommand','check_oracle_datafile_io_traffic',NULL),(1303,'2012-06-03 09:30:46','Database API','added','command_name','check_oracle_datafile_io_traffic',NULL),(1304,'2012-06-03 09:30:46','Database API','added','command_param_count','1',NULL),(1305,'2012-06-03 09:30:46','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode datafile-io-traffic',NULL),(1306,'2012-06-03 09:30:46','Database API','added','default_params','!',NULL),(1307,'2012-06-03 09:30:46','Database API','created','checkcommand','check_oracle_datafiles_existing',NULL),(1308,'2012-06-03 09:30:46','Database API','added','command_name','check_oracle_datafiles_existing',NULL),(1309,'2012-06-03 09:30:46','Database API','added','command_param_count','1',NULL),(1310,'2012-06-03 09:30:46','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode datafiles-existing',NULL),(1311,'2012-06-03 09:30:46','Database API','added','default_params','!',NULL),(1312,'2012-06-03 09:30:47','Database API','created','checkcommand','check_oracle_soft_parse_ratio',NULL),(1313,'2012-06-03 09:30:47','Database API','added','command_name','check_oracle_soft_parse_ratio',NULL),(1314,'2012-06-03 09:30:47','Database API','added','command_param_count','1',NULL),(1315,'2012-06-03 09:30:47','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode soft-parse-ratio',NULL),(1316,'2012-06-03 09:30:47','Database API','added','default_params','!',NULL),(1317,'2012-06-03 09:30:47','Database API','created','checkcommand','check_oracle_switch_interval',NULL),(1318,'2012-06-03 09:30:47','Database API','added','command_name','check_oracle_switch_interval',NULL),(1319,'2012-06-03 09:30:47','Database API','added','command_param_count','1',NULL),(1320,'2012-06-03 09:30:47','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode switch-interval',NULL),(1321,'2012-06-03 09:30:47','Database API','added','default_params','!',NULL),(1322,'2012-06-03 09:30:47','Database API','created','checkcommand','check_oracle_retry_ratio',NULL),(1323,'2012-06-03 09:30:47','Database API','added','command_name','check_oracle_retry_ratio',NULL),(1324,'2012-06-03 09:30:47','Database API','added','command_param_count','1',NULL),(1325,'2012-06-03 09:30:48','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode retry-ratio',NULL),(1326,'2012-06-03 09:30:48','Database API','added','default_params','!',NULL),(1327,'2012-06-03 09:30:48','Database API','created','checkcommand','check_oracle_redo_io_traffic',NULL),(1328,'2012-06-03 09:30:48','Database API','added','command_name','check_oracle_redo_io_traffic',NULL),(1329,'2012-06-03 09:30:48','Database API','added','command_param_count','1',NULL),(1330,'2012-06-03 09:30:48','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode redo-io-traffic',NULL),(1331,'2012-06-03 09:30:48','Database API','added','default_params','!',NULL),(1332,'2012-06-03 09:30:48','Database API','created','checkcommand','check_oracle_roll_header_contention',NULL),(1333,'2012-06-03 09:30:48','Database API','added','command_name','check_oracle_roll_header_contention',NULL),(1334,'2012-06-03 09:30:48','Database API','added','command_param_count','1',NULL),(1335,'2012-06-03 09:30:48','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-header-contention',NULL),(1336,'2012-06-03 09:30:49','Database API','added','default_params','!',NULL),(1337,'2012-06-03 09:30:49','Database API','created','checkcommand','check_oracle_roll_block_contention',NULL),(1338,'2012-06-03 09:30:49','Database API','added','command_name','check_oracle_roll_block_contention',NULL),(1339,'2012-06-03 09:30:49','Database API','added','command_param_count','1',NULL),(1340,'2012-06-03 09:30:49','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-block-contention',NULL),(1341,'2012-06-03 09:30:49','Database API','added','default_params','!',NULL),(1342,'2012-06-03 09:30:49','Database API','created','checkcommand','check_oracle_roll_hit_ratio',NULL),(1343,'2012-06-03 09:30:49','Database API','added','command_name','check_oracle_roll_hit_ratio',NULL),(1344,'2012-06-03 09:30:49','Database API','added','command_param_count','1',NULL),(1345,'2012-06-03 09:30:49','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-hit-ratio',NULL),(1346,'2012-06-03 09:30:49','Database API','added','default_params','!',NULL),(1347,'2012-06-03 09:30:49','Database API','created','checkcommand','check_oracle_roll_extends',NULL),(1348,'2012-06-03 09:30:49','Database API','added','command_name','check_oracle_roll_extends',NULL),(1349,'2012-06-03 09:30:49','Database API','added','command_param_count','1',NULL),(1350,'2012-06-03 09:30:50','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-extends',NULL),(1351,'2012-06-03 09:30:50','Database API','added','default_params','!',NULL),(1352,'2012-06-03 09:30:50','Database API','created','checkcommand','check_oracle_roll_wraps',NULL),(1353,'2012-06-03 09:30:50','Database API','added','command_name','check_oracle_roll_wraps',NULL),(1354,'2012-06-03 09:30:50','Database API','added','command_param_count','1',NULL),(1355,'2012-06-03 09:30:50','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode roll-wraps',NULL),(1356,'2012-06-03 09:30:50','Database API','added','default_params','!',NULL),(1357,'2012-06-03 09:30:50','Database API','created','checkcommand','check_oracle_seg_top10_logical_reads',NULL),(1358,'2012-06-03 09:30:50','Database API','added','command_name','check_oracle_seg_top10_logical_reads',NULL),(1359,'2012-06-03 09:30:50','Database API','added','command_param_count','1',NULL),(1360,'2012-06-03 09:30:50','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-logical-reads',NULL),(1361,'2012-06-03 09:30:50','Database API','added','default_params','!',NULL),(1362,'2012-06-03 09:30:51','Database API','created','checkcommand','check_oracle_seg_top10_physical_reads',NULL),(1363,'2012-06-03 09:30:51','Database API','added','command_name','check_oracle_seg_top10_physical_reads',NULL),(1364,'2012-06-03 09:30:51','Database API','added','command_param_count','1',NULL),(1365,'2012-06-03 09:30:51','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-physical-reads',NULL),(1366,'2012-06-03 09:30:51','Database API','added','default_params','!',NULL),(1367,'2012-06-03 09:30:51','Database API','created','checkcommand','check_oracle_seg_top10_buffer_busy_waits',NULL),(1368,'2012-06-03 09:30:51','Database API','added','command_name','check_oracle_seg_top10_buffer_busy_waits',NULL),(1369,'2012-06-03 09:30:51','Database API','added','command_param_count','1',NULL),(1370,'2012-06-03 09:30:51','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-buffer-busy-waits',NULL),(1371,'2012-06-03 09:30:51','Database API','added','default_params','!',NULL),(1372,'2012-06-03 09:30:52','Database API','created','checkcommand','check_oracle_seg_top10_row_lock_waits',NULL),(1373,'2012-06-03 09:30:52','Database API','added','command_name','check_oracle_seg_top10_row_lock_waits',NULL),(1374,'2012-06-03 09:30:52','Database API','added','command_param_count','1',NULL),(1375,'2012-06-03 09:30:52','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode seg-top10-row-lock-waits',NULL),(1376,'2012-06-03 09:30:52','Database API','added','default_params','!',NULL),(1377,'2012-06-03 09:30:52','Database API','created','checkcommand','check_oracle_event_waits',NULL),(1378,'2012-06-03 09:30:52','Database API','added','command_name','check_oracle_event_waits',NULL),(1379,'2012-06-03 09:30:52','Database API','added','command_param_count','1',NULL),(1380,'2012-06-03 09:30:52','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode event-waits',NULL),(1381,'2012-06-03 09:30:52','Database API','added','default_params','!',NULL),(1382,'2012-06-03 09:30:52','Database API','created','checkcommand','check_oracle_event_waiting',NULL),(1383,'2012-06-03 09:30:52','Database API','added','command_name','check_oracle_event_waiting',NULL),(1384,'2012-06-03 09:30:52','Database API','added','command_param_count','1',NULL),(1385,'2012-06-03 09:30:53','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode event-waiting',NULL),(1386,'2012-06-03 09:30:53','Database API','added','default_params','!',NULL),(1387,'2012-06-03 09:30:53','Database API','created','checkcommand','check_oracle_enqueue_contention',NULL),(1388,'2012-06-03 09:30:53','Database API','added','command_name','check_oracle_enqueue_contention',NULL),(1389,'2012-06-03 09:30:53','Database API','added','command_param_count','1',NULL),(1390,'2012-06-03 09:30:53','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode enqueue-contention',NULL),(1391,'2012-06-03 09:30:53','Database API','added','default_params','!',NULL),(1392,'2012-06-03 09:30:53','Database API','created','checkcommand','check_oracle_enqueue_waiting',NULL),(1393,'2012-06-03 09:30:54','Database API','added','command_name','check_oracle_enqueue_waiting',NULL),(1394,'2012-06-03 09:30:54','Database API','added','command_param_count','1',NULL),(1395,'2012-06-03 09:30:54','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode enqueue-waiting',NULL),(1396,'2012-06-03 09:30:54','Database API','added','default_params','!',NULL),(1397,'2012-06-03 09:30:54','Database API','created','checkcommand','check_oracle_latch_contention',NULL),(1398,'2012-06-03 09:30:54','Database API','added','command_name','check_oracle_latch_contention',NULL),(1399,'2012-06-03 09:30:54','Database API','added','command_param_count','1',NULL),(1400,'2012-06-03 09:30:54','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode latch-contention',NULL),(1401,'2012-06-03 09:30:54','Database API','added','default_params','!',NULL),(1402,'2012-06-03 09:30:54','Database API','created','checkcommand','check_oracle_latch_waiting',NULL),(1403,'2012-06-03 09:30:54','Database API','added','command_name','check_oracle_latch_waiting',NULL),(1404,'2012-06-03 09:30:54','Database API','added','command_param_count','1',NULL),(1405,'2012-06-03 09:30:54','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode latch-waiting',NULL),(1406,'2012-06-03 09:30:55','Database API','added','default_params','!',NULL),(1407,'2012-06-03 09:30:55','Database API','created','checkcommand','check_oracle_sysstat',NULL),(1408,'2012-06-03 09:30:55','Database API','added','command_name','check_oracle_sysstat',NULL),(1409,'2012-06-03 09:30:55','Database API','added','command_param_count','1',NULL),(1410,'2012-06-03 09:30:55','Database API','added','command_line','$PLUGINSDIR$/check_oracle_health --connect \"$ARG1$\" --user \"$ORACLEUSER$\" --password \"$ORACLEPASSWORD$\" --mode sysstat',NULL),(1411,'2012-06-03 09:30:55','Database API','added','default_params','!',NULL),(1412,'2012-06-03 09:30:55','Database API','created','checkcommand','check_mongodb_connection',NULL),(1413,'2012-06-03 09:30:56','Database API','added','command_name','check_mongodb_connection',NULL),(1414,'2012-06-03 09:30:56','Database API','added','command_param_count','0',NULL),(1415,'2012-06-03 09:30:56','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A connect -W 2 -c 4',NULL),(1416,'2012-06-03 09:30:56','Database API','added','default_params','!',NULL),(1417,'2012-06-03 09:30:56','Database API','created','checkcommand','check_mongodb_open_connections',NULL),(1418,'2012-06-03 09:30:56','Database API','added','command_name','check_mongodb_open_connections',NULL),(1419,'2012-06-03 09:30:56','Database API','added','command_param_count','0',NULL),(1420,'2012-06-03 09:30:56','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A connections -W 70 -c 80',NULL),(1421,'2012-06-03 09:30:56','Database API','added','default_params','!',NULL),(1422,'2012-06-03 09:30:56','Database API','created','checkcommand','check_mongodb_replication_lag',NULL),(1423,'2012-06-03 09:30:56','Database API','added','command_name','check_mongodb_replication_lag',NULL),(1424,'2012-06-03 09:30:56','Database API','added','command_param_count','0',NULL),(1425,'2012-06-03 09:30:57','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A replication_lag -W 15 -c 30',NULL),(1426,'2012-06-03 09:30:57','Database API','added','default_params','!',NULL),(1427,'2012-06-03 09:30:57','Database API','created','checkcommand','check_mongodb_lock_time',NULL),(1428,'2012-06-03 09:30:57','Database API','added','command_name','check_mongodb_lock_time',NULL),(1429,'2012-06-03 09:30:57','Database API','added','command_param_count','0',NULL),(1430,'2012-06-03 09:30:57','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A lock -W 5 -c 10',NULL),(1431,'2012-06-03 09:30:57','Database API','added','default_params','!',NULL),(1432,'2012-06-03 09:30:57','Database API','created','checkcommand','check_mongodb_flush_time',NULL),(1433,'2012-06-03 09:30:57','Database API','added','command_name','check_mongodb_flush_time',NULL),(1434,'2012-06-03 09:30:57','Database API','added','command_param_count','0',NULL),(1435,'2012-06-03 09:30:57','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A flushing -W 100 -c 200',NULL),(1436,'2012-06-03 09:30:58','Database API','added','default_params','!',NULL),(1437,'2012-06-03 09:30:58','Database API','created','checkcommand','check_mongodb_last_flush',NULL),(1438,'2012-06-03 09:30:58','Database API','added','command_name','check_mongodb_last_flush',NULL),(1439,'2012-06-03 09:30:58','Database API','added','command_param_count','0',NULL),(1440,'2012-06-03 09:30:58','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A last_flush_time -W 200 -c 400',NULL),(1441,'2012-06-03 09:30:58','Database API','added','default_params','!',NULL),(1442,'2012-06-03 09:30:58','Database API','created','checkcommand','check_mongodb_replicaset',NULL),(1443,'2012-06-03 09:30:58','Database API','added','command_name','check_mongodb_replicaset',NULL),(1444,'2012-06-03 09:30:58','Database API','added','command_param_count','0',NULL),(1445,'2012-06-03 09:30:58','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A replset_state -W 0 -c 0',NULL),(1446,'2012-06-03 09:30:58','Database API','added','default_params','!',NULL),(1447,'2012-06-03 09:30:58','Database API','created','checkcommand','check_mongodb_index_miss_ratio',NULL),(1448,'2012-06-03 09:30:59','Database API','added','command_name','check_mongodb_index_miss_ratio',NULL),(1449,'2012-06-03 09:30:59','Database API','added','command_param_count','0',NULL),(1450,'2012-06-03 09:30:59','Database API','added','command_line','$PLUGINSDIR$/check_mongodb.py -H $HOSTADDRESS$ -P 27017 -A index_miss_ration -W .005 -c .01',NULL),(1451,'2012-06-03 09:30:59','Database API','added','default_params','!',NULL),(1452,'2012-06-03 09:31:00','Database API','created','checkcommand','check_mysql_connection',NULL),(1453,'2012-06-03 09:31:00','Database API','added','command_name','check_mysql_connection',NULL),(1454,'2012-06-03 09:31:00','Database API','added','command_param_count','0',NULL),(1455,'2012-06-03 09:31:00','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode connection-time --warning $_HOSTCONNECTIONTIME_WARN$ --critical $_HOSTCONNECTIONTIME_CRIT$',NULL),(1456,'2012-06-03 09:31:00','Database API','added','default_params','!',NULL),(1457,'2012-06-03 09:31:00','Database API','created','checkcommand','check_mysql_querycache_hitrate',NULL),(1458,'2012-06-03 09:31:00','Database API','added','command_name','check_mysql_querycache_hitrate',NULL),(1459,'2012-06-03 09:31:00','Database API','added','command_param_count','0',NULL),(1460,'2012-06-03 09:31:01','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode querycache-hitrate --warning $_HOSTQUERYCACHEHITRATE_WARN$ --critical $_HOSTQUERYCACHEHITRATE_CRIT$',NULL),(1461,'2012-06-03 09:31:01','Database API','added','default_params','!',NULL),(1462,'2012-06-03 09:31:01','Database API','created','checkcommand','check_mysql_uptime',NULL),(1463,'2012-06-03 09:31:01','Database API','added','command_name','check_mysql_uptime',NULL),(1464,'2012-06-03 09:31:01','Database API','added','command_param_count','0',NULL),(1465,'2012-06-03 09:31:01','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode uptime',NULL),(1466,'2012-06-03 09:31:01','Database API','added','default_params','!',NULL),(1467,'2012-06-03 09:31:01','Database API','created','checkcommand','check_mysql_threads_connected',NULL),(1468,'2012-06-03 09:31:01','Database API','added','command_name','check_mysql_threads_connected',NULL),(1469,'2012-06-03 09:31:01','Database API','added','command_param_count','0',NULL),(1470,'2012-06-03 09:31:02','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode threads-connected --warning $_HOSTTHREADSCONNECTED_WARN$ --critical $_HOSTTHREADSCONNECTED_CRIT$',NULL),(1471,'2012-06-03 09:31:02','Database API','added','default_params','!',NULL),(1472,'2012-06-03 09:31:02','Database API','created','checkcommand','check_mysql_qcache_hitrate',NULL),(1473,'2012-06-03 09:31:02','Database API','added','command_name','check_mysql_qcache_hitrate',NULL),(1474,'2012-06-03 09:31:02','Database API','added','command_param_count','0',NULL),(1475,'2012-06-03 09:31:02','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode qcache-hitrate --warning $_HOSTQCACHEHITRATE_WARN$ --critical $_HOSTQCACHEHITRATE_CRIT$',NULL),(1476,'2012-06-03 09:31:02','Database API','added','default_params','!',NULL),(1477,'2012-06-03 09:31:02','Database API','created','checkcommand','check_mysql_qcache_lowmem_prunes',NULL),(1478,'2012-06-03 09:31:02','Database API','added','command_name','check_mysql_qcache_lowmem_prunes',NULL),(1479,'2012-06-03 09:31:02','Database API','added','command_param_count','0',NULL),(1480,'2012-06-03 09:31:03','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode qcache-lowmem-prunes --warning $_HOSTQCACHELOWMEMPRUNES_WARN$ --critical $_HOSTQCACHELOWMEMPRUNES_CRIT$',NULL),(1481,'2012-06-03 09:31:03','Database API','added','default_params','!',NULL),(1482,'2012-06-03 09:31:03','Database API','created','checkcommand','check_mysql_keycache_hitrate',NULL),(1483,'2012-06-03 09:31:03','Database API','added','command_name','check_mysql_keycache_hitrate',NULL),(1484,'2012-06-03 09:31:03','Database API','added','command_param_count','0',NULL),(1485,'2012-06-03 09:31:03','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode keycache-hitrate --warning $_HOSTKEYCACHEHITRATE_WARN$ --critical $_HOSTKEYCACHEHITRATE_CRIT$',NULL),(1486,'2012-06-03 09:31:03','Database API','added','default_params','!',NULL),(1487,'2012-06-03 09:31:03','Database API','created','checkcommand','check_mysql_bufferpool_hitrate',NULL),(1488,'2012-06-03 09:31:03','Database API','added','command_name','check_mysql_bufferpool_hitrate',NULL),(1489,'2012-06-03 09:31:03','Database API','added','command_param_count','0',NULL),(1490,'2012-06-03 09:31:03','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode bufferpool-hitrate --warning $_HOSTBUFFERPOOLHITRATE_WARN$ --critical $_HOSTBUFFERPOOLHITRATE_CRIT$',NULL),(1491,'2012-06-03 09:31:04','Database API','added','default_params','!',NULL),(1492,'2012-06-03 09:31:04','Database API','created','checkcommand','check_mysql_bufferpool_wait_free',NULL),(1493,'2012-06-03 09:31:04','Database API','added','command_name','check_mysql_bufferpool_wait_free',NULL),(1494,'2012-06-03 09:31:04','Database API','added','command_param_count','0',NULL),(1495,'2012-06-03 09:31:04','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode bufferpool-wait-free --warning $_HOSTBUFFERPOOLWAITFREE_WARN$ --critical $_HOSTBUFFERPOOLWAITFREE_CRIT$',NULL),(1496,'2012-06-03 09:31:04','Database API','added','default_params','!',NULL),(1497,'2012-06-03 09:31:04','Database API','created','checkcommand','check_mysql_log_waits',NULL),(1498,'2012-06-03 09:31:04','Database API','added','command_name','check_mysql_log_waits',NULL),(1499,'2012-06-03 09:31:04','Database API','added','command_param_count','0',NULL),(1500,'2012-06-03 09:31:04','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode log-waits --warning $_HOSTLOGWAITS_WARN$ --critical $_HOSTLOGWAITS_CRIT$',NULL),(1501,'2012-06-03 09:31:04','Database API','added','default_params','!',NULL),(1502,'2012-06-03 09:31:04','Database API','created','checkcommand','check_mysql_tablecache_hitrate',NULL),(1503,'2012-06-03 09:31:04','Database API','added','command_name','check_mysql_tablecache_hitrate',NULL),(1504,'2012-06-03 09:31:04','Database API','added','command_param_count','0',NULL),(1505,'2012-06-03 09:31:05','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode tablecache-hitrate --warning $_HOSTTABLECACHEHITRATE_WARN$ --critical $_HOSTTABLECACHEHITRATE_CRIT$',NULL),(1506,'2012-06-03 09:31:05','Database API','added','default_params','!',NULL),(1507,'2012-06-03 09:31:05','Database API','created','checkcommand','check_mysql_table_lock_contention',NULL),(1508,'2012-06-03 09:31:05','Database API','added','command_name','check_mysql_table_lock_contention',NULL),(1509,'2012-06-03 09:31:05','Database API','added','command_param_count','0',NULL),(1510,'2012-06-03 09:31:05','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode table-lock-contention --warning $_HOSTTABLELOCKCONTENTION_WARN$ --critical $_HOSTTABLELOCKCONTENTION_CRIT$',NULL),(1511,'2012-06-03 09:31:05','Database API','added','default_params','!',NULL),(1512,'2012-06-03 09:31:05','Database API','created','checkcommand','check_mysql_index_usage',NULL),(1513,'2012-06-03 09:31:05','Database API','added','command_name','check_mysql_index_usage',NULL),(1514,'2012-06-03 09:31:05','Database API','added','command_param_count','0',NULL),(1515,'2012-06-03 09:31:05','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode index-usage --warning $_HOSTINDEXUSAGE_WARN$ --critical $_HOSTINDEXUSAGE_CRIT$',NULL),(1516,'2012-06-03 09:31:05','Database API','added','default_params','!',NULL),(1517,'2012-06-03 09:31:06','Database API','created','checkcommand','check_mysql_tmp_disk_tables',NULL),(1518,'2012-06-03 09:31:06','Database API','added','command_name','check_mysql_tmp_disk_tables',NULL),(1519,'2012-06-03 09:31:06','Database API','added','command_param_count','0',NULL),(1520,'2012-06-03 09:31:06','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode tmp-disk-tables --warning $_HOSTTMPDISKTABLES_WARN$ --critical $_HOSTTMPDISKTABLES_CRIT$',NULL),(1521,'2012-06-03 09:31:06','Database API','added','default_params','!',NULL),(1522,'2012-06-03 09:31:06','Database API','created','checkcommand','check_mysql_slow_queries',NULL),(1523,'2012-06-03 09:31:06','Database API','added','command_name','check_mysql_slow_queries',NULL),(1524,'2012-06-03 09:31:06','Database API','added','command_param_count','0',NULL),(1525,'2012-06-03 09:31:06','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slow-queries --warning $_HOSTSLOWQUERIES_WARN$ --critical $_HOSTSLOWQUERIES_CRIT$',NULL),(1526,'2012-06-03 09:31:07','Database API','added','default_params','!',NULL),(1527,'2012-06-03 09:31:07','Database API','created','checkcommand','check_mysql_long_running_procs',NULL),(1528,'2012-06-03 09:31:07','Database API','added','command_name','check_mysql_long_running_procs',NULL),(1529,'2012-06-03 09:31:07','Database API','added','command_param_count','0',NULL),(1530,'2012-06-03 09:31:07','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode long-running-procs --warning $_HOSTLONGRUNNINGPROCS_WARN$ --critical $_HOSTLONGRUNNINGPROCS_CRIT$',NULL),(1531,'2012-06-03 09:31:07','Database API','added','default_params','!',NULL),(1532,'2012-06-03 09:31:07','Database API','created','checkcommand','check_mysql_slave_lag',NULL),(1533,'2012-06-03 09:31:07','Database API','added','command_name','check_mysql_slave_lag',NULL),(1534,'2012-06-03 09:31:07','Database API','added','command_param_count','0',NULL),(1535,'2012-06-03 09:31:07','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-lag --warning $_HOSTSLAVELAG_WARN$ --critical $_HOSTSLAVELAG_CRIT$',NULL),(1536,'2012-06-03 09:31:07','Database API','added','default_params','!',NULL),(1537,'2012-06-03 09:31:07','Database API','created','checkcommand','check_mysql_slave_io_running',NULL),(1538,'2012-06-03 09:31:07','Database API','added','command_name','check_mysql_slave_io_running',NULL),(1539,'2012-06-03 09:31:08','Database API','added','command_param_count','0',NULL),(1540,'2012-06-03 09:31:08','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-io-running',NULL),(1541,'2012-06-03 09:31:08','Database API','added','default_params','!',NULL),(1542,'2012-06-03 09:31:08','Database API','created','checkcommand','check_mysql_slave_sql_running',NULL),(1543,'2012-06-03 09:31:08','Database API','added','command_name','check_mysql_slave_sql_running',NULL),(1544,'2012-06-03 09:31:08','Database API','added','command_param_count','0',NULL),(1545,'2012-06-03 09:31:08','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode slave-sql-running',NULL),(1546,'2012-06-03 09:31:08','Database API','added','default_params','!',NULL),(1547,'2012-06-03 09:31:08','Database API','created','checkcommand','check_mysql_open_files',NULL),(1548,'2012-06-03 09:31:08','Database API','added','command_name','check_mysql_open_files',NULL),(1549,'2012-06-03 09:31:08','Database API','added','command_param_count','0',NULL),(1550,'2012-06-03 09:31:08','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode open-files --warning $_HOSTOPENFILES_WARN$ --critical $_HOSTOPENFILES_CRIT$',NULL),(1551,'2012-06-03 09:31:08','Database API','added','default_params','!',NULL),(1552,'2012-06-03 09:31:09','Database API','created','checkcommand','check_mysql_cluster_ndb_running',NULL),(1553,'2012-06-03 09:31:09','Database API','added','command_name','check_mysql_cluster_ndb_running',NULL),(1554,'2012-06-03 09:31:09','Database API','added','command_param_count','0',NULL),(1555,'2012-06-03 09:31:09','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode cluster-ndb-running',NULL),(1556,'2012-06-03 09:31:09','Database API','added','default_params','!',NULL),(1557,'2012-06-03 09:31:09','Database API','created','checkcommand','check_mysql_threadcache_hitrate',NULL),(1558,'2012-06-03 09:31:09','Database API','added','command_name','check_mysql_threadcache_hitrate',NULL),(1559,'2012-06-03 09:31:09','Database API','added','command_param_count','0',NULL),(1560,'2012-06-03 09:31:09','Database API','added','command_line','$PLUGINSDIR$/check_mysql_health --hostname $HOSTADDRESS$ --username $MYSQLUSER$ --password $MYSQLPASSWORD$ --mode threadcache-hitrate --warning $_HOSTTHREADCACHE_WARN$ --critical $_HOSTTHREADCACHE_CRIT$',NULL),(1561,'2012-06-03 09:31:09','Database API','added','default_params','!',NULL),(1562,'2012-06-03 09:31:10','Database API','created','checkcommand','check_mssql_connection',NULL),(1563,'2012-06-03 09:31:10','Database API','added','command_name','check_mssql_connection',NULL),(1564,'2012-06-03 09:31:10','Database API','added','command_param_count','0',NULL),(1565,'2012-06-03 09:31:11','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode connection-time',NULL),(1566,'2012-06-03 09:31:11','Database API','added','default_params','!',NULL),(1567,'2012-06-03 09:31:11','Database API','created','checkcommand','check_mssql_connected_users',NULL),(1568,'2012-06-03 09:31:11','Database API','added','command_name','check_mssql_connected_users',NULL),(1569,'2012-06-03 09:31:11','Database API','added','command_param_count','0',NULL),(1570,'2012-06-03 09:31:11','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode connected-users',NULL),(1571,'2012-06-03 09:31:11','Database API','added','default_params','!',NULL),(1572,'2012-06-03 09:31:11','Database API','created','checkcommand','check_mssql_cpu_busy',NULL),(1573,'2012-06-03 09:31:11','Database API','added','command_name','check_mssql_cpu_busy',NULL),(1574,'2012-06-03 09:31:11','Database API','added','command_param_count','0',NULL),(1575,'2012-06-03 09:31:11','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode cpu-busy',NULL),(1576,'2012-06-03 09:31:11','Database API','added','default_params','!',NULL),(1577,'2012-06-03 09:31:11','Database API','created','checkcommand','check_mssql_io_busy',NULL),(1578,'2012-06-03 09:31:12','Database API','added','command_name','check_mssql_io_busy',NULL),(1579,'2012-06-03 09:31:12','Database API','added','command_param_count','0',NULL),(1580,'2012-06-03 09:31:12','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode io-busy',NULL),(1581,'2012-06-03 09:31:12','Database API','added','default_params','!',NULL),(1582,'2012-06-03 09:31:12','Database API','created','checkcommand','check_mssql_full_scans',NULL),(1583,'2012-06-03 09:31:12','Database API','added','command_name','check_mssql_full_scans',NULL),(1584,'2012-06-03 09:31:12','Database API','added','command_param_count','0',NULL),(1585,'2012-06-03 09:31:12','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode full-scans',NULL),(1586,'2012-06-03 09:31:12','Database API','added','default_params','!',NULL),(1587,'2012-06-03 09:31:13','Database API','created','checkcommand','check_mssql_transactions',NULL),(1588,'2012-06-03 09:31:13','Database API','added','command_name','check_mssql_transactions',NULL),(1589,'2012-06-03 09:31:13','Database API','added','command_param_count','0',NULL),(1590,'2012-06-03 09:31:13','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode transactions',NULL),(1591,'2012-06-03 09:31:13','Database API','added','default_params','!',NULL),(1592,'2012-06-03 09:31:13','Database API','created','checkcommand','check_mssql_batch_requests',NULL),(1593,'2012-06-03 09:31:13','Database API','added','command_name','check_mssql_batch_requests',NULL),(1594,'2012-06-03 09:31:13','Database API','added','command_param_count','0',NULL),(1595,'2012-06-03 09:31:13','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode batch-requests',NULL),(1596,'2012-06-03 09:31:13','Database API','added','default_params','!',NULL),(1597,'2012-06-03 09:31:13','Database API','created','checkcommand','check_mssql_latches_waits',NULL),(1598,'2012-06-03 09:31:13','Database API','added','command_name','check_mssql_latches_waits',NULL),(1599,'2012-06-03 09:31:13','Database API','added','command_param_count','0',NULL),(1600,'2012-06-03 09:31:13','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode latches-waits',NULL),(1601,'2012-06-03 09:31:14','Database API','added','default_params','!',NULL),(1602,'2012-06-03 09:31:14','Database API','created','checkcommand','check_mssql_latches_wait_time',NULL),(1603,'2012-06-03 09:31:14','Database API','added','command_name','check_mssql_latches_wait_time',NULL),(1604,'2012-06-03 09:31:14','Database API','added','command_param_count','0',NULL),(1605,'2012-06-03 09:31:14','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode latches-wait-time',NULL),(1606,'2012-06-03 09:31:14','Database API','added','default_params','!',NULL),(1607,'2012-06-03 09:31:14','Database API','created','checkcommand','check_mssql_locks_waits',NULL),(1608,'2012-06-03 09:31:14','Database API','added','command_name','check_mssql_locks_waits',NULL),(1609,'2012-06-03 09:31:14','Database API','added','command_param_count','0',NULL),(1610,'2012-06-03 09:31:14','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-waits',NULL),(1611,'2012-06-03 09:31:14','Database API','added','default_params','!',NULL),(1612,'2012-06-03 09:31:14','Database API','created','checkcommand','check_mssql_locks_timeouts',NULL),(1613,'2012-06-03 09:31:15','Database API','added','command_name','check_mssql_locks_timeouts',NULL),(1614,'2012-06-03 09:31:15','Database API','added','command_param_count','0',NULL),(1615,'2012-06-03 09:31:15','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-timeouts',NULL),(1616,'2012-06-03 09:31:15','Database API','added','default_params','!',NULL),(1617,'2012-06-03 09:31:15','Database API','created','checkcommand','check_mssql_locks_deadlocks',NULL),(1618,'2012-06-03 09:31:15','Database API','added','command_name','check_mssql_locks_deadlocks',NULL),(1619,'2012-06-03 09:31:15','Database API','added','command_param_count','0',NULL),(1620,'2012-06-03 09:31:15','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode locks-deadlocks',NULL),(1621,'2012-06-03 09:31:15','Database API','added','default_params','!',NULL),(1622,'2012-06-03 09:31:15','Database API','created','checkcommand','check_mssql_sql_recompilations',NULL),(1623,'2012-06-03 09:31:15','Database API','added','command_name','check_mssql_sql_recompilations',NULL),(1624,'2012-06-03 09:31:15','Database API','added','command_param_count','0',NULL),(1625,'2012-06-03 09:31:15','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode sql-recompilations',NULL),(1626,'2012-06-03 09:31:16','Database API','added','default_params','!',NULL),(1627,'2012-06-03 09:31:16','Database API','created','checkcommand','check_mssql_sql_initcompilations',NULL),(1628,'2012-06-03 09:31:16','Database API','added','command_name','check_mssql_sql_initcompilations',NULL),(1629,'2012-06-03 09:31:16','Database API','added','command_param_count','0',NULL),(1630,'2012-06-03 09:31:16','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode sql-initcompilations',NULL),(1631,'2012-06-03 09:31:16','Database API','added','default_params','!',NULL),(1632,'2012-06-03 09:31:16','Database API','created','checkcommand','check_mssql_total_server_memory',NULL),(1633,'2012-06-03 09:31:16','Database API','added','command_name','check_mssql_total_server_memory',NULL),(1634,'2012-06-03 09:31:16','Database API','added','command_param_count','0',NULL),(1635,'2012-06-03 09:31:16','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode total-server-memory',NULL),(1636,'2012-06-03 09:31:16','Database API','added','default_params','!',NULL),(1637,'2012-06-03 09:31:17','Database API','created','checkcommand','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(1638,'2012-06-03 09:31:17','Database API','added','command_name','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(1639,'2012-06-03 09:31:17','Database API','added','command_param_count','0',NULL),(1640,'2012-06-03 09:31:17','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode mem-pool-data-buffer-hit-ratio',NULL),(1641,'2012-06-03 09:31:17','Database API','added','default_params','!',NULL),(1642,'2012-06-03 09:31:17','Database API','created','checkcommand','check_mssql_lazy_writes',NULL),(1643,'2012-06-03 09:31:17','Database API','added','command_name','check_mssql_lazy_writes',NULL),(1644,'2012-06-03 09:31:17','Database API','added','command_param_count','0',NULL),(1645,'2012-06-03 09:31:17','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode lazy-writes',NULL),(1646,'2012-06-03 09:31:17','Database API','added','default_params','!',NULL),(1647,'2012-06-03 09:31:17','Database API','created','checkcommand','check_mssql_page_life_expectancy',NULL),(1648,'2012-06-03 09:31:17','Database API','added','command_name','check_mssql_page_life_expectancy',NULL),(1649,'2012-06-03 09:31:17','Database API','added','command_param_count','0',NULL),(1650,'2012-06-03 09:31:18','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode page-life-expectancy',NULL),(1651,'2012-06-03 09:31:18','Database API','added','default_params','!',NULL),(1652,'2012-06-03 09:31:18','Database API','created','checkcommand','check_mssql_free_list_stalls',NULL),(1653,'2012-06-03 09:31:18','Database API','added','command_name','check_mssql_free_list_stalls',NULL),(1654,'2012-06-03 09:31:18','Database API','added','command_param_count','0',NULL),(1655,'2012-06-03 09:31:18','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode free-list-stalls',NULL),(1656,'2012-06-03 09:31:18','Database API','added','default_params','!',NULL),(1657,'2012-06-03 09:31:18','Database API','created','checkcommand','check_mssql_checkpoint_pages',NULL),(1658,'2012-06-03 09:31:18','Database API','added','command_name','check_mssql_checkpoint_pages',NULL),(1659,'2012-06-03 09:31:18','Database API','added','command_param_count','0',NULL),(1660,'2012-06-03 09:31:18','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode checkpoint-pages',NULL),(1661,'2012-06-03 09:31:18','Database API','added','default_params','!',NULL),(1662,'2012-06-03 09:31:19','Database API','created','checkcommand','check_mssql_database_free',NULL),(1663,'2012-06-03 09:31:19','Database API','added','command_name','check_mssql_database_free',NULL),(1664,'2012-06-03 09:31:19','Database API','added','command_param_count','0',NULL),(1665,'2012-06-03 09:31:19','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode database-free',NULL),(1666,'2012-06-03 09:31:19','Database API','added','default_params','!',NULL),(1667,'2012-06-03 09:31:19','Database API','created','checkcommand','check_mssql_database_backup_age',NULL),(1668,'2012-06-03 09:31:19','Database API','added','command_name','check_mssql_database_backup_age',NULL),(1669,'2012-06-03 09:31:19','Database API','added','command_param_count','0',NULL),(1670,'2012-06-03 09:31:19','Database API','added','command_line','$PLUGINSDIR$/check_mssql_health --hostname $HOSTADDRESS$ --username \"$MSSQLUSER$\" --password \"$MSSQLPASSWORD$\" --mode database-backup-age',NULL),(1671,'2012-06-03 09:31:19','Database API','added','default_params','!',NULL),(1672,'2012-06-03 09:31:20','Database API','created','checkcommand','check_akcp',NULL),(1673,'2012-06-03 09:31:20','Database API','added','command_name','check_akcp',NULL),(1674,'2012-06-03 09:31:20','Database API','added','command_param_count','0',NULL),(1675,'2012-06-03 09:31:20','Database API','added','command_line','$PLUGINSDIR$/check_akcp.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -P 1 -w 26 -c 30',NULL),(1676,'2012-06-03 09:31:20','Database API','added','default_params','!',NULL),(1677,'2012-06-03 09:31:20','Database API','created','checkcommand','check_aix_disks',NULL),(1678,'2012-06-03 09:31:20','Database API','added','command_name','check_aix_disks',NULL),(1679,'2012-06-03 09:31:20','Database API','added','command_param_count','0',NULL),(1680,'2012-06-03 09:31:20','Database API','added','command_line','$PLUGINSDIR$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -m / -f -w $_HOSTSTORAGE_WARN$ -c $_HOSTSTORAGE_CRIT$ -S0,1',NULL),(1681,'2012-06-03 09:31:21','Database API','added','default_params','!',NULL),(1682,'2012-06-03 09:31:21','Database API','created','checkcommand','check_aix_cpu',NULL),(1683,'2012-06-03 09:31:21','Database API','added','command_name','check_aix_cpu',NULL),(1684,'2012-06-03 09:31:21','Database API','added','command_param_count','0',NULL),(1685,'2012-06-03 09:31:21','Database API','added','command_line','$PLUGINSDIR$/check_snmp_load.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTCPU_WARN$ -c $_HOSTCPU_CRIT$',NULL),(1686,'2012-06-03 09:31:21','Database API','added','default_params','!',NULL),(1687,'2012-06-03 09:31:21','Database API','created','checkcommand','check_aix_memory',NULL),(1688,'2012-06-03 09:31:21','Database API','added','command_name','check_aix_memory',NULL),(1689,'2012-06-03 09:31:21','Database API','added','command_param_count','0',NULL),(1690,'2012-06-03 09:31:21','Database API','added','command_line','$PLUGINSDIR$/check_snmp_mem.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTMEMORY_WARN$ -c $_HOSTMEMORY_CRIT$',NULL),(1691,'2012-06-03 09:31:21','Database API','added','default_params','!',NULL),(1692,'2012-06-03 09:31:22','Database API','created','checkcommand','check_linux_disks',NULL),(1693,'2012-06-03 09:31:22','Database API','added','command_name','check_linux_disks',NULL),(1694,'2012-06-03 09:31:22','Database API','added','command_param_count','0',NULL),(1695,'2012-06-03 09:31:22','Database API','added','command_line','$PLUGINSDIR$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -m / -f -w $_HOSTSTORAGE_WARN$ -c $_HOSTSTORAGE_CRIT$ -S0,1',NULL),(1696,'2012-06-03 09:31:22','Database API','added','default_params','!',NULL),(1697,'2012-06-03 09:31:22','Database API','created','checkcommand','check_linux_cpu',NULL),(1698,'2012-06-03 09:31:22','Database API','added','command_name','check_linux_cpu',NULL),(1699,'2012-06-03 09:31:23','Database API','added','command_param_count','0',NULL),(1700,'2012-06-03 09:31:23','Database API','added','command_line','$PLUGINSDIR$/check_snmp_load.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTCPU_WARN$ -c $_HOSTCPU_CRIT$',NULL),(1701,'2012-06-03 09:31:23','Database API','added','default_params','!',NULL),(1702,'2012-06-03 09:31:23','Database API','created','checkcommand','check_linux_network_usage',NULL),(1703,'2012-06-03 09:31:23','Database API','added','command_name','check_linux_network_usage',NULL),(1704,'2012-06-03 09:31:23','Database API','added','command_param_count','0',NULL),(1705,'2012-06-03 09:31:23','Database API','added','command_line','$PLUGINSDIR$/check_snmp_int.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -n eth -k -M -y -e -w 0,0 -c 0,0',NULL),(1706,'2012-06-03 09:31:23','Database API','added','default_params','!',NULL),(1707,'2012-06-03 09:31:23','Database API','created','checkcommand','check_linux_memory',NULL),(1708,'2012-06-03 09:31:23','Database API','added','command_name','check_linux_memory',NULL),(1709,'2012-06-03 09:31:23','Database API','added','command_param_count','0',NULL),(1710,'2012-06-03 09:31:24','Database API','added','command_line','$PLUGINSDIR$/check_snmp_mem.pl -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -f -w $_HOSTMEMORY_WARN$ -c $_HOSTMEMORY_CRIT$',NULL),(1711,'2012-06-03 09:31:24','Database API','added','default_params','!',NULL),(1712,'2012-06-03 09:31:24','Database API','created','checkcommand','check_windows_disks',NULL),(1713,'2012-06-03 09:31:25','Database API','added','command_name','check_windows_disks',NULL),(1714,'2012-06-03 09:31:25','Database API','added','command_param_count','0',NULL),(1715,'2012-06-03 09:31:25','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkdrivesize -a \'.\' -w 90 -c 95 -o 0 -3 0',NULL),(1716,'2012-06-03 09:31:25','Database API','added','default_params','!',NULL),(1717,'2012-06-03 09:31:25','Database API','created','checkcommand','check_windows_eventlogs',NULL),(1718,'2012-06-03 09:31:25','Database API','added','command_name','check_windows_eventlogs',NULL),(1719,'2012-06-03 09:31:25','Database API','added','command_param_count','1',NULL),(1720,'2012-06-03 09:31:25','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkeventlog -a $ARG1$ -o 2 -3 1 -w 1 -c 2',NULL),(1721,'2012-06-03 09:31:25','Database API','added','default_params','!',NULL),(1722,'2012-06-03 09:31:25','Database API','created','checkcommand','check_windows_reboot',NULL),(1723,'2012-06-03 09:31:25','Database API','added','command_name','check_windows_reboot',NULL),(1724,'2012-06-03 09:31:25','Database API','added','command_param_count','0',NULL),(1725,'2012-06-03 09:31:26','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkuptime -w \'5min:\' -c \'15min:\'',NULL),(1726,'2012-06-03 09:31:26','Database API','added','default_params','!',NULL),(1727,'2012-06-03 09:31:26','Database API','created','checkcommand','check_windows_physical_memory',NULL),(1728,'2012-06-03 09:31:26','Database API','added','command_name','check_windows_physical_memory',NULL),(1729,'2012-06-03 09:31:26','Database API','added','command_param_count','0',NULL),(1730,'2012-06-03 09:31:26','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkmem -w 80 -c 90',NULL),(1731,'2012-06-03 09:31:26','Database API','added','default_params','!',NULL),(1732,'2012-06-03 09:31:26','Database API','created','checkcommand','check_windows_swap',NULL),(1733,'2012-06-03 09:31:26','Database API','added','command_name','check_windows_swap',NULL),(1734,'2012-06-03 09:31:26','Database API','added','command_param_count','0',NULL),(1735,'2012-06-03 09:31:26','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkpage -a auto',NULL),(1736,'2012-06-03 09:31:26','Database API','added','default_params','!',NULL),(1737,'2012-06-03 09:31:26','Database API','created','checkcommand','check_windows_overall_cpu',NULL),(1738,'2012-06-03 09:31:27','Database API','added','command_name','check_windows_overall_cpu',NULL),(1739,'2012-06-03 09:31:27','Database API','added','command_param_count','0',NULL),(1740,'2012-06-03 09:31:27','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkcpu -w 80 -c 90',NULL),(1741,'2012-06-03 09:31:27','Database API','added','default_params','!',NULL),(1742,'2012-06-03 09:31:27','Database API','created','checkcommand','check_windows_each_cpu',NULL),(1743,'2012-06-03 09:31:27','Database API','added','command_name','check_windows_each_cpu',NULL),(1744,'2012-06-03 09:31:27','Database API','added','command_param_count','0',NULL),(1745,'2012-06-03 09:31:27','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkeachcpu -w 80 -c 90',NULL),(1746,'2012-06-03 09:31:27','Database API','added','default_params','!',NULL),(1747,'2012-06-03 09:31:27','Database API','created','checkcommand','check_windows_loadaverage',NULL),(1748,'2012-06-03 09:31:27','Database API','added','command_name','check_windows_loadaverage',NULL),(1749,'2012-06-03 09:31:27','Database API','added','command_param_count','0',NULL),(1750,'2012-06-03 09:31:28','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkcpuq -w 10 -c 20 -a 20 -y 0',NULL),(1751,'2012-06-03 09:31:28','Database API','added','default_params','!',NULL),(1752,'2012-06-03 09:31:28','Database API','created','checkcommand','check_windows_auto_services',NULL),(1753,'2012-06-03 09:31:28','Database API','added','command_name','check_windows_auto_services',NULL),(1754,'2012-06-03 09:31:28','Database API','added','command_param_count','0',NULL),(1755,'2012-06-03 09:31:28','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkservice -a Auto -o \'\' -w 0 -c 1',NULL),(1756,'2012-06-03 09:31:28','Database API','added','default_params','!',NULL),(1757,'2012-06-03 09:31:28','Database API','created','checkcommand','check_windows_big_processes',NULL),(1758,'2012-06-03 09:31:28','Database API','added','command_name','check_windows_big_processes',NULL),(1759,'2012-06-03 09:31:28','Database API','added','command_param_count','0',NULL),(1760,'2012-06-03 09:31:28','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkproc -s cpuabove -a \'%\' -w 25 -exc _AvgCPU=@0:2 --nodataexit 0 --nodatastring \"No processes with high CPU found\"',NULL),(1761,'2012-06-03 09:31:28','Database API','added','default_params','!',NULL),(1762,'2012-06-03 09:31:29','Database API','created','checkcommand','check_windows_big_process',NULL),(1763,'2012-06-03 09:31:29','Database API','added','command_name','check_windows_big_process',NULL),(1764,'2012-06-03 09:31:29','Database API','added','command_param_count','1',NULL),(1765,'2012-06-03 09:31:29','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkproc -s cpu -a \'$ARG1$\' --nodatamode',NULL),(1766,'2012-06-03 09:31:29','Database API','added','default_params','!',NULL),(1767,'2012-06-03 09:31:29','Database API','created','checkcommand','check_windows_disks_io',NULL),(1768,'2012-06-03 09:31:29','Database API','added','command_name','check_windows_disks_io',NULL),(1769,'2012-06-03 09:31:29','Database API','added','command_param_count','0',NULL),(1770,'2012-06-03 09:31:29','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkio -s logical -a \'%\'',NULL),(1771,'2012-06-03 09:31:29','Database API','added','default_params','!',NULL),(1772,'2012-06-03 09:31:29','Database API','created','checkcommand','check_windows_inactive_ts_sessions',NULL),(1773,'2012-06-03 09:31:29','Database API','added','command_name','check_windows_inactive_ts_sessions',NULL),(1774,'2012-06-03 09:31:29','Database API','added','command_param_count','0',NULL),(1775,'2012-06-03 09:31:29','Database API','added','command_line','$PLUGINSDIR$/check_wmi_plus.pl -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSER$\" -p \"$_HOSTDOMAINPASSWORD$\" -m checkts -s sessions2003 -w \'InactiveSessions=0:1\'',NULL),(1776,'2012-06-03 09:31:30','Database API','added','default_params','!',NULL),(1777,'2012-06-03 09:31:30','Database API','created','checkcommand','check_windows_share',NULL),(1778,'2012-06-03 09:31:30','Database API','added','command_name','check_windows_share',NULL),(1779,'2012-06-03 09:31:30','Database API','added','command_param_count','1',NULL),(1780,'2012-06-03 09:31:30','Database API','added','command_line','$PLUGINSDIR$/check_disk_smb -H $HOSTADDRESS$ -u \"$_HOSTDOMAINUSERSHORT$\" -p \"$_HOSTDOMAINPASSWORD$\" -W \'$_HOSTDOMAIN$\' -s \'$ARG1$\' -w $_HOSTSHARE_WARN$ -c $_HOSTSHARE_CRIT$',NULL),(1781,'2012-06-03 09:31:30','Database API','added','default_params','!',NULL),(1782,'2012-06-03 09:31:31','Database API','created','checkcommand','check_netapp_cpu',NULL),(1783,'2012-06-03 09:31:31','Database API','added','command_name','check_netapp_cpu',NULL),(1784,'2012-06-03 09:31:31','Database API','added','command_param_count','0',NULL),(1785,'2012-06-03 09:31:31','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v CPULOAD',NULL),(1786,'2012-06-03 09:31:31','Database API','added','default_params','!',NULL),(1787,'2012-06-03 09:31:31','Database API','created','checkcommand','check_netapp_disks',NULL),(1788,'2012-06-03 09:31:31','Database API','added','command_name','check_netapp_disks',NULL),(1789,'2012-06-03 09:31:31','Database API','added','command_param_count','0',NULL),(1790,'2012-06-03 09:31:31','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v DISKUSED',NULL),(1791,'2012-06-03 09:31:31','Database API','added','default_params','!',NULL),(1792,'2012-06-03 09:31:31','Database API','created','checkcommand','check_netapp_faileddisk',NULL),(1793,'2012-06-03 09:31:31','Database API','added','command_name','check_netapp_faileddisk',NULL),(1794,'2012-06-03 09:31:31','Database API','added','command_param_count','0',NULL),(1795,'2012-06-03 09:31:31','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v FAILEDDISK',NULL),(1796,'2012-06-03 09:31:32','Database API','added','default_params','!',NULL),(1797,'2012-06-03 09:31:32','Database API','created','checkcommand','check_netapp_fan',NULL),(1798,'2012-06-03 09:31:32','Database API','added','command_name','check_netapp_fan',NULL),(1799,'2012-06-03 09:31:32','Database API','added','command_param_count','0',NULL),(1800,'2012-06-03 09:31:32','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v FAN',NULL),(1801,'2012-06-03 09:31:32','Database API','added','default_params','!',NULL),(1802,'2012-06-03 09:31:32','Database API','created','checkcommand','check_netapp_nvram',NULL),(1803,'2012-06-03 09:31:32','Database API','added','command_name','check_netapp_nvram',NULL),(1804,'2012-06-03 09:31:32','Database API','added','command_param_count','0',NULL),(1805,'2012-06-03 09:31:32','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v NVRAM',NULL),(1806,'2012-06-03 09:31:32','Database API','added','default_params','!',NULL),(1807,'2012-06-03 09:31:33','Database API','created','checkcommand','check_netapp_power_supply',NULL),(1808,'2012-06-03 09:31:33','Database API','added','command_name','check_netapp_power_supply',NULL),(1809,'2012-06-03 09:31:33','Database API','added','command_param_count','0',NULL),(1810,'2012-06-03 09:31:33','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v PS',NULL),(1811,'2012-06-03 09:31:33','Database API','added','default_params','!',NULL),(1812,'2012-06-03 09:31:33','Database API','created','checkcommand','check_netapp_snapshots',NULL),(1813,'2012-06-03 09:31:33','Database API','added','command_name','check_netapp_snapshots',NULL),(1814,'2012-06-03 09:31:33','Database API','added','command_param_count','0',NULL),(1815,'2012-06-03 09:31:33','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v SNAPSHOT',NULL),(1816,'2012-06-03 09:31:34','Database API','added','default_params','!',NULL),(1817,'2012-06-03 09:31:34','Database API','created','checkcommand','check_netapp_temperature',NULL),(1818,'2012-06-03 09:31:34','Database API','added','command_name','check_netapp_temperature',NULL),(1819,'2012-06-03 09:31:34','Database API','added','command_param_count','0',NULL),(1820,'2012-06-03 09:31:34','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v TEMP',NULL),(1821,'2012-06-03 09:31:34','Database API','added','default_params','!',NULL),(1822,'2012-06-03 09:31:34','Database API','created','checkcommand','check_netapp_uptime',NULL),(1823,'2012-06-03 09:31:34','Database API','added','command_name','check_netapp_uptime',NULL),(1824,'2012-06-03 09:31:34','Database API','added','command_param_count','0',NULL),(1825,'2012-06-03 09:31:34','Database API','added','command_line','$PLUGINSDIR$/check_netapp2 -H $HOSTADDRESS$ -C $_HOSTSNMPCOMMUNITY$ -v UPTIME',NULL),(1826,'2012-06-03 09:31:34','Database API','added','default_params','!',NULL),(1827,'2012-06-03 09:31:35','Database API','created','checkcommand','check_emc_spa',NULL),(1828,'2012-06-03 09:31:35','Database API','added','command_name','check_emc_spa',NULL),(1829,'2012-06-03 09:31:35','Database API','added','command_param_count','0',NULL),(1830,'2012-06-03 09:31:35','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t sp --sp A',NULL),(1831,'2012-06-03 09:31:35','Database API','added','default_params','!',NULL),(1832,'2012-06-03 09:31:35','Database API','created','checkcommand','check_emc_spb',NULL),(1833,'2012-06-03 09:31:35','Database API','added','command_name','check_emc_spb',NULL),(1834,'2012-06-03 09:31:35','Database API','added','command_param_count','0',NULL),(1835,'2012-06-03 09:31:36','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t sp --sp B',NULL),(1836,'2012-06-03 09:31:36','Database API','added','default_params','!',NULL),(1837,'2012-06-03 09:31:36','Database API','created','checkcommand','check_emc_disks',NULL),(1838,'2012-06-03 09:31:36','Database API','added','command_name','check_emc_disks',NULL),(1839,'2012-06-03 09:31:36','Database API','added','command_param_count','0',NULL),(1840,'2012-06-03 09:31:36','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t disk',NULL),(1841,'2012-06-03 09:31:36','Database API','added','default_params','!',NULL),(1842,'2012-06-03 09:31:36','Database API','created','checkcommand','check_emc_cache',NULL),(1843,'2012-06-03 09:31:36','Database API','added','command_name','check_emc_cache',NULL),(1844,'2012-06-03 09:31:36','Database API','added','command_param_count','0',NULL),(1845,'2012-06-03 09:31:36','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t cache',NULL),(1846,'2012-06-03 09:31:36','Database API','added','default_params','!',NULL),(1847,'2012-06-03 09:31:37','Database API','created','checkcommand','check_emc_faults',NULL),(1848,'2012-06-03 09:31:37','Database API','added','command_name','check_emc_faults',NULL),(1849,'2012-06-03 09:31:37','Database API','added','command_param_count','0',NULL),(1850,'2012-06-03 09:31:37','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t faults',NULL),(1851,'2012-06-03 09:31:37','Database API','added','default_params','!',NULL),(1852,'2012-06-03 09:31:37','Database API','created','checkcommand','check_emc_ports',NULL),(1853,'2012-06-03 09:31:37','Database API','added','command_name','check_emc_ports',NULL),(1854,'2012-06-03 09:31:37','Database API','added','command_param_count','0',NULL),(1855,'2012-06-03 09:31:37','Database API','added','command_line','$PLUGINSDIR$/check_emc_clariion.pl -H $HOSTADDRESS$ -u $NAVISECCLIUSER$ -p $NAVISECCLIPASSWORD$ -t portstate',NULL),(1856,'2012-06-03 09:31:37','Database API','added','default_params','!',NULL),(1857,'2012-06-03 09:31:38','Database API','created','checkcommand','check_esx_vm_cpu',NULL),(1858,'2012-06-03 09:31:38','Database API','added','command_name','check_esx_vm_cpu',NULL),(1859,'2012-06-03 09:31:38','Database API','added','command_param_count','0',NULL),(1860,'2012-06-03 09:31:38','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l cpu',NULL),(1861,'2012-06-03 09:31:38','Database API','added','default_params','!',NULL),(1862,'2012-06-03 09:31:38','Database API','created','checkcommand','check_esx_vm_io',NULL),(1863,'2012-06-03 09:31:38','Database API','added','command_name','check_esx_vm_io',NULL),(1864,'2012-06-03 09:31:38','Database API','added','command_param_count','0',NULL),(1865,'2012-06-03 09:31:39','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l io',NULL),(1866,'2012-06-03 09:31:39','Database API','added','default_params','!',NULL),(1867,'2012-06-03 09:31:39','Database API','created','checkcommand','check_esx_vm_net',NULL),(1868,'2012-06-03 09:31:39','Database API','added','command_name','check_esx_vm_net',NULL),(1869,'2012-06-03 09:31:39','Database API','added','command_param_count','0',NULL),(1870,'2012-06-03 09:31:39','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l net',NULL),(1871,'2012-06-03 09:31:39','Database API','added','default_params','!',NULL),(1872,'2012-06-03 09:31:39','Database API','created','checkcommand','check_esx_vm_mem',NULL),(1873,'2012-06-03 09:31:39','Database API','added','command_name','check_esx_vm_mem',NULL),(1874,'2012-06-03 09:31:39','Database API','added','command_param_count','0',NULL),(1875,'2012-06-03 09:31:39','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l mem',NULL),(1876,'2012-06-03 09:31:39','Database API','added','default_params','!',NULL),(1877,'2012-06-03 09:31:40','Database API','created','checkcommand','check_esx_host',NULL),(1878,'2012-06-03 09:31:40','Database API','added','command_name','check_esx_host',NULL),(1879,'2012-06-03 09:31:40','Database API','added','command_param_count','1',NULL),(1880,'2012-06-03 09:31:40','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l $ARG1$',NULL),(1881,'2012-06-03 09:31:40','Database API','added','default_params','!',NULL),(1882,'2012-06-03 09:31:40','Database API','created','checkcommand','check_esx_vm',NULL),(1883,'2012-06-03 09:31:40','Database API','added','command_name','check_esx_vm',NULL),(1884,'2012-06-03 09:31:40','Database API','added','command_param_count','1',NULL),(1885,'2012-06-03 09:31:41','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -N $HOSTALIAS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l $ARG1$',NULL),(1886,'2012-06-03 09:31:41','Database API','added','default_params','!',NULL),(1887,'2012-06-03 09:31:41','Database API','created','checkcommand','check_esx_host_cpu',NULL),(1888,'2012-06-03 09:31:41','Database API','added','command_name','check_esx_host_cpu',NULL),(1889,'2012-06-03 09:31:41','Database API','added','command_param_count','0',NULL),(1890,'2012-06-03 09:31:41','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l cpu',NULL),(1891,'2012-06-03 09:31:41','Database API','added','default_params','!',NULL),(1892,'2012-06-03 09:31:41','Database API','created','checkcommand','check_esx_host_io',NULL),(1893,'2012-06-03 09:31:41','Database API','added','command_name','check_esx_host_io',NULL),(1894,'2012-06-03 09:31:41','Database API','added','command_param_count','0',NULL),(1895,'2012-06-03 09:31:41','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l io',NULL),(1896,'2012-06-03 09:31:41','Database API','added','default_params','!',NULL),(1897,'2012-06-03 09:31:41','Database API','created','checkcommand','check_esx_host_net',NULL),(1898,'2012-06-03 09:31:42','Database API','added','command_name','check_esx_host_net',NULL),(1899,'2012-06-03 09:31:42','Database API','added','command_param_count','0',NULL),(1900,'2012-06-03 09:31:42','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l net',NULL),(1901,'2012-06-03 09:31:42','Database API','added','default_params','!',NULL),(1902,'2012-06-03 09:31:42','Database API','created','checkcommand','check_esx_host_mem',NULL),(1903,'2012-06-03 09:31:42','Database API','added','command_name','check_esx_host_mem',NULL),(1904,'2012-06-03 09:31:42','Database API','added','command_param_count','0',NULL),(1905,'2012-06-03 09:31:42','Database API','added','command_line','$PLUGINSDIR$/check_esx3.pl -D $VCENTER$ -H $HOSTADDRESS$ -u $VCENTERLOGIN$ -p $VCENTERPASSWORD$ -l mem',NULL),(1906,'2012-06-03 09:31:42','Database API','added','default_params','!',NULL),(1907,'2012-06-03 09:31:43','Database API','created','checkcommand','check_hpjd',NULL),(1908,'2012-06-03 09:31:43','Database API','added','command_name','check_hpjd',NULL),(1909,'2012-06-03 09:31:43','Database API','added','command_param_count','0',NULL),(1910,'2012-06-03 09:31:43','Database API','added','command_line','$PLUGINSDIR$/check_hpjd -H $HOSTADDRESS$ -C $SNMPCOMMUNITYREAD$',NULL),(1911,'2012-06-03 09:31:43','Database API','added','default_params','!',NULL),(1912,'2012-06-03 09:31:43','Database API','created','checkcommand','check_ldap',NULL),(1913,'2012-06-03 09:31:43','Database API','added','command_name','check_ldap',NULL),(1914,'2012-06-03 09:31:44','Database API','added','command_param_count','0',NULL),(1915,'2012-06-03 09:31:44','Database API','added','command_line','$PLUGINSDIR$/check_ldap -H $HOSTADDRESS$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\"',NULL),(1916,'2012-06-03 09:31:44','Database API','added','default_params','!',NULL),(1917,'2012-06-03 09:31:44','Database API','created','checkcommand','check_ldap3',NULL),(1918,'2012-06-03 09:31:44','Database API','added','command_name','check_ldap3',NULL),(1919,'2012-06-03 09:31:44','Database API','added','command_param_count','0',NULL),(1920,'2012-06-03 09:31:44','Database API','added','command_line','$PLUGINSDIR$/check_ldap -H $HOSTADDRESS$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\" -3',NULL),(1921,'2012-06-03 09:31:44','Database API','added','default_params','!',NULL),(1922,'2012-06-03 09:31:44','Database API','created','checkcommand','check_ldaps',NULL),(1923,'2012-06-03 09:31:45','Database API','added','command_name','check_ldaps',NULL),(1924,'2012-06-03 09:31:45','Database API','added','command_param_count','0',NULL),(1925,'2012-06-03 09:31:45','Database API','added','command_line','$PLUGINSDIR$/check_ldaps -H $HOSTNAME$ -b \"$LDAPBASE$\" -D $DOMAINUSER$ -P \"$DOMAINPASSWORD$\"',NULL),(1926,'2012-06-03 09:31:45','Database API','added','default_params','!',NULL),(1927,'2012-06-03 09:31:45','Database API','created','checkcommand','check_ldaps_certificate',NULL),(1928,'2012-06-03 09:31:45','Database API','added','command_name','check_ldaps_certificate',NULL),(1929,'2012-06-03 09:31:45','Database API','added','command_param_count','0',NULL),(1930,'2012-06-03 09:31:45','Database API','added','command_line','$PLUGINSDIR$/check_tcp -H $HOSTADDRESS$ -p 636 -D 30',NULL),(1931,'2012-06-03 09:31:45','Database API','added','default_params','!',NULL),(1932,'2012-06-03 09:31:46','Database API','created','checkcommand','check_dns',NULL),(1933,'2012-06-03 09:31:46','Database API','added','command_name','check_dns',NULL),(1934,'2012-06-03 09:31:46','Database API','added','command_param_count','0',NULL),(1935,'2012-06-03 09:31:46','Database API','added','command_line','$PLUGINSDIR$/check_dns -H $_HOSTDNSHOSTNAME$ -a $_HOSTDNSEXPECTEDRESULT$ -s $HOSTADDRESS$',NULL),(1936,'2012-06-03 09:31:46','Database API','added','default_params','!',NULL),(1937,'2012-06-03 09:31:46','Database API','created','checkcommand','check_smtp',NULL),(1938,'2012-06-03 09:31:46','Database API','added','command_name','check_smtp',NULL),(1939,'2012-06-03 09:31:46','Database API','added','command_param_count','0',NULL),(1940,'2012-06-03 09:31:46','Database API','added','command_line','$PLUGINSDIR$/check_smtp -H $HOSTADDRESS$',NULL),(1941,'2012-06-03 09:31:47','Database API','added','default_params','!',NULL),(1942,'2012-06-03 09:31:47','Database API','created','checkcommand','check_smtps',NULL),(1943,'2012-06-03 09:31:47','Database API','added','command_name','check_smtps',NULL),(1944,'2012-06-03 09:31:47','Database API','added','command_param_count','0',NULL),(1945,'2012-06-03 09:31:47','Database API','added','command_line','$PLUGINSDIR$/check_smtp -H $HOSTADDRESS$ -S',NULL),(1946,'2012-06-03 09:31:47','Database API','added','default_params','!',NULL),(1947,'2012-06-03 09:31:47','Database API','created','checkcommand','check_smtps_certificate',NULL),(1948,'2012-06-03 09:31:47','Database API','added','command_name','check_smtps_certificate',NULL),(1949,'2012-06-03 09:31:47','Database API','added','command_param_count','0',NULL),(1950,'2012-06-03 09:31:47','Database API','added','command_line','$PLUGINSDIR$/check_smtp -H $HOSTADDRESS$ -S -D 30',NULL),(1951,'2012-06-03 09:31:47','Database API','added','default_params','!',NULL),(1952,'2012-06-03 09:31:48','Database API','created','checkcommand','check_imap',NULL),(1953,'2012-06-03 09:31:48','Database API','added','command_name','check_imap',NULL),(1954,'2012-06-03 09:31:48','Database API','added','command_param_count','0',NULL),(1955,'2012-06-03 09:31:48','Database API','added','command_line','$PLUGINSDIR$/check_imap -H $HOSTADDRESS$',NULL),(1956,'2012-06-03 09:31:48','Database API','added','default_params','!',NULL),(1957,'2012-06-03 09:31:48','Database API','created','checkcommand','check_imaps',NULL),(1958,'2012-06-03 09:31:48','Database API','added','command_name','check_imaps',NULL),(1959,'2012-06-03 09:31:48','Database API','added','command_param_count','0',NULL),(1960,'2012-06-03 09:31:48','Database API','added','command_line','$PLUGINSDIR$/check_imap -H $HOSTADDRESS$ -S',NULL),(1961,'2012-06-03 09:31:48','Database API','added','default_params','!',NULL),(1962,'2012-06-03 09:31:49','Database API','created','checkcommand','check_imaps_certificate',NULL),(1963,'2012-06-03 09:31:49','Database API','added','command_name','check_imaps_certificate',NULL),(1964,'2012-06-03 09:31:49','Database API','added','command_param_count','0',NULL),(1965,'2012-06-03 09:31:49','Database API','added','command_line','$PLUGINSDIR$/check_imap -H $HOSTADDRESS$ -S -D 30',NULL),(1966,'2012-06-03 09:31:49','Database API','added','default_params','!',NULL),(1967,'2012-06-03 09:31:49','Database API','created','checkcommand','check_sip',NULL),(1968,'2012-06-03 09:31:49','Database API','added','command_name','check_sip',NULL),(1969,'2012-06-03 09:31:49','Database API','added','command_param_count','0',NULL),(1970,'2012-06-03 09:31:49','Database API','added','command_line','$PLUGINSDIR$/check_sip -H $HOSTADDRESS$ -u sip:$SIPUSER$',NULL),(1971,'2012-06-03 09:31:50','Database API','added','default_params','!',NULL),(1972,'2012-06-03 09:31:50','Database API','created','checkcommand','check_ftp',NULL),(1973,'2012-06-03 09:31:50','Database API','added','command_name','check_ftp',NULL),(1974,'2012-06-03 09:31:50','Database API','added','command_param_count','0',NULL),(1975,'2012-06-03 09:31:50','Database API','added','command_line','$PLUGINSDIR$/check_ftp -H $HOSTADDRESS$',NULL),(1976,'2012-06-03 09:31:50','Database API','added','default_params','!',NULL),(1977,'2012-06-03 09:31:50','Database API','created','checkcommand','check_http',NULL),(1978,'2012-06-03 09:31:50','Database API','added','command_name','check_http',NULL),(1979,'2012-06-03 09:31:51','Database API','added','command_param_count','0',NULL),(1980,'2012-06-03 09:31:51','Database API','added','command_line','$PLUGINSDIR$/check_http -H $HOSTADDRESS$',NULL),(1981,'2012-06-03 09:31:51','Database API','added','default_params','!',NULL),(1982,'2012-06-03 09:31:51','Database API','created','checkcommand','check_https',NULL),(1983,'2012-06-03 09:31:51','Database API','added','command_name','check_https',NULL),(1984,'2012-06-03 09:31:51','Database API','added','command_param_count','0',NULL),(1985,'2012-06-03 09:31:51','Database API','added','command_line','$PLUGINSDIR$/check_http -H $HOSTADDRESS$ -S --sni',NULL),(1986,'2012-06-03 09:31:51','Database API','added','default_params','!',NULL),(1987,'2012-06-03 09:31:51','Database API','created','checkcommand','check_https_certificate',NULL),(1988,'2012-06-03 09:31:51','Database API','added','command_name','check_https_certificate',NULL),(1989,'2012-06-03 09:31:51','Database API','added','command_param_count','0',NULL),(1990,'2012-06-03 09:31:51','Database API','added','command_line','$PLUGINSDIR$/check_http -H $HOSTADDRESS$ -C 30 --sni',NULL),(1991,'2012-06-03 09:31:51','Database API','added','default_params','!',NULL),(1992,'2012-06-03 09:31:52','Database API','created','checkcommand','check_ssh',NULL),(1993,'2012-06-03 09:31:52','Database API','added','command_name','check_ssh',NULL),(1994,'2012-06-03 09:31:52','Database API','added','command_param_count','0',NULL),(1995,'2012-06-03 09:31:52','Database API','added','command_line','$PLUGINSDIR$/check_ssh -p $_HOSTSSHPORT$ $HOSTADDRESS$',NULL),(1996,'2012-06-03 09:31:52','Database API','added','default_params','!',NULL),(1997,'2012-06-03 09:31:52','Database API','created','checkcommand','check_dhcp',NULL),(1998,'2012-06-03 09:31:52','Database API','added','command_name','check_dhcp',NULL),(1999,'2012-06-03 09:31:52','Database API','added','command_param_count','0',NULL),(2000,'2012-06-03 09:31:53','Database API','added','command_line','$PLUGINSDIR$/check_dhcp -s $HOSTADDRESS$',NULL),(2001,'2012-06-03 09:31:53','Database API','added','default_params','!',NULL),(2002,'2012-06-03 09:31:53','Database API','created','checkcommand','check_pop3',NULL),(2003,'2012-06-03 09:31:53','Database API','added','command_name','check_pop3',NULL),(2004,'2012-06-03 09:31:53','Database API','added','command_param_count','0',NULL),(2005,'2012-06-03 09:31:53','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$',NULL),(2006,'2012-06-03 09:31:53','Database API','added','default_params','!',NULL),(2007,'2012-06-03 09:31:53','Database API','created','checkcommand','check_pop3s',NULL),(2008,'2012-06-03 09:31:53','Database API','added','command_name','check_pop3s',NULL),(2009,'2012-06-03 09:31:53','Database API','added','command_param_count','0',NULL),(2010,'2012-06-03 09:31:54','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$ -S',NULL),(2011,'2012-06-03 09:31:54','Database API','added','default_params','!',NULL),(2012,'2012-06-03 09:31:54','Database API','created','checkcommand','check_pop3s_certificate',NULL),(2013,'2012-06-03 09:31:54','Database API','added','command_name','check_pop3s_certificate',NULL),(2014,'2012-06-03 09:31:54','Database API','added','command_param_count','0',NULL),(2015,'2012-06-03 09:31:54','Database API','added','command_line','$PLUGINSDIR$/check_pop -H $HOSTADDRESS$ -S -D 30',NULL),(2016,'2012-06-03 09:31:54','Database API','added','default_params','!',NULL),(2017,'2012-06-03 09:31:55','Database API','created','checkcommand','check_switch_interface_status',NULL),(2018,'2012-06-03 09:31:55','Database API','added','command_name','check_switch_interface_status',NULL),(2019,'2012-06-03 09:31:55','Database API','added','command_param_count','0',NULL),(2020,'2012-06-03 09:31:55','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-status',NULL),(2021,'2012-06-03 09:31:55','Database API','added','default_params','!',NULL),(2022,'2012-06-03 09:31:55','Database API','created','checkcommand','check_switch_interface_usage',NULL),(2023,'2012-06-03 09:31:55','Database API','added','command_name','check_switch_interface_usage',NULL),(2024,'2012-06-03 09:31:55','Database API','added','command_param_count','0',NULL),(2025,'2012-06-03 09:31:55','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-usage',NULL),(2026,'2012-06-03 09:31:55','Database API','added','default_params','!',NULL),(2027,'2012-06-03 09:31:55','Database API','created','checkcommand','check_switch_interface_errors',NULL),(2028,'2012-06-03 09:31:56','Database API','added','command_name','check_switch_interface_errors',NULL),(2029,'2012-06-03 09:31:56','Database API','added','command_param_count','0',NULL),(2030,'2012-06-03 09:31:56','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode interface-errors',NULL),(2031,'2012-06-03 09:31:56','Database API','added','default_params','!',NULL),(2032,'2012-06-03 09:31:56','Database API','created','checkcommand','check_switch_hardware_health',NULL),(2033,'2012-06-03 09:31:56','Database API','added','command_name','check_switch_hardware_health',NULL),(2034,'2012-06-03 09:31:56','Database API','added','command_param_count','0',NULL),(2035,'2012-06-03 09:31:56','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode hardware-health',NULL),(2036,'2012-06-03 09:31:57','Database API','added','default_params','!',NULL),(2037,'2012-06-03 09:31:57','Database API','created','checkcommand','check_switch_cpu',NULL),(2038,'2012-06-03 09:31:57','Database API','added','command_name','check_switch_cpu',NULL),(2039,'2012-06-03 09:31:57','Database API','added','command_param_count','0',NULL),(2040,'2012-06-03 09:31:57','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode cpu-load',NULL),(2041,'2012-06-03 09:31:57','Database API','added','default_params','!',NULL),(2042,'2012-06-03 09:31:57','Database API','created','checkcommand','check_switch_memory',NULL),(2043,'2012-06-03 09:31:57','Database API','added','command_name','check_switch_memory',NULL),(2044,'2012-06-03 09:31:57','Database API','added','command_param_count','0',NULL),(2045,'2012-06-03 09:31:57','Database API','added','command_line','$PLUGINSDIR$/check_nwc_health --hostname $HOSTADDRESS$ --timeout 60 --community $_HOSTSNMPCOMMUNITY$ --mode memory-usage',NULL),(2046,'2012-06-03 09:31:57','Database API','added','default_params','!',NULL),(2047,'2012-06-03 09:37:27','admin','created','host-preset','linux',5732),(2048,'2012-06-03 09:37:27','admin','added','host preset name','linux',5732),(2049,'2012-06-03 09:37:27','admin','assigned','host-alive check','check-host-alive',5732),(2050,'2012-06-03 09:37:27','admin','assigned','host preset commands','check_linux_disks',5732),(2051,'2012-06-03 09:37:27','admin','assigned','host preset commands','check_linux_memory',5732),(2052,'2012-06-03 09:37:27','admin','assigned','host preset commands','check_linux_network_usage',5732),(2053,'2012-06-03 09:38:59','admin','created','host','shinken-central',NULL),(2054,'2012-06-03 09:38:59','admin','added','hostname','shinken-central',NULL),(2055,'2012-06-03 09:38:59','admin','added','alias','shinken-central',NULL),(2056,'2012-06-03 09:38:59','admin','added','address','localhost',NULL),(2057,'2012-06-03 09:39:00','admin','assigned','OS','Linux',NULL),(2058,'2012-06-03 09:39:00','admin','assigned','host preset','linux',NULL),(2059,'2012-06-03 09:39:00','admin','assigned','monitored by','Default Nagios',NULL),(2060,'2012-06-03 09:39:00','admin','added','host is collector','no',NULL),(2061,'2012-06-03 09:39:00','admin','assigned','check period','24x7',NULL),(2062,'2012-06-03 09:39:00','admin','assigned','notification period','24x7',NULL),(2063,'2012-06-03 09:39:00','admin','assigned','host template(s)','generic-host',NULL),(2064,'2012-06-03 09:39:00','admin','assigned','contact groups','admins',NULL),(2065,'2012-06-03 09:39:00','admin','added','notes','',NULL),(2066,'2012-06-03 09:39:00','admin','added','notes URL','',NULL),(2067,'2012-06-03 09:39:00','admin','added','action URL','',NULL),(2068,'2012-06-03 09:39:00','admin','added','max check attempts','',NULL),(2069,'2012-06-03 09:39:00','admin','added','check interval','',NULL),(2070,'2012-06-03 09:39:01','admin','added','retry interval','',NULL),(2071,'2012-06-03 09:39:01','admin','added','first notification delay','',NULL),(2072,'2012-06-03 09:39:01','admin','added','notification interval','',NULL),(2073,'2012-06-03 09:39:01','admin','added','notification options','',NULL),(2074,'2012-06-03 09:39:01','admin','added','active checking','',NULL),(2075,'2012-06-03 09:39:01','admin','added','passive checking','',NULL),(2076,'2012-06-03 09:39:01','admin','added','notification enabled','',NULL),(2077,'2012-06-03 09:39:01','admin','added','check freshness','',NULL),(2078,'2012-06-03 09:39:01','admin','added','freshness threshold','',NULL),(2079,'2012-06-03 09:39:03','admin','created','service','shinken-central: check_linux_disks',NULL),(2080,'2012-06-03 09:39:03','admin','added','service name','check_linux_disks',NULL),(2081,'2012-06-03 09:39:03','admin','added','service','shinken-central: check_linux_disks',NULL),(2082,'2012-06-03 09:39:03','admin','added','params for check command','!',NULL),(2083,'2012-06-03 09:39:03','admin','assigned','check period','24x7',NULL),(2084,'2012-06-03 09:39:03','admin','assigned','notification period','24x7',NULL),(2085,'2012-06-03 09:39:03','admin','assigned','contact groups','admins',NULL),(2086,'2012-06-03 09:39:03','admin','added','notes','',NULL),(2087,'2012-06-03 09:39:03','admin','added','notes URL','',NULL),(2088,'2012-06-03 09:39:03','admin','added','action URL','',NULL),(2089,'2012-06-03 09:39:03','admin','added','service enabled','yes',NULL),(2090,'2012-06-03 09:39:03','admin','added','max check attempts','',NULL),(2091,'2012-06-03 09:39:03','admin','added','check interval','',NULL),(2092,'2012-06-03 09:39:04','admin','added','retry interval','',NULL),(2093,'2012-06-03 09:39:04','admin','added','first notification delay','',NULL),(2094,'2012-06-03 09:39:04','admin','added','notification interval','',NULL),(2095,'2012-06-03 09:39:04','admin','added','notification options','',NULL),(2096,'2012-06-03 09:39:04','admin','added','active checking','',NULL),(2097,'2012-06-03 09:39:04','admin','added','passive checking','',NULL),(2098,'2012-06-03 09:39:04','admin','added','notification enabled','',NULL),(2099,'2012-06-03 09:39:04','admin','added','check freshness','',NULL),(2100,'2012-06-03 09:39:04','admin','added','freshness threshold','',NULL),(2101,'2012-06-03 09:39:04','admin','added','event-handler enabled','0',NULL),(2102,'2012-06-03 09:39:04','admin','created','service','shinken-central: check_linux_network_usage',NULL),(2103,'2012-06-03 09:39:04','admin','added','service name','check_linux_network_usage',NULL),(2104,'2012-06-03 09:39:04','admin','added','service','shinken-central: check_linux_network_usage',NULL),(2105,'2012-06-03 09:39:04','admin','added','params for check command','!',NULL),(2106,'2012-06-03 09:39:05','admin','assigned','check period','24x7',NULL),(2107,'2012-06-03 09:39:05','admin','assigned','notification period','24x7',NULL),(2108,'2012-06-03 09:39:05','admin','assigned','contact groups','admins',NULL),(2109,'2012-06-03 09:39:05','admin','added','notes','',NULL),(2110,'2012-06-03 09:39:05','admin','added','notes URL','',NULL),(2111,'2012-06-03 09:39:05','admin','added','action URL','',NULL),(2112,'2012-06-03 09:39:05','admin','added','service enabled','yes',NULL),(2113,'2012-06-03 09:39:05','admin','added','max check attempts','',NULL),(2114,'2012-06-03 09:39:05','admin','added','check interval','',NULL),(2115,'2012-06-03 09:39:05','admin','added','retry interval','',NULL),(2116,'2012-06-03 09:39:06','admin','added','first notification delay','',NULL),(2117,'2012-06-03 09:39:06','admin','added','notification interval','',NULL),(2118,'2012-06-03 09:39:06','admin','added','notification options','',NULL),(2119,'2012-06-03 09:39:06','admin','added','active checking','',NULL),(2120,'2012-06-03 09:39:06','admin','added','passive checking','',NULL),(2121,'2012-06-03 09:39:06','admin','added','notification enabled','',NULL),(2122,'2012-06-03 09:39:06','admin','added','check freshness','',NULL),(2123,'2012-06-03 09:39:06','admin','added','freshness threshold','',NULL),(2124,'2012-06-03 09:39:06','admin','added','event-handler enabled','0',NULL),(2125,'2012-06-03 09:39:06','admin','created','service','shinken-central: check_linux_memory',NULL),(2126,'2012-06-03 09:39:06','admin','added','service name','check_linux_memory',NULL),(2127,'2012-06-03 09:39:06','admin','added','service','shinken-central: check_linux_memory',NULL),(2128,'2012-06-03 09:39:06','admin','added','params for check command','!',NULL),(2129,'2012-06-03 09:39:07','admin','assigned','check period','24x7',NULL),(2130,'2012-06-03 09:39:07','admin','assigned','notification period','24x7',NULL),(2131,'2012-06-03 09:39:07','admin','assigned','contact groups','admins',NULL),(2132,'2012-06-03 09:39:07','admin','added','notes','',NULL),(2133,'2012-06-03 09:39:07','admin','added','notes URL','',NULL),(2134,'2012-06-03 09:39:07','admin','added','action URL','',NULL),(2135,'2012-06-03 09:39:07','admin','added','service enabled','yes',NULL),(2136,'2012-06-03 09:39:07','admin','added','max check attempts','',NULL),(2137,'2012-06-03 09:39:07','admin','added','check interval','',NULL),(2138,'2012-06-03 09:39:07','admin','added','retry interval','',NULL),(2139,'2012-06-03 09:39:08','admin','added','first notification delay','',NULL),(2140,'2012-06-03 09:39:08','admin','added','notification interval','',NULL),(2141,'2012-06-03 09:39:08','admin','added','notification options','',NULL),(2142,'2012-06-03 09:39:08','admin','added','active checking','',NULL),(2143,'2012-06-03 09:39:08','admin','added','passive checking','',NULL),(2144,'2012-06-03 09:39:08','admin','added','notification enabled','',NULL),(2145,'2012-06-03 09:39:08','admin','added','check freshness','',NULL),(2146,'2012-06-03 09:39:08','admin','added','freshness threshold','',NULL),(2147,'2012-06-03 09:39:08','admin','added','event-handler enabled','0',NULL),(2148,'2012-06-03 09:39:16','admin','created','service','shinken-central: check_linux_disks_2',NULL),(2149,'2012-06-03 09:39:16','admin','added','service name','check_linux_disks_2',NULL),(2150,'2012-06-03 09:39:16','admin','added','service','shinken-central: check_linux_disks_2',NULL),(2151,'2012-06-03 09:39:16','admin','added','params for check command','!',NULL),(2152,'2012-06-03 09:39:16','admin','assigned','check period','24x7',NULL),(2153,'2012-06-03 09:39:17','admin','assigned','notification period','24x7',NULL),(2154,'2012-06-03 09:39:17','admin','assigned','contact groups','admins',NULL),(2155,'2012-06-03 09:39:17','admin','added','notes','',NULL),(2156,'2012-06-03 09:39:17','admin','added','notes URL','',NULL),(2157,'2012-06-03 09:39:17','admin','added','action URL','',NULL),(2158,'2012-06-03 09:39:17','admin','added','service enabled','yes',NULL),(2159,'2012-06-03 09:39:17','admin','added','max check attempts','',NULL),(2160,'2012-06-03 09:39:17','admin','added','check interval','',NULL),(2161,'2012-06-03 09:39:17','admin','added','retry interval','',NULL),(2162,'2012-06-03 09:39:17','admin','added','first notification delay','',NULL),(2163,'2012-06-03 09:39:17','admin','added','notification interval','',NULL),(2164,'2012-06-03 09:39:17','admin','added','notification options','',NULL),(2165,'2012-06-03 09:39:18','admin','added','active checking','',NULL),(2166,'2012-06-03 09:39:18','admin','added','passive checking','',NULL),(2167,'2012-06-03 09:39:18','admin','added','notification enabled','',NULL),(2168,'2012-06-03 09:39:18','admin','added','check freshness','',NULL),(2169,'2012-06-03 09:39:18','admin','added','freshness threshold','',NULL),(2170,'2012-06-03 09:39:18','admin','added','event-handler enabled','0',NULL),(2171,'2012-06-03 09:39:18','admin','created','service','shinken-central: check_linux_network_usage_2',NULL),(2172,'2012-06-03 09:39:18','admin','added','service name','check_linux_network_usage_2',NULL),(2173,'2012-06-03 09:39:18','admin','added','service','shinken-central: check_linux_network_usage_2',NULL),(2174,'2012-06-03 09:39:18','admin','added','params for check command','!',NULL),(2175,'2012-06-03 09:39:18','admin','assigned','check period','24x7',NULL),(2176,'2012-06-03 09:39:18','admin','assigned','notification period','24x7',NULL),(2177,'2012-06-03 09:39:18','admin','assigned','contact groups','admins',NULL),(2178,'2012-06-03 09:39:18','admin','added','notes','',NULL),(2179,'2012-06-03 09:39:18','admin','added','notes URL','',NULL),(2180,'2012-06-03 09:39:19','admin','added','action URL','',NULL),(2181,'2012-06-03 09:39:19','admin','added','service enabled','yes',NULL),(2182,'2012-06-03 09:39:19','admin','added','max check attempts','',NULL),(2183,'2012-06-03 09:39:19','admin','added','check interval','',NULL),(2184,'2012-06-03 09:39:19','admin','added','retry interval','',NULL),(2185,'2012-06-03 09:39:19','admin','added','first notification delay','',NULL),(2186,'2012-06-03 09:39:19','admin','added','notification interval','',NULL),(2187,'2012-06-03 09:39:19','admin','added','notification options','',NULL),(2188,'2012-06-03 09:39:19','admin','added','active checking','',NULL),(2189,'2012-06-03 09:39:19','admin','added','passive checking','',NULL),(2190,'2012-06-03 09:39:19','admin','added','notification enabled','',NULL),(2191,'2012-06-03 09:39:19','admin','added','check freshness','',NULL),(2192,'2012-06-03 09:39:20','admin','added','freshness threshold','',NULL),(2193,'2012-06-03 09:39:20','admin','added','event-handler enabled','0',NULL),(2194,'2012-06-03 09:39:20','admin','created','service','shinken-central: check_linux_memory_2',NULL),(2195,'2012-06-03 09:39:20','admin','added','service name','check_linux_memory_2',NULL),(2196,'2012-06-03 09:39:20','admin','added','service','shinken-central: check_linux_memory_2',NULL),(2197,'2012-06-03 09:39:20','admin','added','params for check command','!',NULL),(2198,'2012-06-03 09:39:20','admin','assigned','check period','24x7',NULL),(2199,'2012-06-03 09:39:20','admin','assigned','notification period','24x7',NULL),(2200,'2012-06-03 09:39:20','admin','assigned','contact groups','admins',NULL),(2201,'2012-06-03 09:39:20','admin','added','notes','',NULL),(2202,'2012-06-03 09:39:20','admin','added','notes URL','',NULL),(2203,'2012-06-03 09:39:21','admin','added','action URL','',NULL),(2204,'2012-06-03 09:39:21','admin','added','service enabled','yes',NULL),(2205,'2012-06-03 09:39:21','admin','added','max check attempts','',NULL),(2206,'2012-06-03 09:39:21','admin','added','check interval','',NULL),(2207,'2012-06-03 09:39:21','admin','added','retry interval','',NULL),(2208,'2012-06-03 09:39:21','admin','added','first notification delay','',NULL),(2209,'2012-06-03 09:39:21','admin','added','notification interval','',NULL),(2210,'2012-06-03 09:39:21','admin','added','notification options','',NULL),(2211,'2012-06-03 09:39:21','admin','added','active checking','',NULL),(2212,'2012-06-03 09:39:21','admin','added','passive checking','',NULL),(2213,'2012-06-03 09:39:21','admin','added','notification enabled','',NULL),(2214,'2012-06-03 09:39:21','admin','added','check freshness','',NULL),(2215,'2012-06-03 09:39:21','admin','added','freshness threshold','',NULL),(2216,'2012-06-03 09:39:21','admin','added','event-handler enabled','0',NULL),(2217,'2012-06-03 09:39:28','admin','removed','service','shinken-central: check_linux_disks_2',NULL),(2218,'2012-06-03 09:39:34','admin','removed','service','shinken-central: check_linux_memory_2',NULL),(2219,'2012-06-03 09:39:40','admin','removed','service','shinken-central: check_linux_network_usage_2',NULL),(2220,'2012-06-03 09:40:12','admin','general','config','generating...',NULL),(2221,'2012-06-03 09:40:14','admin','general','config','generate failed with syntax errors',NULL),(2222,'2012-06-03 09:42:06','admin','assigned','check period','24x7',5335),(2223,'2012-06-03 09:42:06','admin','assigned','check command','check-host-alive',5335),(2224,'2012-06-03 09:42:06','admin','assigned','contact groups','admins',5335),(2225,'2012-06-03 09:42:06','admin','modified','notes','',5335),(2226,'2012-06-03 09:42:06','admin','modified','notes URL','',5335),(2227,'2012-06-03 09:42:06','admin','modified','action URL','',5335),(2228,'2012-06-03 09:42:07','admin','modified','max check attempts','3',5335),(2229,'2012-06-03 09:42:07','admin','modified','check interval','5',5335),(2230,'2012-06-03 09:42:07','admin','modified','retry interval','2',5335),(2231,'2012-06-03 09:42:07','admin','modified','first notification delay','0',5335),(2232,'2012-06-03 09:42:07','admin','modified','notification interval','30',5335),(2233,'2012-06-03 09:42:07','admin','modified','notification options','d,u,r,f,s',5335),(2234,'2012-06-03 09:42:07','admin','modified','active checking','1',5335),(2235,'2012-06-03 09:42:07','admin','modified','passive checking','0',5335),(2236,'2012-06-03 09:42:07','admin','modified','check freshness','',5335),(2237,'2012-06-03 09:42:07','admin','modified','freshness threshold','',5335),(2238,'2012-06-03 09:42:07','admin','edited','host-template','generic-host',5335),(2239,'2012-06-03 09:42:11','admin','general','config','generating...',NULL),(2240,'2012-06-03 09:42:13','admin','general','config','generate failed with syntax errors',NULL),(2241,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2242,'2012-06-03 09:46:09','admin','edited','checkcommand','check_ad_replications',NULL),(2243,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2244,'2012-06-03 09:46:09','admin','edited','checkcommand','check_aix_cpu',NULL),(2245,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2246,'2012-06-03 09:46:09','admin','edited','checkcommand','check_aix_disks',NULL),(2247,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2248,'2012-06-03 09:46:09','admin','edited','checkcommand','check_aix_memory',NULL),(2249,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2250,'2012-06-03 09:46:09','admin','edited','checkcommand','check_akcp',NULL),(2251,'2012-06-03 09:46:09','admin','assigned','default service template(s)','generic-service',NULL),(2252,'2012-06-03 09:46:10','admin','edited','checkcommand','check_dhcp',NULL),(2253,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2254,'2012-06-03 09:46:10','admin','edited','checkcommand','check_dns',NULL),(2255,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2256,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_cache',NULL),(2257,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2258,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_disks',NULL),(2259,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2260,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_faults',NULL),(2261,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2262,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_ports',NULL),(2263,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2264,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_spa',NULL),(2265,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2266,'2012-06-03 09:46:10','admin','edited','checkcommand','check_emc_spb',NULL),(2267,'2012-06-03 09:46:10','admin','assigned','default service template(s)','generic-service',NULL),(2268,'2012-06-03 09:46:10','admin','edited','checkcommand','check_esx_host',NULL),(2269,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2270,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_host_cpu',NULL),(2271,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2272,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_host_io',NULL),(2273,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2274,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_host_mem',NULL),(2275,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2276,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_host_net',NULL),(2277,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2278,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_vm',NULL),(2279,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2280,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_vm_cpu',NULL),(2281,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2282,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_vm_io',NULL),(2283,'2012-06-03 09:46:11','admin','assigned','default service template(s)','generic-service',NULL),(2284,'2012-06-03 09:46:11','admin','edited','checkcommand','check_esx_vm_mem',NULL),(2285,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2286,'2012-06-03 09:46:12','admin','edited','checkcommand','check_esx_vm_net',NULL),(2287,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2288,'2012-06-03 09:46:12','admin','edited','checkcommand','check_exchange_db_activity',NULL),(2289,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2290,'2012-06-03 09:46:12','admin','edited','checkcommand','check_exchange_hub_transport_activity',NULL),(2291,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2292,'2012-06-03 09:46:12','admin','edited','checkcommand','check_exchange_hub_transport_queues',NULL),(2293,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2294,'2012-06-03 09:46:12','admin','edited','checkcommand','check_exchange_smtp_receive',NULL),(2295,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2296,'2012-06-03 09:46:12','admin','edited','checkcommand','check_exchange_smtp_send',NULL),(2297,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2298,'2012-06-03 09:46:12','admin','edited','checkcommand','check_ftp',NULL),(2299,'2012-06-03 09:46:12','admin','assigned','default service template(s)','generic-service',NULL),(2300,'2012-06-03 09:46:12','admin','edited','checkcommand','check_hpjd',NULL),(2301,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2302,'2012-06-03 09:46:13','admin','edited','checkcommand','check_hp_asm',NULL),(2303,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2304,'2012-06-03 09:46:13','admin','edited','checkcommand','check_hp_bladechassis',NULL),(2305,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2306,'2012-06-03 09:46:13','admin','edited','checkcommand','check_http',NULL),(2307,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2308,'2012-06-03 09:46:13','admin','edited','checkcommand','check_https',NULL),(2309,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2310,'2012-06-03 09:46:13','admin','edited','checkcommand','check_https_certificate',NULL),(2311,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2312,'2012-06-03 09:46:13','admin','edited','checkcommand','check_iis_connections',NULL),(2313,'2012-06-03 09:46:13','admin','assigned','default service template(s)','generic-service',NULL),(2314,'2012-06-03 09:46:13','admin','edited','checkcommand','check_iis_errors',NULL),(2315,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2316,'2012-06-03 09:46:14','admin','edited','checkcommand','check_iis_requests_activity',NULL),(2317,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2318,'2012-06-03 09:46:14','admin','edited','checkcommand','check_iis_transferts_activity',NULL),(2319,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2320,'2012-06-03 09:46:14','admin','edited','checkcommand','check_iis_users',NULL),(2321,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2322,'2012-06-03 09:46:14','admin','edited','checkcommand','check_imap',NULL),(2323,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2324,'2012-06-03 09:46:14','admin','edited','checkcommand','check_imaps',NULL),(2325,'2012-06-03 09:46:14','admin','assigned','default service template(s)','generic-service',NULL),(2326,'2012-06-03 09:46:14','admin','edited','checkcommand','check_imaps_certificate',NULL),(2327,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2328,'2012-06-03 09:46:15','admin','edited','checkcommand','check_ldap',NULL),(2329,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2330,'2012-06-03 09:46:15','admin','edited','checkcommand','check_ldap3',NULL),(2331,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2332,'2012-06-03 09:46:15','admin','edited','checkcommand','check_ldaps',NULL),(2333,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2334,'2012-06-03 09:46:15','admin','edited','checkcommand','check_ldaps_certificate',NULL),(2335,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2336,'2012-06-03 09:46:15','admin','edited','checkcommand','check_linux_cpu',NULL),(2337,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2338,'2012-06-03 09:46:15','admin','edited','checkcommand','check_linux_disks',NULL),(2339,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2340,'2012-06-03 09:46:15','admin','edited','checkcommand','check_linux_memory',NULL),(2341,'2012-06-03 09:46:15','admin','assigned','default service template(s)','generic-service',NULL),(2342,'2012-06-03 09:46:15','admin','edited','checkcommand','check_linux_network_usage',NULL),(2343,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2344,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_connection',NULL),(2345,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2346,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_flush_time',NULL),(2347,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2348,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_index_miss_ratio',NULL),(2349,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2350,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_last_flush',NULL),(2351,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2352,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_lock_time',NULL),(2353,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2354,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_open_connections',NULL),(2355,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2356,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_replicaset',NULL),(2357,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2358,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mongodb_replication_lag',NULL),(2359,'2012-06-03 09:46:16','admin','assigned','default service template(s)','generic-service',NULL),(2360,'2012-06-03 09:46:16','admin','edited','checkcommand','check_mssql_batch_requests',NULL),(2361,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2362,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_checkpoint_pages',NULL),(2363,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2364,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_connected_users',NULL),(2365,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2366,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_connection',NULL),(2367,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2368,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_cpu_busy',NULL),(2369,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2370,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_database_backup_age',NULL),(2371,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2372,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_database_free',NULL),(2373,'2012-06-03 09:46:17','admin','assigned','default service template(s)','generic-service',NULL),(2374,'2012-06-03 09:46:17','admin','edited','checkcommand','check_mssql_free_list_stalls',NULL),(2375,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2376,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_full_scans',NULL),(2377,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2378,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_io_busy',NULL),(2379,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2380,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_latches_waits',NULL),(2381,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2382,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_latches_wait_time',NULL),(2383,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2384,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_lazy_writes',NULL),(2385,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2386,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_locks_deadlocks',NULL),(2387,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2388,'2012-06-03 09:46:18','admin','edited','checkcommand','check_mssql_locks_timeouts',NULL),(2389,'2012-06-03 09:46:18','admin','assigned','default service template(s)','generic-service',NULL),(2390,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_locks_waits',NULL),(2391,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2392,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(2393,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2394,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_page_life_expectancy',NULL),(2395,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2396,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_sql_initcompilations',NULL),(2397,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2398,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_sql_recompilations',NULL),(2399,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2400,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_total_server_memory',NULL),(2401,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2402,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mssql_transactions',NULL),(2403,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2404,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mysql_bufferpool_hitrate',NULL),(2405,'2012-06-03 09:46:19','admin','assigned','default service template(s)','generic-service',NULL),(2406,'2012-06-03 09:46:19','admin','edited','checkcommand','check_mysql_bufferpool_wait_free',NULL),(2407,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2408,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_cluster_ndb_running',NULL),(2409,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2410,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_connection',NULL),(2411,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2412,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_index_usage',NULL),(2413,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2414,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_keycache_hitrate',NULL),(2415,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2416,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_log_waits',NULL),(2417,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2418,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_long_running_procs',NULL),(2419,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2420,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_open_files',NULL),(2421,'2012-06-03 09:46:20','admin','assigned','default service template(s)','generic-service',NULL),(2422,'2012-06-03 09:46:20','admin','edited','checkcommand','check_mysql_qcache_hitrate',NULL),(2423,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2424,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_qcache_lowmem_prunes',NULL),(2425,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2426,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_querycache_hitrate',NULL),(2427,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2428,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_slave_io_running',NULL),(2429,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2430,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_slave_lag',NULL),(2431,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2432,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_slave_sql_running',NULL),(2433,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2434,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_slow_queries',NULL),(2435,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2436,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_tablecache_hitrate',NULL),(2437,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2438,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_table_lock_contention',NULL),(2439,'2012-06-03 09:46:21','admin','assigned','default service template(s)','generic-service',NULL),(2440,'2012-06-03 09:46:21','admin','edited','checkcommand','check_mysql_threadcache_hitrate',NULL),(2441,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2442,'2012-06-03 09:46:22','admin','edited','checkcommand','check_mysql_threads_connected',NULL),(2443,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2444,'2012-06-03 09:46:22','admin','edited','checkcommand','check_mysql_tmp_disk_tables',NULL),(2445,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2446,'2012-06-03 09:46:22','admin','edited','checkcommand','check_mysql_uptime',NULL),(2447,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2448,'2012-06-03 09:46:22','admin','edited','checkcommand','check_netapp_cpu',NULL),(2449,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2450,'2012-06-03 09:46:22','admin','edited','checkcommand','check_netapp_disks',NULL),(2451,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2452,'2012-06-03 09:46:22','admin','edited','checkcommand','check_netapp_faileddisk',NULL),(2453,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2454,'2012-06-03 09:46:22','admin','edited','checkcommand','check_netapp_fan',NULL),(2455,'2012-06-03 09:46:22','admin','assigned','default service template(s)','generic-service',NULL),(2456,'2012-06-03 09:46:22','admin','edited','checkcommand','check_netapp_nvram',NULL),(2457,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2458,'2012-06-03 09:46:23','admin','edited','checkcommand','check_netapp_power_supply',NULL),(2459,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2460,'2012-06-03 09:46:23','admin','edited','checkcommand','check_netapp_snapshots',NULL),(2461,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2462,'2012-06-03 09:46:23','admin','edited','checkcommand','check_netapp_temperature',NULL),(2463,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2464,'2012-06-03 09:46:23','admin','edited','checkcommand','check_netapp_uptime',NULL),(2465,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2466,'2012-06-03 09:46:23','admin','edited','checkcommand','check_oracle_connected_users',NULL),(2467,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2468,'2012-06-03 09:46:23','admin','edited','checkcommand','check_oracle_connection_time',NULL),(2469,'2012-06-03 09:46:23','admin','assigned','default service template(s)','generic-service',NULL),(2470,'2012-06-03 09:46:23','admin','edited','checkcommand','check_oracle_datafiles_existing',NULL),(2471,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2472,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_datafile_io_traffic',NULL),(2473,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2474,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_enqueue_contention',NULL),(2475,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2476,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_enqueue_waiting',NULL),(2477,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2478,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_event_waiting',NULL),(2479,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2480,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_event_waits',NULL),(2481,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2482,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_flash_recovery_area_free',NULL),(2483,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2484,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_flash_recovery_area_usage',NULL),(2485,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2486,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_invalid_objects',NULL),(2487,'2012-06-03 09:46:24','admin','assigned','default service template(s)','generic-service',NULL),(2488,'2012-06-03 09:46:24','admin','edited','checkcommand','check_oracle_latch_contention',NULL),(2489,'2012-06-03 09:46:25','admin','assigned','default service template(s)','generic-service',NULL),(2490,'2012-06-03 09:46:25','admin','edited','checkcommand','check_oracle_latch_waiting',NULL),(2491,'2012-06-03 09:46:25','admin','assigned','default service template(s)','generic-service',NULL),(2492,'2012-06-03 09:46:25','admin','edited','checkcommand','check_oracle_pga_in_memory_sort_ratio',NULL),(2493,'2012-06-03 09:46:25','admin','assigned','default service template(s)','generic-service',NULL),(2494,'2012-06-03 09:46:25','admin','edited','checkcommand','check_oracle_process_usage',NULL),(2495,'2012-06-03 09:46:25','admin','assigned','default service template(s)','generic-service',NULL),(2496,'2012-06-03 09:46:25','admin','edited','checkcommand','check_oracle_redo_io_traffic',NULL),(2497,'2012-06-03 09:46:25','admin','assigned','default service template(s)','generic-service',NULL),(2498,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_retry_ratio',NULL),(2499,'2012-06-03 09:46:26','admin','assigned','default service template(s)','generic-service',NULL),(2500,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_rman_backup_problems',NULL),(2501,'2012-06-03 09:46:26','admin','assigned','default service template(s)','generic-service',NULL),(2502,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_roll_block_contention',NULL),(2503,'2012-06-03 09:46:26','admin','assigned','default service template(s)','generic-service',NULL),(2504,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_roll_extends',NULL),(2505,'2012-06-03 09:46:26','admin','assigned','default service template(s)','generic-service',NULL),(2506,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_roll_header_contention',NULL),(2507,'2012-06-03 09:46:26','admin','assigned','default service template(s)','generic-service',NULL),(2508,'2012-06-03 09:46:26','admin','edited','checkcommand','check_oracle_roll_hit_ratio',NULL),(2509,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2510,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_roll_wraps',NULL),(2511,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2512,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_seg_top10_buffer_busy_waits',NULL),(2513,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2514,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_seg_top10_logical_reads',NULL),(2515,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2516,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_seg_top10_physical_reads',NULL),(2517,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2518,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_seg_top10_row_lock_waits',NULL),(2519,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2520,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_session_usage',NULL),(2521,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2522,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_sga_data_buffer_hit_ratio',NULL),(2523,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2524,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(2525,'2012-06-03 09:46:27','admin','assigned','default service template(s)','generic-service',NULL),(2526,'2012-06-03 09:46:27','admin','edited','checkcommand','check_oracle_sga_latches_hit_ratio',NULL),(2527,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2528,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_sga_library_cache_gethit_ratio',NULL),(2529,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2530,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_sga_library_cache_pinhit_ratio',NULL),(2531,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2532,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_sga_library_cache_reloads',NULL),(2533,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2534,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_sga_shared_pool_free',NULL),(2535,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2536,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_sga_shared_pool_reloads',NULL),(2537,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2538,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_soft_parse_ratio',NULL),(2539,'2012-06-03 09:46:28','admin','assigned','default service template(s)','generic-service',NULL),(2540,'2012-06-03 09:46:28','admin','edited','checkcommand','check_oracle_stale_statistics',NULL),(2541,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2542,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_switch_interval',NULL),(2543,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2544,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_sysstat',NULL),(2545,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2546,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_tablespace_can_allocate_next',NULL),(2547,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2548,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_tablespace_fragmentation',NULL),(2549,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2550,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_tablespace_free',NULL),(2551,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2552,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_tablespace_io_balanc',NULL),(2553,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2554,'2012-06-03 09:46:29','admin','edited','checkcommand','check_oracle_tablespace_remaining_time',NULL),(2555,'2012-06-03 09:46:29','admin','assigned','default service template(s)','generic-service',NULL),(2556,'2012-06-03 09:46:30','admin','edited','checkcommand','check_oracle_tablespace_usage',NULL),(2557,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2558,'2012-06-03 09:46:30','admin','edited','checkcommand','check_oracle_tnsping',NULL),(2559,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2560,'2012-06-03 09:46:30','admin','edited','checkcommand','check_pop3',NULL),(2561,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2562,'2012-06-03 09:46:30','admin','edited','checkcommand','check_pop3s',NULL),(2563,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2564,'2012-06-03 09:46:30','admin','edited','checkcommand','check_pop3s_certificate',NULL),(2565,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2566,'2012-06-03 09:46:30','admin','edited','checkcommand','check_sip',NULL),(2567,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2568,'2012-06-03 09:46:30','admin','edited','checkcommand','check_smtp',NULL),(2569,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2570,'2012-06-03 09:46:30','admin','edited','checkcommand','check_smtps',NULL),(2571,'2012-06-03 09:46:30','admin','assigned','default service template(s)','generic-service',NULL),(2572,'2012-06-03 09:46:30','admin','edited','checkcommand','check_smtps_certificate',NULL),(2573,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2574,'2012-06-03 09:46:31','admin','edited','checkcommand','check_ssh',NULL),(2575,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2576,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_cpu',NULL),(2577,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2578,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_hardware_health',NULL),(2579,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2580,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_interface_errors',NULL),(2581,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2582,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_interface_status',NULL),(2583,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2584,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_interface_usage',NULL),(2585,'2012-06-03 09:46:31','admin','assigned','default service template(s)','generic-service',NULL),(2586,'2012-06-03 09:46:31','admin','edited','checkcommand','check_switch_memory',NULL),(2587,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2588,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_auto_services',NULL),(2589,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2590,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_big_process',NULL),(2591,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2592,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_big_processes',NULL),(2593,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2594,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_disks',NULL),(2595,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2596,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_disks_io',NULL),(2597,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2598,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_each_cpu',NULL),(2599,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2600,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_eventlogs',NULL),(2601,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2602,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_inactive_ts_sessions',NULL),(2603,'2012-06-03 09:46:32','admin','assigned','default service template(s)','generic-service',NULL),(2604,'2012-06-03 09:46:32','admin','edited','checkcommand','check_windows_loadaverage',NULL),(2605,'2012-06-03 09:46:33','admin','assigned','default service template(s)','generic-service',NULL),(2606,'2012-06-03 09:46:33','admin','edited','checkcommand','check_windows_overall_cpu',NULL),(2607,'2012-06-03 09:46:33','admin','assigned','default service template(s)','generic-service',NULL),(2608,'2012-06-03 09:46:33','admin','edited','checkcommand','check_windows_physical_memory',NULL),(2609,'2012-06-03 09:46:33','admin','assigned','default service template(s)','generic-service',NULL),(2610,'2012-06-03 09:46:33','admin','edited','checkcommand','check_windows_reboot',NULL),(2611,'2012-06-03 09:46:33','admin','assigned','default service template(s)','generic-service',NULL),(2612,'2012-06-03 09:46:33','admin','edited','checkcommand','check_windows_share',NULL),(2613,'2012-06-03 09:46:33','admin','assigned','default service template(s)','generic-service',NULL),(2614,'2012-06-03 09:46:33','admin','edited','checkcommand','check_windows_swap',NULL),(2615,'2012-06-03 09:46:42','admin','general','config','generating...',NULL),(2616,'2012-06-03 09:46:43','admin','general','config','generated successfully',NULL),(2617,'2012-06-03 09:46:49','admin','module','deploy local','extract config (OK)',NULL),(2618,'2012-06-03 09:46:49','admin','module','deploy local','copy global config (OK)',NULL),(2619,'2012-06-03 09:46:50','admin','module','deploy local','copy host and service config (OK)',NULL),(2620,'2012-06-03 09:48:05','admin','created','Attribute','password',NULL),(2621,'2012-06-03 09:48:14','admin','modified','shinken password','admin',5333),(2622,'2012-06-03 09:48:14','admin','edited','contact','admin',5333),(2623,'2012-06-03 09:48:18','admin','general','config','generating...',NULL),(2624,'2012-06-03 09:48:19','admin','general','config','generated successfully',NULL),(2625,'2012-06-03 09:48:21','admin','module','deploy local','extract config (OK)',NULL),(2626,'2012-06-03 09:48:21','admin','module','deploy local','copy global config (OK)',NULL),(2627,'2012-06-03 09:48:22','admin','module','deploy local','copy host and service config (OK)',NULL),(2628,'2012-06-03 10:41:03','admin','removed','service','shinken-central: check_linux_disks',NULL),(2629,'2012-06-03 10:41:03','admin','removed','service','shinken-central: check_linux_memory',NULL),(2630,'2012-06-03 10:41:04','admin','removed','service','shinken-central: check_linux_network_usage',NULL),(2631,'2012-06-03 10:41:04','admin','removed','host','shinken-central',NULL),(2632,'2012-06-03 10:41:25','admin','removed','checkcommand','check_ad_replications',NULL),(2633,'2012-06-03 10:41:25','admin','removed','checkcommand','check_aix_cpu',NULL),(2634,'2012-06-03 10:41:25','admin','removed','checkcommand','check_aix_disks',NULL),(2635,'2012-06-03 10:41:25','admin','removed','checkcommand','check_aix_memory',NULL),(2636,'2012-06-03 10:41:25','admin','removed','checkcommand','check_akcp',NULL),(2637,'2012-06-03 10:41:25','admin','removed','checkcommand','check_dhcp',NULL),(2638,'2012-06-03 10:41:25','admin','removed','checkcommand','check_dns',NULL),(2639,'2012-06-03 10:41:25','admin','removed','checkcommand','check_emc_cache',NULL),(2640,'2012-06-03 10:41:25','admin','removed','checkcommand','check_emc_disks',NULL),(2641,'2012-06-03 10:41:25','admin','removed','checkcommand','check_emc_faults',NULL),(2642,'2012-06-03 10:41:25','admin','removed','checkcommand','check_emc_ports',NULL),(2643,'2012-06-03 10:41:25','admin','removed','checkcommand','check_emc_spa',NULL),(2644,'2012-06-03 10:41:26','admin','removed','checkcommand','check_emc_spb',NULL),(2645,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_host',NULL),(2646,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_host_cpu',NULL),(2647,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_host_io',NULL),(2648,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_host_mem',NULL),(2649,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_host_net',NULL),(2650,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_vm',NULL),(2651,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_vm_cpu',NULL),(2652,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_vm_io',NULL),(2653,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_vm_mem',NULL),(2654,'2012-06-03 10:41:26','admin','removed','checkcommand','check_esx_vm_net',NULL),(2655,'2012-06-03 10:41:26','admin','removed','checkcommand','check_exchange_db_activity',NULL),(2656,'2012-06-03 10:41:26','admin','removed','checkcommand','check_exchange_hub_transport_activity',NULL),(2657,'2012-06-03 10:41:26','admin','removed','checkcommand','check_exchange_hub_transport_queues',NULL),(2658,'2012-06-03 10:41:27','admin','removed','checkcommand','check_exchange_smtp_receive',NULL),(2659,'2012-06-03 10:41:27','admin','removed','checkcommand','check_exchange_smtp_send',NULL),(2660,'2012-06-03 10:41:27','admin','removed','checkcommand','check_ftp',NULL),(2661,'2012-06-03 10:41:27','admin','removed','checkcommand','check_hpjd',NULL),(2662,'2012-06-03 10:41:27','admin','removed','checkcommand','check_hp_asm',NULL),(2663,'2012-06-03 10:41:27','admin','removed','checkcommand','check_hp_bladechassis',NULL),(2664,'2012-06-03 10:41:27','admin','removed','checkcommand','check_http',NULL),(2665,'2012-06-03 10:41:27','admin','removed','checkcommand','check_https',NULL),(2666,'2012-06-03 10:41:27','admin','removed','checkcommand','check_https_certificate',NULL),(2667,'2012-06-03 10:41:27','admin','removed','checkcommand','check_iis_connections',NULL),(2668,'2012-06-03 10:41:27','admin','removed','checkcommand','check_iis_errors',NULL),(2669,'2012-06-03 10:41:27','admin','removed','checkcommand','check_iis_requests_activity',NULL),(2670,'2012-06-03 10:41:27','admin','removed','checkcommand','check_iis_transferts_activity',NULL),(2671,'2012-06-03 10:41:28','admin','removed','checkcommand','check_iis_users',NULL),(2672,'2012-06-03 10:41:28','admin','removed','checkcommand','check_imap',NULL),(2673,'2012-06-03 10:41:28','admin','removed','checkcommand','check_imaps',NULL),(2674,'2012-06-03 10:41:28','admin','removed','checkcommand','check_imaps_certificate',NULL),(2675,'2012-06-03 10:41:28','admin','removed','checkcommand','check_ldap',NULL),(2676,'2012-06-03 10:41:28','admin','removed','checkcommand','check_ldap3',NULL),(2677,'2012-06-03 10:41:28','admin','removed','checkcommand','check_ldaps',NULL),(2678,'2012-06-03 10:41:28','admin','removed','checkcommand','check_ldaps_certificate',NULL),(2679,'2012-06-03 10:41:28','admin','removed','checkcommand','check_linux_cpu',NULL),(2680,'2012-06-03 10:41:28','admin','removed','checkcommand','check_linux_disks',NULL),(2681,'2012-06-03 10:41:28','admin','removed','checkcommand','check_linux_memory',NULL),(2682,'2012-06-03 10:41:28','admin','removed','checkcommand','check_linux_network_usage',NULL),(2683,'2012-06-03 10:41:28','admin','removed','checkcommand','check_mongodb_connection',NULL),(2684,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_flush_time',NULL),(2685,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_index_miss_ratio',NULL),(2686,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_last_flush',NULL),(2687,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_lock_time',NULL),(2688,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_open_connections',NULL),(2689,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_replicaset',NULL),(2690,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mongodb_replication_lag',NULL),(2691,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mssql_batch_requests',NULL),(2692,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mssql_checkpoint_pages',NULL),(2693,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mssql_connected_users',NULL),(2694,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mssql_connection',NULL),(2695,'2012-06-03 10:41:29','admin','removed','checkcommand','check_mssql_cpu_busy',NULL),(2696,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_database_backup_age',NULL),(2697,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_database_free',NULL),(2698,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_free_list_stalls',NULL),(2699,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_full_scans',NULL),(2700,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_io_busy',NULL),(2701,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_latches_waits',NULL),(2702,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_latches_wait_time',NULL),(2703,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_lazy_writes',NULL),(2704,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_locks_deadlocks',NULL),(2705,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_locks_timeouts',NULL),(2706,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_locks_waits',NULL),(2707,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_mem_pool_data_buffer_hit_ratio',NULL),(2708,'2012-06-03 10:41:30','admin','removed','checkcommand','check_mssql_page_life_expectancy',NULL),(2709,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mssql_sql_initcompilations',NULL),(2710,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mssql_sql_recompilations',NULL),(2711,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mssql_total_server_memory',NULL),(2712,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mssql_transactions',NULL),(2713,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_bufferpool_hitrate',NULL),(2714,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_bufferpool_wait_free',NULL),(2715,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_cluster_ndb_running',NULL),(2716,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_connection',NULL),(2717,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_index_usage',NULL),(2718,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_keycache_hitrate',NULL),(2719,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_log_waits',NULL),(2720,'2012-06-03 10:41:31','admin','removed','checkcommand','check_mysql_long_running_procs',NULL),(2721,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_open_files',NULL),(2722,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_qcache_hitrate',NULL),(2723,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_qcache_lowmem_prunes',NULL),(2724,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_querycache_hitrate',NULL),(2725,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_slave_io_running',NULL),(2726,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_slave_lag',NULL),(2727,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_slave_sql_running',NULL),(2728,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_slow_queries',NULL),(2729,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_tablecache_hitrate',NULL),(2730,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_table_lock_contention',NULL),(2731,'2012-06-03 10:41:32','admin','removed','checkcommand','check_mysql_threadcache_hitrate',NULL),(2732,'2012-06-03 10:41:33','admin','removed','checkcommand','check_mysql_threads_connected',NULL),(2733,'2012-06-03 10:41:33','admin','removed','checkcommand','check_mysql_tmp_disk_tables',NULL),(2734,'2012-06-03 10:41:33','admin','removed','checkcommand','check_mysql_uptime',NULL),(2735,'2012-06-03 10:41:33','admin','removed','checkcommand','check_netapp_cpu',NULL),(2736,'2012-06-03 10:41:33','admin','removed','checkcommand','check_netapp_disks',NULL),(2737,'2012-06-03 10:41:33','admin','removed','checkcommand','check_netapp_faileddisk',NULL),(2738,'2012-06-03 10:41:33','admin','removed','checkcommand','check_netapp_fan',NULL),(2739,'2012-06-03 10:41:34','admin','removed','checkcommand','check_netapp_nvram',NULL),(2740,'2012-06-03 10:41:34','admin','removed','checkcommand','check_netapp_power_supply',NULL),(2741,'2012-06-03 10:41:34','admin','removed','checkcommand','check_netapp_snapshots',NULL),(2742,'2012-06-03 10:41:34','admin','removed','checkcommand','check_netapp_temperature',NULL),(2743,'2012-06-03 10:41:34','admin','removed','checkcommand','check_netapp_uptime',NULL),(2744,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_connected_users',NULL),(2745,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_connection_time',NULL),(2746,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_datafiles_existing',NULL),(2747,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_datafile_io_traffic',NULL),(2748,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_enqueue_contention',NULL),(2749,'2012-06-03 10:41:34','admin','removed','checkcommand','check_oracle_enqueue_waiting',NULL),(2750,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_event_waiting',NULL),(2751,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_event_waits',NULL),(2752,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_flash_recovery_area_free',NULL),(2753,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_flash_recovery_area_usage',NULL),(2754,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_invalid_objects',NULL),(2755,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_latch_contention',NULL),(2756,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_latch_waiting',NULL),(2757,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_pga_in_memory_sort_ratio',NULL),(2758,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_process_usage',NULL),(2759,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_redo_io_traffic',NULL),(2760,'2012-06-03 10:41:35','admin','removed','checkcommand','check_oracle_retry_ratio',NULL),(2761,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_rman_backup_problems',NULL),(2762,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_roll_block_contention',NULL),(2763,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_roll_extends',NULL),(2764,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_roll_header_contention',NULL),(2765,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_roll_hit_ratio',NULL),(2766,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_roll_wraps',NULL),(2767,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_seg_top10_buffer_busy_waits',NULL),(2768,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_seg_top10_logical_reads',NULL),(2769,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_seg_top10_physical_reads',NULL),(2770,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_seg_top10_row_lock_waits',NULL),(2771,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_session_usage',NULL),(2772,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_sga_data_buffer_hit_ratio',NULL),(2773,'2012-06-03 10:41:36','admin','removed','checkcommand','check_oracle_sga_dictionary_cache_hit_ratio',NULL),(2774,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_latches_hit_ratio',NULL),(2775,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_library_cache_gethit_ratio',NULL),(2776,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_library_cache_pinhit_ratio',NULL),(2777,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_library_cache_reloads',NULL),(2778,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_shared_pool_free',NULL),(2779,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_sga_shared_pool_reloads',NULL),(2780,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_soft_parse_ratio',NULL),(2781,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_stale_statistics',NULL),(2782,'2012-06-03 10:41:37','admin','removed','checkcommand','check_oracle_switch_interval',NULL),(2783,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_sysstat',NULL),(2784,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_can_allocate_next',NULL),(2785,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_fragmentation',NULL),(2786,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_free',NULL),(2787,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_io_balanc',NULL),(2788,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_remaining_time',NULL),(2789,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tablespace_usage',NULL),(2790,'2012-06-03 10:41:38','admin','removed','checkcommand','check_oracle_tnsping',NULL),(2791,'2012-06-03 10:41:39','admin','removed','checkcommand','check_pop3',NULL),(2792,'2012-06-03 10:41:39','admin','removed','checkcommand','check_pop3s',NULL),(2793,'2012-06-03 10:41:39','admin','removed','checkcommand','check_pop3s_certificate',NULL),(2794,'2012-06-03 10:41:39','admin','removed','checkcommand','check_sip',NULL),(2795,'2012-06-03 10:41:39','admin','removed','checkcommand','check_smtp',NULL),(2796,'2012-06-03 10:41:39','admin','removed','checkcommand','check_smtps',NULL),(2797,'2012-06-03 10:41:39','admin','removed','checkcommand','check_smtps_certificate',NULL),(2798,'2012-06-03 10:41:39','admin','removed','checkcommand','check_ssh',NULL),(2799,'2012-06-03 10:41:39','admin','removed','checkcommand','check_switch_cpu',NULL),(2800,'2012-06-03 10:41:39','admin','removed','checkcommand','check_switch_hardware_health',NULL),(2801,'2012-06-03 10:41:39','admin','removed','checkcommand','check_switch_interface_errors',NULL),(2802,'2012-06-03 10:41:39','admin','removed','checkcommand','check_switch_interface_status',NULL),(2803,'2012-06-03 10:41:40','admin','removed','checkcommand','check_switch_interface_usage',NULL),(2804,'2012-06-03 10:41:40','admin','removed','checkcommand','check_switch_memory',NULL),(2805,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_auto_services',NULL),(2806,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_big_process',NULL),(2807,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_big_processes',NULL),(2808,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_disks',NULL),(2809,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_disks_io',NULL),(2810,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_each_cpu',NULL),(2811,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_eventlogs',NULL),(2812,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_inactive_ts_sessions',NULL),(2813,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_loadaverage',NULL),(2814,'2012-06-03 10:41:40','admin','removed','checkcommand','check_windows_overall_cpu',NULL),(2815,'2012-06-03 10:41:41','admin','removed','checkcommand','check_windows_physical_memory',NULL),(2816,'2012-06-03 10:41:41','admin','removed','checkcommand','check_windows_reboot',NULL),(2817,'2012-06-03 10:41:41','admin','removed','checkcommand','check_windows_share',NULL),(2818,'2012-06-03 10:41:41','admin','removed','checkcommand','check_windows_swap',NULL),(2819,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2820,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2821,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2822,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2823,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2824,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2825,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2826,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2827,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2828,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2829,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2830,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2831,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2832,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2833,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2834,'2012-06-03 10:41:41','admin','removed','checkcommand','',NULL),(2835,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2836,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2837,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2838,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2839,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2840,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2841,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2842,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2843,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2844,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2845,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2846,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2847,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2848,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2849,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2850,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2851,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2852,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2853,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2854,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2855,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2856,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2857,'2012-06-03 10:41:42','admin','removed','checkcommand','',NULL),(2858,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2859,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2860,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2861,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2862,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2863,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2864,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2865,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2866,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2867,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2868,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2869,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2870,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2871,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2872,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2873,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2874,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2875,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2876,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2877,'2012-06-03 10:41:43','admin','removed','checkcommand','',NULL),(2878,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2879,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2880,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2881,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2882,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2883,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2884,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2885,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2886,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2887,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2888,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2889,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2890,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2891,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2892,'2012-06-03 10:41:44','admin','removed','checkcommand','',NULL),(2893,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2894,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2895,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2896,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2897,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2898,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2899,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2900,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2901,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2902,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2903,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2904,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2905,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2906,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2907,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2908,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2909,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2910,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2911,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2912,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2913,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2914,'2012-06-03 10:41:45','admin','removed','checkcommand','',NULL),(2915,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2916,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2917,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2918,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2919,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2920,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2921,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2922,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2923,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2924,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2925,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2926,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2927,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2928,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2929,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2930,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2931,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2932,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2933,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2934,'2012-06-03 10:41:46','admin','removed','checkcommand','',NULL),(2935,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2936,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2937,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2938,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2939,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2940,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2941,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2942,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2943,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2944,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2945,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2946,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2947,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2948,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2949,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2950,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2951,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2952,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2953,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2954,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2955,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2956,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2957,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2958,'2012-06-03 10:41:47','admin','removed','checkcommand','',NULL),(2959,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2960,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2961,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2962,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2963,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2964,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2965,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2966,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2967,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2968,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2969,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2970,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2971,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2972,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2973,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2974,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2975,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2976,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2977,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2978,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2979,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2980,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2981,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2982,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2983,'2012-06-03 10:41:48','admin','removed','checkcommand','',NULL),(2984,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2985,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2986,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2987,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2988,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2989,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2990,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2991,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2992,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2993,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2994,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2995,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2996,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2997,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2998,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(2999,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3000,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3001,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3002,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3003,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3004,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3005,'2012-06-03 10:41:49','admin','removed','checkcommand','',NULL),(3006,'2012-06-03 10:58:09','admin','modified','host preset name','generic-host',5732),(3007,'2012-06-03 10:58:09','admin','edited','host-preset','generic-host',5732);
/*!40000 ALTER TABLE `History` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ItemLinks`
--

DROP TABLE IF EXISTS `ItemLinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ItemLinks` (
  `fk_id_item` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_item_linked2` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_id_attr` int(10) unsigned NOT NULL DEFAULT '0',
  `cust_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_id_item`,`fk_item_linked2`,`fk_id_attr`),
  KEY `fk_item_linked2` (`fk_item_linked2`),
  KEY `fk_id_attr` (`fk_id_attr`),
  CONSTRAINT `ItemLinks_ibfk_1` FOREIGN KEY (`fk_id_item`) REFERENCES `ConfigItems` (`id_item`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ItemLinks_ibfk_2` FOREIGN KEY (`fk_item_linked2`) REFERENCES `ConfigItems` (`id_item`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ItemLinks_ibfk_3` FOREIGN KEY (`fk_id_attr`) REFERENCES `ConfigAttrs` (`id_attr`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ItemLinks`
--

LOCK TABLES `ItemLinks` WRITE;
/*!40000 ALTER TABLE `ItemLinks` DISABLE KEYS */;
INSERT INTO `ItemLinks` VALUES (5333,5305,49,0),(5333,5305,50,0),(5333,5327,53,0),(5333,5328,54,0),(5333,5334,59,0),(5335,5305,111,0),(5335,5305,112,0),(5335,5331,113,0),(5335,5334,115,0),(5348,5305,132,0),(5348,5305,133,0),(5348,5334,135,0),(5732,5331,81,0);
/*!40000 ALTER TABLE `ItemLinks` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2012-06-03 12:59:22
