/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli --scli-set Printer-MIB
 *
 * Derived from Printer-MIB:
 *   The MIB module for management of printers.
 *   Copyright (C) The Internet Society (2004). This
 *   version of this MIB module was published
 *   in RFC 3805. For full legal notices see the RFC itself.
 *
 * Revision 2004-06-02 00:00:
 *   Printer MIB v2.
 *   Moved all enum groups to be maintained by IANA into new TCs
 *      within the ianaPrinterMIB, which is contained in this
 *      document.
 *   New TCs created from enums defined within RFC 1759 Objects:
 *      PrtPrintOrientationTC, PrtLocalizedDescriptionStringTC,
 *      PrtConsoleDescriptionStringTC, PrtChannelStateTC,
 *      PrtOutputStackingOrderTC, PrtOutputPageDeliveryOrientationTC,
 *      PrtMarkerCounterUnitTC, PrtMarkerSuppliesSupplyUnitTC,
 *      PrtMarkerSuppliesClassTC, PrtMarkerAddressabilityUnitTC,
 *      PrtMarkerColorantRoleTC, PrtMediaPathMaxSpeedPrintUnitTC,
 *      PrtInterpreterTwoWayTC, and PrtAlertSeverityLevelTC.
 *   The following four TCs have been deprecated:
 *      MediaUnit (replaced by PrtMediaUnitTC),
 *      CapacityUnit (replaced by PrtCapacityUnitTC),
 *      SubUnitStatus (replaced by PrtSubUnitStatusTC),
 *      CodedCharSet (replaced by IANACharset in IANA Charset MIB)
 *   Five new OBJECT-GROUPs: prtAuxilliarySheetGroup,
 *      prtInputSwitchingGroup, prtGeneralV2Group,
 *      prtAlertTableV2Group, prtChannelV2Group.
 *   Nine new objects added to those groups:
 *      prtAuxiliarySheetStartupPage, prtAuxiliarySheetBannerPage,
 *      prtGeneralPrinterName, prtGeneralSerialNumber,
 *      prtAlertCriticalEvents, prtAlertAllEvents,
 *   
 *   
 *      prtInputMediaLoadTimeout, prtInputNextIndex,
 *      prtChannelInformation.
 *   SYNTAX range changed from (0..65535) to (1..65535) for the
 *      index objects prtStorageRefSeqNumber, prtDeviceRefSeqNumber,
 *      and prtConsoleLightIndex.
 *   SYNTAX range changed from (0..65535) to (0..2147483647) for the
 *      objects prtStorageRefIndex and prtDeviceRefIndex to agree
 *      with the Host Resources MIB.
 *   Defined a range for the objects with a SYNTAX of Integer32:
 *      prtOutputDefaultIndex, prtInputMediaDimFeedDirDeclared,
 *      prtInputMediaDimXFeedDirDeclared, prtInputMaxCapacity,
 *      prtInputCurrentLevel, prtInputMediaDimFeedDirChosen,
 *      prtInputMediaDimXFeedDirChosen, prtInputMediaWeight,
 *      prtInputMediaFormParts, prtOutputIndex,
 *      prtOutputMaxCapacity, prtOutputRemainingCapacity,
 *      prtOutputMaxDimFeedDir, prtOutputMaxDimXFeedDir,
 *      prtOutputMinDimFeedDir, prtOutputMinDimXFeedDir,
 *      prtMarkerAddressibilityFeedDir,
 *      prtMarkerAddressibilityXFeedDir, prtMarkerNorthMargin,
 *      prtMarkerSouthMargin, prtMarkerWestMargin,
 *      prtMarkerEastMargin, prtMarkerSuppliesMaxCapacity,
 *      prtMarkerSuppliesLevel, prtMarkerColorantTonality,
 *      prtMediaPathMaxSpeed, prtMediaPathMaxMediaFeedDir,
 *      prtMediaPathMaxMediaXFeedDir, prtMediaPathMinMediaFeedDir,
 *      prtMediaPathMinMediaXFeedDir, prtChannelIndex,
 *      prtChannelCurrentJobCntlLangIndex, prtInterpreterIndex,
 *      prtChannelDefaultPageDescLangIndex, prtConsoleOnTime,
 *      prtInterpreterFeedAddressibility, prtConsoleOffTime,
 *      prtInterpreterXFeedAddressibility, prtAlertIndex,
 *      prtAlertGroupIndex, prtAlertLocation.
 *   Changed SYNTAX from Integer32 to InterfaceIndexOrZero for
 *      prtChannelIfIndex.
 *   Changed MAX-ACCESS of prtAlertIndex from not-accessible to
 *      Read-only and added a compliance statement to allow a
 *      MIN-ACCESS of accessible-for-notify.
 *   One new NOTIFICATION-GROUP: prtAlertTrapGroup which contains
 *      printerV2Alert.
 *   In MODULE-COMPLIANCE prtMIBCompliance, new OBJECT-GROUPs and
 *      the NOTIFICATION_GROUP, all in GROUP (not MANDATORY-GROUP)
 *      clauses.  The nine new objects are optional, i.e., this
 *      document is backward compatible with RFC 1759.
 *
 * Revision 1994-11-25 00:00:
 *   The original version of this MIB, published as RFC1759.
 *
 * $Id: printer-mib.h 3180 2009-07-29 22:36:13Z schoenw $
 */

#ifndef _PRINTER_MIB_H_
#define _PRINTER_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define PRINTER_MIB_PRTMEDIAUNITTC_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_PRTMEDIAUNITTC_MICROMETERS            4

extern GNetSnmpEnum const printer_mib_enums_PrtMediaUnitTC[];

#define PRINTER_MIB_MEDIAUNIT_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_MEDIAUNIT_MICROMETERS            4

extern GNetSnmpEnum const printer_mib_enums_MediaUnit[];

#define PRINTER_MIB_PRTCAPACITYUNITTC_OTHER                  1
#define PRINTER_MIB_PRTCAPACITYUNITTC_UNKNOWN                2
#define PRINTER_MIB_PRTCAPACITYUNITTC_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_PRTCAPACITYUNITTC_MICROMETERS            4
#define PRINTER_MIB_PRTCAPACITYUNITTC_SHEETS                 8
#define PRINTER_MIB_PRTCAPACITYUNITTC_FEET                   16
#define PRINTER_MIB_PRTCAPACITYUNITTC_METERS                 17
#define PRINTER_MIB_PRTCAPACITYUNITTC_ITEMS                  18
#define PRINTER_MIB_PRTCAPACITYUNITTC_PERCENT                19

extern GNetSnmpEnum const printer_mib_enums_PrtCapacityUnitTC[];

#define PRINTER_MIB_CAPACITYUNIT_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_CAPACITYUNIT_MICROMETERS            4
#define PRINTER_MIB_CAPACITYUNIT_SHEETS                 8
#define PRINTER_MIB_CAPACITYUNIT_FEET                   16
#define PRINTER_MIB_CAPACITYUNIT_METERS                 17

extern GNetSnmpEnum const printer_mib_enums_CapacityUnit[];

#define PRINTER_MIB_PRTPRINTORIENTATIONTC_OTHER     1
#define PRINTER_MIB_PRTPRINTORIENTATIONTC_PORTRAIT  3
#define PRINTER_MIB_PRTPRINTORIENTATIONTC_LANDSCAPE 4

extern GNetSnmpEnum const printer_mib_enums_PrtPrintOrientationTC[];

#define PRINTER_MIB_PRESENTONOFF_OTHER      1
#define PRINTER_MIB_PRESENTONOFF_ON         3
#define PRINTER_MIB_PRESENTONOFF_OFF        4
#define PRINTER_MIB_PRESENTONOFF_NOTPRESENT 5

extern GNetSnmpEnum const printer_mib_enums_PresentOnOff[];

#define PRINTER_MIB_CODEDCHARSET_OTHER 1

extern GNetSnmpEnum const printer_mib_enums_CodedCharSet[];

#define PRINTER_MIB_PRTCHANNELSTATETC_OTHER             1
#define PRINTER_MIB_PRTCHANNELSTATETC_PRINTDATAACCEPTED 3
#define PRINTER_MIB_PRTCHANNELSTATETC_NODATAACCEPTED    4

extern GNetSnmpEnum const printer_mib_enums_PrtChannelStateTC[];

#define PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_UNKNOWN     2
#define PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_FIRSTTOLAST 3
#define PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_LASTTOFIRST 4

extern GNetSnmpEnum const printer_mib_enums_PrtOutputStackingOrderTC[];

#define PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATIONTC_FACEUP   3
#define PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATIONTC_FACEDOWN 4

extern GNetSnmpEnum const printer_mib_enums_PrtOutputPageDeliveryOrientationTC[];

#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_MICROMETERS            4
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_CHARACTERS             5
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_LINES                  6
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_IMPRESSIONS            7
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_SHEETS                 8
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_DOTROW                 9
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_HOURS                  11
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_FEET                   16
#define PRINTER_MIB_PRTMARKERCOUNTERUNITTC_METERS                 17

extern GNetSnmpEnum const printer_mib_enums_PrtMarkerCounterUnitTC[];

#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_OTHER                  1
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_UNKNOWN                2
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_MICROMETERS            4
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_IMPRESSIONS            7
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_SHEETS                 8
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_HOURS                  11
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_THOUSANDTHSOFOUNCES    12
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHSOFGRAMS          13
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_HUNDRETHSOFFLUIDOUNCES 14
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHSOFMILLILITERS    15
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_FEET                   16
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_METERS                 17
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_ITEMS                  18
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_PERCENT                19

extern GNetSnmpEnum const printer_mib_enums_PrtMarkerSuppliesSupplyUnitTC[];

#define PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_OTHER                  1
#define PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_SUPPLYTHATISCONSUMED   3
#define PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_RECEPTACLETHATISFILLED 4

extern GNetSnmpEnum const printer_mib_enums_PrtMarkerSuppliesClassTC[];

#define PRINTER_MIB_PRTMARKERCOLORANTROLETC_OTHER   1
#define PRINTER_MIB_PRTMARKERCOLORANTROLETC_PROCESS 3
#define PRINTER_MIB_PRTMARKERCOLORANTROLETC_SPOT    4

extern GNetSnmpEnum const printer_mib_enums_PrtMarkerColorantRoleTC[];

#define PRINTER_MIB_PRTMARKERADDRESSABILITYUNITTC_TENTHOUSANDTHSOFINCHES 3
#define PRINTER_MIB_PRTMARKERADDRESSABILITYUNITTC_MICROMETERS            4

extern GNetSnmpEnum const printer_mib_enums_PrtMarkerAddressabilityUnitTC[];

#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_TENTHOUSANDTHSOFINCHESPERHOUR 3
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_MICROMETERSPERHOUR            4
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_CHARACTERSPERHOUR             5
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_LINESPERHOUR                  6
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_IMPRESSIONSPERHOUR            7
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_SHEETSPERHOUR                 8
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_DOTROWPERHOUR                 9
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_FEETPERHOUR                   16
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_METERSPERHOUR                 17

extern GNetSnmpEnum const printer_mib_enums_PrtMediaPathMaxSpeedPrintUnitTC[];

#define PRINTER_MIB_PRTINTERPRETERTWOWAYTC_YES 3
#define PRINTER_MIB_PRTINTERPRETERTWOWAYTC_NO  4

extern GNetSnmpEnum const printer_mib_enums_PrtInterpreterTwoWayTC[];

#define PRINTER_MIB_PRTALERTSEVERITYLEVELTC_OTHER                    1
#define PRINTER_MIB_PRTALERTSEVERITYLEVELTC_CRITICAL                 3
#define PRINTER_MIB_PRTALERTSEVERITYLEVELTC_WARNING                  4
#define PRINTER_MIB_PRTALERTSEVERITYLEVELTC_WARNINGBINARYCHANGEEVENT 5

extern GNetSnmpEnum const printer_mib_enums_PrtAlertSeverityLevelTC[];


/*
 * Tables to map identities to strings and vice versa.
 */

#define PRINTER_MIB_PRINTERV1ALERT	1,3,6,1,2,1,43,18,2

extern GNetSnmpIdentity const printer_mib_identities[];

/*
 * Tables to map notifications to strings and vice versa.
 */

#define PRINTER_MIB_PRINTERV2ALERT	1,3,6,1,2,1,43,18,2,0,1

extern GNetSnmpIdentity const printer_mib_notifications[];

/*
 * C type definitions for Printer-MIB::prtGeneralEntry.
 */

#define PRINTER_MIB_PRTGENERALCONFIGCHANGES        (1 << 0) 
#define PRINTER_MIB_PRTGENERALCURRENTLOCALIZATION  (1 << 1) 
#define PRINTER_MIB_PRTGENERALRESET                (1 << 2) 
#define PRINTER_MIB_PRTGENERALCURRENTOPERATOR      (1 << 3) 
#define PRINTER_MIB_PRTGENERALSERVICEPERSON        (1 << 4) 
#define PRINTER_MIB_PRTINPUTDEFAULTINDEX           (1 << 5) 
#define PRINTER_MIB_PRTOUTPUTDEFAULTINDEX          (1 << 6) 
#define PRINTER_MIB_PRTMARKERDEFAULTINDEX          (1 << 7) 
#define PRINTER_MIB_PRTMEDIAPATHDEFAULTINDEX       (1 << 8) 
#define PRINTER_MIB_PRTCONSOLELOCALIZATION         (1 << 9) 
#define PRINTER_MIB_PRTCONSOLENUMBEROFDISPLAYLINES (1 << 10) 
#define PRINTER_MIB_PRTCONSOLENUMBEROFDISPLAYCHARS (1 << 11) 
#define PRINTER_MIB_PRTCONSOLEDISABLE              (1 << 12) 
#define PRINTER_MIB_PRTAUXILIARYSHEETSTARTUPPAGE   (1 << 13) 
#define PRINTER_MIB_PRTAUXILIARYSHEETBANNERPAGE    (1 << 14) 
#define PRINTER_MIB_PRTGENERALPRINTERNAME          (1 << 15) 
#define PRINTER_MIB_PRTGENERALSERIALNUMBER         (1 << 16) 
#define PRINTER_MIB_PRTALERTCRITICALEVENTS         (1 << 17) 
#define PRINTER_MIB_PRTALERTALLEVENTS              (1 << 18) 

typedef struct {
    gint32   hrDeviceIndex;                       /* ro */
    guint32  *prtGeneralConfigChanges;            /* ro SNMPv2-SMI::Counter32 */
    gint32   *prtGeneralCurrentLocalization;      /* rw */
    gint32   *prtGeneralReset;                    /* rw IANA-PRINTER-MIB::PrtGeneralResetTC */
    guchar   *prtGeneralCurrentOperator;          /* rw */
#define PRINTER_MIB_PRTGENERALCURRENTOPERATORMINLENGTH 0
#define PRINTER_MIB_PRTGENERALCURRENTOPERATORMAXLENGTH 127
    guint16  _prtGeneralCurrentOperatorLength;
    guchar   *prtGeneralServicePerson;            /* rw */
#define PRINTER_MIB_PRTGENERALSERVICEPERSONMINLENGTH 0
#define PRINTER_MIB_PRTGENERALSERVICEPERSONMAXLENGTH 127
    guint16  _prtGeneralServicePersonLength;
    gint32   *prtInputDefaultIndex;               /* rw */
    gint32   *prtOutputDefaultIndex;              /* rw */
    gint32   *prtMarkerDefaultIndex;              /* rw */
    gint32   *prtMediaPathDefaultIndex;           /* rw */
    gint32   *prtConsoleLocalization;             /* rw */
    gint32   *prtConsoleNumberOfDisplayLines;     /* ro */
    gint32   *prtConsoleNumberOfDisplayChars;     /* ro */
    gint32   *prtConsoleDisable;                  /* rw IANA-PRINTER-MIB::PrtConsoleDisableTC */
    gint32   *prtAuxiliarySheetStartupPage;       /* rw Printer-MIB::PresentOnOff */
    gint32   *prtAuxiliarySheetBannerPage;        /* rw Printer-MIB::PresentOnOff */
    guchar   *prtGeneralPrinterName;              /* rw */
#define PRINTER_MIB_PRTGENERALPRINTERNAMEMINLENGTH 0
#define PRINTER_MIB_PRTGENERALPRINTERNAMEMAXLENGTH 127
    guint16  _prtGeneralPrinterNameLength;
    guchar   *prtGeneralSerialNumber;             /* rw */
#define PRINTER_MIB_PRTGENERALSERIALNUMBERMINLENGTH 0
#define PRINTER_MIB_PRTGENERALSERIALNUMBERMAXLENGTH 255
    guint16  _prtGeneralSerialNumberLength;
    guint32  *prtAlertCriticalEvents;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *prtAlertAllEvents;                  /* ro SNMPv2-SMI::Counter32 */
} printer_mib_prtGeneralEntry_t;

extern void
printer_mib_get_prtGeneralTable(GNetSnmp *s, printer_mib_prtGeneralEntry_t ***prtGeneralEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtGeneralTable(printer_mib_prtGeneralEntry_t **prtGeneralEntry);

extern printer_mib_prtGeneralEntry_t *
printer_mib_new_prtGeneralEntry(void);

extern void
printer_mib_get_prtGeneralEntry(GNetSnmp *s, printer_mib_prtGeneralEntry_t **prtGeneralEntry, gint32 hrDeviceIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtGeneralEntry(GNetSnmp *s, printer_mib_prtGeneralEntry_t *prtGeneralEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtGeneralEntry(printer_mib_prtGeneralEntry_t *prtGeneralEntry);

extern void
printer_mib_set_prtGeneralCurrentLocalization(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtGeneralCurrentLocalization, GError **error);

extern void
printer_mib_set_prtGeneralReset(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtGeneralReset, GError **error);

extern void
printer_mib_set_prtGeneralCurrentOperator(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralCurrentOperator, guint16 _prtGeneralCurrentOperatorLength, GError **error);

extern void
printer_mib_set_prtGeneralServicePerson(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralServicePerson, guint16 _prtGeneralServicePersonLength, GError **error);

extern void
printer_mib_set_prtInputDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputDefaultIndex, GError **error);

extern void
printer_mib_set_prtOutputDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputDefaultIndex, GError **error);

extern void
printer_mib_set_prtMarkerDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerDefaultIndex, GError **error);

extern void
printer_mib_set_prtMediaPathDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMediaPathDefaultIndex, GError **error);

extern void
printer_mib_set_prtConsoleLocalization(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLocalization, GError **error);

extern void
printer_mib_set_prtConsoleDisable(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleDisable, GError **error);

extern void
printer_mib_set_prtAuxiliarySheetStartupPage(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtAuxiliarySheetStartupPage, GError **error);

extern void
printer_mib_set_prtAuxiliarySheetBannerPage(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtAuxiliarySheetBannerPage, GError **error);

extern void
printer_mib_set_prtGeneralPrinterName(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralPrinterName, guint16 _prtGeneralPrinterNameLength, GError **error);

extern void
printer_mib_set_prtGeneralSerialNumber(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralSerialNumber, guint16 _prtGeneralSerialNumberLength, GError **error);

/*
 * C type definitions for Printer-MIB::prtStorageRefEntry.
 */

#define PRINTER_MIB_PRTSTORAGEREFINDEX (1 << 0) 

typedef struct {
    gint32   hrStorageIndex;          /* ro */
    gint32   prtStorageRefSeqNumber;  /* na */
    gint32   *prtStorageRefIndex;     /* ro */
} printer_mib_prtStorageRefEntry_t;

extern void
printer_mib_get_prtStorageRefTable(GNetSnmp *s, printer_mib_prtStorageRefEntry_t ***prtStorageRefEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtStorageRefTable(printer_mib_prtStorageRefEntry_t **prtStorageRefEntry);

extern printer_mib_prtStorageRefEntry_t *
printer_mib_new_prtStorageRefEntry(void);

extern void
printer_mib_get_prtStorageRefEntry(GNetSnmp *s, printer_mib_prtStorageRefEntry_t **prtStorageRefEntry, gint32 hrStorageIndex, gint32 prtStorageRefSeqNumber, gint64 mask, GError **error);

extern void
printer_mib_free_prtStorageRefEntry(printer_mib_prtStorageRefEntry_t *prtStorageRefEntry);

/*
 * C type definitions for Printer-MIB::prtDeviceRefEntry.
 */

#define PRINTER_MIB_PRTDEVICEREFINDEX (1 << 0) 

typedef struct {
    gint32   hrDeviceIndex;          /* ro */
    gint32   prtDeviceRefSeqNumber;  /* na */
    gint32   *prtDeviceRefIndex;     /* ro */
} printer_mib_prtDeviceRefEntry_t;

extern void
printer_mib_get_prtDeviceRefTable(GNetSnmp *s, printer_mib_prtDeviceRefEntry_t ***prtDeviceRefEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtDeviceRefTable(printer_mib_prtDeviceRefEntry_t **prtDeviceRefEntry);

extern printer_mib_prtDeviceRefEntry_t *
printer_mib_new_prtDeviceRefEntry(void);

extern void
printer_mib_get_prtDeviceRefEntry(GNetSnmp *s, printer_mib_prtDeviceRefEntry_t **prtDeviceRefEntry, gint32 hrDeviceIndex, gint32 prtDeviceRefSeqNumber, gint64 mask, GError **error);

extern void
printer_mib_free_prtDeviceRefEntry(printer_mib_prtDeviceRefEntry_t *prtDeviceRefEntry);

/*
 * C type definitions for Printer-MIB::prtCoverEntry.
 */

#define PRINTER_MIB_PRTCOVERDESCRIPTION (1 << 0) 
#define PRINTER_MIB_PRTCOVERSTATUS      (1 << 1) 

typedef struct {
    gint32   hrDeviceIndex;            /* ro */
    gint32   prtCoverIndex;            /* na */
    guchar   *prtCoverDescription;     /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTCOVERDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTCOVERDESCRIPTIONMAXLENGTH 255
    guint16  _prtCoverDescriptionLength;
    gint32   *prtCoverStatus;          /* ro IANA-PRINTER-MIB::PrtCoverStatusTC */
} printer_mib_prtCoverEntry_t;

extern void
printer_mib_get_prtCoverTable(GNetSnmp *s, printer_mib_prtCoverEntry_t ***prtCoverEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtCoverTable(printer_mib_prtCoverEntry_t **prtCoverEntry);

extern printer_mib_prtCoverEntry_t *
printer_mib_new_prtCoverEntry(void);

extern void
printer_mib_get_prtCoverEntry(GNetSnmp *s, printer_mib_prtCoverEntry_t **prtCoverEntry, gint32 hrDeviceIndex, gint32 prtCoverIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtCoverEntry(printer_mib_prtCoverEntry_t *prtCoverEntry);

/*
 * C type definitions for Printer-MIB::prtLocalizationEntry.
 */

#define PRINTER_MIB_PRTLOCALIZATIONLANGUAGE     (1 << 0) 
#define PRINTER_MIB_PRTLOCALIZATIONCOUNTRY      (1 << 1) 
#define PRINTER_MIB_PRTLOCALIZATIONCHARACTERSET (1 << 2) 

typedef struct {
    gint32   hrDeviceIndex;                    /* ro */
    gint32   prtLocalizationIndex;             /* na */
    guchar   *prtLocalizationLanguage;         /* ro */
#define PRINTER_MIB_PRTLOCALIZATIONLANGUAGELENGTH 2
    guchar   *prtLocalizationCountry;          /* ro */
#define PRINTER_MIB_PRTLOCALIZATIONCOUNTRYLENGTH 2
    gint32   *prtLocalizationCharacterSet;     /* ro IANA-CHARSET-MIB::IANACharset */
} printer_mib_prtLocalizationEntry_t;

extern void
printer_mib_get_prtLocalizationTable(GNetSnmp *s, printer_mib_prtLocalizationEntry_t ***prtLocalizationEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtLocalizationTable(printer_mib_prtLocalizationEntry_t **prtLocalizationEntry);

extern printer_mib_prtLocalizationEntry_t *
printer_mib_new_prtLocalizationEntry(void);

extern void
printer_mib_get_prtLocalizationEntry(GNetSnmp *s, printer_mib_prtLocalizationEntry_t **prtLocalizationEntry, gint32 hrDeviceIndex, gint32 prtLocalizationIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtLocalizationEntry(printer_mib_prtLocalizationEntry_t *prtLocalizationEntry);

/*
 * C type definitions for Printer-MIB::prtInputEntry.
 */

#define PRINTER_MIB_PRTINPUTTYPE                     (1 << 0) 
#define PRINTER_MIB_PRTINPUTDIMUNIT                  (1 << 1) 
#define PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRDECLARED  (1 << 2) 
#define PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRDECLARED (1 << 3) 
#define PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRCHOSEN    (1 << 4) 
#define PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRCHOSEN   (1 << 5) 
#define PRINTER_MIB_PRTINPUTCAPACITYUNIT             (1 << 6) 
#define PRINTER_MIB_PRTINPUTMAXCAPACITY              (1 << 7) 
#define PRINTER_MIB_PRTINPUTCURRENTLEVEL             (1 << 8) 
#define PRINTER_MIB_PRTINPUTSTATUS                   (1 << 9) 
#define PRINTER_MIB_PRTINPUTMEDIANAME                (1 << 10) 
#define PRINTER_MIB_PRTINPUTNAME                     (1 << 11) 
#define PRINTER_MIB_PRTINPUTVENDORNAME               (1 << 12) 
#define PRINTER_MIB_PRTINPUTMODEL                    (1 << 13) 
#define PRINTER_MIB_PRTINPUTVERSION                  (1 << 14) 
#define PRINTER_MIB_PRTINPUTSERIALNUMBER             (1 << 15) 
#define PRINTER_MIB_PRTINPUTDESCRIPTION              (1 << 16) 
#define PRINTER_MIB_PRTINPUTSECURITY                 (1 << 17) 
#define PRINTER_MIB_PRTINPUTMEDIAWEIGHT              (1 << 18) 
#define PRINTER_MIB_PRTINPUTMEDIATYPE                (1 << 19) 
#define PRINTER_MIB_PRTINPUTMEDIACOLOR               (1 << 20) 
#define PRINTER_MIB_PRTINPUTMEDIAFORMPARTS           (1 << 21) 
#define PRINTER_MIB_PRTINPUTMEDIALOADTIMEOUT         (1 << 22) 
#define PRINTER_MIB_PRTINPUTNEXTINDEX                (1 << 23) 

typedef struct {
    gint32   hrDeviceIndex;                         /* ro */
    gint32   prtInputIndex;                         /* na */
    gint32   *prtInputType;                         /* ro IANA-PRINTER-MIB::PrtInputTypeTC */
    gint32   *prtInputDimUnit;                      /* ro Printer-MIB::PrtMediaUnitTC */
    gint32   *prtInputMediaDimFeedDirDeclared;      /* rw */
    gint32   *prtInputMediaDimXFeedDirDeclared;     /* rw */
    gint32   *prtInputMediaDimFeedDirChosen;        /* ro */
    gint32   *prtInputMediaDimXFeedDirChosen;       /* ro */
    gint32   *prtInputCapacityUnit;                 /* ro Printer-MIB::PrtCapacityUnitTC */
    gint32   *prtInputMaxCapacity;                  /* rw */
    gint32   *prtInputCurrentLevel;                 /* rw */
    gint32   *prtInputStatus;                       /* ro Printer-MIB::PrtSubUnitStatusTC */
    guchar   *prtInputMediaName;                    /* rw */
#define PRINTER_MIB_PRTINPUTMEDIANAMEMINLENGTH 0
#define PRINTER_MIB_PRTINPUTMEDIANAMEMAXLENGTH 63
    guint16  _prtInputMediaNameLength;
    guchar   *prtInputName;                         /* rw */
#define PRINTER_MIB_PRTINPUTNAMEMINLENGTH 0
#define PRINTER_MIB_PRTINPUTNAMEMAXLENGTH 63
    guint16  _prtInputNameLength;
    guchar   *prtInputVendorName;                   /* ro */
#define PRINTER_MIB_PRTINPUTVENDORNAMEMINLENGTH 0
#define PRINTER_MIB_PRTINPUTVENDORNAMEMAXLENGTH 63
    guint16  _prtInputVendorNameLength;
    guchar   *prtInputModel;                        /* ro */
#define PRINTER_MIB_PRTINPUTMODELMINLENGTH 0
#define PRINTER_MIB_PRTINPUTMODELMAXLENGTH 63
    guint16  _prtInputModelLength;
    guchar   *prtInputVersion;                      /* ro */
#define PRINTER_MIB_PRTINPUTVERSIONMINLENGTH 0
#define PRINTER_MIB_PRTINPUTVERSIONMAXLENGTH 63
    guint16  _prtInputVersionLength;
    guchar   *prtInputSerialNumber;                 /* ro */
#define PRINTER_MIB_PRTINPUTSERIALNUMBERMINLENGTH 0
#define PRINTER_MIB_PRTINPUTSERIALNUMBERMAXLENGTH 32
    guint16  _prtInputSerialNumberLength;
    guchar   *prtInputDescription;                  /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTINPUTDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTINPUTDESCRIPTIONMAXLENGTH 255
    guint16  _prtInputDescriptionLength;
    gint32   *prtInputSecurity;                     /* rw Printer-MIB::PresentOnOff */
    gint32   *prtInputMediaWeight;                  /* rw */
    guchar   *prtInputMediaType;                    /* rw */
#define PRINTER_MIB_PRTINPUTMEDIATYPEMINLENGTH 0
#define PRINTER_MIB_PRTINPUTMEDIATYPEMAXLENGTH 63
    guint16  _prtInputMediaTypeLength;
    guchar   *prtInputMediaColor;                   /* rw */
#define PRINTER_MIB_PRTINPUTMEDIACOLORMINLENGTH 0
#define PRINTER_MIB_PRTINPUTMEDIACOLORMAXLENGTH 63
    guint16  _prtInputMediaColorLength;
    gint32   *prtInputMediaFormParts;               /* rw */
    gint32   *prtInputMediaLoadTimeout;             /* rw */
    gint32   *prtInputNextIndex;                    /* rw */
} printer_mib_prtInputEntry_t;

extern void
printer_mib_get_prtInputTable(GNetSnmp *s, printer_mib_prtInputEntry_t ***prtInputEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtInputTable(printer_mib_prtInputEntry_t **prtInputEntry);

extern printer_mib_prtInputEntry_t *
printer_mib_new_prtInputEntry(void);

extern void
printer_mib_get_prtInputEntry(GNetSnmp *s, printer_mib_prtInputEntry_t **prtInputEntry, gint32 hrDeviceIndex, gint32 prtInputIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtInputEntry(GNetSnmp *s, printer_mib_prtInputEntry_t *prtInputEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtInputEntry(printer_mib_prtInputEntry_t *prtInputEntry);

extern void
printer_mib_set_prtInputMediaDimFeedDirDeclared(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaDimFeedDirDeclared, GError **error);

extern void
printer_mib_set_prtInputMediaDimXFeedDirDeclared(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaDimXFeedDirDeclared, GError **error);

extern void
printer_mib_set_prtInputMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMaxCapacity, GError **error);

extern void
printer_mib_set_prtInputCurrentLevel(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputCurrentLevel, GError **error);

extern void
printer_mib_set_prtInputMediaName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaName, guint16 _prtInputMediaNameLength, GError **error);

extern void
printer_mib_set_prtInputName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputName, guint16 _prtInputNameLength, GError **error);

extern void
printer_mib_set_prtInputSecurity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputSecurity, GError **error);

extern void
printer_mib_set_prtInputMediaWeight(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaWeight, GError **error);

extern void
printer_mib_set_prtInputMediaType(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaType, guint16 _prtInputMediaTypeLength, GError **error);

extern void
printer_mib_set_prtInputMediaColor(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaColor, guint16 _prtInputMediaColorLength, GError **error);

extern void
printer_mib_set_prtInputMediaFormParts(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaFormParts, GError **error);

extern void
printer_mib_set_prtInputMediaLoadTimeout(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaLoadTimeout, GError **error);

extern void
printer_mib_set_prtInputNextIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputNextIndex, GError **error);

/*
 * C type definitions for Printer-MIB::prtOutputEntry.
 */

#define PRINTER_MIB_PRTOUTPUTTYPE                    (1 << 0) 
#define PRINTER_MIB_PRTOUTPUTCAPACITYUNIT            (1 << 1) 
#define PRINTER_MIB_PRTOUTPUTMAXCAPACITY             (1 << 2) 
#define PRINTER_MIB_PRTOUTPUTREMAININGCAPACITY       (1 << 3) 
#define PRINTER_MIB_PRTOUTPUTSTATUS                  (1 << 4) 
#define PRINTER_MIB_PRTOUTPUTNAME                    (1 << 5) 
#define PRINTER_MIB_PRTOUTPUTVENDORNAME              (1 << 6) 
#define PRINTER_MIB_PRTOUTPUTMODEL                   (1 << 7) 
#define PRINTER_MIB_PRTOUTPUTVERSION                 (1 << 8) 
#define PRINTER_MIB_PRTOUTPUTSERIALNUMBER            (1 << 9) 
#define PRINTER_MIB_PRTOUTPUTDESCRIPTION             (1 << 10) 
#define PRINTER_MIB_PRTOUTPUTSECURITY                (1 << 11) 
#define PRINTER_MIB_PRTOUTPUTDIMUNIT                 (1 << 12) 
#define PRINTER_MIB_PRTOUTPUTMAXDIMFEEDDIR           (1 << 13) 
#define PRINTER_MIB_PRTOUTPUTMAXDIMXFEEDDIR          (1 << 14) 
#define PRINTER_MIB_PRTOUTPUTMINDIMFEEDDIR           (1 << 15) 
#define PRINTER_MIB_PRTOUTPUTMINDIMXFEEDDIR          (1 << 16) 
#define PRINTER_MIB_PRTOUTPUTSTACKINGORDER           (1 << 17) 
#define PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATION (1 << 18) 
#define PRINTER_MIB_PRTOUTPUTBURSTING                (1 << 19) 
#define PRINTER_MIB_PRTOUTPUTDECOLLATING             (1 << 20) 
#define PRINTER_MIB_PRTOUTPUTPAGECOLLATED            (1 << 21) 
#define PRINTER_MIB_PRTOUTPUTOFFSETSTACKING          (1 << 22) 

typedef struct {
    gint32   hrDeviceIndex;                         /* ro */
    gint32   prtOutputIndex;                        /* na */
    gint32   *prtOutputType;                        /* ro IANA-PRINTER-MIB::PrtOutputTypeTC */
    gint32   *prtOutputCapacityUnit;                /* ro Printer-MIB::PrtCapacityUnitTC */
    gint32   *prtOutputMaxCapacity;                 /* rw */
    gint32   *prtOutputRemainingCapacity;           /* rw */
    gint32   *prtOutputStatus;                      /* ro Printer-MIB::PrtSubUnitStatusTC */
    guchar   *prtOutputName;                        /* rw */
#define PRINTER_MIB_PRTOUTPUTNAMEMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTNAMEMAXLENGTH 63
    guint16  _prtOutputNameLength;
    guchar   *prtOutputVendorName;                  /* ro */
#define PRINTER_MIB_PRTOUTPUTVENDORNAMEMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTVENDORNAMEMAXLENGTH 63
    guint16  _prtOutputVendorNameLength;
    guchar   *prtOutputModel;                       /* ro */
#define PRINTER_MIB_PRTOUTPUTMODELMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTMODELMAXLENGTH 63
    guint16  _prtOutputModelLength;
    guchar   *prtOutputVersion;                     /* ro */
#define PRINTER_MIB_PRTOUTPUTVERSIONMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTVERSIONMAXLENGTH 63
    guint16  _prtOutputVersionLength;
    guchar   *prtOutputSerialNumber;                /* ro */
#define PRINTER_MIB_PRTOUTPUTSERIALNUMBERMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTSERIALNUMBERMAXLENGTH 63
    guint16  _prtOutputSerialNumberLength;
    guchar   *prtOutputDescription;                 /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTOUTPUTDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTOUTPUTDESCRIPTIONMAXLENGTH 255
    guint16  _prtOutputDescriptionLength;
    gint32   *prtOutputSecurity;                    /* rw Printer-MIB::PresentOnOff */
    gint32   *prtOutputDimUnit;                     /* ro Printer-MIB::PrtMediaUnitTC */
    gint32   *prtOutputMaxDimFeedDir;               /* rw */
    gint32   *prtOutputMaxDimXFeedDir;              /* rw */
    gint32   *prtOutputMinDimFeedDir;               /* rw */
    gint32   *prtOutputMinDimXFeedDir;              /* rw */
    gint32   *prtOutputStackingOrder;               /* rw Printer-MIB::PrtOutputStackingOrderTC */
    gint32   *prtOutputPageDeliveryOrientation;     /* rw Printer-MIB::PrtOutputPageDeliveryOrientationTC */
    gint32   *prtOutputBursting;                    /* rw Printer-MIB::PresentOnOff */
    gint32   *prtOutputDecollating;                 /* rw Printer-MIB::PresentOnOff */
    gint32   *prtOutputPageCollated;                /* rw Printer-MIB::PresentOnOff */
    gint32   *prtOutputOffsetStacking;              /* rw Printer-MIB::PresentOnOff */
} printer_mib_prtOutputEntry_t;

extern void
printer_mib_get_prtOutputTable(GNetSnmp *s, printer_mib_prtOutputEntry_t ***prtOutputEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtOutputTable(printer_mib_prtOutputEntry_t **prtOutputEntry);

extern printer_mib_prtOutputEntry_t *
printer_mib_new_prtOutputEntry(void);

extern void
printer_mib_get_prtOutputEntry(GNetSnmp *s, printer_mib_prtOutputEntry_t **prtOutputEntry, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtOutputEntry(GNetSnmp *s, printer_mib_prtOutputEntry_t *prtOutputEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtOutputEntry(printer_mib_prtOutputEntry_t *prtOutputEntry);

extern void
printer_mib_set_prtOutputMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxCapacity, GError **error);

extern void
printer_mib_set_prtOutputRemainingCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputRemainingCapacity, GError **error);

extern void
printer_mib_set_prtOutputName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, guchar *prtOutputName, guint16 _prtOutputNameLength, GError **error);

extern void
printer_mib_set_prtOutputSecurity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputSecurity, GError **error);

extern void
printer_mib_set_prtOutputMaxDimFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxDimFeedDir, GError **error);

extern void
printer_mib_set_prtOutputMaxDimXFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxDimXFeedDir, GError **error);

extern void
printer_mib_set_prtOutputMinDimFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMinDimFeedDir, GError **error);

extern void
printer_mib_set_prtOutputMinDimXFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMinDimXFeedDir, GError **error);

extern void
printer_mib_set_prtOutputStackingOrder(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputStackingOrder, GError **error);

extern void
printer_mib_set_prtOutputPageDeliveryOrientation(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputPageDeliveryOrientation, GError **error);

extern void
printer_mib_set_prtOutputBursting(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputBursting, GError **error);

extern void
printer_mib_set_prtOutputDecollating(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputDecollating, GError **error);

extern void
printer_mib_set_prtOutputPageCollated(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputPageCollated, GError **error);

extern void
printer_mib_set_prtOutputOffsetStacking(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputOffsetStacking, GError **error);

/*
 * C type definitions for Printer-MIB::prtMarkerEntry.
 */

#define PRINTER_MIB_PRTMARKERMARKTECH               (1 << 0) 
#define PRINTER_MIB_PRTMARKERCOUNTERUNIT            (1 << 1) 
#define PRINTER_MIB_PRTMARKERLIFECOUNT              (1 << 2) 
#define PRINTER_MIB_PRTMARKERPOWERONCOUNT           (1 << 3) 
#define PRINTER_MIB_PRTMARKERPROCESSCOLORANTS       (1 << 4) 
#define PRINTER_MIB_PRTMARKERSPOTCOLORANTS          (1 << 5) 
#define PRINTER_MIB_PRTMARKERADDRESSABILITYUNIT     (1 << 6) 
#define PRINTER_MIB_PRTMARKERADDRESSABILITYFEEDDIR  (1 << 7) 
#define PRINTER_MIB_PRTMARKERADDRESSABILITYXFEEDDIR (1 << 8) 
#define PRINTER_MIB_PRTMARKERNORTHMARGIN            (1 << 9) 
#define PRINTER_MIB_PRTMARKERSOUTHMARGIN            (1 << 10) 
#define PRINTER_MIB_PRTMARKERWESTMARGIN             (1 << 11) 
#define PRINTER_MIB_PRTMARKEREASTMARGIN             (1 << 12) 
#define PRINTER_MIB_PRTMARKERSTATUS                 (1 << 13) 

typedef struct {
    gint32   hrDeviceIndex;                        /* ro */
    gint32   prtMarkerIndex;                       /* na */
    gint32   *prtMarkerMarkTech;                   /* ro IANA-PRINTER-MIB::PrtMarkerMarkTechTC */
    gint32   *prtMarkerCounterUnit;                /* ro Printer-MIB::PrtMarkerCounterUnitTC */
    guint32  *prtMarkerLifeCount;                  /* ro SNMPv2-SMI::Counter32 */
    guint32  *prtMarkerPowerOnCount;               /* ro SNMPv2-SMI::Counter32 */
    gint32   *prtMarkerProcessColorants;           /* ro */
    gint32   *prtMarkerSpotColorants;              /* ro */
    gint32   *prtMarkerAddressabilityUnit;         /* ro Printer-MIB::PrtMarkerAddressabilityUnitTC */
    gint32   *prtMarkerAddressabilityFeedDir;      /* ro */
    gint32   *prtMarkerAddressabilityXFeedDir;     /* ro */
    gint32   *prtMarkerNorthMargin;                /* ro */
    gint32   *prtMarkerSouthMargin;                /* ro */
    gint32   *prtMarkerWestMargin;                 /* ro */
    gint32   *prtMarkerEastMargin;                 /* ro */
    gint32   *prtMarkerStatus;                     /* ro Printer-MIB::PrtSubUnitStatusTC */
} printer_mib_prtMarkerEntry_t;

extern void
printer_mib_get_prtMarkerTable(GNetSnmp *s, printer_mib_prtMarkerEntry_t ***prtMarkerEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerTable(printer_mib_prtMarkerEntry_t **prtMarkerEntry);

extern printer_mib_prtMarkerEntry_t *
printer_mib_new_prtMarkerEntry(void);

extern void
printer_mib_get_prtMarkerEntry(GNetSnmp *s, printer_mib_prtMarkerEntry_t **prtMarkerEntry, gint32 hrDeviceIndex, gint32 prtMarkerIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerEntry(printer_mib_prtMarkerEntry_t *prtMarkerEntry);

/*
 * C type definitions for Printer-MIB::prtMarkerSuppliesEntry.
 */

#define PRINTER_MIB_PRTMARKERSUPPLIESMARKERINDEX   (1 << 0) 
#define PRINTER_MIB_PRTMARKERSUPPLIESCOLORANTINDEX (1 << 1) 
#define PRINTER_MIB_PRTMARKERSUPPLIESCLASS         (1 << 2) 
#define PRINTER_MIB_PRTMARKERSUPPLIESTYPE          (1 << 3) 
#define PRINTER_MIB_PRTMARKERSUPPLIESDESCRIPTION   (1 << 4) 
#define PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNIT    (1 << 5) 
#define PRINTER_MIB_PRTMARKERSUPPLIESMAXCAPACITY   (1 << 6) 
#define PRINTER_MIB_PRTMARKERSUPPLIESLEVEL         (1 << 7) 

typedef struct {
    gint32   hrDeviceIndex;                       /* ro */
    gint32   prtMarkerSuppliesIndex;              /* na */
    gint32   *prtMarkerSuppliesMarkerIndex;       /* ro */
    gint32   *prtMarkerSuppliesColorantIndex;     /* ro */
    gint32   *prtMarkerSuppliesClass;             /* ro Printer-MIB::PrtMarkerSuppliesClassTC */
    gint32   *prtMarkerSuppliesType;              /* ro IANA-PRINTER-MIB::PrtMarkerSuppliesTypeTC */
    guchar   *prtMarkerSuppliesDescription;       /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTMARKERSUPPLIESDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTMARKERSUPPLIESDESCRIPTIONMAXLENGTH 255
    guint16  _prtMarkerSuppliesDescriptionLength;
    gint32   *prtMarkerSuppliesSupplyUnit;        /* ro Printer-MIB::PrtMarkerSuppliesSupplyUnitTC */
    gint32   *prtMarkerSuppliesMaxCapacity;       /* rw */
    gint32   *prtMarkerSuppliesLevel;             /* rw */
} printer_mib_prtMarkerSuppliesEntry_t;

extern void
printer_mib_get_prtMarkerSuppliesTable(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t ***prtMarkerSuppliesEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerSuppliesTable(printer_mib_prtMarkerSuppliesEntry_t **prtMarkerSuppliesEntry);

extern printer_mib_prtMarkerSuppliesEntry_t *
printer_mib_new_prtMarkerSuppliesEntry(void);

extern void
printer_mib_get_prtMarkerSuppliesEntry(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t **prtMarkerSuppliesEntry, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtMarkerSuppliesEntry(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerSuppliesEntry(printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry);

extern void
printer_mib_set_prtMarkerSuppliesMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint32 prtMarkerSuppliesMaxCapacity, GError **error);

extern void
printer_mib_set_prtMarkerSuppliesLevel(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint32 prtMarkerSuppliesLevel, GError **error);

/*
 * C type definitions for Printer-MIB::prtMarkerColorantEntry.
 */

#define PRINTER_MIB_PRTMARKERCOLORANTMARKERINDEX (1 << 0) 
#define PRINTER_MIB_PRTMARKERCOLORANTROLE        (1 << 1) 
#define PRINTER_MIB_PRTMARKERCOLORANTVALUE       (1 << 2) 
#define PRINTER_MIB_PRTMARKERCOLORANTTONALITY    (1 << 3) 

typedef struct {
    gint32   hrDeviceIndex;                     /* ro */
    gint32   prtMarkerColorantIndex;            /* na */
    gint32   *prtMarkerColorantMarkerIndex;     /* ro */
    gint32   *prtMarkerColorantRole;            /* ro Printer-MIB::PrtMarkerColorantRoleTC */
    guchar   *prtMarkerColorantValue;           /* ro */
#define PRINTER_MIB_PRTMARKERCOLORANTVALUEMINLENGTH 0
#define PRINTER_MIB_PRTMARKERCOLORANTVALUEMAXLENGTH 255
    guint16  _prtMarkerColorantValueLength;
    gint32   *prtMarkerColorantTonality;        /* ro */
} printer_mib_prtMarkerColorantEntry_t;

extern void
printer_mib_get_prtMarkerColorantTable(GNetSnmp *s, printer_mib_prtMarkerColorantEntry_t ***prtMarkerColorantEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerColorantTable(printer_mib_prtMarkerColorantEntry_t **prtMarkerColorantEntry);

extern printer_mib_prtMarkerColorantEntry_t *
printer_mib_new_prtMarkerColorantEntry(void);

extern void
printer_mib_get_prtMarkerColorantEntry(GNetSnmp *s, printer_mib_prtMarkerColorantEntry_t **prtMarkerColorantEntry, gint32 hrDeviceIndex, gint32 prtMarkerColorantIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtMarkerColorantEntry(printer_mib_prtMarkerColorantEntry_t *prtMarkerColorantEntry);

/*
 * C type definitions for Printer-MIB::prtMediaPathEntry.
 */

#define PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNIT (1 << 0) 
#define PRINTER_MIB_PRTMEDIAPATHMEDIASIZEUNIT     (1 << 1) 
#define PRINTER_MIB_PRTMEDIAPATHMAXSPEED          (1 << 2) 
#define PRINTER_MIB_PRTMEDIAPATHMAXMEDIAFEEDDIR   (1 << 3) 
#define PRINTER_MIB_PRTMEDIAPATHMAXMEDIAXFEEDDIR  (1 << 4) 
#define PRINTER_MIB_PRTMEDIAPATHMINMEDIAFEEDDIR   (1 << 5) 
#define PRINTER_MIB_PRTMEDIAPATHMINMEDIAXFEEDDIR  (1 << 6) 
#define PRINTER_MIB_PRTMEDIAPATHTYPE              (1 << 7) 
#define PRINTER_MIB_PRTMEDIAPATHDESCRIPTION       (1 << 8) 
#define PRINTER_MIB_PRTMEDIAPATHSTATUS            (1 << 9) 

typedef struct {
    gint32   hrDeviceIndex;                      /* ro */
    gint32   prtMediaPathIndex;                  /* na */
    gint32   *prtMediaPathMaxSpeedPrintUnit;     /* ro Printer-MIB::PrtMediaPathMaxSpeedPrintUnitTC */
    gint32   *prtMediaPathMediaSizeUnit;         /* ro Printer-MIB::PrtMediaUnitTC */
    gint32   *prtMediaPathMaxSpeed;              /* ro */
    gint32   *prtMediaPathMaxMediaFeedDir;       /* ro */
    gint32   *prtMediaPathMaxMediaXFeedDir;      /* ro */
    gint32   *prtMediaPathMinMediaFeedDir;       /* ro */
    gint32   *prtMediaPathMinMediaXFeedDir;      /* ro */
    gint32   *prtMediaPathType;                  /* ro IANA-PRINTER-MIB::PrtMediaPathTypeTC */
    guchar   *prtMediaPathDescription;           /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTMEDIAPATHDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTMEDIAPATHDESCRIPTIONMAXLENGTH 255
    guint16  _prtMediaPathDescriptionLength;
    gint32   *prtMediaPathStatus;                /* ro Printer-MIB::PrtSubUnitStatusTC */
} printer_mib_prtMediaPathEntry_t;

extern void
printer_mib_get_prtMediaPathTable(GNetSnmp *s, printer_mib_prtMediaPathEntry_t ***prtMediaPathEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtMediaPathTable(printer_mib_prtMediaPathEntry_t **prtMediaPathEntry);

extern printer_mib_prtMediaPathEntry_t *
printer_mib_new_prtMediaPathEntry(void);

extern void
printer_mib_get_prtMediaPathEntry(GNetSnmp *s, printer_mib_prtMediaPathEntry_t **prtMediaPathEntry, gint32 hrDeviceIndex, gint32 prtMediaPathIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtMediaPathEntry(printer_mib_prtMediaPathEntry_t *prtMediaPathEntry);

/*
 * C type definitions for Printer-MIB::prtChannelEntry.
 */

#define PRINTER_MIB_PRTCHANNELTYPE                     (1 << 0) 
#define PRINTER_MIB_PRTCHANNELPROTOCOLVERSION          (1 << 1) 
#define PRINTER_MIB_PRTCHANNELCURRENTJOBCNTLLANGINDEX  (1 << 2) 
#define PRINTER_MIB_PRTCHANNELDEFAULTPAGEDESCLANGINDEX (1 << 3) 
#define PRINTER_MIB_PRTCHANNELSTATE                    (1 << 4) 
#define PRINTER_MIB_PRTCHANNELIFINDEX                  (1 << 5) 
#define PRINTER_MIB_PRTCHANNELSTATUS                   (1 << 6) 
#define PRINTER_MIB_PRTCHANNELINFORMATION              (1 << 7) 

typedef struct {
    gint32   hrDeviceIndex;                           /* ro */
    gint32   prtChannelIndex;                         /* na */
    gint32   *prtChannelType;                         /* ro IANA-PRINTER-MIB::PrtChannelTypeTC */
    guchar   *prtChannelProtocolVersion;              /* ro */
#define PRINTER_MIB_PRTCHANNELPROTOCOLVERSIONMINLENGTH 0
#define PRINTER_MIB_PRTCHANNELPROTOCOLVERSIONMAXLENGTH 63
    guint16  _prtChannelProtocolVersionLength;
    gint32   *prtChannelCurrentJobCntlLangIndex;      /* rw */
    gint32   *prtChannelDefaultPageDescLangIndex;     /* rw */
    gint32   *prtChannelState;                        /* rw Printer-MIB::PrtChannelStateTC */
    gint32   *prtChannelIfIndex;                      /* rw IF-MIB::InterfaceIndexOrZero */
    gint32   *prtChannelStatus;                       /* ro Printer-MIB::PrtSubUnitStatusTC */
    guchar   *prtChannelInformation;                  /* ro */
#define PRINTER_MIB_PRTCHANNELINFORMATIONMINLENGTH 0
#define PRINTER_MIB_PRTCHANNELINFORMATIONMAXLENGTH 255
    guint16  _prtChannelInformationLength;
} printer_mib_prtChannelEntry_t;

extern void
printer_mib_get_prtChannelTable(GNetSnmp *s, printer_mib_prtChannelEntry_t ***prtChannelEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtChannelTable(printer_mib_prtChannelEntry_t **prtChannelEntry);

extern printer_mib_prtChannelEntry_t *
printer_mib_new_prtChannelEntry(void);

extern void
printer_mib_get_prtChannelEntry(GNetSnmp *s, printer_mib_prtChannelEntry_t **prtChannelEntry, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtChannelEntry(GNetSnmp *s, printer_mib_prtChannelEntry_t *prtChannelEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtChannelEntry(printer_mib_prtChannelEntry_t *prtChannelEntry);

extern void
printer_mib_set_prtChannelCurrentJobCntlLangIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelCurrentJobCntlLangIndex, GError **error);

extern void
printer_mib_set_prtChannelDefaultPageDescLangIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelDefaultPageDescLangIndex, GError **error);

extern void
printer_mib_set_prtChannelState(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelState, GError **error);

extern void
printer_mib_set_prtChannelIfIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelIfIndex, GError **error);

/*
 * C type definitions for Printer-MIB::prtInterpreterEntry.
 */

#define PRINTER_MIB_PRTINTERPRETERLANGFAMILY          (1 << 0) 
#define PRINTER_MIB_PRTINTERPRETERLANGLEVEL           (1 << 1) 
#define PRINTER_MIB_PRTINTERPRETERLANGVERSION         (1 << 2) 
#define PRINTER_MIB_PRTINTERPRETERDESCRIPTION         (1 << 3) 
#define PRINTER_MIB_PRTINTERPRETERVERSION             (1 << 4) 
#define PRINTER_MIB_PRTINTERPRETERDEFAULTORIENTATION  (1 << 5) 
#define PRINTER_MIB_PRTINTERPRETERFEEDADDRESSABILITY  (1 << 6) 
#define PRINTER_MIB_PRTINTERPRETERXFEEDADDRESSABILITY (1 << 7) 
#define PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETIN    (1 << 8) 
#define PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETOUT   (1 << 9) 
#define PRINTER_MIB_PRTINTERPRETERTWOWAY              (1 << 10) 

typedef struct {
    gint32   hrDeviceIndex;                          /* ro */
    gint32   prtInterpreterIndex;                    /* na */
    gint32   *prtInterpreterLangFamily;              /* ro IANA-PRINTER-MIB::PrtInterpreterLangFamilyTC */
    guchar   *prtInterpreterLangLevel;               /* ro */
#define PRINTER_MIB_PRTINTERPRETERLANGLEVELMINLENGTH 0
#define PRINTER_MIB_PRTINTERPRETERLANGLEVELMAXLENGTH 31
    guint16  _prtInterpreterLangLevelLength;
    guchar   *prtInterpreterLangVersion;             /* ro */
#define PRINTER_MIB_PRTINTERPRETERLANGVERSIONMINLENGTH 0
#define PRINTER_MIB_PRTINTERPRETERLANGVERSIONMAXLENGTH 31
    guint16  _prtInterpreterLangVersionLength;
    guchar   *prtInterpreterDescription;             /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTINTERPRETERDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTINTERPRETERDESCRIPTIONMAXLENGTH 255
    guint16  _prtInterpreterDescriptionLength;
    guchar   *prtInterpreterVersion;                 /* ro */
#define PRINTER_MIB_PRTINTERPRETERVERSIONMINLENGTH 0
#define PRINTER_MIB_PRTINTERPRETERVERSIONMAXLENGTH 31
    guint16  _prtInterpreterVersionLength;
    gint32   *prtInterpreterDefaultOrientation;      /* rw Printer-MIB::PrtPrintOrientationTC */
    gint32   *prtInterpreterFeedAddressability;      /* ro */
    gint32   *prtInterpreterXFeedAddressability;     /* ro */
    gint32   *prtInterpreterDefaultCharSetIn;        /* rw IANA-CHARSET-MIB::IANACharset */
    gint32   *prtInterpreterDefaultCharSetOut;       /* rw IANA-CHARSET-MIB::IANACharset */
    gint32   *prtInterpreterTwoWay;                  /* ro Printer-MIB::PrtInterpreterTwoWayTC */
} printer_mib_prtInterpreterEntry_t;

extern void
printer_mib_get_prtInterpreterTable(GNetSnmp *s, printer_mib_prtInterpreterEntry_t ***prtInterpreterEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtInterpreterTable(printer_mib_prtInterpreterEntry_t **prtInterpreterEntry);

extern printer_mib_prtInterpreterEntry_t *
printer_mib_new_prtInterpreterEntry(void);

extern void
printer_mib_get_prtInterpreterEntry(GNetSnmp *s, printer_mib_prtInterpreterEntry_t **prtInterpreterEntry, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtInterpreterEntry(GNetSnmp *s, printer_mib_prtInterpreterEntry_t *prtInterpreterEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtInterpreterEntry(printer_mib_prtInterpreterEntry_t *prtInterpreterEntry);

extern void
printer_mib_set_prtInterpreterDefaultOrientation(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultOrientation, GError **error);

extern void
printer_mib_set_prtInterpreterDefaultCharSetIn(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultCharSetIn, GError **error);

extern void
printer_mib_set_prtInterpreterDefaultCharSetOut(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultCharSetOut, GError **error);

/*
 * C type definitions for Printer-MIB::prtConsoleDisplayBufferEntry.
 */

#define PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXT (1 << 0) 

typedef struct {
    gint32   hrDeviceIndex;                    /* ro */
    gint32   prtConsoleDisplayBufferIndex;     /* na */
    guchar   *prtConsoleDisplayBufferText;     /* rw Printer-MIB::PrtConsoleDescriptionStringTC */
#define PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXTMINLENGTH 0
#define PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXTMAXLENGTH 255
    guint16  _prtConsoleDisplayBufferTextLength;
} printer_mib_prtConsoleDisplayBufferEntry_t;

extern void
printer_mib_get_prtConsoleDisplayBufferTable(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t ***prtConsoleDisplayBufferEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtConsoleDisplayBufferTable(printer_mib_prtConsoleDisplayBufferEntry_t **prtConsoleDisplayBufferEntry);

extern printer_mib_prtConsoleDisplayBufferEntry_t *
printer_mib_new_prtConsoleDisplayBufferEntry(void);

extern void
printer_mib_get_prtConsoleDisplayBufferEntry(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t **prtConsoleDisplayBufferEntry, gint32 hrDeviceIndex, gint32 prtConsoleDisplayBufferIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtConsoleDisplayBufferEntry(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtConsoleDisplayBufferEntry(printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry);

extern void
printer_mib_set_prtConsoleDisplayBufferText(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleDisplayBufferIndex, guchar *prtConsoleDisplayBufferText, guint16 _prtConsoleDisplayBufferTextLength, GError **error);

/*
 * C type definitions for Printer-MIB::prtConsoleLightEntry.
 */

#define PRINTER_MIB_PRTCONSOLEONTIME      (1 << 0) 
#define PRINTER_MIB_PRTCONSOLEOFFTIME     (1 << 1) 
#define PRINTER_MIB_PRTCONSOLECOLOR       (1 << 2) 
#define PRINTER_MIB_PRTCONSOLEDESCRIPTION (1 << 3) 

typedef struct {
    gint32   hrDeviceIndex;              /* ro */
    gint32   prtConsoleLightIndex;       /* na */
    gint32   *prtConsoleOnTime;          /* rw */
    gint32   *prtConsoleOffTime;         /* rw */
    gint32   *prtConsoleColor;           /* ro IANA-PRINTER-MIB::PrtConsoleColorTC */
    guchar   *prtConsoleDescription;     /* ro Printer-MIB::PrtConsoleDescriptionStringTC */
#define PRINTER_MIB_PRTCONSOLEDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTCONSOLEDESCRIPTIONMAXLENGTH 255
    guint16  _prtConsoleDescriptionLength;
} printer_mib_prtConsoleLightEntry_t;

extern void
printer_mib_get_prtConsoleLightTable(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t ***prtConsoleLightEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtConsoleLightTable(printer_mib_prtConsoleLightEntry_t **prtConsoleLightEntry);

extern printer_mib_prtConsoleLightEntry_t *
printer_mib_new_prtConsoleLightEntry(void);

extern void
printer_mib_get_prtConsoleLightEntry(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t **prtConsoleLightEntry, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint64 mask, GError **error);

extern void
printer_mib_set_prtConsoleLightEntry(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtConsoleLightEntry(printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry);

extern void
printer_mib_set_prtConsoleOnTime(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint32 prtConsoleOnTime, GError **error);

extern void
printer_mib_set_prtConsoleOffTime(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint32 prtConsoleOffTime, GError **error);

/*
 * C type definitions for Printer-MIB::prtAlertEntry.
 */

#define PRINTER_MIB_PRTALERTINDEX         (1 << 0) 
#define PRINTER_MIB_PRTALERTSEVERITYLEVEL (1 << 1) 
#define PRINTER_MIB_PRTALERTTRAININGLEVEL (1 << 2) 
#define PRINTER_MIB_PRTALERTGROUP         (1 << 3) 
#define PRINTER_MIB_PRTALERTGROUPINDEX    (1 << 4) 
#define PRINTER_MIB_PRTALERTLOCATION      (1 << 5) 
#define PRINTER_MIB_PRTALERTCODE          (1 << 6) 
#define PRINTER_MIB_PRTALERTDESCRIPTION   (1 << 7) 
#define PRINTER_MIB_PRTALERTTIME          (1 << 8) 

typedef struct {
    gint32   hrDeviceIndex;              /* ro */
    gint32   prtAlertIndex;              /* ro */
    gint32   *prtAlertSeverityLevel;     /* ro Printer-MIB::PrtAlertSeverityLevelTC */
    gint32   *prtAlertTrainingLevel;     /* ro IANA-PRINTER-MIB::PrtAlertTrainingLevelTC */
    gint32   *prtAlertGroup;             /* ro IANA-PRINTER-MIB::PrtAlertGroupTC */
    gint32   *prtAlertGroupIndex;        /* ro */
    gint32   *prtAlertLocation;          /* ro */
    gint32   *prtAlertCode;              /* ro IANA-PRINTER-MIB::PrtAlertCodeTC */
    guchar   *prtAlertDescription;       /* ro Printer-MIB::PrtLocalizedDescriptionStringTC */
#define PRINTER_MIB_PRTALERTDESCRIPTIONMINLENGTH 0
#define PRINTER_MIB_PRTALERTDESCRIPTIONMAXLENGTH 255
    guint16  _prtAlertDescriptionLength;
    guint32  *prtAlertTime;              /* ro SNMPv2-SMI::TimeTicks */
} printer_mib_prtAlertEntry_t;

extern void
printer_mib_get_prtAlertTable(GNetSnmp *s, printer_mib_prtAlertEntry_t ***prtAlertEntry, gint64 mask, GError **error);

extern void
printer_mib_free_prtAlertTable(printer_mib_prtAlertEntry_t **prtAlertEntry);

extern printer_mib_prtAlertEntry_t *
printer_mib_new_prtAlertEntry(void);

extern void
printer_mib_get_prtAlertEntry(GNetSnmp *s, printer_mib_prtAlertEntry_t **prtAlertEntry, gint32 hrDeviceIndex, gint32 prtAlertIndex, gint64 mask, GError **error);

extern void
printer_mib_free_prtAlertEntry(printer_mib_prtAlertEntry_t *prtAlertEntry);


G_END_DECLS

#endif /* _PRINTER_MIB_H_ */
