#include "Builder.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --disable-return-size-array --output-dir src\jni --throws-exception-on-error --description-file src\jni\builder.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_graphic_objects_builder {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * Builder::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Builder::~Builder() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
Builder::Builder(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintcreateRectjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjintintjintintjintintID=NULL;
jintcloneGraphicContextjintintjintintID=NULL;
jintcloneFontContextjintintjintintID=NULL;
jintcreateHiddenLabeljintintID=NULL;
jbooleanisAxesRedrawingjintintID=NULL;
jintcreateLabeljintintjintintID=NULL;
jintcreateNewFigureWithAxesID=NULL;
jintcreateFigurejbooleanbooleanjintintjintintjbooleanbooleanjbooleanbooleanID=NULL;
voidcloneMenusjintintjintintID=NULL;
jintcloneAxesModeljintintID=NULL;
jintcreateSubWinjintintID=NULL;
jintcreateTextjintintjobjectArray_java_lang_Stringjava_lang_StringjintintjintintjdoubledoublejdoubledoublejbooleanbooleanjdoubleArray_doubledoublejintintjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjintintID=NULL;
jintcreateArcjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintcreateAxisjintintjintintjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejintintjstringjava_lang_StringjintintjintintjintintjbooleanbooleanID=NULL;
jintcreateCompoundjintintjintArray_intintID=NULL;
jintcreateCompoundSeqjintintjintintID=NULL;
jintcreateFecjintintjdoubleArray_doubledoublejintArray_intintjintArray_intintjbooleanbooleanID=NULL;
jintcreateGrayplotjintintjintintjdoubleArray_doubledoublejintintjintintID=NULL;
jintcreatePolylinejintintjbooleanbooleanjintintjintintjbooleanbooleanjintArray_intintjintintjbooleanbooleanjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintcreateLegendjintintjobjectArray_java_lang_Stringjava_lang_StringjintArray_intintID=NULL;
jintcreateSegsjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejbooleanbooleanjintArray_intintjdoubledoubleID=NULL;
jintcreateChampjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejbooleanbooleanID=NULL;
jintcreateSurfacejintintjintintjintintjintintID=NULL;
voidinitSubWinTo3djintintjstringjava_lang_StringjbooleanbooleanjintArray_intintjdoubledoublejdoubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID=NULL;
jintcreateLightjintintjintintjbooleanbooleanjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID=NULL;


}

Builder::Builder(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintcreateRectjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjintintjintintjintintID=NULL;
jintcloneGraphicContextjintintjintintID=NULL;
jintcloneFontContextjintintjintintID=NULL;
jintcreateHiddenLabeljintintID=NULL;
jbooleanisAxesRedrawingjintintID=NULL;
jintcreateLabeljintintjintintID=NULL;
jintcreateNewFigureWithAxesID=NULL;
jintcreateFigurejbooleanbooleanjintintjintintjbooleanbooleanjbooleanbooleanID=NULL;
voidcloneMenusjintintjintintID=NULL;
jintcloneAxesModeljintintID=NULL;
jintcreateSubWinjintintID=NULL;
jintcreateTextjintintjobjectArray_java_lang_Stringjava_lang_StringjintintjintintjdoubledoublejdoubledoublejbooleanbooleanjdoubleArray_doubledoublejintintjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjintintID=NULL;
jintcreateArcjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintcreateAxisjintintjintintjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejintintjstringjava_lang_StringjintintjintintjintintjbooleanbooleanID=NULL;
jintcreateCompoundjintintjintArray_intintID=NULL;
jintcreateCompoundSeqjintintjintintID=NULL;
jintcreateFecjintintjdoubleArray_doubledoublejintArray_intintjintArray_intintjbooleanbooleanID=NULL;
jintcreateGrayplotjintintjintintjdoubleArray_doubledoublejintintjintintID=NULL;
jintcreatePolylinejintintjbooleanbooleanjintintjintintjbooleanbooleanjintArray_intintjintintjbooleanbooleanjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintcreateLegendjintintjobjectArray_java_lang_Stringjava_lang_StringjintArray_intintID=NULL;
jintcreateSegsjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejbooleanbooleanjintArray_intintjdoubledoubleID=NULL;
jintcreateChampjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejbooleanbooleanID=NULL;
jintcreateSurfacejintintjintintjintintjintintID=NULL;
voidinitSubWinTo3djintintjstringjava_lang_StringjbooleanbooleanjintArray_intintjdoubledoublejdoubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID=NULL;
jintcreateLightjintintjintintjbooleanbooleanjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID=NULL;


}

// Generic methods

void Builder::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Builder");
}
}

void Builder::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Builder");
}
}
// Method(s)

int Builder::createRect (JavaVM * jvm_, int pparentsubwinUID, double x, double y, double height, double width, int foreground, int background, int isfilled, int isline){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateRectjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "createRect", "(IDDDDIIII)I" ) ;
if (jintcreateRectjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createRect");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateRectjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjintintjintintjintintID ,pparentsubwinUID, x, y, height, width, foreground, background, isfilled, isline));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::cloneGraphicContext (JavaVM * jvm_, int sourceIdentifier, int destIdentifier){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcloneGraphicContextjintintjintintID = curEnv->GetStaticMethodID(cls, "cloneGraphicContext", "(II)I" ) ;
if (jintcloneGraphicContextjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "cloneGraphicContext");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcloneGraphicContextjintintjintintID ,sourceIdentifier, destIdentifier));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::cloneFontContext (JavaVM * jvm_, int sourceIdentifier, int destIdentifier){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcloneFontContextjintintjintintID = curEnv->GetStaticMethodID(cls, "cloneFontContext", "(II)I" ) ;
if (jintcloneFontContextjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "cloneFontContext");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcloneFontContextjintintjintintID ,sourceIdentifier, destIdentifier));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createHiddenLabel (JavaVM * jvm_, int parent){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateHiddenLabeljintintID = curEnv->GetStaticMethodID(cls, "createHiddenLabel", "(I)I" ) ;
if (jintcreateHiddenLabeljintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createHiddenLabel");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateHiddenLabeljintintID ,parent));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool Builder::isAxesRedrawing (JavaVM * jvm_, int subWin){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jbooleanisAxesRedrawingjintintID = curEnv->GetStaticMethodID(cls, "isAxesRedrawing", "(I)Z" ) ;
if (jbooleanisAxesRedrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isAxesRedrawing");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisAxesRedrawingjintintID ,subWin));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int Builder::createLabel (JavaVM * jvm_, int parent, int type){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateLabeljintintjintintID = curEnv->GetStaticMethodID(cls, "createLabel", "(II)I" ) ;
if (jintcreateLabeljintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createLabel");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateLabeljintintjintintID ,parent, type));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createNewFigureWithAxes (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateNewFigureWithAxesID = curEnv->GetStaticMethodID(cls, "createNewFigureWithAxes", "()I" ) ;
if (jintcreateNewFigureWithAxesID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createNewFigureWithAxes");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateNewFigureWithAxesID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createFigure (JavaVM * jvm_, bool dockable, int menubarType, int toolbarType, bool defaultAxes, bool visible){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateFigurejbooleanbooleanjintintjintintjbooleanbooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createFigure", "(ZIIZZ)I" ) ;
if (jintcreateFigurejbooleanbooleanjintintjintintjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createFigure");
}

jboolean dockable_ = (static_cast<bool>(dockable) ? JNI_TRUE : JNI_FALSE);

jboolean defaultAxes_ = (static_cast<bool>(defaultAxes) ? JNI_TRUE : JNI_FALSE);

jboolean visible_ = (static_cast<bool>(visible) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateFigurejbooleanbooleanjintintjintintjbooleanbooleanjbooleanbooleanID ,dockable_, menubarType, toolbarType, defaultAxes_, visible_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void Builder::cloneMenus (JavaVM * jvm_, int model, int newParent){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidcloneMenusjintintjintintID = curEnv->GetStaticMethodID(cls, "cloneMenus", "(II)V" ) ;
if (voidcloneMenusjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "cloneMenus");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloneMenusjintintjintintID ,model, newParent);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int Builder::cloneAxesModel (JavaVM * jvm_, int parent){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcloneAxesModeljintintID = curEnv->GetStaticMethodID(cls, "cloneAxesModel", "(I)I" ) ;
if (jintcloneAxesModeljintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "cloneAxesModel");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcloneAxesModeljintintID ,parent));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createSubWin (JavaVM * jvm_, int parent){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateSubWinjintintID = curEnv->GetStaticMethodID(cls, "createSubWin", "(I)I" ) ;
if (jintcreateSubWinjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createSubWin");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateSubWinjintintID ,parent));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createText (JavaVM * jvm_, int parent, char const* const* text, int textSize, int rows, int cols, double x, double y, bool autoSize, double const* userSize, int userSizeSize, int centerPos, int foreground, bool isForeground, int background, bool isBackground, bool boxed, bool line, bool filled, int align){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateTextjintintjobjectArray_java_lang_Stringjava_lang_StringjintintjintintjdoubledoublejdoubledoublejbooleanbooleanjdoubleArray_doubledoublejintintjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjintintID = curEnv->GetStaticMethodID(cls, "createText", "(I[Ljava/lang/String;IIDDZ[DIIZIZZZZI)I" ) ;
if (jintcreateTextjintintjobjectArray_java_lang_Stringjava_lang_StringjintintjintintjdoubledoublejdoubledoublejbooleanbooleanjdoubleArray_doubledoublejintintjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createText");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
jboolean autoSize_ = (static_cast<bool>(autoSize) ? JNI_TRUE : JNI_FALSE);

jdoubleArray userSize_ = curEnv->NewDoubleArray( userSizeSize ) ;

if (userSize_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( userSize_, 0, userSizeSize, (jdouble*)(userSize) ) ;


jboolean isForeground_ = (static_cast<bool>(isForeground) ? JNI_TRUE : JNI_FALSE);

jboolean isBackground_ = (static_cast<bool>(isBackground) ? JNI_TRUE : JNI_FALSE);

jboolean boxed_ = (static_cast<bool>(boxed) ? JNI_TRUE : JNI_FALSE);

jboolean line_ = (static_cast<bool>(line) ? JNI_TRUE : JNI_FALSE);

jboolean filled_ = (static_cast<bool>(filled) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateTextjintintjobjectArray_java_lang_Stringjava_lang_StringjintintjintintjdoubledoublejdoubledoublejbooleanbooleanjdoubleArray_doubledoublejintintjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjintintID ,parent, text_, rows, cols, x, y, autoSize_, userSize_, centerPos, foreground, isForeground_, background, isBackground_, boxed_, line_, filled_, align));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(userSize_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createArc (JavaVM * jvm_, int parent, double x, double y, double h, double w, double start, double end, int foreground, bool isForeground, int background, bool isBackground, bool filled, bool line){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateArcjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createArc", "(IDDDDDDIZIZZZ)I" ) ;
if (jintcreateArcjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createArc");
}

jboolean isForeground_ = (static_cast<bool>(isForeground) ? JNI_TRUE : JNI_FALSE);

jboolean isBackground_ = (static_cast<bool>(isBackground) ? JNI_TRUE : JNI_FALSE);

jboolean filled_ = (static_cast<bool>(filled) ? JNI_TRUE : JNI_FALSE);

jboolean line_ = (static_cast<bool>(line) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateArcjintintjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanID ,parent, x, y, h, w, start, end, foreground, isForeground_, background, isBackground_, filled_, line_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createAxis (JavaVM * jvm_, int parent, int dir, int tics, double const* vx, int vxSize, double const* vy, int vySize, int subint, char const* format, int fontSize, int textColor, int ticsColor, bool seg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateAxisjintintjintintjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejintintjstringjava_lang_StringjintintjintintjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createAxis", "(III[D[DILjava/lang/String;IIIZ)I" ) ;
if (jintcreateAxisjintintjintintjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejintintjstringjava_lang_StringjintintjintintjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createAxis");
}

jdoubleArray vx_ = curEnv->NewDoubleArray( vxSize ) ;

if (vx_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vx_, 0, vxSize, (jdouble*)(vx) ) ;


jdoubleArray vy_ = curEnv->NewDoubleArray( vySize ) ;

if (vy_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vy_, 0, vySize, (jdouble*)(vy) ) ;


jstring format_ = curEnv->NewStringUTF( format );
if (format != NULL && format_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean seg_ = (static_cast<bool>(seg) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateAxisjintintjintintjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejintintjstringjava_lang_StringjintintjintintjintintjbooleanbooleanID ,parent, dir, tics, vx_, vy_, subint, format_, fontSize, textColor, ticsColor, seg_));
                        curEnv->DeleteLocalRef(vx_);
curEnv->DeleteLocalRef(vy_);
curEnv->DeleteLocalRef(format_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createCompound (JavaVM * jvm_, int parent, int const* children, int childrenSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateCompoundjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "createCompound", "(I[I)I" ) ;
if (jintcreateCompoundjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createCompound");
}

jintArray children_ = curEnv->NewIntArray( childrenSize ) ;

if (children_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( children_, 0, childrenSize, (jint*)(children) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateCompoundjintintjintArray_intintID ,parent, children_));
                        curEnv->DeleteLocalRef(children_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createCompoundSeq (JavaVM * jvm_, int parent, int childrenCount){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateCompoundSeqjintintjintintID = curEnv->GetStaticMethodID(cls, "createCompoundSeq", "(II)I" ) ;
if (jintcreateCompoundSeqjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createCompoundSeq");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateCompoundSeqjintintjintintID ,parent, childrenCount));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createFec (JavaVM * jvm_, int parent, double const* zminmax, int zminmaxSize, int const* colminmax, int colminmaxSize, int const* colout, int coloutSize, bool with_mesh){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateFecjintintjdoubleArray_doubledoublejintArray_intintjintArray_intintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createFec", "(I[D[I[IZ)I" ) ;
if (jintcreateFecjintintjdoubleArray_doubledoublejintArray_intintjintArray_intintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createFec");
}

jdoubleArray zminmax_ = curEnv->NewDoubleArray( zminmaxSize ) ;

if (zminmax_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( zminmax_, 0, zminmaxSize, (jdouble*)(zminmax) ) ;


jintArray colminmax_ = curEnv->NewIntArray( colminmaxSize ) ;

if (colminmax_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( colminmax_, 0, colminmaxSize, (jint*)(colminmax) ) ;


jintArray colout_ = curEnv->NewIntArray( coloutSize ) ;

if (colout_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( colout_, 0, coloutSize, (jint*)(colout) ) ;


jboolean with_mesh_ = (static_cast<bool>(with_mesh) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateFecjintintjdoubleArray_doubledoublejintArray_intintjintArray_intintjbooleanbooleanID ,parent, zminmax_, colminmax_, colout_, with_mesh_));
                        curEnv->DeleteLocalRef(zminmax_);
curEnv->DeleteLocalRef(colminmax_);
curEnv->DeleteLocalRef(colout_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createGrayplot (JavaVM * jvm_, int parent, int type, double const* pvecx, int pvecxSize, int n1, int n2){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateGrayplotjintintjintintjdoubleArray_doubledoublejintintjintintID = curEnv->GetStaticMethodID(cls, "createGrayplot", "(II[DII)I" ) ;
if (jintcreateGrayplotjintintjintintjdoubleArray_doubledoublejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createGrayplot");
}

jdoubleArray pvecx_ = curEnv->NewDoubleArray( pvecxSize ) ;

if (pvecx_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( pvecx_, 0, pvecxSize, (jdouble*)(pvecx) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateGrayplotjintintjintintjdoubleArray_doubledoublejintintjintintID ,parent, type, pvecx_, n1, n2));
                        curEnv->DeleteLocalRef(pvecx_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createPolyline (JavaVM * jvm_, int parent, bool closed, int plot, int foreground, bool isForeground, int const* background, int backgroundSize, int mark_style, bool isMarkStyle, int mark_foreground, bool isMarkForeground, int mark_background, bool isMarkBackground, bool isline, bool isfilled, bool ismark, bool isinterp){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreatePolylinejintintjbooleanbooleanjintintjintintjbooleanbooleanjintArray_intintjintintjbooleanbooleanjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createPolyline", "(IZIIZ[IIZIZIZZZZZ)I" ) ;
if (jintcreatePolylinejintintjbooleanbooleanjintintjintintjbooleanbooleanjintArray_intintjintintjbooleanbooleanjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createPolyline");
}

jboolean closed_ = (static_cast<bool>(closed) ? JNI_TRUE : JNI_FALSE);

jboolean isForeground_ = (static_cast<bool>(isForeground) ? JNI_TRUE : JNI_FALSE);

jintArray background_ = curEnv->NewIntArray( backgroundSize ) ;

if (background_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( background_, 0, backgroundSize, (jint*)(background) ) ;


jboolean isMarkStyle_ = (static_cast<bool>(isMarkStyle) ? JNI_TRUE : JNI_FALSE);

jboolean isMarkForeground_ = (static_cast<bool>(isMarkForeground) ? JNI_TRUE : JNI_FALSE);

jboolean isMarkBackground_ = (static_cast<bool>(isMarkBackground) ? JNI_TRUE : JNI_FALSE);

jboolean isline_ = (static_cast<bool>(isline) ? JNI_TRUE : JNI_FALSE);

jboolean isfilled_ = (static_cast<bool>(isfilled) ? JNI_TRUE : JNI_FALSE);

jboolean ismark_ = (static_cast<bool>(ismark) ? JNI_TRUE : JNI_FALSE);

jboolean isinterp_ = (static_cast<bool>(isinterp) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreatePolylinejintintjbooleanbooleanjintintjintintjbooleanbooleanjintArray_intintjintintjbooleanbooleanjintintjbooleanbooleanjintintjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanjbooleanbooleanID ,parent, closed_, plot, foreground, isForeground_, background_, mark_style, isMarkStyle_, mark_foreground, isMarkForeground_, mark_background, isMarkBackground_, isline_, isfilled_, ismark_, isinterp_));
                        curEnv->DeleteLocalRef(background_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createLegend (JavaVM * jvm_, int parent, char const* const* text, int textSize, int const* handles, int handlesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateLegendjintintjobjectArray_java_lang_Stringjava_lang_StringjintArray_intintID = curEnv->GetStaticMethodID(cls, "createLegend", "(I[Ljava/lang/String;[I)I" ) ;
if (jintcreateLegendjintintjobjectArray_java_lang_Stringjava_lang_StringjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createLegend");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
jintArray handles_ = curEnv->NewIntArray( handlesSize ) ;

if (handles_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( handles_, 0, handlesSize, (jint*)(handles) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateLegendjintintjobjectArray_java_lang_Stringjava_lang_StringjintArray_intintID ,parent, text_, handles_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(handles_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createSegs (JavaVM * jvm_, int parent, double const* vx, int vxSize, double const* vy, int vySize, double const* vz, int vzSize, bool isVZ, int const* style, int styleSize, double arsize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateSegsjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejbooleanbooleanjintArray_intintjdoubledoubleID = curEnv->GetStaticMethodID(cls, "createSegs", "(I[D[D[DZ[ID)I" ) ;
if (jintcreateSegsjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejbooleanbooleanjintArray_intintjdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createSegs");
}

jdoubleArray vx_ = curEnv->NewDoubleArray( vxSize ) ;

if (vx_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vx_, 0, vxSize, (jdouble*)(vx) ) ;


jdoubleArray vy_ = curEnv->NewDoubleArray( vySize ) ;

if (vy_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vy_, 0, vySize, (jdouble*)(vy) ) ;


jdoubleArray vz_ = curEnv->NewDoubleArray( vzSize ) ;

if (vz_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vz_, 0, vzSize, (jdouble*)(vz) ) ;


jboolean isVZ_ = (static_cast<bool>(isVZ) ? JNI_TRUE : JNI_FALSE);

jintArray style_ = curEnv->NewIntArray( styleSize ) ;

if (style_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( style_, 0, styleSize, (jint*)(style) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateSegsjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejbooleanbooleanjintArray_intintjdoubledoubleID ,parent, vx_, vy_, vz_, isVZ_, style_, arsize));
                        curEnv->DeleteLocalRef(vx_);
curEnv->DeleteLocalRef(vy_);
curEnv->DeleteLocalRef(vz_);
curEnv->DeleteLocalRef(style_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createChamp (JavaVM * jvm_, int parent, double const* vx, int vxSize, double const* vy, int vySize, double const* vfx, int vfxSize, double const* vfy, int vfySize, double arsize, bool typeofchamp){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateChampjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejbooleanbooleanID = curEnv->GetStaticMethodID(cls, "createChamp", "(I[D[D[D[DDZ)I" ) ;
if (jintcreateChampjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createChamp");
}

jdoubleArray vx_ = curEnv->NewDoubleArray( vxSize ) ;

if (vx_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vx_, 0, vxSize, (jdouble*)(vx) ) ;


jdoubleArray vy_ = curEnv->NewDoubleArray( vySize ) ;

if (vy_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vy_, 0, vySize, (jdouble*)(vy) ) ;


jdoubleArray vfx_ = curEnv->NewDoubleArray( vfxSize ) ;

if (vfx_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vfx_, 0, vfxSize, (jdouble*)(vfx) ) ;


jdoubleArray vfy_ = curEnv->NewDoubleArray( vfySize ) ;

if (vfy_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( vfy_, 0, vfySize, (jdouble*)(vfy) ) ;


jboolean typeofchamp_ = (static_cast<bool>(typeofchamp) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateChampjintintjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejbooleanbooleanID ,parent, vx_, vy_, vfx_, vfy_, arsize, typeofchamp_));
                        curEnv->DeleteLocalRef(vx_);
curEnv->DeleteLocalRef(vy_);
curEnv->DeleteLocalRef(vfx_);
curEnv->DeleteLocalRef(vfy_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Builder::createSurface (JavaVM * jvm_, int parent, int typeof3d, int colorFlag, int colorMode){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateSurfacejintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "createSurface", "(IIII)I" ) ;
if (jintcreateSurfacejintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createSurface");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateSurfacejintintjintintjintintjintintID ,parent, typeof3d, colorFlag, colorMode));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void Builder::initSubWinTo3d (JavaVM * jvm_, int parent, char const* legend, bool isLegend, int const* flag, int flagSize, double alpha, double theta, double const* ebox, int eboxSize, double const* x, int xSize, double const* y, int ySize, double const* z, int zSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidinitSubWinTo3djintintjstringjava_lang_StringjbooleanbooleanjintArray_intintjdoubledoublejdoubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "initSubWinTo3d", "(ILjava/lang/String;Z[IDD[D[D[D[D)V" ) ;
if (voidinitSubWinTo3djintintjstringjava_lang_StringjbooleanbooleanjintArray_intintjdoubledoublejdoubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initSubWinTo3d");
}

jstring legend_ = curEnv->NewStringUTF( legend );
if (legend != NULL && legend_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean isLegend_ = (static_cast<bool>(isLegend) ? JNI_TRUE : JNI_FALSE);

jintArray flag_ = curEnv->NewIntArray( flagSize ) ;

if (flag_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( flag_, 0, flagSize, (jint*)(flag) ) ;


jdoubleArray ebox_ = curEnv->NewDoubleArray( eboxSize ) ;

if (ebox_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( ebox_, 0, eboxSize, (jdouble*)(ebox) ) ;


jdoubleArray x_ = curEnv->NewDoubleArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( x_, 0, xSize, (jdouble*)(x) ) ;


jdoubleArray y_ = curEnv->NewDoubleArray( ySize ) ;

if (y_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( y_, 0, ySize, (jdouble*)(y) ) ;


jdoubleArray z_ = curEnv->NewDoubleArray( zSize ) ;

if (z_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( z_, 0, zSize, (jdouble*)(z) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidinitSubWinTo3djintintjstringjava_lang_StringjbooleanbooleanjintArray_intintjdoubledoublejdoubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID ,parent, legend_, isLegend_, flag_, alpha, theta, ebox_, x_, y_, z_);
                        curEnv->DeleteLocalRef(legend_);
curEnv->DeleteLocalRef(flag_);
curEnv->DeleteLocalRef(ebox_);
curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(y_);
curEnv->DeleteLocalRef(z_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int Builder::createLight (JavaVM * jvm_, int parent, int type, bool visible, double const* pos, int posSize, double const* dir, int dirSize, double const* ambient, int ambientSize, double const* diffuse, int diffuseSize, double const* specular, int specularSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintcreateLightjintintjintintjbooleanbooleanjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "createLight", "(IIZ[D[D[D[D[D)I" ) ;
if (jintcreateLightjintintjintintjbooleanbooleanjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "createLight");
}

jboolean visible_ = (static_cast<bool>(visible) ? JNI_TRUE : JNI_FALSE);

jdoubleArray pos_ = curEnv->NewDoubleArray( posSize ) ;

if (pos_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( pos_, 0, posSize, (jdouble*)(pos) ) ;


jdoubleArray dir_ = curEnv->NewDoubleArray( dirSize ) ;

if (dir_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dir_, 0, dirSize, (jdouble*)(dir) ) ;


jdoubleArray ambient_ = curEnv->NewDoubleArray( ambientSize ) ;

if (ambient_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( ambient_, 0, ambientSize, (jdouble*)(ambient) ) ;


jdoubleArray diffuse_ = curEnv->NewDoubleArray( diffuseSize ) ;

if (diffuse_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( diffuse_, 0, diffuseSize, (jdouble*)(diffuse) ) ;


jdoubleArray specular_ = curEnv->NewDoubleArray( specularSize ) ;

if (specular_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( specular_, 0, specularSize, (jdouble*)(specular) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintcreateLightjintintjintintjbooleanbooleanjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoubleID ,parent, type, visible_, pos_, dir_, ambient_, diffuse_, specular_));
                        curEnv->DeleteLocalRef(pos_);
curEnv->DeleteLocalRef(dir_);
curEnv->DeleteLocalRef(ambient_);
curEnv->DeleteLocalRef(diffuse_);
curEnv->DeleteLocalRef(specular_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
