// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises - Antoine ELIAS
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
// <-- CLI SHELL MODE -->
//
// <-- Non-regression test for bug 14055 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/14055
//
// <-- Short Description -->
// overload on matrix concatenation failed with []

function L = %l_c_s(L,N)
    L = lstcat(L, N)
    assert_checkequal(N, check);
endfunction

//same function for line and column concatenation
%l_f_s = %l_c_s;

L = list("abc");

check = %pi;
l = [L check];
assert_checkequal(l($), check);
l = [L;check];
assert_checkequal(l($), check);

check = [];
l = [L check];
assert_checkequal(l($), check);
l = [L;check];
assert_checkequal(l($), check);
