#!/bin/bash
# bbou@ac-toulouse.fr
# 2009-06-30 09:41:09 
# conf/config-pam_mountconf.sh

### P A R A M S
MYSERVER="$1"
MYSHARE="$2"
MYMOUNTPOINT="$3"
MYDOMAIN="$4"
MYUSER="$5"
#echo "//${MYSERVER}/${MYSHARE}->${MYMOUNTPOINT}"

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
pammountconf=pam_mount.conf

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### O T H E R
MOUNTPOINT_MOD=774

### S T A R T

# E S C A P E
escapeampersand() {
#echo "$1" | sed -e 's/&/@@&/g' | tr '@' '\\'
echo "$1" | sed -e 's/&/\\\\\&/g'
}
escapequote() {
echo "$@" | sed -e 's/"/\\\"/g'
}

echo "+install pam_mount configuration"
echo "configure pam_mount.conf to connect //${MYSERVER}/${MYSHARE} on ${MYMOUNTPOINT} as ${MYDOMAIN}/${MYUSER}"

# C O N F   A S   P E R   V E R S I O N   O F   P A M _ M O U N T
pammountversion=`${PACKAGEVERSION} ${PAMMOUNTPACKAGE} | awk 'BEGIN {FS="-"}{print $1}'` 
echo "pam_mount version=${pammountversion}"
pammountmainversion=`echo ${pammountversion} | awk 'BEGIN{FS="."}{print $1}'`
pammountsubversion=`echo ${pammountversion} | awk 'BEGIN{FS="."}{print $2}'`
echo "pam_mount main version=${pammountmainversion}"
echo "pam_mount sub version=${pammountsubversion}"
if [ "${pammountmainversion}" == 0 -a "${pammountsubversion}" -ge 19 -o "${pammountmainversion}" -gt 0 ];then
	pammountconf=${pammountconf}.xml
	pammountconfmain=_${pammountconf}
	echo "config file is xml ${pammountconf}"
else 
	if echo "${MYSHARE}" | grep '%(USER)' > /dev/null ; then
		MYSHARE=`echo "${MYSHARE}" | sed 's/%(USER)/\&/g'`
		MYSHARE=`escapeampersand "${MYSHARE}"`
	fi
	if echo "${MYUSER}" | grep '%(USER)' > /dev/null ; then
		MYUSER=`echo "${MYUSER}" | sed 's/%(USER)/\\*/g'`
	fi
	if [ "${pammountsubversion}" -ge 10 ];then
		pammountconfmain=_${pammountconf}.2
		echo "config file is new style ${pammountconf}"
	else
		pammountconfmain=_${pammountconf}.1
		echo "config file is old style ${pammountconf}"
	fi
fi

# C U S T O M I Z E   P A M _ M O U N T . C O N F
echo "customize ${SECDIR}/${pammountconf}"
awkp='{gsub("%USER%","'${MYUSER}'");
	gsub("%SERVER%","'${MYSERVER}'");
	gsub("%SHARE%","'${MYSHARE}'");
	gsub("%MOUNTPOINT%","'${MYMOUNTPOINT}'");
	gsub("%DOMAIN%","'${MYDOMAIN}'");
	print}'
MYVOLUMES=`awk "${awkp}" _${pammountconf}.volume`
MYVOLUMES=`escapequote "$MYVOLUMES"`
MYVOLUMES=`escapeampersand "$MYVOLUMES"`
awkp='{gsub("%VOLUMES%","'${MYVOLUMES}'");
	print}'
awk "${awkp}" ${pammountconfmain} > ${TMPDIR}/${pammountconf}
#cat ${TMPDIR}/${pammountconf} | grep -v "^#" | grep -v "^$"

# I N S T A L L   P A M _ M O U N T . C O N F
echo "install ${pammountconf} to ${SECDIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${pammountconf} ${SECDIR} > /dev/null
rm -f ${TMPDIR}/${pammountconf}

# M A K E   M O U N T P O I N T
echo "+mount point ${MYMOUNTPOINT}"
subhome=${MYMOUNTPOINT#\~/}
if [ "${MYMOUNTPOINT}" != "${subhome}" ]; then
	echo "home ${subhome} within user's home"
	# add mount point to /etc/skel
	if [ -d ${SKELDIR}/${subhome} ]; then
		echo "${SKELDIR}/${subhome} exists as: `ls -dl ${SKELDIR}/${subhome}`"
	else
		echo "create mount point in ${SKELDIR}/${subhome}"
		mkdir -m ${MOUNTPOINT_MOD} ${SKELDIR}/${subhome}
	fi
else
	echo "home ${subhome} outside user's home"
	if [ -d ${MYMOUNTPOINT} ]; then
		echo "${MYMOUNTPOINT} exists as: `ls -dl ${MYMOUNTPOINT}`"
	else
		echo "create mount point ${MYMOUNTPOINT}"
		mkdir -m ${MOUNTPOINT_MOD} ${MYMOUNTPOINT}
	fi
fi
