// Copyright (C) 2009 by Thomas Moulard, AIST, CNRS, INRIA.
//
// This file is part of the roboptim.
//
// roboptim is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// roboptim is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with roboptim.  If not, see <http://www.gnu.org/licenses/>.

#include "roboptim/core/config.hh"
#include "config.h"

#include <iostream>

#include <roboptim/core/visualization/gnuplot.hh>
#include <roboptim/core/visualization/gnuplot-commands.hh>
#include <roboptim/core/indent.hh>

namespace roboptim
{
  namespace visualization
  {
    Gnuplot::Gnuplot () throw ()
    {
      using namespace gnuplot;
      push_command (comment ("!/usr/bin/gnuplot"));
      push_command (comment (" Generated by " PACKAGE_NAME));
    }

    Gnuplot::~Gnuplot () throw ()
    {
    }

    void
    Gnuplot::push_command (gnuplot::Command cmd) throw ()
    {
      commands_.push_back (cmd);
    }

    std::ostream&
    Gnuplot::print (std::ostream& o) const throw ()
    {
      typedef std::vector<gnuplot::Command>::const_iterator citer_t;

      for (citer_t it = commands_.begin (); it != commands_.end (); ++it)
	o << it->command () << std::endl;
      return o;
    }

    Gnuplot&
    Gnuplot::operator << (gnuplot::Command cmd) throw ()
    {
      push_command (cmd);
      return *this;
    }

    std::ostream&
    operator<< (std::ostream& o, const Gnuplot& gp)
    {
      return gp.print (o);
    }
  } // end of namespace visualization.
} // end of namespace roboptim.
