//service-about.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2013-2019
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

static int __show(const struct roar_dl_libraryname * libname) {
 struct roar_vio_calls * vio = roar_stdout;

 roar_vio_printf(vio, "---[ About %s ]---\n", libname->name);
#define _var(x,y) \
 if ( libname->x != NULL ) \
  roar_vio_printf(vio, " %-16s: %s\n", y, libname->x);
 _var(libname, "Full Name");
 _var(libversion, "Full Version");
 _var(abiversion, "ABI Version");
 _var(description, "Description");
 _var(contact, "Contact");
 _var(authors, "Other Authors");
 _var(license, "License");
 roar_vio_printf(vio, "---[ End of About ]---\n");
 return 0;
}

static struct roar_service_about api = {.show = __show};

ROAR_DL_PLUGIN_REG_SERVICES_GET_API(get_api, api)

static const struct roar_dl_service service[1] = {
 {
  .appname = NULL,
  .appabi = NULL,
  .servicename = ROAR_SERVICE_ABOUT_NAME,
  .serviceabi = ROAR_SERVICE_ABOUT_ABI,
  .description = "About dialog display API",
  .flags = ROAR_DL_SERVICE_FLAGS_NONE,
  .userdata = NULL,
  .get_api = get_api
 }
};

ROAR_DL_PLUGIN_REG_SERVICES(service);

ROAR_DL_PLUGIN_START(service_about) {
 ROAR_DL_PLUGIN_META_PRODUCT_NIV("service-about", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("This plugin provides a simple interface to about dialog display functions.");
 ROAR_DL_PLUGIN_REG_FNFUNC(ROAR_DL_FN_SERVICE);
} ROAR_DL_PLUGIN_END

//ll
