/* risdb.h header file for risdb.c */
/* markus@mhoenicka.de 3-26-00 */
/* $Id: risdb.h,v 1.11.2.4 2005/11/02 22:37:52 mhoenicka Exp $ */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include "authorinfo.h"

/* this structure holds pointers to the synonyms of a particular journal */
struct PERIODICAL_INFO {
  char* full;
  char* abbrev;
  char* custabbrev1;
  char* custabbrev2;
};

int process_ris_set(char* set, dbi_conn conn, dbi_conn conn_refdb, int replace_ref, char* set_owner, struct CLIENT_REQUEST* ptr_clrequest, int n_keep_id, Lilid* ptr_sentinel, unsigned long long set_count, char** msg_pool, size_t* msg_pool_len);
char* preprocess_citekey_copy (const char* string, size_t n_maxlen);
const char* get_unique_citekey(dbi_conn conn, const char* first_author, int year, int type, int replace_ref);
int remove_keyword_entries(unsigned long long ref_id, dbi_conn conn, int mode);
int remove_author_entries(unsigned long long ref_id, dbi_conn conn);
int remove_xnote_entries(unsigned long long note_id, unsigned long long xref_id, dbi_conn conn, int mode);
int remove_periodical_entries(unsigned long long periodical_id, dbi_conn conn);
int remove_user_entries(unsigned long long user_id, dbi_conn conn);
int remove_xuser_entries(unsigned long long ref_id, char* set_owner, dbi_conn conn);
int remove_ulink_entries(unsigned long long ref_id, const char* set_owner, dbi_conn conn, int mode);
/* int update_refdb_field(const char* fieldname, unsigned long long id, const char* fieldvalue, dbi_driver dbidrv, dbi_conn conn); */
int insert_user(const char* set_owner, unsigned long long n_refdb_id, unsigned long long* ptr_n_user_id, dbi_conn conn, const char* drivername, int replace_ref, int mode);
int update_reprint(int rp_type, unsigned long long n_refdb_id, unsigned long long n_user_id, dbi_conn conn, const char* date_buffer, int replace_ref);
int update_notes(const char* notes, unsigned long long n_refdb_id, unsigned long long n_user_id, dbi_conn conn, dbi_driver driver, int replace_ref);
int update_avail(const char* avail, unsigned long long n_refdb_id, unsigned long long n_user_id, dbi_conn conn, dbi_driver driver, int replace_ref);
int insert_author(struct AUTHOR_INFO* ptr_ainfo, int author_type, int xauthor_pos, unsigned long long n_refdb_id, dbi_conn conn, dbi_driver driver, const char* drivername, int replace_ref);
int update_dateinfo(int date_type, int year, const char* otherinfo, unsigned long long n_refdb_id, dbi_conn conn, dbi_driver driver);
int insert_keyword(const char* keyword, unsigned long long n_refdb_id, dbi_conn conn, dbi_driver driver, const char* drivername, int mode, int replace_ref);
int insert_ulink(const char* ulink, int type, unsigned long long n_xref_id, dbi_conn conn, dbi_driver driver, const char* drivername, unsigned long long n_user_id, int mode, int replace_ref);
int insert_periodical(struct PERIODICAL_INFO* ptr_perinfo, unsigned long long n_refdb_id, int replace_ref, int nis_dummy, dbi_conn conn, const char* drivername);
char* assemble_full_author(struct AUTHOR_INFO* ptr_ainfo, int* ptr_error);


