% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom.R
\name{vroom}
\alias{vroom}
\title{Read a delimited file into a tibble}
\usage{
vroom(
  file,
  delim = NULL,
  col_names = TRUE,
  col_types = NULL,
  col_select = NULL,
  id = NULL,
  skip = 0,
  n_max = Inf,
  na = c("", "NA"),
  quote = "\\"",
  comment = "",
  skip_empty_rows = TRUE,
  trim_ws = TRUE,
  escape_double = TRUE,
  escape_backslash = FALSE,
  locale = default_locale(),
  guess_max = 100,
  altrep = TRUE,
  altrep_opts = deprecated(),
  num_threads = vroom_threads(),
  progress = vroom_progress(),
  show_col_types = NULL,
  .name_repair = "unique"
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector). \code{file} can also be a character vector
containing multiple filepaths or a list containing multiple connections.

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will be automatically
uncompressed. Files starting with \verb{http://}, \verb{https://}, \verb{ftp://}, or
\verb{ftps://} will be automatically downloaded. Remote gz files can also be
automatically downloaded and decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, wrap the input with \code{I()}.}

\item{delim}{One or more characters used to delimit fields within a
file. If \code{NULL} the delimiter is guessed from the set of \code{c(",", "\\t", " ", "|", ":", ";")}.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{...1}, \code{...2} etc. Duplicate column names
will generate a warning and be made unique, see \code{name_repair} to control
how this is done.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string.

If \code{NULL}, all column types will be imputed from \code{guess_max} rows
on the input interspersed throughout the file. This is convenient (and
fast), but not robust. If the imputation fails, you'll need to increase
the \code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[=cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set \code{options(readr.show_col_types = FALSE)}.
}}

\item{col_select}{Columns to include in the results. You can use the same
mini-language as \code{dplyr::select()} to refer to the columns by name. Use
\code{c()} to use more than one selection expression. Although this
usage is less common, \code{col_select} also accepts a numeric column index. See
\code{\link[tidyselect:language]{?tidyselect::language}} for full details on the
selection language.}

\item{id}{Either a string or 'NULL'. If a string, the output will contain a
variable with that name with the filename(s) as the value. If 'NULL', the
default, no variable will be created.}

\item{skip}{Number of lines to skip before reading data. If \code{comment} is
supplied any commented lines are ignored \emph{after} skipping.}

\item{n_max}{Maximum number of lines to read.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quote}{Single character used to quote strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value '""' represents
a single quote, '"'.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \verb{\\\\n}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{guess_max}{Maximum number of lines to use for guessing column types.
See \code{vignette("column-types", package = "readr")} for more details.}

\item{altrep}{Control which column types use Altrep representations,
either a character vector of types, \code{TRUE} or \code{FALSE}. See
\code{\link[=vroom_altrep]{vroom_altrep()}} for for full details.}

\item{altrep_opts}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}

\item{num_threads}{Number of threads to use when reading and materializing
vectors. If your data contains newlines within fields the parser will
automatically be forced to use a single thread only.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The automatic
progress bar can be disabled by setting option \code{readr.show_progress} to
\code{FALSE}.}

\item{show_col_types}{Control showing the column specifications. If \code{TRUE}
column specifications are always show, if \code{FALSE} they are never shown. If
\code{NULL} (the default) they are shown only if an explicit specification is not
given to \code{col_types}.}

\item{.name_repair}{Handling of column names. The default behaviour is to
ensure column names are \code{"unique"}. Various repair strategies are
supported:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence of names.
\item \code{"unique"} (default value): Make sure names are unique and not empty.
\item \code{"check_unique"}: no name repair, but check they are \code{unique}.
\item \code{"universal"}: Make the names \code{unique} and syntactic.
\item A function: apply custom name repair (e.g., \code{name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}.
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}
}
\description{
Read a delimited file into a tibble
}
\examples{
# get path to example file
input_file <- vroom_example("mtcars.csv")
input_file

# Read from a path

# Input sources -------------------------------------------------------------
# Read from a path
vroom(input_file)
# You can also use paths directly
# vroom("mtcars.csv")

\dontrun{
# Including remote paths
vroom("https://github.com/tidyverse/vroom/raw/main/inst/extdata/mtcars.csv")
}

# Or directly from a string with `I()`
vroom(I("x,y\n1,2\n3,4\n"))

# Column selection ----------------------------------------------------------
# Pass column names or indexes directly to select them
vroom(input_file, col_select = c(model, cyl, gear))
vroom(input_file, col_select = c(1, 3, 11))

# Or use the selection helpers
vroom(input_file, col_select = starts_with("d"))

# You can also rename specific columns
vroom(input_file, col_select = c(car = model, everything()))

# Column types --------------------------------------------------------------
# By default, vroom guesses the columns types, looking at 1000 rows
# throughout the dataset.
# You can specify them explicitly with a compact specification:
vroom(I("x,y\n1,2\n3,4\n"), col_types = "dc")

# Or with a list of column types:
vroom(I("x,y\n1,2\n3,4\n"), col_types = list(col_double(), col_character()))

# File types ----------------------------------------------------------------
# csv
vroom(I("a,b\n1.0,2.0\n"), delim = ",")
# tsv
vroom(I("a\tb\n1.0\t2.0\n"))
# Other delimiters
vroom(I("a|b\n1.0|2.0\n"), delim = "|")

# Read datasets across multiple files ---------------------------------------
mtcars_by_cyl <- vroom_example(vroom_examples("mtcars-"))
mtcars_by_cyl

# Pass the filenames directly to vroom, they are efficiently combined
vroom(mtcars_by_cyl)

# If you need to extract data from the filenames, use `id` to request a
# column that reveals the underlying file path
dat <- vroom(mtcars_by_cyl, id = "source")
dat$source <- basename(dat$source)
dat
}
