% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document-api.R
\name{rstudio-documents}
\alias{rstudio-documents}
\alias{rstudio-documents}
\alias{insertText}
\alias{rstudio-documents}
\alias{modifyRange}
\alias{rstudio-documents}
\alias{setDocumentContents}
\alias{rstudio-documents}
\alias{setCursorPosition}
\alias{rstudio-documents}
\alias{setSelectionRanges}
\alias{rstudio-documents}
\alias{documentSave}
\alias{rstudio-documents}
\alias{documentSaveAll}
\title{Interact with Documents open in RStudio}
\usage{
insertText(location, text, id = NULL)

modifyRange(location, text, id = NULL)

setDocumentContents(text, id = NULL)

setCursorPosition(position, id = NULL)

setSelectionRanges(ranges, id = NULL)

documentSave(id = NULL)

documentSaveAll()
}
\arguments{
\item{location}{An object specifying the positions, or ranges, wherein
text should be inserted. See \bold{Details} for more information.}

\item{text}{A character vector, indicating what text should be
inserted at each aforementioned range. This should either
be length one (in which case, this text is applied to each
range specified); otherwise, it should be the same length
as the \code{ranges} list.}

\item{id}{The document id. When \code{NULL} or blank,
the mutation will apply to the currently open, or last
focused, RStudio document. Use the \code{id} returned
from \code{\link{getActiveDocumentContext}()} to ensure
that the operation is applied on the intended document.}

\item{position}{The cursor position, typically created through
\code{\link{document_position}()}.}

\item{ranges}{A list of one or more ranges, typically created
through \code{\link{document_range}()}.}
}
\description{
Use these functions to interact with documents open in RStudio.
}
\details{
\code{location} should be a (list of) \code{\link{document_position}} or
\code{\link{document_range}} object(s), or numeric vectors coercable to
such objects.

To operate on the current selection in a document, call \code{insertText()}
with only a text argument, e.g.

\preformatted{
    insertText("# Hello\\n")
    insertText(text = "# Hello\\n")
}

Otherwise, specify a (list of) positions or ranges, as in:

\preformatted{
    # insert text at the start of the document
    insertText(c(1, 1), "# Hello\\n")

    # insert text at the end of the document
    insertText(Inf, "# Hello\\n")

    # comment out the first 5 rows
    pos <- Map(c, 1:5, 1)
    insertText(pos, "# ")

    # uncomment the first 5 rows, undoing the previous action
    rng <- Map(c, Map(c, 1:5, 1), Map(c, 1:5, 3))
    modifyRange(rng, "")
}

\code{modifyRange} is a synonym for \code{insertText}, but makes its intent
clearer when working with ranges, as performing text insertion with a range
will replace the text previously existing in that range with new text. For
clarity, prefer using \code{insertText} when working with
\code{\link{document_position}}s, and \code{modifyRange} when working with
\code{\link{document_range}}s.
}
\note{
The \code{insertText}, \code{modifyRange} and \code{setDocumentContents}
functions were added with version 0.99.796 of RStudio.

The \code{setCursorPosition} and \code{setSelectionRanges} functions were
added with version 0.99.1111 of RStudio.

The \code{documentSave} and \code{documentSaveAll} functions were added
with version 1.1.287 of RStudio.
}
