% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{plotBS}
\alias{plotBS}
\title{Plotting trees with bootstrap values}
\usage{
plotBS(tree, BStrees, type = "phylogram", method = "FBP",
  bs.col = "black", bs.adj = NULL, digits = 3, p = 0, frame = "none",
  ...)
}
\arguments{
\item{tree}{The tree on which edges the bootstrap values are plotted.}

\item{BStrees}{a list of trees (object of class "multiPhylo").}

\item{type}{the type of tree to plot, one of "phylogram", "cladogram", "fan",
"unrooted", "radial" or "none". If type is "none" the tree is returned with
the bootstrap values assigned to the node labels.}

\item{method}{either "FBP" the classical bootstrap (default) or "TBE"
(transfer bootstrap)}

\item{bs.col}{color of bootstrap support labels.}

\item{bs.adj}{one or two numeric values specifying the horizontal and
vertical justification of the bootstrap labels.}

\item{digits}{integer indicating the number of decimal places.}

\item{p}{only plot support values higher than this percentage number
(default is 0).}

\item{frame}{a character string specifying the kind of frame to be printed
around the bootstrap values. This must be one of "none" (the default),
"rect" or "circle".}

\item{\dots}{further parameters used by \code{plot.phylo}.}
}
\value{
\code{plotBS} returns silently a tree, i.e. an object of class
\code{phylo} with the bootstrap values as node labels. The argument
\code{BStrees} is optional and if not supplied the labels supplied
in the \code{node.label} slot will be used.
}
\description{
\code{plotBS} plots a phylogenetic tree with the bootstrap values assigned
to the (internal) edges. It can also used to assign bootstrap values to a
phylogenetic tree.
}
\details{
\code{plotBS} can either assign the classical Felsenstein’s bootstrap
proportions (FBP) (Felsenstein (1985), Hendy & Penny (1985))  or the
transfer bootstrap expectation (TBE) of Lemoine et al. (2018). Using the
option \code{type=="n"} just assigns the bootstrap values and return the tree
without plotting it.
}
\examples{
fdir <- system.file("extdata/trees", package = "phangorn")
# RAxML best-known tree with bipartition support (from previous analysis)
raxml.tree <- read.tree(file.path(fdir,"RAxML_bipartitions.woodmouse"))
# RAxML bootstrap trees (from previous analysis)
raxml.bootstrap <- read.tree(file.path(fdir,"RAxML_bootstrap.woodmouse"))
par(mfrow=c(1,2))
plotBS(raxml.tree,  raxml.bootstrap, "p")
plotBS(raxml.tree,  raxml.bootstrap, "p", "TBE")
}
\references{
Felsenstein J. (1985) Confidence limits on phylogenies. An
approach using the bootstrap. \emph{Evolution} \bold{39}, 783--791

Lemoine, F., Entfellner, J. B. D., Wilkinson, E., Correia, D., Felipe, M. D.,
De Oliveira, T., & Gascuel, O. (2018). Renewing Felsenstein’s phylogenetic
bootstrap in the era of big data. \emph{Nature}, \bold{556(7702)}, 452--456.

Penny D. and Hendy M.D. (1985) Testing methods evolutionary tree
construction. \emph{Cladistics} \bold{1}, 266--278

Penny D. and Hendy M.D. (1986) Estimating the reliability of evolutionary
trees. \emph{Molecular Biology and Evolution} \bold{3}, 403--417
}
\seealso{
\code{\link{transferBootstrap}}, \code{\link{plot.phylo}},
\code{\link{maxCladeCred}}, \code{\link{nodelabels}},
\code{\link{consensus}}, \code{\link{consensusNet}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
