% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclic_encoding.r
\name{cyclic_encoding}
\alias{cyclic_encoding}
\title{Cyclic encoding of date-times}
\usage{
cyclic_encoding(
  x,
  periods,
  encoders = c("sin", "cos"),
  week_start = getOption("lubridate.week.start", 7)
)
}
\arguments{
\item{x}{a date-time object}

\item{periods}{a character vector of periods. Follows same specification as
\link{period} and \link{floor_date} functions.}

\item{encoders}{names of functions to produce the encoding. Defaults to
"sin" and "cos". Names of any predefined functions accepting a numeric
input are allowed.}

\item{week_start}{day starting a week (used for weekly periods).}
}
\value{
a numeric matrix with number of columns equal \code{length(periods) * length(types)}.
}
\description{
Encode a date-time object into a cyclic coordinate system in which the
distances between two pairs of dates separated by the same time duration are
the same.
}
\details{
Machine learning models don't know that December 31st and January 1st are
close in our human calendar sense. \code{cyclic_encoding} makes it obvious to the
machine learner that two calendar dates are close by mapping the dates onto
the circle.
}
\examples{

times <- ymd_hms("2019-01-01 00:00:00") + hours(0:23)
cyclic_encoding(times, c("day", "week", "month"))
plot(cyclic_encoding(times, "1d"))
plot(cyclic_encoding(times, "2d"), xlim = c(-1, 1))
plot(cyclic_encoding(times, "4d"), xlim = c(-1, 1))

}
