\name{openPage}

\alias{openPage}
\alias{closePage}

\title{HTML document/page management}

\description{
 Opens and closes an HTML page/document, allowing a sequential building
 of an HTML page.
}

\usage{
openPage(filename, dirname=NULL, title=filename, link.javascript=NULL, 
link.css=NULL, css=NULL, head=NULL, charset="utf-8", lang="en",
head.attributes=NULL, body.attributes=NULL)

closePage(page, splash=TRUE)
}

\arguments{
  \item{filename}{a character string containing the filename or the path
    of the HTML file to be created.}

  \item{dirname}{an optional character string containing the path of the
    directory where the file should be written.}

  \item{title}{an optional character string containing the title of the
    HTML page.}

  \item{link.javascript}{an optional character vector containing the URL of Javascripts
    to be associated with the page.}

  \item{link.css}{an optional character vector containing the URL of CSS stylesheets
    to be associated with the page.}

  \item{css}{an optional character vector containing inline CSS stylesheets to be associated with the page.}

  \item{head}{an optional character string containing an HTML fragment
    to be added in the <head> section of the page.}

  \item{charset}{an optional character string containing the current charset. Default is "utf-8".}

  \item{lang}{an optional character string containing the current
    langage. Default is "en".}

  \item{head.attributes}{an optional named list of character strings,
    containing the <head> attributes.}

  \item{body.attributes}{an optional named list of character strings,
    containing the <body> attributes.}
  
  \item{page}{a page handle returned by a previous \code{openPage}
    call.}

  \item{splash}{a logical, indicating whether the hwriter splash tag
  'generated by...' should be written at the end of the page.}

}

\value{
  A connection which is a handle to the current HTML page.
}

\details{
 \code{openPage} opens a new file for writing and returns a page handle
 which is used by \code{hwrite} to append HTML elements in a current
 page. Any previous existing file will be overwritten.

 The argument \code{head} is useful to add extra HTML code in the <head> header code.

 \code{closePage} ends the HTML page formatting, flushes the pending
writing operations and closes the file.
}

\seealso{
  \code{\link{hwrite}}, \code{\link{hmakeTag}}.
}

\examples{
## Creates a new web page 'test.html' in the R temporary directory
tmpdir <- tempdir()
p <- openPage('test.html', dirname=tmpdir, link.css='http://www.ebi.ac.uk/~gpau/hwriter/hwriter.css')
hwrite('Iris example', p, center=TRUE, heading=1)
hwrite('This famous (Fisher\'s or Anderson\'s) iris data set gives the measurements in centimeters of the variables sepal length and width and petal length and width, respectively, for 50 flowers from each of 3 species of iris.', p, class='king')
hwrite(iris, p, row.bgcolor='#ffffaa')
closePage(p)

## Opens a web browser on the web page
if (interactive()) try(browseURL(file.path(tmpdir, 'test.html')))
}

\author{
  Gregoire Pau, \email{gpau@ebi.ac.uk}, 2008
}

\keyword{interface}
