% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linda.R
\name{linda.plot}
\alias{linda.plot}
\title{Plot LinDA Results}
\usage{
linda.plot(
  linda.obj,
  variables.plot,
  titles = NULL,
  alpha = 0.05,
  lfc.cut = 1,
  legend = FALSE,
  directory = NULL,
  width = 11,
  height = 8
)
}
\arguments{
\item{linda.obj}{return from function \code{linda}.}

\item{variables.plot}{vector; variables whose results are to be plotted. For example, suppose the return
value \code{variables} is equal to \code{('x1', 'x2', 'x3b', 'x3c', 'x1:x2')}, then one could set \code{variables.plot = c('x3b', 'x1:x2')}.}

\item{titles}{vector; titles of the effect size plot and volcano plot for each variable in \code{variables.plot}.
Default is NULL. If NULL, the titles will be set as \code{variables.plot}.}

\item{alpha}{a numerical value between 0 and 1; cutoff for \code{padj}.}

\item{lfc.cut}{a positive numerical value; cutoff for \code{log2FoldChange}.}

\item{legend}{TRUE or FALSE; whether to show the legends of the effect size plot and volcano plot.}

\item{directory}{character; the directory to save the figures, e.g., \code{getwd()}. Default is NULL. If NULL, figures will not be saved.}

\item{width}{the width of the graphics region in inches. See R function \code{pdf}.}

\item{height}{the height of the graphics region in inches. See R function \code{pdf}.}
}
\value{
A list of \code{ggplot2} objects.
\item{plot.lfc}{a list of effect size plots. Each plot corresponds to one variable in \code{variables.plot}.}
\item{plot.volcano}{a list of volcano plots. Each plot corresponds to one variable in \code{variables.plot}.}
}
\description{
The function produces the effect size plot of the differential features and volcano plot based on the output from \code{linda}.
}
\examples{

data(throat.otu.tab)
data(throat.tree)
data(throat.meta)

comm <- t(throat.otu.tab)
meta.dat <- throat.meta

# For count data
linda.obj <- linda(comm, meta.dat, formula = '~SmokingStatus+Sex', feature.dat.type = 'count', 
           prev.filter = 0.2, is.winsor = TRUE, outlier.pct = 0.03,
           p.adj.method = "BH", alpha = 0.1
   )

rownames(linda.obj$output[[1]])[which(linda.obj$output[[1]]$reject)]

linda.plot(linda.obj, c('SmokingStatusSmoker', 'Sexmale'),
           titles = c('Smoke: n v.s. y', 'Sex: female v.s. male'), alpha = 0.1, lfc.cut = 1,
           legend = TRUE, directory = NULL, width = 11, height = 8)

}

\references{
Huijuan Zhou, Kejun He, Jun Chen, and Xianyang Zhang. LinDA: Linear Models for Differential Abundance
Analysis of Microbiome Compositional Data. 
}
\author{
Huijuan Zhou,
Jun Chen,
Xianyang Zhang

}
