% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggexport.R
\name{ggexport}
\alias{ggexport}
\title{Export ggplots}
\usage{
ggexport(
  ...,
  plotlist = NULL,
  filename = NULL,
  ncol = NULL,
  nrow = NULL,
  width = 480,
  height = 480,
  pointsize = 12,
  res = NA,
  verbose = TRUE
)
}
\arguments{
\item{...}{list of plots to be arranged into the grid. The plots can be either
ggplot2 plot objects, arbitrary gtables or an object of class
\code{\link{ggarrange}}.}

\item{plotlist}{(optional) list of plots to display.}

\item{filename}{File name to create on disk.}

\item{ncol}{(optional) number of columns in the plot grid.}

\item{nrow}{(optional) number of rows in the plot grid.}

\item{width, height}{plot width and height, respectively (example, width = 800,
height = 800). Applied only to raster plots: "png", "jpeg", "jpg", "bmp" and
"tiff".}

\item{pointsize}{the default pointsize of plotted text (example, pointsize =
8). Used only for raster plots.}

\item{res}{the resolution in ppi (example, res = 250). Used only for raster
plots.}

\item{verbose}{logical. If TRUE, show message.}
}
\description{
Export ggplots
}
\examples{
\dontrun{
require("magrittr")
# Load data
data("ToothGrowth")
df <- ToothGrowth
df$dose <- as.factor(df$dose)

# Box plot
bxp <- ggboxplot(df, x = "dose", y = "len",
    color = "dose", palette = "jco")
# Dot plot
dp <- ggdotplot(df, x = "dose", y = "len",
    color = "dose", palette = "jco")
# Density plot
dens <- ggdensity(df, x = "len", fill = "dose", palette = "jco")

# Export to pdf
ggarrange(bxp, dp, dens, ncol = 2) \%>\%
  ggexport(filename = "test.pdf")

# Export to png
ggarrange(bxp, dp, dens, ncol = 2) \%>\%
  ggexport(filename = "test.png")
 }

}
\author{
Alboukadel Kassambara <alboukadel.kassambara@gmail.com>
}
