% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eigen_centrality.R
\name{get_eigen_centrality}
\alias{get_eigen_centrality}
\title{Get the eigen centrality for all nodes}
\usage{
get_eigen_centrality(graph, weights_attr = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{weights_attr}{An optional name of the edge attribute to use in the
adjacency matrix. If \code{NULL} then, if it exists, the \code{weight} edge attribute
of the graph will be used. If \code{NA} then no edge weights will be used.}
}
\value{
A data frame with eigen centrality scores for each of the nodes.
}
\description{
Get the eigen centrality values for all nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10, m = 15,
    set_seed = 23)

# Get the eigen centrality scores
# for nodes in the graph
graph \%>\% get_eigen_centrality()

}
