% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ok.R
\name{ok}
\alias{ok}
\title{check if a url is okay}
\usage{
ok(x, status = 200L, info = TRUE, ...)
}
\arguments{
\item{x}{either a URL as a character string, or an object of
class \link{HttpClient}}

\item{status}{(integer) an HTTP status code, must be an integer.
By default this is 200L, since this is the most common signal
that a URL is okay, but there may be cases in which your URL
is okay if it's a 201L, or some other status code.}

\item{info}{(logical) in the case of an error, do you want a
\code{message()} about it? Default: \code{TRUE}}

\item{...}{args passed on to \link{HttpClient}}
}
\value{
a single boolean, if \code{TRUE} the URL is up and okay,
if \code{FALSE} it is down.
}
\description{
check if a url is okay
}
\details{
We internally verify that status is an integer and
in the known set of HTTP status codes, and that info is a boolean
}
\examples{
\dontrun{
# 200
ok("https://google.com") 
# 200
ok("https://httpbin.org/status/200")
# 404
ok("https://httpbin.org/status/404")
# doesn't exist
ok("https://stuff.bar")
# doesn't exist
ok("stuff")

# with HttpClient
z <- crul::HttpClient$new("https://httpbin.org/status/404", 
 opts = list(verbose = TRUE))
ok(z)
}
}
