% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-length.R
\name{chk_length}
\alias{chk_length}
\alias{vld_length}
\title{Check Length}
\usage{
chk_length(x, length = 1L, upper = length, x_name = NULL)

vld_length(x, length = 1L, upper = length)
}
\arguments{
\item{x}{The object to check.}

\item{length}{A count of the length.}

\item{upper}{A count of the max length.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks length is a particular value or range using

\code{length(x) >= length && length(x) <= upper}
}
\section{Functions}{
\itemize{
\item \code{vld_length()}: Validate Length

}}
\examples{
# chk_length
chk_length("text")
try(vld_length("text", length = 2))
# vld_length
vld_length(2:1, 2)
vld_length(2:1, 1)
}
\seealso{
\code{\link[=length]{length()}}, \code{\link[=check_length]{check_length()}}, \code{\link[=check_dim]{check_dim()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other length_checkers: 
\code{\link{chk_compatible_lengths}()}
}
\concept{length_checkers}
