% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{is.booltype}
\alias{is.booltype}
\alias{is.bit}
\alias{is.bitwhich}
\alias{is.which}
\alias{is.hi}
\alias{is.ri}
\title{Testing for boolean types}
\usage{
is.booltype(x)

is.bit(x)

is.bitwhich(x)

is.which(x)

is.hi(x)

is.ri(x)
}
\arguments{
\item{x}{an R object}
}
\value{
logical scalar
}
\description{
All \code{\link{booltypes}} including  \code{\link{logical}} except 'nobool' types are considered 'is.booltype'.
}
\section{Functions}{
\itemize{
\item \code{is.bit}: tests for \code{\link{bit}}

\item \code{is.bitwhich}: tests for \code{\link{bitwhich}}

\item \code{is.which}: tests for \code{\link[=as.which]{which}}

\item \code{is.hi}: tests for \code{\link[ff]{hi}}

\item \code{is.ri}: tests for \code{\link{ri}}
}}

\examples{
sapply(list(double(),integer(),logical(),bit(),bitwhich(),as.which(),ri(1,2,3)), is.booltype)
}
\seealso{
\code{\link{booltypes}}, \code{\link{booltype}}, \code{\link{as.booltype}}
}
