% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set_methods.R
\name{samples_metadata}
\alias{samples_metadata}
\alias{samples_metadata<-}
\alias{samples_metadata,MOFA-method}
\alias{samples_metadata<-,MOFA,data.frame-method}
\title{samples_metadata: retrieve sample metadata}
\usage{
samples_metadata(object)

samples_metadata(object) <- value

\S4method{samples_metadata}{MOFA}(object)

\S4method{samples_metadata}{MOFA,data.frame}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{value}{data frame with sample metadata, it must at least contain the columns \code{sample} and \code{group}.
The order of the rows must match the order of \code{samples_names(object)}}
}
\value{
a data frame with sample metadata
}
\description{
samples_metadata: retrieve sample metadata
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
samples_metadata(model)
}
